/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.optifine.Config;

public class ModelUtils {
    private static final Random RANDOM = new Random(0L);

    public static void dbgModel(dyp model) {
        if (model == null) {
            return;
        }
        Config.dbg("Model: " + model + ", ao: " + model.a() + ", gui3d: " + model.b() + ", builtIn: " + model.c() + ", particle: " + model.d());
        fb[] faces = fb.n;
        for (int i = 0; i < faces.length; ++i) {
            fb face = faces[i];
            List faceQuads = model.a(null, face, RANDOM);
            ModelUtils.dbgQuads(face.m(), faceQuads, "  ");
        }
        List generalQuads = model.a(null, null, RANDOM);
        ModelUtils.dbgQuads("General", generalQuads, "  ");
    }

    private static void dbgQuads(String name, List quads, String prefix) {
        for (dnz quad : quads) {
            ModelUtils.dbgQuad(name, quad, prefix);
        }
    }

    public static void dbgQuad(String name, dnz quad, String prefix) {
        Config.dbg(prefix + "Quad: " + quad.getClass().getName() + ", type: " + name + ", face: " + quad.e() + ", tint: " + quad.d() + ", sprite: " + quad.a());
        ModelUtils.dbgVertexData(quad.b(), "  " + prefix);
    }

    public static void dbgVertexData(int[] vd, String prefix) {
        int step = vd.length / 4;
        Config.dbg(prefix + "Length: " + vd.length + ", step: " + step);
        for (int i = 0; i < 4; ++i) {
            int pos = i * step;
            float x = Float.intBitsToFloat(vd[pos + 0]);
            float y = Float.intBitsToFloat(vd[pos + 1]);
            float z = Float.intBitsToFloat(vd[pos + 2]);
            int col = vd[pos + 3];
            float u = Float.intBitsToFloat(vd[pos + 4]);
            float v = Float.intBitsToFloat(vd[pos + 5]);
            Config.dbg(prefix + i + " xyz: " + x + "," + y + "," + z + " col: " + col + " u,v: " + u + "," + v);
        }
    }

    public static dyp duplicateModel(dyp model) {
        List generalQuads2 = ModelUtils.duplicateQuadList(model.a(null, null, RANDOM));
        fb[] faces = fb.n;
        HashMap<fb, List> faceQuads2 = new HashMap<fb, List>();
        for (int i = 0; i < faces.length; ++i) {
            fb face = faces[i];
            List quads = model.a(null, face, RANDOM);
            List quads2 = ModelUtils.duplicateQuadList(quads);
            faceQuads2.put(face, quads2);
        }
        dyx model2 = new dyx(generalQuads2, faceQuads2, model.a(), model.b(), model.d(), model.e(), model.f());
        return model2;
    }

    public static List duplicateQuadList(List list) {
        ArrayList<dnz> list2 = new ArrayList<dnz>();
        for (dnz quad : list) {
            dnz quad2 = ModelUtils.duplicateQuad(quad);
            list2.add(quad2);
        }
        return list2;
    }

    public static dnz duplicateQuad(dnz quad) {
        dnz quad2 = new dnz((int[])quad.b().clone(), quad.d(), quad.e(), quad.a());
        return quad2;
    }
}

