/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.optifine.BetterGrass;
import net.optifine.BetterSnow;
import net.optifine.Config;
import net.optifine.ConnectedTextures;
import net.optifine.CustomBlockLayers;
import net.optifine.CustomColors;
import net.optifine.CustomGuis;
import net.optifine.CustomItems;
import net.optifine.CustomLoadingScreens;
import net.optifine.CustomPanorama;
import net.optifine.CustomSky;
import net.optifine.EmissiveTextures;
import net.optifine.Lang;
import net.optifine.NaturalTextures;
import net.optifine.RandomEntities;
import net.optifine.SmartLeaves;
import net.optifine.TextureAnimations;
import net.optifine.entity.model.CustomEntityModels;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.MultiTexID;
import net.optifine.shaders.Shaders;
import net.optifine.util.StrUtils;
import net.optifine.util.TickableTexture;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    private static final String texGrassTop = "grass_block_top";
    private static final String texGrassSide = "grass_block_side";
    private static final String texGrassSideOverlay = "grass_block_side_overlay";
    private static final String texSnow = "snow";
    private static final String texGrassSideSnowed = "grass_block_snow";
    private static final String texMyceliumSide = "mycelium_side";
    private static final String texMyceliumTop = "mycelium_top";
    private static final String texWaterStill = "water_still";
    private static final String texWaterFlow = "water_flow";
    private static final String texLavaStill = "lava_still";
    private static final String texLavaFlow = "lava_flow";
    private static final String texFireLayer0 = "fire_0";
    private static final String texFireLayer1 = "fire_1";
    private static final String texSoulFireLayer0 = "soul_fire_0";
    private static final String texSoulFireLayer1 = "soul_fire_1";
    private static final String texCampFire = "campfire_fire";
    private static final String texCampFireLogLit = "campfire_log_lit";
    private static final String texSoulCampFire = "soul_campfire_fire";
    private static final String texSoulCampFireLogLit = "soul_campfire_log_lit";
    private static final String texPortal = "nether_portal";
    private static final String texGlass = "glass";
    private static final String texGlassPaneTop = "glass_pane_top";
    public static exm iconGrassTop;
    public static exm iconGrassSide;
    public static exm iconGrassSideOverlay;
    public static exm iconSnow;
    public static exm iconGrassSideSnowed;
    public static exm iconMyceliumSide;
    public static exm iconMyceliumTop;
    public static exm iconWaterStill;
    public static exm iconWaterFlow;
    public static exm iconLavaStill;
    public static exm iconLavaFlow;
    public static exm iconFireLayer0;
    public static exm iconFireLayer1;
    public static exm iconSoulFireLayer0;
    public static exm iconSoulFireLayer1;
    public static exm iconCampFire;
    public static exm iconCampFireLogLit;
    public static exm iconSoulCampFire;
    public static exm iconSoulCampFireLogLit;
    public static exm iconPortal;
    public static exm iconGlass;
    public static exm iconGlassPaneTop;
    public static final String SPRITE_PREFIX_BLOCKS = "minecraft:block/";
    public static final String SPRITE_PREFIX_ITEMS = "minecraft:item/";
    public static final ww LOCATION_SPRITE_EMPTY;
    public static final ww LOCATION_TEXTURE_EMPTY;
    public static final ww WHITE_TEXTURE_LOCATION;
    private static IntBuffer staticBuffer;
    private static int glMaximumTextureSize;
    private static Map<Integer, String> mapTextureAllocations;

    public static void update() {
        exl mapBlocks = TextureUtils.getTextureMapBlocks();
        if (mapBlocks == null) {
            return;
        }
        String prefix = SPRITE_PREFIX_BLOCKS;
        iconGrassTop = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGrassTop);
        iconGrassSide = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGrassSide);
        iconGrassSideOverlay = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGrassSideOverlay);
        iconSnow = TextureUtils.getSpriteCheck(mapBlocks, prefix + texSnow);
        iconGrassSideSnowed = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGrassSideSnowed);
        iconMyceliumSide = TextureUtils.getSpriteCheck(mapBlocks, prefix + texMyceliumSide);
        iconMyceliumTop = TextureUtils.getSpriteCheck(mapBlocks, prefix + texMyceliumTop);
        iconWaterStill = TextureUtils.getSpriteCheck(mapBlocks, prefix + texWaterStill);
        iconWaterFlow = TextureUtils.getSpriteCheck(mapBlocks, prefix + texWaterFlow);
        iconLavaStill = TextureUtils.getSpriteCheck(mapBlocks, prefix + texLavaStill);
        iconLavaFlow = TextureUtils.getSpriteCheck(mapBlocks, prefix + texLavaFlow);
        iconFireLayer0 = TextureUtils.getSpriteCheck(mapBlocks, prefix + texFireLayer0);
        iconFireLayer1 = TextureUtils.getSpriteCheck(mapBlocks, prefix + texFireLayer1);
        iconSoulFireLayer0 = TextureUtils.getSpriteCheck(mapBlocks, prefix + texSoulFireLayer0);
        iconSoulFireLayer1 = TextureUtils.getSpriteCheck(mapBlocks, prefix + texSoulFireLayer1);
        iconCampFire = TextureUtils.getSpriteCheck(mapBlocks, prefix + texCampFire);
        iconCampFireLogLit = TextureUtils.getSpriteCheck(mapBlocks, prefix + texCampFireLogLit);
        iconSoulCampFire = TextureUtils.getSpriteCheck(mapBlocks, prefix + texSoulCampFire);
        iconSoulCampFireLogLit = TextureUtils.getSpriteCheck(mapBlocks, prefix + texSoulCampFireLogLit);
        iconPortal = TextureUtils.getSpriteCheck(mapBlocks, prefix + texPortal);
        iconGlass = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGlass);
        iconGlassPaneTop = TextureUtils.getSpriteCheck(mapBlocks, prefix + texGlassPaneTop);
        String prefixItems = SPRITE_PREFIX_ITEMS;
    }

    public static exm getSpriteCheck(exl textureMap, String name) {
        exm sprite = textureMap.getUploadedSprite(name);
        if (sprite == null || sprite instanceof exf) {
            Config.warn("Sprite not found: " + name);
        }
        return sprite;
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi.getWidth()) == (height = bi.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr = scaledImage.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr.drawImage(bi, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi;
    }

    public static int ceilPowerOfTwo(int val) {
        int i2;
        for (i2 = 1; i2 < val; i2 *= 2) {
        }
        return i2;
    }

    public static int getPowerOfTwo(int val) {
        int i2 = 1;
        int po2 = 0;
        while (i2 < val) {
            i2 *= 2;
            ++po2;
        }
        return po2;
    }

    public static int twoToPower(int power) {
        int val = 1;
        for (int i2 = 0; i2 < power; ++i2) {
            val *= 2;
        }
        return val;
    }

    public static exa getTexture(ww loc) {
        exa tex = Config.getTextureManager().b(loc);
        if (tex != null) {
            return tex;
        }
        if (!Config.hasResource(loc)) {
            return null;
        }
        tex = new exi(loc);
        Config.getTextureManager().a(loc, tex);
        return tex;
    }

    public static void resourcesReloaded(adt rm) {
        if (TextureUtils.getTextureMapBlocks() == null) {
            return;
        }
        Config.dbg("*** Reloading custom textures ***");
        CustomSky.reset();
        TextureAnimations.reset();
        TextureUtils.update();
        NaturalTextures.update();
        BetterGrass.update();
        BetterSnow.update();
        TextureAnimations.update();
        CustomColors.update();
        CustomSky.update();
        RandomEntities.update();
        CustomItems.updateModels();
        CustomEntityModels.update();
        Shaders.resourcesReloaded();
        Lang.resourcesReloaded();
        Config.updateTexturePackClouds();
        SmartLeaves.updateLeavesModels();
        CustomPanorama.update();
        CustomGuis.update();
        evx.update();
        CustomLoadingScreens.update();
        CustomBlockLayers.update();
        Config.getTextureManager().e();
        Config.dbg("Disable Forge light pipeline");
        ReflectorForge.setForgeLightPipelineEnabled(false);
    }

    public static exl getTextureMapBlocks() {
        return Config.getTextureMap();
    }

    public static void registerResourceListener() {
        adt rm = Config.getResourceManager();
        if (rm instanceof adr) {
            adr rrm = (adr)rm;
            adx rl = new adx(){

                protected Object b(adt p_212854_1_, apv p_212854_2_) {
                    return null;
                }

                protected void a(Object p_212853_1_, adt p_212853_2_, apv p_212853_3_) {
                }
            };
            rrm.a((ado)rl);
            adu rmrl = new adu(){

                public void a(adt resourceManager) {
                    TextureUtils.resourcesReloaded(resourceManager);
                }
            };
            rrm.a((ado)rmrl);
        }
    }

    public static void registerTickableTextures() {
        TickableTexture tt = new TickableTexture(){

            public void e() {
                TextureAnimations.updateAnimations();
            }

            public void a(adt var1) throws IOException {
            }

            public int b() {
                return 0;
            }

            public void restoreLastBlurMipmap() {
            }

            public MultiTexID getMultiTexID() {
                return null;
            }
        };
        ww ttl = new ww("optifine/tickable_textures");
        Config.getTextureManager().a(ttl, (exa)tt);
    }

    public static void registerCustomModels(ezc modelBakery) {
        CustomItems.update();
        CustomItems.loadModels(modelBakery);
    }

    public static void registerCustomSprites(exl textureMap) {
        if (textureMap.g().equals((Object)exl.e)) {
            ConnectedTextures.updateIcons(textureMap);
            CustomItems.updateIcons(textureMap);
            BetterGrass.updateIcons(textureMap);
        }
    }

    public static void refreshCustomSprites(exl textureMap) {
        if (textureMap.g().equals((Object)exl.e)) {
            ConnectedTextures.refreshIcons(textureMap);
            CustomItems.refreshIcons(textureMap);
            BetterGrass.refreshIcons(textureMap);
        }
        EmissiveTextures.refreshIcons(textureMap);
    }

    public static ww fixResourceLocation(ww loc, String basePath) {
        if (!loc.b().equals("minecraft")) {
            return loc;
        }
        String path = loc.a();
        String pathFixed = TextureUtils.fixResourcePath(path, basePath);
        if (pathFixed != path) {
            loc = new ww(loc.b(), pathFixed);
        }
        return loc;
    }

    public static String fixResourcePath(String path, String basePath) {
        String strAssMc = "assets/minecraft/";
        if (path.startsWith(strAssMc)) {
            path = path.substring(strAssMc.length());
            return path;
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            path = basePath + path;
            return path;
        }
        if (path.startsWith("/~")) {
            path = path.substring(1);
        }
        String strOptifine = "optifine/";
        if (path.startsWith("~/")) {
            path = path.substring(2);
            path = strOptifine + path;
            return path;
        }
        if (path.startsWith("/")) {
            path = strOptifine + path.substring(1);
            return path;
        }
        return path;
    }

    public static String getBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    public static void applyAnisotropicLevel() {
        if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float maxLevel = GL11.glGetFloat((int)34047);
            float level = Config.getAnisotropicFilterLevel();
            level = Math.min(level, maxLevel);
            GL11.glTexParameterf((int)3553, (int)34046, (float)level);
        }
    }

    public static void bindTexture(int glTexId) {
        GlStateManager._bindTexture((int)glTexId);
    }

    public static boolean isPowerOfTwo(int x) {
        int x2 = ahb.c((int)x);
        return x2 == x;
    }

    public static dpm scaleImage(dpm ni2, int w2) {
        BufferedImage bi = TextureUtils.toBufferedImage(ni2);
        BufferedImage bi2 = TextureUtils.scaleImage(bi, w2);
        dpm ni22 = TextureUtils.toNativeImage(bi2);
        return ni22;
    }

    public static BufferedImage toBufferedImage(dpm ni2) {
        int width = ni2.a();
        int height = ni2.b();
        int[] data = new int[width * height];
        ni2.getBufferRGBA().get(data);
        BufferedImage bi = new BufferedImage(width, height, 2);
        bi.setRGB(0, 0, width, height, data, 0, width);
        return bi;
    }

    private static dpm toNativeImage(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int[] data = new int[width * height];
        bi.getRGB(0, 0, width, height, data, 0, width);
        dpm ni2 = new dpm(width, height, false);
        ni2.getBufferRGBA().put(data);
        return ni2;
    }

    public static BufferedImage scaleImage(BufferedImage bi, int w2) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        int h2 = h * w2 / w;
        BufferedImage bi2 = new BufferedImage(w2, h2, 2);
        Graphics2D g2 = bi2.createGraphics();
        Object method = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        if (w2 < w || w2 % w != 0) {
            method = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, method);
        g2.drawImage(bi, 0, 0, w2, h2, null);
        return bi2;
    }

    public static int scaleToGrid(int size, int sizeGrid) {
        int sizeNew;
        if (size == sizeGrid) {
            return size;
        }
        for (sizeNew = size / sizeGrid * sizeGrid; sizeNew < size; sizeNew += sizeGrid) {
        }
        return sizeNew;
    }

    public static int scaleToMin(int size, int sizeMin) {
        int sizeNew;
        if (size >= sizeMin) {
            return size;
        }
        for (sizeNew = sizeMin / size * size; sizeNew < sizeMin; sizeNew += size) {
        }
        return sizeNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dimension getImageSize(InputStream in, String suffix) {
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(suffix);
        while (iter.hasNext()) {
            ImageReader reader = iter.next();
            try {
                ImageInputStream iis = ImageIO.createImageInputStream(in);
                reader.setInput(iis);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                Dimension dimension = new Dimension(width, height);
                return dimension;
            }
            catch (IOException e2) {}
            continue;
            finally {
                reader.dispose();
            }
        }
        return null;
    }

    public static void dbgMipmaps(exm textureatlassprite) {
        dpm[] mipmapImages = textureatlassprite.getMipmapImages();
        for (int l2 = 0; l2 < mipmapImages.length; ++l2) {
            dpm image = mipmapImages[l2];
            if (image == null) {
                Config.dbg("" + l2 + ": " + image);
                continue;
            }
            Config.dbg("" + l2 + ": " + image.a() * image.b());
        }
    }

    public static void saveGlTexture(String name, int textureId, int mipmapLevels, int width, int height) {
        TextureUtils.bindTexture(textureId);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        name = StrUtils.removeSuffix(name, ".png");
        File fileBase = new File(name);
        File dir = fileBase.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            String namePng = name + "_" + i2 + ".png";
            File filePng = new File(namePng);
            filePng.delete();
        }
        for (int level = 0; level <= mipmapLevels; ++level) {
            File filePng = new File(name + "_" + level + ".png");
            int widthLevel = width >> level;
            int heightLevel = height >> level;
            int sizeLevel = widthLevel * heightLevel;
            IntBuffer buf = BufferUtils.createIntBuffer((int)sizeLevel);
            int[] data = new int[sizeLevel];
            GL11.glGetTexImage((int)3553, (int)level, (int)32993, (int)33639, (IntBuffer)buf);
            buf.get(data);
            BufferedImage image = new BufferedImage(widthLevel, heightLevel, 2);
            image.setRGB(0, 0, widthLevel, heightLevel, data, 0, widthLevel);
            try {
                ImageIO.write((RenderedImage)image, "png", filePng);
                Config.dbg("Exported: " + filePng);
                continue;
            }
            catch (Exception e2) {
                Config.warn("Error writing: " + filePng);
                Config.warn("" + e2.getClass().getName() + ": " + e2.getMessage());
            }
        }
    }

    public static int getGLMaximumTextureSize() {
        if (glMaximumTextureSize < 0) {
            glMaximumTextureSize = TextureUtils.detectGLMaximumTextureSize();
        }
        return glMaximumTextureSize;
    }

    private static int detectGLMaximumTextureSize() {
        for (int i2 = 65536; i2 > 0; i2 >>= 1) {
            GlStateManager._texImage2D((int)32868, (int)0, (int)6408, (int)i2, (int)i2, (int)0, (int)6408, (int)5121, (IntBuffer)null);
            int err2 = GL11.glGetError();
            int width = GlStateManager._getTexLevelParameter((int)32868, (int)0, (int)4096);
            if (width == 0) continue;
            return i2;
        }
        return 0;
    }

    public static BufferedImage readBufferedImage(InputStream imageStream) throws IOException {
        if (imageStream == null) {
            return null;
        }
        try {
            BufferedImage bufferedimage;
            BufferedImage bufferedImage = bufferedimage = ImageIO.read(imageStream);
            return bufferedImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)imageStream);
        }
    }

    public static int toAbgr(int argb) {
        int a2 = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g2 = argb >> 8 & 0xFF;
        int b2 = argb >> 0 & 0xFF;
        int abgr = a2 << 24 | b2 << 16 | g2 << 8 | r;
        return abgr;
    }

    public static void resetDataUnpacking() {
        GlStateManager._pixelStore((int)3314, (int)0);
        GlStateManager._pixelStore((int)3316, (int)0);
        GlStateManager._pixelStore((int)3315, (int)0);
        GlStateManager._pixelStore((int)3317, (int)4);
    }

    public static String getStackTrace(Throwable t) {
        CharArrayWriter caw = new CharArrayWriter();
        t.printStackTrace(new PrintWriter(caw));
        return caw.toString();
    }

    public static void debugTextureGenerated(int id) {
        mapTextureAllocations.put(id, TextureUtils.getStackTrace(new Throwable("StackTrace")));
        Config.dbg("Textures: " + mapTextureAllocations.size());
    }

    public static void debugTextureDeleted(int id) {
        mapTextureAllocations.remove(id);
        Config.dbg("Textures: " + mapTextureAllocations.size());
    }

    static {
        LOCATION_SPRITE_EMPTY = new ww("optifine/ctm/default/empty");
        LOCATION_TEXTURE_EMPTY = new ww("optifine/ctm/default/empty.png");
        WHITE_TEXTURE_LOCATION = new ww("textures/misc/white.png");
        staticBuffer = Config.createDirectIntBuffer(256);
        glMaximumTextureSize = -1;
        mapTextureAllocations = new HashMap<Integer, String>();
    }
}

