/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class DefaultShaders {
    public static InputStream getResourceAsStream(String filename) {
        if (filename.equals("/shaders/final.vsh")) {
            return DefaultShaders.getFinalVsh();
        }
        if (filename.equals("/shaders/final.fsh")) {
            return DefaultShaders.getFinalFsh();
        }
        return null;
    }

    private static InputStream getFinalVsh() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("#version 120");
        lines.add("varying vec2 texcoord;");
        lines.add("void main()");
        lines.add("{");
        lines.add("  gl_Position  = ftransform();");
        lines.add("  texcoord = gl_MultiTexCoord0.st;");
        lines.add("}");
        String str = lines.stream().collect(Collectors.joining("\n"));
        return DefaultShaders.getInputStream(str);
    }

    private static InputStream getFinalFsh() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("#version 120");
        lines.add("uniform sampler2D colortex0;");
        lines.add("/* DRAWBUFFERS:0 */");
        lines.add("varying vec2 texcoord;");
        lines.add("void main()");
        lines.add("{");
        lines.add("  gl_FragData[0] = texture2D(colortex0, texcoord);");
        lines.add("}");
        String str = lines.stream().collect(Collectors.joining("\n"));
        return DefaultShaders.getInputStream(str);
    }

    private static InputStream getInputStream(String str) {
        byte[] bytes = str.getBytes(Charsets.US_ASCII);
        return new ByteArrayInputStream(bytes);
    }
}

