/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import net.optifine.Config;
import net.optifine.model.BlockModelUtils;
import net.optifine.util.PropertiesOrdered;

public class BetterGrass {
    private static boolean betterGrass = true;
    private static boolean betterGrassPath = true;
    private static boolean betterMycelium = true;
    private static boolean betterPodzol = true;
    private static boolean betterGrassSnow = true;
    private static boolean betterMyceliumSnow = true;
    private static boolean betterPodzolSnow = true;
    private static boolean grassMultilayer = false;
    private static exm spriteGrass = null;
    private static exm spriteGrassSide = null;
    private static exm spriteGrassPath = null;
    private static exm spriteGrassPathSide = null;
    private static exm spriteMycelium = null;
    private static exm spritePodzol = null;
    private static exm spriteSnow = null;
    private static boolean spritesLoaded = false;
    private static eyy modelCubeGrass = null;
    private static eyy modelGrassPath = null;
    private static eyy modelCubeGrassPath = null;
    private static eyy modelCubeMycelium = null;
    private static eyy modelCubePodzol = null;
    private static eyy modelCubeSnow = null;
    private static boolean modelsLoaded = false;
    private static final String TEXTURE_GRASS_DEFAULT = "block/grass_block_top";
    private static final String TEXTURE_GRASS_SIDE_DEFAULT = "block/grass_block_side";
    private static final String TEXTURE_GRASS_PATH_DEFAULT = "block/dirt_path_top";
    private static final String TEXTURE_GRASS_PATH_SIDE_DEFAULT = "block/dirt_path_side";
    private static final String TEXTURE_MYCELIUM_DEFAULT = "block/mycelium_top";
    private static final String TEXTURE_PODZOL_DEFAULT = "block/podzol_top";
    private static final String TEXTURE_SNOW_DEFAULT = "block/snow";
    private static final Random RANDOM = new Random(0L);

    public static void updateIcons(exl textureMap) {
        spritesLoaded = false;
        modelsLoaded = false;
        BetterGrass.loadProperties(textureMap);
    }

    public static void update() {
        if (!spritesLoaded) {
            return;
        }
        modelCubeGrass = BlockModelUtils.makeModelCube(spriteGrass, 0);
        if (grassMultilayer) {
            eyy modelCubeGrassSide = BlockModelUtils.makeModelCube(spriteGrassSide, -1);
            modelCubeGrass = BlockModelUtils.joinModelsCube(modelCubeGrassSide, modelCubeGrass);
        }
        modelGrassPath = BlockModelUtils.makeModel("dirt_path", spriteGrassPathSide, spriteGrassPath);
        modelCubeGrassPath = BlockModelUtils.makeModelCube(spriteGrassPath, -1);
        modelCubeMycelium = BlockModelUtils.makeModelCube(spriteMycelium, -1);
        modelCubePodzol = BlockModelUtils.makeModelCube(spritePodzol, 0);
        modelCubeSnow = BlockModelUtils.makeModelCube(spriteSnow, -1);
        modelsLoaded = true;
    }

    private static void loadProperties(exl textureMap) {
        betterGrass = true;
        betterGrassPath = true;
        betterMycelium = true;
        betterPodzol = true;
        betterGrassSnow = true;
        betterMyceliumSnow = true;
        betterPodzolSnow = true;
        spriteGrass = textureMap.registerSprite(new ww(TEXTURE_GRASS_DEFAULT));
        spriteGrassSide = textureMap.registerSprite(new ww(TEXTURE_GRASS_SIDE_DEFAULT));
        spriteGrassPath = textureMap.registerSprite(new ww(TEXTURE_GRASS_PATH_DEFAULT));
        spriteGrassPathSide = textureMap.registerSprite(new ww(TEXTURE_GRASS_PATH_SIDE_DEFAULT));
        spriteMycelium = textureMap.registerSprite(new ww(TEXTURE_MYCELIUM_DEFAULT));
        spritePodzol = textureMap.registerSprite(new ww(TEXTURE_PODZOL_DEFAULT));
        spriteSnow = textureMap.registerSprite(new ww(TEXTURE_SNOW_DEFAULT));
        spritesLoaded = true;
        String name = "optifine/bettergrass.properties";
        try {
            ww locFile = new ww(name);
            if (!Config.hasResource(locFile)) {
                return;
            }
            InputStream in = Config.getResourceStream(locFile);
            if (in == null) {
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack(locFile);
            if (defaultConfig) {
                Config.dbg("BetterGrass: Parsing default configuration " + name);
            } else {
                Config.dbg("BetterGrass: Parsing configuration " + name);
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            betterGrass = BetterGrass.getBoolean(props, "grass", true);
            betterGrassPath = BetterGrass.getBoolean(props, "grass_path", true);
            betterMycelium = BetterGrass.getBoolean(props, "mycelium", true);
            betterPodzol = BetterGrass.getBoolean(props, "podzol", true);
            betterGrassSnow = BetterGrass.getBoolean(props, "grass.snow", true);
            betterMyceliumSnow = BetterGrass.getBoolean(props, "mycelium.snow", true);
            betterPodzolSnow = BetterGrass.getBoolean(props, "podzol.snow", true);
            grassMultilayer = BetterGrass.getBoolean(props, "grass.multilayer", false);
            spriteGrass = BetterGrass.registerSprite(props, "texture.grass", TEXTURE_GRASS_DEFAULT, textureMap);
            spriteGrassSide = BetterGrass.registerSprite(props, "texture.grass_side", TEXTURE_GRASS_SIDE_DEFAULT, textureMap);
            spriteGrassPath = BetterGrass.registerSprite(props, "texture.grass_path", TEXTURE_GRASS_PATH_DEFAULT, textureMap);
            spriteGrassPathSide = BetterGrass.registerSprite(props, "texture.grass_path_side", TEXTURE_GRASS_PATH_SIDE_DEFAULT, textureMap);
            spriteMycelium = BetterGrass.registerSprite(props, "texture.mycelium", TEXTURE_MYCELIUM_DEFAULT, textureMap);
            spritePodzol = BetterGrass.registerSprite(props, "texture.podzol", TEXTURE_PODZOL_DEFAULT, textureMap);
            spriteSnow = BetterGrass.registerSprite(props, "texture.snow", TEXTURE_SNOW_DEFAULT, textureMap);
        }
        catch (IOException e2) {
            Config.warn("Error reading: " + name + ", " + e2.getClass().getName() + ": " + e2.getMessage());
        }
    }

    public static void refreshIcons(exl textureMap) {
        spriteGrass = BetterGrass.getSprite(textureMap, spriteGrass.l());
        spriteGrassSide = BetterGrass.getSprite(textureMap, spriteGrassSide.l());
        spriteGrassPath = BetterGrass.getSprite(textureMap, spriteGrassPath.l());
        spriteGrassPathSide = BetterGrass.getSprite(textureMap, spriteGrassPathSide.l());
        spriteMycelium = BetterGrass.getSprite(textureMap, spriteMycelium.l());
        spritePodzol = BetterGrass.getSprite(textureMap, spritePodzol.l());
        spriteSnow = BetterGrass.getSprite(textureMap, spriteSnow.l());
    }

    private static exm getSprite(exl textureMap, ww loc) {
        exm sprite = textureMap.a(loc);
        if (sprite == null || sprite instanceof exf) {
            Config.warn("Missing BetterGrass sprite: " + loc);
        }
        return sprite;
    }

    private static exm registerSprite(Properties props, String key, String textureDefault, exl textureMap) {
        ww locPng;
        String texture = props.getProperty(key);
        if (texture == null) {
            texture = textureDefault;
        }
        if (!Config.hasResource(locPng = new ww("textures/" + texture + ".png"))) {
            Config.warn("BetterGrass texture not found: " + locPng);
            texture = textureDefault;
        }
        ww locSprite = new ww(texture);
        exm sprite = textureMap.registerSprite(locSprite);
        return sprite;
    }

    public static List getFaceQuads(bvu blockAccess, ckt blockState, gg blockPos, gl facing, List quads) {
        if (facing == gl.b || facing == gl.a) {
            return quads;
        }
        if (!modelsLoaded) {
            return quads;
        }
        bzp block = blockState.b();
        if (block instanceof cec) {
            return BetterGrass.getFaceQuadsMycelium(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof cbj) {
            return BetterGrass.getFaceQuadsGrassPath(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bzq.l) {
            return BetterGrass.getFaceQuadsPodzol(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block == bzq.j) {
            return BetterGrass.getFaceQuadsDirt(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof cco) {
            return BetterGrass.getFaceQuadsGrass(blockAccess, blockState, blockPos, facing, quads);
        }
        return quads;
    }

    private static List getFaceQuadsMycelium(bvu blockAccess, ckt blockState, gg blockPos, gl facing, List quads) {
        boolean snowy;
        bzp blockUp = blockAccess.a_(blockPos.b()).b();
        boolean bl = snowy = blockUp == bzq.cM || blockUp == bzq.cK;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterMyceliumSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bzq.cK) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterMycelium && BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bzq.ec) {
                return modelCubeMycelium.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterMyceliumSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterMycelium) {
            return modelCubeMycelium.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrassPath(bvu blockAccess, ckt blockState, gg blockPos, gl facing, List quads) {
        if (!betterGrassPath) {
            return quads;
        }
        if (Config.isBetterGrassFancy()) {
            if (BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bzq.iS) {
                return modelGrassPath.a(blockState, facing, RANDOM);
            }
        } else {
            return modelGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsPodzol(bvu blockAccess, ckt blockState, gg blockPos, gl facing, List quads) {
        boolean snowy;
        bzp blockTop = BetterGrass.getBlockAt(blockPos, gl.b, blockAccess);
        boolean bl = snowy = blockTop == bzq.cM || blockTop == bzq.cK;
        if (Config.isBetterGrassFancy()) {
            gg posSide;
            ckt stateSide;
            if (snowy) {
                if (betterPodzolSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bzq.cK) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterPodzol && (stateSide = blockAccess.a_(posSide = blockPos.c().a(facing))).b() == bzq.l) {
                return modelCubePodzol.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterPodzolSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterPodzol) {
            return modelCubePodzol.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsDirt(bvu blockAccess, ckt blockState, gg blockPos, gl facing, List quads) {
        bzp blockTop = BetterGrass.getBlockAt(blockPos, gl.b, blockAccess);
        if (blockTop == bzq.iS && betterGrassPath && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bzq.iS) {
            return modelCubeGrassPath.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static List getFaceQuadsGrass(bvu blockAccess, ckt blockState, gg blockPos, gl facing, List quads) {
        boolean snowy;
        bzp blockUp = blockAccess.a_(blockPos.b()).b();
        boolean bl = snowy = blockUp == bzq.cM || blockUp == bzq.cK;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterGrassSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == bzq.cK) {
                    return modelCubeSnow.a(blockState, facing, RANDOM);
                }
            } else if (betterGrass && BetterGrass.getBlockAt(blockPos.c(), facing, blockAccess) == bzq.i) {
                return modelCubeGrass.a(blockState, facing, RANDOM);
            }
        } else if (snowy) {
            if (betterGrassSnow) {
                return modelCubeSnow.a(blockState, facing, RANDOM);
            }
        } else if (betterGrass) {
            return modelCubeGrass.a(blockState, facing, RANDOM);
        }
        return quads;
    }

    private static bzp getBlockAt(gg blockPos, gl facing, bvu blockAccess) {
        gg pos = blockPos.a(facing);
        bzp block = blockAccess.a_(pos).b();
        return block;
    }

    private static boolean getBoolean(Properties props, String key, boolean def) {
        String str = props.getProperty(key);
        if (str == null) {
            return def;
        }
        return Boolean.parseBoolean(str);
    }
}

