/*
 * Decompiled with CFR 0.152.
 */
import java.util.BitSet;
import java.util.List;

public class RenderEnv {
    private ard blockAccess;
    private bec blockState;
    private dt blockPos;
    private bto gameSettings;
    private int blockId = -1;
    private int metadata = -1;
    private int breakingAnimation = -1;
    private float[] quadBounds = new float[ej.n.length * 2];
    private BitSet boundsFlags = new BitSet(3);
    private clq aoFace = new clq();
    private BlockPosM colorizerBlockPosM = null;
    private boolean[] borderFlags = null;
    private static ThreadLocal threadLocalInstance = new ThreadLocal();

    private RenderEnv(ard blockAccess, bec blockState, dt blockPos) {
        this.blockAccess = blockAccess;
        this.blockState = blockState;
        this.blockPos = blockPos;
        this.gameSettings = Config.getGameSettings();
    }

    public static RenderEnv getInstance(ard blockAccessIn, bec blockStateIn, dt blockPosIn) {
        RenderEnv re = (RenderEnv)threadLocalInstance.get();
        if (re == null) {
            re = new RenderEnv(blockAccessIn, blockStateIn, blockPosIn);
            threadLocalInstance.set(re);
            return re;
        }
        re.reset(blockAccessIn, blockStateIn, blockPosIn);
        return re;
    }

    private void reset(ard blockAccessIn, bec blockStateIn, dt blockPosIn) {
        this.blockAccess = blockAccessIn;
        this.blockState = blockStateIn;
        this.blockPos = blockPosIn;
        this.blockId = -1;
        this.metadata = -1;
        this.breakingAnimation = -1;
        this.boundsFlags.clear();
    }

    public int getBlockId() {
        if (this.blockId < 0) {
            if (this.blockState instanceof bea) {
                bea bsb = (bea)this.blockState;
                this.blockId = bsb.getBlockId();
            } else {
                this.blockId = atr.a((atr)this.blockState.c());
            }
        }
        return this.blockId;
    }

    public int getMetadata() {
        if (this.metadata < 0) {
            if (this.blockState instanceof bea) {
                bea bsb = (bea)this.blockState;
                this.metadata = bsb.getMetadata();
            } else {
                this.metadata = this.blockState.c().c(this.blockState);
            }
        }
        return this.metadata;
    }

    public float[] getQuadBounds() {
        return this.quadBounds;
    }

    public BitSet getBoundsFlags() {
        return this.boundsFlags;
    }

    public clq getAoFace() {
        return this.aoFace;
    }

    public boolean isBreakingAnimation(List listQuads) {
        if (this.breakingAnimation < 0 && listQuads.size() > 0) {
            this.breakingAnimation = listQuads.get(0) instanceof cmn ? 1 : 0;
        }
        return this.breakingAnimation == 1;
    }

    public boolean isBreakingAnimation(clt quad) {
        if (this.breakingAnimation < 0) {
            this.breakingAnimation = quad instanceof cmn ? 1 : 0;
        }
        return this.breakingAnimation == 1;
    }

    public boolean isBreakingAnimation() {
        return this.breakingAnimation == 1;
    }

    public bec getBlockState() {
        return this.blockState;
    }

    public BlockPosM getColorizerBlockPosM() {
        if (this.colorizerBlockPosM == null) {
            this.colorizerBlockPosM = new BlockPosM(0, 0, 0);
        }
        return this.colorizerBlockPosM;
    }

    public boolean[] getBorderFlags() {
        if (this.borderFlags == null) {
            this.borderFlags = new boolean[4];
        }
        return this.borderFlags;
    }
}

