/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector3f;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;

    public static cxe makeModelCube(String spriteName, int tintIndex) {
        cue sprite = Config.getMinecraft().R().a(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static cxe makeModelCube(cue sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        ej[] facings = ej.n;
        ArrayList faceQuads = new ArrayList();
        for (int i = 0; i < facings.length; ++i) {
            ej facing = facings[i];
            ArrayList<clt> quads = new ArrayList<clt>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.add(quads);
        }
        cxm bakedModel = new cxm(generalQuads, faceQuads, true, true, sprite, cmx.a);
        return bakedModel;
    }

    public static cxe joinModelsCube(cxe modelBase, cxe modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a());
        generalQuads.addAll(modelAdd.a());
        ej[] facings = ej.n;
        ArrayList faceQuads = new ArrayList();
        for (int i = 0; i < facings.length; ++i) {
            ej facing = facings[i];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(facing));
            quads.addAll(modelAdd.a(facing));
            faceQuads.add(quads);
        }
        boolean ao = modelBase.b();
        boolean builtIn = modelBase.d();
        cue sprite = modelBase.e();
        cmx transforms = modelBase.f();
        cxm bakedModel = new cxm(generalQuads, faceQuads, ao, builtIn, sprite, transforms);
        return bakedModel;
    }

    public static clt makeBakedQuad(ej facing, cue sprite, int tintIndex) {
        Vector3f posFrom = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f posTo = new Vector3f(16.0f, 16.0f, 16.0f);
        cma uv = new cma(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        clx face = new clx(facing, tintIndex, "#" + facing.l(), uv);
        cxf modelRotation = cxf.a;
        clz partRotation = null;
        boolean uvLocked = false;
        boolean shade = true;
        cmp faceBakery = new cmp();
        clt quad = faceBakery.a(posFrom, posTo, face, sprite, facing, modelRotation, partRotation, uvLocked, shade);
        return quad;
    }

    public static cxe makeModel(String modelName, String spriteOldName, String spriteNewName) {
        cua textureMap = Config.getMinecraft().R();
        cue spriteOld = textureMap.getSpriteSafe(spriteOldName);
        cue spriteNew = textureMap.getSpriteSafe(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static cxe makeModel(String modelName, cue spriteOld, cue spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        cxk modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        cxl mrl = new cxl(modelName, "normal");
        cxe model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        cxe modelNew = ModelUtils.duplicateModel(model);
        ej[] faces = ej.n;
        for (int i = 0; i < faces.length; ++i) {
            ej face = faces[i];
            List quads = modelNew.a(face);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a();
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<clt> quads, cue spriteOld, cue spriteNew) {
        ArrayList<Object> quadsNew = new ArrayList<Object>();
        for (clt quad : quads) {
            if (quad.getSprite() != spriteOld) {
                quadsNew.add(quad);
                break;
            }
            cmn quadNew = new cmn(quad, spriteNew);
            quadsNew.add(quadNew);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(Vector3f pos) {
        pos.setX(BlockModelUtils.snapVertexCoord(pos.getX()));
        pos.setY(BlockModelUtils.snapVertexCoord(pos.getY()));
        pos.setZ(BlockModelUtils.snapVertexCoord(pos.getZ()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static brt getOffsetBoundingBox(brt aabb, atw offsetType, dt pos) {
        int x = pos.n();
        int z = pos.p();
        long k = (long)(x * 3129871) ^ (long)z * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double dx = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == atw.c) {
            dy = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.c(dx, dy, dz);
    }
}

