/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.zip.ZipFile;
import optifine.OptiFineTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptiFineTransformationService
implements ITransformationService {
    private static final Logger LOGGER = LogManager.getLogger();

    public String name() {
        return "OptiFine";
    }

    public void initialize(IEnvironment environment) {
        LOGGER.info("OptiFineTransformationService.initialize: " + environment);
    }

    public void beginScanning(IEnvironment environment) {
        LOGGER.info("OptiFineTransformationService.beginScanning: " + environment);
    }

    public void onLoad(IEnvironment env, Set<String> otherServices) throws IncompatibleEnvironmentException {
        LOGGER.info("OptiFineTransformationService.onLoad: " + env);
    }

    public Map.Entry<Set<String>, Supplier<Function<String, Optional<URL>>>> additionalClassesLocator() {
        HashSet<String> key = new HashSet<String>();
        key.add("net.optifine.");
        Supplier<Function> value = () -> this::getClassUrl;
        AbstractMap.SimpleEntry<Set<String>, Supplier<Function<String, Optional<URL>>>> entry = new AbstractMap.SimpleEntry<Set<String>, Supplier<Function<String, Optional<URL>>>>(key, value);
        LOGGER.info("additionalClassesLocator: " + entry);
        return entry;
    }

    public Optional<URL> getClassUrl(String name) {
        LOGGER.info("getClassUrl: " + name);
        return null;
    }

    public List<ITransformer> transformers() {
        LOGGER.info("OptiFineTransformationService.transformers()");
        ArrayList<ITransformer> list = new ArrayList<ITransformer>();
        try {
            URL url = OptiFineTransformer.class.getProtectionDomain().getCodeSource().getLocation();
            URI uri = url.toURI();
            File file = new File(uri);
            ZipFile ofZipFile = new ZipFile(file);
            LOGGER.info("OptiFine ZIP file: " + file);
            OptiFineTransformer oft = new OptiFineTransformer(ofZipFile);
            list.add(oft);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (list.isEmpty()) {
            LOGGER.error("*** Can not find the OptiFine JAR in the classpath ***");
            LOGGER.error("*** OptiFine will not be loaded! ***");
        }
        LOGGER.info("OptiFineTransformationService.transformers(): " + list);
        return list;
    }
}

