/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import net.optifine.Config;
import net.optifine.shaders.config.ShaderOption;
import net.optifine.shaders.config.ShaderProfile;

public class ShaderUtils {
    public static ShaderOption getShaderOption(String name, ShaderOption[] opts) {
        if (opts == null) {
            return null;
        }
        for (int i = 0; i < opts.length; ++i) {
            ShaderOption so = opts[i];
            if (!so.getName().equals(name)) continue;
            return so;
        }
        return null;
    }

    public static ShaderProfile detectProfile(ShaderProfile[] profs, ShaderOption[] opts, boolean def2) {
        if (profs == null) {
            return null;
        }
        for (int i = 0; i < profs.length; ++i) {
            ShaderProfile prof = profs[i];
            if (!ShaderUtils.matchProfile(prof, opts, def2)) continue;
            return prof;
        }
        return null;
    }

    public static boolean matchProfile(ShaderProfile prof, ShaderOption[] opts, boolean def2) {
        if (prof == null) {
            return false;
        }
        if (opts == null) {
            return false;
        }
        String[] optsProf = prof.getOptions();
        for (int p2 = 0; p2 < optsProf.length; ++p2) {
            String profVal;
            String optVal;
            String opt = optsProf[p2];
            ShaderOption so = ShaderUtils.getShaderOption(opt, opts);
            if (so == null || Config.equals(optVal = def2 ? so.getValueDefault() : so.getValue(), profVal = prof.getValue(opt))) continue;
            return false;
        }
        return true;
    }
}

