/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.nio.IntBuffer;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import shadersmod.client.ClippingHelperShadow;
import shadersmod.client.Shaders;

public class ShadersRender {
    private static final kq END_PORTAL_TEXTURE = new kq("textures/entity/end_portal.png");

    public static void setFrustrumPosition(btj frustum, double x, double y, double z) {
        frustum.a(x, y, z);
    }

    public static void setupTerrain(bqk renderGlobal, sm viewEntity, double partialTicks, btj camera, int frameCount, boolean playerSpectator) {
        renderGlobal.a(viewEntity, partialTicks, camera, frameCount, playerSpectator);
    }

    public static void beginTerrainSolid() {
        if (Shaders.isRenderingWorld) {
            Shaders.fogEnabled = true;
            Shaders.useProgram(7);
        }
    }

    public static void beginTerrainCutoutMipped() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(7);
        }
    }

    public static void beginTerrainCutout() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(7);
        }
    }

    public static void endTerrain() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(3);
        }
    }

    public static void beginTranslucent() {
        if (Shaders.isRenderingWorld) {
            if (Shaders.usedDepthBuffers >= 2) {
                bqe.g((int)33995);
                Shaders.checkGLError("pre copy depth");
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Shaders.renderWidth, (int)Shaders.renderHeight);
                Shaders.checkGLError("copy depth");
                bqe.g((int)33984);
            }
            Shaders.useProgram(12);
        }
    }

    public static void endTranslucent() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(3);
        }
    }

    public static void renderHand0(bqc er, float par1, int par2) {
        if (!Shaders.isShadowPass) {
            boolean blockTranslucentMain = Shaders.isItemToRenderMainTranslucent();
            boolean blockTranslucentOff = Shaders.isItemToRenderOffTranslucent();
            if (!blockTranslucentMain || !blockTranslucentOff) {
                Shaders.readCenterDepth();
                Shaders.beginHand(false);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Shaders.setSkipRenderHands(blockTranslucentMain, blockTranslucentOff);
                er.renderHand(par1, par2, true, false, false);
                Shaders.endHand();
                Shaders.setHandsRendered(!blockTranslucentMain, !blockTranslucentOff);
                Shaders.setSkipRenderHands(false, false);
            }
        }
    }

    public static void renderHand1(bqc er, float par1, int par2) {
        if (!Shaders.isShadowPass && !Shaders.isBothHandsRendered()) {
            Shaders.readCenterDepth();
            bqe.m();
            Shaders.beginHand(true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Shaders.setSkipRenderHands(Shaders.isHandRenderedMain(), Shaders.isHandRenderedOff());
            er.renderHand(par1, par2, true, false, true);
            Shaders.endHand();
            Shaders.setHandsRendered(true, true);
            Shaders.setSkipRenderHands(false, false);
        }
    }

    public static void renderItemFP(bqg itemRenderer, float par1, boolean renderTranslucent) {
        Shaders.setRenderingFirstPersonHand(true);
        bqe.a((boolean)true);
        if (renderTranslucent) {
            bqe.c((int)519);
            GL11.glPushMatrix();
            IntBuffer drawBuffers = Shaders.activeDrawBuffers;
            Shaders.setDrawBuffers(Shaders.drawBuffersNone);
            Shaders.renderItemKeepDepthMask = true;
            itemRenderer.a(par1);
            Shaders.renderItemKeepDepthMask = false;
            Shaders.setDrawBuffers(drawBuffers);
            GL11.glPopMatrix();
        }
        bqe.c((int)515);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        itemRenderer.a(par1);
        Shaders.setRenderingFirstPersonHand(false);
    }

    public static void renderFPOverlay(bqc er, float par1, int par2) {
        if (!Shaders.isShadowPass) {
            Shaders.beginFPOverlay();
            er.renderHand(par1, par2, false, true, false);
            Shaders.endFPOverlay();
        }
    }

    public static void beginBlockDamage() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(11);
            if (Shaders.programsID[11] == Shaders.programsID[7]) {
                Shaders.setDrawBuffers(Shaders.drawBuffersColorAtt0);
                bqe.a((boolean)false);
            }
        }
    }

    public static void endBlockDamage() {
        if (Shaders.isRenderingWorld) {
            bqe.a((boolean)true);
            Shaders.useProgram(3);
        }
    }

    public static void renderShadowMap(bqc entityRenderer, int pass, float partialTicks, long finishTimeNano) {
        if (Shaders.usedShadowDepthBuffers > 0 && --Shaders.shadowPassCounter <= 0) {
            beq mc = beq.z();
            mc.B.c("shadow pass");
            bqk renderGlobal = mc.g;
            Shaders.isShadowPass = true;
            Shaders.shadowPassCounter = Shaders.shadowPassInterval;
            Shaders.preShadowPassThirdPersonView = mc.u.as;
            mc.u.as = 1;
            Shaders.checkGLError("pre shadow");
            GL11.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            mc.B.c("shadow clear");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.sfb);
            Shaders.checkGLError("shadow bind sfb");
            Shaders.useProgram(30);
            mc.B.c("shadow camera");
            entityRenderer.a(partialTicks, 2);
            Shaders.setCameraShadow(partialTicks);
            bel.a((aax)mc.h, (mc.u.as == 2 ? 1 : 0) != 0);
            Shaders.checkGLError("shadow camera");
            GL20.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers");
            GL11.glReadBuffer((int)0);
            Shaders.checkGLError("shadow readbuffer");
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)Shaders.sfbDepthTextures.get(0), (int)0);
            if (Shaders.usedShadowColorBuffers != 0) {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)Shaders.sfbColorTextures.get(0), (int)0);
            }
            Shaders.checkFramebufferStatus("shadow fb");
            GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glClear((int)(Shaders.usedShadowColorBuffers != 0 ? 16640 : 256));
            Shaders.checkGLError("shadow clear");
            mc.B.c("shadow frustum");
            btm clippingHelper = ClippingHelperShadow.getInstance();
            mc.B.c("shadow culling");
            btl frustum = new btl(clippingHelper);
            sm viewEntity = mc.aa();
            double viewPosX = viewEntity.M + (viewEntity.p - viewEntity.M) * (double)partialTicks;
            double viewPosY = viewEntity.N + (viewEntity.q - viewEntity.N) * (double)partialTicks;
            double viewPosZ = viewEntity.O + (viewEntity.r - viewEntity.O) * (double)partialTicks;
            frustum.a(viewPosX, viewPosY, viewPosZ);
            bqe.j((int)7425);
            bqe.k();
            bqe.c((int)515);
            bqe.a((boolean)true);
            bqe.a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            bqe.r();
            mc.B.c("shadow prepareterrain");
            mc.N().a(byv.g);
            mc.B.c("shadow setupterrain");
            int frameCount = 0;
            frameCount = entityRenderer.aj;
            entityRenderer.aj = frameCount + 1;
            renderGlobal.a(viewEntity, (double)partialTicks, (btj)frustum, frameCount, mc.h.y());
            mc.B.c("shadow updatechunks");
            mc.B.c("shadow terrain");
            bqe.n((int)5888);
            bqe.G();
            bqe.d();
            renderGlobal.a(aji.a, (double)partialTicks, 2, viewEntity);
            Shaders.checkGLError("shadow terrain solid");
            bqe.e();
            renderGlobal.a(aji.b, (double)partialTicks, 2, viewEntity);
            Shaders.checkGLError("shadow terrain cutoutmipped");
            mc.N().b(byv.g).b(false, false);
            renderGlobal.a(aji.c, (double)partialTicks, 2, viewEntity);
            Shaders.checkGLError("shadow terrain cutout");
            mc.N().b(byv.g).a();
            bqe.j((int)7424);
            bqe.a((int)516, (float)0.1f);
            bqe.n((int)5888);
            bqe.H();
            bqe.G();
            mc.B.c("shadow entities");
            if (Reflector.ForgeHooksClient_setRenderPass.exists()) {
                Reflector.callVoid(Reflector.ForgeHooksClient_setRenderPass, 0);
            }
            renderGlobal.a(viewEntity, (btj)frustum, partialTicks);
            Shaders.checkGLError("shadow entities");
            bqe.n((int)5888);
            bqe.H();
            bqe.a((boolean)true);
            bqe.l();
            bqe.q();
            bqe.a((int)770, (int)771, (int)1, (int)0);
            bqe.a((int)516, (float)0.1f);
            if (Shaders.usedShadowDepthBuffers >= 2) {
                bqe.g((int)33989);
                Shaders.checkGLError("pre copy shadow depth");
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Shaders.shadowMapWidth, (int)Shaders.shadowMapHeight);
                Shaders.checkGLError("copy shadow depth");
                bqe.g((int)33984);
            }
            bqe.l();
            bqe.a((boolean)true);
            mc.N().a(byv.g);
            bqe.j((int)7425);
            Shaders.checkGLError("shadow pre-translucent");
            GL20.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers pre-translucent");
            Shaders.checkFramebufferStatus("shadow pre-translucent");
            if (Shaders.isRenderShadowTranslucent()) {
                mc.B.c("shadow translucent");
                renderGlobal.a(aji.d, (double)partialTicks, 2, viewEntity);
                Shaders.checkGLError("shadow translucent");
            }
            if (Reflector.ForgeHooksClient_setRenderPass.exists()) {
                beo.b();
                Reflector.call(Reflector.ForgeHooksClient_setRenderPass, 1);
                renderGlobal.a(viewEntity, (btj)frustum, partialTicks);
                Reflector.call(Reflector.ForgeHooksClient_setRenderPass, -1);
                beo.a();
                Shaders.checkGLError("shadow entities 1");
            }
            bqe.j((int)7424);
            bqe.a((boolean)true);
            bqe.q();
            bqe.l();
            GL11.glFlush();
            Shaders.checkGLError("shadow flush");
            Shaders.isShadowPass = false;
            mc.u.as = Shaders.preShadowPassThirdPersonView;
            mc.B.c("shadow postprocess");
            if (Shaders.hasGlGenMipmap) {
                if (Shaders.usedShadowDepthBuffers >= 1) {
                    if (Shaders.shadowMipmapEnabled[0]) {
                        bqe.g((int)33988);
                        bqe.i((int)Shaders.sfbDepthTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL11.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowDepthBuffers >= 2 && Shaders.shadowMipmapEnabled[1]) {
                        bqe.g((int)33989);
                        bqe.i((int)Shaders.sfbDepthTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL11.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[1] ? 9984 : 9987));
                    }
                    bqe.g((int)33984);
                }
                if (Shaders.usedShadowColorBuffers >= 1) {
                    if (Shaders.shadowColorMipmapEnabled[0]) {
                        bqe.g((int)33997);
                        bqe.i((int)Shaders.sfbColorTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL11.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowColorBuffers >= 2 && Shaders.shadowColorMipmapEnabled[1]) {
                        bqe.g((int)33998);
                        bqe.i((int)Shaders.sfbColorTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL11.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[1] ? 9984 : 9987));
                    }
                    bqe.g((int)33984);
                }
            }
            Shaders.checkGLError("shadow postprocess");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.dfb);
            GL11.glViewport((int)0, (int)0, (int)Shaders.renderWidth, (int)Shaders.renderHeight);
            Shaders.activeDrawBuffers = null;
            mc.N().a(byv.g);
            Shaders.useProgram(7);
            GL11.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            Shaders.checkGLError("shadow end");
        }
    }

    public static void preRenderChunkLayer(aji blockLayerIn) {
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            bqe.r();
        }
        if (ccy.f()) {
            GL11.glEnableClientState((int)32885);
            GL20.glEnableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.entityAttrib);
        }
    }

    public static void postRenderChunkLayer(aji blockLayerIn) {
        if (ccy.f()) {
            GL11.glDisableClientState((int)32885);
            GL20.glDisableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.entityAttrib);
        }
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            bqe.q();
        }
    }

    public static void setupArrayPointersVbo() {
        int vertexSizeI = 14;
        GL11.glVertexPointer((int)3, (int)5126, (int)56, (long)0L);
        GL11.glColorPointer((int)4, (int)5121, (int)56, (long)12L);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)56, (long)16L);
        ccy.l((int)ccy.r);
        GL11.glTexCoordPointer((int)2, (int)5122, (int)56, (long)24L);
        ccy.l((int)ccy.q);
        GL11.glNormalPointer((int)5120, (int)56, (long)28L);
        GL20.glVertexAttribPointer((int)Shaders.midTexCoordAttrib, (int)2, (int)5126, (boolean)false, (int)56, (long)32L);
        GL20.glVertexAttribPointer((int)Shaders.tangentAttrib, (int)4, (int)5122, (boolean)false, (int)56, (long)40L);
        GL20.glVertexAttribPointer((int)Shaders.entityAttrib, (int)3, (int)5122, (boolean)false, (int)56, (long)48L);
    }

    public static void beaconBeamBegin() {
        Shaders.useProgram(14);
    }

    public static void beaconBeamStartQuad1() {
    }

    public static void beaconBeamStartQuad2() {
    }

    public static void beaconBeamDraw1() {
    }

    public static void beaconBeamDraw2() {
        bqe.l();
    }

    public static void renderEnchantedGlintBegin() {
        Shaders.useProgram(17);
    }

    public static void renderEnchantedGlintEnd() {
        if (Shaders.isRenderingWorld) {
            if (Shaders.isRenderingFirstPersonHand() && Shaders.isRenderBothHands()) {
                Shaders.useProgram(19);
            } else {
                Shaders.useProgram(16);
            }
        } else {
            Shaders.useProgram(0);
        }
    }

    public static boolean renderEndPortal(asx te, double x, double y, double z, float partialTicks, int destroyStage, float offset) {
        int lu;
        float du2;
        if (!Shaders.isShadowPass && Shaders.programsID[Shaders.activeProgram] == 0) {
            return false;
        }
        bqe.g();
        Config.getTextureManager().a(END_PORTAL_TEXTURE);
        bqq tessellator = bqq.a();
        bpw vertexbuffer = tessellator.c();
        vertexbuffer.a(7, bze.a);
        float col = 0.5f;
        float r = col * 0.15f;
        float g = col * 0.3f;
        float b2 = col * 0.4f;
        float u0 = 0.0f;
        float u1 = 0.2f;
        float v0 = u0;
        float v1 = u1;
        float dv2 = du2 = (float)(System.currentTimeMillis() % 100000L) / 100000.0f;
        float dy = offset;
        int lv = lu = 240;
        if (te.a(cv.d)) {
            vertexbuffer.b(x, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v0 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x + 1.0, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v1 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x + 1.0, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v1 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v0 + dv2)).a(lu, lv).d();
        }
        if (te.a(cv.c)) {
            vertexbuffer.b(x, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v1 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x + 1.0, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v0 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x + 1.0, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v0 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v1 + dv2)).a(lu, lv).d();
        }
        if (te.a(cv.f)) {
            vertexbuffer.b(x + 1.0, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v1 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x + 1.0, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v0 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x + 1.0, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v0 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x + 1.0, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v1 + dv2)).a(lu, lv).d();
        }
        if (te.a(cv.e)) {
            vertexbuffer.b(x, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v0 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v1 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x, y + 1.0, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v1 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x, y + 1.0, z).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v0 + dv2)).a(lu, lv).d();
        }
        if (te.a(cv.a)) {
            vertexbuffer.b(x, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v0 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x + 1.0, y, z).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v1 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x + 1.0, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v1 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x, y, z + 1.0).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v0 + dv2)).a(lu, lv).d();
        }
        if (te.a(cv.b)) {
            vertexbuffer.b(x, y + (double)dy, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v0 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x + 1.0, y + (double)dy, z + 1.0).a(r, g, b2, 1.0f).a((double)(u0 + du2), (double)(v1 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x + 1.0, y + (double)dy, z).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v1 + dv2)).a(lu, lv).d();
            vertexbuffer.b(x, y + (double)dy, z).a(r, g, b2, 1.0f).a((double)(u1 + du2), (double)(v0 + dv2)).a(lu, lv).d();
        }
        tessellator.b();
        bqe.f();
        return true;
    }
}

