/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.lwjgl.util.vector.Vector3f;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;

    public static cbe makeModelCube(String spriteName, int tintIndex) {
        byw sprite = Config.getMinecraft().R().a(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static cbe makeModelCube(byw sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        cv[] facings = cv.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            cv facing = facings[i];
            ArrayList<brb> quads = new ArrayList<brb>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.put(facing, quads);
        }
        brm itemOverrideList = new brm(new ArrayList());
        cbl bakedModel = new cbl(generalQuads, faceQuads, true, true, sprite, bro.a, itemOverrideList);
        return bakedModel;
    }

    public static cbe joinModelsCube(cbe modelBase, cbe modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a(null, null, 0L));
        generalQuads.addAll(modelAdd.a(null, null, 0L));
        cv[] facings = cv.n;
        HashMap faceQuads = new HashMap();
        for (int i = 0; i < facings.length; ++i) {
            cv facing = facings[i];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(null, facing, 0L));
            quads.addAll(modelAdd.a(null, facing, 0L));
            faceQuads.put(facing, quads);
        }
        boolean ao = modelBase.a();
        boolean builtIn = modelBase.c();
        byw sprite = modelBase.d();
        bro transforms = modelBase.e();
        brm itemOverrideList = modelBase.f();
        cbl bakedModel = new cbl(generalQuads, faceQuads, ao, builtIn, sprite, transforms, itemOverrideList);
        return bakedModel;
    }

    public static brb makeBakedQuad(cv facing, byw sprite, int tintIndex) {
        Vector3f posFrom = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f posTo = new Vector3f(16.0f, 16.0f, 16.0f);
        brf uv = new brf(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        brd face = new brd(facing, tintIndex, "#" + facing.m(), uv);
        cbf modelRotation = cbf.a;
        bre partRotation = null;
        boolean uvLocked = false;
        boolean shade = true;
        brj faceBakery = new brj();
        brb quad = faceBakery.a(posFrom, posTo, face, sprite, facing, modelRotation, partRotation, uvLocked, shade);
        return quad;
    }

    public static cbe makeModel(String modelName, String spriteOldName, String spriteNewName) {
        byv textureMap = Config.getMinecraft().R();
        byw spriteOld = textureMap.getSpriteSafe(spriteOldName);
        byw spriteNew = textureMap.getSpriteSafe(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static cbe makeModel(String modelName, byw spriteOld, byw spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        cbi modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        cbj mrl = new cbj(modelName, "normal");
        cbe model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        cbe modelNew = ModelUtils.duplicateModel(model);
        cv[] faces = cv.n;
        for (int i = 0; i < faces.length; ++i) {
            cv face = faces[i];
            List quads = modelNew.a(null, face, 0L);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a(null, null, 0L);
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<brb> quads, byw spriteOld, byw spriteNew) {
        ArrayList<Object> quadsNew = new ArrayList<Object>();
        for (brb quad : quads) {
            if (quad.a() != spriteOld) {
                quadsNew.add(quad);
                break;
            }
            bri quadNew = new bri(quad, spriteNew);
            quadsNew.add(quadNew);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(Vector3f pos) {
        pos.setX(BlockModelUtils.snapVertexCoord(pos.getX()));
        pos.setY(BlockModelUtils.snapVertexCoord(pos.getY()));
        pos.setZ(BlockModelUtils.snapVertexCoord(pos.getZ()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static bdr getOffsetBoundingBox(bdr aabb, als.a offsetType, co pos) {
        int x = pos.p();
        int z = pos.r();
        long k = (long)(x * 3129871) ^ (long)z * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double dx = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == als.a.c) {
            dy = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.d(dx, dy, dz);
    }
}

