/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.common.primitives.Floats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.ItemOverrideProperty;
import net.optifine.reflect.Reflector;
import net.optifine.util.CompoundKey;

public class ItemOverrideCache {
    private ItemOverrideProperty[] itemOverrideProperties;
    private Map<CompoundKey, Integer> mapModelIndexes = new HashMap<CompoundKey, Integer>();
    public static final Integer INDEX_NONE = new Integer(-1);

    public ItemOverrideCache(ItemOverrideProperty[] itemOverrideProperties) {
        this.itemOverrideProperties = itemOverrideProperties;
    }

    public Integer getModelIndex(bqq stack, eji world, atu entity) {
        CompoundKey valueKey = this.getValueKey(stack, world, entity);
        if (valueKey == null) {
            return null;
        }
        return this.mapModelIndexes.get(valueKey);
    }

    public void putModelIndex(bqq stack, eji world, atu entity, Integer index) {
        CompoundKey valueKey = this.getValueKey(stack, world, entity);
        if (valueKey == null) {
            return;
        }
        this.mapModelIndexes.put(valueKey, index);
    }

    private CompoundKey getValueKey(bqq stack, eji world, atu entity) {
        Object[] indexes = new Integer[this.itemOverrideProperties.length];
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            Integer index = this.itemOverrideProperties[i2].getValueIndex(stack, world, entity);
            if (index == null) {
                return null;
            }
            indexes[i2] = index;
        }
        return new CompoundKey(indexes);
    }

    public static ItemOverrideCache make(List<eol> overrides) {
        if (overrides.isEmpty()) {
            return null;
        }
        if (!Reflector.ItemOverride_listResourceValues.exists()) {
            return null;
        }
        LinkedHashMap<ww, HashSet<Float>> propertyValues = new LinkedHashMap<ww, HashSet<Float>>();
        for (eol itemOverride : overrides) {
            List resourceValues = (List)Reflector.getFieldValue(itemOverride, Reflector.ItemOverride_listResourceValues);
            for (eol.b resourceValue : resourceValues) {
                ww loc = resourceValue.a();
                float val = resourceValue.b();
                HashSet<Float> setValues = (HashSet<Float>)propertyValues.get(loc);
                if (setValues == null) {
                    setValues = new HashSet<Float>();
                    propertyValues.put(loc, setValues);
                }
                setValues.add(Float.valueOf(val));
            }
        }
        ArrayList<ItemOverrideProperty> listProps = new ArrayList<ItemOverrideProperty>();
        Set setPropertyLocations = propertyValues.keySet();
        for (ww loc : setPropertyLocations) {
            Set setValues = (Set)propertyValues.get(loc);
            float[] values = Floats.toArray((Collection)setValues);
            ItemOverrideProperty prop = new ItemOverrideProperty(loc, values);
            listProps.add(prop);
        }
        ItemOverrideProperty[] props = listProps.toArray(new ItemOverrideProperty[listProps.size()]);
        ItemOverrideCache cache = new ItemOverrideCache(props);
        ItemOverrideCache.logCache(props, overrides);
        return cache;
    }

    private static void logCache(ItemOverrideProperty[] props, List<eol> overrides) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < props.length; ++i2) {
            ItemOverrideProperty prop = props[i2];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("" + prop.getLocation() + "=" + prop.getValues().length);
        }
        if (overrides.size() > 0) {
            sb.append(" -> " + overrides.get(0).a() + " ...");
        }
        Config.dbg("ItemOverrideCache: " + sb.toString());
    }

    public String toString() {
        return "properties: " + this.itemOverrideProperties.length + ", modelIndexes: " + this.mapModelIndexes.size();
    }
}

