/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.Pbuffer;
import org.lwjgl.opengl.PixelFormat;

public class WrUpdaterThreaded
implements IWrUpdater {
    private WrUpdateThread updateThread = null;
    private float timePerUpdateMs = 10.0f;
    private long updateStartTimeNs = 0L;
    private boolean firstUpdate = true;
    private int updateTargetNum = 0;

    @Override
    public void terminate() {
        if (this.updateThread == null) {
            return;
        }
        this.updateThread.terminate();
        this.updateThread.unpauseToEndOfUpdate();
    }

    @Override
    public void initialize() {
    }

    private void delayedInit() {
        if (this.updateThread != null) {
            return;
        }
        this.createUpdateThread(Display.getDrawable());
    }

    @Override
    public blg makeWorldRenderer(afn worldObj, List tileEntities, int x, int y, int z, int glRenderListBase) {
        return new WorldRendererThreaded(worldObj, tileEntities, x, y, z, glRenderListBase);
    }

    public WrUpdateThread createUpdateThread(Drawable displayDrawable) {
        if (this.updateThread != null) {
            throw new IllegalStateException("UpdateThread is already existing");
        }
        try {
            Pbuffer pbuffer = new Pbuffer(1, 1, new PixelFormat(), displayDrawable);
            this.updateThread = new WrUpdateThread(pbuffer);
            this.updateThread.setPriority(1);
            this.updateThread.start();
            this.updateThread.pause();
            return this.updateThread;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isUpdateThread() {
        return Thread.currentThread() == this.updateThread;
    }

    public static boolean isBackgroundChunkLoading() {
        return true;
    }

    @Override
    public void preRender(bls rg, rh player) {
        this.updateTargetNum = 0;
        if (this.updateThread != null) {
            if (this.updateStartTimeNs == 0L) {
                this.updateStartTimeNs = System.nanoTime();
            }
            if (this.updateThread.hasWorkToDo()) {
                this.updateTargetNum = Config.getUpdatesPerFrame();
                if (Config.isDynamicUpdates() && !rg.isMoving(player)) {
                    this.updateTargetNum *= 3;
                }
                this.updateTargetNum = Math.min(this.updateTargetNum, this.updateThread.getPendingUpdatesCount());
                if (this.updateTargetNum > 0) {
                    this.updateThread.unpause();
                }
            }
        }
    }

    @Override
    public void postRender() {
        if (this.updateThread != null) {
            float sleepTimeMs = 0.0f;
            if (this.updateTargetNum > 0) {
                long renderTimeNs = System.nanoTime() - this.updateStartTimeNs;
                float targetRunTime = this.timePerUpdateMs * (1.0f + (float)(this.updateTargetNum - 1) / 2.0f);
                sleepTimeMs = targetRunTime;
                if (sleepTimeMs > 0.0f) {
                    int sleepTimeMsInt = (int)sleepTimeMs;
                    Config.sleep(sleepTimeMsInt);
                }
                this.updateThread.pause();
            }
            float deltaTime = 0.2f;
            if (this.updateTargetNum > 0) {
                int updateCount = this.updateThread.resetUpdateCount();
                if (updateCount < this.updateTargetNum) {
                    this.timePerUpdateMs += deltaTime;
                }
                if (updateCount > this.updateTargetNum) {
                    this.timePerUpdateMs -= deltaTime;
                }
                if (updateCount == this.updateTargetNum) {
                    this.timePerUpdateMs -= deltaTime;
                }
            } else {
                this.timePerUpdateMs -= deltaTime / 5.0f;
            }
            if (this.timePerUpdateMs < 0.0f) {
                this.timePerUpdateMs = 0.0f;
            }
            this.updateStartTimeNs = System.nanoTime();
        }
    }

    @Override
    public boolean updateRenderers(bls rg, rh entityliving, boolean flag) {
        Object wr2;
        int i;
        this.delayedInit();
        if (rg.t.size() <= 0) {
            return true;
        }
        int num = 0;
        int NOT_IN_FRUSTRUM_MUL = 4;
        int numValid = 0;
        blg wrBest = null;
        float distSqBest = Float.MAX_VALUE;
        int indexBest = -1;
        for (int i2 = 0; i2 < rg.t.size(); ++i2) {
            blg wr3 = (blg)rg.t.get(i2);
            if (wr3 == null) continue;
            ++numValid;
            if (wr3.isUpdating) continue;
            if (!wr3.q) {
                rg.t.set(i2, null);
                continue;
            }
            float distSq = wr3.a((qn)entityliving);
            if (distSq < 512.0f) {
                if (distSq < 256.0f && rg.isActingNow() && wr3.l || this.firstUpdate) {
                    if (this.updateThread != null) {
                        this.updateThread.unpauseToEndOfUpdate();
                    }
                    wr3.a(entityliving);
                    wr3.q = false;
                    rg.t.set(i2, null);
                    ++num;
                    continue;
                }
                if (this.updateThread != null) {
                    this.updateThread.addRendererToUpdate(wr3, true);
                    wr3.q = false;
                    rg.t.set(i2, null);
                    ++num;
                    continue;
                }
            }
            if (!wr3.l) {
                distSq *= (float)NOT_IN_FRUSTRUM_MUL;
            }
            if (wrBest == null) {
                wrBest = wr3;
                distSqBest = distSq;
                indexBest = i2;
                continue;
            }
            if (!(distSq < distSqBest)) continue;
            wrBest = wr3;
            distSqBest = distSq;
            indexBest = i2;
        }
        int maxUpdateNum = Config.getUpdatesPerFrame();
        boolean turboMode = false;
        if (Config.isDynamicUpdates() && !rg.isMoving(entityliving)) {
            maxUpdateNum *= 3;
            turboMode = true;
        }
        if (this.updateThread != null && (maxUpdateNum = this.updateThread.getUpdateCapacity()) <= 0) {
            return true;
        }
        if (wrBest != null) {
            this.updateRenderer(wrBest, entityliving);
            rg.t.set(indexBest, null);
            ++num;
            float maxDiffDistSq = distSqBest / 5.0f;
            for (i = 0; i < rg.t.size() && num < maxUpdateNum; ++i) {
                float diffDistSq;
                wr2 = (blg)rg.t.get(i);
                if (wr2 == null || ((blg)wr2).isUpdating) continue;
                float distSq = wr2.a((qn)entityliving);
                if (!((blg)wr2).l) {
                    distSq *= (float)NOT_IN_FRUSTRUM_MUL;
                }
                if (!((diffDistSq = Math.abs(distSq - distSqBest)) < maxDiffDistSq)) continue;
                this.updateRenderer((blg)wr2, entityliving);
                rg.t.set(i, null);
                ++num;
            }
        }
        if (numValid == 0) {
            rg.t.clear();
        }
        if (rg.t.size() > 100 && numValid < rg.t.size() * 4 / 5) {
            int dstIndex = 0;
            for (int srcIndex = 0; srcIndex < rg.t.size(); ++srcIndex) {
                wr2 = rg.t.get(srcIndex);
                if (wr2 == null) continue;
                if (srcIndex != dstIndex) {
                    rg.t.set(dstIndex, wr2);
                }
                ++dstIndex;
            }
            for (i = rg.t.size() - 1; i >= dstIndex; --i) {
                rg.t.remove(i);
            }
        }
        this.firstUpdate = false;
        return true;
    }

    private void updateRenderer(blg wr2, rh entityLiving) {
        WrUpdateThread ut = this.updateThread;
        if (ut != null) {
            ut.addRendererToUpdate(wr2, false);
            wr2.q = false;
            return;
        }
        wr2.a(entityLiving);
        wr2.q = false;
        wr2.isUpdating = false;
    }

    @Override
    public void finishCurrentUpdate() {
        if (this.updateThread != null) {
            this.updateThread.unpauseToEndOfUpdate();
        }
    }

    @Override
    public void resumeBackgroundUpdates() {
        if (this.updateThread != null) {
            this.updateThread.unpause();
        }
    }

    @Override
    public void pauseBackgroundUpdates() {
        if (this.updateThread != null) {
            this.updateThread.pause();
        }
    }

    @Override
    public void clearAllUpdates() {
        if (this.updateThread != null) {
            this.updateThread.clearAllUpdates();
        }
        this.firstUpdate = true;
    }
}

