/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;

public class DynamicLights {
    private static DynamicLightsMap mapDynamicLights = new DynamicLightsMap();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static ReflectorField ItemBlock_block = Reflector.getReflectorField(zt.class, ahu.class);

    public static void entityAdded(qn entityIn, bls renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(qn entityIn, bls renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLight dynamicLight = mapDynamicLights.remove(entityIn.y());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(bls renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLights.updateMapDynamicLights(renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                DynamicLight dynamicLight = dynamicLights.get(i);
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void updateMapDynamicLights(bls renderGlobal) {
        biz world = renderGlobal.r;
        if (world == null) {
            return;
        }
        List entities = world.C();
        for (qn entity : entities) {
            DynamicLight dynamicLight;
            int key;
            int lightLevel = DynamicLights.getLightLevel(entity);
            if (lightLevel > 0) {
                key = entity.y();
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = entity.y();
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(int x, int y, int z, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(x, y, z);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(qn entity, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(entity);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(int x, int y, int z) {
        double lightLevelMax = 0.0;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                double dist;
                double light;
                double lightLevel;
                DynamicLight dynamicLight = dynamicLights.get(i);
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)x - px;
                double dy = (double)y - py;
                double dz = (double)z - pz;
                double distSq = dx * dx + dy * dy + dz * dz;
                if (dynamicLight.isUnderwater() && !Config.isClearWater()) {
                    dynamicLightLevel = Config.limit(dynamicLightLevel - 2, 0, 15);
                    distSq *= 2.0;
                }
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit(lightLevelMax, 0.0, 15.0);
        return lightPlayer;
    }

    public static int getLightLevel(abp itemStack) {
        zt itemBlock;
        ahu block;
        if (itemStack == null) {
            return 0;
        }
        abn item = itemStack.b();
        if (item instanceof zt && (block = (ahu)Reflector.getFieldValue(itemBlock = (zt)item, ItemBlock_block)) != null) {
            return block.m();
        }
        if (item == abq.at) {
            return ahz.l.m();
        }
        if (item == abq.bj || item == abq.br) {
            return 10;
        }
        if (item == abq.aO) {
            return 8;
        }
        if (item == abq.bs) {
            return 8;
        }
        if (item == abq.bN) {
            return ahz.bJ.m() / 2;
        }
        return 0;
    }

    public static int getLightLevel(qn entity) {
        wl entityCreeper;
        if (entity == Config.getMinecraft().i && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity.al()) {
            return 15;
        }
        if (entity instanceof xq) {
            return 15;
        }
        if (entity instanceof wi) {
            return 15;
        }
        if (entity instanceof wj) {
            wj entityBlaze = (wj)entity;
            if (entityBlaze.bX()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof wr) {
            wr emc = (wr)entity;
            if ((double)emc.i > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof wl && (entityCreeper = (wl)entity).bZ() > 0) {
            return 15;
        }
        if (entity instanceof rh) {
            rh player = (rh)entity;
            abp stackMain = player.be();
            int levelMain = DynamicLights.getLightLevel(stackMain);
            abp stackHead = player.q(4);
            int levelHead = DynamicLights.getLightLevel(stackHead);
            return Math.max(levelMain, levelHead);
        }
        if (entity instanceof vw) {
            vw entityItem = (vw)entity;
            abp itemStack = DynamicLights.getItemStack(entityItem);
            return DynamicLights.getLightLevel(itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(bls renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i = 0; i < dynamicLights.size(); ++i) {
                DynamicLight dynamicLight = dynamicLights.get(i);
                dynamicLight.updateLitChunks(renderGlobal);
            }
            dynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            return mapDynamicLights.size();
        }
    }

    public static abp getItemStack(vw entityItem) {
        abp itemstack = entityItem.z().f(10);
        return itemstack;
    }
}

