/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.optifine.DynamicLight;
import net.optifine.DynamicLightsMap;
import net.optifine.config.ConnectedParser;
import net.optifine.config.EntityClassLocator;
import net.optifine.config.IObjectLocator;
import net.optifine.config.ItemLocator;
import net.optifine.reflect.ReflectorForge;
import net.optifine.util.PropertiesOrdered;

public class DynamicLights {
    private static DynamicLightsMap mapDynamicLights = new DynamicLightsMap();
    private static Map<Class, Integer> mapEntityLightLevels = new HashMap<Class, Integer>();
    private static Map<asz, Integer> mapItemLightLevels = new HashMap<asz, Integer>();
    private static long timeUpdateMs = 0L;
    private static final double MAX_DIST = 7.5;
    private static final double MAX_DIST_SQ = 56.25;
    private static final int LIGHT_LEVEL_MAX = 15;
    private static final int LIGHT_LEVEL_FIRE = 15;
    private static final int LIGHT_LEVEL_BLAZE = 10;
    private static final int LIGHT_LEVEL_MAGMA_CUBE = 8;
    private static final int LIGHT_LEVEL_MAGMA_CUBE_CORE = 13;
    private static final int LIGHT_LEVEL_GLOWSTONE_DUST = 8;
    private static final int LIGHT_LEVEL_PRISMARINE_CRYSTALS = 8;
    private static final or<atd> PARAMETER_ITEM_STACK = new or(6, ot.g);
    private static boolean initialized;

    public static void entityAdded(aer entityIn, cud renderGlobal) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void entityRemoved(aer entityIn, cud renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLight dynamicLight = mapDynamicLights.remove(entityIn.Q());
            if (dynamicLight != null) {
                dynamicLight.updateLitChunks(renderGlobal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(cud renderGlobal) {
        long timeNowMs = System.currentTimeMillis();
        if (timeNowMs < timeUpdateMs + 50L) {
            return;
        }
        timeUpdateMs = timeNowMs;
        if (!initialized) {
            DynamicLights.initialize();
        }
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            DynamicLights.updateMapDynamicLights(renderGlobal);
            if (mapDynamicLights.size() <= 0) {
                return;
            }
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                DynamicLight dynamicLight = dynamicLights.get(i2);
                dynamicLight.update(renderGlobal);
            }
        }
    }

    private static void initialize() {
        initialized = true;
        mapEntityLightLevels.clear();
        mapItemLightLevels.clear();
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i2 = 0; i2 < modIds.length; ++i2) {
            String modId = modIds[i2];
            try {
                pc loc = new pc(modId, "optifine/dynamic_lights.properties");
                InputStream in = Config.getResourceStream(loc);
                DynamicLights.loadModConfiguration(in, loc.toString(), modId);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (mapEntityLightLevels.size() > 0) {
            Config.dbg("DynamicLights entities: " + mapEntityLightLevels.size());
        }
        if (mapItemLightLevels.size() > 0) {
            Config.dbg("DynamicLights items: " + mapItemLightLevels.size());
        }
    }

    private static void loadModConfiguration(InputStream in, String path, String modId) {
        if (in == null) {
            return;
        }
        try {
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg("DynamicLights: Parsing " + path);
            ConnectedParser cp = new ConnectedParser("DynamicLights");
            DynamicLights.loadModLightLevels(props.getProperty("entities"), mapEntityLightLevels, new EntityClassLocator(), cp, path, modId);
            DynamicLights.loadModLightLevels(props.getProperty("items"), mapItemLightLevels, new ItemLocator(), cp, path, modId);
        }
        catch (IOException e2) {
            Config.warn("DynamicLights: Error reading " + path);
        }
    }

    private static void loadModLightLevels(String prop, Map mapLightLevels, IObjectLocator ol, ConnectedParser cp, String path, String modId) {
        if (prop == null) {
            return;
        }
        String[] parts = Config.tokenize(prop, " ");
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String part = parts[i2];
            String[] tokens = Config.tokenize(part, ":");
            if (tokens.length != 2) {
                cp.warn("Invalid entry: " + part + ", in:" + path);
                continue;
            }
            String name = tokens[0];
            String light = tokens[1];
            String nameFull = modId + ":" + name;
            pc loc = new pc(nameFull);
            Object obj = ol.getObject(loc);
            if (obj == null) {
                cp.warn("Object not found: " + nameFull);
                continue;
            }
            int lightLevel = cp.parseInt(light, -1);
            if (lightLevel < 0 || lightLevel > 15) {
                cp.warn("Invalid light level: " + part);
                continue;
            }
            mapLightLevels.put(obj, new Integer(lightLevel));
        }
    }

    private static void updateMapDynamicLights(cud renderGlobal) {
        crf world = renderGlobal.getWorld();
        if (world == null) {
            return;
        }
        List entities = world.f;
        for (aer entity : entities) {
            DynamicLight dynamicLight;
            int key;
            int lightLevel = DynamicLights.getLightLevel(entity);
            if (lightLevel > 0) {
                key = entity.Q();
                dynamicLight = mapDynamicLights.get(key);
                if (dynamicLight != null) continue;
                dynamicLight = new DynamicLight(entity);
                mapDynamicLights.put(key, dynamicLight);
                continue;
            }
            key = entity.Q();
            dynamicLight = mapDynamicLights.remove(key);
            if (dynamicLight == null) continue;
            dynamicLight.updateLitChunks(renderGlobal);
        }
    }

    public static int getCombinedLight(el pos, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(pos);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(aer entity, int combinedLight) {
        double lightPlayer = DynamicLights.getLightLevel(entity);
        combinedLight = DynamicLights.getCombinedLight(lightPlayer, combinedLight);
        return combinedLight;
    }

    public static int getCombinedLight(double lightPlayer, int combinedLight) {
        int lightBlockFF;
        int lightPlayerFF;
        if (lightPlayer > 0.0 && (lightPlayerFF = (int)(lightPlayer * 16.0)) > (lightBlockFF = combinedLight & 0xFF)) {
            combinedLight &= 0xFFFFFF00;
            combinedLight |= lightPlayerFF;
        }
        return combinedLight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getLightLevel(el pos) {
        double lightLevelMax = 0.0;
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                double dist;
                double light;
                double lightLevel;
                double dz;
                double dy;
                DynamicLight dynamicLight = dynamicLights.get(i2);
                int dynamicLightLevel = dynamicLight.getLastLightLevel();
                if (dynamicLightLevel <= 0) continue;
                double px = dynamicLight.getLastPosX();
                double py = dynamicLight.getLastPosY();
                double pz = dynamicLight.getLastPosZ();
                double dx = (double)pos.o() - px;
                double distSq = dx * dx + (dy = (double)pos.p() - py) * dy + (dz = (double)pos.q() - pz) * dz;
                if (distSq > 56.25 || !((lightLevel = (light = 1.0 - (dist = Math.sqrt(distSq)) / 7.5) * (double)dynamicLightLevel) > lightLevelMax)) continue;
                lightLevelMax = lightLevel;
            }
        }
        double lightPlayer = Config.limit(lightLevelMax, 0.0, 15.0);
        return lightPlayer;
    }

    public static int getLightLevel(atd itemStack) {
        Integer level;
        ari itemBlock;
        bcr block;
        if (itemStack == null) {
            return 0;
        }
        asz item = itemStack.b();
        if (item instanceof ari && (block = (itemBlock = (ari)item).d()) != null) {
            return block.m(block.p());
        }
        if (item == ate.ay) {
            return bcs.C.m(bcs.C.p());
        }
        if (item == ate.cj || item == ate.cu) {
            return 10;
        }
        if (item == ate.ba) {
            return 8;
        }
        if (item == ate.es) {
            return 8;
        }
        if (item == ate.cv) {
            return 8;
        }
        if (item == ate.dP) {
            return bcs.eu.m(bcs.eu.p()) / 2;
        }
        if (!mapItemLightLevels.isEmpty() && (level = mapItemLightLevels.get(item)) != null) {
            return level;
        }
        return 0;
    }

    public static int getLightLevel(aer entity) {
        ams entityCreeper;
        Integer level;
        aof player;
        if (entity == Config.getMinecraft().S() && !Config.isDynamicHandLight()) {
            return 0;
        }
        if (entity instanceof aof && (player = (aof)entity).t()) {
            return 0;
        }
        if (entity.aV()) {
            return 15;
        }
        if (!mapEntityLightLevels.isEmpty() && (level = mapEntityLightLevels.get(entity.getClass())) != null) {
            return level;
        }
        if (entity instanceof aok) {
            return 15;
        }
        if (entity instanceof amm) {
            return 15;
        }
        if (entity instanceof amq) {
            amq entityBlaze = (amq)entity;
            if (entityBlaze.l()) {
                return 15;
            }
            return 10;
        }
        if (entity instanceof ane) {
            ane emc = (ane)entity;
            if ((double)emc.b > 0.6) {
                return 13;
            }
            return 8;
        }
        if (entity instanceof ams && (double)(entityCreeper = (ams)entity).a(0.0f) > 0.001) {
            return 15;
        }
        if (entity instanceof afa) {
            player = (afa)entity;
            atd stackMain = player.cB();
            int levelMain = DynamicLights.getLightLevel(stackMain);
            atd stackOff = player.cC();
            int levelOff = DynamicLights.getLightLevel(stackOff);
            atd stackHead = player.b(aew.f);
            int levelHead = DynamicLights.getLightLevel(stackHead);
            int levelHandMax = Math.max(levelMain, levelOff);
            return Math.max(levelHandMax, levelHead);
        }
        if (entity instanceof aml) {
            aml entityItem = (aml)entity;
            atd itemStack = DynamicLights.getItemStack(entityItem);
            return DynamicLights.getLightLevel(itemStack);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLights(cud renderGlobal) {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            List<DynamicLight> dynamicLights = mapDynamicLights.valueList();
            for (int i2 = 0; i2 < dynamicLights.size(); ++i2) {
                DynamicLight dynamicLight = dynamicLights.get(i2);
                dynamicLight.updateLitChunks(renderGlobal);
            }
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            mapDynamicLights.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount() {
        DynamicLightsMap dynamicLightsMap = mapDynamicLights;
        synchronized (dynamicLightsMap) {
            return mapDynamicLights.size();
        }
    }

    public static atd getItemStack(aml entityItem) {
        atd itemstack = (atd)entityItem.T().a(PARAMETER_ITEM_STACK);
        return itemstack;
    }
}

