/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.optifine.CustomGuiProperties;
import net.optifine.override.PlayerControllerOF;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;

public class CustomGuis {
    private static cfs mc = Config.getMinecraft();
    private static PlayerControllerOF playerControllerOF = null;
    private static CustomGuiProperties[][] guiProperties = null;
    public static boolean isChristmas = CustomGuis.isChristmas();

    public static pc getTextureLocation(pc loc) {
        aer entity;
        if (guiProperties == null) {
            return loc;
        }
        ckc screen = CustomGuis.mc.m;
        if (!(screen instanceof ckx)) {
            return loc;
        }
        if (!loc.b().equals("minecraft") || !loc.a().startsWith("textures/gui/")) {
            return loc;
        }
        if (playerControllerOF == null) {
            return loc;
        }
        crf world = CustomGuis.mc.g;
        if (world == null) {
            return loc;
        }
        if (screen instanceof clg) {
            return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CREATIVE, CustomGuis.mc.i.bH(), (ayd)world, loc, screen);
        }
        if (screen instanceof clo) {
            return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.INVENTORY, CustomGuis.mc.i.bH(), (ayd)world, loc, screen);
        }
        el pos = playerControllerOF.getLastClickBlockPos();
        if (pos != null) {
            if (screen instanceof cky) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ANVIL, pos, (ayd)world, loc, screen);
            }
            if (screen instanceof ckz) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BEACON, pos, (ayd)world, loc, screen);
            }
            if (screen instanceof clb) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BREWING_STAND, pos, (ayd)world, loc, screen);
            }
            if (screen instanceof cld) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CHEST, pos, (ayd)world, loc, screen);
            }
            if (screen instanceof cle) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CRAFTING, pos, (ayd)world, loc, screen);
            }
            if (screen instanceof clh) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.DISPENSER, pos, (ayd)world, loc, screen);
            }
            if (screen instanceof clk) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ENCHANTMENT, pos, (ayd)world, loc, screen);
            }
            if (screen instanceof cll) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.FURNACE, pos, (ayd)world, loc, screen);
            }
            if (screen instanceof clm) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.HOPPER, pos, (ayd)world, loc, screen);
            }
            if (screen instanceof clr) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.SHULKER_BOX, pos, (ayd)world, loc, screen);
            }
        }
        if ((entity = playerControllerOF.getLastClickEntity()) != null) {
            if (screen instanceof cln) {
                return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.HORSE, entity, (ayd)world, loc);
            }
            if (screen instanceof clp) {
                return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.VILLAGER, entity, (ayd)world, loc);
            }
        }
        return loc;
    }

    private static pc getTexturePos(CustomGuiProperties.EnumContainer container, el pos, ayd blockAccess, pc loc, ckc screen) {
        CustomGuiProperties[] props = guiProperties[container.ordinal()];
        if (props == null) {
            return loc;
        }
        for (int i2 = 0; i2 < props.length; ++i2) {
            CustomGuiProperties prop = props[i2];
            if (!prop.matchesPos(container, pos, blockAccess, screen)) continue;
            return prop.getTextureLocation(loc);
        }
        return loc;
    }

    private static pc getTextureEntity(CustomGuiProperties.EnumContainer container, aer entity, ayd blockAccess, pc loc) {
        CustomGuiProperties[] props = guiProperties[container.ordinal()];
        if (props == null) {
            return loc;
        }
        for (int i2 = 0; i2 < props.length; ++i2) {
            CustomGuiProperties prop = props[i2];
            if (!prop.matchesEntity(container, entity, blockAccess)) continue;
            return prop.getTextureLocation(loc);
        }
        return loc;
    }

    public static void update() {
        guiProperties = null;
        if (!Config.isCustomGuis()) {
            return;
        }
        ArrayList<List<CustomGuiProperties>> listProps = new ArrayList<List<CustomGuiProperties>>();
        ul[] rps = Config.getResourcePacks();
        for (int i2 = rps.length - 1; i2 >= 0; --i2) {
            ul rp = rps[i2];
            CustomGuis.update(rp, listProps);
        }
        guiProperties = CustomGuis.propertyListToArray(listProps);
    }

    private static CustomGuiProperties[][] propertyListToArray(List<List<CustomGuiProperties>> listProps) {
        if (listProps.isEmpty()) {
            return null;
        }
        CustomGuiProperties[][] cgps = new CustomGuiProperties[CustomGuiProperties.EnumContainer.values().length][];
        for (int i2 = 0; i2 < cgps.length; ++i2) {
            List<CustomGuiProperties> subList;
            if (listProps.size() <= i2 || (subList = listProps.get(i2)) == null) continue;
            CustomGuiProperties[] subArr = subList.toArray(new CustomGuiProperties[subList.size()]);
            cgps[i2] = subArr;
        }
        return cgps;
    }

    private static void update(ul rp, List<List<CustomGuiProperties>> listProps) {
        Object[] paths = ResUtils.collectFiles(rp, "optifine/gui/container/", ".properties", null);
        Arrays.sort(paths);
        for (int i2 = 0; i2 < paths.length; ++i2) {
            Object name = paths[i2];
            Config.dbg("CustomGuis: " + (String)name);
            try {
                pc locFile = new pc((String)name);
                InputStream in = rp.a(um.a, locFile);
                if (in == null) {
                    Config.warn("CustomGuis file not found: " + (String)name);
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                in.close();
                CustomGuiProperties cgp = new CustomGuiProperties(props, (String)name);
                if (!cgp.isValid((String)name)) continue;
                CustomGuis.addToList(cgp, listProps);
                continue;
            }
            catch (FileNotFoundException e2) {
                Config.warn("CustomGuis file not found: " + (String)name);
                continue;
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
    }

    private static void addToList(CustomGuiProperties cgp, List<List<CustomGuiProperties>> listProps) {
        if (cgp.getContainer() == null) {
            CustomGuis.warn("Invalid container: " + (Object)((Object)cgp.getContainer()));
            return;
        }
        int indexContainer = cgp.getContainer().ordinal();
        while (listProps.size() <= indexContainer) {
            listProps.add(null);
        }
        List<CustomGuiProperties> subList = listProps.get(indexContainer);
        if (subList == null) {
            subList = new ArrayList<CustomGuiProperties>();
            listProps.set(indexContainer, subList);
        }
        subList.add(cgp);
    }

    public static PlayerControllerOF getPlayerControllerOF() {
        return playerControllerOF;
    }

    public static void setPlayerControllerOF(PlayerControllerOF playerControllerOF) {
        CustomGuis.playerControllerOF = playerControllerOF;
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }
}

