/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.CustomGuis;
import net.optifine.config.ConnectedParser;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.config.VillagerProfession;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<pc, pc> textureLocations = null;
    private NbtTagValue nbtName = null;
    private ayt[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private VillagerProfession[] professions = null;
    private EnumVariant[] variants = null;
    private asb[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final asb[] COLORS_INVALID = new asb[0];
    private static final pc ANVIL_GUI_TEXTURE = new pc("textures/gui/container/anvil.png");
    private static final pc BEACON_GUI_TEXTURE = new pc("textures/gui/container/beacon.png");
    private static final pc BREWING_STAND_GUI_TEXTURE = new pc("textures/gui/container/brewing_stand.png");
    private static final pc CHEST_GUI_TEXTURE = new pc("textures/gui/container/generic_54.png");
    private static final pc CRAFTING_TABLE_GUI_TEXTURE = new pc("textures/gui/container/crafting_table.png");
    private static final pc HORSE_GUI_TEXTURE = new pc("textures/gui/container/horse.png");
    private static final pc DISPENSER_GUI_TEXTURE = new pc("textures/gui/container/dispenser.png");
    private static final pc ENCHANTMENT_TABLE_GUI_TEXTURE = new pc("textures/gui/container/enchanting_table.png");
    private static final pc FURNACE_GUI_TEXTURE = new pc("textures/gui/container/furnace.png");
    private static final pc HOPPER_GUI_TEXTURE = new pc("textures/gui/container/hopper.png");
    private static final pc INVENTORY_GUI_TEXTURE = new pc("textures/gui/container/inventory.png");
    private static final pc SHULKER_BOX_GUI_TEXTURE = new pc("textures/gui/container/shulker_box.png");
    private static final pc VILLAGER_GUI_TEXTURE = new pc("textures/gui/container/villager.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations(props, "texture", this.container, "textures/gui/", this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListInt(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        Enum[] vars = CustomGuiProperties.getContainerVariants(this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), vars, "variants", VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors(props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static asb[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize(str, " ");
        asb[] cols = new asb[tokens.length];
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            asb col = CustomGuiProperties.parseEnumDyeColor(token);
            if (col == null) {
                CustomGuiProperties.warn("Invalid color: " + token);
                return COLORS_INVALID;
            }
            cols[i2] = col;
        }
        return cols;
    }

    private static asb parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        asb[] colors = asb.values();
        for (int i2 = 0; i2 < colors.length; ++i2) {
            asb enumDyeColor = colors[i2];
            if (enumDyeColor.m().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.b().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static pc parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        String tex = TextureUtils.fixResourcePath(str = str.trim(), basePath);
        if (!tex.endsWith(".png")) {
            tex = tex + ".png";
        }
        return new pc(basePath + "/" + tex);
    }

    private static Map<pc, pc> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<pc, pc> map = new HashMap<pc, pc>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            pc locKey = CustomGuiProperties.getGuiTextureLocation(container);
            pc locVal = CustomGuiProperties.parseTextureLocation(propVal, basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix(pathRel, "/", ".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            pc locKey = new pc(path);
            pc locVal = CustomGuiProperties.parseTextureLocation(val, basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static pc getGuiTextureLocation(EnumContainer container) {
        switch (container) {
            case ANVIL: {
                return ANVIL_GUI_TEXTURE;
            }
            case BEACON: {
                return BEACON_GUI_TEXTURE;
            }
            case BREWING_STAND: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case CHEST: {
                return CHEST_GUI_TEXTURE;
            }
            case CRAFTING: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case CREATIVE: {
                return null;
            }
            case DISPENSER: {
                return DISPENSER_GUI_TEXTURE;
            }
            case ENCHANTMENT: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case FURNACE: {
                return FURNACE_GUI_TEXTURE;
            }
            case HOPPER: {
                return HOPPER_GUI_TEXTURE;
            }
            case HORSE: {
                return HORSE_GUI_TEXTURE;
            }
            case INVENTORY: {
                return INVENTORY_GUI_TEXTURE;
            }
            case SHULKER_BOX: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case VILLAGER: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn("No base path found: " + path);
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn("No container found: " + path);
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn("No texture found: " + path);
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn("Invalid professions or careers: " + path);
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn("Invalid variants: " + path);
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn("Invalid colors: " + path);
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }

    private boolean matchesGeneral(EnumContainer ec, el pos, ayd blockAccess) {
        ayt biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome(biome = blockAccess.d(pos), this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.p());
    }

    public boolean matchesPos(EnumContainer ec, el pos, ayd blockAccess, ckc screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName(screen))) {
            return false;
        }
        switch (ec) {
            case BEACON: {
                return this.matchesBeacon(pos, blockAccess);
            }
            case CHEST: {
                return this.matchesChest(pos, blockAccess);
            }
            case DISPENSER: {
                return this.matchesDispenser(pos, blockAccess);
            }
            case SHULKER_BOX: {
                return this.matchesShulker(pos, blockAccess);
            }
        }
        return true;
    }

    public static String getName(ckc screen) {
        adr nameable = CustomGuiProperties.getWorldNameable(screen);
        if (nameable == null) {
            return null;
        }
        return nameable.O().d();
    }

    private static adr getWorldNameable(ckc screen) {
        if (screen instanceof ckz) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiBeacon_tileBeacon);
        }
        if (screen instanceof clb) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiBrewingStand_tileBrewingStand);
        }
        if (screen instanceof cld) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiChest_lowerChestInventory);
        }
        if (screen instanceof clh) {
            return ((clh)screen).w;
        }
        if (screen instanceof clk) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiEnchantment_nameable);
        }
        if (screen instanceof cll) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiFurnace_tileFurnace);
        }
        if (screen instanceof clm) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiHopper_hopperInventory);
        }
        if (screen instanceof clr) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiShulkerBox_inventory);
        }
        return null;
    }

    private static adr getWorldNameable(ckc screen, ReflectorField fieldInventory) {
        Object obj = Reflector.getFieldValue(screen, fieldInventory);
        if (!(obj instanceof adr)) {
            return null;
        }
        return (adr)obj;
    }

    private boolean matchesBeacon(el pos, ayd blockAccess) {
        int l;
        bjh te = blockAccess.f(pos);
        if (!(te instanceof bjf)) {
            return false;
        }
        bjf teb = (bjf)te;
        return this.levels == null || this.levels.isInRange(l = teb.s());
    }

    private boolean matchesChest(el pos, ayd blockAccess) {
        bjh te = blockAccess.f(pos);
        if (te instanceof bjk) {
            bjk tec = (bjk)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof bjs) {
            bjs teec = (bjs)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(bjk tec, el pos, ayd blockAccess) {
        blb blockState = blockAccess.a_(pos);
        bmb chestType = blockState.b((bml)bdg.b) ? (bmb)blockState.c((bml)bdg.b) : bmb.a;
        boolean isLarge = chestType == bmb.a;
        boolean isTrapped = tec instanceof bkh;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(bjs teec, el pos, ayd blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(el pos, ayd blockAccess) {
        EnumVariant var;
        bjh te = blockAccess.f(pos);
        if (!(te instanceof bjp)) {
            return false;
        }
        bjp ted = (bjp)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(bjp ted) {
        if (ted instanceof bjq) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(el pos, ayd blockAccess) {
        asb col;
        bjh te = blockAccess.f(pos);
        if (!(te instanceof bka)) {
            return false;
        }
        bka tesb = (bka)te;
        return this.colors == null || Config.equalsOne(col = tesb.D(), this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, aer entity, ayd blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.bH(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.bv())) {
            return false;
        }
        switch (ec) {
            case VILLAGER: {
                return this.matchesVillager(entity, blockAccess);
            }
            case HORSE: {
                return this.matchesHorse(entity, blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(aer entity, ayd blockAccess) {
        if (!(entity instanceof aoa)) {
            return false;
        }
        aoa entityVillager = (aoa)entity;
        if (this.professions != null) {
            int profInt = entityVillager.dy();
            int careerInt = Reflector.getFieldValueInt(entityVillager, Reflector.EntityVillager_careerId, -1);
            if (careerInt < 0) {
                return false;
            }
            boolean matchProfession = false;
            for (int i2 = 0; i2 < this.professions.length; ++i2) {
                VillagerProfession prof = this.professions[i2];
                if (!prof.matches(profInt, careerInt)) continue;
                matchProfession = true;
                break;
            }
            if (!matchProfession) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesHorse(aer entity, ayd blockAccess) {
        akr el2;
        asb col;
        EnumVariant var;
        if (!(entity instanceof akn)) {
            return false;
        }
        akn ah = (akn)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof akr) || Config.equalsOne(col = (el2 = (akr)ah).ej(), this.colors);
    }

    private EnumVariant getHorseVariant(akn entity) {
        if (entity instanceof akp) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof ako) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof aks) {
            return EnumVariant.MULE;
        }
        if (entity instanceof akr) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public pc getTextureLocation(pc loc) {
        pc locNew = this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + (Object)((Object)this.container) + ", textures: " + this.textureLocations;
    }

    private static enum EnumVariant {
        HORSE,
        DONKEY,
        MULE,
        LLAMA,
        DISPENSER,
        DROPPER;

    }

    public static enum EnumContainer {
        ANVIL,
        BEACON,
        BREWING_STAND,
        CHEST,
        CRAFTING,
        DISPENSER,
        ENCHANTMENT,
        FURNACE,
        HOPPER,
        HORSE,
        VILLAGER,
        SHULKER_BOX,
        CREATIVE,
        INVENTORY;

    }
}

