/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.Iterator;
import net.optifine.BlockPosM;
import net.optifine.shaders.IteratorAxis;

public class Iterator3d
implements Iterator<fx> {
    private IteratorAxis iteratorAxis;
    private BlockPosM blockPos = new BlockPosM(0, 0, 0);
    private int axis = 0;
    private int kX;
    private int kY;
    private int kZ;
    private static final int AXIS_X = 0;
    private static final int AXIS_Y = 1;
    private static final int AXIS_Z = 2;

    public Iterator3d(fx posStart, fx posEnd, int width, int height) {
        boolean revX = posStart.u() > posEnd.u();
        boolean revY = posStart.v() > posEnd.v();
        boolean revZ = posStart.w() > posEnd.w();
        posStart = this.reverseCoord(posStart, revX, revY, revZ);
        posEnd = this.reverseCoord(posEnd, revX, revY, revZ);
        this.kX = revX ? -1 : 1;
        this.kY = revY ? -1 : 1;
        this.kZ = revZ ? -1 : 1;
        dcn vec = new dcn((double)(posEnd.u() - posStart.u()), (double)(posEnd.v() - posStart.v()), (double)(posEnd.w() - posStart.w()));
        dcn vecN = vec.d();
        dcn vecX = new dcn(1.0, 0.0, 0.0);
        double dotX = vecN.b(vecX);
        double dotXabs = Math.abs(dotX);
        dcn vecY = new dcn(0.0, 1.0, 0.0);
        double dotY = vecN.b(vecY);
        double dotYabs = Math.abs(dotY);
        dcn vecZ = new dcn(0.0, 0.0, 1.0);
        double dotZ = vecN.b(vecZ);
        double dotZabs = Math.abs(dotZ);
        if (dotZabs >= dotYabs && dotZabs >= dotXabs) {
            this.axis = 2;
            fx pos1 = new fx(posStart.w(), posStart.v() - width, posStart.u() - height);
            fx pos2 = new fx(posEnd.w(), posStart.v() + width + 1, posStart.u() + height + 1);
            int countX = posEnd.w() - posStart.w();
            double deltaY = (double)(posEnd.v() - posStart.v()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.u() - posStart.u()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else if (dotYabs >= dotXabs && dotYabs >= dotZabs) {
            this.axis = 1;
            fx pos1 = new fx(posStart.v(), posStart.u() - width, posStart.w() - height);
            fx pos2 = new fx(posEnd.v(), posStart.u() + width + 1, posStart.w() + height + 1);
            int countX = posEnd.v() - posStart.v();
            double deltaY = (double)(posEnd.u() - posStart.u()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.w() - posStart.w()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        } else {
            this.axis = 0;
            fx pos1 = new fx(posStart.u(), posStart.v() - width, posStart.w() - height);
            fx pos2 = new fx(posEnd.u(), posStart.v() + width + 1, posStart.w() + height + 1);
            int countX = posEnd.u() - posStart.u();
            double deltaY = (double)(posEnd.v() - posStart.v()) / (1.0 * (double)countX);
            double deltaZ = (double)(posEnd.w() - posStart.w()) / (1.0 * (double)countX);
            this.iteratorAxis = new IteratorAxis(pos1, pos2, deltaY, deltaZ);
        }
    }

    private fx reverseCoord(fx pos, boolean revX, boolean revY, boolean revZ) {
        if (revX) {
            pos = new fx(-pos.u(), pos.v(), pos.w());
        }
        if (revY) {
            pos = new fx(pos.u(), -pos.v(), pos.w());
        }
        if (revZ) {
            pos = new fx(pos.u(), pos.v(), -pos.w());
        }
        return pos;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorAxis.hasNext();
    }

    @Override
    public fx next() {
        fx pos = this.iteratorAxis.next();
        switch (this.axis) {
            case 0: {
                this.blockPos.setXyz(pos.u() * this.kX, pos.v() * this.kY, pos.w() * this.kZ);
                return this.blockPos;
            }
            case 1: {
                this.blockPos.setXyz(pos.v() * this.kX, pos.u() * this.kY, pos.w() * this.kZ);
                return this.blockPos;
            }
            case 2: {
                this.blockPos.setXyz(pos.w() * this.kX, pos.v() * this.kY, pos.u() * this.kZ);
                return this.blockPos;
            }
        }
        this.blockPos.setXyz(pos.u() * this.kX, pos.v() * this.kY, pos.w() * this.kZ);
        return this.blockPos;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not supported");
    }

    public static void main(String[] args) {
        fx posStart = new fx(10, 20, 30);
        fx posEnd = new fx(30, 40, 20);
        Iterator3d it = new Iterator3d(posStart, posEnd, 1, 1);
        while (it.hasNext()) {
            fx blockPos = it.next();
            System.out.println("" + blockPos);
        }
    }
}

