/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;
import shadersmod.client.BlockAliases;
import shadersmod.client.CustomTexture;
import shadersmod.client.EnumShaderOption;
import shadersmod.client.HFNoiseTexture;
import shadersmod.client.ICustomTexture;
import shadersmod.client.IShaderPack;
import shadersmod.client.PropertyDefaultFastFancyOff;
import shadersmod.client.PropertyDefaultTrueFalse;
import shadersmod.client.SMath;
import shadersmod.client.ScreenShaderOptions;
import shadersmod.client.ShaderLine;
import shadersmod.client.ShaderOption;
import shadersmod.client.ShaderOptionProfile;
import shadersmod.client.ShaderOptionRest;
import shadersmod.client.ShaderPackDefault;
import shadersmod.client.ShaderPackFolder;
import shadersmod.client.ShaderPackNone;
import shadersmod.client.ShaderPackParser;
import shadersmod.client.ShaderPackZip;
import shadersmod.client.ShaderParser;
import shadersmod.client.ShaderProfile;
import shadersmod.client.ShaderUtils;
import shadersmod.client.ShadersBuiltIn;
import shadersmod.client.ShadersRender;
import shadersmod.client.ShadersTex;
import shadersmod.client.SimpleShaderTexture;
import shadersmod.common.SMCLog;
import shadersmod.uniform.CustomUniforms;
import shadersmod.uniform.LegacyUniforms;
import shadersmod.uniform.ShaderUniformFloat4;
import shadersmod.uniform.ShaderUniformInt;
import shadersmod.uniform.Smoother;

public class Shaders {
    static ave mc;
    static bfk entityRenderer;
    public static boolean isInitializedOnce;
    public static boolean isShaderPackInitialized;
    public static ContextCapabilities capabilities;
    public static String glVersionString;
    public static String glVendorString;
    public static String glRendererString;
    public static boolean hasGlGenMipmap;
    public static boolean hasForge;
    public static int numberResetDisplayList;
    static boolean needResetModels;
    private static int renderDisplayWidth;
    private static int renderDisplayHeight;
    public static int renderWidth;
    public static int renderHeight;
    public static boolean isRenderingWorld;
    public static boolean isRenderingSky;
    public static boolean isCompositeRendered;
    public static boolean isRenderingDfb;
    public static boolean isShadowPass;
    public static boolean isSleeping;
    private static boolean isRenderingFirstPersonHand;
    private static boolean isHandRenderedMain;
    public static boolean renderItemKeepDepthMask;
    public static boolean itemToRenderMainTranslucent;
    static float[] sunPosition;
    static float[] moonPosition;
    static float[] shadowLightPosition;
    static float[] upPosition;
    static float[] shadowLightPositionVector;
    static float[] upPosModelView;
    static float[] sunPosModelView;
    static float[] moonPosModelView;
    private static float[] tempMat;
    static float clearColorR;
    static float clearColorG;
    static float clearColorB;
    static float skyColorR;
    static float skyColorG;
    static float skyColorB;
    static long worldTime;
    static long lastWorldTime;
    static long diffWorldTime;
    static float celestialAngle;
    static float sunAngle;
    static float shadowAngle;
    static int moonPhase;
    static long systemTime;
    static long lastSystemTime;
    static long diffSystemTime;
    static int frameCounter;
    static float frameTime;
    static float frameTimeCounter;
    static int systemTimeInt32;
    static float rainStrength;
    static float wetness;
    public static float wetnessHalfLife;
    public static float drynessHalfLife;
    public static float eyeBrightnessHalflife;
    static boolean usewetness;
    static int isEyeInWater;
    static int eyeBrightness;
    static float eyeBrightnessFadeX;
    static float eyeBrightnessFadeY;
    static float eyePosY;
    static float centerDepth;
    static float centerDepthSmooth;
    static float centerDepthSmoothHalflife;
    static boolean centerDepthSmoothEnabled;
    static int superSamplingLevel;
    static float nightVision;
    static float blindness;
    static boolean updateChunksErrorRecorded;
    static boolean lightmapEnabled;
    static boolean fogEnabled;
    public static int entityAttrib;
    public static int midTexCoordAttrib;
    public static int tangentAttrib;
    public static boolean useEntityAttrib;
    public static boolean useMidTexCoordAttrib;
    public static boolean useMultiTexCoord3Attrib;
    public static boolean useTangentAttrib;
    public static boolean progUseEntityAttrib;
    public static boolean progUseMidTexCoordAttrib;
    public static boolean progUseTangentAttrib;
    public static int atlasSizeX;
    public static int atlasSizeY;
    public static ShaderUniformFloat4 uniformEntityColor;
    public static ShaderUniformInt uniformEntityId;
    public static ShaderUniformInt uniformBlockEntityId;
    static double previousCameraPositionX;
    static double previousCameraPositionY;
    static double previousCameraPositionZ;
    static double cameraPositionX;
    static double cameraPositionY;
    static double cameraPositionZ;
    static int shadowPassInterval;
    public static boolean needResizeShadow;
    static int shadowMapWidth;
    static int shadowMapHeight;
    static int spShadowMapWidth;
    static int spShadowMapHeight;
    static float shadowMapFOV;
    static float shadowMapHalfPlane;
    static boolean shadowMapIsOrtho;
    static float shadowDistanceRenderMul;
    static int shadowPassCounter;
    static int preShadowPassThirdPersonView;
    public static boolean shouldSkipDefaultShadow;
    static boolean waterShadowEnabled;
    static final int MaxDrawBuffers = 8;
    static final int MaxColorBuffers = 8;
    static final int MaxDepthBuffers = 3;
    static final int MaxShadowColorBuffers = 8;
    static final int MaxShadowDepthBuffers = 2;
    static int usedColorBuffers;
    static int usedDepthBuffers;
    static int usedShadowColorBuffers;
    static int usedShadowDepthBuffers;
    static int usedColorAttachs;
    static int usedDrawBuffers;
    static int dfb;
    static int sfb;
    private static int[] gbuffersFormat;
    public static boolean[] gbuffersClear;
    public static int activeProgram;
    public static final int ProgramNone = 0;
    public static final int ProgramBasic = 1;
    public static final int ProgramTextured = 2;
    public static final int ProgramTexturedLit = 3;
    public static final int ProgramSkyBasic = 4;
    public static final int ProgramSkyTextured = 5;
    public static final int ProgramClouds = 6;
    public static final int ProgramTerrain = 7;
    public static final int ProgramTerrainSolid = 8;
    public static final int ProgramTerrainCutoutMip = 9;
    public static final int ProgramTerrainCutout = 10;
    public static final int ProgramDamagedBlock = 11;
    public static final int ProgramWater = 12;
    public static final int ProgramBlock = 13;
    public static final int ProgramBeaconBeam = 14;
    public static final int ProgramItem = 15;
    public static final int ProgramEntities = 16;
    public static final int ProgramArmorGlint = 17;
    public static final int ProgramSpiderEyes = 18;
    public static final int ProgramHand = 19;
    public static final int ProgramWeather = 20;
    public static final int ProgramComposite = 21;
    public static final int ProgramComposite1 = 22;
    public static final int ProgramComposite2 = 23;
    public static final int ProgramComposite3 = 24;
    public static final int ProgramComposite4 = 25;
    public static final int ProgramComposite5 = 26;
    public static final int ProgramComposite6 = 27;
    public static final int ProgramComposite7 = 28;
    public static final int ProgramFinal = 29;
    public static final int ProgramShadow = 30;
    public static final int ProgramShadowSolid = 31;
    public static final int ProgramShadowCutout = 32;
    public static final int ProgramDeferred = 33;
    public static final int ProgramDeferred1 = 34;
    public static final int ProgramDeferred2 = 35;
    public static final int ProgramDeferred3 = 36;
    public static final int ProgramDeferred4 = 37;
    public static final int ProgramDeferred5 = 38;
    public static final int ProgramDeferred6 = 39;
    public static final int ProgramDeferred7 = 40;
    public static final int ProgramHandWater = 41;
    public static final int ProgramDeferredLast = 42;
    public static final int ProgramCompositeLast = 43;
    public static final int ProgramCount = 44;
    public static final int MaxCompositePasses = 8;
    public static final int MaxDeferredPasses = 8;
    private static final String[] programNames;
    private static final int[] programBackups;
    static int[] programsID;
    private static int[] programsRef;
    private static int programIDCopyDepth;
    private static boolean hasDeferredPrograms;
    public static String[] programsDrawBufSettings;
    private static String newDrawBufSetting;
    static IntBuffer[] programsDrawBuffers;
    static IntBuffer activeDrawBuffers;
    private static String[] programsColorAtmSettings;
    private static String newColorAtmSetting;
    private static String activeColorAtmSettings;
    private static int[] programsCompositeMipmapSetting;
    private static int newCompositeMipmapSetting;
    private static int activeCompositeMipmapSetting;
    public static Properties loadedShaders;
    public static Properties shadersConfig;
    public static bmk defaultTexture;
    public static boolean normalMapEnabled;
    public static boolean[] shadowHardwareFilteringEnabled;
    public static boolean[] shadowMipmapEnabled;
    public static boolean[] shadowFilterNearest;
    public static boolean[] shadowColorMipmapEnabled;
    public static boolean[] shadowColorFilterNearest;
    public static boolean configTweakBlockDamage;
    public static boolean configCloudShadow;
    public static float configHandDepthMul;
    public static float configRenderResMul;
    public static float configShadowResMul;
    public static int configTexMinFilB;
    public static int configTexMinFilN;
    public static int configTexMinFilS;
    public static int configTexMagFilB;
    public static int configTexMagFilN;
    public static int configTexMagFilS;
    public static boolean configShadowClipFrustrum;
    public static boolean configNormalMap;
    public static boolean configSpecularMap;
    public static PropertyDefaultTrueFalse configOldLighting;
    public static PropertyDefaultTrueFalse configOldHandLight;
    public static int configAntialiasingLevel;
    public static final int texMinFilRange = 3;
    public static final int texMagFilRange = 2;
    public static final String[] texMinFilDesc;
    public static final String[] texMagFilDesc;
    public static final int[] texMinFilValue;
    public static final int[] texMagFilValue;
    static IShaderPack shaderPack;
    public static boolean shaderPackLoaded;
    static File currentshader;
    static String currentshadername;
    public static String packNameNone;
    static String packNameDefault;
    static String shaderpacksdirname;
    static String optionsfilename;
    static File shadersdir;
    static File shaderpacksdir;
    static File configFile;
    static ShaderOption[] shaderPackOptions;
    static Set<String> shaderPackOptionSliders;
    static ShaderProfile[] shaderPackProfiles;
    static Map<String, ScreenShaderOptions> shaderPackGuiScreens;
    public static PropertyDefaultFastFancyOff shaderPackClouds;
    public static PropertyDefaultTrueFalse shaderPackOldLighting;
    public static PropertyDefaultTrueFalse shaderPackOldHandLight;
    public static PropertyDefaultTrueFalse shaderPackDynamicHandLight;
    public static PropertyDefaultTrueFalse shaderPackShadowTranslucent;
    public static PropertyDefaultTrueFalse shaderPackUnderwaterOverlay;
    public static PropertyDefaultTrueFalse shaderPackSun;
    public static PropertyDefaultTrueFalse shaderPackMoon;
    public static PropertyDefaultTrueFalse shaderPackVignette;
    public static PropertyDefaultTrueFalse shaderPackBackFaceSolid;
    public static PropertyDefaultTrueFalse shaderPackBackFaceCutout;
    public static PropertyDefaultTrueFalse shaderPackBackFaceCutoutMipped;
    public static PropertyDefaultTrueFalse shaderPackBackFaceTranslucent;
    private static Map<String, String> shaderPackResources;
    private static adm currentWorld;
    private static List<Integer> shaderPackDimensions;
    private static CustomTexture[] customTexturesGbuffers;
    private static CustomTexture[] customTexturesComposite;
    private static CustomTexture[] customTexturesDeferred;
    private static String noiseTexturePath;
    private static CustomUniforms customUniforms;
    private static final int STAGE_GBUFFERS = 0;
    private static final int STAGE_COMPOSITE = 1;
    private static final int STAGE_DEFERRED = 2;
    private static final String[] STAGE_NAMES;
    public static final boolean enableShadersOption = true;
    private static final boolean enableShadersDebug = true;
    private static final boolean saveFinalShaders;
    public static float blockLightLevel05;
    public static float blockLightLevel06;
    public static float blockLightLevel08;
    public static float aoLevel;
    public static float sunPathRotation;
    public static float shadowAngleInterval;
    public static int fogMode;
    public static float fogColorR;
    public static float fogColorG;
    public static float fogColorB;
    public static float shadowIntervalSize;
    public static int terrainIconSize;
    public static int[] terrainTextureSize;
    private static ICustomTexture noiseTexture;
    private static boolean noiseTextureEnabled;
    private static int noiseTextureResolution;
    static final int[] dfbColorTexturesA;
    static final int[] colorTexturesToggle;
    static final int[] colorTextureTextureImageUnit;
    static final boolean[][] programsToggleColorTextures;
    private static final int bigBufferSize = 2548;
    private static final ByteBuffer bigBuffer;
    static final float[] faProjection;
    static final float[] faProjectionInverse;
    static final float[] faModelView;
    static final float[] faModelViewInverse;
    static final float[] faShadowProjection;
    static final float[] faShadowProjectionInverse;
    static final float[] faShadowModelView;
    static final float[] faShadowModelViewInverse;
    static final FloatBuffer projection;
    static final FloatBuffer projectionInverse;
    static final FloatBuffer modelView;
    static final FloatBuffer modelViewInverse;
    static final FloatBuffer shadowProjection;
    static final FloatBuffer shadowProjectionInverse;
    static final FloatBuffer shadowModelView;
    static final FloatBuffer shadowModelViewInverse;
    static final FloatBuffer previousProjection;
    static final FloatBuffer previousModelView;
    static final FloatBuffer tempMatrixDirectBuffer;
    static final FloatBuffer tempDirectFloatBuffer;
    static final IntBuffer dfbColorTextures;
    static final IntBuffer dfbDepthTextures;
    static final IntBuffer sfbColorTextures;
    static final IntBuffer sfbDepthTextures;
    static final IntBuffer dfbDrawBuffers;
    static final IntBuffer sfbDrawBuffers;
    static final IntBuffer drawBuffersNone;
    static final IntBuffer drawBuffersAll;
    static final IntBuffer drawBuffersClear0;
    static final IntBuffer drawBuffersClear1;
    static final IntBuffer drawBuffersClearColor;
    static final IntBuffer drawBuffersColorAtt0;
    static final IntBuffer[] drawBuffersBuffer;
    static Map<afh, Integer> mapBlockToEntityData;
    private static final String[] formatNames;
    private static final int[] formatIds;
    private static final Pattern patternLoadEntityDataMap;
    public static int[] entityData;
    public static int entityDataIndex;

    private Shaders() {
    }

    private static ByteBuffer nextByteBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size);
        return buffer.slice();
    }

    private static IntBuffer nextIntBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size * 4);
        return buffer.asIntBuffer();
    }

    private static FloatBuffer nextFloatBuffer(int size) {
        ByteBuffer buffer = bigBuffer;
        int pos = buffer.limit();
        buffer.position(pos).limit(pos + size * 4);
        return buffer.asFloatBuffer();
    }

    private static IntBuffer[] nextIntBufferArray(int count, int size) {
        IntBuffer[] aib2 = new IntBuffer[count];
        for (int i = 0; i < count; ++i) {
            aib2[i] = Shaders.nextIntBuffer(size);
        }
        return aib2;
    }

    public static void loadConfig() {
        SMCLog.info("Load ShadersMod configuration.");
        try {
            if (!shaderpacksdir.exists()) {
                shaderpacksdir.mkdir();
            }
        }
        catch (Exception e) {
            SMCLog.severe("Failed to open the shaderpacks directory: " + shaderpacksdir);
        }
        shadersConfig = new PropertiesOrdered();
        shadersConfig.setProperty(EnumShaderOption.SHADER_PACK.getPropertyKey(), "");
        if (configFile.exists()) {
            try {
                FileReader reader = new FileReader(configFile);
                shadersConfig.load(reader);
                reader.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!configFile.exists()) {
            try {
                Shaders.storeConfig();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        EnumShaderOption[] ops = EnumShaderOption.values();
        for (int i = 0; i < ops.length; ++i) {
            EnumShaderOption op2 = ops[i];
            String key = op2.getPropertyKey();
            String def = op2.getValueDefault();
            String val = shadersConfig.getProperty(key, def);
            Shaders.setEnumShaderOption(op2, val);
        }
        Shaders.loadShaderPack();
    }

    private static void setEnumShaderOption(EnumShaderOption eso, String str) {
        if (str == null) {
            str = eso.getValueDefault();
        }
        switch (eso) {
            case ANTIALIASING: {
                configAntialiasingLevel = Config.parseInt(str, 0);
                break;
            }
            case NORMAL_MAP: {
                configNormalMap = Config.parseBoolean(str, true);
                break;
            }
            case SPECULAR_MAP: {
                configSpecularMap = Config.parseBoolean(str, true);
                break;
            }
            case RENDER_RES_MUL: {
                configRenderResMul = Config.parseFloat(str, 1.0f);
                break;
            }
            case SHADOW_RES_MUL: {
                configShadowResMul = Config.parseFloat(str, 1.0f);
                break;
            }
            case HAND_DEPTH_MUL: {
                configHandDepthMul = Config.parseFloat(str, 0.125f);
                break;
            }
            case CLOUD_SHADOW: {
                configCloudShadow = Config.parseBoolean(str, true);
                break;
            }
            case OLD_HAND_LIGHT: {
                configOldHandLight.setPropertyValue(str);
                break;
            }
            case OLD_LIGHTING: {
                configOldLighting.setPropertyValue(str);
                break;
            }
            case SHADER_PACK: {
                currentshadername = str;
                break;
            }
            case TWEAK_BLOCK_DAMAGE: {
                configTweakBlockDamage = Config.parseBoolean(str, true);
                break;
            }
            case SHADOW_CLIP_FRUSTRUM: {
                configShadowClipFrustrum = Config.parseBoolean(str, true);
                break;
            }
            case TEX_MIN_FIL_B: {
                configTexMinFilB = Config.parseInt(str, 0);
                break;
            }
            case TEX_MIN_FIL_N: {
                configTexMinFilN = Config.parseInt(str, 0);
                break;
            }
            case TEX_MIN_FIL_S: {
                configTexMinFilS = Config.parseInt(str, 0);
                break;
            }
            case TEX_MAG_FIL_B: {
                configTexMagFilB = Config.parseInt(str, 0);
                break;
            }
            case TEX_MAG_FIL_N: {
                configTexMagFilB = Config.parseInt(str, 0);
                break;
            }
            case TEX_MAG_FIL_S: {
                configTexMagFilB = Config.parseInt(str, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown option: " + (Object)((Object)eso));
            }
        }
    }

    public static void storeConfig() {
        SMCLog.info("Save ShadersMod configuration.");
        if (shadersConfig == null) {
            shadersConfig = new PropertiesOrdered();
        }
        EnumShaderOption[] ops = EnumShaderOption.values();
        for (int i = 0; i < ops.length; ++i) {
            EnumShaderOption op2 = ops[i];
            String key = op2.getPropertyKey();
            String val = Shaders.getEnumShaderOption(op2);
            shadersConfig.setProperty(key, val);
        }
        try {
            FileWriter writer = new FileWriter(configFile);
            shadersConfig.store(writer, null);
            writer.close();
        }
        catch (Exception ex) {
            SMCLog.severe("Error saving configuration: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static String getEnumShaderOption(EnumShaderOption eso) {
        switch (eso) {
            case ANTIALIASING: {
                return Integer.toString(configAntialiasingLevel);
            }
            case NORMAL_MAP: {
                return Boolean.toString(configNormalMap);
            }
            case SPECULAR_MAP: {
                return Boolean.toString(configSpecularMap);
            }
            case RENDER_RES_MUL: {
                return Float.toString(configRenderResMul);
            }
            case SHADOW_RES_MUL: {
                return Float.toString(configShadowResMul);
            }
            case HAND_DEPTH_MUL: {
                return Float.toString(configHandDepthMul);
            }
            case CLOUD_SHADOW: {
                return Boolean.toString(configCloudShadow);
            }
            case OLD_HAND_LIGHT: {
                return configOldHandLight.getPropertyValue();
            }
            case OLD_LIGHTING: {
                return configOldLighting.getPropertyValue();
            }
            case SHADER_PACK: {
                return currentshadername;
            }
            case TWEAK_BLOCK_DAMAGE: {
                return Boolean.toString(configTweakBlockDamage);
            }
            case SHADOW_CLIP_FRUSTRUM: {
                return Boolean.toString(configShadowClipFrustrum);
            }
            case TEX_MIN_FIL_B: {
                return Integer.toString(configTexMinFilB);
            }
            case TEX_MIN_FIL_N: {
                return Integer.toString(configTexMinFilN);
            }
            case TEX_MIN_FIL_S: {
                return Integer.toString(configTexMinFilS);
            }
            case TEX_MAG_FIL_B: {
                return Integer.toString(configTexMagFilB);
            }
            case TEX_MAG_FIL_N: {
                return Integer.toString(configTexMagFilB);
            }
            case TEX_MAG_FIL_S: {
                return Integer.toString(configTexMagFilB);
            }
        }
        throw new IllegalArgumentException("Unknown option: " + (Object)((Object)eso));
    }

    public static void setShaderPack(String par1name) {
        currentshadername = par1name;
        shadersConfig.setProperty(EnumShaderOption.SHADER_PACK.getPropertyKey(), par1name);
        Shaders.loadShaderPack();
    }

    public static void loadShaderPack() {
        boolean oldLightingChanged;
        String packName;
        boolean shaderPackLoadedPrev = shaderPackLoaded;
        boolean oldLightingPrev = Shaders.isOldLighting();
        shaderPackLoaded = false;
        if (shaderPack != null) {
            shaderPack.close();
            shaderPack = null;
            shaderPackResources.clear();
            shaderPackDimensions.clear();
            shaderPackOptions = null;
            shaderPackOptionSliders = null;
            shaderPackProfiles = null;
            shaderPackGuiScreens = null;
            shaderPackClouds.resetValue();
            shaderPackOldHandLight.resetValue();
            shaderPackDynamicHandLight.resetValue();
            shaderPackOldLighting.resetValue();
            Shaders.resetCustomTextures();
            noiseTexturePath = null;
        }
        boolean shadersBlocked = false;
        if (Config.isAntialiasing()) {
            SMCLog.info("Shaders can not be loaded, Antialiasing is enabled: " + Config.getAntialiasingLevel() + "x");
            shadersBlocked = true;
        }
        if (Config.isAnisotropicFiltering()) {
            SMCLog.info("Shaders can not be loaded, Anisotropic Filtering is enabled: " + Config.getAnisotropicFilterLevel() + "x");
            shadersBlocked = true;
        }
        if (Config.isFastRender()) {
            SMCLog.info("Shaders can not be loaded, Fast Render is enabled.");
            shadersBlocked = true;
        }
        if (!((packName = shadersConfig.getProperty(EnumShaderOption.SHADER_PACK.getPropertyKey(), packNameDefault)).isEmpty() || packName.equals(packNameNone) || shadersBlocked)) {
            if (packName.equals(packNameDefault)) {
                shaderPack = new ShaderPackDefault();
                shaderPackLoaded = true;
            } else {
                try {
                    File packFile = new File(shaderpacksdir, packName);
                    if (packFile.isDirectory()) {
                        shaderPack = new ShaderPackFolder(packName, packFile);
                        shaderPackLoaded = true;
                    } else if (packFile.isFile() && packName.toLowerCase().endsWith(".zip")) {
                        shaderPack = new ShaderPackZip(packName, packFile);
                        shaderPackLoaded = true;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (shaderPack != null) {
            SMCLog.info("Loaded shaderpack: " + Shaders.getShaderPackName());
        } else {
            SMCLog.info("No shaderpack loaded.");
            shaderPack = new ShaderPackNone();
        }
        Shaders.loadShaderPackResources();
        Shaders.loadShaderPackDimensions();
        shaderPackOptions = Shaders.loadShaderPackOptions();
        Shaders.loadShaderPackProperties();
        boolean formatChanged = shaderPackLoaded != shaderPackLoadedPrev;
        boolean bl = oldLightingChanged = Shaders.isOldLighting() != oldLightingPrev;
        if (formatChanged || oldLightingChanged) {
            bms.updateVertexFormats();
            if (Reflector.LightUtil.exists()) {
                Reflector.LightUtil_itemConsumer.setValue(null);
                Reflector.LightUtil_tessellator.setValue(null);
            }
            Shaders.updateBlockLightLevel();
            if (mc.R() != null) {
                mc.B();
            }
        }
    }

    private static void loadShaderPackDimensions() {
        shaderPackDimensions.clear();
        for (int i = -128; i <= 128; ++i) {
            String worldDir = "/shaders/world" + i;
            if (!shaderPack.hasDirectory(worldDir)) continue;
            shaderPackDimensions.add(i);
        }
        if (shaderPackDimensions.size() > 0) {
            Object[] ids = shaderPackDimensions.toArray(new Integer[shaderPackDimensions.size()]);
            Config.dbg("[Shaders] Worlds: " + Config.arrayToString(ids));
        }
    }

    private static void loadShaderPackProperties() {
        shaderPackClouds.resetValue();
        shaderPackOldHandLight.resetValue();
        shaderPackDynamicHandLight.resetValue();
        shaderPackOldLighting.resetValue();
        shaderPackShadowTranslucent.resetValue();
        shaderPackUnderwaterOverlay.resetValue();
        shaderPackSun.resetValue();
        shaderPackMoon.resetValue();
        shaderPackVignette.resetValue();
        shaderPackBackFaceSolid.resetValue();
        shaderPackBackFaceCutout.resetValue();
        shaderPackBackFaceCutoutMipped.resetValue();
        shaderPackBackFaceTranslucent.resetValue();
        BlockAliases.reset();
        customUniforms = null;
        LegacyUniforms.reset();
        if (shaderPack == null) {
            return;
        }
        BlockAliases.update(shaderPack);
        String path = "/shaders/shaders.properties";
        try {
            InputStream in = shaderPack.getResourceAsStream(path);
            if (in == null) {
                return;
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            shaderPackClouds.loadFrom(props);
            shaderPackOldHandLight.loadFrom(props);
            shaderPackDynamicHandLight.loadFrom(props);
            shaderPackOldLighting.loadFrom(props);
            shaderPackShadowTranslucent.loadFrom(props);
            shaderPackUnderwaterOverlay.loadFrom(props);
            shaderPackSun.loadFrom(props);
            shaderPackVignette.loadFrom(props);
            shaderPackMoon.loadFrom(props);
            shaderPackBackFaceSolid.loadFrom(props);
            shaderPackBackFaceCutout.loadFrom(props);
            shaderPackBackFaceCutoutMipped.loadFrom(props);
            shaderPackBackFaceTranslucent.loadFrom(props);
            shaderPackOptionSliders = ShaderPackParser.parseOptionSliders(props, shaderPackOptions);
            shaderPackProfiles = ShaderPackParser.parseProfiles(props, shaderPackOptions);
            shaderPackGuiScreens = ShaderPackParser.parseGuiScreens(props, shaderPackProfiles, shaderPackOptions);
            customTexturesGbuffers = Shaders.loadCustomTextures(props, 0);
            customTexturesComposite = Shaders.loadCustomTextures(props, 1);
            customTexturesDeferred = Shaders.loadCustomTextures(props, 2);
            noiseTexturePath = props.getProperty("texture.noise");
            if (noiseTexturePath != null) {
                noiseTextureEnabled = true;
            }
            customUniforms = ShaderPackParser.parseCustomUniforms(props);
        }
        catch (IOException e) {
            Config.warn("[Shaders] Error reading: " + path);
        }
    }

    private static CustomTexture[] loadCustomTextures(Properties props, int stage) {
        String PREFIX_TEXTURE = "texture." + STAGE_NAMES[stage] + ".";
        Set<Object> keys = props.keySet();
        ArrayList<CustomTexture> list = new ArrayList<CustomTexture>();
        for (String string : keys) {
            if (!string.startsWith(PREFIX_TEXTURE)) continue;
            String name = string.substring(PREFIX_TEXTURE.length());
            String path = props.getProperty(string).trim();
            int index = Shaders.getTextureIndex(stage, name);
            if (index < 0) {
                SMCLog.warning("Invalid texture name: " + string);
                continue;
            }
            CustomTexture ct = Shaders.loadCustomTexture(index, path);
            if (ct == null) continue;
            list.add(ct);
        }
        if (list.size() <= 0) {
            return null;
        }
        CustomTexture[] cts = list.toArray(new CustomTexture[list.size()]);
        return cts;
    }

    private static CustomTexture loadCustomTexture(int index, String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.trim()).indexOf(46) < 0) {
            path = path + ".png";
        }
        try {
            String pathFull = "shaders/" + StrUtils.removePrefix(path, "/");
            InputStream in = shaderPack.getResourceAsStream(pathFull);
            if (in == null) {
                SMCLog.warning("Texture not found: " + path);
                return null;
            }
            IOUtils.closeQuietly((InputStream)in);
            SimpleShaderTexture tex = new SimpleShaderTexture(pathFull);
            tex.a(mc.Q());
            CustomTexture ct = new CustomTexture(index, pathFull, (bmk)tex);
            return ct;
        }
        catch (IOException e) {
            SMCLog.warning("Error loading texture: " + path);
            SMCLog.warning("" + e.getClass().getName() + ": " + e.getMessage());
            return null;
        }
    }

    private static int getTextureIndex(int stage, String name) {
        if (stage == 0) {
            if (name.equals("texture")) {
                return 0;
            }
            if (name.equals("lightmap")) {
                return 1;
            }
            if (name.equals("normals")) {
                return 2;
            }
            if (name.equals("specular")) {
                return 3;
            }
            if (name.equals("shadowtex0") || name.equals("watershadow")) {
                return 4;
            }
            if (name.equals("shadow")) {
                return waterShadowEnabled ? 5 : 4;
            }
            if (name.equals("shadowtex1")) {
                return 5;
            }
            if (name.equals("depthtex0")) {
                return 6;
            }
            if (name.equals("gaux1")) {
                return 7;
            }
            if (name.equals("gaux2")) {
                return 8;
            }
            if (name.equals("gaux3")) {
                return 9;
            }
            if (name.equals("gaux4")) {
                return 10;
            }
            if (name.equals("depthtex1")) {
                return 12;
            }
            if (name.equals("shadowcolor0") || name.equals("shadowcolor")) {
                return 13;
            }
            if (name.equals("shadowcolor1")) {
                return 14;
            }
            if (name.equals("noisetex")) {
                return 15;
            }
        }
        if (stage == 1 || stage == 2) {
            if (name.equals("colortex0") || name.equals("colortex0")) {
                return 0;
            }
            if (name.equals("colortex1") || name.equals("gdepth")) {
                return 1;
            }
            if (name.equals("colortex2") || name.equals("gnormal")) {
                return 2;
            }
            if (name.equals("colortex3") || name.equals("composite")) {
                return 3;
            }
            if (name.equals("shadowtex0") || name.equals("watershadow")) {
                return 4;
            }
            if (name.equals("shadow")) {
                return waterShadowEnabled ? 5 : 4;
            }
            if (name.equals("shadowtex1")) {
                return 5;
            }
            if (name.equals("depthtex0") || name.equals("gdepthtex")) {
                return 6;
            }
            if (name.equals("colortex4") || name.equals("gaux1")) {
                return 7;
            }
            if (name.equals("colortex5") || name.equals("gaux2")) {
                return 8;
            }
            if (name.equals("colortex6") || name.equals("gaux3")) {
                return 9;
            }
            if (name.equals("colortex7") || name.equals("gaux4")) {
                return 10;
            }
            if (name.equals("depthtex1")) {
                return 11;
            }
            if (name.equals("depthtex2")) {
                return 12;
            }
            if (name.equals("shadowcolor0") || name.equals("shadowcolor")) {
                return 13;
            }
            if (name.equals("shadowcolor1")) {
                return 14;
            }
            if (name.equals("noisetex")) {
                return 15;
            }
        }
        return -1;
    }

    private static void bindCustomTextures(CustomTexture[] cts) {
        if (cts == null) {
            return;
        }
        for (int i = 0; i < cts.length; ++i) {
            CustomTexture ct = cts[i];
            bfl.g((int)(33984 + ct.getTextureUnit()));
            bmk tex = ct.getTexture();
            bfl.i((int)tex.b());
        }
    }

    private static void resetCustomTextures() {
        Shaders.deleteCustomTextures(customTexturesGbuffers);
        Shaders.deleteCustomTextures(customTexturesComposite);
        Shaders.deleteCustomTextures(customTexturesDeferred);
        customTexturesGbuffers = null;
        customTexturesComposite = null;
        customTexturesDeferred = null;
    }

    private static void deleteCustomTextures(CustomTexture[] cts) {
        if (cts == null) {
            return;
        }
        for (int i = 0; i < cts.length; ++i) {
            CustomTexture ct = cts[i];
            ct.deleteTexture();
        }
    }

    public static ShaderOption[] getShaderPackOptions(String screenName) {
        Object[] ops = (ShaderOption[])shaderPackOptions.clone();
        if (shaderPackGuiScreens == null) {
            if (shaderPackProfiles != null) {
                ShaderOptionProfile optionProfile = new ShaderOptionProfile(shaderPackProfiles, (ShaderOption[])ops);
                ops = (ShaderOption[])Config.addObjectToArray(ops, optionProfile, 0);
            }
            ops = Shaders.getVisibleOptions((ShaderOption[])ops);
            return ops;
        }
        String key = screenName != null ? "screen." + screenName : "screen";
        ScreenShaderOptions sso = shaderPackGuiScreens.get(key);
        if (sso == null) {
            return new ShaderOption[0];
        }
        ShaderOption[] sos = sso.getShaderOptions();
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i = 0; i < sos.length; ++i) {
            ShaderOption so = sos[i];
            if (so == null) {
                list.add(null);
                continue;
            }
            if (so instanceof ShaderOptionRest) {
                ShaderOption[] restOps = Shaders.getShaderOptionsRest(shaderPackGuiScreens, (ShaderOption[])ops);
                list.addAll(Arrays.asList(restOps));
                continue;
            }
            list.add(so);
        }
        ShaderOption[] sosExp = list.toArray(new ShaderOption[list.size()]);
        return sosExp;
    }

    public static int getShaderPackColumns(String screenName, int def) {
        String key;
        String string = key = screenName != null ? "screen." + screenName : "screen";
        if (shaderPackGuiScreens == null) {
            return def;
        }
        ScreenShaderOptions sso = shaderPackGuiScreens.get(key);
        if (sso == null) {
            return def;
        }
        return sso.getColumns();
    }

    private static ShaderOption[] getShaderOptionsRest(Map<String, ScreenShaderOptions> mapScreens, ShaderOption[] ops) {
        HashSet<String> setNames = new HashSet<String>();
        Set<String> keys = mapScreens.keySet();
        for (String key : keys) {
            ScreenShaderOptions sso = mapScreens.get(key);
            ShaderOption[] sos = sso.getShaderOptions();
            for (int v = 0; v < sos.length; ++v) {
                ShaderOption so = sos[v];
                if (so == null) continue;
                setNames.add(so.getName());
            }
        }
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i = 0; i < ops.length; ++i) {
            String name;
            ShaderOption so = ops[i];
            if (!so.isVisible() || setNames.contains(name = so.getName())) continue;
            list.add(so);
        }
        ShaderOption[] sos = list.toArray(new ShaderOption[list.size()]);
        return sos;
    }

    public static ShaderOption getShaderOption(String name) {
        return ShaderUtils.getShaderOption(name, shaderPackOptions);
    }

    public static ShaderOption[] getShaderPackOptions() {
        return shaderPackOptions;
    }

    public static boolean isShaderPackOptionSlider(String name) {
        if (shaderPackOptionSliders == null) {
            return false;
        }
        return shaderPackOptionSliders.contains(name);
    }

    private static ShaderOption[] getVisibleOptions(ShaderOption[] ops) {
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i = 0; i < ops.length; ++i) {
            ShaderOption so = ops[i];
            if (!so.isVisible()) continue;
            list.add(so);
        }
        ShaderOption[] sos = list.toArray(new ShaderOption[list.size()]);
        return sos;
    }

    public static void saveShaderPackOptions() {
        Shaders.saveShaderPackOptions(shaderPackOptions, shaderPack);
    }

    private static void saveShaderPackOptions(ShaderOption[] sos, IShaderPack sp) {
        Properties props = new Properties();
        if (shaderPackOptions != null) {
            for (int i = 0; i < sos.length; ++i) {
                ShaderOption so = sos[i];
                if (!so.isChanged() || !so.isEnabled()) continue;
                props.setProperty(so.getName(), so.getValue());
            }
        }
        try {
            Shaders.saveOptionProperties(sp, props);
        }
        catch (IOException e) {
            Config.warn("[Shaders] Error saving configuration for " + shaderPack.getName());
            e.printStackTrace();
        }
    }

    private static void saveOptionProperties(IShaderPack sp, Properties props) throws IOException {
        String path = shaderpacksdirname + "/" + sp.getName() + ".txt";
        File propFile = new File(ave.A().v, path);
        if (props.isEmpty()) {
            propFile.delete();
            return;
        }
        FileOutputStream fos = new FileOutputStream(propFile);
        props.store(fos, null);
        fos.flush();
        fos.close();
    }

    private static ShaderOption[] loadShaderPackOptions() {
        try {
            ShaderOption[] sos = ShaderPackParser.parseShaderPackOptions(shaderPack, programNames, shaderPackDimensions);
            Properties props = Shaders.loadOptionProperties(shaderPack);
            for (int i = 0; i < sos.length; ++i) {
                ShaderOption so = sos[i];
                String val = props.getProperty(so.getName());
                if (val == null) continue;
                so.resetValue();
                if (so.setValue(val)) continue;
                Config.warn("[Shaders] Invalid value, option: " + so.getName() + ", value: " + val);
            }
            return sos;
        }
        catch (IOException e) {
            Config.warn("[Shaders] Error reading configuration for " + shaderPack.getName());
            e.printStackTrace();
            return null;
        }
    }

    private static Properties loadOptionProperties(IShaderPack sp) throws IOException {
        Properties props = new Properties();
        String path = shaderpacksdirname + "/" + sp.getName() + ".txt";
        File propFile = new File(ave.A().v, path);
        if (!(propFile.exists() && propFile.isFile() && propFile.canRead())) {
            return props;
        }
        FileInputStream fis = new FileInputStream(propFile);
        props.load(fis);
        fis.close();
        return props;
    }

    public static ShaderOption[] getChangedOptions(ShaderOption[] ops) {
        ArrayList<ShaderOption> list = new ArrayList<ShaderOption>();
        for (int i = 0; i < ops.length; ++i) {
            ShaderOption op2 = ops[i];
            if (!op2.isEnabled() || !op2.isChanged()) continue;
            list.add(op2);
        }
        ShaderOption[] cops = list.toArray(new ShaderOption[list.size()]);
        return cops;
    }

    private static String applyOptions(String line, ShaderOption[] ops) {
        if (ops == null || ops.length <= 0) {
            return line;
        }
        for (int i = 0; i < ops.length; ++i) {
            ShaderOption op2 = ops[i];
            String opName = op2.getName();
            if (!op2.matchesLine(line)) continue;
            line = op2.getSourceLine();
            break;
        }
        return line;
    }

    static ArrayList listOfShaders() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(packNameNone);
        list.add(packNameDefault);
        try {
            if (!shaderpacksdir.exists()) {
                shaderpacksdir.mkdir();
            }
            File[] listOfFiles = shaderpacksdir.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                File file = listOfFiles[i];
                String name = file.getName();
                if (file.isDirectory()) {
                    File subDir;
                    if (name.equals("debug") || !(subDir = new File(file, "shaders")).exists() || !subDir.isDirectory()) continue;
                    list.add(name);
                    continue;
                }
                if (!file.isFile() || !name.toLowerCase().endsWith(".zip")) continue;
                list.add(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    static String versiontostring(int vv) {
        String vs = Integer.toString(vv);
        return Integer.toString(Integer.parseInt(vs.substring(1, 3))) + "." + Integer.toString(Integer.parseInt(vs.substring(3, 5))) + "." + Integer.toString(Integer.parseInt(vs.substring(5)));
    }

    static void checkOptifine() {
    }

    public static int checkFramebufferStatus(String location) {
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status != 36053) {
            System.err.format("FramebufferStatus 0x%04X at %s\n", status, location);
        }
        return status;
    }

    public static int checkGLError(String location) {
        boolean skipPrint;
        int errorCode = GL11.glGetError();
        if (errorCode != 0 && !(skipPrint = false)) {
            if (errorCode == 1286) {
                int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
                System.err.format("GL error 0x%04X: %s (Fb status 0x%04X) at %s\n", errorCode, GLU.gluErrorString((int)errorCode), status, location);
            } else {
                System.err.format("GL error 0x%04X: %s at %s\n", errorCode, GLU.gluErrorString((int)errorCode), location);
            }
        }
        return errorCode;
    }

    public static int checkGLError(String location, String info) {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            System.err.format("GL error 0x%04x: %s at %s %s\n", errorCode, GLU.gluErrorString((int)errorCode), location, info);
        }
        return errorCode;
    }

    public static int checkGLError(String location, String info1, String info2) {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            System.err.format("GL error 0x%04x: %s at %s %s %s\n", errorCode, GLU.gluErrorString((int)errorCode), location, info1, info2);
        }
        return errorCode;
    }

    private static void printChat(String str) {
        Shaders.mc.q.d().a((eu)new fa(str));
    }

    private static void printChatAndLogError(String str) {
        SMCLog.severe(str);
        Shaders.mc.q.d().a((eu)new fa(str));
    }

    public static void printIntBuffer(String title, IntBuffer buf) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(title).append(" [pos ").append(buf.position()).append(" lim ").append(buf.limit()).append(" cap ").append(buf.capacity()).append(" :");
        int lim = buf.limit();
        for (int i = 0; i < lim; ++i) {
            sb.append(" ").append(buf.get(i));
        }
        sb.append("]");
        SMCLog.info(sb.toString());
    }

    public static void startup(ave mc) {
        Shaders.checkShadersModInstalled();
        Shaders.mc = mc;
        mc = ave.A();
        capabilities = GLContext.getCapabilities();
        glVersionString = GL11.glGetString((int)7938);
        glVendorString = GL11.glGetString((int)7936);
        glRendererString = GL11.glGetString((int)7937);
        SMCLog.info("ShadersMod version: 2.4.12");
        SMCLog.info("OpenGL Version: " + glVersionString);
        SMCLog.info("Vendor:  " + glVendorString);
        SMCLog.info("Renderer: " + glRendererString);
        SMCLog.info("Capabilities: " + (Shaders.capabilities.OpenGL20 ? " 2.0 " : " - ") + (Shaders.capabilities.OpenGL21 ? " 2.1 " : " - ") + (Shaders.capabilities.OpenGL30 ? " 3.0 " : " - ") + (Shaders.capabilities.OpenGL32 ? " 3.2 " : " - ") + (Shaders.capabilities.OpenGL40 ? " 4.0 " : " - "));
        SMCLog.info("GL_MAX_DRAW_BUFFERS: " + GL11.glGetInteger((int)34852));
        SMCLog.info("GL_MAX_COLOR_ATTACHMENTS_EXT: " + GL11.glGetInteger((int)36063));
        SMCLog.info("GL_MAX_TEXTURE_IMAGE_UNITS: " + GL11.glGetInteger((int)34930));
        hasGlGenMipmap = Shaders.capabilities.OpenGL30;
        Shaders.loadConfig();
    }

    private static String toStringYN(boolean b2) {
        return b2 ? "Y" : "N";
    }

    public static void updateBlockLightLevel() {
        if (Shaders.isOldLighting()) {
            blockLightLevel05 = 0.5f;
            blockLightLevel06 = 0.6f;
            blockLightLevel08 = 0.8f;
        } else {
            blockLightLevel05 = 1.0f;
            blockLightLevel06 = 1.0f;
            blockLightLevel08 = 1.0f;
        }
    }

    public static boolean isOldHandLight() {
        if (!configOldHandLight.isDefault()) {
            return configOldHandLight.isTrue();
        }
        if (!shaderPackOldHandLight.isDefault()) {
            return shaderPackOldHandLight.isTrue();
        }
        return true;
    }

    public static boolean isDynamicHandLight() {
        if (!shaderPackDynamicHandLight.isDefault()) {
            return shaderPackDynamicHandLight.isTrue();
        }
        return true;
    }

    public static boolean isOldLighting() {
        if (!configOldLighting.isDefault()) {
            return configOldLighting.isTrue();
        }
        if (!shaderPackOldLighting.isDefault()) {
            return shaderPackOldLighting.isTrue();
        }
        return true;
    }

    public static boolean isRenderShadowTranslucent() {
        return !shaderPackShadowTranslucent.isFalse();
    }

    public static boolean isUnderwaterOverlay() {
        return !shaderPackUnderwaterOverlay.isFalse();
    }

    public static boolean isSun() {
        return !shaderPackSun.isFalse();
    }

    public static boolean isMoon() {
        return !shaderPackMoon.isFalse();
    }

    public static boolean isVignette() {
        return !shaderPackVignette.isFalse();
    }

    public static boolean isRenderBackFace(adf blockLayerIn) {
        switch (blockLayerIn) {
            case a: {
                return shaderPackBackFaceSolid.isTrue();
            }
            case c: {
                return shaderPackBackFaceCutout.isTrue();
            }
            case b: {
                return shaderPackBackFaceCutoutMipped.isTrue();
            }
            case d: {
                return shaderPackBackFaceTranslucent.isTrue();
            }
        }
        return false;
    }

    public static void init() {
        boolean firstInit;
        if (!isInitializedOnce) {
            isInitializedOnce = true;
            firstInit = true;
        } else {
            firstInit = false;
        }
        if (!isShaderPackInitialized) {
            int i;
            int dimId;
            Shaders.checkGLError("Shaders.init pre");
            if (Shaders.getShaderPackName() != null) {
                // empty if block
            }
            if (!Shaders.capabilities.OpenGL20) {
                Shaders.printChatAndLogError("No OpenGL 2.0");
            }
            if (!Shaders.capabilities.GL_EXT_framebuffer_object) {
                Shaders.printChatAndLogError("No EXT_framebuffer_object");
            }
            dfbDrawBuffers.position(0).limit(8);
            dfbColorTextures.position(0).limit(16);
            dfbDepthTextures.position(0).limit(3);
            sfbDrawBuffers.position(0).limit(8);
            sfbDepthTextures.position(0).limit(2);
            sfbColorTextures.position(0).limit(8);
            usedColorBuffers = 4;
            usedDepthBuffers = 1;
            usedShadowColorBuffers = 0;
            usedShadowDepthBuffers = 0;
            usedColorAttachs = 1;
            usedDrawBuffers = 1;
            Arrays.fill(gbuffersFormat, 6408);
            Arrays.fill(gbuffersClear, true);
            Arrays.fill(shadowHardwareFilteringEnabled, false);
            Arrays.fill(shadowMipmapEnabled, false);
            Arrays.fill(shadowFilterNearest, false);
            Arrays.fill(shadowColorMipmapEnabled, false);
            Arrays.fill(shadowColorFilterNearest, false);
            centerDepthSmoothEnabled = false;
            noiseTextureEnabled = false;
            sunPathRotation = 0.0f;
            shadowIntervalSize = 2.0f;
            shadowMapWidth = 1024;
            shadowMapHeight = 1024;
            spShadowMapWidth = 1024;
            spShadowMapHeight = 1024;
            shadowMapFOV = 90.0f;
            shadowMapHalfPlane = 160.0f;
            shadowMapIsOrtho = true;
            shadowDistanceRenderMul = -1.0f;
            aoLevel = -1.0f;
            useEntityAttrib = false;
            useMidTexCoordAttrib = false;
            useMultiTexCoord3Attrib = false;
            useTangentAttrib = false;
            waterShadowEnabled = false;
            updateChunksErrorRecorded = false;
            Shaders.updateBlockLightLevel();
            Smoother.reset();
            LegacyUniforms.reset();
            ShaderProfile activeProfile = ShaderUtils.detectProfile(shaderPackProfiles, shaderPackOptions, false);
            String worldPrefix = "";
            if (currentWorld != null && shaderPackDimensions.contains(dimId = Shaders.currentWorld.t.q())) {
                worldPrefix = "world" + dimId + "/";
            }
            if (saveFinalShaders) {
                Shaders.clearDirectory(new File(shaderpacksdir, "debug"));
            }
            for (int i2 = 0; i2 < 44; ++i2) {
                String programFullPath;
                int pr2;
                String programName = programNames[i2];
                if (programName.equals("")) {
                    Shaders.programsRef[i2] = 0;
                    Shaders.programsID[i2] = 0;
                    Shaders.programsDrawBufSettings[i2] = null;
                    Shaders.programsColorAtmSettings[i2] = null;
                    Shaders.programsCompositeMipmapSetting[i2] = 0;
                    continue;
                }
                newDrawBufSetting = null;
                newColorAtmSetting = null;
                newCompositeMipmapSetting = 0;
                String programPath = worldPrefix + programName;
                if (activeProfile != null && activeProfile.isProgramDisabled(programPath)) {
                    SMCLog.info("Program disabled: " + programPath);
                    programName = "<disabled>";
                    programPath = worldPrefix + programName;
                }
                if ((pr2 = Shaders.setupProgram(i2, (programFullPath = "/shaders/" + programPath) + ".vsh", programFullPath + ".fsh")) > 0) {
                    SMCLog.info("Program loaded: " + programPath);
                }
                Shaders.programsID[i2] = Shaders.programsRef[i2] = pr2;
                Shaders.programsDrawBufSettings[i2] = pr2 != 0 ? newDrawBufSetting : null;
                Shaders.programsColorAtmSettings[i2] = pr2 != 0 ? newColorAtmSetting : null;
                Shaders.programsCompositeMipmapSetting[i2] = pr2 != 0 ? newCompositeMipmapSetting : 0;
            }
            int maxDrawBuffers = GL11.glGetInteger((int)34852);
            HashMap drawBuffersMap = new HashMap();
            for (int p = 0; p < 44; ++p) {
                Arrays.fill(programsToggleColorTextures[p], false);
                if (p == 29) {
                    Shaders.programsDrawBuffers[p] = null;
                    continue;
                }
                if (programsID[p] == 0) {
                    if (p == 30) {
                        Shaders.programsDrawBuffers[p] = drawBuffersNone;
                        continue;
                    }
                    Shaders.programsDrawBuffers[p] = drawBuffersColorAtt0;
                    continue;
                }
                String str = programsDrawBufSettings[p];
                if (str != null) {
                    IntBuffer intbuf = drawBuffersBuffer[p];
                    int numDB = str.length();
                    if (numDB > usedDrawBuffers) {
                        usedDrawBuffers = numDB;
                    }
                    if (numDB > maxDrawBuffers) {
                        numDB = maxDrawBuffers;
                    }
                    Shaders.programsDrawBuffers[p] = intbuf;
                    intbuf.limit(numDB);
                    for (int i3 = 0; i3 < numDB; ++i3) {
                        int drawBuffer = 0;
                        if (str.length() > i3) {
                            int ca = str.charAt(i3) - 48;
                            if (p != 30) {
                                if (ca >= 0 && ca <= 7) {
                                    Shaders.programsToggleColorTextures[p][ca] = true;
                                    drawBuffer = ca + 36064;
                                    if (ca > usedColorAttachs) {
                                        usedColorAttachs = ca;
                                    }
                                    if (ca > usedColorBuffers) {
                                        usedColorBuffers = ca;
                                    }
                                }
                            } else if (ca >= 0 && ca <= 1) {
                                drawBuffer = ca + 36064;
                                if (ca > usedShadowColorBuffers) {
                                    usedShadowColorBuffers = ca;
                                }
                            }
                        }
                        intbuf.put(i3, drawBuffer);
                    }
                    continue;
                }
                if (p != 30 && p != 31 && p != 32) {
                    Shaders.programsDrawBuffers[p] = dfbDrawBuffers;
                    usedDrawBuffers = usedColorBuffers;
                    Arrays.fill(programsToggleColorTextures[p], 0, usedColorBuffers, true);
                    continue;
                }
                Shaders.programsDrawBuffers[p] = sfbDrawBuffers;
            }
            hasDeferredPrograms = false;
            for (int cp = 0; cp < 8; ++cp) {
                if (programsID[33 + cp] == 0) continue;
                hasDeferredPrograms = true;
                break;
            }
            usedColorAttachs = usedColorBuffers;
            shadowPassInterval = usedShadowDepthBuffers > 0 ? 1 : 0;
            shouldSkipDefaultShadow = usedShadowDepthBuffers > 0;
            SMCLog.info("usedColorBuffers: " + usedColorBuffers);
            SMCLog.info("usedDepthBuffers: " + usedDepthBuffers);
            SMCLog.info("usedShadowColorBuffers: " + usedShadowColorBuffers);
            SMCLog.info("usedShadowDepthBuffers: " + usedShadowDepthBuffers);
            SMCLog.info("usedColorAttachs: " + usedColorAttachs);
            SMCLog.info("usedDrawBuffers: " + usedDrawBuffers);
            dfbDrawBuffers.position(0).limit(usedDrawBuffers);
            dfbColorTextures.position(0).limit(usedColorBuffers * 2);
            for (i = 0; i < usedDrawBuffers; ++i) {
                dfbDrawBuffers.put(i, 36064 + i);
            }
            if (usedDrawBuffers > maxDrawBuffers) {
                Shaders.printChatAndLogError("[Shaders] Error: Not enough draw buffers, needed: " + usedDrawBuffers + ", available: " + maxDrawBuffers);
            }
            sfbDrawBuffers.position(0).limit(usedShadowColorBuffers);
            for (i = 0; i < usedShadowColorBuffers; ++i) {
                sfbDrawBuffers.put(i, 36064 + i);
            }
            for (i = 0; i < 44; ++i) {
                int n = i;
                while (programsID[n] == 0 && programBackups[n] != n) {
                    n = programBackups[n];
                }
                if (n == i || i == 30) continue;
                Shaders.programsID[i] = programsID[n];
                Shaders.programsDrawBufSettings[i] = programsDrawBufSettings[n];
                Shaders.programsDrawBuffers[i] = programsDrawBuffers[n];
            }
            Shaders.resize();
            Shaders.resizeShadow();
            if (noiseTextureEnabled) {
                Shaders.setupNoiseTexture();
            }
            if (defaultTexture == null) {
                defaultTexture = ShadersTex.createDefaultTexture();
            }
            bfl.E();
            bfl.b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Shaders.preCelestialRotate();
            Shaders.postCelestialRotate();
            bfl.F();
            isShaderPackInitialized = true;
            Shaders.loadEntityDataMap();
            Shaders.resetDisplayList();
            if (!firstInit) {
                // empty if block
            }
            Shaders.checkGLError("Shaders.init");
        }
    }

    public static void resetDisplayList() {
        ++numberResetDisplayList;
        needResetModels = true;
        SMCLog.info("Reset world renderers");
        Shaders.mc.g.a();
    }

    public static void resetDisplayListModels() {
        if (needResetModels) {
            needResetModels = false;
            SMCLog.info("Reset model renderers");
            for (biv ren : mc.af().getEntityRenderMap().values()) {
                if (!(ren instanceof bjl)) continue;
                bjl rle = (bjl)ren;
                Shaders.resetDisplayListModel(rle.b());
            }
        }
    }

    public static void resetDisplayListModel(bbo model) {
        if (model != null) {
            for (Object obj : model.s) {
                if (!(obj instanceof bct)) continue;
                Shaders.resetDisplayListModelRenderer((bct)obj);
            }
        }
    }

    public static void resetDisplayListModelRenderer(bct mrr) {
        mrr.resetDisplayList();
        if (mrr.m != null) {
            int n = mrr.m.size();
            for (int i = 0; i < n; ++i) {
                Shaders.resetDisplayListModelRenderer((bct)mrr.m.get(i));
            }
        }
    }

    private static int setupProgram(int program, String vShaderPath, String fShaderPath) {
        Shaders.checkGLError("pre setupProgram");
        int programid = ARBShaderObjects.glCreateProgramObjectARB();
        Shaders.checkGLError("create");
        if (programid != 0) {
            progUseEntityAttrib = false;
            progUseMidTexCoordAttrib = false;
            progUseTangentAttrib = false;
            int vShader = Shaders.createVertShader(vShaderPath);
            int fShader = Shaders.createFragShader(fShaderPath);
            Shaders.checkGLError("create");
            if (vShader != 0 || fShader != 0) {
                if (vShader != 0) {
                    ARBShaderObjects.glAttachObjectARB((int)programid, (int)vShader);
                    Shaders.checkGLError("attach");
                }
                if (fShader != 0) {
                    ARBShaderObjects.glAttachObjectARB((int)programid, (int)fShader);
                    Shaders.checkGLError("attach");
                }
                if (progUseEntityAttrib) {
                    ARBVertexShader.glBindAttribLocationARB((int)programid, (int)entityAttrib, (CharSequence)"mc_Entity");
                    Shaders.checkGLError("mc_Entity");
                }
                if (progUseMidTexCoordAttrib) {
                    ARBVertexShader.glBindAttribLocationARB((int)programid, (int)midTexCoordAttrib, (CharSequence)"mc_midTexCoord");
                    Shaders.checkGLError("mc_midTexCoord");
                }
                if (progUseTangentAttrib) {
                    ARBVertexShader.glBindAttribLocationARB((int)programid, (int)tangentAttrib, (CharSequence)"at_tangent");
                    Shaders.checkGLError("at_tangent");
                }
                ARBShaderObjects.glLinkProgramARB((int)programid);
                if (GL20.glGetProgrami((int)programid, (int)35714) != 1) {
                    SMCLog.severe("Error linking program: " + programid);
                }
                Shaders.printLogInfo(programid, vShaderPath + ", " + fShaderPath);
                if (vShader != 0) {
                    ARBShaderObjects.glDetachObjectARB((int)programid, (int)vShader);
                    ARBShaderObjects.glDeleteObjectARB((int)vShader);
                }
                if (fShader != 0) {
                    ARBShaderObjects.glDetachObjectARB((int)programid, (int)fShader);
                    ARBShaderObjects.glDeleteObjectARB((int)fShader);
                }
                Shaders.programsID[program] = programid;
                Shaders.useProgram(program);
                ARBShaderObjects.glValidateProgramARB((int)programid);
                Shaders.useProgram(0);
                Shaders.printLogInfo(programid, vShaderPath + ", " + fShaderPath);
                int valid = GL20.glGetProgrami((int)programid, (int)35715);
                if (valid != 1) {
                    String Q = "\"";
                    Shaders.printChatAndLogError("[Shaders] Error: Invalid program " + Q + programNames[program] + Q);
                    ARBShaderObjects.glDeleteObjectARB((int)programid);
                    programid = 0;
                }
            } else {
                ARBShaderObjects.glDeleteObjectARB((int)programid);
                programid = 0;
            }
        }
        return programid;
    }

    private static int createVertShader(String filename) {
        int vertShader = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
        if (vertShader == 0) {
            return 0;
        }
        StringBuilder vertexCode = new StringBuilder(131072);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(Shaders.getShaderReader(filename));
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)vertShader);
            return 0;
        }
        ShaderOption[] activeOptions = Shaders.getChangedOptions(shaderPackOptions);
        ArrayList<String> listFiles = new ArrayList<String>();
        if (reader != null) {
            try {
                String line;
                reader = ShaderPackParser.resolveIncludes(reader, filename, shaderPack, 0, listFiles, 0);
                while ((line = reader.readLine()) != null) {
                    line = Shaders.applyOptions(line, activeOptions);
                    vertexCode.append(line).append('\n');
                    ShaderLine sl = ShaderParser.parseLine(line);
                    if (sl == null) continue;
                    if (sl.isAttribute("mc_Entity")) {
                        useEntityAttrib = true;
                        progUseEntityAttrib = true;
                        continue;
                    }
                    if (sl.isAttribute("mc_midTexCoord")) {
                        useMidTexCoordAttrib = true;
                        progUseMidTexCoordAttrib = true;
                        continue;
                    }
                    if (line.contains("gl_MultiTexCoord3")) {
                        useMultiTexCoord3Attrib = true;
                        continue;
                    }
                    if (!sl.isAttribute("at_tangent")) continue;
                    useTangentAttrib = true;
                    progUseTangentAttrib = true;
                }
                reader.close();
            }
            catch (Exception e) {
                SMCLog.severe("Couldn't read " + filename + "!");
                e.printStackTrace();
                ARBShaderObjects.glDeleteObjectARB((int)vertShader);
                return 0;
            }
        }
        if (saveFinalShaders) {
            Shaders.saveShader(filename, vertexCode.toString());
        }
        ARBShaderObjects.glShaderSourceARB((int)vertShader, (CharSequence)vertexCode);
        ARBShaderObjects.glCompileShaderARB((int)vertShader);
        if (GL20.glGetShaderi((int)vertShader, (int)35713) != 1) {
            SMCLog.severe("Error compiling vertex shader: " + filename);
        }
        Shaders.printShaderLogInfo(vertShader, filename, listFiles);
        return vertShader;
    }

    private static int createFragShader(String filename) {
        int fragShader = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
        if (fragShader == 0) {
            return 0;
        }
        StringBuilder fragCode = new StringBuilder(131072);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(Shaders.getShaderReader(filename));
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)fragShader);
            return 0;
        }
        ShaderOption[] activeOptions = Shaders.getChangedOptions(shaderPackOptions);
        ArrayList<String> listFiles = new ArrayList<String>();
        if (reader != null) {
            try {
                String line;
                reader = ShaderPackParser.resolveIncludes(reader, filename, shaderPack, 0, listFiles, 0);
                while ((line = reader.readLine()) != null) {
                    String name;
                    line = Shaders.applyOptions(line, activeOptions);
                    fragCode.append(line).append('\n');
                    ShaderLine sl = ShaderParser.parseLine(line);
                    if (sl == null) continue;
                    if (sl.isUniform()) {
                        String uniform = sl.getName();
                        int index = ShaderParser.getShadowDepthIndex(uniform);
                        if (index >= 0) {
                            usedShadowDepthBuffers = Math.max(usedShadowDepthBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getShadowColorIndex(uniform);
                        if (index >= 0) {
                            usedShadowColorBuffers = Math.max(usedShadowColorBuffers, index + 1);
                            continue;
                        }
                        index = ShaderParser.getDepthIndex(uniform);
                        if (index >= 0) {
                            usedDepthBuffers = Math.max(usedDepthBuffers, index + 1);
                            continue;
                        }
                        if (uniform.equals("gdepth") && gbuffersFormat[1] == 6408) {
                            Shaders.gbuffersFormat[1] = 34836;
                            continue;
                        }
                        index = ShaderParser.getColorIndex(uniform);
                        if (index >= 0) {
                            usedColorBuffers = Math.max(usedColorBuffers, index + 1);
                            continue;
                        }
                        if (!uniform.equals("centerDepthSmooth")) continue;
                        centerDepthSmoothEnabled = true;
                        continue;
                    }
                    if (sl.isConstInt("shadowMapResolution") || sl.isProperty("SHADOWRES")) {
                        spShadowMapWidth = spShadowMapHeight = sl.getValueInt();
                        shadowMapWidth = shadowMapHeight = Math.round((float)spShadowMapWidth * configShadowResMul);
                        SMCLog.info("Shadow map resolution: " + spShadowMapWidth);
                        continue;
                    }
                    if (sl.isConstFloat("shadowMapFov") || sl.isProperty("SHADOWFOV")) {
                        shadowMapFOV = sl.getValueFloat();
                        shadowMapIsOrtho = false;
                        SMCLog.info("Shadow map field of view: " + shadowMapFOV);
                        continue;
                    }
                    if (sl.isConstFloat("shadowDistance") || sl.isProperty("SHADOWHPL")) {
                        shadowMapHalfPlane = sl.getValueFloat();
                        shadowMapIsOrtho = true;
                        SMCLog.info("Shadow map distance: " + shadowMapHalfPlane);
                        continue;
                    }
                    if (sl.isConstFloat("shadowDistanceRenderMul")) {
                        shadowDistanceRenderMul = sl.getValueFloat();
                        SMCLog.info("Shadow distance render mul: " + shadowDistanceRenderMul);
                        continue;
                    }
                    if (sl.isConstFloat("shadowIntervalSize")) {
                        shadowIntervalSize = sl.getValueFloat();
                        SMCLog.info("Shadow map interval size: " + shadowIntervalSize);
                        continue;
                    }
                    if (sl.isConstBool("generateShadowMipmap", true)) {
                        Arrays.fill(shadowMipmapEnabled, true);
                        SMCLog.info("Generate shadow mipmap");
                        continue;
                    }
                    if (sl.isConstBool("generateShadowColorMipmap", true)) {
                        Arrays.fill(shadowColorMipmapEnabled, true);
                        SMCLog.info("Generate shadow color mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowHardwareFiltering", true)) {
                        Arrays.fill(shadowHardwareFilteringEnabled, true);
                        SMCLog.info("Hardware shadow filtering enabled.");
                        continue;
                    }
                    if (sl.isConstBool("shadowHardwareFiltering0", true)) {
                        Shaders.shadowHardwareFilteringEnabled[0] = true;
                        SMCLog.info("shadowHardwareFiltering0");
                        continue;
                    }
                    if (sl.isConstBool("shadowHardwareFiltering1", true)) {
                        Shaders.shadowHardwareFilteringEnabled[1] = true;
                        SMCLog.info("shadowHardwareFiltering1");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex0Mipmap", "shadowtexMipmap", true)) {
                        Shaders.shadowMipmapEnabled[0] = true;
                        SMCLog.info("shadowtex0Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex1Mipmap", true)) {
                        Shaders.shadowMipmapEnabled[1] = true;
                        SMCLog.info("shadowtex1Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor0Mipmap", "shadowColor0Mipmap", true)) {
                        Shaders.shadowColorMipmapEnabled[0] = true;
                        SMCLog.info("shadowcolor0Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor1Mipmap", "shadowColor1Mipmap", true)) {
                        Shaders.shadowColorMipmapEnabled[1] = true;
                        SMCLog.info("shadowcolor1Mipmap");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex0Nearest", "shadowtexNearest", "shadow0MinMagNearest", true)) {
                        Shaders.shadowFilterNearest[0] = true;
                        SMCLog.info("shadowtex0Nearest");
                        continue;
                    }
                    if (sl.isConstBool("shadowtex1Nearest", "shadow1MinMagNearest", true)) {
                        Shaders.shadowFilterNearest[1] = true;
                        SMCLog.info("shadowtex1Nearest");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor0Nearest", "shadowColor0Nearest", "shadowColor0MinMagNearest", true)) {
                        Shaders.shadowColorFilterNearest[0] = true;
                        SMCLog.info("shadowcolor0Nearest");
                        continue;
                    }
                    if (sl.isConstBool("shadowcolor1Nearest", "shadowColor1Nearest", "shadowColor1MinMagNearest", true)) {
                        Shaders.shadowColorFilterNearest[1] = true;
                        SMCLog.info("shadowcolor1Nearest");
                        continue;
                    }
                    if (sl.isConstFloat("wetnessHalflife") || sl.isProperty("WETNESSHL")) {
                        wetnessHalfLife = sl.getValueFloat();
                        SMCLog.info("Wetness halflife: " + wetnessHalfLife);
                        continue;
                    }
                    if (sl.isConstFloat("drynessHalflife") || sl.isProperty("DRYNESSHL")) {
                        drynessHalfLife = sl.getValueFloat();
                        SMCLog.info("Dryness halflife: " + drynessHalfLife);
                        continue;
                    }
                    if (sl.isConstFloat("eyeBrightnessHalflife")) {
                        eyeBrightnessHalflife = sl.getValueFloat();
                        SMCLog.info("Eye brightness halflife: " + eyeBrightnessHalflife);
                        continue;
                    }
                    if (sl.isConstFloat("centerDepthHalflife")) {
                        centerDepthSmoothHalflife = sl.getValueFloat();
                        SMCLog.info("Center depth halflife: " + centerDepthSmoothHalflife);
                        continue;
                    }
                    if (sl.isConstFloat("sunPathRotation")) {
                        sunPathRotation = sl.getValueFloat();
                        SMCLog.info("Sun path rotation: " + sunPathRotation);
                        continue;
                    }
                    if (sl.isConstFloat("ambientOcclusionLevel")) {
                        aoLevel = Config.limit(sl.getValueFloat(), 0.0f, 1.0f);
                        SMCLog.info("AO Level: " + aoLevel);
                        continue;
                    }
                    if (sl.isConstInt("superSamplingLevel")) {
                        int ssaa = sl.getValueInt();
                        if (ssaa > 1) {
                            SMCLog.info("Super sampling level: " + ssaa + "x");
                            superSamplingLevel = ssaa;
                            continue;
                        }
                        superSamplingLevel = 1;
                        continue;
                    }
                    if (sl.isConstInt("noiseTextureResolution")) {
                        noiseTextureResolution = sl.getValueInt();
                        noiseTextureEnabled = true;
                        SMCLog.info("Noise texture enabled");
                        SMCLog.info("Noise texture resolution: " + noiseTextureResolution);
                        continue;
                    }
                    if (sl.isConstIntSuffix("Format")) {
                        name = StrUtils.removeSuffix(sl.getName(), "Format");
                        String value = sl.getValue();
                        int bufferindex = Shaders.getBufferIndexFromString(name);
                        int format = Shaders.getTextureFormatFromString(value);
                        if (bufferindex < 0 || format == 0) continue;
                        Shaders.gbuffersFormat[bufferindex] = format;
                        SMCLog.info("%s format: %s", name, value);
                        continue;
                    }
                    if (sl.isConstBoolSuffix("Clear", false)) {
                        int bufferindex;
                        if (!ShaderParser.isComposite(filename) && !ShaderParser.isDeferred(filename) || (bufferindex = Shaders.getBufferIndexFromString(name = StrUtils.removeSuffix(sl.getName(), "Clear"))) < 0) continue;
                        Shaders.gbuffersClear[bufferindex] = false;
                        SMCLog.info("%s clear disabled", name);
                        continue;
                    }
                    if (sl.isProperty("GAUX4FORMAT", "RGBA32F")) {
                        Shaders.gbuffersFormat[7] = 34836;
                        SMCLog.info("gaux4 format : RGB32AF");
                        continue;
                    }
                    if (sl.isProperty("GAUX4FORMAT", "RGB32F")) {
                        Shaders.gbuffersFormat[7] = 34837;
                        SMCLog.info("gaux4 format : RGB32F");
                        continue;
                    }
                    if (sl.isProperty("GAUX4FORMAT", "RGB16")) {
                        Shaders.gbuffersFormat[7] = 32852;
                        SMCLog.info("gaux4 format : RGB16");
                        continue;
                    }
                    if (sl.isConstBoolSuffix("MipmapEnabled", true)) {
                        int bufferindex;
                        if (!ShaderParser.isComposite(filename) && !ShaderParser.isDeferred(filename) && !ShaderParser.isFinal(filename) || (bufferindex = Shaders.getBufferIndexFromString(name = StrUtils.removeSuffix(sl.getName(), "MipmapEnabled"))) < 0) continue;
                        newCompositeMipmapSetting |= 1 << bufferindex;
                        SMCLog.info("%s mipmap enabled", name);
                        continue;
                    }
                    if (!sl.isProperty("DRAWBUFFERS")) continue;
                    String val = sl.getValue();
                    if (ShaderParser.isValidDrawBuffers(val)) {
                        newDrawBufSetting = val;
                        continue;
                    }
                    SMCLog.warning("Invalid draw buffers: " + val);
                }
                reader.close();
            }
            catch (Exception e) {
                SMCLog.severe("Couldn't read " + filename + "!");
                e.printStackTrace();
                ARBShaderObjects.glDeleteObjectARB((int)fragShader);
                return 0;
            }
        }
        if (saveFinalShaders) {
            Shaders.saveShader(filename, fragCode.toString());
        }
        ARBShaderObjects.glShaderSourceARB((int)fragShader, (CharSequence)fragCode);
        ARBShaderObjects.glCompileShaderARB((int)fragShader);
        if (GL20.glGetShaderi((int)fragShader, (int)35713) != 1) {
            SMCLog.severe("Error compiling fragment shader: " + filename);
        }
        Shaders.printShaderLogInfo(fragShader, filename, listFiles);
        return fragShader;
    }

    private static Reader getShaderReader(String filename) {
        Reader r = ShadersBuiltIn.getShaderReader(filename);
        if (r != null) {
            return r;
        }
        return new InputStreamReader(shaderPack.getResourceAsStream(filename));
    }

    private static void saveShader(String filename, String code) {
        try {
            File file = new File(shaderpacksdir, "debug/" + filename);
            file.getParentFile().mkdirs();
            Config.writeFile(file, code);
        }
        catch (IOException e) {
            Config.warn("Error saving: " + filename);
            e.printStackTrace();
        }
    }

    private static void clearDirectory(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                Shaders.clearDirectory(file);
            }
            file.delete();
        }
    }

    private static boolean printLogInfo(int obj, String name) {
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)obj, (int)35716, (IntBuffer)iVal);
        int length = iVal.get();
        if (length > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer((int)length);
            iVal.flip();
            ARBShaderObjects.glGetInfoLogARB((int)obj, (IntBuffer)iVal, (ByteBuffer)infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            if (infoBytes[length - 1] == 0) {
                infoBytes[length - 1] = 10;
            }
            String out = new String(infoBytes);
            SMCLog.info("Info log: " + name + "\n" + out);
            return false;
        }
        return true;
    }

    private static boolean printShaderLogInfo(int shader, String name, List<String> listFiles) {
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        int length = GL20.glGetShaderi((int)shader, (int)35716);
        if (length > 1) {
            for (int i = 0; i < listFiles.size(); ++i) {
                String path = listFiles.get(i);
                SMCLog.info("File: " + (i + 1) + " = " + path);
            }
            String log = GL20.glGetShaderInfoLog((int)shader, (int)length);
            SMCLog.info("Shader info log: " + name + "\n" + log);
            return false;
        }
        return true;
    }

    public static void setDrawBuffers(IntBuffer drawBuffers) {
        if (drawBuffers == null) {
            drawBuffers = drawBuffersNone;
        }
        if (activeDrawBuffers != drawBuffers) {
            activeDrawBuffers = drawBuffers;
            GL20.glDrawBuffers((IntBuffer)drawBuffers);
        }
    }

    public static void useProgram(int program) {
        Shaders.checkGLError("pre-useProgram");
        if (isShadowPass) {
            program = 30;
            if (programsID[30] == 0) {
                normalMapEnabled = false;
                return;
            }
        }
        if (activeProgram == program) {
            return;
        }
        activeProgram = program;
        ARBShaderObjects.glUseProgramObjectARB((int)programsID[program]);
        if (programsID[program] == 0) {
            normalMapEnabled = false;
            return;
        }
        if (Shaders.checkGLError("useProgram ", programNames[program]) != 0) {
            Shaders.programsID[program] = 0;
        }
        IntBuffer drawBuffers = programsDrawBuffers[program];
        if (isRenderingDfb) {
            Shaders.setDrawBuffers(drawBuffers);
            Shaders.checkGLError(programNames[program], " draw buffers = ", programsDrawBufSettings[program]);
        }
        activeCompositeMipmapSetting = programsCompositeMipmapSetting[program];
        uniformEntityColor.setProgram(programsID[activeProgram]);
        uniformEntityId.setProgram(programsID[activeProgram]);
        uniformBlockEntityId.setProgram(programsID[activeProgram]);
        switch (program) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 41: {
                normalMapEnabled = true;
                Shaders.setProgramUniform1i("texture", 0);
                Shaders.setProgramUniform1i("lightmap", 1);
                Shaders.setProgramUniform1i("normals", 2);
                Shaders.setProgramUniform1i("specular", 3);
                Shaders.setProgramUniform1i("shadow", waterShadowEnabled ? 5 : 4);
                Shaders.setProgramUniform1i("watershadow", 4);
                Shaders.setProgramUniform1i("shadowtex0", 4);
                Shaders.setProgramUniform1i("shadowtex1", 5);
                Shaders.setProgramUniform1i("depthtex0", 6);
                if (customTexturesGbuffers != null || hasDeferredPrograms) {
                    Shaders.setProgramUniform1i("gaux1", 7);
                    Shaders.setProgramUniform1i("gaux2", 8);
                    Shaders.setProgramUniform1i("gaux3", 9);
                    Shaders.setProgramUniform1i("gaux4", 10);
                }
                Shaders.setProgramUniform1i("depthtex1", 12);
                Shaders.setProgramUniform1i("shadowcolor", 13);
                Shaders.setProgramUniform1i("shadowcolor0", 13);
                Shaders.setProgramUniform1i("shadowcolor1", 14);
                Shaders.setProgramUniform1i("noisetex", 15);
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: {
                normalMapEnabled = false;
                Shaders.setProgramUniform1i("gcolor", 0);
                Shaders.setProgramUniform1i("gdepth", 1);
                Shaders.setProgramUniform1i("gnormal", 2);
                Shaders.setProgramUniform1i("composite", 3);
                Shaders.setProgramUniform1i("gaux1", 7);
                Shaders.setProgramUniform1i("gaux2", 8);
                Shaders.setProgramUniform1i("gaux3", 9);
                Shaders.setProgramUniform1i("gaux4", 10);
                Shaders.setProgramUniform1i("colortex0", 0);
                Shaders.setProgramUniform1i("colortex1", 1);
                Shaders.setProgramUniform1i("colortex2", 2);
                Shaders.setProgramUniform1i("colortex3", 3);
                Shaders.setProgramUniform1i("colortex4", 7);
                Shaders.setProgramUniform1i("colortex5", 8);
                Shaders.setProgramUniform1i("colortex6", 9);
                Shaders.setProgramUniform1i("colortex7", 10);
                Shaders.setProgramUniform1i("shadow", waterShadowEnabled ? 5 : 4);
                Shaders.setProgramUniform1i("watershadow", 4);
                Shaders.setProgramUniform1i("shadowtex0", 4);
                Shaders.setProgramUniform1i("shadowtex1", 5);
                Shaders.setProgramUniform1i("gdepthtex", 6);
                Shaders.setProgramUniform1i("depthtex0", 6);
                Shaders.setProgramUniform1i("depthtex1", 11);
                Shaders.setProgramUniform1i("depthtex2", 12);
                Shaders.setProgramUniform1i("shadowcolor", 13);
                Shaders.setProgramUniform1i("shadowcolor0", 13);
                Shaders.setProgramUniform1i("shadowcolor1", 14);
                Shaders.setProgramUniform1i("noisetex", 15);
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                Shaders.setProgramUniform1i("tex", 0);
                Shaders.setProgramUniform1i("texture", 0);
                Shaders.setProgramUniform1i("lightmap", 1);
                Shaders.setProgramUniform1i("normals", 2);
                Shaders.setProgramUniform1i("specular", 3);
                Shaders.setProgramUniform1i("shadow", waterShadowEnabled ? 5 : 4);
                Shaders.setProgramUniform1i("watershadow", 4);
                Shaders.setProgramUniform1i("shadowtex0", 4);
                Shaders.setProgramUniform1i("shadowtex1", 5);
                if (customTexturesGbuffers != null) {
                    Shaders.setProgramUniform1i("gaux1", 7);
                    Shaders.setProgramUniform1i("gaux2", 8);
                    Shaders.setProgramUniform1i("gaux3", 9);
                    Shaders.setProgramUniform1i("gaux4", 10);
                }
                Shaders.setProgramUniform1i("shadowcolor", 13);
                Shaders.setProgramUniform1i("shadowcolor0", 13);
                Shaders.setProgramUniform1i("shadowcolor1", 14);
                Shaders.setProgramUniform1i("noisetex", 15);
                break;
            }
            default: {
                normalMapEnabled = false;
            }
        }
        zx stack = Shaders.mc.h != null ? Shaders.mc.h.bA() : null;
        zw item = stack != null ? stack.b() : null;
        int itemID = -1;
        afh block = null;
        if (item != null) {
            itemID = zw.e.b((Object)item);
            block = (afh)afh.c.a(itemID);
        }
        int blockLight = block != null ? block.r() : 0;
        Shaders.setProgramUniform1i("heldItemId", itemID);
        Shaders.setProgramUniform1i("heldBlockLightValue", blockLight);
        Shaders.setProgramUniform1i("fogMode", fogEnabled ? fogMode : 0);
        Shaders.setProgramUniform3f("fogColor", fogColorR, fogColorG, fogColorB);
        Shaders.setProgramUniform3f("skyColor", skyColorR, skyColorG, skyColorB);
        Shaders.setProgramUniform1i("worldTime", (int)(worldTime % 24000L));
        Shaders.setProgramUniform1i("worldDay", (int)(worldTime / 24000L));
        Shaders.setProgramUniform1i("moonPhase", moonPhase);
        Shaders.setProgramUniform1i("frameCounter", frameCounter);
        Shaders.setProgramUniform1f("frameTime", frameTime);
        Shaders.setProgramUniform1f("frameTimeCounter", frameTimeCounter);
        Shaders.setProgramUniform1f("sunAngle", sunAngle);
        Shaders.setProgramUniform1f("shadowAngle", shadowAngle);
        Shaders.setProgramUniform1f("rainStrength", rainStrength);
        Shaders.setProgramUniform1f("aspectRatio", (float)renderWidth / (float)renderHeight);
        Shaders.setProgramUniform1f("viewWidth", renderWidth);
        Shaders.setProgramUniform1f("viewHeight", renderHeight);
        Shaders.setProgramUniform1f("near", 0.05f);
        Shaders.setProgramUniform1f("far", Shaders.mc.t.c * 16);
        Shaders.setProgramUniform3f("sunPosition", sunPosition[0], sunPosition[1], sunPosition[2]);
        Shaders.setProgramUniform3f("moonPosition", moonPosition[0], moonPosition[1], moonPosition[2]);
        Shaders.setProgramUniform3f("shadowLightPosition", shadowLightPosition[0], shadowLightPosition[1], shadowLightPosition[2]);
        Shaders.setProgramUniform3f("upPosition", upPosition[0], upPosition[1], upPosition[2]);
        Shaders.setProgramUniform3f("previousCameraPosition", (float)previousCameraPositionX, (float)previousCameraPositionY, (float)previousCameraPositionZ);
        Shaders.setProgramUniform3f("cameraPosition", (float)cameraPositionX, (float)cameraPositionY, (float)cameraPositionZ);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelView", false, modelView);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelViewInverse", false, modelViewInverse);
        Shaders.setProgramUniformMatrix4ARB("gbufferPreviousProjection", false, previousProjection);
        Shaders.setProgramUniformMatrix4ARB("gbufferProjection", false, projection);
        Shaders.setProgramUniformMatrix4ARB("gbufferProjectionInverse", false, projectionInverse);
        Shaders.setProgramUniformMatrix4ARB("gbufferPreviousModelView", false, previousModelView);
        if (usedShadowDepthBuffers > 0) {
            Shaders.setProgramUniformMatrix4ARB("shadowProjection", false, shadowProjection);
            Shaders.setProgramUniformMatrix4ARB("shadowProjectionInverse", false, shadowProjectionInverse);
            Shaders.setProgramUniformMatrix4ARB("shadowModelView", false, shadowModelView);
            Shaders.setProgramUniformMatrix4ARB("shadowModelViewInverse", false, shadowModelViewInverse);
        }
        Shaders.setProgramUniform1f("wetness", wetness);
        Shaders.setProgramUniform1f("eyeAltitude", eyePosY);
        Shaders.setProgramUniform2i("eyeBrightness", eyeBrightness & 0xFFFF, eyeBrightness >> 16);
        Shaders.setProgramUniform2i("eyeBrightnessSmooth", Math.round(eyeBrightnessFadeX), Math.round(eyeBrightnessFadeY));
        Shaders.setProgramUniform2i("terrainTextureSize", terrainTextureSize[0], terrainTextureSize[1]);
        Shaders.setProgramUniform1i("terrainIconSize", terrainIconSize);
        Shaders.setProgramUniform1i("isEyeInWater", isEyeInWater);
        Shaders.setProgramUniform1f("nightVision", nightVision);
        Shaders.setProgramUniform1f("blindness", blindness);
        Shaders.setProgramUniform1f("screenBrightness", Shaders.mc.t.aJ);
        Shaders.setProgramUniform1i("hideGUI", Shaders.mc.t.aA ? 1 : 0);
        Shaders.setProgramUniform1f("centerDepthSmooth", centerDepthSmooth);
        Shaders.setProgramUniform2i("atlasSize", atlasSizeX, atlasSizeY);
        if (customUniforms != null) {
            customUniforms.setProgram(programsID[activeProgram]);
            customUniforms.update();
        }
        Shaders.checkGLError("useProgram ", programNames[program]);
    }

    public static void setProgramUniform1i(String name, int x) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform1iARB((int)uniform, (int)x);
            if (Shaders.isCustomUniforms()) {
                LegacyUniforms.setInt(name, x);
            }
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform2i(String name, int x, int y) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform2iARB((int)uniform, (int)x, (int)y);
            if (Shaders.isCustomUniforms()) {
                LegacyUniforms.setIntXy(name, x, y);
            }
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform1f(String name, float x) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform1fARB((int)uniform, (float)x);
            if (Shaders.isCustomUniforms()) {
                LegacyUniforms.setFloat(name, x);
            }
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniform3f(String name, float x, float y, float z) {
        int gp = programsID[activeProgram];
        if (gp != 0) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniform3fARB((int)uniform, (float)x, (float)y, (float)z);
            if (Shaders.isCustomUniforms()) {
                if (name.endsWith("Color")) {
                    LegacyUniforms.setFloatRgb(name, x, y, z);
                } else {
                    LegacyUniforms.setFloatXyz(name, x, y, z);
                }
            }
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    public static void setProgramUniformMatrix4ARB(String name, boolean transpose, FloatBuffer matrix) {
        int gp = programsID[activeProgram];
        if (gp != 0 && matrix != null) {
            int uniform = ARBShaderObjects.glGetUniformLocationARB((int)gp, (CharSequence)name);
            ARBShaderObjects.glUniformMatrix4ARB((int)uniform, (boolean)transpose, (FloatBuffer)matrix);
            Shaders.checkGLError(programNames[activeProgram], name);
        }
    }

    private static int getBufferIndexFromString(String name) {
        if (name.equals("colortex0") || name.equals("gcolor")) {
            return 0;
        }
        if (name.equals("colortex1") || name.equals("gdepth")) {
            return 1;
        }
        if (name.equals("colortex2") || name.equals("gnormal")) {
            return 2;
        }
        if (name.equals("colortex3") || name.equals("composite")) {
            return 3;
        }
        if (name.equals("colortex4") || name.equals("gaux1")) {
            return 4;
        }
        if (name.equals("colortex5") || name.equals("gaux2")) {
            return 5;
        }
        if (name.equals("colortex6") || name.equals("gaux3")) {
            return 6;
        }
        if (name.equals("colortex7") || name.equals("gaux4")) {
            return 7;
        }
        return -1;
    }

    private static int getTextureFormatFromString(String par) {
        par = par.trim();
        for (int i = 0; i < formatNames.length; ++i) {
            String name = formatNames[i];
            if (!par.equals(name)) continue;
            return formatIds[i];
        }
        return 0;
    }

    private static void setupNoiseTexture() {
        if (noiseTexture == null && noiseTexturePath != null) {
            noiseTexture = Shaders.loadCustomTexture(15, noiseTexturePath);
        }
        if (noiseTexture == null) {
            noiseTexture = new HFNoiseTexture(noiseTextureResolution, noiseTextureResolution);
        }
    }

    private static void loadEntityDataMap() {
        mapBlockToEntityData = new IdentityHashMap<afh, Integer>(300);
        if (mapBlockToEntityData.isEmpty()) {
            for (jy key : afh.c.c()) {
                afh block = (afh)afh.c.a((Object)key);
                int id = afh.c.b((Object)block);
                mapBlockToEntityData.put(block, id);
            }
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(shaderPack.getResourceAsStream("/mc_Entity_x.txt")));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (reader != null) {
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher m = patternLoadEntityDataMap.matcher(line);
                    if (m.matches()) {
                        String name = m.group(1);
                        String value = m.group(2);
                        int id = Integer.parseInt(value);
                        afh block = afh.b((String)name);
                        if (block != null) {
                            mapBlockToEntityData.put(block, id);
                            continue;
                        }
                        SMCLog.warning("Unknown block name %s", name);
                        continue;
                    }
                    SMCLog.warning("unmatched %s\n", line);
                }
            }
            catch (Exception e) {
                SMCLog.warning("Error parsing mc_Entity_x.txt");
            }
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static IntBuffer fillIntBufferZero(IntBuffer buf) {
        int limit = buf.limit();
        for (int i = buf.position(); i < limit; ++i) {
            buf.put(i, 0);
        }
        return buf;
    }

    public static void uninit() {
        if (isShaderPackInitialized) {
            Shaders.checkGLError("Shaders.uninit pre");
            for (int i = 0; i < 44; ++i) {
                if (programsRef[i] != 0) {
                    ARBShaderObjects.glDeleteObjectARB((int)programsRef[i]);
                    Shaders.checkGLError("del programRef");
                }
                Shaders.programsRef[i] = 0;
                Shaders.programsID[i] = 0;
                Shaders.programsDrawBufSettings[i] = null;
                Shaders.programsDrawBuffers[i] = null;
                Shaders.programsCompositeMipmapSetting[i] = 0;
            }
            hasDeferredPrograms = false;
            if (dfb != 0) {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)dfb);
                dfb = 0;
                Shaders.checkGLError("del dfb");
            }
            if (sfb != 0) {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)sfb);
                sfb = 0;
                Shaders.checkGLError("del sfb");
            }
            if (dfbDepthTextures != null) {
                bfl.deleteTextures((IntBuffer)dfbDepthTextures);
                Shaders.fillIntBufferZero(dfbDepthTextures);
                Shaders.checkGLError("del dfbDepthTextures");
            }
            if (dfbColorTextures != null) {
                bfl.deleteTextures((IntBuffer)dfbColorTextures);
                Shaders.fillIntBufferZero(dfbColorTextures);
                Shaders.checkGLError("del dfbTextures");
            }
            if (sfbDepthTextures != null) {
                bfl.deleteTextures((IntBuffer)sfbDepthTextures);
                Shaders.fillIntBufferZero(sfbDepthTextures);
                Shaders.checkGLError("del shadow depth");
            }
            if (sfbColorTextures != null) {
                bfl.deleteTextures((IntBuffer)sfbColorTextures);
                Shaders.fillIntBufferZero(sfbColorTextures);
                Shaders.checkGLError("del shadow color");
            }
            if (dfbDrawBuffers != null) {
                Shaders.fillIntBufferZero(dfbDrawBuffers);
            }
            if (noiseTexture != null) {
                noiseTexture.deleteTexture();
                noiseTexture = null;
            }
            SMCLog.info("Uninit");
            shadowPassInterval = 0;
            shouldSkipDefaultShadow = false;
            isShaderPackInitialized = false;
            Shaders.checkGLError("Shaders.uninit");
        }
    }

    public static void scheduleResize() {
        renderDisplayHeight = 0;
    }

    public static void scheduleResizeShadow() {
        needResizeShadow = true;
    }

    private static void resize() {
        renderDisplayWidth = Shaders.mc.d;
        renderDisplayHeight = Shaders.mc.e;
        renderWidth = Math.round((float)renderDisplayWidth * configRenderResMul);
        renderHeight = Math.round((float)renderDisplayHeight * configRenderResMul);
        Shaders.setupFrameBuffer();
    }

    private static void resizeShadow() {
        needResizeShadow = false;
        shadowMapWidth = Math.round((float)spShadowMapWidth * configShadowResMul);
        shadowMapHeight = Math.round((float)spShadowMapHeight * configShadowResMul);
        Shaders.setupShadowFrameBuffer();
    }

    private static void setupFrameBuffer() {
        int i;
        if (dfb != 0) {
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)dfb);
            bfl.deleteTextures((IntBuffer)dfbDepthTextures);
            bfl.deleteTextures((IntBuffer)dfbColorTextures);
        }
        dfb = EXTFramebufferObject.glGenFramebuffersEXT();
        GL11.glGenTextures((IntBuffer)((IntBuffer)dfbDepthTextures.clear().limit(usedDepthBuffers)));
        GL11.glGenTextures((IntBuffer)((IntBuffer)dfbColorTextures.clear().limit(16)));
        dfbDepthTextures.position(0);
        dfbColorTextures.position(0);
        dfbColorTextures.get(dfbColorTexturesA).position(0);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        GL20.glDrawBuffers((int)0);
        GL11.glReadBuffer((int)0);
        for (i = 0; i < usedDepthBuffers; ++i) {
            bfl.i((int)dfbDepthTextures.get(i));
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)34891, (int)6409);
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)renderWidth, (int)renderHeight, (int)0, (int)6402, (int)5126, (FloatBuffer)null);
        }
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)dfbDepthTextures.get(0), (int)0);
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
        GL11.glReadBuffer((int)0);
        Shaders.checkGLError("FT d");
        for (i = 0; i < usedColorBuffers; ++i) {
            bfl.i((int)dfbColorTexturesA[i]);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)gbuffersFormat[i], (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i), (int)3553, (int)dfbColorTexturesA[i], (int)0);
            Shaders.checkGLError("FT c");
        }
        for (i = 0; i < usedColorBuffers; ++i) {
            bfl.i((int)dfbColorTexturesA[8 + i]);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexImage2D((int)3553, (int)0, (int)gbuffersFormat[i], (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            Shaders.checkGLError("FT ca");
        }
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status == 36058) {
            Shaders.printChatAndLogError("[Shaders] Error: Failed framebuffer incomplete formats");
            for (int i2 = 0; i2 < usedColorBuffers; ++i2) {
                bfl.i((int)dfbColorTextures.get(i2));
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)renderWidth, (int)renderHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i2), (int)3553, (int)dfbColorTextures.get(i2), (int)0);
                Shaders.checkGLError("FT c");
            }
            status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
            if (status == 36053) {
                SMCLog.info("complete");
            }
        }
        bfl.i((int)0);
        if (status != 36053) {
            Shaders.printChatAndLogError("[Shaders] Error: Failed creating framebuffer! (Status " + status + ")");
        } else {
            SMCLog.info("Framebuffer created.");
        }
    }

    private static void setupShadowFrameBuffer() {
        int status;
        int filter;
        int i;
        if (usedShadowDepthBuffers == 0) {
            return;
        }
        if (sfb != 0) {
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)sfb);
            bfl.deleteTextures((IntBuffer)sfbDepthTextures);
            bfl.deleteTextures((IntBuffer)sfbColorTextures);
        }
        sfb = EXTFramebufferObject.glGenFramebuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
        GL11.glDrawBuffer((int)0);
        GL11.glReadBuffer((int)0);
        GL11.glGenTextures((IntBuffer)((IntBuffer)sfbDepthTextures.clear().limit(usedShadowDepthBuffers)));
        GL11.glGenTextures((IntBuffer)((IntBuffer)sfbColorTextures.clear().limit(usedShadowColorBuffers)));
        sfbDepthTextures.position(0);
        sfbColorTextures.position(0);
        for (i = 0; i < usedShadowDepthBuffers; ++i) {
            bfl.i((int)sfbDepthTextures.get(i));
            GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
            GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
            filter = shadowFilterNearest[i] ? 9728 : 9729;
            GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
            if (shadowHardwareFilteringEnabled[i]) {
                GL11.glTexParameteri((int)3553, (int)34892, (int)34894);
            }
            GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)shadowMapWidth, (int)shadowMapHeight, (int)0, (int)6402, (int)5126, (FloatBuffer)null);
        }
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbDepthTextures.get(0), (int)0);
        Shaders.checkGLError("FT sd");
        for (i = 0; i < usedShadowColorBuffers; ++i) {
            bfl.i((int)sfbColorTextures.get(i));
            GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
            GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
            filter = shadowColorFilterNearest[i] ? 9728 : 9729;
            GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
            GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)shadowMapWidth, (int)shadowMapHeight, (int)0, (int)32993, (int)33639, (ByteBuffer)null);
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i), (int)3553, (int)sfbColorTextures.get(i), (int)0);
            Shaders.checkGLError("FT sc");
        }
        bfl.i((int)0);
        if (usedShadowColorBuffers > 0) {
            GL20.glDrawBuffers((IntBuffer)sfbDrawBuffers);
        }
        if ((status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160)) != 36053) {
            Shaders.printChatAndLogError("[Shaders] Error: Failed creating shadow framebuffer! (Status " + status + ")");
        } else {
            SMCLog.info("Shadow framebuffer created.");
        }
    }

    public static void beginRender(ave minecraft, float partialTicks, long finishTimeNano) {
        int i;
        block25: {
            Shaders.checkGLError("pre beginRender");
            Shaders.checkWorldChanged((adm)Shaders.mc.f);
            mc = minecraft;
            Shaders.mc.A.a("init");
            entityRenderer = Shaders.mc.o;
            if (!isShaderPackInitialized) {
                try {
                    Shaders.init();
                }
                catch (IllegalStateException e) {
                    if (!Config.normalize(e.getMessage()).equals("Function is not supported")) break block25;
                    Shaders.printChatAndLogError("[Shaders] Error: " + e.getMessage());
                    e.printStackTrace();
                    Shaders.setShaderPack(packNameNone);
                    return;
                }
            }
        }
        if (Shaders.mc.d != renderDisplayWidth || Shaders.mc.e != renderDisplayHeight) {
            Shaders.resize();
        }
        if (needResizeShadow) {
            Shaders.resizeShadow();
        }
        if ((diffWorldTime = ((worldTime = Shaders.mc.f.L()) - lastWorldTime) % 24000L) < 0L) {
            diffWorldTime += 24000L;
        }
        lastWorldTime = worldTime;
        moonPhase = Shaders.mc.f.x();
        if (++frameCounter >= 720720) {
            frameCounter = 0;
        }
        systemTime = System.currentTimeMillis();
        if (lastSystemTime == 0L) {
            lastSystemTime = systemTime;
        }
        diffSystemTime = systemTime - lastSystemTime;
        lastSystemTime = systemTime;
        frameTime = (float)diffSystemTime / 1000.0f;
        frameTimeCounter += frameTime;
        frameTimeCounter %= 3600.0f;
        rainStrength = minecraft.f.j(partialTicks);
        float fadeScalar = (float)diffSystemTime * 0.01f;
        float temp1 = (float)Math.exp(Math.log(0.5) * (double)fadeScalar / (double)(wetness < rainStrength ? drynessHalfLife : wetnessHalfLife));
        wetness = wetness * temp1 + rainStrength * (1.0f - temp1);
        pk renderViewEntity = mc.ac();
        if (renderViewEntity != null) {
            isSleeping = renderViewEntity instanceof pr && ((pr)renderViewEntity).bJ();
            eyePosY = (float)renderViewEntity.t * partialTicks + (float)renderViewEntity.Q * (1.0f - partialTicks);
            eyeBrightness = renderViewEntity.b(partialTicks);
            float fadeScalar2 = (float)diffSystemTime * 0.01f;
            float temp2 = (float)Math.exp(Math.log(0.5) * (double)fadeScalar2 / (double)eyeBrightnessHalflife);
            eyeBrightnessFadeX = eyeBrightnessFadeX * temp2 + (float)(eyeBrightness & 0xFFFF) * (1.0f - temp2);
            eyeBrightnessFadeY = eyeBrightnessFadeY * temp2 + (float)(eyeBrightness >> 16) * (1.0f - temp2);
            isEyeInWater = 0;
            if (Shaders.mc.t.aB == 0 && !isSleeping) {
                if (renderViewEntity.a(arm.h)) {
                    isEyeInWater = 1;
                } else if (renderViewEntity.a(arm.i)) {
                    isEyeInWater = 2;
                }
            }
            if (Shaders.mc.h != null) {
                nightVision = 0.0f;
                if (Shaders.mc.h.a(pe.r)) {
                    nightVision = Config.getMinecraft().o.a((pr)Shaders.mc.h, partialTicks);
                }
                blindness = 0.0f;
                if (Shaders.mc.h.a(pe.q)) {
                    int blindnessTicks = Shaders.mc.h.b(pe.q).b();
                    blindness = Config.limit((float)blindnessTicks / 20.0f, 0.0f, 1.0f);
                }
            }
            aui skyColorV = Shaders.mc.f.a(renderViewEntity, partialTicks);
            skyColorV = CustomColors.getWorldSkyColor(skyColorV, currentWorld, renderViewEntity, partialTicks);
            skyColorR = (float)skyColorV.a;
            skyColorG = (float)skyColorV.b;
            skyColorB = (float)skyColorV.c;
        }
        isRenderingWorld = true;
        isCompositeRendered = false;
        isHandRenderedMain = false;
        if (usedShadowDepthBuffers >= 1) {
            bfl.g((int)33988);
            bfl.i((int)sfbDepthTextures.get(0));
            if (usedShadowDepthBuffers >= 2) {
                bfl.g((int)33989);
                bfl.i((int)sfbDepthTextures.get(1));
            }
        }
        bfl.g((int)33984);
        for (i = 0; i < usedColorBuffers; ++i) {
            bfl.i((int)dfbColorTexturesA[i]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            bfl.i((int)dfbColorTexturesA[8 + i]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        }
        bfl.i((int)0);
        for (i = 0; i < 4 && 4 + i < usedColorBuffers; ++i) {
            bfl.g((int)(33991 + i));
            bfl.i((int)dfbColorTextures.get(4 + i));
        }
        bfl.g((int)33990);
        bfl.i((int)dfbDepthTextures.get(0));
        if (usedDepthBuffers >= 2) {
            bfl.g((int)33995);
            bfl.i((int)dfbDepthTextures.get(1));
            if (usedDepthBuffers >= 3) {
                bfl.g((int)33996);
                bfl.i((int)dfbDepthTextures.get(2));
            }
        }
        for (i = 0; i < usedShadowColorBuffers; ++i) {
            bfl.g((int)(33997 + i));
            bfl.i((int)sfbColorTextures.get(i));
        }
        if (noiseTextureEnabled) {
            bfl.g((int)(33984 + noiseTexture.getTextureUnit()));
            bfl.i((int)noiseTexture.getTextureId());
        }
        Shaders.bindCustomTextures(customTexturesGbuffers);
        bfl.g((int)33984);
        previousCameraPositionX = cameraPositionX;
        previousCameraPositionY = cameraPositionY;
        previousCameraPositionZ = cameraPositionZ;
        previousProjection.position(0);
        projection.position(0);
        previousProjection.put(projection);
        previousProjection.position(0);
        projection.position(0);
        previousModelView.position(0);
        modelView.position(0);
        previousModelView.put(modelView);
        previousModelView.position(0);
        modelView.position(0);
        Shaders.checkGLError("beginRender");
        ShadersRender.renderShadowMap(entityRenderer, 0, partialTicks, finishTimeNano);
        Shaders.mc.A.b();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        for (i = 0; i < usedColorBuffers; ++i) {
            Shaders.colorTexturesToggle[i] = 0;
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i), (int)3553, (int)dfbColorTexturesA[i], (int)0);
        }
        Shaders.checkGLError("end beginRender");
    }

    private static void checkWorldChanged(adm world) {
        if (currentWorld == world) {
            return;
        }
        adm oldWorld = currentWorld;
        currentWorld = world;
        if (oldWorld != null && world != null) {
            int dimIdOld = oldWorld.t.q();
            int dimIdNew = world.t.q();
            boolean dimShadersOld = shaderPackDimensions.contains(dimIdOld);
            boolean dimShadersNew = shaderPackDimensions.contains(dimIdNew);
            if (dimShadersOld || dimShadersNew) {
                Shaders.uninit();
            }
        }
        Smoother.reset();
    }

    public static void beginRenderPass(int pass, float partialTicks, long finishTimeNano) {
        if (isShadowPass) {
            return;
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        GL11.glViewport((int)0, (int)0, (int)renderWidth, (int)renderHeight);
        activeDrawBuffers = null;
        ShadersTex.bindNSTextures(defaultTexture.getMultiTexID());
        Shaders.useProgram(2);
        Shaders.checkGLError("end beginRenderPass");
    }

    public static void setViewport(int vx, int vy, int vw, int vh) {
        bfl.a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        if (isShadowPass) {
            GL11.glViewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
        } else {
            GL11.glViewport((int)0, (int)0, (int)renderWidth, (int)renderHeight);
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
            isRenderingDfb = true;
            bfl.o();
            bfl.j();
            Shaders.setDrawBuffers(drawBuffersNone);
            Shaders.useProgram(2);
            Shaders.checkGLError("beginRenderPass");
        }
    }

    public static int setFogMode(int val) {
        fogMode = val;
        return fogMode;
    }

    public static void setFogColor(float r, float g2, float b2) {
        fogColorR = r;
        fogColorG = g2;
        fogColorB = b2;
        Shaders.setProgramUniform3f("fogColor", fogColorR, fogColorG, fogColorB);
    }

    public static void setClearColor(float red, float green, float blue, float alpha) {
        bfl.a((float)red, (float)green, (float)blue, (float)alpha);
        clearColorR = red;
        clearColorG = green;
        clearColorB = blue;
    }

    public static void clearRenderBuffer() {
        if (isShadowPass) {
            Shaders.checkGLError("shadow clear pre");
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbDepthTextures.get(0), (int)0);
            GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL20.glDrawBuffers((IntBuffer)programsDrawBuffers[30]);
            Shaders.checkFramebufferStatus("shadow clear");
            GL11.glClear((int)16640);
            Shaders.checkGLError("shadow clear");
            return;
        }
        Shaders.checkGLError("clear pre");
        if (gbuffersClear[0]) {
            GL20.glDrawBuffers((int)36064);
            GL11.glClear((int)16384);
        }
        if (gbuffersClear[1]) {
            GL20.glDrawBuffers((int)36065);
            GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glClear((int)16384);
        }
        for (int i = 2; i < usedColorBuffers; ++i) {
            if (!gbuffersClear[i]) continue;
            GL20.glDrawBuffers((int)(36064 + i));
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GL11.glClear((int)16384);
        }
        Shaders.setDrawBuffers(dfbDrawBuffers);
        Shaders.checkFramebufferStatus("clear");
        Shaders.checkGLError("clear");
    }

    public static void setCamera(float partialTicks) {
        pk viewEntity = mc.ac();
        double x = viewEntity.P + (viewEntity.s - viewEntity.P) * (double)partialTicks;
        double y = viewEntity.Q + (viewEntity.t - viewEntity.Q) * (double)partialTicks;
        double z = viewEntity.R + (viewEntity.u - viewEntity.R) * (double)partialTicks;
        cameraPositionX = x;
        cameraPositionY = y;
        cameraPositionZ = z;
        GL11.glGetFloat((int)2983, (FloatBuffer)((FloatBuffer)projection.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)projectionInverse.position(0), (FloatBuffer)projection.position(0), faProjectionInverse, faProjection);
        projection.position(0);
        projectionInverse.position(0);
        GL11.glGetFloat((int)2982, (FloatBuffer)((FloatBuffer)modelView.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)modelViewInverse.position(0), (FloatBuffer)modelView.position(0), faModelViewInverse, faModelView);
        modelView.position(0);
        modelViewInverse.position(0);
        Shaders.checkGLError("setCamera");
    }

    public static void setCameraShadow(float partialTicks) {
        float angleInterval;
        pk viewEntity = mc.ac();
        double x = viewEntity.P + (viewEntity.s - viewEntity.P) * (double)partialTicks;
        double y = viewEntity.Q + (viewEntity.t - viewEntity.Q) * (double)partialTicks;
        double z = viewEntity.R + (viewEntity.u - viewEntity.R) * (double)partialTicks;
        cameraPositionX = x;
        cameraPositionY = y;
        cameraPositionZ = z;
        GL11.glGetFloat((int)2983, (FloatBuffer)((FloatBuffer)projection.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)projectionInverse.position(0), (FloatBuffer)projection.position(0), faProjectionInverse, faProjection);
        projection.position(0);
        projectionInverse.position(0);
        GL11.glGetFloat((int)2982, (FloatBuffer)((FloatBuffer)modelView.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)modelViewInverse.position(0), (FloatBuffer)modelView.position(0), faModelViewInverse, faModelView);
        modelView.position(0);
        modelViewInverse.position(0);
        GL11.glViewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        if (shadowMapIsOrtho) {
            GL11.glOrtho((double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)0.05f, (double)256.0);
        } else {
            GLU.gluPerspective((float)shadowMapFOV, (float)((float)shadowMapWidth / (float)shadowMapHeight), (float)0.05f, (float)256.0f);
        }
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        celestialAngle = Shaders.mc.f.c(partialTicks);
        sunAngle = celestialAngle < 0.75f ? celestialAngle + 0.25f : celestialAngle - 0.75f;
        float angle = celestialAngle * -360.0f;
        float f = angleInterval = shadowAngleInterval > 0.0f ? angle % shadowAngleInterval - shadowAngleInterval * 0.5f : 0.0f;
        if ((double)sunAngle <= 0.5) {
            GL11.glRotatef((float)(angle - angleInterval), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)sunPathRotation, (float)1.0f, (float)0.0f, (float)0.0f);
            shadowAngle = sunAngle;
        } else {
            GL11.glRotatef((float)(angle + 180.0f - angleInterval), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)sunPathRotation, (float)1.0f, (float)0.0f, (float)0.0f);
            shadowAngle = sunAngle - 0.5f;
        }
        if (shadowMapIsOrtho) {
            float trans = shadowIntervalSize;
            float trans2 = trans / 2.0f;
            GL11.glTranslatef((float)((float)x % trans - trans2), (float)((float)y % trans - trans2), (float)((float)z % trans - trans2));
        }
        float raSun = sunAngle * ((float)Math.PI * 2);
        float x1 = (float)Math.cos(raSun);
        float y1 = (float)Math.sin(raSun);
        float raTilt = sunPathRotation * ((float)Math.PI * 2);
        float x2 = x1;
        float y2 = y1 * (float)Math.cos(raTilt);
        float z2 = y1 * (float)Math.sin(raTilt);
        if ((double)sunAngle > 0.5) {
            x2 = -x2;
            y2 = -y2;
            z2 = -z2;
        }
        Shaders.shadowLightPositionVector[0] = x2;
        Shaders.shadowLightPositionVector[1] = y2;
        Shaders.shadowLightPositionVector[2] = z2;
        Shaders.shadowLightPositionVector[3] = 0.0f;
        GL11.glGetFloat((int)2983, (FloatBuffer)((FloatBuffer)shadowProjection.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)shadowProjectionInverse.position(0), (FloatBuffer)shadowProjection.position(0), faShadowProjectionInverse, faShadowProjection);
        shadowProjection.position(0);
        shadowProjectionInverse.position(0);
        GL11.glGetFloat((int)2982, (FloatBuffer)((FloatBuffer)shadowModelView.position(0)));
        SMath.invertMat4FBFA((FloatBuffer)shadowModelViewInverse.position(0), (FloatBuffer)shadowModelView.position(0), faShadowModelViewInverse, faShadowModelView);
        shadowModelView.position(0);
        shadowModelViewInverse.position(0);
        Shaders.setProgramUniformMatrix4ARB("gbufferProjection", false, projection);
        Shaders.setProgramUniformMatrix4ARB("gbufferProjectionInverse", false, projectionInverse);
        Shaders.setProgramUniformMatrix4ARB("gbufferPreviousProjection", false, previousProjection);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelView", false, modelView);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelViewInverse", false, modelViewInverse);
        Shaders.setProgramUniformMatrix4ARB("gbufferPreviousModelView", false, previousModelView);
        Shaders.setProgramUniformMatrix4ARB("shadowProjection", false, shadowProjection);
        Shaders.setProgramUniformMatrix4ARB("shadowProjectionInverse", false, shadowProjectionInverse);
        Shaders.setProgramUniformMatrix4ARB("shadowModelView", false, shadowModelView);
        Shaders.setProgramUniformMatrix4ARB("shadowModelViewInverse", false, shadowModelViewInverse);
        Shaders.mc.t.aB = 1;
        Shaders.checkGLError("setCamera");
    }

    public static void preCelestialRotate() {
        GL11.glRotatef((float)(sunPathRotation * 1.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        Shaders.checkGLError("preCelestialRotate");
    }

    public static void postCelestialRotate() {
        FloatBuffer modelView = tempMatrixDirectBuffer;
        modelView.clear();
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        modelView.get(tempMat, 0, 16);
        SMath.multiplyMat4xVec4(sunPosition, tempMat, sunPosModelView);
        SMath.multiplyMat4xVec4(moonPosition, tempMat, moonPosModelView);
        System.arraycopy(shadowAngle == sunAngle ? sunPosition : moonPosition, 0, shadowLightPosition, 0, 3);
        Shaders.setProgramUniform3f("sunPosition", sunPosition[0], sunPosition[1], sunPosition[2]);
        Shaders.setProgramUniform3f("moonPosition", moonPosition[0], moonPosition[1], moonPosition[2]);
        Shaders.setProgramUniform3f("shadowLightPosition", shadowLightPosition[0], shadowLightPosition[1], shadowLightPosition[2]);
        Shaders.checkGLError("postCelestialRotate");
    }

    public static void setUpPosition() {
        FloatBuffer modelView = tempMatrixDirectBuffer;
        modelView.clear();
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        modelView.get(tempMat, 0, 16);
        SMath.multiplyMat4xVec4(upPosition, tempMat, upPosModelView);
        Shaders.setProgramUniform3f("upPosition", upPosition[0], upPosition[1], upPosition[2]);
    }

    public static void genCompositeMipmap() {
        if (hasGlGenMipmap) {
            for (int i = 0; i < usedColorBuffers; ++i) {
                if ((activeCompositeMipmapSetting & 1 << i) == 0) continue;
                bfl.g((int)(33984 + colorTextureTextureImageUnit[i]));
                GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
                GL30.glGenerateMipmap((int)3553);
            }
            bfl.g((int)33984);
        }
    }

    public static void drawComposite() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
    }

    public static void renderDeferred() {
        if (!hasDeferredPrograms) {
            return;
        }
        Shaders.checkGLError("pre-render Deferred");
        Shaders.renderComposites(33, 8, false);
        mc.P().a(bmh.g);
    }

    public static void renderCompositeFinal() {
        Shaders.checkGLError("pre-render CompositeFinal");
        Shaders.renderComposites(21, 8, true);
    }

    private static void renderComposites(int programBase, int countPrograms, boolean renderFinal) {
        int programLast;
        int t1;
        int t0;
        int i;
        int i2;
        if (isShadowPass) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bfl.w();
        bfl.c();
        bfl.k();
        bfl.j();
        bfl.c((int)519);
        bfl.a((boolean)false);
        bfl.f();
        if (usedShadowDepthBuffers >= 1) {
            bfl.g((int)33988);
            bfl.i((int)sfbDepthTextures.get(0));
            if (usedShadowDepthBuffers >= 2) {
                bfl.g((int)33989);
                bfl.i((int)sfbDepthTextures.get(1));
            }
        }
        for (i2 = 0; i2 < usedColorBuffers; ++i2) {
            bfl.g((int)(33984 + colorTextureTextureImageUnit[i2]));
            bfl.i((int)dfbColorTexturesA[i2]);
        }
        bfl.g((int)33990);
        bfl.i((int)dfbDepthTextures.get(0));
        if (usedDepthBuffers >= 2) {
            bfl.g((int)33995);
            bfl.i((int)dfbDepthTextures.get(1));
            if (usedDepthBuffers >= 3) {
                bfl.g((int)33996);
                bfl.i((int)dfbDepthTextures.get(2));
            }
        }
        for (i2 = 0; i2 < usedShadowColorBuffers; ++i2) {
            bfl.g((int)(33997 + i2));
            bfl.i((int)sfbColorTextures.get(i2));
        }
        if (noiseTextureEnabled) {
            bfl.g((int)(33984 + noiseTexture.getTextureUnit()));
            bfl.i((int)noiseTexture.getTextureId());
        }
        if (renderFinal) {
            Shaders.bindCustomTextures(customTexturesComposite);
        } else {
            Shaders.bindCustomTextures(customTexturesDeferred);
        }
        bfl.g((int)33984);
        boolean enableAltBuffers = true;
        for (int i3 = 0; i3 < usedColorBuffers; ++i3) {
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i3), (int)3553, (int)dfbColorTexturesA[8 + i3], (int)0);
        }
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)dfbDepthTextures.get(0), (int)0);
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
        Shaders.checkGLError("pre-composite");
        for (int cp = 0; cp < countPrograms; ++cp) {
            if (programsID[programBase + cp] == 0) continue;
            Shaders.useProgram(programBase + cp);
            Shaders.checkGLError(programNames[programBase + cp]);
            if (activeCompositeMipmapSetting != 0) {
                Shaders.genCompositeMipmap();
            }
            Shaders.drawComposite();
            for (i = 0; i < usedColorBuffers; ++i) {
                if (!programsToggleColorTextures[programBase + cp][i]) continue;
                t0 = colorTexturesToggle[i];
                t1 = Shaders.colorTexturesToggle[i] = 8 - t0;
                bfl.g((int)(33984 + colorTextureTextureImageUnit[i]));
                bfl.i((int)dfbColorTexturesA[t1 + i]);
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i), (int)3553, (int)dfbColorTexturesA[t0 + i], (int)0);
            }
            bfl.g((int)33984);
        }
        Shaders.checkGLError("composite");
        int n = programLast = renderFinal ? 43 : 42;
        if (programsID[programLast] != 0) {
            Shaders.useProgram(programLast);
            Shaders.checkGLError(programNames[programLast]);
            if (activeCompositeMipmapSetting != 0) {
                Shaders.genCompositeMipmap();
            }
            Shaders.drawComposite();
            for (i = 0; i < usedColorBuffers; ++i) {
                if (!programsToggleColorTextures[programLast][i]) continue;
                t0 = colorTexturesToggle[i];
                t1 = Shaders.colorTexturesToggle[i] = 8 - t0;
                bfl.g((int)(33984 + colorTextureTextureImageUnit[i]));
                bfl.i((int)dfbColorTexturesA[t1 + i]);
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i), (int)3553, (int)dfbColorTexturesA[t0 + i], (int)0);
            }
            bfl.g((int)33984);
        }
        if (renderFinal) {
            Shaders.renderFinal();
        }
        if (renderFinal) {
            isCompositeRendered = true;
        }
        if (!renderFinal) {
            for (i = 0; i < usedColorBuffers; ++i) {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)(36064 + i), (int)3553, (int)dfbColorTexturesA[i], (int)0);
            }
            Shaders.setDrawBuffers(programsDrawBuffers[12]);
        }
        bfl.e();
        bfl.w();
        bfl.d();
        bfl.l();
        bfl.c((int)515);
        bfl.a((boolean)true);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        Shaders.useProgram(0);
    }

    private static void renderFinal() {
        isRenderingDfb = false;
        mc.b().a(true);
        bqs.a((int)bqs.c, (int)bqs.e, (int)3553, (int)Shaders.mc.b().g, (int)0);
        GL11.glViewport((int)0, (int)0, (int)Shaders.mc.d, (int)Shaders.mc.e);
        if (bfk.a) {
            boolean maskR = bfk.b != 0;
            bfl.a((boolean)maskR, (!maskR ? 1 : 0) != 0, (!maskR ? 1 : 0) != 0, (boolean)true);
        }
        bfl.a((boolean)true);
        GL11.glClearColor((float)clearColorR, (float)clearColorG, (float)clearColorB, (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bfl.w();
        bfl.c();
        bfl.k();
        bfl.j();
        bfl.c((int)519);
        bfl.a((boolean)false);
        Shaders.checkGLError("pre-final");
        Shaders.useProgram(29);
        Shaders.checkGLError("final");
        if (activeCompositeMipmapSetting != 0) {
            Shaders.genCompositeMipmap();
        }
        Shaders.drawComposite();
        Shaders.checkGLError("renderCompositeFinal");
    }

    public static void endRender() {
        if (isShadowPass) {
            Shaders.checkGLError("shadow endRender");
            return;
        }
        if (!isCompositeRendered) {
            Shaders.renderCompositeFinal();
        }
        isRenderingWorld = false;
        bfl.a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Shaders.useProgram(0);
        avc.a();
        Shaders.checkGLError("endRender end");
    }

    public static void beginSky() {
        isRenderingSky = true;
        fogEnabled = true;
        Shaders.setDrawBuffers(dfbDrawBuffers);
        Shaders.useProgram(5);
        Shaders.pushEntity(-2, 0);
    }

    public static void setSkyColor(aui v3color) {
        skyColorR = (float)v3color.a;
        skyColorG = (float)v3color.b;
        skyColorB = (float)v3color.c;
        Shaders.setProgramUniform3f("skyColor", skyColorR, skyColorG, skyColorB);
    }

    public static void drawHorizon() {
        bfd tess = bfx.a().c();
        float farDistance = Shaders.mc.t.c * 16;
        double xzq = (double)farDistance * 0.9238;
        double xzp = (double)farDistance * 0.3826;
        double xzn = -xzp;
        double xzm = -xzq;
        double top = 16.0;
        double bot = -cameraPositionY;
        tess.a(7, bms.e);
        tess.b(xzn, bot, xzm).d();
        tess.b(xzn, top, xzm).d();
        tess.b(xzm, top, xzn).d();
        tess.b(xzm, bot, xzn).d();
        tess.b(xzm, bot, xzn).d();
        tess.b(xzm, top, xzn).d();
        tess.b(xzm, top, xzp).d();
        tess.b(xzm, bot, xzp).d();
        tess.b(xzm, bot, xzp).d();
        tess.b(xzm, top, xzp).d();
        tess.b(xzn, top, xzp).d();
        tess.b(xzn, bot, xzp).d();
        tess.b(xzn, bot, xzp).d();
        tess.b(xzn, top, xzp).d();
        tess.b(xzp, top, xzq).d();
        tess.b(xzp, bot, xzq).d();
        tess.b(xzp, bot, xzq).d();
        tess.b(xzp, top, xzq).d();
        tess.b(xzq, top, xzp).d();
        tess.b(xzq, bot, xzp).d();
        tess.b(xzq, bot, xzp).d();
        tess.b(xzq, top, xzp).d();
        tess.b(xzq, top, xzn).d();
        tess.b(xzq, bot, xzn).d();
        tess.b(xzq, bot, xzn).d();
        tess.b(xzq, top, xzn).d();
        tess.b(xzp, top, xzm).d();
        tess.b(xzp, bot, xzm).d();
        tess.b(xzp, bot, xzm).d();
        tess.b(xzp, top, xzm).d();
        tess.b(xzn, top, xzm).d();
        tess.b(xzn, bot, xzm).d();
        bfx.a().b();
    }

    public static void preSkyList() {
        Shaders.setUpPosition();
        GL11.glColor3f((float)fogColorR, (float)fogColorG, (float)fogColorB);
        Shaders.drawHorizon();
        GL11.glColor3f((float)skyColorR, (float)skyColorG, (float)skyColorB);
    }

    public static void endSky() {
        isRenderingSky = false;
        Shaders.setDrawBuffers(dfbDrawBuffers);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
        Shaders.popEntity();
    }

    public static void beginUpdateChunks() {
        Shaders.checkGLError("beginUpdateChunks1");
        Shaders.checkFramebufferStatus("beginUpdateChunks1");
        if (!isShadowPass) {
            Shaders.useProgram(7);
        }
        Shaders.checkGLError("beginUpdateChunks2");
        Shaders.checkFramebufferStatus("beginUpdateChunks2");
    }

    public static void endUpdateChunks() {
        Shaders.checkGLError("endUpdateChunks1");
        Shaders.checkFramebufferStatus("endUpdateChunks1");
        if (!isShadowPass) {
            Shaders.useProgram(7);
        }
        Shaders.checkGLError("endUpdateChunks2");
        Shaders.checkFramebufferStatus("endUpdateChunks2");
    }

    public static boolean shouldRenderClouds(avh gs) {
        if (!shaderPackLoaded) {
            return true;
        }
        Shaders.checkGLError("shouldRenderClouds");
        return isShadowPass ? configCloudShadow : gs.h > 0;
    }

    public static void beginClouds() {
        fogEnabled = true;
        Shaders.pushEntity(-3, 0);
        Shaders.useProgram(6);
    }

    public static void endClouds() {
        Shaders.disableFog();
        Shaders.popEntity();
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void beginEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram(16);
            Shaders.resetDisplayListModels();
        }
    }

    public static void nextEntity(pk entity) {
        if (isRenderingWorld) {
            Shaders.useProgram(16);
            Shaders.setEntityId(entity);
        }
    }

    public static void setEntityId(pk entity) {
        if (isRenderingWorld && !isShadowPass && uniformEntityId.isDefined()) {
            int id = pm.a((pk)entity);
            uniformEntityId.setValue(id);
        }
    }

    public static void beginSpiderEyes() {
        if (isRenderingWorld && programsID[18] != programsID[0]) {
            Shaders.useProgram(18);
            bfl.d();
            bfl.a((int)516, (float)0.0f);
            bfl.b((int)770, (int)771);
        }
    }

    public static void endSpiderEyes() {
        if (isRenderingWorld && programsID[18] != programsID[0]) {
            Shaders.useProgram(16);
            bfl.c();
        }
    }

    public static void endEntities() {
        if (isRenderingWorld) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void setEntityColor(float r, float g2, float b2, float a2) {
        if (isRenderingWorld && !isShadowPass) {
            uniformEntityColor.setValue(r, g2, b2, a2);
        }
    }

    public static void beginLivingDamage() {
        if (isRenderingWorld) {
            ShadersTex.bindTexture(defaultTexture);
            if (!isShadowPass) {
                Shaders.setDrawBuffers(drawBuffersColorAtt0);
            }
        }
    }

    public static void endLivingDamage() {
        if (isRenderingWorld && !isShadowPass) {
            Shaders.setDrawBuffers(programsDrawBuffers[16]);
        }
    }

    public static void beginBlockEntities() {
        if (isRenderingWorld) {
            Shaders.checkGLError("beginBlockEntities");
            Shaders.useProgram(13);
        }
    }

    public static void nextBlockEntity(akw tileEntity) {
        if (isRenderingWorld) {
            Shaders.checkGLError("nextBlockEntity");
            Shaders.useProgram(13);
            Shaders.setBlockEntityId(tileEntity);
        }
    }

    public static void setBlockEntityId(akw tileEntity) {
        if (isRenderingWorld && !isShadowPass && uniformBlockEntityId.isDefined()) {
            afh block = tileEntity.w();
            int blockId = afh.a((afh)block);
            uniformBlockEntityId.setValue(blockId);
        }
    }

    public static void endBlockEntities() {
        if (isRenderingWorld) {
            Shaders.checkGLError("endBlockEntities");
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
            ShadersTex.bindNSTextures(defaultTexture.getMultiTexID());
        }
    }

    public static void beginLitParticles() {
        Shaders.useProgram(3);
    }

    public static void beginParticles() {
        Shaders.useProgram(2);
    }

    public static void endParticles() {
        Shaders.useProgram(3);
    }

    public static void readCenterDepth() {
        if (!isShadowPass && centerDepthSmoothEnabled) {
            tempDirectFloatBuffer.clear();
            GL11.glReadPixels((int)(renderWidth / 2), (int)(renderHeight / 2), (int)1, (int)1, (int)6402, (int)5126, (FloatBuffer)tempDirectFloatBuffer);
            centerDepth = tempDirectFloatBuffer.get(0);
            float fadeScalar = (float)diffSystemTime * 0.01f;
            float fadeFactor = (float)Math.exp(Math.log(0.5) * (double)fadeScalar / (double)centerDepthSmoothHalflife);
            centerDepthSmooth = centerDepthSmooth * fadeFactor + centerDepth * (1.0f - fadeFactor);
        }
    }

    public static void beginWeather() {
        if (!isShadowPass) {
            if (usedDepthBuffers >= 3) {
                bfl.g((int)33996);
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
                bfl.g((int)33984);
            }
            bfl.j();
            bfl.l();
            bfl.b((int)770, (int)771);
            bfl.d();
            Shaders.useProgram(20);
        }
    }

    public static void endWeather() {
        bfl.k();
        Shaders.useProgram(3);
    }

    public static void preWater() {
        if (usedDepthBuffers >= 2) {
            bfl.g((int)33995);
            Shaders.checkGLError("pre copy depth");
            GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)renderWidth, (int)renderHeight);
            Shaders.checkGLError("copy depth");
            bfl.g((int)33984);
        }
        ShadersTex.bindNSTextures(defaultTexture.getMultiTexID());
    }

    public static void beginWater() {
        if (isRenderingWorld) {
            if (!isShadowPass) {
                Shaders.renderDeferred();
                Shaders.useProgram(12);
                bfl.l();
                bfl.a((boolean)true);
            } else {
                bfl.a((boolean)true);
            }
        }
    }

    public static void endWater() {
        if (isRenderingWorld) {
            if (isShadowPass) {
                // empty if block
            }
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void beginProjectRedHalo() {
        if (isRenderingWorld) {
            Shaders.useProgram(1);
        }
    }

    public static void endProjectRedHalo() {
        if (isRenderingWorld) {
            Shaders.useProgram(3);
        }
    }

    public static void applyHandDepth() {
        if ((double)configHandDepthMul != 1.0) {
            GL11.glScaled((double)1.0, (double)1.0, (double)configHandDepthMul);
        }
    }

    public static void beginHand(boolean translucent) {
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5888);
        if (translucent) {
            Shaders.useProgram(41);
        } else {
            Shaders.useProgram(19);
        }
        Shaders.checkGLError("beginHand");
        Shaders.checkFramebufferStatus("beginHand");
    }

    public static void endHand() {
        Shaders.checkGLError("pre endHand");
        Shaders.checkFramebufferStatus("pre endHand");
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        bfl.b((int)770, (int)771);
        Shaders.checkGLError("endHand");
    }

    public static void beginFPOverlay() {
        bfl.f();
        bfl.k();
    }

    public static void endFPOverlay() {
    }

    public static void glEnableWrapper(int cap) {
        GL11.glEnable((int)cap);
        if (cap == 3553) {
            Shaders.enableTexture2D();
        } else if (cap == 2912) {
            Shaders.enableFog();
        }
    }

    public static void glDisableWrapper(int cap) {
        GL11.glDisable((int)cap);
        if (cap == 3553) {
            Shaders.disableTexture2D();
        } else if (cap == 2912) {
            Shaders.disableFog();
        }
    }

    public static void sglEnableT2D(int cap) {
        GL11.glEnable((int)cap);
        Shaders.enableTexture2D();
    }

    public static void sglDisableT2D(int cap) {
        GL11.glDisable((int)cap);
        Shaders.disableTexture2D();
    }

    public static void sglEnableFog(int cap) {
        GL11.glEnable((int)cap);
        Shaders.enableFog();
    }

    public static void sglDisableFog(int cap) {
        GL11.glDisable((int)cap);
        Shaders.disableFog();
    }

    public static void enableTexture2D() {
        if (isRenderingSky) {
            Shaders.useProgram(5);
        } else if (activeProgram == 1) {
            Shaders.useProgram(lightmapEnabled ? 3 : 2);
        }
    }

    public static void disableTexture2D() {
        if (isRenderingSky) {
            Shaders.useProgram(4);
        } else if (activeProgram == 2 || activeProgram == 3) {
            Shaders.useProgram(1);
        }
    }

    public static void beginLeash() {
        Shaders.useProgram(1);
    }

    public static void endLeash() {
        Shaders.useProgram(16);
    }

    public static void enableFog() {
        fogEnabled = true;
        Shaders.setProgramUniform1i("fogMode", fogMode);
    }

    public static void disableFog() {
        fogEnabled = false;
        Shaders.setProgramUniform1i("fogMode", 0);
    }

    public static void setFog(int fogMode) {
        bfl.d((int)fogMode);
        Shaders.fogMode = fogMode;
        if (fogEnabled) {
            Shaders.setProgramUniform1i("fogMode", fogMode);
        }
    }

    public static void sglFogi(int pname, int param) {
        GL11.glFogi((int)pname, (int)param);
        if (pname == 2917) {
            fogMode = param;
            if (fogEnabled) {
                Shaders.setProgramUniform1i("fogMode", fogMode);
            }
        }
    }

    public static void enableLightmap() {
        lightmapEnabled = true;
        if (activeProgram == 2) {
            Shaders.useProgram(3);
        }
    }

    public static void disableLightmap() {
        lightmapEnabled = false;
        if (activeProgram == 3) {
            Shaders.useProgram(2);
        }
    }

    public static int getEntityData() {
        return entityData[entityDataIndex * 2];
    }

    public static int getEntityData2() {
        return entityData[entityDataIndex * 2 + 1];
    }

    public static int setEntityData1(int data1) {
        Shaders.entityData[Shaders.entityDataIndex * 2] = entityData[entityDataIndex * 2] & 0xFFFF | data1 << 16;
        return data1;
    }

    public static int setEntityData2(int data2) {
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = entityData[entityDataIndex * 2 + 1] & 0xFFFF0000 | data2 & 0xFFFF;
        return data2;
    }

    public static void pushEntity(int data0, int data1) {
        Shaders.entityData[++Shaders.entityDataIndex * 2] = data0 & 0xFFFF | data1 << 16;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void pushEntity(int data0) {
        Shaders.entityData[++Shaders.entityDataIndex * 2] = data0 & 0xFFFF;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void pushEntity(afh block) {
        Shaders.entityData[++Shaders.entityDataIndex * 2] = afh.c.b((Object)block) & 0xFFFF | block.b() << 16;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
    }

    public static void popEntity() {
        Shaders.entityData[Shaders.entityDataIndex * 2] = 0;
        Shaders.entityData[Shaders.entityDataIndex * 2 + 1] = 0;
        --entityDataIndex;
    }

    public static void mcProfilerEndSection() {
        Shaders.mc.A.b();
    }

    public static String getShaderPackName() {
        if (shaderPack == null) {
            return null;
        }
        if (shaderPack instanceof ShaderPackNone) {
            return null;
        }
        return shaderPack.getName();
    }

    public static InputStream getShaderPackResourceStream(String path) {
        if (shaderPack == null) {
            return null;
        }
        return shaderPack.getResourceAsStream(path);
    }

    public static void nextAntialiasingLevel() {
        configAntialiasingLevel += 2;
        if ((configAntialiasingLevel = configAntialiasingLevel / 2 * 2) > 4) {
            configAntialiasingLevel = 0;
        }
        configAntialiasingLevel = Config.limit(configAntialiasingLevel, 0, 4);
    }

    public static void checkShadersModInstalled() {
        try {
            Class<?> cls = Class.forName("shadersmod.transform.SMCClassTransformer");
        }
        catch (Throwable e) {
            return;
        }
        throw new RuntimeException("Shaders Mod detected. Please remove it, OptiFine has built-in support for shaders.");
    }

    public static void resourcesReloaded() {
        Shaders.loadShaderPackResources();
        if (shaderPackLoaded) {
            BlockAliases.resourcesReloaded();
        }
    }

    private static void loadShaderPackResources() {
        shaderPackResources = new HashMap<String, String>();
        if (!shaderPackLoaded) {
            return;
        }
        ArrayList<String> listFiles = new ArrayList<String>();
        String PREFIX = "/shaders/lang/";
        String EN_US = "en_US";
        String SUFFIX = ".lang";
        listFiles.add(PREFIX + EN_US + SUFFIX);
        if (!Config.getGameSettings().aN.equals(EN_US)) {
            listFiles.add(PREFIX + Config.getGameSettings().aN + SUFFIX);
        }
        try {
            for (String file : listFiles) {
                InputStream in = shaderPack.getResourceAsStream(file);
                if (in == null) continue;
                Properties props = new Properties();
                Lang.loadLocaleData(in, props);
                in.close();
                Set<Object> keys = props.keySet();
                for (String string : keys) {
                    String value = props.getProperty(string);
                    shaderPackResources.put(string, value);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String translate(String key, String def) {
        String str = shaderPackResources.get(key);
        if (str == null) {
            return def;
        }
        return str;
    }

    public static boolean isProgramPath(String program) {
        if (program == null) {
            return false;
        }
        if (program.length() <= 0) {
            return false;
        }
        int pos = program.lastIndexOf("/");
        if (pos >= 0) {
            program = program.substring(pos + 1);
        }
        return Arrays.asList(programNames).contains(program);
    }

    public static void setItemToRenderMain(zx itemToRenderMain) {
        itemToRenderMainTranslucent = Shaders.isTranslucentBlock(itemToRenderMain);
    }

    public static boolean isItemToRenderMainTranslucent() {
        return itemToRenderMainTranslucent;
    }

    private static boolean isTranslucentBlock(zx stack) {
        if (stack == null) {
            return false;
        }
        zw item = stack.b();
        if (item == null) {
            return false;
        }
        if (!(item instanceof yo)) {
            return false;
        }
        yo itemBlock = (yo)item;
        afh block = itemBlock.d();
        if (block == null) {
            return false;
        }
        adf blockRenderLayer = block.m();
        return blockRenderLayer == adf.d;
    }

    public static boolean isRenderBothHands() {
        return false;
    }

    public static boolean isHandRenderedMain() {
        return isHandRenderedMain;
    }

    public static void setHandRenderedMain(boolean isHandRenderedMain) {
        Shaders.isHandRenderedMain = isHandRenderedMain;
    }

    public static float getShadowRenderDistance() {
        if (shadowDistanceRenderMul < 0.0f) {
            return -1.0f;
        }
        return shadowMapHalfPlane * shadowDistanceRenderMul;
    }

    public static void setRenderingFirstPersonHand(boolean flag) {
        isRenderingFirstPersonHand = flag;
    }

    public static boolean isRenderingFirstPersonHand() {
        return isRenderingFirstPersonHand;
    }

    public static void beginBeacon() {
        if (isRenderingWorld) {
            Shaders.useProgram(14);
        }
    }

    public static void endBeacon() {
        if (isRenderingWorld) {
            Shaders.useProgram(13);
        }
    }

    public static adm getCurrentWorld() {
        return currentWorld;
    }

    public static cj getCameraPosition() {
        return new cj(cameraPositionX, cameraPositionY, cameraPositionZ);
    }

    public static boolean isCustomUniforms() {
        return customUniforms != null;
    }

    static {
        isInitializedOnce = false;
        isShaderPackInitialized = false;
        hasGlGenMipmap = false;
        hasForge = false;
        numberResetDisplayList = 0;
        needResetModels = false;
        renderDisplayWidth = 0;
        renderDisplayHeight = 0;
        renderWidth = 0;
        renderHeight = 0;
        isRenderingWorld = false;
        isRenderingSky = false;
        isCompositeRendered = false;
        isRenderingDfb = false;
        isShadowPass = false;
        renderItemKeepDepthMask = false;
        itemToRenderMainTranslucent = false;
        sunPosition = new float[4];
        moonPosition = new float[4];
        shadowLightPosition = new float[4];
        upPosition = new float[4];
        shadowLightPositionVector = new float[4];
        upPosModelView = new float[]{0.0f, 100.0f, 0.0f, 0.0f};
        sunPosModelView = new float[]{0.0f, 100.0f, 0.0f, 0.0f};
        moonPosModelView = new float[]{0.0f, -100.0f, 0.0f, 0.0f};
        tempMat = new float[16];
        worldTime = 0L;
        lastWorldTime = 0L;
        diffWorldTime = 0L;
        celestialAngle = 0.0f;
        sunAngle = 0.0f;
        shadowAngle = 0.0f;
        moonPhase = 0;
        systemTime = 0L;
        lastSystemTime = 0L;
        diffSystemTime = 0L;
        frameCounter = 0;
        frameTime = 0.0f;
        frameTimeCounter = 0.0f;
        systemTimeInt32 = 0;
        rainStrength = 0.0f;
        wetness = 0.0f;
        wetnessHalfLife = 600.0f;
        drynessHalfLife = 200.0f;
        eyeBrightnessHalflife = 10.0f;
        usewetness = false;
        isEyeInWater = 0;
        eyeBrightness = 0;
        eyeBrightnessFadeX = 0.0f;
        eyeBrightnessFadeY = 0.0f;
        eyePosY = 0.0f;
        centerDepth = 0.0f;
        centerDepthSmooth = 0.0f;
        centerDepthSmoothHalflife = 1.0f;
        centerDepthSmoothEnabled = false;
        superSamplingLevel = 1;
        nightVision = 0.0f;
        blindness = 0.0f;
        updateChunksErrorRecorded = false;
        lightmapEnabled = false;
        fogEnabled = true;
        entityAttrib = 10;
        midTexCoordAttrib = 11;
        tangentAttrib = 12;
        useEntityAttrib = false;
        useMidTexCoordAttrib = false;
        useMultiTexCoord3Attrib = false;
        useTangentAttrib = false;
        progUseEntityAttrib = false;
        progUseMidTexCoordAttrib = false;
        progUseTangentAttrib = false;
        atlasSizeX = 0;
        atlasSizeY = 0;
        uniformEntityColor = new ShaderUniformFloat4("entityColor");
        uniformEntityId = new ShaderUniformInt("entityId");
        uniformBlockEntityId = new ShaderUniformInt("blockEntityId");
        shadowPassInterval = 0;
        needResizeShadow = false;
        shadowMapWidth = 1024;
        shadowMapHeight = 1024;
        spShadowMapWidth = 1024;
        spShadowMapHeight = 1024;
        shadowMapFOV = 90.0f;
        shadowMapHalfPlane = 160.0f;
        shadowMapIsOrtho = true;
        shadowDistanceRenderMul = -1.0f;
        shadowPassCounter = 0;
        shouldSkipDefaultShadow = false;
        waterShadowEnabled = false;
        usedColorBuffers = 0;
        usedDepthBuffers = 0;
        usedShadowColorBuffers = 0;
        usedShadowDepthBuffers = 0;
        usedColorAttachs = 0;
        usedDrawBuffers = 0;
        dfb = 0;
        sfb = 0;
        gbuffersFormat = new int[8];
        gbuffersClear = new boolean[8];
        activeProgram = 0;
        programNames = new String[]{"", "gbuffers_basic", "gbuffers_textured", "gbuffers_textured_lit", "gbuffers_skybasic", "gbuffers_skytextured", "gbuffers_clouds", "gbuffers_terrain", "gbuffers_terrain_solid", "gbuffers_terrain_cutout_mip", "gbuffers_terrain_cutout", "gbuffers_damagedblock", "gbuffers_water", "gbuffers_block", "gbuffers_beaconbeam", "gbuffers_item", "gbuffers_entities", "gbuffers_armor_glint", "gbuffers_spidereyes", "gbuffers_hand", "gbuffers_weather", "composite", "composite1", "composite2", "composite3", "composite4", "composite5", "composite6", "composite7", "final", "shadow", "shadow_solid", "shadow_cutout", "deferred", "deferred1", "deferred2", "deferred3", "deferred4", "deferred5", "deferred6", "deferred7", "gbuffers_hand_water", "deferred_last", "composite_last"};
        programBackups = new int[]{0, 0, 1, 2, 1, 2, 2, 3, 7, 7, 7, 7, 7, 7, 2, 3, 3, 2, 2, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 19, 0, 0};
        programsID = new int[44];
        programsRef = new int[44];
        programIDCopyDepth = 0;
        hasDeferredPrograms = false;
        programsDrawBufSettings = new String[44];
        newDrawBufSetting = null;
        programsDrawBuffers = new IntBuffer[44];
        activeDrawBuffers = null;
        programsColorAtmSettings = new String[44];
        newColorAtmSetting = null;
        activeColorAtmSettings = null;
        programsCompositeMipmapSetting = new int[44];
        newCompositeMipmapSetting = 0;
        activeCompositeMipmapSetting = 0;
        loadedShaders = null;
        shadersConfig = null;
        defaultTexture = null;
        normalMapEnabled = false;
        shadowHardwareFilteringEnabled = new boolean[2];
        shadowMipmapEnabled = new boolean[2];
        shadowFilterNearest = new boolean[2];
        shadowColorMipmapEnabled = new boolean[8];
        shadowColorFilterNearest = new boolean[8];
        configTweakBlockDamage = false;
        configCloudShadow = false;
        configHandDepthMul = 0.125f;
        configRenderResMul = 1.0f;
        configShadowResMul = 1.0f;
        configTexMinFilB = 0;
        configTexMinFilN = 0;
        configTexMinFilS = 0;
        configTexMagFilB = 0;
        configTexMagFilN = 0;
        configTexMagFilS = 0;
        configShadowClipFrustrum = true;
        configNormalMap = true;
        configSpecularMap = true;
        configOldLighting = new PropertyDefaultTrueFalse("oldLighting", "Classic Lighting", 0);
        configOldHandLight = new PropertyDefaultTrueFalse("oldHandLight", "Old Hand Light", 0);
        configAntialiasingLevel = 0;
        texMinFilDesc = new String[]{"Nearest", "Nearest-Nearest", "Nearest-Linear"};
        texMagFilDesc = new String[]{"Nearest", "Linear"};
        texMinFilValue = new int[]{9728, 9984, 9986};
        texMagFilValue = new int[]{9728, 9729};
        shaderPack = null;
        shaderPackLoaded = false;
        packNameNone = "OFF";
        packNameDefault = "(internal)";
        shaderpacksdirname = "shaderpacks";
        optionsfilename = "optionsshaders.txt";
        shadersdir = new File(ave.A().v, "shaders");
        shaderpacksdir = new File(ave.A().v, shaderpacksdirname);
        configFile = new File(ave.A().v, optionsfilename);
        shaderPackOptions = null;
        shaderPackOptionSliders = null;
        shaderPackProfiles = null;
        shaderPackGuiScreens = null;
        shaderPackClouds = new PropertyDefaultFastFancyOff("clouds", "Clouds", 0);
        shaderPackOldLighting = new PropertyDefaultTrueFalse("oldLighting", "Classic Lighting", 0);
        shaderPackOldHandLight = new PropertyDefaultTrueFalse("oldHandLight", "Old Hand Light", 0);
        shaderPackDynamicHandLight = new PropertyDefaultTrueFalse("dynamicHandLight", "Dynamic Hand Light", 0);
        shaderPackShadowTranslucent = new PropertyDefaultTrueFalse("shadowTranslucent", "Shadow Translucent", 0);
        shaderPackUnderwaterOverlay = new PropertyDefaultTrueFalse("underwaterOverlay", "Underwater Overlay", 0);
        shaderPackSun = new PropertyDefaultTrueFalse("sun", "Sun", 0);
        shaderPackMoon = new PropertyDefaultTrueFalse("moon", "Moon", 0);
        shaderPackVignette = new PropertyDefaultTrueFalse("vignette", "Vignette", 0);
        shaderPackBackFaceSolid = new PropertyDefaultTrueFalse("backFace.solid", "Back-face Solid", 0);
        shaderPackBackFaceCutout = new PropertyDefaultTrueFalse("backFace.cutout", "Back-face Cutout", 0);
        shaderPackBackFaceCutoutMipped = new PropertyDefaultTrueFalse("backFace.cutoutMipped", "Back-face Cutout Mipped", 0);
        shaderPackBackFaceTranslucent = new PropertyDefaultTrueFalse("backFace.translucent", "Back-face Translucent", 0);
        shaderPackResources = new HashMap<String, String>();
        currentWorld = null;
        shaderPackDimensions = new ArrayList<Integer>();
        customTexturesGbuffers = null;
        customTexturesComposite = null;
        customTexturesDeferred = null;
        noiseTexturePath = null;
        customUniforms = null;
        STAGE_NAMES = new String[]{"gbuffers", "composite", "deferred"};
        saveFinalShaders = System.getProperty("shaders.debug.save", "false").equals("true");
        blockLightLevel05 = 0.5f;
        blockLightLevel06 = 0.6f;
        blockLightLevel08 = 0.8f;
        aoLevel = -1.0f;
        sunPathRotation = 0.0f;
        shadowAngleInterval = 0.0f;
        fogMode = 0;
        shadowIntervalSize = 2.0f;
        terrainIconSize = 16;
        terrainTextureSize = new int[2];
        noiseTextureEnabled = false;
        noiseTextureResolution = 256;
        dfbColorTexturesA = new int[16];
        colorTexturesToggle = new int[8];
        colorTextureTextureImageUnit = new int[]{0, 1, 2, 3, 7, 8, 9, 10};
        programsToggleColorTextures = new boolean[44][8];
        bigBuffer = (ByteBuffer)BufferUtils.createByteBuffer((int)2548).limit(0);
        faProjection = new float[16];
        faProjectionInverse = new float[16];
        faModelView = new float[16];
        faModelViewInverse = new float[16];
        faShadowProjection = new float[16];
        faShadowProjectionInverse = new float[16];
        faShadowModelView = new float[16];
        faShadowModelViewInverse = new float[16];
        projection = Shaders.nextFloatBuffer(16);
        projectionInverse = Shaders.nextFloatBuffer(16);
        modelView = Shaders.nextFloatBuffer(16);
        modelViewInverse = Shaders.nextFloatBuffer(16);
        shadowProjection = Shaders.nextFloatBuffer(16);
        shadowProjectionInverse = Shaders.nextFloatBuffer(16);
        shadowModelView = Shaders.nextFloatBuffer(16);
        shadowModelViewInverse = Shaders.nextFloatBuffer(16);
        previousProjection = Shaders.nextFloatBuffer(16);
        previousModelView = Shaders.nextFloatBuffer(16);
        tempMatrixDirectBuffer = Shaders.nextFloatBuffer(16);
        tempDirectFloatBuffer = Shaders.nextFloatBuffer(16);
        dfbColorTextures = Shaders.nextIntBuffer(16);
        dfbDepthTextures = Shaders.nextIntBuffer(3);
        sfbColorTextures = Shaders.nextIntBuffer(8);
        sfbDepthTextures = Shaders.nextIntBuffer(2);
        dfbDrawBuffers = Shaders.nextIntBuffer(8);
        sfbDrawBuffers = Shaders.nextIntBuffer(8);
        drawBuffersNone = Shaders.nextIntBuffer(8);
        drawBuffersAll = Shaders.nextIntBuffer(8);
        drawBuffersClear0 = Shaders.nextIntBuffer(8);
        drawBuffersClear1 = Shaders.nextIntBuffer(8);
        drawBuffersClearColor = Shaders.nextIntBuffer(8);
        drawBuffersColorAtt0 = Shaders.nextIntBuffer(8);
        drawBuffersBuffer = Shaders.nextIntBufferArray(44, 8);
        drawBuffersNone.limit(0);
        drawBuffersColorAtt0.put(36064).position(0).limit(1);
        formatNames = new String[]{"R8", "RG8", "RGB8", "RGBA8", "R8_SNORM", "RG8_SNORM", "RGB8_SNORM", "RGBA8_SNORM", "R16", "RG16", "RGB16", "RGBA16", "R16_SNORM", "RG16_SNORM", "RGB16_SNORM", "RGBA16_SNORM", "R16F", "RG16F", "RGB16F", "RGBA16F", "R32F", "RG32F", "RGB32F", "RGBA32F", "R32I", "RG32I", "RGB32I", "RGBA32I", "R32UI", "RG32UI", "RGB32UI", "RGBA32UI", "R3_G3_B2", "RGB5_A1", "RGB10_A2", "R11F_G11F_B10F", "RGB9_E5"};
        formatIds = new int[]{33321, 33323, 32849, 32856, 36756, 36757, 36758, 36759, 33322, 33324, 32852, 32859, 36760, 36761, 36762, 36763, 33325, 33327, 34843, 34842, 33326, 33328, 34837, 34836, 33333, 33339, 36227, 36226, 33334, 33340, 36209, 36208, 10768, 32855, 32857, 35898, 35901};
        patternLoadEntityDataMap = Pattern.compile("\\s*([\\w:]+)\\s*=\\s*([-]?\\d+)\\s*");
        entityData = new int[32];
        entityDataIndex = 0;
    }
}

