/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.List;
import net.optifine.Config;
import net.optifine.reflect.Reflector;

public class SpriteDependencies {
    private static int countDependenciesTotal;

    public static dxb resolveDependencies(List<dxb> listRegisteredSprites, int ix, dxa textureMap) {
        dxb sprite = listRegisteredSprites.get(ix);
        while (SpriteDependencies.resolveOne(listRegisteredSprites, ix, sprite, textureMap)) {
            sprite = listRegisteredSprites.get(ix);
        }
        sprite.isDependencyParent = false;
        return sprite;
    }

    private static boolean resolveOne(List<dxb> listRegisteredSprites, int ix, dxb sprite, dxa textureMap) {
        int countDep = 0;
        for (qv locDep : sprite.getDependencies()) {
            Config.detail("Sprite dependency: " + sprite.m() + " <- " + locDep);
            ++countDependenciesTotal;
            dxb spriteDep = textureMap.getRegisteredSprite(locDep);
            if (spriteDep == null) {
                spriteDep = textureMap.registerSprite(locDep);
            } else {
                int ixDep = listRegisteredSprites.indexOf(spriteDep);
                if (ixDep <= ix + countDep) continue;
                if (spriteDep.isDependencyParent) {
                    String error = "circular dependency: " + sprite.m() + " -> " + spriteDep.m();
                    qv locSpritePng = textureMap.b(sprite.m());
                    Reflector.call(Reflector.ClientHooks_trackBrokenTexture, locSpritePng, error);
                    break;
                }
                listRegisteredSprites.remove(ixDep);
            }
            sprite.isDependencyParent = true;
            listRegisteredSprites.add(ix + countDep, spriteDep);
            ++countDep;
        }
        return countDep > 0;
    }

    public static void reset() {
        countDependenciesTotal = 0;
    }

    public static int getCountDependencies() {
        return countDependenciesTotal;
    }
}

