/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashSet;
import java.util.Set;

public class DynamicLight {
    private rr entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private boolean underwater = false;
    private long timeCheckMs = 0L;
    private Set<cj> setLitChunkPos = new HashSet<cj>();
    private cj.a blockPosMutable = new cj.a();

    public DynamicLight(rr entity) {
        this.entity = entity;
        this.offsetY = entity.bn();
    }

    public void update(bnl renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.p - 0.5;
        double posY = this.entity.q - 0.5 + this.offsetY;
        double posZ = this.entity.r - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        this.underwater = false;
        bkr world = renderGlobal.getWorld();
        if (world != null) {
            this.blockPosMutable.c(on.c((double)posX), on.c((double)posY), on.c((double)posZ));
            arc state = world.o((cj)this.blockPosMutable);
            ajt block = state.t();
            this.underwater = block == aju.j;
        }
        HashSet<cj> setNewPos = new HashSet<cj>();
        if (lightLevel > 0) {
            cq dirX = (on.c((double)posX) & 0xF) >= 8 ? cq.f : cq.e;
            cq dirY = (on.c((double)posY) & 0xF) >= 8 ? cq.b : cq.a;
            cq dirZ = (on.c((double)posZ) & 0xF) >= 8 ? cq.d : cq.c;
            cj chunkPos = new cj(posX, posY, posZ);
            bqc chunk = renderGlobal.getRenderChunk(chunkPos);
            cj chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            bqc chunkX = renderGlobal.getRenderChunk(chunkPosX);
            cj chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            bqc chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            cj chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            bqc chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            cj chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            bqc chunkY = renderGlobal.getRenderChunk(chunkPosY);
            cj chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            bqc chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            cj chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            bqc chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            cj chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            bqc chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private cj getChunkPos(bqc renderChunk, cj pos, cq facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(bqc renderChunk, Set<cj> setPrevPos, Set<cj> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        bpz compiledChunk = renderChunk.h();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
        }
        cj pos = renderChunk.k().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(bnl renderGlobal) {
        for (cj posOld : this.setLitChunkPos) {
            bqc chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public rr getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public boolean isUnderwater() {
        return this.underwater;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

