/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.client;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import shadersmod.client.ShaderOption;

public class ShaderProfile {
    private String name = null;
    private Map<String, String> mapOptionValues = new LinkedHashMap<String, String>();
    private Set<String> disabledPrograms = new LinkedHashSet<String>();

    public ShaderProfile(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addOptionValue(String option, String value) {
        this.mapOptionValues.put(option, value);
    }

    public void addOptionValues(ShaderProfile prof) {
        if (prof == null) {
            return;
        }
        this.mapOptionValues.putAll(prof.mapOptionValues);
    }

    public void applyOptionValues(ShaderOption[] options) {
        for (int i = 0; i < options.length; ++i) {
            ShaderOption so2 = options[i];
            String key = so2.getName();
            String val = this.mapOptionValues.get(key);
            if (val == null) continue;
            so2.setValue(val);
        }
    }

    public String[] getOptions() {
        Set<String> keys = this.mapOptionValues.keySet();
        String[] opts = keys.toArray(new String[keys.size()]);
        return opts;
    }

    public String getValue(String key) {
        return this.mapOptionValues.get(key);
    }

    public void addDisabledProgram(String program) {
        this.disabledPrograms.add(program);
    }

    public void removeDisabledProgram(String program) {
        this.disabledPrograms.remove(program);
    }

    public Collection<String> getDisabledPrograms() {
        return new LinkedHashSet<String>(this.disabledPrograms);
    }

    public void addDisabledPrograms(Collection<String> programs) {
        this.disabledPrograms.addAll(programs);
    }

    public boolean isProgramDisabled(String program) {
        return this.disabledPrograms.contains(program);
    }
}

