/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Collection;
import java.util.List;
import net.optifine.render.RenderEnv;

public class BlockUtils {
    private static final ThreadLocal<RenderSideCacheKey> threadLocalKey = ThreadLocal.withInitial(() -> new RenderSideCacheKey(null, null, null));
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> threadLocalMap = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(200){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    public static boolean shouldSideBeRendered(byj blockStateIn, bjg blockReaderIn, fk blockPosIn, fp facingIn, RenderEnv renderEnv) {
        fk posNeighbour = blockPosIn.a(facingIn);
        byj stateNeighbour = blockReaderIn.d_(posNeighbour);
        if (blockStateIn.a(stateNeighbour, facingIn)) {
            return false;
        }
        if (stateNeighbour.o()) {
            return BlockUtils.shouldSideBeRenderedCached(blockStateIn, blockReaderIn, blockPosIn, facingIn, renderEnv, stateNeighbour, posNeighbour);
        }
        return true;
    }

    public static boolean shouldSideBeRenderedCached(byj blockStateIn, bjg blockReaderIn, fk blockPosIn, fp facingIn, RenderEnv renderEnv, byj stateNeighbourIn, fk posNeighbourIn) {
        long key = (long)blockStateIn.getBlockStateId() << 36 | (long)stateNeighbourIn.getBlockStateId() << 4 | (long)facingIn.ordinal();
        Long2ByteLinkedOpenHashMap map = renderEnv.getRenderSideMap();
        byte b0 = map.getAndMoveToFirst(key);
        if (b0 != 0) {
            return b0 > 0;
        }
        cwf voxelshape = blockStateIn.a(blockReaderIn, blockPosIn, facingIn);
        cwf voxelshape1 = stateNeighbourIn.a(blockReaderIn, posNeighbourIn, facingIn.e());
        boolean flag = cwc.c((cwf)voxelshape, (cwf)voxelshape1, (cvp)cvp.e);
        if (map.size() > 400) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst(key, (byte)(flag ? 1 : -1));
        return flag;
    }

    public static int getBlockId(bph block) {
        return gb.j.a((Object)block);
    }

    public static bph getBlock(sm loc) {
        if (!gb.j.c(loc)) {
            return null;
        }
        return (bph)gb.j.a(loc);
    }

    public static int getMetadata(byj blockState) {
        bph block = blockState.d();
        byk stateContainer = block.o();
        ImmutableList validStates = stateContainer.a();
        int metadata = validStates.indexOf(blockState);
        return metadata;
    }

    public static int getMetadataCount(bph block) {
        byk stateContainer = block.o();
        ImmutableList validStates = stateContainer.a();
        return validStates.size();
    }

    public static byj getBlockState(bph block, int metadata) {
        byk stateContainer = block.o();
        ImmutableList validStates = stateContainer.a();
        if (metadata < 0 || metadata >= validStates.size()) {
            return null;
        }
        byj blockState = (byj)validStates.get(metadata);
        return blockState;
    }

    public static List<byj> getBlockStates(bph block) {
        byk stateContainer = block.o();
        ImmutableList validStates = stateContainer.a();
        return validStates;
    }

    public static boolean isFullCube(byj stateIn, bjg blockReaderIn, fk posIn) {
        return bph.a((cwf)stateIn.i(blockReaderIn, posIn));
    }

    public static Collection<bzm> getProperties(byj blockState) {
        return blockState.a();
    }

    public static final class RenderSideCacheKey {
        private byj blockState1;
        private byj blockState2;
        private fp facing;
        private int hashCode;

        private RenderSideCacheKey(byj blockState1In, byj blockState2In, fp facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
        }

        private void init(byj blockState1In, byj blockState2In, fp facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
            this.hashCode = 0;
        }

        public RenderSideCacheKey duplicate() {
            return new RenderSideCacheKey(this.blockState1, this.blockState2, this.facing);
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey block$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.blockState1 == block$rendersidecachekey.blockState1 && this.blockState2 == block$rendersidecachekey.blockState2 && this.facing == block$rendersidecachekey.facing;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 31 * this.hashCode + this.blockState1.hashCode();
                this.hashCode = 31 * this.hashCode + this.blockState2.hashCode();
                this.hashCode = 31 * this.hashCode + this.facing.hashCode();
            }
            return this.hashCode;
        }
    }
}

