/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import net.optifine.Log;
import net.optifine.reflect.IResolvable;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorClass;
import net.optifine.reflect.ReflectorResolver;

public class ReflectorMethod
implements IResolvable {
    private ReflectorClass reflectorClass = null;
    private String targetMethodName = null;
    private Class[] targetMethodParameterTypes = null;
    private boolean checked = false;
    private Method targetMethod = null;

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName) {
        this(reflectorClass, targetMethodName, null);
    }

    public ReflectorMethod(ReflectorClass reflectorClass, String targetMethodName, Class[] targetMethodParameterTypes) {
        this.reflectorClass = reflectorClass;
        this.targetMethodName = targetMethodName;
        this.targetMethodParameterTypes = targetMethodParameterTypes;
        ReflectorResolver.register(this);
    }

    public Method getTargetMethod() {
        if (this.checked) {
            return this.targetMethod;
        }
        this.checked = true;
        Class cls = this.reflectorClass.getTargetClass();
        if (cls == null) {
            return null;
        }
        try {
            if (this.targetMethodParameterTypes == null) {
                Method[] ms = ReflectorMethod.getMethods(cls, this.targetMethodName);
                if (ms.length <= 0) {
                    Log.log("(Reflector) Method not present: " + cls.getName() + "." + this.targetMethodName);
                    return null;
                }
                if (ms.length > 1) {
                    Log.warn("(Reflector) More than one method found: " + cls.getName() + "." + this.targetMethodName);
                    for (int i2 = 0; i2 < ms.length; ++i2) {
                        Method m2 = ms[i2];
                        Log.warn("(Reflector)  - " + m2);
                    }
                    return null;
                }
                this.targetMethod = ms[0];
            } else {
                this.targetMethod = ReflectorMethod.getMethod(cls, this.targetMethodName, this.targetMethodParameterTypes);
            }
            if (this.targetMethod == null) {
                Log.log("(Reflector) Method not present: " + cls.getName() + "." + this.targetMethodName);
                return null;
            }
            this.targetMethod.setAccessible(true);
            return this.targetMethod;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public boolean exists() {
        if (this.checked) {
            return this.targetMethod != null;
        }
        return this.getTargetMethod() != null;
    }

    public Class getReturnType() {
        Method tm = this.getTargetMethod();
        if (tm == null) {
            return null;
        }
        return tm.getReturnType();
    }

    public void deactivate() {
        this.checked = true;
        this.targetMethod = null;
    }

    public Object call(Object ... params) {
        return Reflector.call(this, params);
    }

    public boolean callBoolean(Object ... params) {
        return Reflector.callBoolean(this, params);
    }

    public int callInt(Object ... params) {
        return Reflector.callInt(this, params);
    }

    public float callFloat(Object ... params) {
        return Reflector.callFloat(this, params);
    }

    public double callDouble(Object ... params) {
        return Reflector.callDouble(this, params);
    }

    public String callString(Object ... params) {
        return Reflector.callString(this, params);
    }

    public void callVoid(Object ... params) {
        Reflector.callVoid(this, params);
    }

    public static Method getMethod(Class cls, String methodName, Class[] paramTypes) {
        Method[] ms = cls.getDeclaredMethods();
        for (int i2 = 0; i2 < ms.length; ++i2) {
            Class[] types;
            Method m2 = ms[i2];
            if (!m2.getName().equals(methodName) || !Reflector.matchesTypes(paramTypes, types = m2.getParameterTypes())) continue;
            return m2;
        }
        return null;
    }

    public static Method[] getMethods(Class cls, String methodName) {
        ArrayList<Method> listMethods = new ArrayList<Method>();
        Method[] ms = cls.getDeclaredMethods();
        for (int i2 = 0; i2 < ms.length; ++i2) {
            Method m2 = ms[i2];
            if (!m2.getName().equals(methodName)) continue;
            listMethods.add(m2);
        }
        Method[] methods = listMethods.toArray(new Method[listMethods.size()]);
        return methods;
    }

    @Override
    public void resolve() {
        Method m2 = this.getTargetMethod();
    }
}

