/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private akq entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<fk> setLitChunkPos = new HashSet<fk>();
    private fk.a blockPosMutable = new fk.a();

    public DynamicLight(akq entity) {
        this.entity = entity;
        this.offsetY = entity.bV();
    }

    public void update(dqr renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.ct() - 0.5;
        double posY = this.entity.cu() - 0.5 + this.offsetY;
        double posZ = this.entity.cx() - 0.5;
        int lightLevel = DynamicLights.getLightLevel(this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet<fk> setNewPos = new HashSet<fk>();
        if (lightLevel > 0) {
            fp dirX = (abr.c((double)posX) & 0xF) >= 8 ? fp.f : fp.e;
            fp dirY = (abr.c((double)posY) & 0xF) >= 8 ? fp.b : fp.a;
            fp dirZ = (abr.c((double)posZ) & 0xF) >= 8 ? fp.d : fp.c;
            fk chunkPos = new fk(posX, posY, posZ);
            dth.c chunk = renderGlobal.getRenderChunk(chunkPos);
            fk chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            dth.c chunkX = renderGlobal.getRenderChunk(chunkPosX);
            fk chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            dth.c chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            fk chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            dth.c chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            fk chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            dth.c chunkY = renderGlobal.getRenderChunk(chunkPosY);
            fk chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            dth.c chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            fk chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            dth.c chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            fk chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            dth.c chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private fk getChunkPos(dth.c renderChunk, fk pos, fp facing) {
        if (renderChunk != null) {
            return renderChunk.a(facing);
        }
        return pos.a(facing, 16);
    }

    private void updateChunkLight(dth.c renderChunk, Set<fk> setPrevPos, Set<fk> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        dth.b compiledChunk = renderChunk.c();
        if (compiledChunk != null && !compiledChunk.a()) {
            renderChunk.a(false);
        }
        fk pos = renderChunk.e().h();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(dqr renderGlobal) {
        for (fk posOld : this.setLitChunkPos) {
            dth.c chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public akq getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + this.entity + ", offsetY: " + this.offsetY;
    }
}

