/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.Config;
import net.optifine.CustomGuis;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<sm, sm> textureLocations = null;
    private NbtTagValue nbtName = null;
    private bkt[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private bdj[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final bdj[] COLORS_INVALID = new bdj[0];
    private static final sm ANVIL_GUI_TEXTURE = new sm("textures/gui/container/anvil.png");
    private static final sm BEACON_GUI_TEXTURE = new sm("textures/gui/container/beacon.png");
    private static final sm BREWING_STAND_GUI_TEXTURE = new sm("textures/gui/container/brewing_stand.png");
    private static final sm CHEST_GUI_TEXTURE = new sm("textures/gui/container/generic_54.png");
    private static final sm CRAFTING_TABLE_GUI_TEXTURE = new sm("textures/gui/container/crafting_table.png");
    private static final sm HORSE_GUI_TEXTURE = new sm("textures/gui/container/horse.png");
    private static final sm DISPENSER_GUI_TEXTURE = new sm("textures/gui/container/dispenser.png");
    private static final sm ENCHANTMENT_TABLE_GUI_TEXTURE = new sm("textures/gui/container/enchanting_table.png");
    private static final sm FURNACE_GUI_TEXTURE = new sm("textures/gui/container/furnace.png");
    private static final sm HOPPER_GUI_TEXTURE = new sm("textures/gui/container/hopper.png");
    private static final sm INVENTORY_GUI_TEXTURE = new sm("textures/gui/container/inventory.png");
    private static final sm SHULKER_BOX_GUI_TEXTURE = new sm("textures/gui/container/shulker_box.png");
    private static final sm VILLAGER_GUI_TEXTURE = new sm("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations(props, "texture", this.container, "textures/gui/", this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListInt(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        Enum[] vars = CustomGuiProperties.getContainerVariants(this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), vars, "variants", VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors(props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static bdj[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize(str, " ");
        bdj[] cols = new bdj[tokens.length];
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            bdj col = CustomGuiProperties.parseEnumDyeColor(token);
            if (col == null) {
                CustomGuiProperties.warn("Invalid color: " + token);
                return COLORS_INVALID;
            }
            cols[i2] = col;
        }
        return cols;
    }

    private static bdj parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        bdj[] colors = bdj.values();
        for (int i2 = 0; i2 < colors.length; ++i2) {
            bdj enumDyeColor = colors[i2];
            if (enumDyeColor.o().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.b().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static sm parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        String tex = TextureUtils.fixResourcePath(str = str.trim(), basePath);
        if (!tex.endsWith(".png")) {
            tex = tex + ".png";
        }
        return new sm(basePath + "/" + tex);
    }

    private static Map<sm, sm> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<sm, sm> map = new HashMap<sm, sm>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            sm locKey = CustomGuiProperties.getGuiTextureLocation(container);
            sm locVal = CustomGuiProperties.parseTextureLocation(propVal, basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix(pathRel, "/", ".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            sm locKey = new sm(path);
            sm locVal = CustomGuiProperties.parseTextureLocation(val, basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static sm getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (container) {
            case ANVIL: {
                return ANVIL_GUI_TEXTURE;
            }
            case BEACON: {
                return BEACON_GUI_TEXTURE;
            }
            case BREWING_STAND: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case CHEST: {
                return CHEST_GUI_TEXTURE;
            }
            case CRAFTING: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case CREATIVE: {
                return null;
            }
            case DISPENSER: {
                return DISPENSER_GUI_TEXTURE;
            }
            case ENCHANTMENT: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case FURNACE: {
                return FURNACE_GUI_TEXTURE;
            }
            case HOPPER: {
                return HOPPER_GUI_TEXTURE;
            }
            case HORSE: {
                return HORSE_GUI_TEXTURE;
            }
            case INVENTORY: {
                return INVENTORY_GUI_TEXTURE;
            }
            case SHULKER_BOX: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case VILLAGER: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn("No base path found: " + path);
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn("No container found: " + path);
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn("No texture found: " + path);
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn("Invalid professions or careers: " + path);
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn("Invalid variants: " + path);
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn("Invalid colors: " + path);
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }

    private boolean matchesGeneral(EnumContainer ec, fk pos, bjz blockAccess) {
        bkt biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome(biome = blockAccess.t(pos), this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.p());
    }

    public boolean matchesPos(EnumContainer ec, fk pos, bjz blockAccess, dgb screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName(screen))) {
            return false;
        }
        switch (ec) {
            case BEACON: {
                return this.matchesBeacon(pos, (bje)blockAccess);
            }
            case CHEST: {
                return this.matchesChest(pos, (bje)blockAccess);
            }
            case DISPENSER: {
                return this.matchesDispenser(pos, (bje)blockAccess);
            }
            case SHULKER_BOX: {
                return this.matchesShulker(pos, (bje)blockAccess);
            }
        }
        return true;
    }

    public static String getName(dgb screen) {
        lf itc = screen.getTitle();
        if (itc == null) {
            return null;
        }
        return itc.d();
    }

    private boolean matchesBeacon(fk pos, bje blockAccess) {
        int l;
        bwl te = blockAccess.c(pos);
        if (!(te instanceof bwg)) {
            return false;
        }
        bwg teb = (bwg)te;
        return this.levels == null || this.levels.isInRange(l = teb.h());
    }

    private boolean matchesChest(fk pos, bje blockAccess) {
        bwl te = blockAccess.c(pos);
        if (te instanceof bwp) {
            bwp tec = (bwp)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof bwx) {
            bwx teec = (bwx)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(bwp tec, fk pos, bje blockAccess) {
        byj blockState = blockAccess.d_(pos);
        bzc chestType = blockState.b((bzm)bpw.c) ? (bzc)blockState.c((bzm)bpw.c) : bzc.a;
        boolean isLarge = chestType == bzc.a;
        boolean isTrapped = tec instanceof bxp;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(bwx teec, fk pos, bje blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(fk pos, bje blockAccess) {
        EnumVariant var;
        bwl te = blockAccess.c(pos);
        if (!(te instanceof bwu)) {
            return false;
        }
        bwu ted = (bwu)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(bwu ted) {
        if (ted instanceof bwv) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(fk pos, bje blockAccess) {
        bdj col;
        bwl te = blockAccess.c(pos);
        if (!(te instanceof bxg)) {
            return false;
        }
        bxg tesb = (bxg)te;
        return this.colors == null || Config.equalsOne(col = tesb.k(), this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, akq entity, bjz blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.bW(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.bL())) {
            return false;
        }
        switch (ec) {
            case VILLAGER: {
                return this.matchesVillager(entity, (bje)blockAccess);
            }
            case HORSE: {
                return this.matchesHorse(entity, (bje)blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(akq entity, bje blockAccess) {
        int level;
        axx vd;
        axz vp;
        if (!(entity instanceof axw)) {
            return false;
        }
        axw entityVillager = (axw)entity;
        return this.professions == null || MatchProfession.matchesOne(vp = (vd = entityVillager.eA()).b(), level = vd.c(), this.professions);
    }

    private boolean matchesHorse(akq entity, bje blockAccess) {
        auh el;
        bdj col;
        EnumVariant var;
        if (!(entity instanceof aue)) {
            return false;
        }
        aue ah = (aue)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof auh) || Config.equalsOne(col = (el = (auh)ah).eZ(), this.colors);
    }

    private EnumVariant getHorseVariant(aue entity) {
        if (entity instanceof aug) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof auf) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof aui) {
            return EnumVariant.MULE;
        }
        if (entity instanceof auh) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public sm getTextureLocation(sm loc) {
        sm locNew = this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + (Object)((Object)this.container) + ", textures: " + this.textureLocations;
    }

    private static enum EnumVariant {
        HORSE,
        DONKEY,
        MULE,
        LLAMA,
        DISPENSER,
        DROPPER;

    }

    public static enum EnumContainer {
        ANVIL,
        BEACON,
        BREWING_STAND,
        CHEST,
        CRAFTING,
        DISPENSER,
        ENCHANTMENT,
        FURNACE,
        HOPPER,
        HORSE,
        VILLAGER,
        SHULKER_BOX,
        CREATIVE,
        INVENTORY;

    }
}

