/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<nd, nd> textureLocations = null;
    private NbtTagValue nbtName = null;
    private anf[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private VillagerProfession[] professions = null;
    private EnumVariant[] variants = null;
    private ahq[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final ahq[] COLORS_INVALID = new ahq[0];
    private static final nd ANVIL_GUI_TEXTURE = new nd("textures/gui/container/anvil.png");
    private static final nd BEACON_GUI_TEXTURE = new nd("textures/gui/container/beacon.png");
    private static final nd BREWING_STAND_GUI_TEXTURE = new nd("textures/gui/container/brewing_stand.png");
    private static final nd CHEST_GUI_TEXTURE = new nd("textures/gui/container/generic_54.png");
    private static final nd CRAFTING_TABLE_GUI_TEXTURE = new nd("textures/gui/container/crafting_table.png");
    private static final nd HORSE_GUI_TEXTURE = new nd("textures/gui/container/horse.png");
    private static final nd DISPENSER_GUI_TEXTURE = new nd("textures/gui/container/dispenser.png");
    private static final nd ENCHANTMENT_TABLE_GUI_TEXTURE = new nd("textures/gui/container/enchanting_table.png");
    private static final nd FURNACE_GUI_TEXTURE = new nd("textures/gui/container/furnace.png");
    private static final nd HOPPER_GUI_TEXTURE = new nd("textures/gui/container/hopper.png");
    private static final nd INVENTORY_GUI_TEXTURE = new nd("textures/gui/container/inventory.png");
    private static final nd SHULKER_BOX_GUI_TEXTURE = new nd("textures/gui/container/shulker_box.png");
    private static final nd VILLAGER_GUI_TEXTURE = new nd("textures/gui/container/villager.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations(props, "texture", this.container, "textures/gui/", this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListInt(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        Enum[] vars = CustomGuiProperties.getContainerVariants(this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), vars, "variants", VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors(props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static ahq[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize(str, " ");
        ahq[] cols = new ahq[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            ahq col = CustomGuiProperties.parseEnumDyeColor(token);
            if (col == null) {
                CustomGuiProperties.warn("Invalid color: " + token);
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static ahq parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        ahq[] colors = ahq.values();
        for (int i = 0; i < colors.length; ++i) {
            ahq enumDyeColor = colors[i];
            if (enumDyeColor.m().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.d().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static nd parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        String tex = TextureUtils.fixResourcePath(str = str.trim(), basePath);
        if (!tex.endsWith(".png")) {
            tex = tex + ".png";
        }
        return new nd(basePath + "/" + tex);
    }

    private static Map<nd, nd> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<nd, nd> map = new HashMap<nd, nd>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            nd locKey = CustomGuiProperties.getGuiTextureLocation(container);
            nd locVal = CustomGuiProperties.parseTextureLocation(propVal, basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix(pathRel, "/", ".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            nd locKey = new nd(path);
            nd locVal = CustomGuiProperties.parseTextureLocation(val, basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static nd getGuiTextureLocation(EnumContainer container) {
        switch (container) {
            case ANVIL: {
                return ANVIL_GUI_TEXTURE;
            }
            case BEACON: {
                return BEACON_GUI_TEXTURE;
            }
            case BREWING_STAND: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case CHEST: {
                return CHEST_GUI_TEXTURE;
            }
            case CRAFTING: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case CREATIVE: {
                return null;
            }
            case DISPENSER: {
                return DISPENSER_GUI_TEXTURE;
            }
            case ENCHANTMENT: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case FURNACE: {
                return FURNACE_GUI_TEXTURE;
            }
            case HOPPER: {
                return HOPPER_GUI_TEXTURE;
            }
            case HORSE: {
                return HORSE_GUI_TEXTURE;
            }
            case INVENTORY: {
                return INVENTORY_GUI_TEXTURE;
            }
            case SHULKER_BOX: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case VILLAGER: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn("No base path found: " + path);
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn("No container found: " + path);
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn("No texture found: " + path);
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn("Invalid professions or careers: " + path);
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn("Invalid variants: " + path);
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn("Invalid colors: " + path);
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }

    private boolean matchesGeneral(EnumContainer ec, et pos, amw blockAccess) {
        anf biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome(biome = blockAccess.b(pos), this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.q());
    }

    public boolean matchesPos(EnumContainer ec, et pos, amw blockAccess, bli screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName(screen))) {
            return false;
        }
        switch (ec) {
            case BEACON: {
                return this.matchesBeacon(pos, blockAccess);
            }
            case CHEST: {
                return this.matchesChest(pos, blockAccess);
            }
            case DISPENSER: {
                return this.matchesDispenser(pos, blockAccess);
            }
            case SHULKER_BOX: {
                return this.matchesShulker(pos, blockAccess);
            }
        }
        return true;
    }

    public static String getName(bli screen) {
        ug nameable = CustomGuiProperties.getWorldNameable(screen);
        if (nameable == null) {
            return null;
        }
        return nameable.i_().c();
    }

    private static ug getWorldNameable(bli screen) {
        if (screen instanceof bmg) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiBeacon_tileBeacon);
        }
        if (screen instanceof bmi) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiBrewingStand_tileBrewingStand);
        }
        if (screen instanceof bmk) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiChest_lowerChestInventory);
        }
        if (screen instanceof bmo) {
            return ((bmo)screen).v;
        }
        if (screen instanceof bmr) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiEnchantment_nameable);
        }
        if (screen instanceof bms) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiFurnace_tileFurnace);
        }
        if (screen instanceof bmt) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiHopper_hopperInventory);
        }
        if (screen instanceof bmy) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiShulkerBox_inventory);
        }
        return null;
    }

    private static ug getWorldNameable(bli screen, ReflectorField fieldInventory) {
        Object obj = Reflector.getFieldValue(screen, fieldInventory);
        if (!(obj instanceof ug)) {
            return null;
        }
        return (ug)obj;
    }

    private boolean matchesBeacon(et pos, amw blockAccess) {
        int l;
        avh te = blockAccess.r(pos);
        if (!(te instanceof avf)) {
            return false;
        }
        avf teb = (avf)te;
        return this.levels == null || this.levels.isInRange(l = teb.s());
    }

    private boolean matchesChest(et pos, amw blockAccess) {
        avh te = blockAccess.r(pos);
        if (te instanceof avj) {
            avj tec = (avj)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof avq) {
            avq teec = (avq)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(avj tec, et pos, amw blockAccess) {
        boolean isLarge = tec.h != null || tec.g != null || tec.f != null || tec.i != null;
        boolean isTrapped = tec.p() == apg.a.b;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(avq teec, et pos, amw blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(et pos, amw blockAccess) {
        EnumVariant var;
        avh te = blockAccess.r(pos);
        if (!(te instanceof avn)) {
            return false;
        }
        avn ted = (avn)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(avn ted) {
        if (ted instanceof avo) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(et pos, amw blockAccess) {
        ahq col;
        avh te = blockAccess.r(pos);
        if (!(te instanceof avz)) {
            return false;
        }
        avz tesb = (avz)te;
        return this.colors == null || Config.equalsOne(col = tesb.s(), this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, ve entity, amw blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.c(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.h_())) {
            return false;
        }
        switch (ec) {
            case VILLAGER: {
                return this.matchesVillager(entity, blockAccess);
            }
            case HORSE: {
                return this.matchesHorse(entity, blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(ve entity, amw blockAccess) {
        if (!(entity instanceof adw)) {
            return false;
        }
        adw entityVillager = (adw)entity;
        if (this.professions != null) {
            int profInt = entityVillager.dl();
            int careerInt = Reflector.getFieldValueInt(entityVillager, Reflector.EntityVillager_careerId, -1);
            if (careerInt < 0) {
                return false;
            }
            boolean matchProfession = false;
            for (int i = 0; i < this.professions.length; ++i) {
                VillagerProfession prof = this.professions[i];
                if (!prof.matches(profInt, careerInt)) continue;
                matchProfession = true;
                break;
            }
            if (!matchProfession) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesHorse(ve entity, amw blockAccess) {
        aaq el;
        ahq col;
        EnumVariant var;
        if (!(entity instanceof aam)) {
            return false;
        }
        aam ah = (aam)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof aaq) || Config.equalsOne(col = (el = (aaq)ah).dT(), this.colors);
    }

    private EnumVariant getHorseVariant(aam entity) {
        if (entity instanceof aao) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof aan) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof aar) {
            return EnumVariant.MULE;
        }
        if (entity instanceof aaq) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public nd getTextureLocation(nd loc) {
        nd locNew = this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + (Object)((Object)this.container) + ", textures: " + this.textureLocations;
    }

    private static enum EnumVariant {
        HORSE,
        DONKEY,
        MULE,
        LLAMA,
        DISPENSER,
        DROPPER;

    }

    public static enum EnumContainer {
        ANVIL,
        BEACON,
        BREWING_STAND,
        CHEST,
        CRAFTING,
        DISPENSER,
        ENCHANTMENT,
        FURNACE,
        HOPPER,
        HORSE,
        VILLAGER,
        SHULKER_BOX,
        CREATIVE,
        INVENTORY;

    }
}

