/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.optifine.render.VboRange;
import net.optifine.util.LinkedList;

public class VboRegion {
    private axk layer = null;
    private int glBufferId = dhp.e();
    private int capacity = 4096;
    private int positionTop = 0;
    private int sizeUsed;
    private LinkedList<VboRange> rangeList = new LinkedList();
    private VboRange compactRangeLast = null;
    private IntBuffer bufferIndexVertex = Config.createDirectIntBuffer(this.capacity);
    private IntBuffer bufferCountVertex = Config.createDirectIntBuffer(this.capacity);
    private final int vertexBytes = ddt.g.g();

    public VboRegion(axk layer) {
        this.layer = layer;
        this.bindBuffer();
        long capacityBytes = this.toBytes(this.capacity);
        dhp.glBufferData((int)dhp.R, (long)capacityBytes, (int)dhp.S);
        this.unbindBuffer();
    }

    public void bufferData(ByteBuffer data, VboRange range) {
        int posOld = range.getPosition();
        int sizeOld = range.getSize();
        int sizeNew = this.toVertex(data.limit());
        if (sizeNew <= 0) {
            if (posOld >= 0) {
                range.setPosition(-1);
                range.setSize(0);
                this.rangeList.remove(range.getNode());
                this.sizeUsed -= sizeOld;
            }
            return;
        }
        if (sizeNew > sizeOld) {
            range.setPosition(this.positionTop);
            range.setSize(sizeNew);
            this.positionTop += sizeNew;
            if (posOld >= 0) {
                this.rangeList.remove(range.getNode());
            }
            this.rangeList.addLast(range.getNode());
        }
        range.setSize(sizeNew);
        this.sizeUsed += sizeNew - sizeOld;
        this.checkVboSize(range.getPositionNext());
        long positionBytes = this.toBytes(range.getPosition());
        this.bindBuffer();
        dhp.glBufferSubData((int)dhp.R, (long)positionBytes, (ByteBuffer)data);
        this.unbindBuffer();
        if (this.positionTop > this.sizeUsed * 11 / 10) {
            this.compactRanges(1);
        }
    }

    private void compactRanges(int countMax) {
        if (this.rangeList.isEmpty()) {
            return;
        }
        VboRange range = this.compactRangeLast;
        if (range == null || !this.rangeList.contains(range.getNode())) {
            range = this.rangeList.getFirst().getItem();
        }
        int posCompact = range.getPosition();
        VboRange rangePrev = range.getPrev();
        posCompact = rangePrev == null ? 0 : rangePrev.getPositionNext();
        for (int count = 0; range != null && count < countMax; ++count) {
            if (range.getPosition() == posCompact) {
                posCompact += range.getSize();
                range = range.getNext();
                continue;
            }
            int sizeFree = range.getPosition() - posCompact;
            if (range.getSize() <= sizeFree) {
                this.copyVboData(range.getPosition(), posCompact, range.getSize());
                range.setPosition(posCompact);
                posCompact += range.getSize();
                range = range.getNext();
                continue;
            }
            this.checkVboSize(this.positionTop + range.getSize());
            this.copyVboData(range.getPosition(), this.positionTop, range.getSize());
            range.setPosition(this.positionTop);
            this.positionTop += range.getSize();
            VboRange rangeNext = range.getNext();
            this.rangeList.remove(range.getNode());
            this.rangeList.addLast(range.getNode());
            range = rangeNext;
        }
        if (range == null) {
            this.positionTop = this.rangeList.getLast().getItem().getPositionNext();
        }
        this.compactRangeLast = range;
    }

    private void checkRanges() {
        int count = 0;
        int size = 0;
        for (VboRange range = this.rangeList.getFirst().getItem(); range != null; range = range.getNext()) {
            ++count;
            size += range.getSize();
            if (range.getPosition() < 0 || range.getSize() <= 0 || range.getPositionNext() > this.positionTop) {
                throw new RuntimeException("Invalid range: " + range);
            }
            VboRange rangePrev = range.getPrev();
            if (rangePrev != null && range.getPosition() < rangePrev.getPositionNext()) {
                throw new RuntimeException("Invalid range: " + range);
            }
            VboRange rangeNext = range.getNext();
            if (rangeNext == null || range.getPositionNext() <= rangeNext.getPosition()) continue;
            throw new RuntimeException("Invalid range: " + range);
        }
        if (count != this.rangeList.getSize()) {
            throw new RuntimeException("Invalid count: " + count + " <> " + this.rangeList.getSize());
        }
        if (size != this.sizeUsed) {
            throw new RuntimeException("Invalid size: " + size + " <> " + this.sizeUsed);
        }
    }

    private void checkVboSize(int sizeMin) {
        if (this.capacity < sizeMin) {
            this.expandVbo(sizeMin);
        }
    }

    private void copyVboData(int posFrom, int posTo, int size) {
        long posFromBytes = this.toBytes(posFrom);
        long posToBytes = this.toBytes(posTo);
        long sizeBytes = this.toBytes(size);
        dhp.g((int)dhp.GL_COPY_READ_BUFFER, (int)this.glBufferId);
        dhp.g((int)dhp.GL_COPY_WRITE_BUFFER, (int)this.glBufferId);
        dhp.glCopyBufferSubData((int)dhp.GL_COPY_READ_BUFFER, (int)dhp.GL_COPY_WRITE_BUFFER, (long)posFromBytes, (long)posToBytes, (long)sizeBytes);
        Config.checkGlError("Copy VBO range");
        dhp.g((int)dhp.GL_COPY_READ_BUFFER, (int)0);
        dhp.g((int)dhp.GL_COPY_WRITE_BUFFER, (int)0);
    }

    private void expandVbo(int sizeMin) {
        int capacityNew = this.capacity * 6 / 4;
        while (capacityNew < sizeMin) {
            capacityNew = capacityNew * 6 / 4;
        }
        long capacityBytes = this.toBytes(this.capacity);
        long capacityNewBytes = this.toBytes(capacityNew);
        int glBufferIdNew = dhp.e();
        dhp.g((int)dhp.R, (int)glBufferIdNew);
        dhp.glBufferData((int)dhp.R, (long)capacityNewBytes, (int)dhp.S);
        Config.checkGlError("Expand VBO");
        dhp.g((int)dhp.R, (int)0);
        dhp.g((int)dhp.GL_COPY_READ_BUFFER, (int)this.glBufferId);
        dhp.g((int)dhp.GL_COPY_WRITE_BUFFER, (int)glBufferIdNew);
        dhp.glCopyBufferSubData((int)dhp.GL_COPY_READ_BUFFER, (int)dhp.GL_COPY_WRITE_BUFFER, (long)0L, (long)0L, (long)capacityBytes);
        Config.checkGlError("Copy VBO: " + capacityNewBytes);
        dhp.g((int)dhp.GL_COPY_READ_BUFFER, (int)0);
        dhp.g((int)dhp.GL_COPY_WRITE_BUFFER, (int)0);
        dhp.g((int)this.glBufferId);
        this.bufferIndexVertex = Config.createDirectIntBuffer(capacityNew);
        this.bufferCountVertex = Config.createDirectIntBuffer(capacityNew);
        this.glBufferId = glBufferIdNew;
        this.capacity = capacityNew;
    }

    public void bindBuffer() {
        dhp.g((int)dhp.R, (int)this.glBufferId);
    }

    public void drawArrays(VboRange range) {
        this.bufferIndexVertex.put(range.getPosition());
        this.bufferCountVertex.put(range.getSize());
    }

    public void finishDraw(cum vboRenderList) {
        this.bindBuffer();
        vboRenderList.a();
        this.bufferIndexVertex.flip();
        this.bufferCountVertex.flip();
        ctz.glMultiDrawArrays((int)7, (IntBuffer)this.bufferIndexVertex, (IntBuffer)this.bufferCountVertex);
        this.bufferIndexVertex.limit(this.bufferIndexVertex.capacity());
        this.bufferCountVertex.limit(this.bufferCountVertex.capacity());
        if (this.positionTop > this.sizeUsed * 11 / 10) {
            this.compactRanges(1);
        }
    }

    public void unbindBuffer() {
        dhp.g((int)dhp.R, (int)0);
    }

    public void deleteGlBuffers() {
        if (this.glBufferId >= 0) {
            dhp.g((int)this.glBufferId);
            this.glBufferId = -1;
        }
    }

    private long toBytes(int vertex) {
        return (long)vertex * (long)this.vertexBytes;
    }

    private int toVertex(long bytes) {
        return (int)(bytes / (long)this.vertexBytes);
    }

    public int getPositionTop() {
        return this.positionTop;
    }
}

