/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import net.optifine.shaders.Program;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.Shaders;

public class ShadersBuiltIn {
    public static Reader getShaderReader(String filename) {
        if (filename.endsWith("/deferred_last.vsh")) {
            return ShadersBuiltIn.getCompositeShaderReader(true, true);
        }
        if (filename.endsWith("/composite_last.vsh")) {
            return ShadersBuiltIn.getCompositeShaderReader(false, true);
        }
        if (filename.endsWith("/deferred_last.fsh")) {
            return ShadersBuiltIn.getCompositeShaderReader(true, false);
        }
        if (filename.endsWith("/composite_last.fsh")) {
            return ShadersBuiltIn.getCompositeShaderReader(false, false);
        }
        return null;
    }

    private static Reader getCompositeShaderReader(boolean deferred, boolean vertex) {
        if (!ShadersBuiltIn.hasDeferredPrograms() && !ShadersBuiltIn.hasSkipClear()) {
            return null;
        }
        int[] flipBuffers = ShadersBuiltIn.getLastFlipBuffers(deferred);
        if (flipBuffers == null) {
            return null;
        }
        if (!vertex) {
            String stage = deferred ? "deferred" : "composite";
            SMCLog.info("flipped buffers after " + stage + ": " + Config.arrayToString(flipBuffers));
        }
        String shader = vertex ? ShadersBuiltIn.getCompositeVertexShader(flipBuffers) : ShadersBuiltIn.getCompositeFragmentShader(flipBuffers);
        return new StringReader(shader);
    }

    private static boolean hasDeferredPrograms() {
        for (int i = 0; i < Shaders.ProgramsDeferred.length; ++i) {
            if (Shaders.ProgramsDeferred[i].getId() == 0) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSkipClear() {
        for (int i = 0; i < Shaders.gbuffersClear.length; ++i) {
            if (Shaders.gbuffersClear[i]) continue;
            return true;
        }
        return false;
    }

    private static String getCompositeVertexShader(int[] buffers) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("#version 120                        ");
        list.add("varying vec2 texcoord;              ");
        list.add("void main()                         ");
        list.add("{                                   ");
        list.add("  gl_Position = ftransform();       ");
        list.add("  texcoord = gl_MultiTexCoord0.xy;  ");
        list.add("}                                   ");
        return Config.listToString(list, "\n");
    }

    private static String getCompositeFragmentShader(int[] buffers) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        String drawBuffers = Config.arrayToString(buffers, "");
        list.add("#version 120                                           ");
        for (i = 0; i < buffers.length; ++i) {
            list.add("uniform sampler2D colortex" + buffers[i] + ";        ");
        }
        list.add("varying vec2 texcoord;                                 ");
        list.add("/* DRAWBUFFERS:" + drawBuffers + " */                  ");
        list.add("void main()                                            ");
        list.add("{                                                      ");
        for (i = 0; i < buffers.length; ++i) {
            list.add("  gl_FragData[" + i + "] = texture2D(colortex" + buffers[i] + ", texcoord);     ");
        }
        list.add("}                                                      ");
        return Config.listToString(list, "\n");
    }

    private static int[] getLastFlipBuffers(boolean deferred) {
        if (deferred) {
            return ShadersBuiltIn.getLastFlipBuffers(Shaders.ProgramsDeferred);
        }
        return ShadersBuiltIn.getLastFlipBuffers(Shaders.ProgramsComposite);
    }

    private static int[] getLastFlipBuffers(Program[] programs) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        boolean[] toggled = new boolean[8];
        for (int p = 0; p < programs.length; ++p) {
            if (programs[p].getId() == 0) continue;
            boolean[] togglesTexture = programs[p].getToggleColorTextures();
            for (int t = 0; t < togglesTexture.length; ++t) {
                boolean toggle = togglesTexture[t];
                if (!toggle) continue;
                toggled[t] = !toggled[t];
            }
        }
        for (int t = 0; t < toggled.length; ++t) {
            boolean toggle = toggled[t];
            if (!toggle) continue;
            list.add(new Integer(t));
        }
        if (list.isEmpty()) {
            return null;
        }
        Integer[] arr2 = list.toArray(new Integer[list.size()]);
        return Config.toPrimitive(arr2);
    }
}

