/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import shadersmod.client.GuiButtonShaderOption;
import shadersmod.client.ShaderOption;
import shadersmod.client.ShaderOptionProfile;

public class TooltipProviderShaderOptions
extends TooltipProviderOptions {
    @Override
    public String[] getTooltipLines(bcz btn, int width) {
        if (!(btn instanceof GuiButtonShaderOption)) {
            return null;
        }
        GuiButtonShaderOption btnSo = (GuiButtonShaderOption)btn;
        ShaderOption so = btnSo.getShaderOption();
        String[] lines = this.makeTooltipLines(so, width);
        return lines;
    }

    private String[] makeTooltipLines(ShaderOption so, int width) {
        if (so instanceof ShaderOptionProfile) {
            return null;
        }
        String name = so.getNameText();
        String desc = Config.normalize(so.getDescriptionText()).trim();
        String[] descs = this.splitDescription(desc);
        bch settings = Config.getGameSettings();
        String id = null;
        if (!name.equals(so.getName()) && settings.x) {
            id = "\u00a78" + Lang.get("of.general.id") + ": " + so.getName();
        }
        String source = null;
        if (so.getPaths() != null && settings.x) {
            source = "\u00a78" + Lang.get("of.general.from") + ": " + Config.arrayToString(so.getPaths());
        }
        String def = null;
        if (so.getValueDefault() != null && settings.x) {
            String defVal = so.isEnabled() ? so.getValueText(so.getValueDefault()) : Lang.get("of.general.ambiguous");
            def = "\u00a78" + Lang.getDefault() + ": " + defVal;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(name);
        list.addAll(Arrays.asList(descs));
        if (id != null) {
            list.add(id);
        }
        if (source != null) {
            list.add(source);
        }
        if (def != null) {
            list.add(def);
        }
        String[] lines = this.makeTooltipLines(width, list);
        return lines;
    }

    private String[] splitDescription(String desc) {
        if (desc.length() <= 0) {
            return new String[0];
        }
        desc = StrUtils.removePrefix(desc, "//");
        String[] descs = desc.split("\\. ");
        for (int i = 0; i < descs.length; ++i) {
            descs[i] = "- " + descs[i].trim();
            descs[i] = StrUtils.removeSuffix(descs[i], ".");
        }
        return descs;
    }

    private String[] makeTooltipLines(int width, List<String> args) {
        bct fr = Config.getMinecraft().k;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i);
            if (arg == null || arg.length() <= 0) continue;
            List parts = fr.c(arg, width);
            for (String part : parts) {
                list.add(part);
            }
        }
        String[] lines = list.toArray(new String[list.size()]);
        return lines;
    }
}

