/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.optifine.Config;
import net.optifine.ConnectedProperties;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.shaders.BlockAlias;
import net.optifine.shaders.IShaderPack;
import net.optifine.shaders.ShaderPackNone;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.config.MacroProcessor;
import net.optifine.util.BlockUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;

public class BlockAliases {
    private static BlockAlias[][] blockAliases = null;
    private static boolean hasAliasMetadata = false;
    private static PropertiesOrdered blockLayerPropertes = null;
    private static boolean updateOnResourcesReloaded;

    public static int getAliasBlockId(bvt blockState) {
        int metadata;
        int blockId = blockState.getBlockId();
        BlockAlias alias = BlockAliases.getBlockAlias(blockId, metadata = blockState.getMetadata());
        if (alias != null) {
            return alias.getAliasBlockId();
        }
        return -1;
    }

    public static boolean hasAliasMetadata() {
        return hasAliasMetadata;
    }

    public static int getAliasMetadata(bvt blockState) {
        int metadata;
        if (!hasAliasMetadata) {
            return 0;
        }
        int blockId = blockState.getBlockId();
        BlockAlias alias = BlockAliases.getBlockAlias(blockId, metadata = blockState.getMetadata());
        if (alias != null) {
            return alias.getAliasMetadata();
        }
        return 0;
    }

    public static BlockAlias getBlockAlias(int blockId, int metadata) {
        if (blockAliases == null) {
            return null;
        }
        if (blockId < 0 || blockId >= blockAliases.length) {
            return null;
        }
        BlockAlias[] aliases = blockAliases[blockId];
        if (aliases == null) {
            return null;
        }
        for (int i = 0; i < aliases.length; ++i) {
            BlockAlias ba = aliases[i];
            if (!ba.matches(blockId, metadata)) continue;
            return ba;
        }
        return null;
    }

    public static BlockAlias[] getBlockAliases(int blockId) {
        if (blockAliases == null) {
            return null;
        }
        if (blockId < 0 || blockId >= blockAliases.length) {
            return null;
        }
        BlockAlias[] aliases = blockAliases[blockId];
        return aliases;
    }

    public static void resourcesReloaded() {
        if (!updateOnResourcesReloaded) {
            return;
        }
        updateOnResourcesReloaded = false;
        BlockAliases.update(Shaders.getShaderPack());
    }

    public static void update(IShaderPack shaderPack) {
        BlockAliases.reset();
        if (shaderPack == null) {
            return;
        }
        if (shaderPack instanceof ShaderPackNone) {
            return;
        }
        if (Reflector.Loader_getActiveModList.exists() && cyc.u().G() == null) {
            Config.dbg("[Shaders] Delayed loading of block mappings after resources are loaded");
            updateOnResourcesReloaded = true;
            return;
        }
        List<List<BlockAlias>> listBlockAliases = new ArrayList<List<BlockAlias>>();
        String path = "/shaders/block.properties";
        InputStream in = shaderPack.getResourceAsStream(path);
        if (in != null) {
            BlockAliases.loadBlockAliases(in, path, listBlockAliases);
        }
        BlockAliases.loadModBlockAliases(listBlockAliases);
        if (listBlockAliases.size() <= 0) {
            listBlockAliases = BlockAliases.makeLegacyAliases();
            hasAliasMetadata = true;
        }
        blockAliases = BlockAliases.toBlockAliasArrays(listBlockAliases);
    }

    private static void loadModBlockAliases(List<List<BlockAlias>> listBlockAliases) {
        String[] modIds = ReflectorForge.getForgeModIds();
        for (int i = 0; i < modIds.length; ++i) {
            String modId = modIds[i];
            try {
                qv loc = new qv(modId, "shaders/block.properties");
                InputStream in = Config.getResourceStream(loc);
                BlockAliases.loadBlockAliases(in, loc.toString(), listBlockAliases);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void loadBlockAliases(InputStream in, String path, List<List<BlockAlias>> listBlockAliases) {
        if (in == null) {
            return;
        }
        try {
            in = MacroProcessor.process(in, path);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            Config.dbg("[Shaders] Parsing block mappings: " + path);
            ConnectedParser cp = new ConnectedParser("Shaders");
            Set<Object> keys = ((Properties)props).keySet();
            for (String string : keys) {
                String val = props.getProperty(string);
                if (string.startsWith("layer.")) {
                    if (blockLayerPropertes == null) {
                        blockLayerPropertes = new PropertiesOrdered();
                    }
                    blockLayerPropertes.put(string, val);
                    continue;
                }
                String prefix = "block.";
                if (!string.startsWith(prefix)) {
                    Config.warn("[Shaders] Invalid block ID: " + string);
                    continue;
                }
                String blockIdStr = StrUtils.removePrefix(string, prefix);
                int blockId = Config.parseInt(blockIdStr, -1);
                if (blockId < 0) {
                    Config.warn("[Shaders] Invalid block ID: " + string);
                    continue;
                }
                MatchBlock[] matchBlocks = cp.parseMatchBlocks(val);
                if (matchBlocks == null || matchBlocks.length < 1) {
                    Config.warn("[Shaders] Invalid block ID mapping: " + string + "=" + val);
                    continue;
                }
                BlockAlias ba = new BlockAlias(blockId, matchBlocks);
                BlockAliases.addToList(listBlockAliases, ba);
            }
        }
        catch (IOException e2) {
            Config.warn("[Shaders] Error reading: " + path);
        }
    }

    private static void addToList(List<List<BlockAlias>> blocksAliases, BlockAlias ba) {
        int[] blockIds = ba.getMatchBlockIds();
        for (int i = 0; i < blockIds.length; ++i) {
            int blockId = blockIds[i];
            while (blockId >= blocksAliases.size()) {
                blocksAliases.add(null);
            }
            List<BlockAlias> blockAliases = blocksAliases.get(blockId);
            if (blockAliases == null) {
                blockAliases = new ArrayList<BlockAlias>();
                blocksAliases.set(blockId, blockAliases);
            }
            BlockAlias baBlock = new BlockAlias(ba.getAliasBlockId(), ba.getMatchBlocks(blockId));
            blockAliases.add(baBlock);
        }
    }

    private static BlockAlias[][] toBlockAliasArrays(List<List<BlockAlias>> listBlocksAliases) {
        BlockAlias[][] bas = new BlockAlias[listBlocksAliases.size()][];
        for (int i = 0; i < bas.length; ++i) {
            List<BlockAlias> listBlockAliases = listBlocksAliases.get(i);
            if (listBlockAliases == null) continue;
            bas[i] = listBlockAliases.toArray(new BlockAlias[listBlockAliases.size()]);
        }
        return bas;
    }

    private static List<List<BlockAlias>> makeLegacyAliases() {
        try {
            String path = "flattening_ids.txt";
            Config.dbg("Using legacy block aliases: " + path);
            ArrayList<List<BlockAlias>> listAliases = new ArrayList<List<BlockAlias>>();
            ArrayList<String> listLines = new ArrayList<String>();
            int countAliases = 0;
            InputStream in = BlockAliases.class.getResourceAsStream("/" + path);
            String[] lines = Config.readLines(in);
            for (int i = 0; i < lines.length; ++i) {
                int lineNum = i + 1;
                String line = lines[i];
                if (line.trim().length() <= 0) continue;
                listLines.add(line);
                if (line.startsWith("#")) continue;
                if (line.startsWith("alias")) {
                    String[] parts = Config.tokenize(line, " ");
                    String blockAliasStr = parts[1];
                    String blockStr = parts[2];
                    String prefix = "{Name:'" + blockStr + "'";
                    List blockLines = listLines.stream().filter(s -> s.startsWith(prefix)).collect(Collectors.toList());
                    if (blockLines.size() <= 0) {
                        Config.warn("Block not processed: " + line);
                        continue;
                    }
                    for (String lineBlock : blockLines) {
                        String prefixNew = "{Name:'" + blockAliasStr + "'";
                        String lineNew = lineBlock.replace(prefix, prefixNew);
                        listLines.add(lineNew);
                        BlockAliases.addLegacyAlias(lineNew, lineNum, listAliases);
                        ++countAliases;
                    }
                    continue;
                }
                BlockAliases.addLegacyAlias(line, lineNum, listAliases);
                ++countAliases;
            }
            Config.dbg("Legacy block aliases: " + countAliases);
            return listAliases;
        }
        catch (IOException e2) {
            Config.warn("Error loading legacy block aliases: " + e2.getClass().getName() + ": " + e2.getMessage());
            return new ArrayList<List<BlockAlias>>();
        }
    }

    private static void addLegacyAlias(String line, int lineNum, List<List<BlockAlias>> listAliases) {
        String[] parts = Config.tokenize(line, " ");
        if (parts.length != 4) {
            Config.warn("Invalid flattening line: " + line);
            return;
        }
        String partNew = parts[0];
        String partOld = parts[1];
        int blockIdOld = Config.parseInt(parts[2], Integer.MIN_VALUE);
        int metadataOld = Config.parseInt(parts[3], Integer.MIN_VALUE);
        if (blockIdOld < 0 || metadataOld < 0) {
            Config.warn("Invalid blockID or metadata (" + lineNum + "): " + blockIdOld + ":" + metadataOld);
            return;
        }
        try {
            JsonParser jp = new JsonParser();
            JsonObject jo2 = jp.parse(partNew).getAsJsonObject();
            String name = jo2.get("Name").getAsString();
            qv loc = new qv(name);
            bmv block = BlockUtils.getBlock(loc);
            if (block == null) {
                Config.warn("Invalid block name (" + lineNum + "): " + name);
                return;
            }
            bvt blockState = block.o();
            Collection stateProperties = blockState.a();
            LinkedHashMap<bww, Comparable> mapProperties = new LinkedHashMap<bww, Comparable>();
            JsonObject properties = (JsonObject)jo2.get("Properties");
            if (properties != null) {
                Set entries = properties.entrySet();
                for (Map.Entry entry : entries) {
                    String key = (String)entry.getKey();
                    String value = ((JsonElement)entry.getValue()).getAsString();
                    bww prop = ConnectedProperties.getProperty(key, stateProperties);
                    if (prop == null) {
                        Config.warn("Invalid property (" + lineNum + "): " + key);
                        continue;
                    }
                    Comparable propVal = ConnectedParser.parsePropertyValue(prop, value);
                    if (propVal == null) {
                        Config.warn("Invalid property value (" + lineNum + "): " + value);
                        continue;
                    }
                    mapProperties.put(prop, propVal);
                }
            }
            int blockId = blockState.getBlockId();
            while (listAliases.size() <= blockId) {
                listAliases.add(null);
            }
            List<BlockAlias> las = listAliases.get(blockId);
            if (las == null) {
                las = new ArrayList<BlockAlias>(BlockUtils.getMetadataCount(block));
                listAliases.set(blockId, las);
            }
            MatchBlock mb = BlockAliases.getMatchBlock(blockState.d(), blockState.getBlockId(), mapProperties);
            BlockAliases.addBlockAlias(las, blockIdOld, metadataOld, mb);
        }
        catch (Exception e2) {
            Config.warn("Error parsing: " + line);
        }
    }

    private static void addBlockAlias(List<BlockAlias> listBlockAliases, int aliasBlockId, int aliasMetadata, MatchBlock matchBlock) {
        for (BlockAlias ba : listBlockAliases) {
            if (ba.getAliasBlockId() != aliasBlockId || ba.getAliasMetadata() != aliasMetadata) continue;
            MatchBlock[] mbs = ba.getMatchBlocks();
            for (int i = 0; i < mbs.length; ++i) {
                MatchBlock mb = mbs[i];
                if (mb.getBlockId() != matchBlock.getBlockId()) continue;
                mb.addMetadatas(matchBlock.getMetadatas());
                return;
            }
        }
        BlockAlias ba = new BlockAlias(aliasBlockId, aliasMetadata, new MatchBlock[]{matchBlock});
        listBlockAliases.add(ba);
    }

    private static MatchBlock getMatchBlock(bmv block, int blockId, Map<bww, Comparable> mapProperties) {
        ArrayList<bvt> matchingStates = new ArrayList<bvt>();
        Set<bww> props = mapProperties.keySet();
        List<bvt> states = BlockUtils.getBlockStates(block);
        for (bvt bvt2 : states) {
            boolean bl = true;
            for (bww prop : props) {
                Comparable val2;
                if (!bvt2.b(prop)) {
                    bl = false;
                    break;
                }
                Comparable val1 = mapProperties.get(prop);
                if (val1.equals(val2 = bvt2.c(prop))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            matchingStates.add(bvt2);
        }
        LinkedHashSet<Integer> setMetadatas = new LinkedHashSet<Integer>();
        for (bvt bvt3 : matchingStates) {
            setMetadatas.add(bvt3.getMetadata());
        }
        Integer[] integerArray = setMetadatas.toArray(new Integer[setMetadatas.size()]);
        int[] nArray = Config.toPrimitive(integerArray);
        MatchBlock mb = new MatchBlock(blockId, nArray);
        return mb;
    }

    private static void checkLegacyAliases() {
        Set locs = fn.j.b();
        for (qv loc : locs) {
            bmv block = (bmv)fn.j.a(loc);
            int blockId = block.o().getBlockId();
            BlockAlias[] bas = BlockAliases.getBlockAliases(blockId);
            if (bas == null) {
                Config.warn("Block has no alias: " + block);
                continue;
            }
            List<bvt> states = BlockUtils.getBlockStates(block);
            for (bvt state : states) {
                int metadata = state.getMetadata();
                BlockAlias ba = BlockAliases.getBlockAlias(blockId, metadata);
                if (ba != null) continue;
                Config.warn("State has no alias: " + state);
            }
        }
    }

    public static PropertiesOrdered getBlockLayerPropertes() {
        return blockLayerPropertes;
    }

    public static void reset() {
        blockAliases = null;
        hasAliasMetadata = false;
        blockLayerPropertes = null;
    }
}

