/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.gui;

import com.mojang.authlib.exceptions.InvalidCredentialsException;
import java.math.BigInteger;
import java.net.URI;
import java.util.Random;
import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.gui.GuiButtonOF;
import net.optifine.gui.GuiScreenOF;

public class GuiScreenCapeOF
extends GuiScreenOF {
    private final dcl parentScreen;
    private String message;
    private long messageHideTimeMs;

    public GuiScreenCapeOF(dcl parentScreenIn) {
        super((jo)new jx(dxx.a((String)"of.options.capeOF.title", (Object[])new Object[0])));
        this.parentScreen = parentScreenIn;
    }

    protected void init() {
        int i = 0;
        this.addButton((czg)new GuiButtonOF(210, this.width / 2 - 155, this.height / 6 + 24 * ((i += 2) >> 1), 150, 20, dxx.a((String)"of.options.capeOF.openEditor", (Object[])new Object[0])));
        this.addButton((czg)new GuiButtonOF(220, this.width / 2 - 155 + 160, this.height / 6 + 24 * (i >> 1), 150, 20, dxx.a((String)"of.options.capeOF.reloadCape", (Object[])new Object[0])));
        this.addButton((czg)new GuiButtonOF(200, this.width / 2 - 100, this.height / 6 + 24 * ((i += 8) >> 1), dxx.a((String)"gui.done", (Object[])new Object[0])));
    }

    @Override
    protected void actionPerformed(czg guiElement) {
        if (!(guiElement instanceof GuiButtonOF)) {
            return;
        }
        GuiButtonOF button = (GuiButtonOF)guiElement;
        if (button.active) {
            if (button.id == 200) {
                this.minecraft.a(this.parentScreen);
            }
            if (button.id == 210) {
                try {
                    String userName = this.minecraft.C().e().getName();
                    String userId = this.minecraft.C().e().getId().toString().replace("-", "");
                    String accessToken = this.minecraft.C().d();
                    Random r1 = new Random();
                    Random r2 = new Random(System.identityHashCode(new Object()));
                    BigInteger random1Bi = new BigInteger(128, r1);
                    BigInteger random2Bi = new BigInteger(128, r2);
                    BigInteger serverBi = random1Bi.xor(random2Bi);
                    String serverId = serverBi.toString(16);
                    this.minecraft.Q().joinServer(this.minecraft.C().e(), accessToken, serverId);
                    String urlStr = "https://optifine.net/capeChange?u=" + userId + "&n=" + userName + "&s=" + serverId;
                    Config.openWebLink(new URI(urlStr));
                    this.showMessage(Lang.get("of.message.capeOF.openEditor"), 10000L);
                }
                catch (InvalidCredentialsException e2) {
                    Config.showGuiMessage(dxx.a((String)"of.message.capeOF.error1", (Object[])new Object[0]), dxx.a((String)"of.message.capeOF.error2", (Object[])new Object[]{e2.getMessage()}));
                    Config.warn("Mojang authentication failed");
                    Config.warn(((Object)((Object)e2)).getClass().getName() + ": " + e2.getMessage());
                }
                catch (Exception e3) {
                    Config.warn("Error opening OptiFine cape link");
                    Config.warn(e3.getClass().getName() + ": " + e3.getMessage());
                }
            }
            if (button.id == 220) {
                this.showMessage(Lang.get("of.message.capeOF.reloadCape"), 15000L);
                if (this.minecraft.i != null) {
                    long delayMs = 15000L;
                    long reloadTimeMs = System.currentTimeMillis() + delayMs;
                    this.minecraft.i.setReloadCapeTimeMs(reloadTimeMs);
                }
            }
        }
    }

    private void showMessage(String msg, long timeMs) {
        this.message = msg;
        this.messageHideTimeMs = System.currentTimeMillis() + timeMs;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(this.fontRenderer, this.title.e(), this.width / 2, 20, 0xFFFFFF);
        if (this.message != null) {
            this.drawCenteredString(this.fontRenderer, this.message, this.width / 2, this.height / 6 + 60, 0xFFFFFF);
            if (System.currentTimeMillis() > this.messageHideTimeMs) {
                this.message = null;
            }
        }
        super.render(mouseX, mouseY, partialTicks);
    }
}

