/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;
import shadersmod.client.MultiTexID;
import shadersmod.client.Shaders;

public class TextureUtils {
    public static final String texGrassTop = "grass_top";
    public static final String texStone = "stone";
    public static final String texDirt = "dirt";
    public static final String texGrassSide = "grass_side";
    public static final String texStoneslabSide = "stone_slab_side";
    public static final String texStoneslabTop = "stone_slab_top";
    public static final String texBedrock = "bedrock";
    public static final String texSand = "sand";
    public static final String texGravel = "gravel";
    public static final String texLogOak = "log_oak";
    public static final String texLogOakTop = "log_oak_top";
    public static final String texGoldOre = "gold_ore";
    public static final String texIronOre = "iron_ore";
    public static final String texCoalOre = "coal_ore";
    public static final String texObsidian = "obsidian";
    public static final String texGrassSideOverlay = "grass_side_overlay";
    public static final String texSnow = "snow";
    public static final String texGrassSideSnowed = "grass_side_snowed";
    public static final String texMyceliumSide = "mycelium_side";
    public static final String texMyceliumTop = "mycelium_top";
    public static final String texDiamondOre = "diamond_ore";
    public static final String texRedstoneOre = "redstone_ore";
    public static final String texLapisOre = "lapis_ore";
    public static final String texLeavesOak = "leaves_oak";
    public static final String texLeavesOakOpaque = "leaves_oak_opaque";
    public static final String texLeavesJungle = "leaves_jungle";
    public static final String texLeavesJungleOpaque = "leaves_jungle_opaque";
    public static final String texCactusSide = "cactus_side";
    public static final String texClay = "clay";
    public static final String texFarmlandWet = "farmland_wet";
    public static final String texFarmlandDry = "farmland_dry";
    public static final String texNetherrack = "netherrack";
    public static final String texSoulSand = "soul_sand";
    public static final String texGlowstone = "glowstone";
    public static final String texLogSpruce = "log_spruce";
    public static final String texLogBirch = "log_birch";
    public static final String texLeavesSpruce = "leaves_spruce";
    public static final String texLeavesSpruceOpaque = "leaves_spruce_opaque";
    public static final String texLogJungle = "log_jungle";
    public static final String texEndStone = "end_stone";
    public static final String texSandstoneTop = "sandstone_top";
    public static final String texSandstoneBottom = "sandstone_bottom";
    public static final String texRedstoneLampOff = "redstone_lamp_off";
    public static final String texRedstoneLampOn = "redstone_lamp_on";
    public static final String texWaterStill = "water_still";
    public static final String texWaterFlow = "water_flow";
    public static final String texLavaStill = "lava_still";
    public static final String texLavaFlow = "lava_flow";
    public static final String texFireLayer0 = "fire_layer_0";
    public static final String texFireLayer1 = "fire_layer_1";
    public static final String texPortal = "portal";
    public static final String texGlass = "glass";
    public static final String texGlassPaneTop = "glass_pane_top";
    public static final String texCompass = "compass";
    public static final String texClock = "clock";
    public static ps iconGrassTop;
    public static ps iconGrassSide;
    public static ps iconGrassSideOverlay;
    public static ps iconSnow;
    public static ps iconGrassSideSnowed;
    public static ps iconMyceliumSide;
    public static ps iconMyceliumTop;
    public static ps iconWaterStill;
    public static ps iconWaterFlow;
    public static ps iconLavaStill;
    public static ps iconLavaFlow;
    public static ps iconPortal;
    public static ps iconFireLayer0;
    public static ps iconFireLayer1;
    public static ps iconGlass;
    public static ps iconGlassPaneTop;
    public static ps iconCompass;
    public static ps iconClock;
    private static IntBuffer staticBuffer;

    public static void update() {
        bpr mapBlocks = bpr.textureMapBlocks;
        if (mapBlocks == null) {
            return;
        }
        iconGrassTop = mapBlocks.getIconSafe(texGrassTop);
        iconGrassSide = mapBlocks.getIconSafe(texGrassSide);
        iconGrassSideOverlay = mapBlocks.getIconSafe(texGrassSideOverlay);
        iconSnow = mapBlocks.getIconSafe(texSnow);
        iconGrassSideSnowed = mapBlocks.getIconSafe(texGrassSideSnowed);
        iconMyceliumSide = mapBlocks.getIconSafe(texMyceliumSide);
        iconMyceliumTop = mapBlocks.getIconSafe(texMyceliumTop);
        iconWaterStill = mapBlocks.getIconSafe(texWaterStill);
        iconWaterFlow = mapBlocks.getIconSafe(texWaterFlow);
        iconLavaStill = mapBlocks.getIconSafe(texLavaStill);
        iconLavaFlow = mapBlocks.getIconSafe(texLavaFlow);
        iconFireLayer0 = mapBlocks.getIconSafe(texFireLayer0);
        iconFireLayer1 = mapBlocks.getIconSafe(texFireLayer1);
        iconPortal = mapBlocks.getIconSafe(texPortal);
        iconGlass = mapBlocks.getIconSafe(texGlass);
        iconGlassPaneTop = mapBlocks.getIconSafe(texGlassPaneTop);
        bpr mapItems = bpr.textureMapItems;
        if (mapItems == null) {
            return;
        }
        iconCompass = mapItems.getIconSafe(texCompass);
        iconClock = mapItems.getIconSafe(texClock);
    }

    public static BufferedImage fixTextureDimensions(String name, BufferedImage bi) {
        int height;
        int width;
        if ((name.startsWith("/mob/zombie") || name.startsWith("/mob/pigzombie")) && (width = bi.getWidth()) == (height = bi.getHeight()) * 2) {
            BufferedImage scaledImage = new BufferedImage(width, height * 2, 2);
            Graphics2D gr = scaledImage.createGraphics();
            gr.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gr.drawImage(bi, 0, 0, width, height, null);
            return scaledImage;
        }
        return bi;
    }

    public static bpv getTextureAtlasSprite(ps icon) {
        if (icon instanceof bpv) {
            return (bpv)icon;
        }
        return null;
    }

    public static int ceilPowerOfTwo(int val) {
        int i;
        for (i = 1; i < val; i *= 2) {
        }
        return i;
    }

    public static int getPowerOfTwo(int val) {
        int i = 1;
        int po2 = 0;
        while (i < val) {
            i *= 2;
            ++po2;
        }
        return po2;
    }

    public static int twoToPower(int power) {
        int val = 1;
        for (int i = 0; i < power; ++i) {
            val *= 2;
        }
        return val;
    }

    public static void refreshBlockTextures() {
        Config.dbg("*** Reloading block textures ***");
        WrUpdates.finishCurrentUpdate();
        bpr.textureMapBlocks.loadTextureSafe(Config.getResourceManager());
        TextureUtils.update();
        NaturalTextures.update();
        bpr.textureMapBlocks.d();
    }

    public static bpz getTexture(String path) {
        return TextureUtils.getTexture(new bqo(path));
    }

    public static bpz getTexture(bqo loc) {
        bpz tex = Config.getTextureManager().b(loc);
        if (tex != null) {
            return tex;
        }
        if (!Config.hasResource(loc)) {
            return null;
        }
        tex = new bpm(loc);
        Config.getTextureManager().a(loc, tex);
        return tex;
    }

    public static void resourcesReloaded(bqp rm) {
        if (bpr.textureMapBlocks == null) {
            return;
        }
        Config.dbg("*** Reloading custom textures ***");
        CustomSky.reset();
        TextureAnimations.reset();
        WrUpdates.finishCurrentUpdate();
        TextureUtils.update();
        NaturalTextures.update();
        TextureAnimations.update();
        CustomColorizer.update();
        CustomSky.update();
        RandomMobs.resetTextures();
        Shaders.resourcesReloaded();
        Lang.resourcesReloaded();
        Config.updateTexturePackClouds();
        Config.getTextureManager().e();
    }

    public static void refreshTextureMaps(bqp rm) {
        bpr.textureMapBlocks.loadTextureSafe(rm);
        bpr.textureMapItems.loadTextureSafe(rm);
        TextureUtils.update();
        NaturalTextures.update();
    }

    public static void registerResourceListener() {
        bqp rm = Config.getResourceManager();
        if (rm instanceof bqm) {
            bqm rrm = (bqm)rm;
            bqq rl = new bqq(){

                public void a(bqp var1) {
                    TextureUtils.resourcesReloaded(var1);
                }
            };
            rrm.a(rl);
        }
        bqc tto = new bqc(){

            public void e() {
                TextureAnimations.updateCustomAnimations();
            }

            public void a(bqp var1) throws IOException {
            }

            public int b() {
                return 0;
            }

            public MultiTexID getMultiTexID() {
                return null;
            }
        };
        bqo ttol = new bqo("optifine/TickableTextures");
        Config.getTextureManager().a(ttol, tto);
    }

    public static bqo fixResourceLocation(bqo loc, String basePath) {
        if (!loc.b().equals("minecraft")) {
            return loc;
        }
        String path = loc.a();
        String pathFixed = TextureUtils.fixResourcePath(path, basePath);
        if (pathFixed != path) {
            loc = new bqo(loc.b(), pathFixed);
        }
        return loc;
    }

    public static String fixResourcePath(String path, String basePath) {
        String strAssMc = "assets/minecraft/";
        if (path.startsWith(strAssMc)) {
            path = path.substring(strAssMc.length());
            return path;
        }
        if (path.startsWith("./")) {
            path = path.substring(2);
            if (!basePath.endsWith("/")) {
                basePath = basePath + "/";
            }
            path = basePath + path;
            return path;
        }
        if (path.startsWith("/~")) {
            path = path.substring(1);
        }
        String strMcpatcher = "mcpatcher/";
        if (path.startsWith("~/")) {
            path = path.substring(2);
            path = strMcpatcher + path;
            return path;
        }
        if (path.startsWith("/")) {
            path = strMcpatcher + path.substring(1);
            return path;
        }
        return path;
    }

    public static String getBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readBufferedImage(InputStream is) throws IOException {
        BufferedImage var1;
        try {
            var1 = ImageIO.read(is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return var1;
    }

    public static BufferedImage scaleImage(BufferedImage bi, int w2) {
        int w = bi.getWidth();
        int h = bi.getHeight();
        int h2 = h * w2 / w;
        BufferedImage bi2 = new BufferedImage(w2, h2, 2);
        Graphics2D g2 = bi2.createGraphics();
        Object method = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        if (w2 < w || w2 % w != 0) {
            method = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, method);
        g2.drawImage(bi, 0, 0, w2, h2, null);
        return bi2;
    }

    public static int getGLMaximumTextureSize() {
        for (int i = 65536; i > 0; i >>= 1) {
            GL11.glTexImage2D((int)32868, (int)0, (int)6408, (int)i, (int)i, (int)0, (int)6408, (int)5121, (IntBuffer)null);
            int err = GL11.glGetError();
            int width = GL11.glGetTexLevelParameteri((int)32868, (int)0, (int)4096);
            if (width == 0) continue;
            return i;
        }
        return -1;
    }

    static {
        staticBuffer = azc.f((int)256);
    }
}

