/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.google.common.primitives.Floats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.ItemOverrideProperty;
import net.optifine.reflect.Reflector;
import net.optifine.util.CompoundKey;

public class ItemOverrideCache {
    private ItemOverrideProperty[] itemOverrideProperties;
    private Map<CompoundKey, Integer> mapModelIndexes = new HashMap<CompoundKey, Integer>();
    public static final Integer INDEX_NONE = new Integer(-1);

    public ItemOverrideCache(ItemOverrideProperty[] itemOverrideProperties) {
        this.itemOverrideProperties = itemOverrideProperties;
    }

    public Integer getModelIndex(bce stack, bhm world, aiu entity) {
        CompoundKey valueKey = this.getValueKey(stack, world, entity);
        if (valueKey == null) {
            return null;
        }
        return this.mapModelIndexes.get(valueKey);
    }

    public void putModelIndex(bce stack, bhm world, aiu entity, Integer index) {
        CompoundKey valueKey = this.getValueKey(stack, world, entity);
        if (valueKey == null) {
            return;
        }
        this.mapModelIndexes.put(valueKey, index);
    }

    private CompoundKey getValueKey(bce stack, bhm world, aiu entity) {
        Object[] indexes = new Integer[this.itemOverrideProperties.length];
        for (int i = 0; i < indexes.length; ++i) {
            Integer index = this.itemOverrideProperties[i].getValueIndex(stack, world, entity);
            if (index == null) {
                return null;
            }
            indexes[i] = index;
        }
        return new CompoundKey(indexes);
    }

    public static ItemOverrideCache make(List<dlv> overrides) {
        if (overrides.isEmpty()) {
            return null;
        }
        if (!Reflector.ItemOverride_mapResourceValues.exists()) {
            return null;
        }
        LinkedHashMap<qt, HashSet<Float>> propertyValues = new LinkedHashMap<qt, HashSet<Float>>();
        for (dlv itemOverride : overrides) {
            Map mapResourceValues = (Map)Reflector.getFieldValue(itemOverride, Reflector.ItemOverride_mapResourceValues);
            Set setLocs = mapResourceValues.keySet();
            for (qt loc : setLocs) {
                Float val = (Float)mapResourceValues.get(loc);
                if (val == null) continue;
                HashSet<Float> setValues = (HashSet<Float>)propertyValues.get(loc);
                if (setValues == null) {
                    setValues = new HashSet<Float>();
                    propertyValues.put(loc, setValues);
                }
                setValues.add(val);
            }
        }
        ArrayList<ItemOverrideProperty> listProps = new ArrayList<ItemOverrideProperty>();
        Set setPropertyLocations = propertyValues.keySet();
        for (qt loc : setPropertyLocations) {
            Set setValues = (Set)propertyValues.get(loc);
            float[] values = Floats.toArray((Collection)setValues);
            ItemOverrideProperty prop = new ItemOverrideProperty(loc, values);
            listProps.add(prop);
        }
        ItemOverrideProperty[] props = listProps.toArray(new ItemOverrideProperty[listProps.size()]);
        ItemOverrideCache cache = new ItemOverrideCache(props);
        ItemOverrideCache.logCache(props, overrides);
        return cache;
    }

    private static void logCache(ItemOverrideProperty[] props, List<dlv> overrides) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < props.length; ++i) {
            ItemOverrideProperty prop = props[i];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("" + prop.getLocation() + "=" + prop.getValues().length);
        }
        if (overrides.size() > 0) {
            sb.append(" -> " + overrides.get(0).a() + " ...");
        }
        Config.dbg("ItemOverrideCache: " + sb.toString());
    }

    public String toString() {
        return "properties: " + this.itemOverrideProperties.length + ", modelIndexes: " + this.mapModelIndexes.size();
    }
}

