/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.optifine.Config;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.shaders.BlockAliases;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;

public class CustomBlockLayers {
    private static bgx[] renderLayers = null;
    public static boolean active = false;

    public static bgx getRenderLayer(bgu worldReader, bvo blockState, ev blockPos) {
        if (renderLayers == null) {
            return null;
        }
        if (blockState.g((bgw)worldReader, blockPos)) {
            return null;
        }
        int id2 = blockState.getBlockId();
        if (id2 <= 0 || id2 >= renderLayers.length) {
            return null;
        }
        return renderLayers[id2];
    }

    public static void update() {
        PropertiesOrdered propsShaders;
        renderLayers = null;
        active = false;
        ArrayList<bgx> list = new ArrayList<bgx>();
        String pathProps = "optifine/block.properties";
        Properties props = ResUtils.readProperties(pathProps, "CustomBlockLayers");
        if (props != null) {
            CustomBlockLayers.readLayers(pathProps, props, list);
        }
        if (Config.isShaders() && (propsShaders = BlockAliases.getBlockLayerPropertes()) != null) {
            String pathPropsShaders = "shaders/block.properties";
            CustomBlockLayers.readLayers(pathPropsShaders, propsShaders, list);
        }
        if (list.isEmpty()) {
            return;
        }
        renderLayers = list.toArray(new bgx[list.size()]);
        active = true;
    }

    private static void readLayers(String pathProps, Properties props, List<bgx> list) {
        Config.dbg("CustomBlockLayers: " + pathProps);
        CustomBlockLayers.readLayer("solid", bgx.a, props, list);
        CustomBlockLayers.readLayer("cutout", bgx.c, props, list);
        CustomBlockLayers.readLayer("cutout_mipped", bgx.b, props, list);
        CustomBlockLayers.readLayer("translucent", bgx.d, props, list);
    }

    private static void readLayer(String name, bgx layer, Properties props, List<bgx> listLayers) {
        String key = "layer." + name;
        String val = props.getProperty(key);
        if (val == null) {
            return;
        }
        ConnectedParser cp = new ConnectedParser("CustomBlockLayers");
        MatchBlock[] mbs = cp.parseMatchBlocks(val);
        if (mbs == null) {
            return;
        }
        for (int i = 0; i < mbs.length; ++i) {
            MatchBlock mb = mbs[i];
            int blockId = mb.getBlockId();
            if (blockId <= 0) continue;
            while (listLayers.size() < blockId + 1) {
                listLayers.add(null);
            }
            if (listLayers.get(blockId) != null) {
                Config.warn("CustomBlockLayers: Block layer is already set, block: " + blockId + ", layer: " + name);
            }
            listLayers.set(blockId, layer);
        }
    }

    public static boolean isActive() {
        return active;
    }
}

