/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.optifine.BetterGrass;
import net.optifine.BlockDir;
import net.optifine.Config;
import net.optifine.ConnectedProperties;
import net.optifine.ConnectedTexturesCompact;
import net.optifine.config.Matches;
import net.optifine.model.BlockModelUtils;
import net.optifine.model.ListQuadsOverlay;
import net.optifine.reflect.Reflector;
import net.optifine.render.RenderEnv;
import net.optifine.util.BlockUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TileEntityUtils;

public class ConnectedTextures {
    private static Map[] spriteQuadMaps = null;
    private static Map[] spriteQuadFullMaps = null;
    private static Map[][] spriteQuadCompactMaps = null;
    private static ConnectedProperties[][] blockProperties = null;
    private static ConnectedProperties[][] tileProperties = null;
    private static boolean multipass = false;
    protected static final int UNKNOWN = -1;
    protected static final int Y_NEG_DOWN = 0;
    protected static final int Y_POS_UP = 1;
    protected static final int Z_NEG_NORTH = 2;
    protected static final int Z_POS_SOUTH = 3;
    protected static final int X_NEG_WEST = 4;
    protected static final int X_POS_EAST = 5;
    private static final int Y_AXIS = 0;
    private static final int Z_AXIS = 1;
    private static final int X_AXIS = 2;
    public static final bvo AIR_DEFAULT_STATE = bmr.a.o();
    private static dun emptySprite = null;
    private static final BlockDir[] SIDES_Y_NEG_DOWN = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.NORTH, BlockDir.SOUTH};
    private static final BlockDir[] SIDES_Y_POS_UP = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.SOUTH, BlockDir.NORTH};
    private static final BlockDir[] SIDES_Z_NEG_NORTH = new BlockDir[]{BlockDir.EAST, BlockDir.WEST, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_Z_POS_SOUTH = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_X_NEG_WEST = new BlockDir[]{BlockDir.NORTH, BlockDir.SOUTH, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_X_POS_EAST = new BlockDir[]{BlockDir.SOUTH, BlockDir.NORTH, BlockDir.DOWN, BlockDir.UP};
    private static final BlockDir[] SIDES_Z_NEG_NORTH_Z_AXIS = new BlockDir[]{BlockDir.WEST, BlockDir.EAST, BlockDir.UP, BlockDir.DOWN};
    private static final BlockDir[] SIDES_X_POS_EAST_X_AXIS = new BlockDir[]{BlockDir.NORTH, BlockDir.SOUTH, BlockDir.UP, BlockDir.DOWN};
    private static final BlockDir[] EDGES_Y_NEG_DOWN = new BlockDir[]{BlockDir.NORTH_EAST, BlockDir.NORTH_WEST, BlockDir.SOUTH_EAST, BlockDir.SOUTH_WEST};
    private static final BlockDir[] EDGES_Y_POS_UP = new BlockDir[]{BlockDir.SOUTH_EAST, BlockDir.SOUTH_WEST, BlockDir.NORTH_EAST, BlockDir.NORTH_WEST};
    private static final BlockDir[] EDGES_Z_NEG_NORTH = new BlockDir[]{BlockDir.DOWN_WEST, BlockDir.DOWN_EAST, BlockDir.UP_WEST, BlockDir.UP_EAST};
    private static final BlockDir[] EDGES_Z_POS_SOUTH = new BlockDir[]{BlockDir.DOWN_EAST, BlockDir.DOWN_WEST, BlockDir.UP_EAST, BlockDir.UP_WEST};
    private static final BlockDir[] EDGES_X_NEG_WEST = new BlockDir[]{BlockDir.DOWN_SOUTH, BlockDir.DOWN_NORTH, BlockDir.UP_SOUTH, BlockDir.UP_NORTH};
    private static final BlockDir[] EDGES_X_POS_EAST = new BlockDir[]{BlockDir.DOWN_NORTH, BlockDir.DOWN_SOUTH, BlockDir.UP_NORTH, BlockDir.UP_SOUTH};
    private static final BlockDir[] EDGES_Z_NEG_NORTH_Z_AXIS = new BlockDir[]{BlockDir.UP_EAST, BlockDir.UP_WEST, BlockDir.DOWN_EAST, BlockDir.DOWN_WEST};
    private static final BlockDir[] EDGES_X_POS_EAST_X_AXIS = new BlockDir[]{BlockDir.UP_SOUTH, BlockDir.UP_NORTH, BlockDir.DOWN_SOUTH, BlockDir.DOWN_NORTH};
    public static final dun SPRITE_DEFAULT = new dun(new qt("default"), 0, 0);
    private static final Random RANDOM = new Random(0L);

    public static dll[] getConnectedTexture(bgu blockAccess, bvo blockState, ev blockPos, dll quad, RenderEnv renderEnv) {
        dun spriteIn = quad.a();
        if (spriteIn == null) {
            return renderEnv.getArrayQuadsCtm(quad);
        }
        bmq block = blockState.d();
        if (ConnectedTextures.skipConnectedTexture(blockAccess, blockState, blockPos, quad, renderEnv)) {
            quad = ConnectedTextures.getQuad(emptySprite, quad);
            return renderEnv.getArrayQuadsCtm(quad);
        }
        fa side = quad.e();
        dll[] quads = ConnectedTextures.getConnectedTextureMultiPass(blockAccess, blockState, blockPos, side, quad, renderEnv);
        return quads;
    }

    private static boolean skipConnectedTexture(bgu blockAccess, bvo blockState, ev blockPos, dll quad, RenderEnv renderEnv) {
        bmq block = blockState.d();
        if (block instanceof bpk) {
            bbb colorNeighbour;
            bbb color;
            fa face = quad.e();
            if (face != fa.b && face != fa.a) {
                return false;
            }
            if (!quad.isFaceQuad()) {
                return false;
            }
            ev posNeighbour = blockPos.a(quad.e());
            bvo stateNeighbour = blockAccess.e_(posNeighbour);
            if (stateNeighbour.d() != block) {
                return false;
            }
            bmq blockNeighbour = stateNeighbour.d();
            if (block instanceof bry && blockNeighbour instanceof bry && (color = ((bry)block).a()) != (colorNeighbour = ((bry)blockNeighbour).a())) {
                return false;
            }
            double midX = quad.getMidX();
            if (midX < 0.4) {
                if (((Boolean)stateNeighbour.c((bwr)bnu.d)).booleanValue()) {
                    return true;
                }
            } else if (midX > 0.6) {
                if (((Boolean)stateNeighbour.c((bwr)bnu.b)).booleanValue()) {
                    return true;
                }
            } else {
                double midZ = quad.getMidZ();
                if (midZ < 0.4) {
                    if (((Boolean)stateNeighbour.c((bwr)bnu.a)).booleanValue()) {
                        return true;
                    }
                } else if (midZ > 0.6) {
                    if (((Boolean)stateNeighbour.c((bwr)bnu.c)).booleanValue()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    protected static dll[] getQuads(dun sprite, dll quadIn, RenderEnv renderEnv) {
        if (sprite == null) {
            return null;
        }
        if (sprite == SPRITE_DEFAULT) {
            return renderEnv.getArrayQuadsCtm(quadIn);
        }
        dll quad = ConnectedTextures.getQuad(sprite, quadIn);
        dll[] quads = renderEnv.getArrayQuadsCtm(quad);
        return quads;
    }

    private static synchronized dll getQuad(dun sprite, dll quadIn) {
        dll quad;
        if (spriteQuadMaps == null) {
            return quadIn;
        }
        int spriteIndex = sprite.getIndexInMap();
        if (spriteIndex < 0 || spriteIndex >= spriteQuadMaps.length) {
            return quadIn;
        }
        IdentityHashMap<dll, dll> quadMap = spriteQuadMaps[spriteIndex];
        if (quadMap == null) {
            ConnectedTextures.spriteQuadMaps[spriteIndex] = quadMap = new IdentityHashMap<dll, dll>(1);
        }
        if ((quad = (dll)quadMap.get(quadIn)) == null) {
            quad = ConnectedTextures.makeSpriteQuad(quadIn, sprite);
            quadMap.put(quadIn, quad);
        }
        return quad;
    }

    private static synchronized dll getQuadFull(dun sprite, dll quadIn, int tintIndex) {
        fa face;
        dll quad;
        if (spriteQuadFullMaps == null) {
            return null;
        }
        if (sprite == null) {
            return null;
        }
        int spriteIndex = sprite.getIndexInMap();
        if (spriteIndex < 0 || spriteIndex >= spriteQuadFullMaps.length) {
            return null;
        }
        EnumMap<fa, dll> quadMap = spriteQuadFullMaps[spriteIndex];
        if (quadMap == null) {
            ConnectedTextures.spriteQuadFullMaps[spriteIndex] = quadMap = new EnumMap<fa, dll>(fa.class);
        }
        if ((quad = (dll)quadMap.get(face = quadIn.e())) == null) {
            quad = BlockModelUtils.makeBakedQuad(face, sprite, tintIndex);
            quadMap.put(face, quad);
        }
        return quad;
    }

    private static dll makeSpriteQuad(dll quad, dun sprite) {
        int[] data = (int[])quad.b().clone();
        dun spriteFrom = quad.a();
        for (int i = 0; i < 4; ++i) {
            ConnectedTextures.fixVertex(data, i, spriteFrom, sprite);
        }
        dll bq = new dll(data, quad.d(), quad.e(), sprite);
        return bq;
    }

    private static void fixVertex(int[] data, int vertex, dun spriteFrom, dun spriteTo) {
        int mul = data.length / 4;
        int pos = mul * vertex;
        float u = Float.intBitsToFloat(data[pos + 4]);
        float v = Float.intBitsToFloat(data[pos + 4 + 1]);
        double su16 = spriteFrom.getSpriteU16(u);
        double sv16 = spriteFrom.getSpriteV16(v);
        data[pos + 4] = Float.floatToRawIntBits(spriteTo.a(su16));
        data[pos + 4 + 1] = Float.floatToRawIntBits(spriteTo.b(sv16));
    }

    private static dll[] getConnectedTextureMultiPass(bgu blockAccess, bvo blockState, ev blockPos, fa side, dll quad, RenderEnv renderEnv) {
        dll[] quads = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, quad, true, 0, renderEnv);
        if (!multipass) {
            return quads;
        }
        if (quads.length == 1 && quads[0] == quad) {
            return quads;
        }
        List<dll> listQuads = renderEnv.getListQuadsCtmMultipass(quads);
        for (int q = 0; q < listQuads.size(); ++q) {
            dll[] newMpQuads;
            dll newQuad;
            dll mpQuad = newQuad = listQuads.get(q);
            for (int i = 0; i < 3 && (newMpQuads = ConnectedTextures.getConnectedTextureSingle(blockAccess, blockState, blockPos, side, mpQuad, false, i + 1, renderEnv)).length == 1 && newMpQuads[0] != mpQuad; ++i) {
                mpQuad = newMpQuads[0];
            }
            listQuads.set(q, mpQuad);
        }
        for (int i = 0; i < quads.length; ++i) {
            quads[i] = listQuads.get(i);
        }
        return quads;
    }

    public static dll[] getConnectedTextureSingle(bgu blockAccess, bvo blockState, ev blockPos, fa facing, dll quad, boolean checkBlocks, int pass, RenderEnv renderEnv) {
        int blockId;
        dll[] newQuads;
        ConnectedProperties cp;
        int i;
        int side;
        ConnectedProperties[] cps;
        int iconId;
        bmq block = blockState.d();
        dun icon = quad.a();
        if (tileProperties != null && (iconId = icon.getIndexInMap()) >= 0 && iconId < tileProperties.length && (cps = tileProperties[iconId]) != null) {
            side = ConnectedTextures.getSide(facing);
            for (i = 0; i < cps.length; ++i) {
                cp = cps[i];
                if (cp == null || !cp.matchesBlockId(blockState.getBlockId()) || (newQuads = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockState, blockPos, side, quad, pass, renderEnv)) == null) continue;
                return newQuads;
            }
        }
        if (blockProperties != null && checkBlocks && (blockId = renderEnv.getBlockId()) >= 0 && blockId < blockProperties.length && (cps = blockProperties[blockId]) != null) {
            side = ConnectedTextures.getSide(facing);
            for (i = 0; i < cps.length; ++i) {
                cp = cps[i];
                if (cp == null || !cp.matchesIcon(icon) || (newQuads = ConnectedTextures.getConnectedTexture(cp, blockAccess, blockState, blockPos, side, quad, pass, renderEnv)) == null) continue;
                return newQuads;
            }
        }
        return renderEnv.getArrayQuadsCtm(quad);
    }

    public static int getSide(fa facing) {
        if (facing == null) {
            return -1;
        }
        switch (facing) {
            case a: {
                return 0;
            }
            case b: {
                return 1;
            }
            case f: {
                return 5;
            }
            case e: {
                return 4;
            }
            case c: {
                return 2;
            }
            case d: {
                return 3;
            }
        }
        return -1;
    }

    private static fa getFacing(int side) {
        switch (side) {
            case 0: {
                return fa.a;
            }
            case 1: {
                return fa.b;
            }
            case 5: {
                return fa.f;
            }
            case 4: {
                return fa.e;
            }
            case 2: {
                return fa.c;
            }
            case 3: {
                return fa.d;
            }
        }
        return fa.b;
    }

    private static dll[] getConnectedTexture(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int side, dll quad, int pass, RenderEnv renderEnv) {
        String name;
        bij blockBiome;
        int vertAxis = 0;
        int metadata = blockState.getMetadata();
        bmq block = blockState.d();
        if (block instanceof bra) {
            vertAxis = ConnectedTextures.getPillarAxis(blockState);
        }
        if (!cp.matchesBlock(blockState.getBlockId(), metadata)) {
            return null;
        }
        if (side >= 0 && cp.faces != 63) {
            int sideCheck = side;
            if (vertAxis != 0) {
                sideCheck = ConnectedTextures.fixSideByAxis(side, vertAxis);
            }
            if ((1 << sideCheck & cp.faces) == 0) {
                return null;
            }
        }
        int y = blockPos.p();
        if (cp.heights != null && !cp.heights.isInRange(y)) {
            return null;
        }
        if (cp.biomes != null && !cp.matchesBiome(blockBiome = blockAccess.c(blockPos))) {
            return null;
        }
        if (cp.nbtName != null && !cp.nbtName.matchesValue(name = TileEntityUtils.getTileEntityName(blockAccess, blockPos))) {
            return null;
        }
        dun icon = quad.a();
        switch (cp.method) {
            case 10: {
                if (pass != 0) break;
                return ConnectedTextures.getConnectedTextureCtmCompact(cp, blockAccess, blockState, blockPos, vertAxis, side, quad, metadata, renderEnv);
            }
            case 1: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureCtm(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata, renderEnv), quad, renderEnv);
            }
            case 2: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 6: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 3: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureTop(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 4: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureRandom(cp, blockAccess, blockState, blockPos, side), quad, renderEnv);
            }
            case 5: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureRepeat(cp, blockPos, side), quad, renderEnv);
            }
            case 7: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureFixed(cp), quad, renderEnv);
            }
            case 8: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureHorizontalVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 9: {
                return ConnectedTextures.getQuads(ConnectedTextures.getConnectedTextureVerticalHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata), quad, renderEnv);
            }
            case 11: {
                return ConnectedTextures.getConnectedTextureOverlay(cp, blockAccess, blockState, blockPos, vertAxis, side, quad, metadata, renderEnv);
            }
            case 12: {
                return ConnectedTextures.getConnectedTextureOverlayFixed(cp, quad, renderEnv);
            }
            case 13: {
                return ConnectedTextures.getConnectedTextureOverlayRandom(cp, blockAccess, blockState, blockPos, side, quad, renderEnv);
            }
            case 14: {
                return ConnectedTextures.getConnectedTextureOverlayRepeat(cp, blockPos, side, quad, renderEnv);
            }
            case 15: {
                return ConnectedTextures.getConnectedTextureOverlayCtm(cp, blockAccess, blockState, blockPos, vertAxis, side, quad, metadata, renderEnv);
            }
        }
        return null;
    }

    private static int fixSideByAxis(int side, int vertAxis) {
        switch (vertAxis) {
            case 0: {
                return side;
            }
            case 1: {
                switch (side) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return side;
            }
            case 2: {
                switch (side) {
                    case 0: {
                        return 4;
                    }
                    case 1: {
                        return 5;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 0;
                    }
                }
                return side;
            }
        }
        return side;
    }

    private static int getPillarAxis(bvo blockState) {
        fa.a axis = (fa.a)blockState.c((bwr)bra.a);
        switch (axis) {
            case a: {
                return 2;
            }
            case c: {
                return 1;
            }
        }
        return 0;
    }

    private static dun getConnectedTextureRandom(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int face = side / cp.symmetry * cp.symmetry;
        if (cp.linked) {
            ev posDown = blockPos.c();
            bvo bsDown = blockAccess.e_(posDown);
            while (bsDown.d() == blockState.d() && (posDown = (blockPos = posDown).c()).p() >= 0) {
                bsDown = blockAccess.e_(posDown);
            }
        }
        int rand = Config.getRandom(blockPos, face) & Integer.MAX_VALUE;
        for (int i = 0; i < cp.randomLoops; ++i) {
            rand = Config.intHash(rand);
        }
        int index = 0;
        if (cp.weights == null) {
            index = rand % cp.tileIcons.length;
        } else {
            int randWeight = rand % cp.sumAllWeights;
            int[] sumWeights = cp.sumWeights;
            for (int i = 0; i < sumWeights.length; ++i) {
                if (randWeight >= sumWeights[i]) continue;
                index = i;
                break;
            }
        }
        return cp.tileIcons[index];
    }

    private static dun getConnectedTextureFixed(ConnectedProperties cp) {
        return cp.tileIcons[0];
    }

    private static dun getConnectedTextureRepeat(ConnectedProperties cp, ev blockPos, int side) {
        if (cp.tileIcons.length == 1) {
            return cp.tileIcons[0];
        }
        int x = blockPos.o();
        int y = blockPos.p();
        int z = blockPos.q();
        int nx = 0;
        int ny = 0;
        switch (side) {
            case 0: {
                nx = x;
                ny = -z - 1;
                break;
            }
            case 1: {
                nx = x;
                ny = z;
                break;
            }
            case 2: {
                nx = -x - 1;
                ny = -y;
                break;
            }
            case 3: {
                nx = x;
                ny = -y;
                break;
            }
            case 4: {
                nx = z;
                ny = -y;
                break;
            }
            case 5: {
                nx = -z - 1;
                ny = -y;
            }
        }
        ny %= cp.height;
        if ((nx %= cp.width) < 0) {
            nx += cp.width;
        }
        if (ny < 0) {
            ny += cp.height;
        }
        int index = ny * cp.width + nx;
        return cp.tileIcons[index];
    }

    private static dun getConnectedTextureCtm(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int vertAxis, int side, dun icon, int metadata, RenderEnv renderEnv) {
        int index = ConnectedTextures.getConnectedTextureCtmIndex(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata, renderEnv);
        return cp.tileIcons[index];
    }

    private static synchronized dll[] getConnectedTextureCtmCompact(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int vertAxis, int side, dll quad, int metadata, RenderEnv renderEnv) {
        dun icon = quad.a();
        int index = ConnectedTextures.getConnectedTextureCtmIndex(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata, renderEnv);
        return ConnectedTexturesCompact.getConnectedTextureCtmCompact(index, cp, side, quad, renderEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static dll[] getConnectedTextureOverlay(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int vertAxis, int side, dll quad, int metadata, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        dun icon = quad.a();
        BlockDir[] dirSides = ConnectedTextures.getSideDirections(side, vertAxis);
        boolean[] sides = renderEnv.getBorderFlags();
        for (int i = 0; i < 4; ++i) {
            sides[i] = ConnectedTextures.isNeighbourOverlay(cp, blockAccess, blockState, dirSides[i].offset(blockPos), side, icon, metadata);
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            if (sides[0] && sides[1] && sides[2] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[8], quad, cp.tintIndex), cp.tintBlockState);
                dll[] dllArray = null;
                return dllArray;
            }
            if (sides[0] && sides[1] && sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[5], quad, cp.tintIndex), cp.tintBlockState);
                dll[] dllArray = null;
                return dllArray;
            }
            if (sides[0] && sides[2] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[6], quad, cp.tintIndex), cp.tintBlockState);
                dll[] dllArray = null;
                return dllArray;
            }
            if (sides[1] && sides[2] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[12], quad, cp.tintIndex), cp.tintBlockState);
                dll[] dllArray = null;
                return dllArray;
            }
            if (sides[0] && sides[1] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[13], quad, cp.tintIndex), cp.tintBlockState);
                dll[] dllArray = null;
                return dllArray;
            }
            BlockDir[] dirEdges = ConnectedTextures.getEdgeDirections(side, vertAxis);
            boolean[] edges = renderEnv.getBorderFlags2();
            for (int i = 0; i < 4; ++i) {
                edges[i] = ConnectedTextures.isNeighbourOverlay(cp, blockAccess, blockState, dirEdges[i].offset(blockPos), side, icon, metadata);
            }
            if (sides[1] && sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[3], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[3]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[16], quad, cp.tintIndex), cp.tintBlockState);
                }
                dll[] i = null;
                return i;
            }
            if (sides[0] && sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[4], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[2]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[14], quad, cp.tintIndex), cp.tintBlockState);
                }
                dll[] i = null;
                return i;
            }
            if (sides[1] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[10], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[1]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[2], quad, cp.tintIndex), cp.tintBlockState);
                }
                dll[] i = null;
                return i;
            }
            if (sides[0] && sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[11], quad, cp.tintIndex), cp.tintBlockState);
                if (edges[0]) {
                    listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[0], quad, cp.tintIndex), cp.tintBlockState);
                }
                dll[] i = null;
                return i;
            }
            boolean[] sidesMatch = renderEnv.getBorderFlags3();
            for (int i = 0; i < 4; ++i) {
                sidesMatch[i] = ConnectedTextures.isNeighbourMatching(cp, blockAccess, blockState, dirSides[i].offset(blockPos), side, icon, metadata);
            }
            if (sides[0]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[9], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (sides[1]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[7], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[1], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[15], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[0] && (sidesMatch[1] || sidesMatch[2]) && !sides[1] && !sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[0], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[1] && (sidesMatch[0] || sidesMatch[2]) && !sides[0] && !sides[2]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[2], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[2] && (sidesMatch[1] || sidesMatch[3]) && !sides[1] && !sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[14], quad, cp.tintIndex), cp.tintBlockState);
            }
            if (edges[3] && (sidesMatch[0] || sidesMatch[3]) && !sides[0] && !sides[3]) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(cp.tileIcons[16], quad, cp.tintIndex), cp.tintBlockState);
            }
            dll[] dllArray = null;
            return dllArray;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static dll[] getConnectedTextureOverlayFixed(ConnectedProperties cp, dll quad, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            dun sprite = ConnectedTextures.getConnectedTextureFixed(cp);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            dll[] dllArray = null;
            return dllArray;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static dll[] getConnectedTextureOverlayRandom(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int side, dll quad, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            dun sprite = ConnectedTextures.getConnectedTextureRandom(cp, blockAccess, blockState, blockPos, side);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            dll[] dllArray = null;
            return dllArray;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static dll[] getConnectedTextureOverlayRepeat(ConnectedProperties cp, ev blockPos, int side, dll quad, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            dun sprite = ConnectedTextures.getConnectedTextureRepeat(cp, blockPos, side);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            dll[] dllArray = null;
            return dllArray;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static dll[] getConnectedTextureOverlayCtm(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int vertAxis, int side, dll quad, int metadata, RenderEnv renderEnv) {
        if (!quad.isFullQuad()) {
            return null;
        }
        ListQuadsOverlay listQuadsOverlay = renderEnv.getListQuadsOverlay(cp.layer);
        try {
            dun sprite = ConnectedTextures.getConnectedTextureCtm(cp, blockAccess, blockState, blockPos, vertAxis, side, quad.a(), metadata, renderEnv);
            if (sprite != null) {
                listQuadsOverlay.addQuad(ConnectedTextures.getQuadFull(sprite, quad, cp.tintIndex), cp.tintBlockState);
            }
            dll[] dllArray = null;
            return dllArray;
        }
        finally {
            if (listQuadsOverlay.size() > 0) {
                renderEnv.setOverlaysRendered(true);
            }
        }
    }

    private static BlockDir[] getSideDirections(int side, int vertAxis) {
        switch (side) {
            case 0: {
                return SIDES_Y_NEG_DOWN;
            }
            case 1: {
                return SIDES_Y_POS_UP;
            }
            case 2: {
                if (vertAxis == 1) {
                    return SIDES_Z_NEG_NORTH_Z_AXIS;
                }
                return SIDES_Z_NEG_NORTH;
            }
            case 3: {
                return SIDES_Z_POS_SOUTH;
            }
            case 4: {
                return SIDES_X_NEG_WEST;
            }
            case 5: {
                if (vertAxis == 2) {
                    return SIDES_X_POS_EAST_X_AXIS;
                }
                return SIDES_X_POS_EAST;
            }
        }
        throw new IllegalArgumentException("Unknown side: " + side);
    }

    private static BlockDir[] getEdgeDirections(int side, int vertAxis) {
        switch (side) {
            case 0: {
                return EDGES_Y_NEG_DOWN;
            }
            case 1: {
                return EDGES_Y_POS_UP;
            }
            case 2: {
                if (vertAxis == 1) {
                    return EDGES_Z_NEG_NORTH_Z_AXIS;
                }
                return EDGES_Z_NEG_NORTH;
            }
            case 3: {
                return EDGES_Z_POS_SOUTH;
            }
            case 4: {
                return EDGES_X_NEG_WEST;
            }
            case 5: {
                if (vertAxis == 2) {
                    return EDGES_X_POS_EAST_X_AXIS;
                }
                return EDGES_X_POS_EAST;
            }
        }
        throw new IllegalArgumentException("Unknown side: " + side);
    }

    protected static Map[][] getSpriteQuadCompactMaps() {
        return spriteQuadCompactMaps;
    }

    private static int getConnectedTextureCtmIndex(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int vertAxis, int side, dun icon, int metadata, RenderEnv renderEnv) {
        boolean[] borders = renderEnv.getBorderFlags();
        switch (side) {
            case 0: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                if (!cp.innerSeams) break;
                ev posFront = blockPos.c();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.d(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.e(), side, icon, metadata);
                break;
            }
            case 1: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                if (!cp.innerSeams) break;
                ev posFront = blockPos.b();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.e(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.d(), side, icon, metadata);
                break;
            }
            case 2: {
                ev posFront;
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                if (cp.innerSeams) {
                    posFront = blockPos.d();
                    borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g(), side, icon, metadata);
                    borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f(), side, icon, metadata);
                    borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c(), side, icon, metadata);
                    boolean bl = borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b(), side, icon, metadata);
                }
                if (vertAxis != 1) break;
                ConnectedTextures.switchValues(0, 1, borders);
                ConnectedTextures.switchValues(2, 3, borders);
                break;
            }
            case 3: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                if (!cp.innerSeams) break;
                ev posFront = blockPos.e();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.f(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.g(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b(), side, icon, metadata);
                break;
            }
            case 4: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                if (!cp.innerSeams) break;
                ev posFront = blockPos.f();
                borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.d(), side, icon, metadata);
                borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.e(), side, icon, metadata);
                borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c(), side, icon, metadata);
                borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b(), side, icon, metadata);
                break;
            }
            case 5: {
                ev posFront;
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                if (cp.innerSeams) {
                    posFront = blockPos.g();
                    borders[0] = borders[0] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.e(), side, icon, metadata);
                    borders[1] = borders[1] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.d(), side, icon, metadata);
                    borders[2] = borders[2] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.c(), side, icon, metadata);
                    boolean bl = borders[3] = borders[3] && !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, posFront.b(), side, icon, metadata);
                }
                if (vertAxis != 2) break;
                ConnectedTextures.switchValues(0, 1, borders);
                ConnectedTextures.switchValues(2, 3, borders);
            }
        }
        int index = 0;
        if (borders[0] & !borders[1] & !borders[2] & !borders[3]) {
            index = 3;
        } else if (!borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 1;
        } else if (!borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 12;
        } else if (!borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 36;
        } else if (borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 2;
        } else if (!borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 24;
        } else if (borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 15;
        } else if (borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 39;
        } else if (!borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 13;
        } else if (!borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 37;
        } else if (!borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 25;
        } else if (borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 27;
        } else if (borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 38;
        } else if (borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 14;
        } else if (borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 26;
        }
        if (index == 0) {
            return index;
        }
        if (!Config.isConnectedTexturesFancy()) {
            return index;
        }
        boolean[] edges = borders;
        switch (side) {
            case 0: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().d(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().d(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().e(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().e(), side, icon, metadata);
                break;
            }
            case 1: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().e(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().e(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().d(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().d(), side, icon, metadata);
                break;
            }
            case 2: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().c(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().c(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().b(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().b(), side, icon, metadata);
                if (vertAxis != 1) break;
                ConnectedTextures.switchValues(0, 3, borders);
                ConnectedTextures.switchValues(1, 2, borders);
                break;
            }
            case 3: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().c(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().c(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g().b(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f().b(), side, icon, metadata);
                break;
            }
            case 4: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c().e(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c().d(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().e(), side, icon, metadata);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().d(), side, icon, metadata);
                break;
            }
            case 5: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c().d(), side, icon, metadata);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c().e(), side, icon, metadata);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().d(), side, icon, metadata);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b().e(), side, icon, metadata);
                if (vertAxis != 2) break;
                ConnectedTextures.switchValues(0, 3, borders);
                ConnectedTextures.switchValues(1, 2, borders);
            }
        }
        if (index == 13 && edges[0]) {
            index = 4;
        } else if (index == 15 && edges[1]) {
            index = 5;
        } else if (index == 37 && edges[2]) {
            index = 16;
        } else if (index == 39 && edges[3]) {
            index = 17;
        } else if (index == 14 && edges[0] && edges[1]) {
            index = 7;
        } else if (index == 25 && edges[0] && edges[2]) {
            index = 6;
        } else if (index == 27 && edges[3] && edges[1]) {
            index = 19;
        } else if (index == 38 && edges[3] && edges[2]) {
            index = 18;
        } else if (index == 14 && !edges[0] && edges[1]) {
            index = 31;
        } else if (index == 25 && edges[0] && !edges[2]) {
            index = 30;
        } else if (index == 27 && !edges[3] && edges[1]) {
            index = 41;
        } else if (index == 38 && edges[3] && !edges[2]) {
            index = 40;
        } else if (index == 14 && edges[0] && !edges[1]) {
            index = 29;
        } else if (index == 25 && !edges[0] && edges[2]) {
            index = 28;
        } else if (index == 27 && edges[3] && !edges[1]) {
            index = 43;
        } else if (index == 38 && !edges[3] && edges[2]) {
            index = 42;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 46;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 9;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 21;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 8;
        } else if (index == 26 && edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 20;
        } else if (index == 26 && edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 11;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 22;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 23;
        } else if (index == 26 && edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 10;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 34;
        } else if (index == 26 && !edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 35;
        } else if (index == 26 && edges[0] && !edges[1] && !edges[2] && !edges[3]) {
            index = 32;
        } else if (index == 26 && !edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 33;
        } else if (index == 26 && !edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 44;
        } else if (index == 26 && !edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 45;
        }
        return index;
    }

    private static void switchValues(int ix1, int ix2, boolean[] arr) {
        boolean prev1 = arr[ix1];
        arr[ix1] = arr[ix2];
        arr[ix2] = prev1;
    }

    private static boolean isNeighbourOverlay(ConnectedProperties cp, bgu worldReader, bvo blockState, ev blockPos, int side, dun icon, int metadata) {
        dun neighbourIcon;
        bvo neighbourState = worldReader.e_(blockPos);
        if (!ConnectedTextures.isFullCubeModel(neighbourState, (bgw)worldReader, blockPos)) {
            return false;
        }
        if (cp.connectBlocks != null && !Matches.block(neighbourState.getBlockId(), neighbourState.getMetadata(), cp.connectBlocks)) {
            return false;
        }
        if (cp.connectTileIcons != null && !Config.isSameOne(neighbourIcon = ConnectedTextures.getNeighbourIcon(worldReader, blockState, blockPos, neighbourState, side), cp.connectTileIcons)) {
            return false;
        }
        ev posNeighbourStateAbove = blockPos.a(ConnectedTextures.getFacing(side));
        bvo neighbourStateAbove = worldReader.e_(posNeighbourStateAbove);
        if (neighbourStateAbove.g((bgw)worldReader, posNeighbourStateAbove)) {
            return false;
        }
        if (side == 1 && neighbourStateAbove.d() == bmr.cA) {
            return false;
        }
        return !ConnectedTextures.isNeighbour(cp, worldReader, blockState, blockPos, neighbourState, side, icon, metadata);
    }

    private static boolean isFullCubeModel(bvo state, bgw blockReader, ev pos) {
        if (BlockUtils.isFullCube(state, blockReader, pos)) {
            return true;
        }
        bmq block = state.d();
        if (block instanceof box) {
            return true;
        }
        return block instanceof brx;
    }

    private static boolean isNeighbourMatching(ConnectedProperties cp, bgu worldReader, bvo blockState, ev blockPos, int side, dun icon, int metadata) {
        dun neighbourIcon;
        bvo neighbourState = worldReader.e_(blockPos);
        if (neighbourState == AIR_DEFAULT_STATE) {
            return false;
        }
        if (cp.matchBlocks != null && !cp.matchesBlock(neighbourState.getBlockId(), neighbourState.getMetadata())) {
            return false;
        }
        if (cp.matchTileIcons != null && (neighbourIcon = ConnectedTextures.getNeighbourIcon(worldReader, blockState, blockPos, neighbourState, side)) != icon) {
            return false;
        }
        ev posNeighbourAbove = blockPos.a(ConnectedTextures.getFacing(side));
        bvo neighbourStateAbove = worldReader.e_(posNeighbourAbove);
        if (neighbourStateAbove.g((bgw)worldReader, posNeighbourAbove)) {
            return false;
        }
        return side != 1 || neighbourStateAbove.d() != bmr.cA;
    }

    private static boolean isNeighbour(ConnectedProperties cp, bgu worldReader, bvo blockState, ev blockPos, int side, dun icon, int metadata) {
        bvo neighbourState = worldReader.e_(blockPos);
        return ConnectedTextures.isNeighbour(cp, worldReader, blockState, blockPos, neighbourState, side, icon, metadata);
    }

    private static boolean isNeighbour(ConnectedProperties cp, bgu worldReader, bvo blockState, ev blockPos, bvo neighbourState, int side, dun icon, int metadata) {
        if (blockState == neighbourState) {
            return true;
        }
        if (cp.connect == 2) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            dun neighbourIcon = ConnectedTextures.getNeighbourIcon(worldReader, blockState, blockPos, neighbourState, side);
            return neighbourIcon == icon;
        }
        if (cp.connect == 3) {
            if (neighbourState == null) {
                return false;
            }
            if (neighbourState == AIR_DEFAULT_STATE) {
                return false;
            }
            return neighbourState.e() == blockState.e();
        }
        if (cp.connect == 1) {
            bmq block = blockState.d();
            bmq neighbourBlock = neighbourState.d();
            return neighbourBlock == block;
        }
        return false;
    }

    private static dun getNeighbourIcon(bgu worldReader, bvo blockState, ev blockPos, bvo neighbourState, int side) {
        fa facing;
        List quads;
        dwb model = cvo.u().U().a().b(neighbourState);
        if (model == null) {
            return null;
        }
        if (Reflector.IForgeBlock_getExtendedState.exists()) {
            neighbourState = (bvo)Reflector.call(neighbourState.d(), Reflector.IForgeBlock_getExtendedState, neighbourState, worldReader, blockPos);
        }
        if ((quads = model.a(neighbourState, facing = ConnectedTextures.getFacing(side), RANDOM)) == null) {
            return null;
        }
        if (Config.isBetterGrass()) {
            quads = BetterGrass.getFaceQuads(worldReader, neighbourState, blockPos, facing, quads);
        }
        if (quads.size() > 0) {
            dll quad = (dll)quads.get(0);
            return quad.a();
        }
        List quadsGeneral = model.a(neighbourState, null, RANDOM);
        if (quadsGeneral == null) {
            return null;
        }
        for (int i = 0; i < quadsGeneral.size(); ++i) {
            dll quad = (dll)quadsGeneral.get(i);
            if (quad.e() != facing) continue;
            return quad.a();
        }
        return null;
    }

    private static dun getConnectedTextureHorizontal(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int vertAxis, int side, dun icon, int metadata) {
        boolean left = false;
        boolean right = false;
        block0 : switch (vertAxis) {
            case 0: {
                switch (side) {
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                    }
                }
                break;
            }
            case 1: {
                switch (side) {
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        break;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
                        break;
                    }
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        break;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    }
                }
                break;
            }
            case 2: {
                switch (side) {
                    case 4: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        break block0;
                    }
                    case 5: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        break block0;
                    }
                    case 2: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        break block0;
                    }
                    case 3: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                        break block0;
                    }
                    case 0: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        break block0;
                    }
                    case 1: {
                        left = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                        right = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                    }
                }
            }
        }
        int index = 3;
        index = left ? (right ? 1 : 2) : (right ? 0 : 3);
        return cp.tileIcons[index];
    }

    private static dun getConnectedTextureVertical(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int vertAxis, int side, dun icon, int metadata) {
        boolean bottom = false;
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                    break;
                }
                if (side == 0) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                    break;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    break;
                }
                if (side == 2) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    break;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.d(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    break;
                }
                if (side == 4) {
                    bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.c(), side, icon, metadata);
                    top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                    break;
                }
                bottom = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.f(), side, icon, metadata);
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
            }
        }
        int index = 3;
        index = bottom ? (top ? 1 : 2) : (top ? 0 : 3);
        return cp.tileIcons[index];
    }

    private static dun getConnectedTextureHorizontalVertical(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int vertAxis, int side, dun icon, int metadata) {
        dun[] tileIcons = cp.tileIcons;
        dun iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconH != null && iconH != icon && iconH != tileIcons[3]) {
            return iconH;
        }
        dun iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconV == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconV == tileIcons[1]) {
            return tileIcons[5];
        }
        if (iconV == tileIcons[2]) {
            return tileIcons[6];
        }
        return iconV;
    }

    private static dun getConnectedTextureVerticalHorizontal(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int vertAxis, int side, dun icon, int metadata) {
        dun[] tileIcons = cp.tileIcons;
        dun iconV = ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconV != null && iconV != icon && iconV != tileIcons[3]) {
            return iconV;
        }
        dun iconH = ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, blockState, blockPos, vertAxis, side, icon, metadata);
        if (iconH == tileIcons[0]) {
            return tileIcons[4];
        }
        if (iconH == tileIcons[1]) {
            return tileIcons[5];
        }
        if (iconH == tileIcons[2]) {
            return tileIcons[6];
        }
        return iconH;
    }

    private static dun getConnectedTextureTop(ConnectedProperties cp, bgu blockAccess, bvo blockState, ev blockPos, int vertAxis, int side, dun icon, int metadata) {
        boolean top = false;
        switch (vertAxis) {
            case 0: {
                if (side == 1 || side == 0) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.b(), side, icon, metadata);
                break;
            }
            case 1: {
                if (side == 3 || side == 2) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.e(), side, icon, metadata);
                break;
            }
            case 2: {
                if (side == 5 || side == 4) {
                    return null;
                }
                top = ConnectedTextures.isNeighbour(cp, blockAccess, blockState, blockPos.g(), side, icon, metadata);
            }
        }
        if (top) {
            return cp.tileIcons[0];
        }
        return null;
    }

    public static void updateIcons(dum textureMap) {
        blockProperties = null;
        tileProperties = null;
        spriteQuadMaps = null;
        spriteQuadCompactMaps = null;
        if (!Config.isConnectedTextures()) {
            return;
        }
        wj[] rps = Config.getResourcePacks();
        for (int i = rps.length - 1; i >= 0; --i) {
            wj rp = rps[i];
            ConnectedTextures.updateIcons(textureMap, rp);
        }
        ConnectedTextures.updateIcons(textureMap, (wj)Config.getDefaultResourcePack());
        qt locEmpty = new qt("optifine/ctm/default/empty");
        emptySprite = textureMap.registerSprite(locEmpty);
        spriteQuadMaps = new Map[textureMap.getCountRegisteredSprites() + 1];
        spriteQuadFullMaps = new Map[textureMap.getCountRegisteredSprites() + 1];
        spriteQuadCompactMaps = new Map[textureMap.getCountRegisteredSprites() + 1][];
        if (blockProperties.length <= 0) {
            blockProperties = null;
        }
        if (tileProperties.length <= 0) {
            tileProperties = null;
        }
    }

    private static void updateIconEmpty(dum textureMap) {
    }

    public static void updateIcons(dum textureMap, wj rp) {
        Object[] names = ResUtils.collectFiles(rp, "optifine/ctm/", ".properties", ConnectedTextures.getDefaultCtmPaths());
        Arrays.sort(names);
        List tileList = ConnectedTextures.makePropertyList(tileProperties);
        List blockList = ConnectedTextures.makePropertyList(blockProperties);
        for (int i = 0; i < names.length; ++i) {
            Object name = names[i];
            Config.dbg("ConnectedTextures: " + (String)name);
            try {
                qt locFile = new qt((String)name);
                InputStream in = rp.a(wk.a, locFile);
                if (in == null) {
                    Config.warn("ConnectedTextures file not found: " + (String)name);
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                ConnectedProperties cp = new ConnectedProperties(props, (String)name);
                if (!cp.isValid((String)name)) continue;
                cp.updateIcons(textureMap);
                ConnectedTextures.addToTileList(cp, tileList);
                ConnectedTextures.addToBlockList(cp, blockList);
                continue;
            }
            catch (FileNotFoundException e) {
                Config.warn("ConnectedTextures file not found: " + (String)name);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        blockProperties = ConnectedTextures.propertyListToArray(blockList);
        tileProperties = ConnectedTextures.propertyListToArray(tileList);
        multipass = ConnectedTextures.detectMultipass();
        Config.dbg("Multipass connected textures: " + multipass);
    }

    private static List makePropertyList(ConnectedProperties[][] propsArr) {
        ArrayList<ArrayList<ConnectedProperties>> list = new ArrayList<ArrayList<ConnectedProperties>>();
        if (propsArr != null) {
            for (int i = 0; i < propsArr.length; ++i) {
                ConnectedProperties[] props = propsArr[i];
                ArrayList<ConnectedProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<ConnectedProperties>(Arrays.asList(props));
                }
                list.add(propList);
            }
        }
        return list;
    }

    private static boolean detectMultipass() {
        ConnectedProperties[] cps;
        int i;
        ArrayList<ConnectedProperties> propList = new ArrayList<ConnectedProperties>();
        for (i = 0; i < tileProperties.length; ++i) {
            cps = tileProperties[i];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        for (i = 0; i < blockProperties.length; ++i) {
            cps = blockProperties[i];
            if (cps == null) continue;
            propList.addAll(Arrays.asList(cps));
        }
        ConnectedProperties[] props = propList.toArray(new ConnectedProperties[propList.size()]);
        HashSet<dun> matchIconSet = new HashSet<dun>();
        HashSet<dun> tileIconSet = new HashSet<dun>();
        for (int i2 = 0; i2 < props.length; ++i2) {
            ConnectedProperties cp = props[i2];
            if (cp.matchTileIcons != null) {
                matchIconSet.addAll(Arrays.asList(cp.matchTileIcons));
            }
            if (cp.tileIcons == null) continue;
            tileIconSet.addAll(Arrays.asList(cp.tileIcons));
        }
        matchIconSet.retainAll(tileIconSet);
        return !matchIconSet.isEmpty();
    }

    private static ConnectedProperties[][] propertyListToArray(List list) {
        ConnectedProperties[][] propArr = new ConnectedProperties[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            ConnectedProperties[] subArr = subList.toArray(new ConnectedProperties[subList.size()]);
            propArr[i] = subArr;
        }
        return propArr;
    }

    private static void addToTileList(ConnectedProperties cp, List tileList) {
        if (cp.matchTileIcons == null) {
            return;
        }
        for (int i = 0; i < cp.matchTileIcons.length; ++i) {
            dun icon = cp.matchTileIcons[i];
            if (!(icon instanceof dun)) {
                Config.warn("TextureAtlasSprite is not TextureAtlasSprite: " + icon + ", name: " + icon.m());
                continue;
            }
            dun ts = icon;
            int tileId = ts.getIndexInMap();
            if (tileId < 0) {
                Config.warn("Invalid tile ID: " + tileId + ", icon: " + ts.m());
                continue;
            }
            ConnectedTextures.addToList(cp, tileList, tileId);
        }
    }

    private static void addToBlockList(ConnectedProperties cp, List blockList) {
        if (cp.matchBlocks == null) {
            return;
        }
        for (int i = 0; i < cp.matchBlocks.length; ++i) {
            int blockId = cp.matchBlocks[i].getBlockId();
            if (blockId < 0) {
                Config.warn("Invalid block ID: " + blockId);
                continue;
            }
            ConnectedTextures.addToList(cp, blockList, blockId);
        }
    }

    private static void addToList(ConnectedProperties cp, List list, int id2) {
        while (id2 >= list.size()) {
            list.add(null);
        }
        ArrayList<ConnectedProperties> subList = (ArrayList<ConnectedProperties>)list.get(id2);
        if (subList == null) {
            subList = new ArrayList<ConnectedProperties>();
            list.set(id2, subList);
        }
        subList.add(cp);
    }

    private static String[] getDefaultCtmPaths() {
        ArrayList<String> list = new ArrayList<String>();
        String defPath = "optifine/ctm/default/";
        if (Config.isFromDefaultResourcePack(new qt("textures/block/glass.png"))) {
            list.add(defPath + "20_glass/glass.properties");
            list.add(defPath + "20_glass/glass_pane.properties");
        }
        if (Config.isFromDefaultResourcePack(new qt("textures/block/bookshelf.png"))) {
            list.add(defPath + "30_bookshelf/bookshelf.properties");
        }
        if (Config.isFromDefaultResourcePack(new qt("textures/block/sandstone.png"))) {
            list.add(defPath + "40_sandstone/sandstone.properties");
        }
        if (Config.isFromDefaultResourcePack(new qt("textures/block/red_sandstone.png"))) {
            list.add(defPath + "41_red_sandstone/red_sandstone.properties");
        }
        String[] colors = new String[]{"white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"};
        for (int i = 0; i < colors.length; ++i) {
            String color = colors[i];
            if (!Config.isFromDefaultResourcePack(new qt("textures/block/" + color + "_stained_glass.png"))) continue;
            String prefix = StrUtils.fillLeft("" + i, 2, '0');
            list.add(defPath + prefix + "_glass_" + color + "/glass_" + color + ".properties");
            list.add(defPath + prefix + "_glass_" + color + "/glass_pane_" + color + ".properties");
        }
        String[] paths = list.toArray(new String[list.size()]);
        return paths;
    }
}

