/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import optifine.HashUtils;
import optifine.Installer;
import optifine.Patcher;
import optifine.Utils;
import optifine.xdelta.Delta;
import optifine.xdelta.DeltaException;
import optifine.xdelta.DiffWriter;
import optifine.xdelta.GDiffWriter;

public class Differ {
    public static void main(String[] args) {
        if (args.length < 3) {
            Utils.dbg("Usage: Differ <base.jar> <mod.jar> <diff.jar>");
            return;
        }
        File baseFile = new File(args[0]);
        File modFile = new File(args[1]);
        File diffFile = new File(args[2]);
        try {
            if (baseFile.getName().equals("AUTO")) {
                baseFile = Differ.detectBaseFile(modFile);
            }
            if (!baseFile.exists() || !baseFile.isFile()) {
                throw new IOException("Base file not found: " + baseFile);
            }
            if (!modFile.exists() || !modFile.isFile()) {
                throw new IOException("Mod file not found: " + modFile);
            }
            Differ.process(baseFile, modFile, diffFile);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            System.exit(1);
        }
    }

    private static void process(File baseFile, File modFile, File diffFile) throws IOException, DeltaException, NoSuchAlgorithmException {
        ZipFile modZip = new ZipFile(modFile);
        Map<String, String> cfgMap = Patcher.getConfigurationMap(modZip);
        Pattern[] patterns = Patcher.getConfigurationPatterns(cfgMap);
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(diffFile));
        ZipFile baseZip = new ZipFile(baseFile);
        Enumeration<? extends ZipEntry> modZipEntries = modZip.entries();
        HashMap<String, Map<String, Integer>> mapStats = new HashMap<String, Map<String, Integer>>();
        while (modZipEntries.hasMoreElements()) {
            ZipEntry modZipEntry = modZipEntries.nextElement();
            if (modZipEntry.isDirectory()) continue;
            InputStream in = modZip.getInputStream(modZipEntry);
            byte[] bytes = Utils.readAll(in);
            String name = modZipEntry.getName();
            byte[] bytesDiff = Differ.makeDiff(name, bytes, patterns, cfgMap, baseZip);
            if (bytesDiff != bytes) {
                ZipEntry zipEntryDiff = new ZipEntry("patch/" + name + ".xdelta");
                zipOut.putNextEntry(zipEntryDiff);
                zipOut.write(bytesDiff);
                zipOut.closeEntry();
                Differ.addStat(mapStats, name, "delta");
                byte[] md5 = HashUtils.getHashMd5(bytes);
                String md5Str = HashUtils.toHexString(md5);
                byte[] bytesMd5Str = md5Str.getBytes("ASCII");
                ZipEntry zipEntryMd5 = new ZipEntry("patch/" + name + ".md5");
                zipOut.putNextEntry(zipEntryMd5);
                zipOut.write(bytesMd5Str);
                zipOut.closeEntry();
                continue;
            }
            ZipEntry zipEntrySame = new ZipEntry(name);
            zipOut.putNextEntry(zipEntrySame);
            zipOut.write(bytes);
            zipOut.closeEntry();
            Differ.addStat(mapStats, name, "same");
        }
        zipOut.close();
        Differ.printStats(mapStats);
    }

    private static void printStats(Map<String, Map<String, Integer>> mapStats) {
        ArrayList<String> folders = new ArrayList<String>(mapStats.keySet());
        Collections.sort(folders);
        for (String folder : folders) {
            Map<String, Integer> map = mapStats.get(folder);
            ArrayList<String> types = new ArrayList<String>(map.keySet());
            Collections.sort(types);
            String dbg2 = "";
            for (String type : types) {
                Integer val = map.get(type);
                if (dbg2.length() > 0) {
                    dbg2 = String.valueOf(dbg2) + ", ";
                }
                dbg2 = String.valueOf(dbg2) + type + " " + val;
            }
            Utils.dbg(folder + " = " + dbg2);
        }
    }

    private static void addStat(Map<String, Map<String, Integer>> mapStats, String name, String type) {
        Integer val;
        Map<String, Integer> map;
        int pos = name.lastIndexOf(47);
        String folder = "";
        if (pos >= 0) {
            folder = name.substring(0, pos);
        }
        if ((map = mapStats.get(folder)) == null) {
            map = new HashMap<String, Integer>();
            mapStats.put(folder, map);
        }
        if ((val = map.get(type)) == null) {
            val = new Integer(0);
        }
        val = new Integer(val + 1);
        map.put(type, val);
    }

    public static byte[] makeDiff(String name, byte[] bytesMod, Pattern[] patterns, Map<String, String> cfgMap, ZipFile zipBase) throws IOException, DeltaException {
        String baseName = Patcher.getPatchBase(name, patterns, cfgMap);
        if (baseName == null) {
            return bytesMod;
        }
        ZipEntry baseEntry = zipBase.getEntry(baseName);
        if (baseEntry == null) {
            throw new IOException("Base entry not found: " + baseName + " in: " + zipBase.getName());
        }
        InputStream baseIn = zipBase.getInputStream(baseEntry);
        byte[] baseBytes = Utils.readAll(baseIn);
        ByteArrayInputStream baisTarget = new ByteArrayInputStream(bytesMod);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GDiffWriter diffWriter = new GDiffWriter(new DataOutputStream(outputStream));
        Delta.computeDelta(baseBytes, (InputStream)baisTarget, bytesMod.length, (DiffWriter)diffWriter);
        diffWriter.close();
        return outputStream.toByteArray();
    }

    public static File detectBaseFile(File modFile) throws IOException {
        ZipFile modZip = new ZipFile(modFile);
        String ofVer = Installer.getOptiFineVersion(modZip);
        if (ofVer == null) {
            throw new IOException("Version not found");
        }
        modZip.close();
        String mcVer = Installer.getMinecraftVersionFromOfVersion(ofVer);
        if (mcVer == null) {
            throw new IOException("Version not found");
        }
        File dirMc = Utils.getWorkingDirectory();
        File baseFile = new File(dirMc, "versions/" + mcVer + "/" + mcVer + ".jar");
        Utils.dbg("BaseFile: " + baseFile);
        return baseFile;
    }
}

