/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.nio.ByteBuffer;

public class BufferUtils {
    public static String getBufferHex(cyg bb) {
        int drawMode = bb.getDrawMode();
        String primitiveName = "";
        int vertexPerPrimitive = -1;
        if (drawMode == 7) {
            primitiveName = "quad";
            vertexPerPrimitive = 4;
        } else if (drawMode == 4) {
            primitiveName = "triangle";
            vertexPerPrimitive = 3;
        } else {
            return "Invalid draw mode: " + drawMode;
        }
        StringBuffer sb2 = new StringBuffer();
        int vertexCount = bb.getVertexCount();
        for (int v = 0; v < vertexCount; ++v) {
            if (v % vertexPerPrimitive == 0) {
                sb2.append(primitiveName + " " + v / vertexPerPrimitive + "\n");
            }
            String vs = BufferUtils.getVertexHex(v, bb);
            sb2.append(vs);
            sb2.append("\n");
        }
        return sb2.toString();
    }

    private static String getVertexHex(int vertex, cyg bb) {
        StringBuffer sb2 = new StringBuffer();
        ByteBuffer buf2 = bb.getByteBuffer();
        cyp vf = bb.getVertexFormat();
        int pos = bb.getStartPosition() + vertex * vf.b();
        for (cyq vfe : vf.c()) {
            if (vfe.c() > 0) {
                sb2.append("(");
            }
            for (int i2 = 0; i2 < vfe.c(); ++i2) {
                if (i2 > 0) {
                    sb2.append(" ");
                }
                switch (vfe.a()) {
                    case a: {
                        sb2.append(buf2.getFloat(pos));
                        break;
                    }
                    case b: 
                    case c: {
                        sb2.append(buf2.get(pos));
                        break;
                    }
                    case d: 
                    case e: {
                        sb2.append(buf2.getShort(pos));
                        break;
                    }
                    case f: 
                    case g: {
                        sb2.append(buf2.getShort(pos));
                        break;
                    }
                    default: {
                        sb2.append("??");
                    }
                }
                pos += vfe.a().a();
            }
            if (vfe.c() <= 0) continue;
            sb2.append(")");
        }
        return sb2.toString();
    }
}

