/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.override;

import java.util.Arrays;
import net.minecraft.world.level.ColorResolver;
import net.optifine.render.RenderEnv;
import net.optifine.util.ArrayCache;

public class ChunkCacheOF
implements bje {
    private final dti chunkCache;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int sizeXY;
    private int[] skyLights;
    private int[] blockLights;
    private byj[] blockStates;
    private bkt[] biomes;
    private final int arraySize;
    private RenderEnv renderEnv;
    private static final ArrayCache cacheSkyLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockLights = new ArrayCache(Integer.TYPE, 16);
    private static final ArrayCache cacheBlockStates = new ArrayCache(byj.class, 16);
    private static final ArrayCache cacheBiomes = new ArrayCache(bkt.class, 16);

    public ChunkCacheOF(dti chunkCache, fk posFromIn, fk posToIn, int subIn) {
        this.chunkCache = chunkCache;
        int minChunkX = posFromIn.o() - subIn >> 4;
        int minChunkY = posFromIn.p() - subIn >> 4;
        int minChunkZ = posFromIn.q() - subIn >> 4;
        int maxChunkX = posToIn.o() + subIn >> 4;
        int maxChunkY = posToIn.p() + subIn >> 4;
        int maxChunkZ = posToIn.q() + subIn >> 4;
        this.sizeX = maxChunkX - minChunkX + 1 << 4;
        this.sizeY = maxChunkY - minChunkY + 1 << 4;
        this.sizeZ = maxChunkZ - minChunkZ + 1 << 4;
        this.sizeXY = this.sizeX * this.sizeY;
        this.arraySize = this.sizeX * this.sizeY * this.sizeZ;
        this.posX = minChunkX << 4;
        this.posY = minChunkY << 4;
        this.posZ = minChunkZ << 4;
    }

    private int getPositionIndex(fk pos) {
        int dx = pos.o() - this.posX;
        if (dx < 0 || dx >= this.sizeX) {
            return -1;
        }
        int dy = pos.p() - this.posY;
        if (dy < 0 || dy >= this.sizeY) {
            return -1;
        }
        int dz = pos.q() - this.posZ;
        if (dz < 0 || dz >= this.sizeZ) {
            return -1;
        }
        return dz * this.sizeXY + dy * this.sizeX + dx;
    }

    public int a(bkf type, fk pos) {
        int[] lights;
        if (type == bkf.a) {
            lights = this.skyLights;
        } else if (type == bkf.b) {
            lights = this.blockLights;
        } else {
            return this.getLightForRaw(type, pos);
        }
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || lights == null) {
            return this.getLightForRaw(type, pos);
        }
        int light = lights[index];
        if (light == -1) {
            lights[index] = light = this.getLightForRaw(type, pos);
        }
        return light;
    }

    private int getLightForRaw(bkf type, fk pos) {
        return this.chunkCache.a(type, pos);
    }

    public byj d_(fk pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.blockStates == null) {
            return this.chunkCache.d_(pos);
        }
        byj iblockstate = this.blockStates[index];
        if (iblockstate == null) {
            this.blockStates[index] = iblockstate = this.chunkCache.d_(pos);
        }
        return iblockstate;
    }

    public void renderStart() {
        if (this.skyLights == null) {
            this.skyLights = (int[])cacheSkyLights.allocate(this.arraySize);
        }
        if (this.blockLights == null) {
            this.blockLights = (int[])cacheBlockLights.allocate(this.arraySize);
        }
        Arrays.fill(this.skyLights, -1);
        Arrays.fill(this.blockLights, -1);
        if (this.blockStates == null) {
            this.blockStates = (byj[])cacheBlockStates.allocate(this.arraySize);
        }
        Arrays.fill(this.blockStates, null);
        if (this.biomes == null) {
            this.biomes = (bkt[])cacheBiomes.allocate(this.arraySize);
        }
        Arrays.fill(this.biomes, null);
    }

    public void renderFinish() {
        cacheSkyLights.free(this.skyLights);
        this.skyLights = null;
        cacheBlockLights.free(this.blockLights);
        this.blockLights = null;
        cacheBlockStates.free(this.blockStates);
        this.blockStates = null;
        cacheBiomes.free(this.biomes);
        this.biomes = null;
    }

    public bkt getBiome(fk pos) {
        int index = this.getPositionIndex(pos);
        if (index < 0 || index >= this.arraySize || this.biomes == null) {
            return this.chunkCache.getBiome(pos);
        }
        bkt biome = this.biomes[index];
        if (biome == null) {
            this.biomes[index] = biome = this.chunkCache.getBiome(pos);
        }
        return biome;
    }

    public bwl c(fk pos) {
        return this.chunkCache.a(pos, cal.a.c);
    }

    public bwl getTileEntity(fk pos, cal.a type) {
        return this.chunkCache.a(pos, type);
    }

    public boolean f(fk pos) {
        return this.chunkCache.f(pos);
    }

    public coj b(fk pos) {
        return this.d_(pos).p();
    }

    public int a(fk blockPosIn, ColorResolver colorResolverIn) {
        return this.chunkCache.a(blockPosIn, colorResolverIn);
    }

    public coa e() {
        return this.chunkCache.e();
    }

    public RenderEnv getRenderEnv() {
        return this.renderEnv;
    }

    public void setRenderEnv(RenderEnv renderEnv) {
        this.renderEnv = renderEnv;
    }
}

