/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

public class ModelSprite {
    private dni modelRenderer = null;
    private int textureOffsetX = 0;
    private int textureOffsetY = 0;
    private float posX = 0.0f;
    private float posY = 0.0f;
    private float posZ = 0.0f;
    private int sizeX = 0;
    private int sizeY = 0;
    private int sizeZ = 0;
    private float sizeAdd = 0.0f;
    private float minU = 0.0f;
    private float minV = 0.0f;
    private float maxU = 0.0f;
    private float maxV = 0.0f;

    public ModelSprite(dni modelRenderer, int textureOffsetX, int textureOffsetY, float posX, float posY, float posZ, int sizeX, int sizeY, int sizeZ, float sizeAdd) {
        this.modelRenderer = modelRenderer;
        this.textureOffsetX = textureOffsetX;
        this.textureOffsetY = textureOffsetY;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.sizeAdd = sizeAdd;
        this.minU = (float)textureOffsetX / modelRenderer.i;
        this.minV = (float)textureOffsetY / modelRenderer.j;
        this.maxU = (float)(textureOffsetX + sizeX) / modelRenderer.i;
        this.maxV = (float)(textureOffsetY + sizeY) / modelRenderer.j;
    }

    public void render(cyl matrixStackIn, cyo bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        float scale = 0.0625f;
        matrixStackIn.a((double)(this.posX * scale), (double)(this.posY * scale), (double)(this.posZ * scale));
        float rMinU = this.minU;
        float rMaxU = this.maxU;
        float rMinV = this.minV;
        float rMaxV = this.maxV;
        if (this.modelRenderer.g) {
            rMinU = this.maxU;
            rMaxU = this.minU;
        }
        if (this.modelRenderer.mirrorV) {
            rMinV = this.maxV;
            rMaxV = this.minV;
        }
        ModelSprite.renderItemIn2D(matrixStackIn, bufferIn, rMinU, rMinV, rMaxU, rMaxV, this.sizeX, this.sizeY, scale * (float)this.sizeZ, this.modelRenderer.i, this.modelRenderer.j, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrixStackIn.a((double)(-this.posX * scale), (double)(-this.posY * scale), (double)(-this.posZ * scale));
    }

    public static void renderItemIn2D(cyl matrixStackIn, cyo bufferIn, float minU, float minV, float maxU, float maxV, int sizeX, int sizeY, float width, float texWidth, float texHeight, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        float var13;
        float var12;
        float var11;
        int var10;
        if (width < 6.25E-4f) {
            width = 6.25E-4f;
        }
        float dU = maxU - minU;
        float dV = maxV - minV;
        float dimX = abr.e((float)dU) * (texWidth / 16.0f);
        float dimY = abr.e((float)dV) * (texHeight / 16.0f);
        float normX = 0.0f;
        float normY = 0.0f;
        float normZ = -1.0f;
        ModelSprite.addVertex(matrixStackIn, bufferIn, 0.0f, dimY, 0.0f, red, green, blue, alpha, minU, maxV, packedOverlayIn, packedLightIn, normX, normY, normZ);
        ModelSprite.addVertex(matrixStackIn, bufferIn, dimX, dimY, 0.0f, red, green, blue, alpha, maxU, maxV, packedOverlayIn, packedLightIn, normX, normY, normZ);
        ModelSprite.addVertex(matrixStackIn, bufferIn, dimX, 0.0f, 0.0f, red, green, blue, alpha, maxU, minV, packedOverlayIn, packedLightIn, normX, normY, normZ);
        ModelSprite.addVertex(matrixStackIn, bufferIn, 0.0f, 0.0f, 0.0f, red, green, blue, alpha, minU, minV, packedOverlayIn, packedLightIn, normX, normY, normZ);
        normX = 0.0f;
        normY = 0.0f;
        normZ = 1.0f;
        ModelSprite.addVertex(matrixStackIn, bufferIn, 0.0f, 0.0f, width, red, green, blue, alpha, minU, minV, packedOverlayIn, packedLightIn, normX, normY, normZ);
        ModelSprite.addVertex(matrixStackIn, bufferIn, dimX, 0.0f, width, red, green, blue, alpha, maxU, minV, packedOverlayIn, packedLightIn, normX, normY, normZ);
        ModelSprite.addVertex(matrixStackIn, bufferIn, dimX, dimY, width, red, green, blue, alpha, maxU, maxV, packedOverlayIn, packedLightIn, normX, normY, normZ);
        ModelSprite.addVertex(matrixStackIn, bufferIn, 0.0f, dimY, width, red, green, blue, alpha, minU, maxV, packedOverlayIn, packedLightIn, normX, normY, normZ);
        float var8 = 0.5f * dU / (float)sizeX;
        float var9 = 0.5f * dV / (float)sizeY;
        normX = -1.0f;
        normY = 0.0f;
        normZ = 0.0f;
        for (var10 = 0; var10 < sizeX; ++var10) {
            var11 = (float)var10 / (float)sizeX;
            var12 = minU + dU * var11 + var8;
            ModelSprite.addVertex(matrixStackIn, bufferIn, var11 * dimX, dimY, width, red, green, blue, alpha, var12, maxV, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, var11 * dimX, dimY, 0.0f, red, green, blue, alpha, var12, maxV, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, var11 * dimX, 0.0f, 0.0f, red, green, blue, alpha, var12, minV, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, var11 * dimX, 0.0f, width, red, green, blue, alpha, var12, minV, packedOverlayIn, packedLightIn, normX, normY, normZ);
        }
        normX = 1.0f;
        normY = 0.0f;
        normZ = 0.0f;
        for (var10 = 0; var10 < sizeX; ++var10) {
            var11 = (float)var10 / (float)sizeX;
            var12 = minU + dU * var11 + var8;
            var13 = var11 + 1.0f / (float)sizeX;
            ModelSprite.addVertex(matrixStackIn, bufferIn, var13 * dimX, 0.0f, width, red, green, blue, alpha, var12, minV, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, var13 * dimX, 0.0f, 0.0f, red, green, blue, alpha, var12, minV, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, var13 * dimX, dimY, 0.0f, red, green, blue, alpha, var12, maxV, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, var13 * dimX, dimY, width, red, green, blue, alpha, var12, maxV, packedOverlayIn, packedLightIn, normX, normY, normZ);
        }
        normX = 0.0f;
        normY = 1.0f;
        normZ = 0.0f;
        for (var10 = 0; var10 < sizeY; ++var10) {
            var11 = (float)var10 / (float)sizeY;
            var12 = minV + dV * var11 + var9;
            var13 = var11 + 1.0f / (float)sizeY;
            ModelSprite.addVertex(matrixStackIn, bufferIn, 0.0f, var13 * dimY, width, red, green, blue, alpha, minU, var12, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, dimX, var13 * dimY, width, red, green, blue, alpha, maxU, var12, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, dimX, var13 * dimY, 0.0f, red, green, blue, alpha, maxU, var12, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, 0.0f, var13 * dimY, 0.0f, red, green, blue, alpha, minU, var12, packedOverlayIn, packedLightIn, normX, normY, normZ);
        }
        normX = 0.0f;
        normY = -1.0f;
        normZ = 0.0f;
        for (var10 = 0; var10 < sizeY; ++var10) {
            var11 = (float)var10 / (float)sizeY;
            var12 = minV + dV * var11 + var9;
            ModelSprite.addVertex(matrixStackIn, bufferIn, dimX, var11 * dimY, width, red, green, blue, alpha, maxU, var12, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, 0.0f, var11 * dimY, width, red, green, blue, alpha, minU, var12, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, 0.0f, var11 * dimY, 0.0f, red, green, blue, alpha, minU, var12, packedOverlayIn, packedLightIn, normX, normY, normZ);
            ModelSprite.addVertex(matrixStackIn, bufferIn, dimX, var11 * dimY, 0.0f, red, green, blue, alpha, maxU, var12, packedOverlayIn, packedLightIn, normX, normY, normZ);
        }
    }

    static void addVertex(cyl matrixStackIn, cyo bufferIn, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int overlayUV, int lightmapUV, float normalX, float normalY, float normalZ) {
        cyl.a matrixEntry = matrixStackIn.c();
        b matrix4f = matrixEntry.a();
        a matrixNormal = matrixEntry.b();
        float xn = matrixNormal.getTransformX(normalX, normalY, normalZ);
        float yn = matrixNormal.getTransformY(normalX, normalY, normalZ);
        float zn = matrixNormal.getTransformZ(normalX, normalY, normalZ);
        float xt = matrix4f.getTransformX(x, y, z, 1.0f);
        float yt = matrix4f.getTransformY(x, y, z, 1.0f);
        float zt = matrix4f.getTransformZ(x, y, z, 1.0f);
        bufferIn.a(xt, yt, zt, red, green, blue, alpha, texU, texV, overlayUV, lightmapUV, xn, yn, zn);
    }
}

