/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.optifine.Config;
import net.optifine.CustomSkyLayer;
import net.optifine.render.Blender;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

public class CustomSky {
    private static CustomSkyLayer[][] worldSkyLayers = null;

    public static void reset() {
        worldSkyLayers = null;
    }

    public static void update() {
        CustomSky.reset();
        if (!Config.isCustomSky()) {
            return;
        }
        worldSkyLayers = CustomSky.readCustomSkies();
    }

    private static CustomSkyLayer[][] readCustomSkies() {
        CustomSkyLayer[][] wsls = new CustomSkyLayer[10][0];
        String prefix = "optifine/sky/world";
        int lastWorldId = -1;
        for (int w = 0; w < wsls.length; ++w) {
            String worldPrefix = prefix + w;
            ArrayList<CustomSkyLayer> listSkyLayers = new ArrayList<CustomSkyLayer>();
            for (int i2 = 0; i2 < 1000; ++i2) {
                String path = worldPrefix + "/sky" + i2 + ".properties";
                int countMissing = 0;
                try {
                    sm locPath = new sm(path);
                    InputStream in = Config.getResourceStream(locPath);
                    if (in == null && ++countMissing > 10) break;
                    PropertiesOrdered props = new PropertiesOrdered();
                    props.load(in);
                    in.close();
                    Config.dbg("CustomSky properties: " + path);
                    String defSource = i2 + ".png";
                    CustomSkyLayer sl = new CustomSkyLayer(props, defSource);
                    if (!sl.isValid(path)) continue;
                    String srcPath = StrUtils.addSuffixCheck(sl.source, ".png");
                    sm locSource = new sm(srcPath);
                    dzw tex = TextureUtils.getTexture(locSource);
                    if (tex == null) {
                        Config.log("CustomSky: Texture not found: " + locSource);
                        continue;
                    }
                    sl.textureId = tex.b();
                    listSkyLayers.add(sl);
                    in.close();
                    continue;
                }
                catch (FileNotFoundException e2) {
                    if (++countMissing <= 10) continue;
                    break;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            if (listSkyLayers.size() <= 0) continue;
            CustomSkyLayer[] sls = listSkyLayers.toArray(new CustomSkyLayer[listSkyLayers.size()]);
            wsls[w] = sls;
            lastWorldId = w;
        }
        if (lastWorldId < 0) {
            return null;
        }
        int worldCount = lastWorldId + 1;
        CustomSkyLayer[][] wslsTrim = new CustomSkyLayer[worldCount][0];
        for (int i3 = 0; i3 < wslsTrim.length; ++i3) {
            wslsTrim[i3] = wsls[i3];
        }
        return wslsTrim;
    }

    public static void renderSky(bjw world, eak re, cyl matrixStackIn, float partialTicks) {
        if (worldSkyLayers == null) {
            return;
        }
        int dimId = world.p.n().b();
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return;
        }
        long time = world.S();
        int timeOfDay = (int)(time % 24000L);
        float celestialAngle = world.f(partialTicks);
        float rainStrength = world.d(partialTicks);
        float thunderStrength = world.b(partialTicks);
        if (rainStrength > 0.0f) {
            thunderStrength /= rainStrength;
        }
        for (int i2 = 0; i2 < sls.length; ++i2) {
            CustomSkyLayer sl = sls[i2];
            if (!sl.isActive(world, timeOfDay)) continue;
            sl.render(world, matrixStackIn, timeOfDay, celestialAngle, rainStrength, thunderStrength);
        }
        float rainBrightness = 1.0f - rainStrength;
        Blender.clearBlend(rainBrightness);
    }

    public static boolean hasSkyLayers(bjw world) {
        if (worldSkyLayers == null) {
            return false;
        }
        int dimId = world.p.n().b();
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return false;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return false;
        }
        return sls.length > 0;
    }
}

