/*
 * Decompiled with CFR 0.152.
 */
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<jy, jy> textureLocations = null;
    private NbtTagValue nbtName = null;
    private ady[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private VillagerProfession[] professions = null;
    private EnumVariant[] variants = null;
    private zd[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final zd[] COLORS_INVALID = new zd[0];
    private static final jy ANVIL_GUI_TEXTURE = new jy("textures/gui/container/anvil.png");
    private static final jy BEACON_GUI_TEXTURE = new jy("textures/gui/container/beacon.png");
    private static final jy BREWING_STAND_GUI_TEXTURE = new jy("textures/gui/container/brewing_stand.png");
    private static final jy CHEST_GUI_TEXTURE = new jy("textures/gui/container/generic_54.png");
    private static final jy CRAFTING_TABLE_GUI_TEXTURE = new jy("textures/gui/container/crafting_table.png");
    private static final jy HORSE_GUI_TEXTURE = new jy("textures/gui/container/horse.png");
    private static final jy DISPENSER_GUI_TEXTURE = new jy("textures/gui/container/dispenser.png");
    private static final jy ENCHANTMENT_TABLE_GUI_TEXTURE = new jy("textures/gui/container/enchanting_table.png");
    private static final jy FURNACE_GUI_TEXTURE = new jy("textures/gui/container/furnace.png");
    private static final jy HOPPER_GUI_TEXTURE = new jy("textures/gui/container/hopper.png");
    private static final jy INVENTORY_GUI_TEXTURE = new jy("textures/gui/container/inventory.png");
    private static final jy SHULKER_BOX_GUI_TEXTURE = new jy("textures/gui/container/shulker_box.png");
    private static final jy VILLAGER_GUI_TEXTURE = new jy("textures/gui/container/villager.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations(props, "texture", this.container, "textures/gui/", this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListInt(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        Enum[] vars = CustomGuiProperties.getContainerVariants(this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), vars, "variants", VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors(props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static zd[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize(str, " ");
        zd[] cols = new zd[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            zd col = CustomGuiProperties.parseEnumDyeColor(token);
            if (col == null) {
                CustomGuiProperties.warn("Invalid color: " + token);
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static zd parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        zd[] colors = zd.values();
        for (int i = 0; i < colors.length; ++i) {
            zd enumDyeColor = colors[i];
            if (enumDyeColor.l().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.d().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static jy parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        String tex = TextureUtils.fixResourcePath(str = str.trim(), basePath);
        if (!tex.endsWith(".png")) {
            tex = tex + ".png";
        }
        return new jy(basePath + "/" + tex);
    }

    private static Map<jy, jy> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<jy, jy> map = new HashMap<jy, jy>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            jy locKey = CustomGuiProperties.getGuiTextureLocation(container);
            jy locVal = CustomGuiProperties.parseTextureLocation(propVal, basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix(pathRel, "/", ".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            jy locKey = new jy(path);
            jy locVal = CustomGuiProperties.parseTextureLocation(val, basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static jy getGuiTextureLocation(EnumContainer container) {
        switch (container) {
            case ANVIL: {
                return ANVIL_GUI_TEXTURE;
            }
            case BEACON: {
                return BEACON_GUI_TEXTURE;
            }
            case BREWING_STAND: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case CHEST: {
                return CHEST_GUI_TEXTURE;
            }
            case CRAFTING: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case CREATIVE: {
                return null;
            }
            case DISPENSER: {
                return DISPENSER_GUI_TEXTURE;
            }
            case ENCHANTMENT: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case FURNACE: {
                return FURNACE_GUI_TEXTURE;
            }
            case HOPPER: {
                return HOPPER_GUI_TEXTURE;
            }
            case HORSE: {
                return HORSE_GUI_TEXTURE;
            }
            case INVENTORY: {
                return INVENTORY_GUI_TEXTURE;
            }
            case SHULKER_BOX: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case VILLAGER: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn("No base path found: " + path);
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn("No container found: " + path);
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn("No texture found: " + path);
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn("Invalid professions or careers: " + path);
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn("Invalid variants: " + path);
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn("Invalid colors: " + path);
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }

    private boolean matchesGeneral(EnumContainer ec, cj pos, adq blockAccess) {
        ady biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome(biome = blockAccess.b(pos), this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.o());
    }

    public boolean matchesPos(EnumContainer ec, cj pos, adq blockAccess, axu screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName(screen))) {
            return false;
        }
        switch (ec) {
            case BEACON: {
                return this.matchesBeacon(pos, blockAccess);
            }
            case CHEST: {
                return this.matchesChest(pos, blockAccess);
            }
            case DISPENSER: {
                return this.matchesDispenser(pos, blockAccess);
            }
        }
        return true;
    }

    public static String getName(axu screen) {
        op nameable = CustomGuiProperties.getWorldNameable(screen);
        if (nameable == null) {
            return null;
        }
        return nameable.f_().c();
    }

    private static op getWorldNameable(axu screen) {
        if (screen instanceof ayn) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiBeacon_tileBeacon);
        }
        if (screen instanceof ayp) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiBrewingStand_tileBrewingStand);
        }
        if (screen instanceof ayr) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiChest_lowerChestInventory);
        }
        if (screen instanceof ayv) {
            return ((ayv)screen).u;
        }
        if (screen instanceof ayy) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiEnchantment_nameable);
        }
        if (screen instanceof ayz) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiFurnace_tileFurnace);
        }
        if (screen instanceof aza) {
            return CustomGuiProperties.getWorldNameable(screen, Reflector.GuiHopper_hopperInventory);
        }
        return null;
    }

    private static op getWorldNameable(axu screen, ReflectorField fieldInventory) {
        Object obj = Reflector.getFieldValue(screen, fieldInventory);
        if (!(obj instanceof op)) {
            return null;
        }
        return (op)obj;
    }

    private boolean matchesBeacon(cj pos, adq blockAccess) {
        akw te = blockAccess.s(pos);
        if (!(te instanceof akv)) {
            return false;
        }
        akv teb = (akv)te;
        if (this.levels != null) {
            dn nbt = new dn();
            teb.b(nbt);
            int l = nbt.f("Levels");
            if (!this.levels.isInRange(l)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesChest(cj pos, adq blockAccess) {
        akw te = blockAccess.s(pos);
        if (te instanceof aky) {
            aky tec = (aky)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof alf) {
            alf teec = (alf)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(aky tec, cj pos, adq blockAccess) {
        boolean isLarge = tec.h != null || tec.g != null || tec.f != null || tec.i != null;
        boolean isTrapped = tec.n() == 1;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(alf teec, cj pos, adq blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(cj pos, adq blockAccess) {
        EnumVariant var;
        akw te = blockAccess.s(pos);
        if (!(te instanceof alc)) {
            return false;
        }
        alc ted = (alc)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(alc ted) {
        if (ted instanceof ald) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    public boolean matchesEntity(EnumContainer ec, pk entity, adq blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.c(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.e_())) {
            return false;
        }
        switch (ec) {
            case VILLAGER: {
                return this.matchesVillager(entity, blockAccess);
            }
            case HORSE: {
                return this.matchesHorse(entity, blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(pk entity, adq blockAccess) {
        if (!(entity instanceof wi)) {
            return false;
        }
        wi entityVillager = (wi)entity;
        if (this.professions != null) {
            int profInt = entityVillager.cl();
            int careerInt = Reflector.getFieldValueInt(entityVillager, Reflector.EntityVillager_careerId, -1);
            if (careerInt < 0) {
                return false;
            }
            boolean matchProfession = false;
            for (int i = 0; i < this.professions.length; ++i) {
                VillagerProfession prof = this.professions[i];
                if (!prof.matches(profInt, careerInt)) continue;
                matchProfession = true;
                break;
            }
            if (!matchProfession) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesHorse(pk entity, adq blockAccess) {
        EnumVariant var;
        if (!(entity instanceof tp)) {
            return false;
        }
        tp ah = (tp)entity;
        return this.variants == null || Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants);
    }

    private EnumVariant getHorseVariant(tp entity) {
        int type = entity.cl();
        switch (type) {
            case 0: {
                return EnumVariant.HORSE;
            }
            case 1: {
                return EnumVariant.DONKEY;
            }
            case 2: {
                return EnumVariant.MULE;
            }
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public jy getTextureLocation(jy loc) {
        jy locNew = this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + (Object)((Object)this.container) + ", textures: " + this.textureLocations;
    }

    private static enum EnumVariant {
        HORSE,
        DONKEY,
        MULE,
        LLAMA,
        DISPENSER,
        DROPPER;

    }

    public static enum EnumContainer {
        ANVIL,
        BEACON,
        BREWING_STAND,
        CHEST,
        CRAFTING,
        DISPENSER,
        ENCHANTMENT,
        FURNACE,
        HOPPER,
        HORSE,
        VILLAGER,
        SHULKER_BOX,
        CREATIVE,
        INVENTORY;

        public static final EnumContainer[] VALUES;

        static {
            VALUES = EnumContainer.values();
        }
    }
}

