---------------------------------------
----- Basic Japanese descriptions -----
---------------------------------------
-- Last Update: 2025-09-16

-- FORMAT: Item ID | Name | Description
-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "ja_jp"

---------- Collectibles ----------

local repCollectibles={
    [2] = {"2", "心眼", "トリプルショットの涙#↓ 連射速度 -49%"},
    [5] = {"5", "リフレクション", "涙にブーメラン軌道を付与#↑ 攻撃力 +1.5#↑ 射程　 +1.5#↑ 射程　 +100%#↑ 弾速　 +60%#↓ 運　　 -1"}, -- My Reflection
    [6] = {"6", "ナンバー ワン", "↑ 連射速度 +1.5#↓ 射程　　 -1.5#↓ 射程　　 -20%"}, -- Number One
    [12] = {"12", "魔法のキノコ", "体力全回復#↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 攻撃力　 +50%#↑ 射程　　 +2.5#↑ 移動速度 +0.3#アイザックのサイズ拡大"}, -- Magic Mushroom
    [13] = {"13", "ウイルス", "接触した敵に毒を与える#↑ 移動速度 +0.2"}, -- The Virus
    [14] = {"14", "ロイド レイジ", "↑ 移動速度 +0.3#↑ 射程　　 +2.5"}, -- Roid Rage
    [18] = {"18", "１ドル", "コイン +100"}, -- A Dollar
    [22] = {"22", "昼ごはん", "↑ 最大体力 +1#体力を1回復"}, -- Lunch
    [23] = {"23", "晩ごはん", "↑ 最大体力 +1#体力を1回復"}, -- Dinner
    [24] = {"24", "デザート", "↑ 最大体力 +1#体力を1回復"}, -- Dessert
    [25] = {"25", "朝ごはん", "↑ 最大体力 +1#体力を1回復"}, -- Breakfast
    [26] = {"26", "腐った肉", "↑ 最大体力 +1#体力を1回復"}, -- Rotten Meat
    [29] = {"29", "ママの下着", "↑ 射程 +2.5#取得時、3～6匹の 青ハエがスポーン"}, -- Mom's Underwear
    [30] = {"30", "ママのヒール", "↑ 射程 +2.5#アイザックと接触した敵に 毎秒24ダメージを与える"}, -- Mom's Heels
    [31] = {"31", "ママの口紅", "↑ 射程 +3.75#取得時、ランダムな ハートを1個スポーン"}, -- Mom's Lipstick
    [37] = {"37", "Mr.ドカーン", "大型の爆弾を設置する#爆発は185ダメージを与える"}, -- Mr. Boom
    [40] = {"40", "カミカゼ！", "自爆攻撃#爆発は185ダメージを与える"}, -- Kamikaze!
    [41] = {"41", "ママのナプキン", "部屋の全ての敵を5秒間 恐怖状態にする#青ハエを1匹スポーン"}, -- Mom's Pad
    [42] = {"42", "ボブの腐った頭", "手投げ式の毒爆弾#爆発は攻撃力+185の ダメージと毒を与える#着弾地点に毒雲を生成"}, -- Bob's Rotten Head
    [45] = {"45", "ヤム ハート", "赤ハートを1回復"}, -- Yum Heart
    [46] = {"46", "幸せの足", "↑ 運 +1#ギャンブルの勝率アップ#部屋クリア時の報酬 スポーン確率アップ#悪性のピルを良性に変換"}, -- Lucky Foot
    [52] = {"52", "Dr. フィータス", "涙が爆弾に置き換わる#爆弾は攻撃力ｘ10の ダメージを与える#ダメージが60を超える場合、 代わりに、攻撃力ｘ5+30の ダメージを与える#↓ 連射速度 -60%"}, --Dr. Fetus
    [53] = {"53", "マグネット", "ピックアップが障害物を 飛び越えてアイザックに 引き寄せられるようになる#付近の宝箱が自動的に開く （トゲ付きを無傷で開ける）"}, -- Magneto
    [55] = {"55", "ママの目", "一定確率で涙が後ろにも 発射されるようになる#確率：運0=50%、5=100%"}, -- Mom's Eye
    [59] = {"59", "ベリアルの本", "↑ 攻撃力 +2#↑ 悪魔部屋／天使部屋の 出現率 +12.5%#{{Collectible7}} 殉教者の血を所有時、 攻撃力が追加で50%増"}, -- The Book of Belial (Judas's Birthright Version)
    [62] = {"62", "ヴァンパイア チャーム", "↑ 攻撃力 +0.3#敵を13体倒すたび、 半赤ハート回復する"}, -- Charm of the Vampire
    [64] = {"64", "スチームセール", "お店の商品が半額になる#複数取得でさらに割引"}, -- Steam Sale
    [67] = {"67", "マギーちゃん", "6ダメージのノーマルな 涙で攻撃する使い魔"}, -- Sister Maggy
    [69] = {"69", "チョコレートミルク", "涙がチャージ式になり、 チャージ量に応じて 10～400%のダメージを 与える"}, --Chocolate Milk
    [70] = {"70", "成長ホルモン", "↑ 攻撃力　 +1#↑ 移動速度 +0.2"}, -- Growth Hormones
    [71] = {"71", "ミニ マッシュ", "↑ 移動速度 +0.3#↑ 射程　　 +2.5#↑ アイザックのサイズ縮小"}, -- Mini Mush
    [72] = {"72", "ロザリー", "青ハート +3#↑ 連射速度 +0.5#{{Collectible33}} 聖書が全てのアイテム プールに追加される"}, -- Rosary
    [78] = {"78", "ヨハネの黙示録", "青ハートを1個付与する#使用すると、現フロアの ボスがハービンガーに 置き換えられる#↑ 保持中、悪魔部屋／天使 部屋の出現率 +17.5%"}, -- Book of Revelations
    [79] = {"79", "紋章", "↑ 攻撃力　 +1#↑ 移動速度 +0.2#黒ハート +1"}, -- The Mark
    [80] = {"80", "契約", "↑ 攻撃力　 +0.5#↑ 連射速度 +0.7#黒ハート +2"}, -- The Pact
    [83] = {"83", "釘", "半黒ハートを付与する#その部屋に居る間：#↑ 攻撃力　 +2#↓ 移動速度 -0.18#毎秒40の接触ダメージ 効果を得る#障害物を破壊できる"}, -- The Nail
    [84] = {"84", "もっと深く！", "次のフロアにつながる トラップドアを生成#装飾のある床の上で 使用するとクロール スペースを生成する （草やゴミがある床）"}, -- We Need To Go Deeper!
    [87] = {"87", "ロキのツノ", "一定確率で涙が四方向に 発射されるようになる#確率：運0=25%、15=100%"}, -- Loki's Horns
    [91] = {"91", "スペランカーの帽子", "マップが二部屋先まで 詳しく表示される#隠し部屋の位置も表示#頭上に落下してくる 弾をブロックする"}, -- Spelunker Hat
    [98] = {"98", "遺物", "7～8部屋クリアするたび 1個の青ハートをスポーン する使い魔"}, -- The Relic
    [101] = {"101", "ヘイロー", "↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 連射速度 +0.2#↑ 射程　　 +1.5#↑ 移動速度 +0.3#体力を1回復"}, -- The Halo
    [106] = {"106", "ミスターメガ", "↑ 爆弾ダメージｘ1.85#↑ 爆発範囲#爆弾 +5"}, -- Mr. Mega
    [107] = {"107", "ピンキング シアー", "頭と体を分離し、浮遊状態 になった頭部を操作する#体が敵を自動的に追いかけ、 毎秒23.5の接触ダメージを 与える"}, -- The Pinking Shears
    [110] = {"110", "ママのコンタクト", "20%の確率で涙に 石化効果を付与する#↑ 射程 +1.5"}, -- Mom's Contacts
    [111] = {"111", "まめ", "おならをし、近くの敵に 5ダメージと毒を与える#おならは敵の弾を跳ね返す"}, -- The Bean
    [112] = {"112", "ガーディアン エンジェル", "天使がアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#毎秒52.5の接触ダメージ#周回タイプの使い魔の 回転速度が上がる"}, -- Guardian Angel
    [114] = {"114", "ママの包丁", "涙がナイフに置き換わる#保持中のナイフは2倍の ダメージを与える#チャージ攻撃でナイフを 発射でき、チャージ量に 応じて射程とダメージが 変化する#約1/3のチャージで最大 6倍のダメージ"}, -- Mom's Knife
    [115] = {"115", "ウィジャボード", "涙に透過効果を付与#↑ 連射速度 +0.5"}, -- Ouija Board
    [118] = {"118", "ブリムストーン", "涙がチャージ式のレーザー ビームに置き換わる#↓ 連射速度 -67%"}, -- Brimstone
    [121] = {"121", "変なきのこ", "↑ 最大体力 +1#↑ 攻撃力　 +1#↑ 射程　　 +1.5#↓ 移動速度 -0.2"}, -- Odd Mushroom (Large)
    [123] = {"123", "モンスター マニュアル", "次のフロアまで持続する ランダムな使い魔を1体 付与する"}, -- Monster Manual
    [126] = {"126", "レイザー ブレード", "ハート1個のダメージを 受け、その部屋に居る間、 攻撃力を1.2増やす#赤ハートを優先して消費#同じ部屋で二回以上使用 する場合、ダメージ量を 半ハートに軽減する"}, -- Razor Blade
    [129] = {"129", "一杯の背アブラ", "↑ 最大体力 +2#↓ 移動速度 -0.2"}, -- Bucket of Lard
    [130] = {"130", "ポニー", "保持中、飛行能力を付与し、 1.5以下の移動速度を 1.5に修正する#使用すると進行方向に 無敵状態で突進し、 敵に攻撃力ｘ4+28の ダメージを与える"}, -- A Pony
    [138] = {"138", "聖痕", "↑ 最大体力 +1#↑ 攻撃力　 +0.3#体力を1回復"}, -- Stigmata
    [139] = {"139", "ママのカバン", "トリンケットを2個まで 保持可能になる#取得時、トリンケットを ランダムに1個スポーン"}, -- Mom's Purse
    [140] = {"140", "ボブの呪い", "爆弾に毒効果を付与する#爆弾 +5#爆破地点に毒雲が生成 されるようになる#アイザックに毒耐性を付与"}, -- Bob's Curse
    [142] = {"142", "スカプラリオ", "残り体力が半ハートに なった時、青ハートを 1個付与する#効果は1部屋で1回のみ 有効だが、部屋に入り 直すと再度有効化する#!!! 献血では機能しない"}, --Scapular
    [147] = {"147", "大斧", "障害物やドアの破壊、 敵への攻撃が可能な斧#64回分のチャージがあり、 破壊時に1チャージ、 攻撃時に2チャージ消費#使用／非使用は切替可能#フロア移動時にチャージ 全回復"}, -- Notched Axe
    [148] = {"148", "感染者", "ダメージを受けるたび、 青ハエが2～6匹スポーン"}, -- Infestation
    [149] = {"149", "吐き気薬", "涙が毒爆弾に置き換わる#↑ 攻撃力　 +40#↓ 弾速　　 x0.8#↓ 連射速度 -67%#↓ 射程　　 -20%"}, -- Ipecac
    [152] = {"152", "テクノロジー２", "右目の涙が連続照射の 貫通レーザーに置き換わる#レーザーは攻撃力ｘ0.13の ダメージを与える#↓ 連射速度 -33%"}, -- Technology 2
    [153] = {"153", "ミュータント スパイダー", "クアッドショットの涙#↓ 連射速度 -58%"}, -- Mutant Spider
    [155] = {"155", "ノゾキ魔", "目玉が部屋を飛び回り、 敵の弾をブロックし、 接触した敵に毎秒17の ダメージを与える#↑ 左目の攻撃力 +35%"}, -- The Peeper
    [158] = {"158", "水晶", "フルマッピング効果#青ハートまたはカード・ ルーンのいずれか1個を スポーンする#↑ 保持中、プラネタリウムの 出現率が15%アップ#以前にトレジャールームを スキップしていた場合、 出現率が100%アップ"}, -- Crystal Ball
    [169] = {"169", "ポリフェムス", "↑ (攻撃力 + 4)ｘ2#↓ 連射速度 -58%#敵を倒した涙は減衰して 貫通する"},
    [171] = {"171", "スパイダー バット", "部屋の全ての敵に 10ダメージを与え、 4秒間スロー状態にする#この効果で倒された敵は 青クモをスポーンする"}, -- Spider Butt
    [172] = {"172", "イケニエの短刀", "短剣がアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#毎秒112.5の接触ダメージ"}, -- Sacrificial Dagger
    [173] = {"173", "司教の冠", "赤ハートが33%の確率で 青ハートに置き換わって スポーンする"}, -- Mitre
    [176] = {"176", "幹細胞", "↑ 最大体力 +1#↑ 弾速　　 +0.16#体力を1回復"}, -- Stem Cells
    [178] = {"178", "聖水", "涙の発射方向に連動して 聖水ビンが発射される#敵に衝突するとビンが 割れ、7ダメージを与える#衝突地点に聖水を残し、 触れた敵を石化させる"}, -- Holy Water
    [180] = {"180", "黒豆", "ダメージを受けると 数回おならを放ち、 敵にダメージと毒を 与える　　　　#おならがその場に残り、 触れた敵に毒を与える"}, -- The Black Bean
    [181] = {"181", "ホワイトポニー", "保持中、飛行能力を付与し、 1.5以下の移動速度を 1.5に修正する#使用すると進行方向に 無敵状態で突進し、 敵に攻撃力の4倍+28の ダメージを与える#突進時に光線が降り注ぎ、 敵に攻撃力の4倍+10の ダメージを与える"}, -- White Pony
    [182] = {"182", "聖なる心臓", "体力全回復#↑ 最大体力 +1#↑ 攻撃力　 +230%#↑ 攻撃力　 +1#↓ 連射速度 -0.4#↓ 弾速　　 -0.25#涙にホーミング効果を付与"}, -- Sacred Heart
    [184] = {"184", "聖杯", "飛行能力を付与#↑ 最大体力 +1#体力を1回復"}, -- Holy Grail
    [186] = {"186", "血印", "ハート 1個のダメージを 受け、部屋の全ての敵に 40のダメージを与える#赤ハートを優先して消費#同じ部屋で二回以上使用 する場合、ダメージ量を 半ハートに軽減する"}, -- Blood Rights
    [188] = {"188", "アベル", "アイザックと鏡映しに 移動・攻撃する使い魔#3.5ダメージのノーマルな 涙で攻撃する#カイン使用時は7.5ダメージ"}, -- Abel
    [189] = {"189", "SMB熱狂的ファン", "体力全回復#↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 連射速度 +0.2#↑ 射程　　 +2.5#↑ 移動速度 +0.2"}, -- SMB Super Fan
    [191] = {"191", "３ドル札", "2～3秒ごとにランダムな 特殊効果を涙に付与#以下の効果がまれに発生：#{{Collectible46}} 幸せの足#{{Collectible53}} マグネット"}, -- 3 Dollar Bill
    [192] = {"192", "初心者向けテレパシー", "涙にホーミング効果を付与#↑ 射程 +3#その部屋でのみ有効"}, -- Telepathy for Dummies
    [193] = {"193", "肉っ！", "↑ 最大体力 +1#↑ 攻撃力　 +0.3#体力を1回復"}, -- MEAT!
    [194] = {"194", "魔法の８ボール", "↑ 弾速 +0.16#取得時、ランダムな カードを1枚スポーン#↑ {{Planetarium}}プラネタリウムの 出現率が15%アップ"}, -- Magic 8 Ball
    [197] = {"197", "ジーザス ジュース", "↑ 攻撃力 +0.5#↑ 射程　 +1.5"}, -- Jesus Juice
    [203] = {"203", "ハンブリングバンドル", "ハート・コイン・爆弾・ 鍵を50%の確率でダブル バージョンに変換する"}, -- Humbleing Bundle
    [205] = {"205", "シャーププラグ", "ダメージをコストにし、 アクティブアイテムを フルチャージできる#1チャージ = 半ハート#赤ハートから優先消費"}, -- Sharp Plug
    [206] = {"206", "ギロチン", "↑ 攻撃力　 +1#↑ 連射速度 +0.5 ※上限を突破できる#アイザックの頭部が切り 離され、胴体を周回する#頭部はダメージを受けず、 弾をブロックできる#頭部は接触した敵に毎秒 56ダメージを与える"}, -- Guillotine
    [211] = {"211", "スパイダーベイビー", "ダメージを受けるたび 3～5匹の青クモがスポーン"}, -- Spiderbaby
    [214] = {"214", "貧血気味", "↑ 射程 +1.5#ダメージを受けると、 その部屋に居る間、 敵にダメージを与える 血液が床に流れ続ける"}, -- Anemic
    [218] = {"218", "胎盤", "↑ 最大体力 +1#体力を1回復#1分間に1回、50%の確率で 半赤ハート回復する"}, -- Placenta
    [219] = {"219", "古い絆創膏", "↑ 最大体力 +1#ダメージを受けた時、 一定確率で赤ハートが スポーンする#確率：運0=20%、80=100%"},
    [222] = {"222", "アンチグラビティ", "攻撃ボタンが押されて いる間、発射した涙が その場で静止を続ける#時間の経過または攻撃の 停止で、元の方向に涙が 発射される#↑ 連射速度 +1 ※上限を突破できる"}, -- Anti-Gravity
    [223] = {"223", "放火魔", "爆発と炎への耐性を付与#爆風で半赤ハート回復#爆弾 +5"}, -- Pyromaniac
    [224] = {"224", "クリケットの体", "衝突した涙が四つに分裂する#分裂した涙はダメージ量が 半減する#↑ 連射速度 +0.5 ※上限を突破できる#↓ 射程　　 -20%"}, -- Cricket's Body
    [225] = {"225", "ギンピー", "ダメージを受けた時、 一定確率で青ハートが スポーンする#確率：運0=8%、46=100%#死んだ敵が1～10%の確率で 半赤ハートを落とす （HPが高い敵ほど高確率）"},
    [226] = {"226", "ブラックロータス", "↑ 最大体力 +1#青ハート +1#黒ハート +1#体力を1回復"}, -- Black Lotus
    [228] = {"228", "ママの香水", "一定確率で涙に 恐怖効果を付与#確率：運0=15%、85=100%#↑ 連射速度 +0.5 ※上限を突破できる"}, -- Mom's Perfume
    [229] = {"229", "モンストロの肺", "涙をチャージ式に置き換え、 一度に14発の涙を同時発射 できるようになる#↓ 連射速度 -77%"}, --Monstro's Lung
    [230] = {"230", "アバドン", "↑ 攻撃力　 +1.5#↑ 移動速度 +0.2#一定確率で涙に 恐怖効果を付与#確率：運0=15%、85=100%#赤ハートを同数の 黒ハートに置き換える#黒ハート +2"}, -- Abaddon
    [232] = {"232", "ストップウォッチ", "全ての敵の移動速度と 攻撃速度が20%ダウン#↑ 移動速度 +0.3"}, -- Stop Watch
    [233] = {"233", "ちっちゃな惑星", "涙がアイザックを周回 して飛ぶようになる#↑ 射程 +6.5#涙に透過効果を付与"}, -- Tiny Planet
    [245] = {"245", "視力２０／２０", "ダブルショットの涙#↓ 攻撃力 -20%"}, -- 20/20
    [248] = {"248", "虫の知らせ", "青ハエ／クモの与える ダメージが2倍になる#ハエ／クモタイプの 使い魔が与える ダメージが2倍になる"}, -- Hive Mind
    [253] = {"253", "魔法のかさぶた", "↑ 最大体力 +1#↑ 運　　　 +1#体力を1回復"}, -- Magic Scab
    [254] = {"254", "血づまり", "左目のみに適用：#↑ 攻撃力 +1#↑ 射程　 +2.5"}, -- Blood Clot
    [256] = {"256", "あつあつボム", "爆弾が炎をまとい、敵に 接触ダメージを与える#爆発地点に炎が残り、 敵にダメージを与える#アイザックが炎から ダメージを受けなくなる#爆弾 +5"}, -- Hot Bombs
    [261] = {"261", "プロップトーシス", "↑ 攻撃力 +0.5#涙のサイズとダメージが 滞空時間と共に減少する#発射直後の涙は3倍の ダメージを与える"}, -- Proptosis
    [262] = {"262", "失われたページ２", "黒ハート +1#ダメージを受け、残りの  体力がハート1個以下に  なった時、部屋の全ての 敵に80ダメージを与える#ネクロノミコン効果による ダメージを40増やす"}, -- Missing Page 2
    [263] = {"263", "クリア ルーン", "保持中のルーン・ソウル ストーンの効果をコピー して発動する#取得時、ランダムな ルーンを1個スポーン"}, -- Clear Rune   (REPENTANCE ITEM)
    [264] = {"264", "スマートフライ", "黄色いハエがアイザックを 周回し、敵に接触ダメージ を与え、弾をブロックする#ダメージを受けると アイザックから離れ、 敵を追いかけ攻撃する#毎秒6.5の接触ダメージ"}, -- Smart Fly
    [269] = {"269", "頭なしベイビー", "床に血を流しながら アイザックを追従する 使い魔#血は触れた敵に毎秒 20ダメージを与える"}, -- Headless Baby
    [272] = {"272", "BBF", "部屋を飛び回り、敵との 接触時に爆発する使い魔#接触で10、爆発で100の ダメージを与える"},
    [273] = {"273", "ボブの脳みそ", "涙の発射方向に連動して 飛び出し、敵との衝突で 爆発する使い魔#爆発は100のダメージと 毒を与える#爆発ダメージは敵の アーマーを無視する"}, -- Bob's Brain
    [274] = {"274", "ベストバディー", "ダメージを受けると白い ハエが現れ、その部屋に 居る間、アイザックを 周回する#白いハエは毎秒150の 接触ダメージを与える"}, -- Best Bud
    [275] = {"275", "小さなブリムストーン", "ブリムストーンで攻撃する 使い魔　　#ビームは完全にヒットした 場合、合計24のダメージを 与える"}, -- Lil Brimstone
    [276] = {"276", "アイザックの心臓", "アイザックに追従する 心臓が現れ、ダメージ 判定が心臓側に移行する#心臓はチャージ式の攻撃 能力を持ち、涙の発射や ノックバックができる#アイザックに接触ダメージ 効果を付与する"}, -- Isaac's Heart
    [278] = {"278", "ダークバム", "赤ハートを拾い集める 乞食の使い魔#1.5個拾うたび、カード・ ピル・ルーン・青クモ・ 敵クモ・黒ハートの いずれかをスポーン"}, -- Dark Bum
    [280] = {"280", "あしなが雑魚", "バトル中、最大5匹まで 青クモをスポーンする 使い魔#接触した敵をチャーム 状態にする"}, -- Sissy Longlegs
    [283] = {"283", "D100", "ステータス、部屋の全ての アイテム、ピックアップ、 宝箱、取得済みのパッシブ アイテムをリロールする#ピックアップをランダムに 1個複製する#その部屋で倒した敵を リスポーンし、その後 別の敵にリロールする#障害物をリロールする"}, -- D100
    [285] = {"285", "D10", "部屋の全ての敵を、一段階 弱い別の敵にリロールする"}, -- D10
    [286] = {"286", "白紙のカード", "保持中のカードの効果を コピーして発動する"}, -- Blank Card
    [287] = {"287", "秘儀の書", "{{Collectible54}} 宝の地図#{{Collectible21}} コンパス#{{Collectible246}} ブルーマップ いずれかの効果を 現フロアに付与する#まだ有効化されていない 効果のみ付与される#全て有効化されている 場合、{{Collectible76}} X線ビジョン 効果を現フロアに付与する#現在の部屋にあるｘ岩と クロールスペース付きの 岩が点滅する"}, -- Book of Secrets
    [288] = {"288", "スパイダーボックス", "4～8匹の青クモをスポーン"}, -- Box of Spiders
    [289] = {"289", "赤いロウソク", "ロウソクから赤い炎を放つ#炎が敵にダメージを与え、 弾をブロックする#接触とブロックで炎は 縮み、4回ヒットで消滅#10秒の経過でも消滅"}, -- Red Candle
    [291] = {"291", "ジャー", "全ての雑魚敵がうんちに変化#うんちタイプのボスが即死#炎を消火する#溶岩を岩に変え、歩行可能に"}, -- Flush!
    [292] = {"292", "邪悪な聖書", "黒ハートを1個付与#ボス戦前に使用した場合、 ボスアイテムが悪魔取引の  アイテムに置き換えられる#この効果で取引した場合、 天使部屋の出現率がゼロに なる　　　"}, -- Satanic Bible
	[293] = {"293", "クランプスの頭", "ブリムストーンビームを 十字方向に放つ#各ビームは最大200の ダメージを与える"}, -- Head of Krampus
    [294] = {"294", "バタービーンズ", "おならで近くの敵と弾を ノックバックさせる#この効果で壁や障害物に 衝突した敵はダメージを 受ける　"}, -- Butter Bean
    [295] = {"295", "マジックフィンガー", "1コイン消費し、部屋の 全ての敵に攻撃力ｘ2+10の ダメージを与える"}, -- Magic Fingers
    [296] = {"296", "コンバーター", "青／黒ハートを1個消費し、 最大体力を1個増やす"}, -- Converter
	--NOTE FOR LOCALIZERS: There is code to highlight the text of your current floor
	--For it to work, only use line breaks or semicolons to separate floor details, and use the same order as English
    [297] = {"297", "パンドラの箱", "使用フロアで効果が変化：#B1:青ハート 2個#B2:爆弾と鍵 各2個#C1:ボスアイテム 1個#C2:B1+C1#D1:青ハート 4個#D2:コイン 20枚#W1:ボスアイテム 2個#W2:{{Collectible33}} 聖書#???/Void:なし#Sheol:悪魔部屋アイテム1個 　　　黒ハート 1個#Cat:天使部屋アイテム 1個 　　白ハート 1個#DarkRoom:{{Collectible523}}お引越し用の箱をアンロック#Chest:コイン 1枚#Home:{{Collectible580}}レッドキー"}, -- Pandora's Box
    [300] = {"300", "おひつじ座", "↑ 移動速度 +0.25#素早く敵に衝突すると、 敵に25のダメージを与える#この時、アイザックは ダメージを受けない"}, -- Aries
    [307] = {"307", "やぎ座", "↑ 最大体力 +1#↑ 攻撃力　 +0.5#↑ 移動速度 +0.1#↑ 射程　　 +0.75#↑ 連射速度 +0.5#コイン・爆弾・鍵 +1"}, -- Capricorn
    [308] = {"308", "みずがめ座", "アイザックの体から青い  液体が流れ続け、触れた  敵にダメージを与える#液体は攻撃力ｘ0.66の ダメージを与え、涙の 特殊効果を引き継ぐ"}, -- Aquarius
    [309] = {"309", "うお座", "↑ 連射速度 +0.5 ※上限を突破できる#↑ ノックバック強化#↑ 涙サイズ +125%"},
    [310] = {"310", "イブのマスカラ", "↑ 攻撃力　 +100%#↓ 連射速度 -33%#↓ 弾速　　 -0.5"},
    [314] = {"314", "ムッチムチなもも！", "↑ 最大体力 +1#↓ 移動速度 -0.4#体力を1回復#障害物破壊能力を付与"}, -- Thunder Thighs
    [315] = {"315", "謎の引力", "涙が磁気を帯び、 敵やピックアップを 引き寄せる#磁力は着弾地点で 最も強くなる"}, -- Strange Attractor
	[316] = {"316", "呪眼", "涙がチャージ式になり、  チャージ量に応じた数の 涙が連続発射される#!!! チャージ中にダメージを 受けると、ランダムな 部屋にテレポートする#{{Collectible260}} ブラックキャンドルを 所持している場合、 テレポートしない"}, -- Cursed Eye
    [319] = {"319", "ケインの予備眼", "目玉がアイザックを追従し、 アイザックと同じ涙を ランダムな方向に放つ#ダメージ量は攻撃力の75%"}, -- Cain's Other Eye
    [320] = {"320", "？？？唯一の友", "攻撃方向に連動して移動し、 毎秒15の接触ダメージを 与える使い魔"}, -- ???'s Only Friend
    [323] = {"323", "アイザックのナミダ", "5の追加ダメージを持つ 涙を8方向に同時発射する#涙を発射するとチャージが 回復する"}, -- Isaac's Tears
	[325] = {"325", "ハサミ", "分離した頭がその場に 固定され、涙を放つ#操作する体側からは、 攻撃方向に向かって 血液の弾が噴き出す"}, -- Scissors
    [326] = {"326", "生命の息吹", "使用ボタンを押し続けると チャージ量が徐々に減り、 空になった瞬間無敵状態に なる#チャージ量が空になった後 更にボタンを1秒以上押し 続けるとダメージを受ける#無敵状態の時、敵に接触 ダメージを与え、光線を 発動する　#チャージ量が空になった 瞬間にダメージを防いだ 場合、十字方向にビーム 攻撃を放ち、短時間の シールド効果を得る"}, -- Breath of Life
    [328] = {"328", "ネガティブ", "↑ 攻撃力 +1#ダメージを受け、残りの 体力が半赤ハート以下に なった時、ネクロノミコン 効果を発動する （全ての敵に40ダメージ）"}, -- The Negative
    [330] = {"330", "豆乳", "↑ 連射速度 x5.5#↓ 攻撃力　 -80%#↓ ノックバック弱化"}, -- Soy Milk
    [331] = {"331", "神の首", "↑ 攻撃力　 +0.5#↓ 連射速度 -0.3#↓ 弾速　　 -0.3#涙がオーラを放ち、触れた 敵にダメージを与える#涙にホーミング効果を付与"}, -- Godhead
    [336] = {"336", "枯れタマネギ", "涙に貫通と透過効果を付与#↓ 射程　　 -1.5#↓ 弾速　　 -0.4#↑ 涙サイズ +0.22"}, -- Dead Onion
    [339] = {"339", "安全ピン", "↑ 射程 +2.5#↑ 弾速 +0.16#黒ハート +1"}, -- Safety Pin
    [342] = {"342", "青い帽子", "↑ 最大体力 +1#↑ 連射速度 +0.7#↓ 弾速　　 -0.16#体力を1回復"}, -- Blue Cap
    [344] = {"344", "紙マッチ", "黒ハート +1#{{Trinket41}} 取得時、3個の爆弾と、 マッチ棒をスポーン"}, -- Match Book
    [345] = {"345", "合成オイル", "↑ 攻撃力 +1#↑ 射程　 +2.5"}, -- Synthoil
    [346] = {"346", "スナック", "↑ 最大体力 +1#体力を1回復"}, -- A Snack
	[349] = {"349", "木製硬貨", "59%の確率でランダムな コインを1枚スポーン"}, -- Wooden Nickel
    [352] = {"352", "ガラスの大砲", "貫通効果を持つ大粒の涙を 発射し、攻撃力x10+10の ダメージを与える#!!! ダメージを受けると大砲が 壊れ、ハートを追加で2個 失う（この追加のダメージ では死に至らない）#献血等による自傷ダメージ では壊れない"}, -- Glass Cannon
    [354] = {"354", "クラックジャックス", "↑ 最大体力 +1#取得時、トリンケットを ランダムに1個スポーン#体力を1回復"}, -- Crack Jacks
    [355] = {"355", "ママのパール", "↑ 射程 +2.5#↑ 運　 +1#青ハート +1"}, -- Mom's Pearls
    [360] = {"360", "インキュバス", "アイザックの涙をコピー して攻撃する使い魔#リリス以外のキャラで 使う場合、ダメージは 攻撃力の75%"}, -- Incubus
    [365] = {"365", "ロスト フライ", "壁や障害物に沿って 移動する使い魔#毎秒30の接触ダメージ#近くの敵を引き付け、 アイザックの代わりに 攻撃対象となる"}, -- Lost Fly
    [366] = {"366", "拡散ボム", "爆弾 +5#爆弾から4～5個の小さな 爆弾が分裂する"}, -- Scatter Bombs
    [367] = {"367", "ねちょねちょボム", "爆弾 +5#爆弾で敵を倒すと 青クモがスポーン#爆弾が敵にくっ付く#爆発時、敵にスロー効果を 付与する液体をまき散らす"}, -- Sticky Bombs
    [368] = {"368", "流涙症", "同一方向に攻撃し続けると 連射速度が上昇していき、 最大200%アップする#攻撃の停止・方向変更で 連射速度がリセットされる"}, -- Epiphora
    [369] = {"369", "連続体", "↑ 射程 +3#涙に透過効果を付与#涙が画面の端と端で ループするようになる"}, -- Continuum
    [370] = {"370", "Mr. ドリー", "↑ 連射速度 +0.7#↑ 射程　　 +2.5#取得時、ランダムな ハートを3個スポーン"}, -- Mr. Dolly
    [374] = {"374", "聖なる光", "一定確率で聖なる涙が 発射され、衝突すると 近くの敵に光線が降り注ぐ#光線は攻撃力ｘ3の ダメージを与える#確率：運0=10%、9=50%"}, -- Holy Light
    [375] = {"375", "ホスト ハット", "爆発耐性を付与#敵の弾を25%の確率で ブロックし、跳ね返す#頭上に落下してくる弾を ブロックする"}, -- Host hat
    [376] = {"376", "商品補充", "お店で商品を購入すると 新しい商品が補充される#補充されるたびに商品が 値上がりする"}, -- Restock
    [380] = {"380", "ペイ・トゥー・プレイ", "コイン +5#鍵付きのドアや宝箱を コインで開けるように なる　　　"}, -- Pay To Play
    [382] = {"382", "フレンドリーボール", "モンスターを捕獲できる ボール#敵を捕獲後にボールを 拾うとチャージが回復#再使用すると捕獲された 敵がチャーム状態で現れる"}, -- Friendly Ball
    [384] = {"384", "リトル ガーディー", "攻撃に連動してチャージを 溜め、解放されると高速で 体当たりを始める使い魔#チャージ量に応じて 5～20のダメージを与える"}, -- Lil Gurdy
	[386] = {"386", "D12", "障害物をリロールする"}, -- D12
    [389] = {"389", "ルーン袋", "7～8部屋クリアするたび ランダムなルーンまたは ソウルストーン1個を スポーンする使い魔"}, -- Rune Bag
    [391] = {"391", "裏切り", "敵の発射した弾が他の 敵に当たるようになる#敵に攻撃された敵は、 発射元の敵に攻撃の ターゲットを変更する"}, -- Betrayal
    [393] = {"393", "サーペントのくちづけ", "15%の確率で涙に毒効果が 付与される#接触した敵に毒を与える#接触で毒を受けた敵が 死んだ時、20%の確率で 黒ハートを落とす"}, -- Serpent's Kiss
    [394] = {"394", "照準マーク", "照準方向へ涙が自動で 流れ続けるようになる#照準は攻撃ボタンで操作#ドロップボタンで攻撃を 停止できる#使い魔も同様に攻撃する#↑ 連射速度 +0.7#↑ 射程　　 +3"}, -- Marked
    [395] = {"395", "テックＸ", "涙がチャージ式のレーザー リングに置き換わる#チャージ量に応じて リングのダメージと サイズがアップする"}, -- Tech X
    [397] = {"397", "トラクタービーム", "アイザックの頭から放射 されるビームに沿って 涙が直進するようになる#↑ 連射速度 +1#↑ 射程　　 +2.5#↑ 弾速　　 +0.16"},
    [399] = {"399", "モー オブ ザ ボイド", "攻撃ボタンを押し続けて 2.35秒経過すると、頭に 十字架が浮かぶ 攻撃ボタンを解放すると ブリムストーンリングを 放出し、敵にダメージを 与える"}, -- Maw of the Void
    [401] = {"401", "エクスプロシボ", "25%の確率で涙が敵に くっ付き、数秒後に爆発#爆発は攻撃力+60の ダメージを与える"}, -- Explosivo
    [405] = {"405", "ＧＢバグ", "攻撃ボタンをダブルタップ して発射する#衝突したピックアップ・ トリンケット・宝箱・敵を リロールする使い魔"}, -- GB Bug
    [407] = {"407", "純潔", "ステータスを強化する オーラを付与#オーラの色と強化対象： {{ColorRed}}赤{{CR}}：攻撃力　 +4 {{ColorBlue}}青{{CR}}：連射速度 +2 {{ColorYellow}}黄{{CR}}：移動速度 +0.5 {{ColorOrange}}橙{{CR}}：射程　　 +3#ダメージを受けると オーラは消えるが、 部屋を移動すると ランダムな色で復活する"},
    [408] = {"408", "儀式の刃", "倒された敵が一定確率で ブリムストーンリングを 放ち、それに触れた他の 敵にダメージを与える#確率：運0=25%、30=100%"}, -- Athame
    [415] = {"415", "光の冠", "青ハート +2#空の赤ハートが無い時：#↑ 攻撃力 +100%#↓ 弾速　 -0.3 王冠が青く輝き、涙が ダイヤに置き換わる#ダメージを受けると、 その部屋では効果が 無効になる"}, -- Crown Of Light
    [416] = {"416", "深いポケット", "コインの最大値が999に#部屋クリア時の報酬が 無かった時、代わりに、 コインが1～3枚スポーン"}, -- Deep Pockets
    [417] = {"417", "サキュバス", "オーラを放ちながら 部屋を飛び回る使い魔#オーラ内では攻撃力が 50%アップする#オーラは範囲内の敵に 毎秒10ダメージを与える"}, -- Succubus
    [419] = {"419", "テレポート２．０", "未探索のランダムな 部屋にテレポートする#優先順位: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}{{BossRushRoom}}>{{IsaacsRoom}}{{BarrenRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{Planetarium}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}>{{ErrorRoom}}"}, -- Teleport 2.0
    [421] = {"421", "インゲン豆", "敵をチャーム状態にする おならを放つ"}, -- Kidney Bean
    [422] = {"422", "輝く砂時計", "時間を巻き戻し、一つ 前の部屋に、一つ前の 部屋の状態で戻る#{{Collectible66}} フロアにつき三回まで 使用でき、使い切ると 次のフロアまでの間、 砂時計に変化する"}, -- Glowing Hourglass
    [426] = {"426", "熱狂的ファン", "0.66秒遅れでアイザックを 追従する使い魔#接触した敵に毎秒30の ダメージを与える"}, -- Obsessed Fan
    [430] = {"430", "パパ　バエ", "0.66秒遅れでアイザックを 追従する使い魔#アイザックと同じ攻撃力の 涙を発射する"}, -- papa Fly
    [431] = {"431", "多数次元ベイビー", "0.66秒遅れでアイザックを 追従する使い魔#アイザックと使い魔の 涙がこれを通過すると、 弾速・高さがアップし、 ダブルショット化する"},
    [432] = {"432", "キラキラボム", "爆弾 +5#爆発した爆弾が、63%の 確率でピックアップや トリンケットをスポーン#効果が発生するたび、その フロアでのスポーン確率が 1%減少する#爆発した爆弾が、15%の 確率で敵にチャームを 付与する"}, -- Glitter Bombs
    [433] = {"433", "ぼくの影", "アイザックを追従する影に 敵が触れると、友好的な チャージャーがスポーン#チャージャーは敵に突進し、 接触ダメージを与える#チャージャーは部屋を移動 すると消滅"}, -- My Shadow
    [437] = {"437", "D7", "その部屋で倒した敵を リスポーンする#クリア報酬のスポーン、 アクティブアイテムの チャージも再度有効化 される"}, -- D7
    [440] = {"440", "腎臓結石", "涙が時々詰まり、その 状態でチャージすると 顔がうっ血していく#フルチャージ状態で解放 すると結石が射出され、 連射速度が一時的に大幅 アップする"}, -- Kidney Stone
    [442] = {"442", "ダークプリンスの冠", "残りの赤ハートが ちょうど1個の時：#↑ 連射速度 +2 ※上限を突破できる#↑ 射程　　 +1.5#↑ 弾速　　 +0.2#有効時、王冠が赤く輝く"}, -- Dark Prince's Crown
    [444] = {"444", "シャープペンシル", "15回に1回、涙の弾幕が 発射されるようになる"}, -- Lead Pencil
    [448] = {"448", "ガラスの破片", "ダメージを受けた時、 25%の確率で赤ハートを 1個スポーンする#ダメージを受けると 出血が始まり、血液が 敵にダメージを与える#出血中、アイザックが 20秒おきにダメージを 受け、半赤ハート失う#赤ハートを拾うか、 赤ハートが空になると、 出血が止まる"}, -- Shard of Glass
    [450] = {"450", "グリードの目", "20回に1回、涙と一緒に 金の涙が発射され、 コインを1枚消費する#金の涙は敵を黄金化し、 追加のダメージを与える#黄金化状態の敵を倒すと 1～3枚のコインが落ちる#コイン未所持の状態でも 金の涙は発射されるが、 追加ダメージは発生しない"}, -- Eye of Greed
    [451] = {"451", "タロットクロス", "カードに追加の効果を 付与する#取得時、ランダムな カード・ルーンを1個 スポーンする"}, -- Tarot Cloth
    [453] = {"453", "複雑骨折", "↑ 射程 +1.5#涙が骨に置き換わり、 衝突すると破片が散る#破片はダメージが半減する"}, -- Compound Fracture
    [455] = {"455", "パパが失くしたコイン", "↑ 射程 +2.5#取得時、ラッキーペニーを 1枚スポーン"}, -- Dad's Lost Coin
    [456] = {"456", "カビの生えたパン", "↑ 最大体力 +1#体力を1回復"}, -- Midnight Snack
    [459] = {"459", "副鼻腔炎", "攻撃中、20%の確率で 鼻くそが発射され、 敵に10秒間くっ付く#鼻くそは攻撃力と等しい ダメージを毎秒与える"}, -- Sinus Infection
    [462] = {"462", "ベリアルの目", "↑ 射程 +1.5#涙に貫通効果を付与#敵を貫通した後の涙は ダメージが2倍になり、 サイズが1.3倍広がり、 ホーミング効果が付与 される"}, -- Eye of Belial
    [464] = {"464", "バランスのグリフ", "青ハート +2#部屋クリア時の報酬と、 チャンピオンタイプの 敵を倒した時の報酬が、 現在不足している物を 優先してスポーンする ように変更される"}, -- Glyph of Balance
    [468] = {"468", "シェード", "0.66秒遅れでアイザックを 追従する使い魔#接触した敵に毎秒75の ダメージを与える#合計666ダメージを 与えると消滅し、 アイザックに同等の 接触ダメージ効果を 付与する"}, -- Shade
    [472] = {"472", "キングベイビー", "他の使い魔を従え、 自動攻撃させる使い魔#攻撃ボタン押下中、 他の使い魔と共に その場で停止し、 離すと戻ってくる"}, -- King Baby
    [474] = {"474", "壊れたガラスの大砲", "チャージが溜まると ガラスの大砲に変化する"}, -- Broken Glass Cannon
    [476] = {"476", "D1", "現在の部屋のランダムな ピックアップを、同種の 別のピックアップとして 1個複製する"}, -- D1
    [477] = {"477", "ボイド", "!!! 部屋の全てのアイテムを 破壊して吸収する#アクティブアイテムを 吸収すると、次からの ボイド使用時に、その 効果を同時発動する#パッシブアイテムを吸収 すると、ステータスが ランダムに2つアップ"},
    [478] = {"478", "一時停止", "攻撃ボタンが押されるまで、 全ての敵の動きを止める#30秒で効果は解除される"}, -- Pause
    [487] = {"487", "ポテトピーラー", "使用するたび：#↓ 最大体力 -1#↑ 攻撃力 +0.2#{{Collectible73}} 肉の塊を付与#{{Collectible214}} 貧血の効果がその部屋 でのみ有効化する （射程アップ＆流血）"},
    [489] = {"489", "Ｄインフィニティー", "ダイス系アイテムの 効果を全て使用可能#ドロップボタンで切替#チャージ量は使用する ダイスで変動する"}, -- D Infinity
    [491] = {"491", "アシッドベイビー", "7部屋クリアごとに ランダムなピルを1個 スポーンする使い魔#ピル使用時、部屋の 全ての敵に毒を与える"}, -- Acid Baby
    [493] = {"493", "アドレナリン", "↑ 空の赤ハートの量に 応じて攻撃力がアップ#{{EmptyHeart}} 1個：+0.3#{{EmptyHeart}} 2個：+0.92#{{EmptyHeart}} 3個：+1.76#{{EmptyHeart}} 4個：+2.79#{{Blank}} ：#{{Blank}} ：#{{EmptyHeart}} 11個：+14.05"}, -- Adrenaline
    [494] = {"494", "ヤコブのハシゴ", "涙が衝突した時、火花 放電が発生し、近くの 敵を攻撃する#火花は攻撃力ｘ0.5の ダメージを与える"}, -- Jacob's Ladder
    [495] = {"495", "ゴーストペッパー", "攻撃中、一定確率で 青い炎を放つ#確率：運0=8%、10=50%#炎は接触した敵に ダメージを与え、 弾をブロックする#炎は2秒で燃え尽きる"}, -- Ghost Pepper
    [496] = {"496", "安楽死", "一定確率で涙が注射針に 置き換わる#注射針は敵を即死させ、 円形に10発の涙を拡散する#ボスには攻撃力ｘ3の ダメージを与える#確率：運0=3%、15=25%"}, -- Euthanasia
    [497] = {"497", "カモフラパンツ", "部屋に入った時、攻撃 ボタンを押すまでの間 アイザックを透明化し、 全ての敵を混乱させる#↑ 透明中、移動速度+0.5#透明化が解除された時、 近くの敵にダメージを 与え、火力が一定時間 アップする"}, -- Camo Undies
    [500] = {"500", "袋の中の袋", "7～8部屋クリアするたび サックをスポーンする 使い魔"}, -- Sack of Sacks
    [501] = {"501", "グリードの喉", "所持コイン25枚ごとに 最大体力を1増やす#99枚で最大+4#キーパーにも適用可能#{{Collectible416}} 深いポケット所有時、 100枚以上からは100枚 ごとに1追加される"}, -- Greed's Gullet
    [503] = {"503", "リトルホーン", "一定確率でビッグホーンを 召喚する涙が発射される#ビッグホーンは雑魚敵を 即死させ、ボスには36の ダメージを与える#確率：運0=5%、15=20%#アイザックに、毎秒7の 接触ダメージ効果を付与"}, -- Little Horn
    [504] = {"504", "ブラウンナゲット", "3.5ダメージの涙で近くの 敵を自動攻撃するハエを スポーン"}, -- Brown Nugget
    [506] = {"506", "裏切り者", "涙が敵の背面に当たると ダメージが2倍になり、 出血状態が付与される#出血中の敵は5秒間、 移動速度に応じた ダメージを受け、  血だまりを生成する#血だまりに触れた 敵はダメージを受ける"}, -- Backstabber
    [507] = {"507", "シャープストロー", "部屋の全ての敵に ダメージを与える#ダメージ量は攻撃力+ 敵の最大体力の10%分#この効果でダメージを 与えた時、15%の確率で 半赤ハートをスポーン"},
    [508] = {"508", "ママのカミソリ", "アイザックを周回する カミソリの使い魔#カミソリは接触した敵に 攻撃力ｘ1.5のダメージを 毎秒与え、出血状態にする#出血中の敵は5秒ごとに 最大体力の10%に相当 するダメージを受け、 血だまりを生成する#敵の弾をブロックする"}, -- Mom's Razor
    [509] = {"509", "充血した目", "目玉がアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#毎秒20の接触ダメージ#近くの敵に3.5ダメージの 涙を発射する"}, -- Bloodshot Eye
    [514] = {"514", "壊れたモデム", "敵と弾がランダムな 間隔で遅延する#遅延した弾は消滅する#25%の確率で部屋の クリア報酬が2倍になる"},
    [517] = {"517", "ファスト ボム", "爆弾 +7#爆弾を高速で連続設置 可能になる#爆弾が互いをノックバック しなくなる"}, -- Fast Bombs
    [522] = {"522", "テレキネシス", "使用後3秒間、敵の弾が アイザックの周囲で 一時停止する#3秒後に弾が跳ね返され、 6～7ダメージを与える#発動中、敵を押しのける"}, -- Telekinesis
    [523] = {"523", "お引越し用の箱", "部屋のピックアップと アイテムを、10個まで 保存して運べる#保存した状態で再使用 すると、中身をそこに 展開する"}, -- Moving Box
    [524] = {"524", "テクノロジーゼロ", "涙同士が電気ビームで  つながり、触れた敵に  攻撃力x0.3のダメージ を秒間15回与える"}, -- Technology Zero
    [531] = {"531", "流血", "涙が弧を描いて飛び、 衝突すると破裂して 小さな涙が拡散する#↑ 攻撃力　 +50%#↑ 攻撃力　 +1#↓ 連射速度 -67%#↓ 射程　　 -20%"}, -- Haemolacria
    [543] = {"543", "神聖なる土", "ダメージを受けると 白いうんちがスポーン#うんちオーラの範囲内：#↑ 攻撃力　 +20%#↑ 連射速度 +150%#涙にホーミング効果を付与#50%の確率でダメージ無効化"}, -- Hallowed Ground
    [549] = {"549", "脆弱骨", "最大体力を0にし、6個の 骨ハートに置き換える#骨ハートを失うと：#8方向に骨が飛び散る#↑ 連射速度 +0.4（永続）"}, -- Brittle Bones
    [552] = {"552", "ママのスコップ", "次のフロアにつながる トラップドアを生成#装飾のある床の上で 使用するとクロール スペースを生成する （草やゴミがある床）#!!! ある場所で使うと…？"}, -- Mom's Shovel
    [553] = {"553", "接合菌症", "攻撃中、25%の確率で 胞子が飛び、敵に付着する#胞子は2.5秒後に爆発し、 近くの敵に5ダメージと 毒を与え、さらに4個の 胞子を拡散する"}, -- Mucormycosis
    [554] = {"554", "トゥ スプーキー", "近くの敵を恐怖状態にする"}, -- 2Spooky
    [555] = {"555", "ゴールデン レイザー", "コインを5枚消費し、 攻撃力を1.2増やす#その部屋でのみ有効#取得時、コイン +5"}, -- Golden Razor
    [556] = {"556", "硫黄", "{{Collectible118}} その部屋にいる間、涙が ブリムストーンに変化#同じ部屋で複数回使用 すると、そのたびに 攻撃力とサイズがアップ"}, -- Sulfur
    [557] = {"557", "フォーチュン クッキー", "おみくじ・青ハート・ カード・トリンケットの いずれかをスポーンする"}, -- Fortune Cookie
    [558] = {"558", "目障り", "一定確率で、1～3発の 追加の涙がランダムな 方向に発射される"}, -- Eye Sore
    [559] = {"559", "１２０ボルト", "接近した敵に放電し、 攻撃力ｘ0.75の ダメージを秒間5回与える"}, -- 120 Volt
    [560] = {"560", "痛い・・・", "ダメージを受けると、 円形に10発の涙を放ち、 連射速度がアップする#最初に1.2、以降は0.4 ずつアップする#その部屋でのみ有効"}, -- It Hurts
    [561] = {"561", "アーモンドミルク", "↑ 連射速度 +400%#↓ 攻撃力　 -70%#以下の効果を一定間隔で ランダムに付与する：#ワーム系トリンケット#{{Collectible221}} ゴムセメント#{{Collectible5}} リフレクション#{{Collectible233}} ちっちゃな惑星"}, -- Almond Milk
    [562] = {"562", "どん底", "ステータスが 下がらなくなる"}, -- Rock Bottom
    [563] = {"563", "ナンシーボム", "爆弾 +5#爆弾にランダムな 特殊効果を付与"}, -- Nancy Bombs
    [564] = {"564", "ソープバー", "↑ 連射速度 +0.5#↑ 弾速　　 +0.2"}, -- A Bar of Soap
    [565] = {"565", "ブラッドパピー", "近くの敵を追いかけて攻撃 する使い魔#敵を一定数倒すと凶暴化し 敵味方なく無差別に攻撃を 始める#凶暴化中は、敵を10体倒す たびに赤ハートをスポーン する　　#アイザックから一定量の ダメージを与えられると 通常状態に戻る"}, -- Blood Puppy
    [566] = {"566", "ドリーム キャッチャー", "フロア移動時の画面中に、 次のトレジャールームの アイテム・ボスの情報が 表示されるようになる#？状態のアイテムでも 確認できる#毎フロア開始時、 半青ハートを得る"}, -- Dream Catcher
    [567] = {"567", "パスカル キャンドル", "ダメージを受けずに 部屋をクリアするたび 連射速度が0.4アップ#最大5回アップ#ダメージを受けると リセットされる"}, -- Paschal Candle
    [568] = {"568", "神々の介入", "攻撃ボタンをダブルタップ するとシールドを展開する#シールドは弾を跳ね返し、 敵をノックバックさせる#持続1秒・再展開まで3秒"}, -- Divine Intervention
    [569] = {"569", "血の誓い", "毎フロア開始時、短剣が 突き刺さり、赤ハートが 空または半個になるまで ダメージを受ける#失われた赤ハートの量に 応じて、各ステータスが アップする#↑ 攻撃力：+0.15*{{Heart}}^2#↑ 移動速度：+0.1*{{Heart}}"}, -- Blood Oath
    [570] = {"570", "プレイドー クッキー", "涙にランダムな特殊効果と 色を付与する"}, -- Playdough Cookie
    [571] = {"571", "オーファン ソックス", "トゲや液体などの、足元 からのダメージを無効化#↑ 移動速度 +0.3#青ハート +2"}, -- Orphan Socks
    [572] = {"572", "オカルトの目", "滞空する涙が攻撃方向に 連動して軌道を変える#↑ 攻撃力 +1#↑ 射程　 +2#↓ 弾速　 -0.16"}, -- Eye of the Occult
    [573] = {"573", "けがれのないハート", "体力全回復#最大体力 +1#↑ 攻撃力　 +20%#攻撃中、20%の確率で 追加の涙が発射され、 アイザックを周回する"}, -- Immaculate Heart
    [574] = {"574", "モンストランス", "アイザックがオーラを 放ち、範囲内の敵に ダメージを与える#オーラの中心に近付く ほどダメージ量が増加"}, -- Monstrance
    [575] = {"575", "侵入者", "クモが頭に寄生し、スロー 効果付き涙で敵を攻撃する#ダメージを受けた時、 一定確率でクモが飛び出し、 近くの敵を攻撃する （運4で確率100%）"}, -- The Intruder
    [576] = {"576", "ダーティ マインド", "敵のうんちが味方になる#うんちを壊すと1～4匹の うんち使い魔がスポーン#特殊なうんちは特殊な うんち使い魔をスポーン#一定確率で岩がうんちに 置き換わる"}, -- Dirty Mind
    [577] = {"577", "ダモクレス", "使うと、アイザックの 頭上に剣が吊るされ、 以降、アイテムが倍に なってスポーンする#お店、宝箱、悪魔取引の アイテムは倍にならない#{{Warning}} ダメージを受けた後、 剣が一定確率で落下し、 アイザックが即死する#即死効果は無敵状態で 回避できる#落下確率は15分で50%"}, -- Damocles
    [578] = {"578", "タダのレモネード", "床にレモネードが広がり、 敵に毎秒24のダメージを 与える"}, -- Free Lemonade
    [579] = {"579", "スピリット ソード", "涙を剣による近接攻撃に 置き換える#剣は攻撃力ｘ3+3.5の ダメージを与え、体力が 十分な時、ビームを放つ#チャージで回転攻撃を 放ち、攻撃力ｘ3+3.5の ダメージを与える#回転攻撃と共にビームを 放ち、攻撃力ｘ4+4の ダメージを与える"}, -- Spirit Sword
    [580] = {"580", "レッド キー", "赤いドアの輪郭が表示 された壁に対して使用 すると、新しい部屋を 生成できる#10%の確率で特殊部屋が 生成される#13ｘ13の範囲外に生成　　 すると、I AM ERRORに つながる　　"}, -- Red Key
    [581] = {"581", "サイ フライ", "敵の弾を追尾ブロックし、 接触した敵に毎秒15の ダメージを与える使い魔"}, -- Psy Fly
    [582] = {"582", "シビレタケ", "↑ 連射速度 +0.75#↓ 移動速度 -0.03#画面が歪む#効果はスタック可能"}, -- Wavy Cap
    [583] = {"583", "ボトル ロケット", "爆弾 +5#攻撃しながら爆弾を設置 すると、ロケット爆弾が 攻撃方向に発射される"}, -- Rocket in a Jar
    [584] = {"584", "美徳の書", "ウィスプがスポーンし、 アイザックを周回する#ウィスプは透過効果付きの 涙を放ち、弾をブロックし、 敵に接触ダメージを与える#一定量のブロック・接触で 燃え尽きる#別のアクティブアイテムを 上に積み重ねると、特殊な ウィスプがスポーン#最初に現れる悪魔部屋を 天使部屋に置き換える#悪魔取引済みでも天使 部屋が生成可能になり、 その出現率を25%増やす"}, -- Book of Virtues
    [585] = {"585", "アラバスタ ボックス", "天使部屋アイテムを2個、 青ハートを3個スポーン#悪魔取引済みの場合、 スポーン量が各1個減#チャージが空の状態で 始まり、通常の方法で チャージされない#青／黒ハートを取得時、 体力には追加されず、 代わりに、チャージが 2追加される"}, -- Alabaster Box
    [586] = {"586", "天国への階段", "フロア開始時、天使部屋の お店につながるハシゴが スポーンする"}, -- The Stairway
    [587] = {"587", "Menorah (Unused but scripted)", "<Item does not exist>"}, -- Menorah (Unused but scripted)
    [588] = {"588", "ソル", "ボス部屋の位置が マッピングされる#ボスを倒すと、 現在のフロアで 以下の効果が発動：#{{Card20}} 太陽のカード効果#アクティブアイテムを フルチャージ#フロアの呪いを除去#↑ 攻撃力 +3#↑ 運　　 +1"}, -- Sol
    [589] = {"589", "ルナ", "各フロアに追加の隠し 部屋を生成する#隠し部屋の位置が一つ マップに表示される#追加された隠し部屋で 月明かりに照らされると 半青ハートと連射速度の アップ効果が付与される"}, -- Luna
    [590] = {"590", "メルクリウス", "↑ 移動速度 +0.4#部屋に敵が居てもドアが 開いたままになる"}, -- Mercurius
    [591] = {"591", "ヴィーナス", "↑ 最大体力 +1#体力を1回復#接近した敵をチャーム 状態にする"}, -- Venus
    [592] = {"592", "テラ", "↑ 攻撃力 +1#涙が石に置き換わり、 障害物の破壊能力と、 追加のノックバック 効果を得る#涙のダメージが 0.5倍～2倍の範囲で ランダムに変動する"}, -- Terra
    [593] = {"593", "マルス", "移動ボタンをダブルタップ すると、突進攻撃が発動#突進中はダメージを受けず、 衝突した敵に攻撃力x4+8の ダメージを与える#3秒のクールダウン"}, -- Mars
    [594] = {"594", "ユピテル", "体力を半ハート回復#↑ 最大体力 +2##↓ 移動速度 -0.3#静止中、一時的に移動 速度が上昇し、毒ガス がチャージされる#移動すると一時上昇した 移動速度が減少を始め、 同時に毒ガスを放出す#アイザックに毒耐性を付与"}, -- Jupiter
    [595] = {"595", "サトゥルヌス", "部屋に入ると、涙の円が アイザックを取り囲む#一定確率で敵の弾を円に 取り込める#涙の円はうんちやTNT、 炎を破壊しない"}, -- Saturnus
    [596] = {"596", "ウラヌス", "涙が氷柱に置き換わり、 倒された敵が凍結する#凍結した敵は砕けると 10個の氷柱を拡散する#拡散した氷柱はスロー 効果を持ち、倒した敵 を凍結させる#凍結は、分裂や爆発等、 死を条件にした効果を 無効にする"}, -- Uranus
    [597] = {"597", "ネプトゥヌス", "攻撃していない間に涙を 溜め込み、攻撃再開時に 大量放出できる"}, -- Neptunus
    [598] = {"598", "プルート", "↑ 連射速度 +0.7#アイザックが大幅に縮み、 障害物のすき間などに 入り込めるようになる#高さのある弾は、頭上を 通過し、ヒットしない"}, -- Pluto
    [599] = {"599", "ブードゥー ヘッド", "各フロアに追加の呪いの 部屋を生成する#呪いの部屋の報酬が改善#呪いの部屋に必ず コインがスポーンする"}, -- Voodoo Head
    [600] = {"600", "目薬", "!!! 左目のみに適用#↑ 連射速度 +40%"}, -- Eye Drops
    [601] = {"601", "痛悔の祈り", "↑ 連射速度 +0.7#白ハート +1#悪魔取引済みでも天使 部屋が生成可能になる#赤ハートにダメージを 受けた時のペナルティ (悪魔部屋の出現率減) を最大65%軽減する"}, -- Act of Contrition
    [602] = {"602", "メンバー カード", "お店にトラップドアが 生成され、地下店舗が 利用可能になる#地下店舗のアイテムは 複数のアイテムプール から選択される"}, -- Member Card
    [603] = {"603", "バッテリー パック", "取得時、電池を2～4個 スポーンし、アクティブ アイテムをフルチャージ"}, -- Battery Pack
    [604] = {"604", "ママのブレスレット", "障害物を持ち上げて 投げつけられる#持ち上げた状態で 部屋を移動できる"}, -- Mom's Bracelet
    [605] = {"605", "ザ スクーパー", "部屋を飛び回る目玉を 召喚する#目玉は接触ダメージを 与え、弾をブロックし、 ダメージ性の血痕を残す#↑ 右目の攻撃力 +36%"}, -- The Scooper
    [606] = {"606", "オキュラー リフト", "5%の確率で涙の着地点に 裂け目が生成され、敵と 弾、ピックアップが吸い 込まれる#裂け目に吸引された敵に 攻撃力x3のダメージを 毎秒与える"}, -- Ocular Rift
    [607] = {"607", "ボイルド ベイビー", "涙をまき散らして攻撃する 使い魔#涙は3.5か5.25のダメージを 与える"}, -- Boiled Baby
    [608] = {"608", "フリーザー ベイビー", "石化と凍結効果を持つ 氷柱で攻撃する使い魔"}, -- Freezer Baby
    [609] = {"609", "エターナルＤ６", "部屋の全てのアイテムを リロールする#リロール時、25%の確率で アイテムが消滅する"}, -- Eternal D6
    [610] = {"610", "バードケージ", "ダメージを受けると 頭から鳥が飛び立ち、 敵に体当たりをする#体当たりは敵に45の ダメージを与え、 地割れを発生させる#体当たり後、敵を追い かけて攻撃し始める"}, -- Bird Cage
    [611] = {"611", "ラリンクス", "叫びの衝撃波で攻撃する#フルチャージではない 状態でも使用でき、 チャージ量に応じた 攻撃範囲とダメージを 与える#ダメージを受けた時、 チャージが1回復する"}, -- Larynx
    [612] = {"612", "ロスト ソウル", "アイザックの背後に一撃で 死ぬ幽霊の使い魔が憑く#次のフロアまで幽霊が 生き残った時、以下の いずれかをスポーンする#青ハート3個#白ハート2個#トレジャールームか 天使部屋のアイテム1個#死んだ幽霊は次の フロアでリスポーン"}, -- Lost Soul
    [613] = {"613", "", "<Item does not exist>"},
    [614] = {"614", "ブラッド ボム", "↑ 最大体力 +1#体力を4回復#爆弾が血だまりを生成し 敵にダメージを与える#爆弾を所持していない時、 代わりに半ハートを消費 して爆弾を設置できる#赤ハートから優先消費"}, -- Blood Bombs
    [615] = {"615", "リトル ダンピー", "敵か弾がアイザックに 接近した時、おならを 出してそれを跳ね返す#一度おならを出すと、 アイザックが再接触 するまで停止する"}, -- Lil Dumpy
    [616] = {"616", "バードアイ", "攻撃中、一定確率で 赤い炎を放つ#確率：運0=8%、10=50%#炎は接触した敵に ダメージを与え、 弾をブロックする#接触／ブロックを 4回行うと消滅する#10秒の経過でも消滅"}, -- Bird's Eye
    [617] = {"617", "ロードストーン", "一定確率で敵を磁化する 涙を放つ#磁化した敵は近くの敵と 弾、ピックアップを引き 寄せる　　#確率：運0=17%、5=100%"}, -- Lodestone
    [618] = {"618", "ロッテン トマト", "一定確率で涙に標的化 効果を付与する#標的化した敵は、他の 敵から攻撃される#確率：運0=17%、4=100%"}, -- Rotten Tomato
    [619] = {"619", "バースライト", "キャラクターごとに 異なる能力を付与"}, -- Birthright
    [620] = {"620", "", "<Item does not exist>"},
    [621] = {"621", "レッド シチュー", "↑ 攻撃力 +21.6（一時的）#アップした攻撃力は徐々に 減少し、3分間で0になるが、 敵を倒すと効果が延長する#体力を全回復"}, -- Red Stew
    [622] = {"622", "ジェネシス", "アイザックを初期状態に リセットし、特殊な部屋 にテレポートさせる#リセットで失った全ての アイテムを、3つの選択肢 からそれぞれ選び直す#部屋から離れると、次の フロアに直行する"}, -- Genesis
    [623] = {"623", "シャープ キー", "鍵 +5#鍵を投げて敵の攻撃や ドア・宝箱の開放、 障害物の破壊ができる#鍵で敵を倒すと、一定 確率で宝箱アイテムを スポーンする"}, -- Sharp Key
    [624] = {"624", "ブースター パック", "取得時、ランダムな カードを5枚スポーン"}, -- Booster Pack
    [625] = {"625", "メガ　マッシュ", "30秒間巨大化し、攻撃力と 射程が大幅にアップ#無敵状態になり、障害物や ドア、敵を粉砕できる#効果はフロア間で持続する"}, -- Mega Mush
    [626] = {"626", "ナイフピース１", "ナイフピース2と 組み合わせるハンドル"}, -- Knife Piece 1
    [627] = {"627", "ナイフピース２", "ナイフピース1と合成 すると、ナイフが現れる#涙の発射方向に連動して ナイフが発射され、敵に 25ダメージを与える#マウソレウム／ゲヘナで 肉のドアを開くと消滅"}, -- Knife Piece 2
    [628] = {"628", "死亡届", "ゲーム内に存在する、ほぼ 全てのアイテムが置かれた 特殊フロアにテレポート#アイテムを一つ取ると元に 居た場所へ戻る"}, -- Death Certificate
    [629] = {"629", "ボット フライ", "アイザックを周回し、 シールド付きの涙で 敵の弾をブロックする 使い魔　　#毎秒3の接触ダメージ"}, -- Bot Fly
    [630] = {"630", "", "<Item does not exist>"},
    [631] = {"631", "ブッチャーナイフ", "敵を二分割し、体力が 40%のミニサイズにする#分裂するタイプの敵を 即座に分裂させる#分割できない敵には 25ダメージを与える"}, -- Meat Cleaver
    [632] = {"632", "イビル チャーム", "↑ 運 +2#火傷・混乱・恐怖・毒への 耐性を付与する"}, -- Evil Charm
    [633] = {"633", "ドグマ", "飛行能力を付与#取得した部屋で一度だけ ダメージを無効化#↑ 攻撃力 +2#1.1以下の移動速度を 1.1に修正する#体力が6未満の時、6になる ハートの組み合わせで回復"}, -- Dogma
    [634] = {"634", "パーガトリー", "バトル中、床に亀裂が 生成され、上を歩くと 幽霊がスポーンする#幽霊は敵に突撃して 爆発する　　"}, -- Purgatory
    [635] = {"635", "スティッチ", "保持中、攻撃方向に連動 して移動する人形が現れる#使用すると、アイザックと 人形の位置が入れ替わり、 一時的に無敵状態になる#敵の位置にテレポートした 場合、攻撃力ｘ3+40の接触 ダメージを与える#人形は接触した敵に毎秒3の ダメージを与える"}, -- Stitches
    [636] = {"636", "Ｒキー", "アイザックを現在の状態の まま最初のフロアに戻す （強くてニューゲーム）"}, -- R Key
    [637] = {"637", "眠り薬", "一定確率で涙が拳に置き 換わり、敵を強くノック バックさせ、混乱状態に する　　#この効果で壁や障害物に 衝突した敵はダメージを 受ける　#確率：運0=10%、8=100%"}, -- Knockout Drops
    [638] = {"638", "ケシゴム", "投げた消しゴムが敵に 当たると、以降、その 敵がスポーンしなくなる#通常の方法でチャージ されず、フロア移動時 にのみチャージされる#ボスには15ダメージを 与える　　"}, -- Eraser
    [639] = {"639", "ヤック ハート", "腐ったハートを1個付与#腐ったハートは、部屋を クリアした時、青ハエを スポーンする"}, -- Yuck Heart
    [640] = {"640", "魂の壺", "火炎放射で攻撃する#敵を倒すとチャージ回復"}, -- Urn of Souls
    [641] = {"641", "アケルダマ", "バトル中、アイザックの 背後に涙が連なり、各涙が 3.5のダメージを与える"}, -- Akeldama
    [642] = {"642", "マジックスキン", "その部屋のアイテムプール から、アイテムを一つ生成#最大体力1か骨ハート1個、 または青／黒ハート2個を、 壊れたハート1個に変換#消費優先順位は赤＞骨＞青#使用後にこれを手放すと、 スポーンするアイテムが 一定確率でこれに置き換え られるようになる#確率は1回の使用で33%、 2回で50%、3回以上で100%#現フロアのどこかにこの アイテムが存在する場合、 置き換え確率が低下する"}, -- Magic Skin
    [643] = {"643", "リベレイション", "飛行能力を付与#青ハート +2#攻撃ボタンを押し続けて 2.35秒以上経過すると、 ボタン解放時にレーザー 攻撃を放つ"}, -- Revelation
    [644] = {"644", "ざんねん賞", "連射速度・移動速度・ 攻撃力・射程の中で、 最も低いステータス 一つをアップする#所持量が最も少ない ピックアップ一つを 選び、コイン3枚・ 爆弾1個・鍵1個の いずれかをスポーン"}, -- Consolation Prize
    [645] = {"645", "タイニートーマ", "テラトーマがアイザックを 周回する#接触した敵にダメージを 与え、弾をブロックする#接触・ブロックを3回 行うと、二分割される#分割後、破壊されると 青クモを3匹スポーンし、 5秒後にリスポーンする"}, -- Tinytoma
    [646] = {"646", "ブリムストーン ボム", "爆弾 +5#爆発した爆弾が十字方向に ブリムストーンレーザーを 放つようになる"}, -- Brimstone Bombs
    [647] = {"647", "４.５ボルト", "アクティブアイテムが 部屋クリアでチャージ されなくなる代わりに、 敵にダメージを与える ことでチャージされる ようになる#フルチャージに必要な ダメージ量は、フロア ごとに増加する"}, -- 4.5 Volt
    [648] = {"648", "", "<Item does not exist>"},
    [649] = {"649", "フルーティ プラム", "部屋を斜めに飛び回り ながら涙を連射する、 ミニ・ベビープラムの#涙で3、接触で毎秒6の ダメージを与える"}, -- Fruity Plum
    [650] = {"650", "プラムのふえ", "ベビープラムが召喚され、 10秒間敵と戦う"}, -- Plum Flute
    [651] = {"651", "ベツレヘムの星", "ボス部屋に向かって自律 移動し、到達すると停止 する使い魔#使い魔の範囲内：#↑ 攻撃力　 +80%#↑ 連射速度 +150%#涙にホーミング効果を付与#50%の確率でダメージ無効"}, -- Star of Bethlehem
    [652] = {"652", "キューブ ベイビー", "接触した敵にダメージと スロー効果を与え、敵を 倒した場合は凍結させる 使い魔　　#速度に応じて最大17.5の 接触ダメージを与える#自ら動けず、アイザック との接触や、敵の弾の ブロックでスライドする"}, -- Cube Baby
    [653] = {"653", "ヴァデ レトロ", "保持中、倒された敵が 赤い幽霊を残す#アイテムを使用すると 赤い幽霊が爆発し、 敵にダメージを与える#残り体力が50%以下の、 幽霊タイプの敵を即死 させる（ボスを含む）"}, -- Vade Retro
    [654] = {"654", "偽ＰＨＤ", "黒ハート +1#全てのピルが識別される#良性のピルを悪性に変換#ステータスを下げるピルを 飲むと攻撃力が0.6増加し、 それ以外の場合黒ハートを スポーンする"}, -- False PHD
    [655] = {"655", "スピン トゥ ウィン", "コマがアイザックを周回し、 敵に接触ダメージを与え、 弾をブロックする#毎秒10.5の接触ダメージ#使用すると、コマと他の 使い魔が高速で周回し、 接触ダメージが強化され、 移動速度が0.5アップする"}, -- Spin to Win
    [656] = {"656", "ダモクレス", "使うと、アイザックの 頭上に剣が吊るされ、 以降、アイテムが倍に なってスポーンする#お店、宝箱、悪魔取引の アイテムは倍にならない#{{Warning}} ダメージを受けた後、 剣が一定確率で落下し、 アイザックが即死する#即死効果は無敵状態で 回避できる#落下確率は15分で50%"}, -- Damocles
    [657] = {"657", "血管炎症候群", "倒された敵が涙を拡散する#拡散する涙はアイザックの 持つ特殊効果を引き継ぐ"}, -- Vasculitis
    [658] = {"658", "ジャイアント セル", "ダメージを受けるたびに マイクロ・アイザックが スポーンし、近くの敵を 追いかけ攻撃する"}, -- Giant Cell
    [659] = {"659", "トロピカミド", "↑ 射程 +2.5#↑ 涙のサイズ"}, -- Tropicamide
    [660] = {"660", "カードリーディング", "フロア開始時、ポータルが 二つ生成される#部屋を離れるとポータルは 消滅する#ポータルの色と行き先：#{{ColorRed}}赤：{{CR}}{{BossRoom}}ボス部屋#{{ColorYellow}}黄：{{CR}}{{TreasureRoom}}トレジャールーム#{{ColorBlue}}青：{{CR}}{{SecretRoom}}隠し部屋"}, -- Card Reading
    [661] = {"661", "クインツ", "敵を倒すと、その場に固定 された使い魔がスポーンし、 連動して攻撃する#最大5匹までスポーンする"}, -- Quints
    [662] = {"662", "Pacifist (Cut item)", "<Item does not exist>"}, -- Pacifist (Cut item)
    [663] = {"663", "トゥース＆ネイル", "6秒おきに1秒間、無敵 状態になり、40の接触 ダメージ効果を得る"}, -- Tooth and Nail
    [664] = {"664", "ドカ食い", "↑ 最大体力 +1#体力全回復#アイテムが食品タイプの アイテムとの二択状態で スポーンする#食品タイプのアイテムを 取得すると、以下の追加 効果を付与する：#体力を3回復#↑ ステータスを二つアップ#↓ 移動速度 -0.03#↑ 攻撃力　 +3.6#攻撃力のアップは30秒で フェードアウト"}, -- Binge Eater
    [665] = {"665", "ガッピーの目", "宝箱・焚き火・サック・ 店主の中身を透視できる"}, -- Guppy's Eye
    [666] = {"666", "", "<Item does not exist>"},
    [667] = {"667", "ストローマン", "セカンドキャラとして キーパーをスポーンする#死亡時、5匹の青クモを スポーンする#!!! アイテムを取得できるが、 死ぬと共に消滅する為、 ストーリー進行に必要な アイテムは注意#キーパーが生きている間、 悪魔部屋の取引コストは コインになる#取得時、爆弾を1個付与"}, -- Strawman
    [668] = {"668", "パパのメモ", "アセントへ移行する"}, -- Dad's Note
    [669] = {"669", "ソーセージ", "体力全回復#↑ 最大体力 +1#↑ 攻撃力　 +0.5#↑ 連射速度 +0.5#↑ 移動速度 +0.2#↑ 弾速　　 +0.16#↑ 射程　　 +2.5#↑ 運　　　 +1#↑ 悪魔部屋／天使部屋と プラネタリウムの出現率が 6.9%アップ"}, -- Sausage
    [670] = {"670", "オプション？", "部屋クリア時の報酬が 二択になる"}, -- Options?
    [671] = {"671", "キャンディハート", "赤ハートを取得し、体力が 回復すると、ステータスが ランダムに一つアップする#取得時、赤ハートを1個 スポーン"}, -- Candy Heart
    [672] = {"672", "１ポンドの肉", "ブラックマーケットと 悪魔部屋の取引コストが コインになる#お店のアイテム価格が コインではなくハート になる　　#お店のピックアップは 無料で取得できるが、 トゲでダメージを受ける"}, -- A Pound of Flesh
    [673] = {"673", "リデンプション", "悪魔部屋に入り、何も取得 せずに次のフロアに行くと、 攻撃力が1アップし、1個の 青ハートが付与される"}, -- Redemption
    [674] = {"674", "スピリット シャックル", "死ぬと、半ハートの体力で 幽霊に変化し、死体に鎖で つながれる#幽霊状態で10秒経過すると 復活する#復活後は、青／黒ハートを 1個取得しなければ、次の 復活効果が機能しない"}, -- Spirit Shackles
    [675] = {"675", "ひび割れたオーブ", "ダメージを受けた時：#その部屋の全ドアを開く#隣接する隠し部屋を開く#クロールスペースがある 岩と、ｘ岩を破壊する#離れ隠し部屋を含む、 ランダムな部屋一つを マッピング "}, -- Cracked Orb
    [676] = {"676", "エンプティ ハート", "赤ハートが1以下の状態で フロアを移動した時：#↑ 最大体力 +1"}, -- Empty Heart
    [677] = {"677", "アストラル プロジェクション", "未クリアの部屋で最初に ダメージを受けた時、 幽体離脱し、時間が 2秒間止まる#幽体離脱中は飛行能力と 透過の涙が付与され、 次に受けるダメージを 無効にする#部屋のクリアか、再度 ダメージを受けると、 幽体離脱が解除される"}, -- Astral Projection
    [678] = {"678", "帝王切開", "涙が胎児に置き換わる#胎児はホーミングと 貫通・透過効果を持ち、 攻撃力ｘ2.8のダメージを 毎秒与える"}, -- C Section
    [679] = {"679", "リトル アバドン", "ブリムストーンリングで 攻撃する使い魔#リングは最大52.5の ダメージを与える"}, -- Lil Abaddon
    [680] = {"680", "モンテズマズ リベンジ", "攻撃ボタンを押し続けて 2.35秒以上経過すると、 ボタン解放時、短射程の レーザー攻撃とコーンを 背後に放つ"}, -- Montezuma's Revenge
    [681] = {"681", "リトル ポータル", "涙の発射方向に連動して 飛び出し、接触した敵に ダメージを与える使い魔#飛行中、ピックアップを 青ハエに変換し、自身の サイズと接触ダメージを アップする#ピックアップを4個変換 すると、未探索の部屋に 繋がるポータルを生成し、 初期サイズに戻る"}, -- Lil Portal
    [682] = {"682", "ワーム フレンド", "敵に絡みつき、毎秒8の ダメージとスロー効果を 与え、動きを4秒間止める ワームの使い魔"}, -- Worm Friend
    [683] = {"683", "ボーン スパーズ", "倒された敵が、1～2個の 骨をスポーンする#骨はその場に浮遊し、接触 した敵にダメージを与え、 弾をブロックする#2回の接触／ブロックで 骨は消滅する"}, -- Bone Spurs
    [684] = {"684", "ハングリー ソウル", "倒された敵が33%の確率で 幽霊をスポーンする#幽霊は敵を追いかけ攻撃し、 7秒後に爆発する#アイザックはこの爆発で ダメージを受けない"}, -- Hungry Soul
    [685] = {"685", "ウィスプの壺", "ウィスプがスポーンし、 アイザックを周回する#使用するたびに一度に スポーンする数が増え、 最大12まで達する#ウィスプは透過効果付きの 涙を放ち、弾をブロックし、 敵に接触ダメージを与える#一定量のブロック・接触で 燃え尽きる"}, -- Jar of Wisps
    [686] = {"686", "ソウル ロケット", "青／黒ハートを拾った時、 ステータスがランダムに 一つアップする#取得時、青ハートを1個 スポーンする"}, -- Soul Locket
    [687] = {"687", "フレンド ファインダー", "アイザックの移動と攻撃を 模倣する、友好的な敵を スポーン"}, -- Friend Finder
    [688] = {"688", "インナー チャイルド", "追加ライフ +1#死ぬと、現在の部屋に 半ハートの体力で復活する#移動速度が0.2アップし、 アイザックのサイズが縮む#復活地点で血の爆発が起き、 敵に35ダメージを与える"}, -- Inner Child
    [689] = {"689", "バグったクラウン", "アイテムが五択状態で スポーンするようになる#0.2秒に1回のスピードで 表示が切り替わる"}, -- Glitched Crown
    [690] = {"690", "ベリー ジェリー", "アイザックに接触した敵が 跳ね返る#跳ね返った敵は、障害物や 壁に衝突するとダメージを 受ける#アイザックが敵と接触した 時、50%の確率でダメージを 受けない#アイザックが被弾した時、 50%の確率で弾を跳ね返し、 ダメージを受けない"}, -- Belly Jelly
    [691] = {"691", "セイクリッド オーブ", "品質0・1のアイテムが 自動的にリロールされ、 スポーンしなくなる#品質2のアイテムが33%の 確率で自動的にリロール される　"}, -- Sacred Orb
    [692] = {"692", "サングイン ボンド", "悪魔部屋にトゲが生成され、 それでダメージを受けた時、 以下の報酬を得る#{{Blank}} 35%：はずれ#{{Blank}} 33%：攻撃力 +0.5#{{Blank}} 15%：コイン 6枚#{{Blank}} 10%：黒ハート 2個#{{Blank}}  5%：悪魔部屋アイテム#{{Blank}}  2%：リヴァイアサン化"}, -- Sanguine Bond //PERCENTAGES NOT CONFIRMED, updated in patch, taken from Wiki
    [693] = {"693", "ザ スウォーム", "黒ハエが8匹スポーンし、 アイザックを周回する#敵の弾をブロックすると、 青ハエに変化する#部屋をクリアすると、 黒ハエが1匹スポーンする"}, -- The Swarm
    [694] = {"694", "ハートブレイク", "↓ 壊れたハート +3#↑ 壊れたハート1個につき 攻撃力 +0.25#アイザックに致命的な ダメージが与えられる時、 代わりに、2個の壊れた ハートを追加し、全ての 敵に40ダメージを与える#壊れたハートが12個 溜まると死ぬ"}, -- Heartbreak
    [695] = {"695", "血まみれの突風", "ダメージを受けるたびに 連射・移動速度がアップ#上限値（6ヒット後）：#{{Blank}} 移動速度 +1.02#{{Blank}} 連射速度 +3#{{Blank}} ※上限を突破できる#効果は次のフロアに 移動するまで有効"}, -- Bloody Gust
    [696] = {"696", "救済", "アイザックを光輪が囲む#光輪に触れた敵を中心に 十字形のビームが発生し、 最大152ダメージを与える#アイザックがダメージを 受けるたび光輪が拡大し、 10回で最大化する#フロア移動時にサイズが リセットされる"}, -- Salvation
    [697] = {"697", "バニッシング ツイン", "ボス部屋に入った時、その ボスのクローンに変身する 使い魔#クローンを倒すと、追加の ボスアイテムがスポーン#ボスとクローンは、体力が 元の75%に設定され、少し 動きが遅くなる"}, -- Vanishing Twin
    [698] = {"698", "ツイステッド ペア", "アイザックの左右に2匹の 使い魔が現れる#使い魔はアイザックの涙を コピーして放つが、攻撃力 のみ0.375倍に修正される"}, -- Twisted Pair
    [699] = {"699", "アザゼルの怒り", "部屋をクリアするたび 怒りが溜め込まれる#4部屋クリア後、次の 敵の居る部屋に入ると、 ブリムストーン攻撃が 3.33秒間発動する"}, -- Azazel's Rage
    [700] = {"700", "エコー チェンバー", "カード・ルーン・ピルを 使用した時、それ以前に 使用した、最後の3つの カード・ルーン・ピルの 効果も同時に発動する"}, -- Echo Chamber
    [701] = {"701", "アイザックの墓", "毎フロア開始時、古びた 宝箱をスポーンする#宝箱は以下の内容を含む：#{{Blank}} 43%：青ハート 1～3個#{{Blank}} 42%：トリンケット 3個#{{Blank}} 10%：古びた宝箱プールの 　　 アイテム#{{Blank}}  5%：天使部屋アイテム"}, -- Isaac's Tomb
    [702] = {"702", "生霊", "ダメージを受けると赤い ウィスプがスポーンし、 アイザックを周回する#ウィスプは透過効果を 持つ涙を発射し、敵に 接触ダメージを与える#弾のブロックはしない#ウィスプは最大6つまで 持て、フロアで持続する"}, -- Vengeful Spirit
    [703] = {"703", "エサウ Jr.", "現在のキャラクターが エサウJrと入れ替わる#エサウJrで使用すると、 元のキャラクターに戻る#エサウJrは+2の攻撃力と 飛行能力を持ち、3個の 黒ハートでスポーンする#初回使用時、エサウJrは 元のキャラクターが所持 していたアイテムと同数の ランダムなアイテムを得る#{{Warning}} どちらかのキャラクターが 死ぬとゲームオーバー"}, -- Esau Jr.
    [704] = {"704", "バーサーカー", "5秒間バーサーカー化し、 以下の効果を得る：#↑ 移動速度 +0.4#↑ 連射速度#↑ 攻撃力　 +3#涙を骨による近接攻撃に 置き換える#敵を倒すと持続時間+1秒#通常の方法ではチャージ されず、敵にダメージを 与えることでチャージする"}, -- Berserk!
    [705] = {"705", "ダーク アーツ", "無敵状態と+1の移動速度を 1秒間付与する#敵と弾を貫通して移動でき、 触れた敵の動きを止める#最初の敵に攻撃力x2+3.5の ダメージを与え、以降は 触れた敵／弾ごとに3.5の ダメージが追加される#効果終了時に爆発を起こし、 発動中の総ダメージ量と 等しいダメージを与える"}, -- Dark Arts
    [706] = {"706", "アビス", "部屋の全てのアイテムを 破壊し、イナゴの使い魔 に変換する#イナゴは攻撃方向に連動 して発射され、接触した 敵にダメージを与える#アイテムに応じて特殊な イナゴが生成される#最大64匹まで所持できる"}, -- Abyss
    [707] = {"707", "夕食", "↑ 最大体力 +1#体力を1回復"}, -- Supper
    [708] = {"708", "ホッチキス", "↑ 攻撃力 +1#左目から涙が流れなくなる"}, -- Stapler
    [709] = {"709", "スープレックス！", "ダッシュで敵に突っ込み、 かかえ上げた後、地面に 叩きつける#敵に50のダメージを与え、 着地地点に地割れを発生 させる#ダメージと地割れの効果 範囲は、アイザックの サイズで増減する"}, -- Suplex!
    [710] = {"710", "バッグ オブ クラフティング", "ピックアップを8個 集めるとアイテムを 作成できる#作成されるアイテムの 品質はピックアップの 品質に依存する"}, -- Bag of Crafting
    [711] = {"711", "フリップ", "保持中、アイテムがある 未訪問の部屋に入ると、 二つのアイテムが前後に 重なって表示される#アイテムを使用すると、 その前後が入れ替わる#片方のアイテムを取得し、 前後を入れ替えると、 もう片方のアイテムも 取得できる#片方のアイテムを取得 したあと部屋を出ると、 もう片方のアイテムは 消滅する"}, -- Flip
    [712] = {"712", "レメゲトン", "ランダムなアイテム効果を 与えるウィスプがスポーン し、アイザックを周回する#アイテムは25%の確率で その部屋のプールから 選択され、75%の確率で ランダムなプールから 選択される#ウィスプが破壊されると、 アイテムの効果を失う"}, -- Lemegeton
    [713] = {"713", "サンプトリウム", "半ハートを消費して血餅の 使い魔をスポーンする#血餅はアイザックの動きと 涙をコピーする#消費されたハートの種類に 応じて、特殊な効果を持つ 血餅がスポーンする"}, -- Sumptorium
    [714] = {"714", "リコール", "フォーガットンの体を 呼び戻す"}, -- Recall
    [715] = {"715", "ホールド", "うんちを1個保存できる"}, -- Hold
    [716] = {"716", "キーパーズ サック", "お店で買い物をするたび、 以下のいずれかがアップ：#↑ 攻撃力　 +0.5#↑ 移動速度 +0.03#↑ 射程　　 +0.25#取得時に3枚のコインと 1個の鍵をスポーン"}, -- Keeper's Sack
    [717] = {"717", "キーパーズ キン", "バトル中、岩から青クモが スポーンする#岩を破壊すると、0～2匹の 青クモがスポーンする"}, -- Keeper's Kin
    [718] = {"718", "Keeper's Rope (Cut item)", "<Item does not exist>"}, -- Keepers Rope (Cut item)
    [719] = {"719", "キーパーズ ボックス", "ランダムなお店の商品を スポーンする（※有料）"}, -- Keeper's Box
    [720] = {"720", "エブリシング ジャー", "フルチャージではない状態 でも使用でき、チャージ量 に応じたピックアップを スポーンする#{{Blank}} 1:{{PoopPickup}} 2:{{Coin}} 3:{{Bomb}} 4:{{Key}}#{{Blank}} 5:{{Heart}} 6:{{Pill}} 7:{{Card}} 8:{{SoulHeart}}#{{Blank}} 9:{{GoldenHeart}} 10:{{GoldenKey}} 11:{{GoldenBomb}}#フルチャージで使用すると ランダムな効果が発動"}, -- Everything Jar
    [721] = {"721", "バグ技", "スポーンするアイテムが グリッチ化して、効果が ランダムになる"}, -- TMTRAINER
    [722] = {"722", "アニマ ソラ", "最も近い敵を鎖で拘束し、 5秒間行動不能にする"}, -- Anima Sola
    [723] = {"723", "スピンダウン ダイス", "アイテムの内部ID番号を 1つ引き、部屋の全ての アイテムをリロールする"}, -- Spindown Dice
    [724] = {"724", "ハイパーコアギュレイション", "ダメージを受けると 赤ハートが飛び出す ようにスポーンし、 1.5秒後に消滅する"}, -- Hypercoagulation
    [725] = {"725", "IBS", "敵に一定量のダメージを 与えると、アイザックが 赤く点滅し始め、以下の 効果を発動する：#うんち投げ#うんち爆弾#下痢爆弾#おなら#下痢#下痢効果で床に生成された 液体に触れると、攻撃力が アップする#下痢効果で床に生成された 液体にうんちを乗せると、 各種相乗効果が発生する"}, -- IBS
    [726] = {"726", "ヘモプタスィス", "攻撃ボタンをダブルタップ すると吐血し、正面の敵に 攻撃力x1.5のダメージと ノックバックを与える#吐血を浴びた敵は呪われ、 ブリムストーンタイプの 攻撃で追加のダメージを 受ける#クールダウンは1秒"}, -- Hemoptysis
    [727] = {"727", "ゴースト ボム", "爆弾 +5#爆弾から幽霊がスポーンし、 敵を追いかけて攻撃する#幽霊は10秒後に爆発する"}, -- Ghost Bombs
    [728] = {"728", "ゲロー", "アイザックの涙をコピーし、 近くの敵を自動で攻撃する 使い魔を召喚#{{Player13}} リリス以外のキャラで 使う場合、ダメージは 攻撃力の75%#使用した部屋でのみ有効"}, -- Gello
    [729] = {"729", "デカップ アタック", "頭を分離して投げる#頭は衝突と接触で敵に ダメージを与え、弾を ブロックし、涙を放つ#頭を拾うか、再度使用 すると、元の体に戻る"}, -- Decap Attack
    [730] = {"730", "グラス アイ", "↑ 攻撃力 +0.75#↑ 運　　 +1"}, -- Glass Eye
    [731] = {"731", "スタイ", "!!! 右目のみに適用#↑ 攻撃力 +28%#↑ 射程　 +7#↓ 弾速　 -0.3"}, -- Stye
    [732] = {"732", "ママの指輪", "↑ 攻撃力 +1#取得時、ルーンかソウル ストーンを1個スポーン"}, -- Mom's Ring
}
EID:updateDescriptionsViaTable(repCollectibles, EID.descriptions[languageCode].collectibles)

---------- Modifiers ----------

-- Buffs caused by Binge Eater
-- Note: "#" will be replaced with "#{{Collectible664}} " automatically, in order to add Binge eater icon infront of each buff-bulletpoint
EID.descriptions[languageCode].bingeEaterBuffs = {
    [22] = "↑ 連射速度 +0.5#↑ 射程　　 +2.5#↓ 移動速度 -0.03", -- Lunch
    [23] = "↑ 連射速度 +0.5#↑ 弾速　　 +0.2#↓ 移動速度 -0.03", -- Dinner
    [24] = "↑ 攻撃力　 +1#↑ 弾速　　 +0.2#↓ 移動速度 -0.03", -- Dessert
    [25] = "↑ 弾速　　 +0.2#↑ 射程　　 +2.5#↓ 移動速度 -0.03", -- Breakfast
    [26] = "↑ 攻撃力　 +1#↑ 射程　　 +2.5#↓ 移動速度 -0.03", -- Rotten Meat
    [456] = "↑ 攻撃力　 +1#↑ 運　　　 +1#↓ 移動速度 -0.03", -- Midnight Snack
    [346] = "↑ 弾速　　 +0.2#↑ 運　　　 +1p#↓ 移動速度 -0.03", -- A Snack
    [707] = "↑ 連射速度 +0.5#↑ 運　　　 +1#↓ 移動速度 -0.03", -- Supper
}

-- Buffs caused by Book of Belial with Judas' Birthright
-- Note: "#" will be replaced with "#{{Collectible34}} " automatically, in order to add Book of Belial icon infront of each buff-bulletpoint
EID.descriptions[languageCode].bookOfBelialBuffs = {
    [40] = "{{Collectible35}}ネクロノミコン効果が 同時に発動する", -- Kamikaze!
    [126] = "{{Collectible35}}ネクロノミコン効果が 同時に発動する", -- Razor Blade
    [127] = "攻撃力の増加が、次の フロア全体で持続する", -- Forget me Now
    [133] = "↑ 攻撃力 +0.5（永続）", -- Guppy's Paw
    [135] = "使用するたび、その部屋に 居る間、攻撃力が0.66ずつ 増加する", -- IV Bag
    [147] = "斧にエンチャントが付き、 耐久性アップ・連射速度 アップ・ノックバックの 強化・火傷付与・幸運の 効果が付与される", -- Notched Axe
    [186] = "{{Collectible126}}レイザーブレードの 効果が同時に発動する", -- Blood Rights
    [282] = "ジャンプが炎の軌跡を 残し、敵にダメージと 火傷を与える", -- How to Jump
    [290] = "ハートを1個消費して 攻撃力アップ#床に血が広がり、敵に ダメージを与える", -- The Jar
    [295] = "一定確率で{{Collectible555}}ゴールデン レイザーの効果が同時に 発動する", -- Magic Fingers
    [297] = "悪魔タイプの使い魔が 追加でスポーンする", -- Pandora's Box
    [323] = "発射される涙のダメージが 増加し、貫通・透過効果も 付与される", -- Isaac's Tears
    [326] = "光線の代わりに、無敵 状態中、炎のオーラを放つ#ダメージを防いだ時、　　　 {{Collectible35}} ネクロノミコン 効果が発動し、更に、 攻撃力が一時的にアップ", -- Breath of Life
    [352] = "壊れると{{Collectible34}}ベリアルの本の 効果が発動し、修復される まで持続する", -- Glass Cannon
    [475] = "追加ライフがある場合、 ダークユダとして復活する", -- Plan C
    [482] = "最後に取得したアイテムを {{Collectible51}}ペンタグラムに置き換える", -- Clicker
    [487] = "↑ 攻撃力 +0.5（永続）", -- Potato Peeler
    [536] = "生贄に捧げられた使い魔 一匹につき攻撃力が10.8 増加する#増加した攻撃力は時間の 経過と共に減少する", -- Sacrificial Altar
    [555] = "全ての敵にダメージを 与え、{{Collectible202}}ミダスタッチの 効果を付与する", -- Golden Razor
    [577] = "攻撃力が永続アップ", -- Damocles
    [582] = "使用回数に応じて攻撃力が 増加し、現フロア間で効果 が持続する", -- Wavy Cap
    [585] = "報酬を、黒ハート2個と 悪魔部屋アイテム1個に 置き換える#悪魔取引済みの場合、  黒ハート3個と悪魔部屋 アイテム2個に置き換える", -- Alabaster Box
    [622] = "アイテムが削除された後、 {{Collectible51}}ペンタグラムを付与", -- Genesis
    [623] = "{{Collectible126}}レイザーブレードの 効果が同時に発動する", -- Sharp Key
    [635] = "{{Collectible705}}ダークアーツ攻撃が 位置交換時に発動する", -- Stitches
    [640] = "炎が{{Collectible118}}ブリムストーンの ビームに置き換わる", -- Urn of Souls
    [642] = "↑ 攻撃力 +0.5（永続）", -- Magic Skin
    [653] = "幽霊が敵を追尾する", -- Vade Retro
    [685] = "{{Collectible292}}邪悪な聖書ウィスプを スポーンし、悪魔部屋の 出現率を1体につき10% アップさせる", -- Jar of Wisps
    [705] = "発動中に貫通した敵・弾の 量に応じて、一時的に 攻撃力が増加する", -- Dark Arts
    [710] = "赤ハート取得時、一定 確率で黒ハートに変換", -- Bag of Crafting
    [729] = "頭が分離している間：#↑ 攻撃力　 +2#↑ 連射速度 +200%", -- Decap Attack
}

-- Book of Virtues wisp types
EID.descriptions[languageCode].BookOfVirtuesWispTexts = {
	-- values inside {} brackets will be replaced with text parts below
	-- Wisp texts are affected by the PluralizeFunction (ab+ file)
	-- The placeholder therefore can be used in all parts that make up the wisp descriptions
	StatDescription = "{ringIcon}{{Wisp}} {amount}|{{Heart}} {health}|{{Damage}} {damage}",	-- {ringIcon} will be replaced with an icon representing the wisp movement, {amount} with the number of wisps, {health} with the HP, {damage} with the damage or the "CantShoot" text
	Shotspeed = "弾速：{1}%", 				-- {1} will be replaced with the shot speed changes in %
	Chance = "（確率{1}%）",					-- {1} will be replaced with the chance
	SingleRoom = "その部屋でのみ有効",
	NoWisps = "ウィスプなし",
}

-- Old table that now is used to store additional information and effects for Book of Virtues Wisps
EID.descriptions[languageCode].bookOfVirtuesWisps = {
    [35] = "破壊時にネクロノミコン効果", -- The Necronomicon
    [37] = "破壊時に{{Collectible366}}拡散ボム", -- Mr. Boom
    [38] = "不正確な高速連射の涙", -- Tammy's Head
    [40] = "破壊時に爆発", -- Kamikaze!
    [47] = "使用時、照準地点に 3発の爆発涙を発射する", -- Doctor's Remote
    [49] = "使用時、同時にレーザー攻撃", -- Shoop da Whoop!
    [56] = "レモン汁を床に垂らし、 敵にダメージを与える", -- Lemon Mishap
    [58] = "敵の弾で破壊されない#{{Collectible58}}使用時、ダメージ無効", -- Book of Shadows
    [65] = "破壊時にトロル爆弾を スポーンする", -- Anarchist Cookbook
    [66] = "破壊時に全ての敵を 3秒間スロー状態にする", -- The Hourglass
    [77] = "強い接触ダメージ", -- My Little Unicorn
    [78] = "破壊時に{{Collectible526}}7つの封印の 使い魔をその部屋に居る 間付与する", -- Book of Revelations
    [85] = "破壊時にランダムな カードをスポーン", -- Deck of Cards
    [97] = "七つの大罪に基づいた 七種類のウィスプ#いくつかのウィスプは、 破壊時に、トロル爆弾・ ホーミング爆弾・ピルを スポーンする", -- The Book of Sin
    [102] = "六種類のウィスプ#毒／石化／混乱／火傷 効果を持つウィスプ#ヒット時トロル爆弾を 落とすウィスプ#破壊時に敵性のクモを スポーンするウィスプ#六種類とも、破壊時に ピルをスポーンする", -- Mom's Bottle of Pills
    [105] = "リロールされたアイテム ごとにウィスプを追加", -- The D6
    [111] = "破壊時に毒おならを放つ", -- The Bean
    [123] = "ランダムな特殊効果の涙", -- Monster Manual
    [124] = "発動したアイテムに 応じた効果のウィスプ", -- Dead Sea Scrolls
    [130] = "ウィスプが攻撃方向に 突進する", -- A Pony
    [137] = "起爆した爆弾1個につき ウィスプを1個スポーン#使用ボタンを押すと、 ウィスプの涙が爆発する", -- Remote Detonator
    [145] = "青ハエの代わりに ウィスプがスポーン#破壊時に青ハエをスポーン", -- Guppy's Head
    [147] = "障害物を破壊すると、 鉱石をテーマにした 五種類のウィスプが 一定確率でスポーン#以下のアイテムに似た 効果を持つ：#{{Collectible132}}石炭{{Collectible201}}鉄{{Collectible202}}金{{Collectible68}}赤石 {{Collectible415}}ダイアモンド", -- Notched Axe
    [160] = "接触時、光線攻撃が発生", -- Crack the Sky
    [166] = "ピックアップをリロール する代わりに、それらを 破壊し、同数のウィスプ をスポーン", -- D20
    [175] = "ウィスプをドア・宝箱に 接触させると、その鍵を 解除する#奇妙なドア・肉ドア・ メガサタンのドアも 解除できる", -- Dad's Key
    [177] = "スロットの報酬に応じて 各種ウィスプをスポーン#特殊効果あり：{{Collectible125}}爆弾／ {{Collectible175}}鍵／{{Collectible102}}ピル／{{Collectible145}}ハエ", -- Portable Slot
    [263] = "破壊時にルーンをスポーン", -- Clear Rune
    [283] = "ウィスプをリロールし、 ランダムなウィスプを 一つ付与#美徳の書はリロール されない", -- D100
    [284] = "全てのウィスプを削除し、 リロールされたアイテム 2個につき1つのランダムな ウィスプをスポーンする#美徳の書はリロール されない", -- D4
    [285] = "10%の確率で敵をリロール する涙", -- D10
    [286] = "破壊時にカードをスポーン", -- Blank Card
    [287] = "破壊時に{{Collectible675}}ひび割れた オーブの効果が発動 （全ドア開放・一部屋 マッピング・ｘ岩破壊）", -- Book of Secrets
    [288] = "青クモの代わりに ウィスプがスポーン#破壊時に青クモをスポーン", -- Box of Spiders
    [290] = "保存したハートを消費 してウィスプを生成する#破壊時に一定確率で 半赤ハートを落とす", -- The Jar
    [291] = "うんちにした敵1体に つき、ウィスプを1つ スポーンする", -- Flush!
    [292] = "悪魔部屋の出現率が、 邪悪な聖書ウィスプ 一つにつき10%増加", -- Satanic Bible
    [293] = "破壊時に四方向に レーザー攻撃", -- Head of Krampus
    [294] = "破壊時におならを放つ", -- Butter Bean
    [295] = "破壊時に一定確率で コインがスポーン", -- Magic Fingers
    [296] = "赤ハートでウィスプの 体力を回復できる", -- Converter
    [297] = "下層のフロアほど スポーン数増（0～8）", -- Pandora's Box
    [298] = "接触ダメージを与えない (接触では破壊されない)#アイザックが無敵状態時、 敵にダメージを与える", -- Unicorn Stump
    [323] = "ウィスプの寿命は3秒", -- Isaac's Tears
    [324] = "{{Collectible570}}プレイドークッキーの涙", -- Undefined
    [325] = "弧を描いて飛ぶ涙", -- Scissors
    [326] = "ダメージを防いだ時、 ウィスプｘ4をスポーン", -- Breath of Life
    [347] = "ダブルショットの涙#ウィスプを2倍にする", -- Diplopia
    [348] = "破壊時にピルをスポーン", -- Placebo
    [349] = "破壊時に50%の確率で コインをスポーン", -- Wooden Nickel
    [351] = "アイテム使用時、メガ豆 ウィスプが地割れを放つ#破壊時に石化と毒効果を 持つおならを放つ", -- Mega Bean
    [352] = "ガラスの大砲ウィスプの 一つが壊されると、他の 全ても同時に壊される#破壊されるまで有効", -- Glass Cannon
    [357] = "ウィスプを複製する#その部屋でのみ有効", -- Box of Friends
    [382] = "捕獲した敵が死ぬと、 そのタイプに応じた ウィスプがスポーン#ノーマル涙／爆発涙／ ブリムストーン攻撃／ ホーミング涙の四種", -- Friendly Ball
    [383] = "ウィスプの涙も分裂可能#ウィスプの分裂した涙は アイザックの攻撃力を 引き継ぐ#破壊時にそれ自身と他の 涙を分裂させる#破壊されるまで有効", -- Tear Detonator
    [386] = "涙が障害物に当たると、 5%の確率でその障害物を リロールする", -- D12
    [396] = "ポータルをウィスプが 周回する", -- Ventricle Razor
    [406] = "ランダムな攻撃力と 連射速度の涙", -- D8
    [421] = "破壊時にチャーム効果の おならを放つ", -- Kidney Bean
    [422] = "前の部屋で破壊された ウィスプが復活する", -- Glowing Hour Glass
    [427] = "部屋をゆっくりと漂い、 アイザックが涙で撃つと 爆発するウィスプ#接触ダメージなし", -- Mine Crafter
    [434] = "青ハエの代わりに ウィスプがスポーン#最大5匹のハエで1つの ウィスプを生成する#消費したハエが多いほど 攻撃力と耐久が増加する", -- Jar of Flies
    [437] = "ウィスプがダメージを 受けた時、一度だけ D7の効果が発動する", -- D7
    [441] = "{{Collectible275}}小さなブリムストーン で攻撃するウィスプ#メガブラスト使用時、 全てのメガブラスト ウィスプも常時発射", -- Mega Blast
    [476] = "複製対象が無い場合、 ウィスプを二つ同時に スポーンする", -- D1
    [477] = "ボイドに取り込んだ アクティブアイテムの ウィスプをスポーン#ボイド自身はウィスプを スポーンしない", -- Void
    [478] = "破壊時に敵と弾を3秒間 停止させる", -- Pause
    [479] = "破壊時に一定確率で トリンケットをスポーン", -- Smelter
    [480] = "ピックアップ破壊時に ウィスプをスポーン#破壊したピックアップの 数が多いほどウィスプの 耐久値が増加する", -- Compost
    [481] = "5%の確率で涙が敵を ランダムなウィスプに 変化させる", -- Dataminer
    [482] = "ランダムなウィスプ", -- Clicker
    [483] = "破壊時に金トロル爆弾を スポーンする", -- Mama Mega!
    [484] = "破壊時に地割れを起こす", -- Wait What?
    [485] = "破壊時に50/50の確率で 他の全てのウィスプを 複製または破壊する", -- Crooked Penny
    [486] = "一定確率でアイザックの ダメージを肩代わりして 消滅する", -- Dull Razor
    [487] = "破壊されない#敵を追いかけ、涙で 自動的に攻撃する#接触ダメージを与えず、 弾をブロックしない", -- Potato Peeler
    [488] = "発動したアイテムに 応じた効果のウィスプが スポーンする", -- Metronome
    [489] = "選択されたダイスの効果に 応じたウィスプがスポーン", -- D Infinity
    [490] = "ランダムなウィスプ#破壊された後、部屋を クリアするとランダムな ウィスプにリスポーン", -- Eden's Soul
    [504] = "高速・自動照準の涙", -- Brown Nugget
    [507] = "ストローでダメージを 与えた時、敵の位置に ウィスプがスポーン", -- Sharp Straw
    [510] = "いずれかの涙：#{{Collectible229}} モンストロの肺#{{Collectible268}} 腐ったベイビー#{{Collectible87}} ロキのツノ#{{Collectible118}} ブリムストーン", -- Delirious
    [515] = "ランダムなウィスプ#破壊された後、部屋を クリアするとランダムな ウィスプにリスポーン", -- Mystery Gift
    [516] = "スプリンクラーの涙", -- Sprinkler
    [521] = "トリプルショットの涙#お店で買い物をすると クーポンのウィスプが 全て破壊される", -- Coupon
    [522] = "捕らえた敵の弾を ウィスプに変換する", -- Telekinesis
    [523] = "中身を展開した時のみ ウィスプをスポーンする#破壊時にランダムな ピックアップをスポーン", -- Moving Box
    [527] = "部屋をクリアした時、 ドア／宝箱の鍵を解除し、 消滅する", -- Mr. ME!
    [536] = "ウィスプを半赤ハートに 変換する#生贄に捧げた後、一つの ウィスプをスポーン", -- Sacrificial Altar
    [545] = "破壊時に友好的なボニーを スポーンする", -- Book of the Dead
    [550] = "涙が10%の確率でママの 踏み潰し攻撃を起こす", -- Broken Shovel
    [552] = "涙が10%の確率でママの 踏み潰し攻撃を起こす", -- Mom's Shovel
    [556] = "短射程のブリムストーン", -- Sulfur
    [557] = "フォーチュンクッキーの ウィスプ一つにつき運+0.2", -- Fortune Cookie
    [578] = "レモン汁を床に垂らし、 敵にダメージを与える", -- Free Lemonade
    [580] = "新しい部屋に入った時、 一定確率で{{Collectible580}}レッドキー 効果が発動", -- Red Key
    [582] = "一つしか保持できない", -- Wavy Cap
    [584] = "特殊効果なし", -- Book of Virtues
    [585] = "中心{{MiddleWisp}}の空いた枠を埋める ウィスプ（最大8）", -- Alabaster Box
    [604] = "投げた障害物の落下地点を 3つのウィスプが周回する", -- Mom's Bracelet
    [609] = "破壊されない#使用時、50%の確率で 全てのエターナルD6 ウィスプが破壊される", -- Eternal D6
    [611] = "チャージ量に応じた 攻撃力と耐久値の ウィスプがスポーン", -- Larynx
    [622] = "全てのウィスプを取り 除き、通常のウィスプを 3つスポーンする", -- Genesis
    [631] = "全てのウィスプを二分割#攻撃力と耐久値は半分に#三回目の分割で消滅", -- Meat Cleaver
    [635] = "人形の位置にウィスプが スポーン（最大6）", -- Stitches
    [638] = "敵の弾で破壊されない#接触した敵にケシゴム 効果を適用し消滅", -- Eraser
    [639] = "部屋クリア時、青ハエを スポーンする", -- Yuck Heart
    [640] = "一定確率で青い炎を放つ", -- Urn of Souls
    [650] = "召喚したベビープラムの 動きをコピーする", -- Plum Flute
    [653] = "幽霊が涙を放つ", -- Vade Retro
    [655] = "回転中のみ現れる", -- Spin to Win
    [685] = "スポーン量2倍+1", -- Jar of Wisps
    [687] = "ランダムなウィスプ", -- Friend Finder
    [705] = "アイテムの効果で倒した 敵一体につきウィスプを 一つスポーン", -- Dark Arts
    [709] = "着地点を3つのウィスプが 周回する", -- Suplex
    [710] = "クラフト時、ランダムな ウィスプをスポーンする", -- Bag of Crafting
    [712] = "アイテムウィスプが ホーミング涙を放つ", -- Lemegeton
    [719] = "", -- Keeper's Box
    [720] = "ランダムなウィスプ", -- Everything Jar
    [722] = "拘束した敵をウィスプが 周回し、自動攻撃する#敵が倒されると消滅", -- Anima Sola
    [723] = "全てのウィスプを同じ タイプのウィスプに リロールする", -- Spindown Dice
    [728] = "全てのウィスプがゲローに 連動する", -- Gello
}

---------- Abyss Locust description parts ----------
EID.descriptions[languageCode].AbyssTexts = {
 	-- values inside {} brackets will be replaced with text parts below
	-- Abyss texts are affected by the PluralizeFunction (ab+ file)
	-- The placeholder therefore can be used in all parts that make up the abyss locust descriptions
	InfoText = "{size}{speed}イナゴ x{amount} （{dmg}）",
	InfoTextPlural = nil, -- Can be used by translators to provide a pluralized version of the InfoText
	Chance = "（確率{1}%）", -- {1} will be replaced with the chance
	SpeedSlow = "遅い", -- Speed < 1
	SpeedFast = "早い", -- Speed > 1
	SpeedDash = "高速", -- Speed >= 6
	SizeSmall = "小型の", -- Size < 1
	SizeBig = "大型の", -- Size > 1
	DamageMult = "攻撃力x{1}のダメージ", -- {1} will be replaced with the calculated damage multiplier 
}

---------- Abyss Locust special effects ----------
--- Special locust effects that dont correspond to TearFlags.
--- Displays an icon in front of the description that shows an item with the same effect
EID.descriptions[languageCode].AbyssLocustEffects = {
[0] = "{{Bomb}} 衝突時に爆発する",
[1] = "{{QuestionMark}} ランダムな効果が発生",
-- 2 = Multiple locusts act like one. Uninteresting info for the player in my opinion
[3] = "{{Collectible285}} 攻撃時に敵をリロールする",
[4] = "{{Collectible35}} 攻撃時にネクロノミコン 効果が発動",
[5] = "{{Collectible638}} 攻撃時にケシゴム効果が 発動し、敵消滅",
[6] = "{{Collectible114}} ナイフを振り回しながら攻撃",
[7] = "{{Collectible611}} 攻撃時にラリンクスの 叫びが発動し、範囲攻撃",
[8] = "{{Collectible399}} 攻撃時にブリムストーンの リングが発生",
[9] = "{{Collectible522}} オーラが敵の弾を跳ね返す",
[10] = "{{Collectible447}} 攻撃時に毒のおならを放つ",
[11] = "{{Collectible447}} 攻撃時におならを放つ",
[12] = "{{Collectible118}} アンチグラビティ型の ブリムストーンが発動",
[13] = "{{Collectible317}} 攻撃時、毒液を床にまき、 触れた敵にダメージ",
[14] = "{{Collectible56}} 攻撃時、尿を床にまき、 触れた敵にダメージ",
[15] = "{{Collectible214}} 攻撃時、血液を床にまき、 触れた敵にダメージ",
[16] = "{{Collectible178}} 攻撃時、聖水を床にまき、 触れた敵にダメージ",
[17] = "{{Collectible420}} 五芒星が浮かび上がり、 触れた敵にダメージ",
[18] = "{{Collectible144}} ピックアップを吸収 するたびダメージ+0.25 （最大25個吸収）",
}


-- list of Tear flag descriptions used for Abyss locust effect description
EID.descriptions[languageCode].TearFlagNames = {
	[0] = "透過",                 -- Ouija board type tear (goes thru obstacles)
    [1] = "貫通",                 -- Cupid's arrow type tear (goes thru enemy)
    [2] = "ホーミング",                   -- Spoon bender type tear (homes to enemy)
    [3] = "スロー付与",                  -- Spider bite type tear (slows on contact)
    [4] = "毒を付与",                   -- Common cold type tear (poisons on contact)
    [5] = "敵を石化",                  -- Mom's contact type tear (freezes on contact)
    [6] = "分裂",                    -- Parasite type tear (splits on collision)
    [7] = "飛距離に応じて膨らむ",            -- Lump of coal type tear (grows by range)
    [8] = "ブーメラン涙",                -- My reflection type tear (returns back)
    [9] = "減衰して貫通",               -- Polyphemus type tear (Damages the entity and if the damage is more then enemy hp it continues with less damage
    [10] = "波打ち移動",         -- Wiggle worm type tear (wiggles)
    [11] = "攻撃時にハエをスポーン",        -- Mulligan type tear (creates fly on hit)
    [12] = "爆発涙 {{Collectible149}}",               -- IPECAC type tear (explodes on hit)
    [13] = "チャーム付与",                -- Mom's Eyeshadow tear
    [14] = "混乱を付与",               -- Iron Bar tear
    [15] = "敵を倒すとハートを スポーン",     -- These tears cause enemy to drop hearts if killed (33% chance)
    [16] = "アイザックを周回",     -- Used for Little Planet (orbit arounds the player)
    [17] = "アンチグラビティ効果",     	      -- Anti gravity type tear (floats in place for some time before finally moving) (unset after first update)
    [18] = "衝突時に4分裂",     -- Splits into 4 smaller tears if it hits the ground
    [19] = "衝突時に跳ね返る",       -- Bounce off of enemies, walls, rocks (Higher priority than PERSISTENT & PIERCING)
    [20] = "恐怖を付与",                    -- Mom's Perfume type tear of fear (fear on contact)
    [21] = "飛距離に応じて縮む",                  -- Proptosis tears start large and shrink
    [22] = "火傷を付与",                    -- Fire Mind tears cause Burn effect on enemies
    [23] = "敵とピックアップを 吸い寄せる", -- Attracts enemies and pickups
    [24] = "ノックバック効果",               -- Tear impact pushes enemies back further
    [25] = "拡縮しながら移動",               -- Makes the tear pulse
    [26] = "渦巻状に飛ぶ",         -- Makes the tear path spiral
    [27] = "楕円型",              -- Makes the tear oval in the direction of travel
    [28] = "サッド ボム",                -- Used by Bombs (Sad Bomb)
    [29] = "ケツ爆弾",               -- Used by Bombs (Butt Bomb)
    [30] = "矩形波",         -- Used for Hook Worm
    [31] = "オーラを放ちダメージ",     -- Used for GodHead (they will have a glow around them)
    [32] = "スロー付与", -- Used for Gish player tears (to color enemy black on slowing)
    [33] = "攻撃時、毒液を床にまく", -- Mysterious Liquid tears spawn damaging green creep when hit
    [34] = "敵の弾をブロック",                -- Lost Contact tears, block enemy projectiles
    [35] = "キラキラボム",            -- Used by Bombs (Glitter Bomb)
    [36] = "拡散ボム",            -- Used for Scatter bombs
    [37] = "粘着",                  -- Used for Sticky bombs and Explosivo tears
    [38] = "画面端ループ",     -- Tears loop around the screen
    [39] = "攻撃時、光線が降り注ぐ", -- Create damaging light beam on hit
    [40] = "攻撃時にコインがスポーン",        -- Used by Bumbo, spawns a coin when tear hits
    [41] = "敵を倒すと黒ハートを スポーン",    -- Enemy drops a black hp when dies
    [42] = "トラクタービーム",            -- Tear with this flag will follow parent player's beam
    [43] = "敵を収縮させる",          -- God's flesh flag to minimize enemies
    [44] = "攻撃時にコインがスポーン",      -- Greed coin tears that has a chance to generate a coin when hit
    [45] = "ボンバーボーイ",              -- Bomber Boy
    [46] = "渦巻状に飛ぶ",     -- Ouroboros Worm, big radius oscilating tears
    [47] = "混乱を付与",   -- Glaucoma tears, permanently confuses enemies
    [48] = "敵にくっつく",                  -- Booger tears, stick and do damage over time
    [49] = "攻撃時にハエ／クモをスポーン",               -- Egg tears, leave creep and spawns spiders or flies
    [50] = "障害物を破壊",            -- Sulfuric Acid tears, can break grid entities
    [51] = "攻撃時、骨が飛び散る",                    -- Bone tears, splits in 2
    [52] = "貫通・2倍ダメージ・ホーミング", -- Belial tears, piecing tears gets double damage + homing
    [53] = "敵を黄金化",           -- Midas touch tears
    [54] = "10発の涙を拡散",                -- Needle tears
    [55] = "攻撃時に放電",           -- Jacobs ladder tears
    [56] = "ビッグホーンを召喚", -- Little Horn tears
    [57] = "攻撃時に放電",   -- Technology Zero
    [58] = "互いに反発",        -- Pop!
    [59] = "吸収する",               -- Hungry Tears
    [60] = "攻撃時、光線が降り注ぐ",               -- Trisagion, generates a laser on top of the tear
    [61] = "床を跳ねる",          -- Flat Stone
    [62] = "はじけ散る",             -- Haemolacria
    [63] = "毒液をまく",             -- Bob's Bladder
    [64] = "ノックバック効果",     -- Knockout Drops
    [65] = "倒した敵を凍結",   -- Uranus
    [66] = "敵とピックアップを 吸い寄せる", -- Lodestone
    [67] = "敵を標的化させる",       -- Rotten Tomato
    [68] = "オカルトの目",       -- Eye of the Occult
    [69] = "アイザックを周回",   -- Orbiting tears with a more narrow and stable orbit (used by Saturnus and Immaculate Heart)
    [70] = "岩を破壊する",             -- Rock tears, chance to break rocks, deal extra damage to rock type enemies
    [71] = "90度ターンして敵に向かう",      -- Brain Worm, tears turn and go horizontally when moving past an enemy
    [72] = "ブラッド ボム",              -- Blood Bombs, leave blood creep on the ground
    [73] = "敵をうんちにする",    -- E. Coli tears, turn enemies into poop
    [74] = "倒した敵がコインを落とす",      -- Killed enemies have a chance to drop a random coin (Reverse Hanged Man)
    [75] = "ブリムストーン ボム",          -- Brimstone Bombs, explosion creates a brimstone cross
    [76] = "攻撃時、ブラックホールが 発生",       -- Rift tears, creates a black hole on impact
    [77] = "胞子が拡散する",  -- Spore tears, stick to enemies and multiply on enemy death
    [78] = "ゴースト ボム",              -- Ghost bombs
    [79] = "倒した敵がカードを落とす",      -- Killed enemies will drop a random tarot card
    [80] = "倒した敵がルーンを落とす",      -- Killed enemies will drop a random rune
    [81] = "敵をテレポートさせる",   -- Hit enemies will teleport to a different part of the room
    [82] = "時間経過で減速",    -- Decelerate over time
    [83] = "時間経過で加速",    -- Accelerate over time
    [104] = "壁で跳ね返る",    -- Similar to TEAR_BOUNCE but only bounces off walls, not enemies
	[106] = "敵を出血状態にする",   -- Deals extra damage from behind and inflicts bleeding
}

-- Special Locust effects when Item was eaten by Abyss. Entries here will override the auto-generated descriptions
-- Kept in for backwards compatibility
EID.descriptions[languageCode].abyssSynergies = {}

-- Effect of Car battery on Active Items
local repCarBattery = {
	[34] = {2, 3}, -- The Book of Belial
	[59] = {2, 3}, -- The Book of Belial (Birthright)
	[83] = {"黒ハートを{{BlinkYellowGreen}}1個{{CR}}付与する#その部屋に居る間：#↑ 攻撃力　 {{BlinkYellowGreen}}+4{{CR}}#↓ 移動速度 -0.18#毎秒40の接触ダメージ 効果を得る#障害物を破壊できる"}, -- The Nail
	[263] = "2回発動する", -- Clear Rune
	[283] = "二重リロールでアイテム プールの枯渇が加速するも、 変身の条件達成にはプラス", -- D100
	[285] = "二段階弱くする", -- D10
	[288] = {"4～8匹", "8～16匹"}, --Box of Spiders
	[293] = {200, 400}, -- Head of Krampus
	[296] = {"1個", "2個", "1個", "2個"}, -- Converter
	[323] = "ダメージ2倍", -- Isaac's Tears
	[386] = "レアな障害物の確率アップ", -- D12
	[485] = "25%の確率で4倍複製 75%の確率で消滅", -- Crooked Penny
	[489] = "二種類の効果を同時発動 ※二番目の効果は　　　 シード値で固定", -- D Infinity
	[522] = {"3秒間", "7秒間", "3秒", "7秒"}, --Telekinesis
	[557] = {"おみくじ・青ハート・ カード・トリンケットの いずれかを{{BlinkYellowGreen}}2個{{CR}}スポーンする"}, -- Fortune Cookie
	[582] = {"+0.75", "+1.5", "-0.03", "{{BlinkYellowRed}}-0.06{{CR}}"}, -- Wavy Cap
	[584] = "スポーン数2倍", -- Book of Virtues
	[605] = {"部屋を飛び回る目玉を {{BlinkYellowGreen}}2匹{{CR}}召喚する#目玉は接触ダメージを 与え、弾をブロックし、 ダメージ性の血痕を残す#↑ 右目の攻撃力 +34%"}, -- The Scooper
	[609] = {"部屋の全てのアイテムを {{BlinkYellowRed}}2回{{CR}}リロールする#リロール時、{{BlinkYellowRed}}51%{{CR}}の確率で アイテムが消滅する"}, -- Eternal D6
	[611] = "1チャージ分の追加効果", -- Larynx
	[625] = {"30秒間","60秒間"}, -- Mega Mush
	[631] = {25, 50}, -- Meat Cleaver
	[635] = "2回発動する", --Stitches
	[639] = {"1個", "2個"}, -- Yuck Heart
	[642] = {"その部屋のアイテムプール から、アイテムを{{BlinkYellowGreen}}二つ{{CR}}生成#最大体力{{BlinkYellowGreen}}2{{CR}}か骨ハート{{BlinkYellowGreen}}2個{{CR}}、 または青／黒ハート{{BlinkYellowGreen}}4個{{CR}}を、 壊れたハート{{BlinkYellowGreen}}2個{{CR}}に変換#消費優先順位は赤＞骨＞青#使用後にこれを手放すと、 スポーンするアイテムが 一定確率でこれに置き換え られるようになる#確率は1回の使用で33%、 2回で50%、3回以上で100%#現フロアのどこかにこの アイテムが存在する場合、 置き換え確率が低下する#{{Warning}} ロスト使用時は使い切り、 置き換え効果なし"}, -- Magic Skin
	[650] = {"ベビープラムが{{BlinkYellowGreen}}2体{{CR}}召喚され、 10秒間敵と戦う"}, -- Plum Flute
	[685] = "スポーン数2倍", -- Jar of Wisps
	[687] = {"アイザックの移動と攻撃を 模倣する、チャーム状態の ランダムな敵を{{BlinkYellowGreen}}2匹{{CR}}スポーン"}, -- Friend Finder
	[704] = "バーサーカー効果が 10秒間に延長されるが、 持続時間が延長する 効果は最初の5秒間のみ", -- Berserk!
	[705] = {"1秒間", "2秒間"}, -- Dark Arts
	[712] = "スポーン数2倍", -- Lemegeton
	[713] = "ハート1個を消費し、 2体の血餅をスポーン", -- Sumptorium
	[719] = {"ランダムなお店の商品を {{BlinkYellowGreen}}二つ{{CR}}スポーンする（有料）"}, -- Keeper's Box
	[720] = "同時にうんちをスポーン", -- Everything Jar
	[722] = {"{{BlinkYellowGreen}}2匹{{CR}}の敵を鎖で拘束し、 5秒間行動不能にする#敵が1匹のみの場合、 {{BlinkYellowGreen}}10秒間{{CR}}行動不能にする"}, --Anima Sola
	[723] = {"1つ","2つ"}, -- Spindown Dice
}
EID:updateDescriptionsViaTable(repCarBattery, EID.descriptions[languageCode].carBattery)

-- Effect of BFFS!/Hive Mind on Familiars
local repBFFSSynergies = {
	["5.100.67"] = {6, 12}, -- Sister Maggy
	["5.100.98"] = {"7～8", "6"}, -- The Relic
	["5.100.107"] = {23.5, 47}, -- The Pinking Shears
	["5.100.172"] = {112.5, 225}, -- Sacrificial Dagger
	["5.100.178"] = {7, 14, "衝突地点に青い炎を残す"}, -- Holy Water
	["5.100.206"] = {56, 112}, -- Guillotine
	["5.100.264"] = {6.5, 13}, -- Smart Fly
	["5.100.272"] = {100, 125}, -- BBF
	["5.100.273"] = {100, 125}, -- Bob's Brain
	["5.100.274"] = {150, 300}, -- Best Bud
	["5.100.275"] = {24, 48}, -- Lil Brimstone
	["5.100.276"] = "ランダムな方向に 追加の涙を発射し、 大きな血だまりを残す", -- Isaac's Heart
	["5.100.319"] = {75, 150}, -- Cain's Other Eye
	["5.100.320"] = {15, 30}, -- ???'s Only Friend
	["5.100.360"] = {75, 150, 100, 200}, -- Incubus (+ Lilith exception)
	["5.100.365"] = {30, 60}, -- Lost Fly
	["5.100.384"] = {"5～20", "10～40"}, -- Lil Gurdy
	["5.100.389"] = {"7～8", "6"}, -- Rune Bag
	["5.100.467"] = {0.1, 0.2}, -- Finger!
	["5.100.468"] = {75, 150}, -- Shade
	["5.100.491"] = {"7", "6"}, -- Acid Baby
	["5.100.500"] = {"7～8", "6"}, -- Sack of Sacks
	["5.100.504"] = {3.5, 7}, -- Brown Nugget
	["5.100.508"] = {1.5, 3}, -- Mom's Razor
	["5.100.509"] = {3.5, 7, 20, 40}, -- Bloodshot Eye
	
	["5.100.565"] = "通常時のダメージ2倍", -- Blood Puppy
	["5.100.569"] = "発動時、ハート2個分の ボーナスを追加", -- Blood Oath
--  ["5.100.575"] = {1.5, 3}, -- The Intruder
	["5.100.581"] = {15, 30}, -- Psy Fly
	["5.100.584"] = "ウィスプのダメージ2倍", -- Book of Virtues
	["5.100.605"] = {36, 72}, -- The Scooper
	["5.100.607"] = {3.5, 7, 5.25, 10.5}, -- Boiled Baby
--  ["5.100.608"] = {3.5, 7}, -- Freezer Baby
	["5.100.610"] = {45, 90, "地割れがｘ型に拡大"}, -- Bird Cage
	["5.100.612"] = "ロストソウルに 聖なるマントの効果を付与", -- Lost Soul
--  ["5.100.626"] = {25, 50}, -- Knife Piece 1
	["5.100.627"] = {25, 50}, -- Knife Piece 2
	["5.100.629"] = {3, 6}, -- Bot Fly
	["5.100.635"] = "使用時、元の位置から 8発の涙を発射する", -- Stitches
--  ["5.100.645"] = {3.5, 7}, -- Tinytoma
	["5.100.649"] = {3, 6, 6, 12}, -- Fruity Plum
	["5.100.650"] = "接触ダメージ2倍", -- Plum Flute
	["5.100.652"] = {17.5, 35}, -- Cube Baby
	["5.100.655"] = {10.5, 21, "使用中、ベストフレンドの ボーナス効果無効"}, -- Spin to Win
	["5.100.679"] = {52.5, 105}, -- Lil Abaddon
	["5.100.681"] = "ダメージ2倍", -- Lil Portal
	["5.100.682"] = {8, 16}, -- Worm Friend
	["5.100.685"] = "ウィスプのダメージ2倍", -- Jar of Wisps
	["5.100.698"] = {0.375, 0.75}, -- Twisted Pair
	["5.100.702"] = "ウィスプのダメージ2倍", -- Vengeful Spirit
	["5.100.706"] = "イナゴのダメージ+25%", -- Abyss
	["5.100.712"] = "接触ダメージ2倍", -- Lemegeton
	["5.100.713"] = "血餅のダメージ2倍", -- Sumptorium
	["5.100.728"] = {75, 150, 100, 200}, -- Gello (+ Lilith exception)
	
	["5.300.96"] = "ウィスプのダメージ2倍", -- Soul of Bethany
	["5.350.142"] = "ウィスプのダメージ2倍", -- Beth's Faith
	["5.350.182"] = "ウィスプのダメージ2倍", -- Beth's Essence
	["5.350.176"] = "血餅のダメージ2倍", -- Lil Clot
	["5.350.186"] = "イナゴのダメージ+25%", -- Apollyon's Best Friend
	["Tainted Lilith"] = "ゲローの涙ダメージ2倍", -- Gello (for BFFS pedestal)
}
EID:updateDescriptionsViaTable(repBFFSSynergies, EID.descriptions[languageCode].BFFSSynergies)

---------- Trinkets ----------

local repTrinkets={
    [10] = {"10", "ウィグル ワーム", "涙が波打つように飛ぶ#↑ 連射速度 +0.4#涙に透過効果を付与"}, -- Wiggle Worm
    [11] = {"11", "リング ワーム", "涙がらせん状に飛ぶ#↑ 連射速度 +0.47#涙に透過効果を付与"}, -- Ring Worm
    [15] = {"15", "ラッキー ロック", "岩や障害物を壊すと、 33%の確率でコインが スポーン"},-- Lucky Rock
    [16] = {"16", "ママの足のつめ", "20秒おきにランダムな 位置にママの踏み潰し 攻撃が発生する"}, -- Mom's Toenail
    [24] = {"24", "バット ペニー", "コインを拾うとおならが 出て、敵をノックバック させ、毒状態にする#うんちからコインが スポーンする確率 +20%"}, -- Butt Penny
    [26] = {"26", "フックワーム", "涙が矩形波のように飛ぶ#↑ 連射速度 +0.4#↑ 射程　　 +1.5#涙に透過効果を付与"}, -- Hook Worm
    [32] = {"32", "リバティーキャップ", "部屋に入るたび、25%の 確率でいずれかの効果を 付与：#{{Collectible71}} ミニ マッシュ#{{Collectible12}} 魔法のキノコ#{{Collectible120}} 変なキノコ#{{Collectible121}} 変なキノコ#{{Collectible342}} 青い帽子#{{Collectible398}} 神々の肉"}, -- Liberty Cap
    [33] = {"33", "へそのお", "{{Collectible100}} 体力が半赤ハート以下の時、 リトルスティーブンを付与#{{Collectible318}} ダメージを受けるたび30%の 確率でふたご座の使い魔が その部屋にスポーン （運でスポーン確率アップ）"}, -- Umbilical Cord
    [39] = {"39", "癌", "↑ 連射速度 +1"},
    [48] = {"48", "失くしたページ", "ネクロノミコン効果 （黒ハートなど）の ダメージ量を2倍にする#ダメージを受けた時、 ネクロノミコン効果が 一定確率で発動する （全ての敵に80ダメージ）#確率：運0=5%、60=50%"}, -- A Missing Page
    [49] = {"49", "血まみれのペニー", "コイン取得時、25%の 確率で半赤ハートが スポーン"}, -- Bloody Penny
    [50] = {"50", "燃え尽きたペニー", "コイン取得時、25%の 確率で爆弾がスポーン"}, -- Burnt Penny
    [51] = {"51", "平らなペニー", "コイン取得時、25%の 確率で鍵がスポーン"}, -- Flat Penny
    [65] = {"65", "さなだワーム", "↑ 射程 +3"}, -- Tape Worm
    [66] = {"66", "なまけワーム", "↓ 弾速 -0.5"}, -- Lazy Worm
    [67] = {"67", "割れたダイス", "ダメージを受けた時、 D6／8／10／12／20 いずれかの効果が 50%の確率で発動"}, -- Cracked Dice
    [69] = {"69", "消えかけインスタント写真", "アイザックが時々透明に なり、敵を混乱させる#ポラロイド・ネガティブの 代わりに奇妙なドアを開く"}, -- Faded Polaroid
    [80] = {"80", "漆黒の羽根", "↑ 所持する悪魔タイプの アイテム・トリンケット 1個につき攻撃力 +0.5"}, -- Black Feather
    [92] = {"92", "ひびが入った冠", "↑ アイテムやトリンケット からのステータス上昇値を 20%アップさせる"}, -- Cracked Crown
    [96] = {"96", "ウロボロスワーム", "涙が渦を描くように飛ぶ#涙に透過効果を付与#↑ 連射速度 +0.4#↑ 射程　　 +1.5#一定確率でホーミング効果"}, -- Ouroboros Worm
    [98] = {"98", "ノーズ ゴブリン", "攻撃中、10%の確率で ホーミング効果付きの 鼻くそが飛び、敵に 10秒間くっ付く#鼻くそは攻撃力と等しい ダメージを毎秒与える"},
    [101] = {"101", "ほの暗い電球", "!!! アクティブアイテムの チャージが空の時：#↑ 攻撃力　 +1.5#↑ 移動速度 +0.5#↑ 射程　　 +1.5#↑ 連射速度 +0.5#↑ 弾速　　 +0.3#↑ 運　　　 +2"},
    [107] = {"107", "クロウハート", "ダメージを受ける時、 赤ハートが優先して 消費される　　#!!! この効果で赤ハートに ダメージを受けた場合、 悪魔部屋／天使部屋の 出現率は通常通り減少"}, -- Crow Heart
    [110] = {"110", "シルバーダラー", "保持して子宮／傷だらけの 子宮／ユテロ／コープスの フロアに移動すると、お店 が生成される"},
    [111] = {"111", "血まみれな冠", "保持して子宮／傷だらけの 子宮／ユテロ／コープスの フロアに移動すると、トレ ジャールームが生成される"}, -- Bloody Crown
    [119] = {"119", "幹細胞", "フロア移動時、空の赤／骨 ハートの50%を回復する#端数は切り捨てるが、最低 でも半赤ハートは回復する"}, -- Stem Cell
    [125] = {"125", "延長コード", "アイザックと使い魔の間に 電気ビームが発生し、敵に 6ダメージを与える#ヤコブ＆エサウなどの複数 操作キャラクターや、協力 モード時は、キャラ間にも 電気ビームが発生する"}, -- Extension Cord
    [128] = {"128", "指のホネ", "ダメージを受けた時、4%の 確率で骨ハートを付与"}, -- Finger Bone
    [129] = {"129", "ジョウブレイカー", "10%の確率で涙が歯に 置き換わる#歯は攻撃力ｘ3.2の ダメージを与える#確率は運9で最大100%に"}, -- Jawbreaker
    [130] = {"130", "噛み跡のあるペン", "10%の確率で涙にスロー 効果を付与する#確率は運18で最大100%に"}, -- Chewed Pen
    [131] = {"131", "幸運のペニー", "コイン取得時、17%の確率で 半青ハートをスポーンする#高額コインほど高確率"}, -- Blessed Penny
    [132] = {"132", "壊れた注射器", "部屋に入った時、25%の 確率でランダムな注射器 タイプのアイテム効果が 付与される"}, -- Broken Syringe
    [133] = {"133", "ショート ヒューズ", "設置した爆弾が起爆する までの時間が、1.5秒から 0.66秒に短縮される"}, -- Short Fuse
    [134] = {"134", "ギガ豆", "おならの範囲が広がる#敵のおなら・キノコの 毒ガスにも有効"}, -- Gigante Bean
    [135] = {"135", "ライター", "部屋に入った時、20%の 確率で敵を火傷にする#確率は運40で最大100%に"}, -- A Lighter
    [136] = {"136", "壊れた南京錠", "ドア・キーブロック・ 宝箱を爆発で開ける"}, -- Broken Padlock
    [137] = {"137", "ミュオソティス", "保持して次のフロアに 移動すると、フロアの 開始時、前のフロアに 残されたピックアップ・ トリンケットを最大4つ ランダムにスポーンする"}, -- Myosotis
    [138] = {"138", "'M", "アクティブアイテムを 使用すると、別の アクティブアイテムに リロールされる"}, -- 'M
    [139] = {"139", "涙のお守り", "運で発生確率が変動する タイプの涙は、運+4相当 に発生確率がアップする"}, -- Teardrop Charm
    [140] = {"140", "ソドムのリンゴ", "赤ハートを拾った時、 50%の確率で青クモが スポーンする#スポーンした場合、 体力は回復しない#体力全快の状態でも 赤ハートを取得でき、 その場合は、100%の 確率でスポーンする"}, -- Apple of Sodom
    [141] = {"141", "忘れられた子守唄", "使い魔の連射速度が 2倍になる"}, -- Forgotten Lullaby
    [142] = {"142", "ベタニアの信念", "{{Collectible584}} 毎フロア開始時、 美徳の書ウィスプが 4つスポーンする"}, -- Beth's Faith
    [143] = {"143", "オールド キャパシタ", "アクティブアイテムが 部屋クリア時にチャージ されなくなる代わりに、 20%の確率で報酬に電池が 追加される#確率は運4.34で最大33%に"}, -- Old Capacitor
    [144] = {"144", "ブレイン ワーム", "外れた涙が90度ターンして 敵に向かう"}, -- Brain Worm
    [145] = {"145", "パーフェクション", "↑ 運 +10#ダメージを受けると消滅"}, -- Perfection
    [146] = {"146", "悪魔の王冠", "トレジャールームの アイテムが悪魔取引に 置き換わる"}, -- Devil's Crown
    [147] = {"147", "充電済みのペニー", "コイン取得時、17%の確率で アクティブアイテムが 1チャージされる#高額コインほど高確率"}, -- Charged Penny
    [148] = {"148", "友情のネックレス", "追従タイプの使い魔が アイザックを周回する ようになる"}, -- Friendship Necklace
    [149] = {"149", "パニック ボタン", "ダメージを受ける直前に アクティブアイテムの 効果が自動的に発動する#フルチャージされている 時のみ発動する"}, -- Panic Button
    [150] = {"150", "ブルー キー", "鍵を消費せずにドアを 開くことができる#鍵付きのドアを通ると、 二部屋の中間のように 機能する青い部屋に 移動する#青い部屋は出ると消滅し、 ドアは通常の挙動に戻る"}, -- Blue Key
    [151] = {"151", "フラット ファイル", "ドア・床・岩・宝箱・ 敵からトゲを取り除き、 無害化する"}, -- Flat File
    [152] = {"152", "望遠鏡レンズ", "プラネタリウムの出現率+9%#プラネタリウムに未訪問の 場合、追加で+15%#子宮／コープスフロアでも プラネタリウムが出現可能に"}, -- Telescope Lens
    [153] = {"153", "ママの髪束", "部屋に入った時、25%の 確率でランダムなママ 関連アイテムの効果が 付与される"}, -- Mom's Lock
    [154] = {"154", "ダイス バッグ", "新しい部屋に入った時、 50%の確率でランダムな ダイス系のアイテムが 消耗品スロットに追加 され、カード／ピルの ように使用できる#ダイスが追加されても、 保持中のカード／ピルは そのまま保持される#ダイスは部屋を出ると 消滅する"}, -- Dice Bag
    [155] = {"155", "ホーリー クラウン", "保持して大聖堂に 移動すると、お店と トレジャールームが 生成される"}, -- Holy Crown
    [156] = {"156", "マザーズ キス", "保持中、最大体力 +1#キーパーでも有効"}, -- Mother's Kiss
    [157] = {"157", "破れたカード", "攻撃中、15発ごとに 非常に長い射程を持つ {{Collectible5}}リフレクション状態の {{Collectible149}}吐き気薬が発射される"}, -- Torn Card
    [158] = {"158", "破れたポケット", "ダメージを受けると、 所持するコイン・鍵・ 爆弾のいずれか2個を ドロップする#ドロップされるピック アップは、別の種類に 置き換わる可能性がある (爆弾→金爆弾など)"}, -- Torn Pocket
    [159] = {"159", "ギルディング キー", "初回取得時、鍵 +1#保持中にスポーンした 宝箱を、金宝箱に置き 換える#金宝箱のランダムな ピックアップ内容に、 カードとトリンケット、 ピルを加える"}, -- Gilded Key
    [160] = {"160", "ラッキー サック", "フロア開始時、サックが スポーン"}, -- Lucky Sack
    [161] = {"161", "ウィキッド クラウン", "保持してシェオルに 移動すると、お店と トレジャールームが 生成される"}, -- Wicked Crown
    [162] = {"162", "アザゼルのカケラ", "部屋をクリアした時、 33%の確率でアザゼルに 変身する#変身効果は次の部屋を クリアしたあと、別の 部屋に移動すると解除"}, -- Azazel's Stump
    [163] = {"163", "ディングル ベリー", "敵のうんちが味方になる#部屋をクリアした時、 ランダムな味方の うんちを1匹スポーン"}, -- Dingle Berry
    [164] = {"164", "リング キャップ", "爆弾を1個余分に設置 できる（追加消費なし）"}, -- Ring Cap
    [165] = {"165", "Nuh Uh!", "スポーンするコインと 鍵が、チャプター4以降、 爆弾・ハート・カード・ ピル・トリンケット・ 電池・ハエのいずれかに 置き換わる"}, -- Nuh Uh!
    [166] = {"166", "モデリング クレイ", "部屋に入った時、50%の 確率でランダムな パッシブアイテムの 効果が付与される"}, -- Modeling Clay
    [167] = {"167", "磨かれたホネ", "部屋をクリアした時、 25%の確率で友好的な ボニーがスポーンする#確率は運51で最大50%に"}, -- Polished Bone
    [168] = {"168", "ホロウ ハート", "フロア開始時、1個の 骨ハートを付与"}, -- Hollow Heart
    [169] = {"169", "こどものお絵描き", "保持中、{{Guppy}} ガッピーの 変身に必要なアイテムの 1つとして機能する"}, -- Kid's Drawing
    [170] = {"170", "クリスタル キー", "部屋をクリアした時、 33%の確率で{{Collectible580}}レッド キーの効果が発動し、 赤い部屋が生成される#赤い部屋では効果の 発動確率が低下する"}, -- Crystal Key
    [171] = {"171", "キーパーズ バーゲン", "悪魔取引のコストが、 50%の確率でハートから コインに置き換わる"}, -- Keeper's Bargain
    [172] = {"172", "呪われたペニー", "コイン取得時、ランダムな 部屋にテレポートする#隠し部屋にもテレポート できる"}, -- Cursed Penny
    [173] = {"173", "ユア ソウル", "悪魔取引を一度だけ 無料にする#取引後に消滅する"}, -- Your Soul
    [174] = {"174", "ナンバー マグネット", "悪魔部屋の出現率 +10%#クランプスが悪魔部屋に 現れなくなる#悪魔部屋が特別な構成に 置き換わり、アイテムや 黒ハート、敵が増加する"}, -- Number Magnet
    [175] = {"175", "ストレンジ キー", "時間制限を過ぎていても ハッシュに挑める#{{Collectible297}} パンドラの箱を使うと 一緒に消費され、通常 効果の代わりに以下の 効果が発生する#ランダムなプールから 6個のアイテムをスポーン"}, -- Strange Key
    [176] = {"176", "リトル クロット", "血餅の使い魔が現れ、 アイザックの動きと 涙をコピーする#涙は攻撃力ｘ0.35の ダメージを与える#血餅は3回のダメージを 受けると消滅し、新しい 部屋に入るとリスポーン する"}, -- Lil Clot
    [177] = {"177", "タトゥーシール", "チャレンジルームの クリア報酬に宝箱が 追加される#ボスチャレンジルームの クリア報酬にボス部屋の アイテムが追加される"}, -- Temporary Tattoo
    [178] = {"178", "飲み込んだＭ８０", "ダメージを受けると 50%の確率で自爆が起き、 敵に185のダメージを 与える　　　"}, -- Swallowed M80
    [179] = {"179", "ＲＣリモート", "使い魔がアイザックの 動きに連動して移動する ようになる#ドロップボタン押下中、 使い魔は動きを停止する#※ヤコブ＆エサウと同じ 制御方法"}, -- RC Remote
    [180] = {"180", "ファウンド ソウル", "アイザックの動きを コピーし、透過効果 付きの涙で攻撃する 幽霊の使い魔が現れる#幽霊はアイザックの ステータスをコピーする （攻撃力のみ0.5倍）#幽霊は一撃で死ぬが、 次のフロアで復活する#幽霊はアイザックの持つ パッシブ／アクティブ アイテムの効果をコピー する#ドロップボタン押下中、 幽霊は動きを停止する#※ヤコブ＆エサウと同じ  制御方法"}, -- Found Soul
    [181] = {"181", "拡張パック", "アクティブアイテムを 使用すると、追加で ランダムなアクティブ アイテムの効果が発動 する　　　　#追加されるアイテムは チャージ容量が1～2の ものに限られる"}, -- Expansion Pack
    [182] = {"182", "ベタニアのエッセンス", "天使部屋に入った時、 ウィスプが5つスポーン#乞食に寄付すると、 25%の確率でウィスプが スポーン"}, -- Beth's Essence
    [183] = {"183", "ザ ツインズ", "部屋に入った時、50%の 確率で使い魔を1つ複製する#使い魔が居ない場合、 {{Collectible8}}ブラザーボビーか {{Collectible67}}シスターマギーを付与"}, -- The Twins
    [184] = {"184", "養子縁組届書", "保持して未訪問のお店に 入ると、お店アイテムが 使い魔アイテムに置き換わる#保持中、使い魔アイテムの 価格を10コインに割り引く"}, -- Adoption Papers
    [185] = {"185", "コオロギの脚", "敵を倒した時、17%の 確率でイナゴがスポーン"}, -- Cricket Leg
    [186] = {"186", "アポリオンの親友", "1匹の{{Collectible706}}アビスイナゴを 付与する"}, -- Apollyon's Best Friend
    [187] = {"187", "壊れたメガネ", "トレジャールームに 50%の確率でブラインド アイテムが追加される#代替ルートの追加の ブラインドアイテムが、 50%の確率で公開状態になる"}, -- Broken Glasses
    [188] = {"188", "アイス キューブ", "部屋に入った時、20%の 確率で敵が石化する#石化状態の敵は 倒されると凍結する#確率は運40で最大100%に"}, -- Ice Cube
    [189] = {"189", "バフォメットの魔法陣", "敵を倒すと、ダメージを 無効化するシールドが 1秒間付与される#シールド展開中に別の 敵を倒すと、効果時間が 1秒延長する"}, -- Sigil of Baphomet
}
EID:updateDescriptionsViaTable(repTrinkets, EID.descriptions[languageCode].trinkets)

EID.descriptions[languageCode].goldenTrinket = "効果2倍！"
EID.descriptions[languageCode].tripledTrinket = "効果3倍！"
EID.descriptions[languageCode].quadrupledTrinket = "効果4倍！"

-- 効果が2倍や3倍になるトリンケットは、その説明文に書かれている数字が倍増して表示されます
-- いくつかのトリンケットは、Mom's Box やゴールデンバージョンによって効果が全く変わってしまうようなケースがあります
EID.descriptions[languageCode].goldenTrinketEffects = {
	-- Broken Remote ：全文置換(ゴールデン効果：Teleport 2.0)
	[4] = { "{{Collectible419}} アクティブアイテムを 使用した時、{{ColorGold}}未探索{{CR}}の 部屋にテレポート#優先順位: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}{{BossRushRoom}}>{{IsaacsRoom}}{{BarrenRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{Planetarium}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}>{{ErrorRoom}}"}, -- Teleport 2.0
	-- Broken Magnet (検索・置換): 一番目の文字列を説明文から検索し、二番目の文字列に置換する（ゴールデン効果）
	[6] = { "コイン", "ピックアップ" },
	-- Rosary Bead append：追加効果
	[7] = { "{{Collectible72}} ロザリーを全ての アイテムプールに追加" },
	-- Golden Store Credit: 全文置換（ゴールデン効果）
	[13] = { "{{Shop}} {{ColorGold}}お店のアイテムが 全て無料になる#アイテムを買う時、 25%の確率で通常の {{Trinket13}}商品券に変化する" },
	-- Lucky Rock：追加 (ゴールデン / Mom's Box / 両方)
	[15] = { "最大2枚スポーン", "最大2枚スポーン", "最大3枚スポーン" },
	-- Golden Mysterious Candy makes Golden Poop (検索・置換): 一番目の文字列を説明文から検索し、二番目の文字列に置換する（ゴールデン効果）
	[25] = { "うんち", "金のうんち" },
    -- Isaac's Fork (検索・置換): 一番目の文字列を説明文から検索し、ダブル効果は二番目、トリプル効果は三番目の文字列に置換する
    [46] = { "半赤ハート", "赤ハート1個", "赤ハート1.5個" },
    -- Tick (置換): 全文置換する 一行目：ゴールデン / 二行目：Mom's Box 保持中 / 三行目：両方, ゴールデンの効果は取り外し可能になること
    [53] = {
   	 "ボスのHPが{{ColorGold}}30{{CR}}%減少#ボス部屋に入った時、 赤ハート{{ColorGold}}2{{CR}}個回復#{{ColorGold}}取り外せる！",
   	 "ボスのHPが{{ColorGold}}30{{CR}}%減少#ボス部屋に入った時、 赤ハート{{ColorGold}}2{{CR}}個回復#!!! 取得すると取り外せない#{{Trinket41}}マッチ棒で除去可能",
   	 "ボスのHPが{{ColorGold}}30{{CR}}%減少#ボス部屋に入った時、 赤ハート{{ColorGold}}3{{CR}}個回復#{{ColorGold}}取り外せる！",
    },
    -- Rainbow Worm (追加): 積み重ねる数に応じて、ステータス効果が倍増する。ノーマル2個・ゴールデン1個は2倍、Mom's Box+ノーマルは3倍、Mom's Box+ゴールデンは4倍
    [64] = { "適用されたワームの ステータス効果2倍", "適用されたワームの ステータス効果3倍", "適用されたワームの ステータス効果4倍", },
    -- Error (追加): Rainbow Wormと同様
    [75] = { "可能であれば適用中の トリンケットの効果を 2倍にする", "可能であれば適用中の トリンケットの効果を 3倍にする", "可能であれば適用中の トリンケットの効果を 4倍にする", },
    -- NO! (追加)
    [88] = { "{{Quality0}} 品質0のアイテムを 自動的にリロールする" },
    -- Gilded Key (ゴールデンバージョンのみ): バグで鍵が付与されない (ゴールデンキーが付与されるべき？)
    [159] = { "保持中にスポーンした 宝箱を、金宝箱に置き 換える#金宝箱のランダムな ピックアップ内容に、 カードとトリンケット、 ピルを加える" },
	-- The Twins：追加 (ゴールデン / Mom's Box / 両方)
	[183] = { "最大2体まで複製・付与", "最大2体まで複製・付与", "最大3体まで複製・付与" },
}

--[[
Localizations may choose to overwrite specific data from EID.GoldenTrinketData in this table. For advanced users only.
Example: If French uses "Double" instead of "2x" for Purple Heart, they can do:
EID.descriptions[languageCode].goldenTrinketData = {
	[5] = {findReplace = true, mult = 2},
}
and then place
	[5] = { "Double", "Quadruple" },
in their goldenTrinketEffects
]]
EID.descriptions[languageCode].goldenTrinketData = { }

---------- Cards ----------

local repCards={
    [2] = {"2", "I - 魔術師", "その部屋に居る間、涙に ホーミング効果を付与#↑ 射程 +3"}, -- I - The Magician
    [12] = {"12", "XI - 力", "その部屋に居る間：#↑ 最大体力 +1#↑ 攻撃力　 +0.3#↑ 攻撃力　 +50%#↑ 射程　　 +2.5#↑ 移動速度 +0.3"}, -- XI - Strength
	[16] = {"16", "XV - 悪魔", "その部屋に居る間：#↑ 攻撃力 +2"},
	[18] = {"18", "XVII - 星", "{{TreasureRoom}} トレジャールームに テレポート#{{Planetarium}} プラネタリウムがある場合、 そちらにテレポート"},
	[20] = {"20", "XIX - 太陽", "全ての敵に100ダメージ#体力全回復#フルマッピング効果#{{CurseDarkness}} 闇の呪いを取り除く"}, -- XIX - The Sun
	[21] = {"21", "XX - 審判", "乞食か悪魔乞食をスポーン#低確率で鍵／爆弾／電池／ 腐った乞食もスポーン"}, -- XX - Judgement
	[22] = {"22", "XXI - 世界", "フルマッピング効果"}, -- XXI - The World
    [27] = {"27", "クラブのエース", "全てのピックアップ・ 宝箱・ボス以外の敵を 爆弾に変換する"}, -- Ace of Clubs
    [28] = {"28", "ダイアのエース", "全てのピックアップ・ 宝箱・ボス以外の敵を コインに変換する"}, -- Ace of Diamonds
    [29] = {"29", "スペードのエース", "全てのピックアップ・ 宝箱・ボス以外の敵を 鍵に変換する"}, -- Ace of Spades
    [30] = {"30", "ハートのエース", "全てのピックアップ・ 宝箱・ボス以外の敵を ハートに変換する"}, -- Ace of Hearts
    [34] = {"34", "エワズ", "次のフロアにつながる トラップドアを生成#装飾のある床の上で 使用するとクロール スペースを生成する （草やゴミがある床）"}, -- Ehwaz
    [39] = {"39", "アルギス", "ダメージを無効化する シールドを20秒間展開"}, -- Algiz
    [42] = {"42", "カオスのカード", "移動方向にカードを投げ、 触れた敵を即死させる#デリリウムとビーストは 即死無効"}, -- Chaos Card
    [51] = {"51", "聖なるカード", "一度だけダメージを 無効化するシールドを 付与する　　　#効果は次のダメージを 受けるまで持続"}, -- Holy Card
    [52] = {"52", "巨大化", "その部屋に居る間：#↑ 攻撃力 +7#↑ 射程　 +3#障害物破壊能力を付与#アイザックのサイズ拡大"}, -- Huge Growth
    [55] = {"55", "ルーンのカケラ", "ランダムなルーンの 効果を発動する#通常のルーンよりも 効果は弱体化される"}, -- Rune Shard
    [56] = {"56", "0 - 愚者？", "所持するピックアップと ハートを全て床に落とし、 残り体力を半ハートにする#一定数以上のコインと 爆弾は、{{Collectible74}}クォーターか {{Collectible19}}ドカーン！に変化して 落とされる"}, -- 0 - The Fool?
    [57] = {"57", "I - 魔術師？", "敵と弾を跳ね返すオーラを 1分間付与する"}, -- I - The Magician?
    [58] = {"58", "II - 女教皇？", "ママの踏み潰し攻撃が 1分間持続する"}, -- II - The High Priestess?
    [59] = {"59", "III - 女帝？", "以下の効果が1分間持続：#↑ 最大体力 +2#↑ 連射速度 +1.5#↓ 移動速度 -0.1"}, -- III - The Empress?
    [60] = {"60", "IV - 皇帝？", "追加のボス部屋に テレポートする#ボスは2階層下の フロアから選ばれる#倒すとボス部屋の アイテムがスポーン"}, -- IV - The Emperor?
    [61] = {"61", "V - 教皇？", "骨ハートを2個スポーン"}, -- V - The Hierophant?
    [62] = {"62", "VI - 恋人？", "現在の部屋のアイテム プールからランダムな アイテムを1個スポーン#最大体力1か、青ハート 2個を、壊れたハートに 置き換える"}, -- VI - The Lovers?
    [63] = {"63", "VII - 戦車？", "10秒間、使用した位置に アイザックが固定され、 無敵と高速連射能力が 付与される"}, -- VII - The Chariot?
    [64] = {"64", "VIII - 正義？", "金宝箱を2～4個スポーン"}, -- VIII - Justice?
    [65] = {"65", "IX - 隠者？", "部屋の全てのアイテムと ピックアップをコインに 変換する#お店の販売価格に 基づいて変換される"}, -- IX - The Hermit?
    [66] = {"66", "X - 運命の輪？", "ランダムなダイス部屋の 効果を発動する"}, -- X - Wheel of Fortune?
    [67] = {"67", "XI - 力？", "部屋の全ての敵が1分間 弱体化し、スロー状態に なり、2倍のダメージを 受ける"}, -- XI - Strength?
    [68] = {"68", "XII - 吊られた男？", "30秒間キーパーに変身#涙がトリプルショットに なり、移動速度が若干 低下する#倒された敵がランダムな コインを落とす"}, -- XII - The Hanged Man?
    [69] = {"69", "XIII - 死神？", "{{Collectible545}}死者の本と同様の効果：#その部屋で倒された敵 1体につき、友好的な 骨タイプの敵、または アイザックを周回する 骨を1つスポーンする"}, -- XIII - Death?
    [70] = {"70", "XIV - 節制？", "ランダムなピルの効果を 5連続で発動する"}, -- XIV - Temperance?
    [71] = {"71", "XV - 悪魔？", "{{Collectible33}}聖書の効果を発動する#30秒間、{{Collectible390}}セラフィムと 飛行能力を付与する"}, -- XV - The Devil?
    [72] = {"72", "XVI - 塔？", "岩や障害物の塊を部屋の 7ヶ所に生成する#ｘ岩が複数生成される 可能性がある"}, -- XVI - The Tower?
    [73] = {"73", "XVII - 星？", "最も古いパッシブアイテム （初期アイテムを除く）を 削除する#現在の部屋のアイテム プールからランダムな アイテムを2個スポーン"}, -- XVII - The Stars?
    [74] = {"74", "XVIII - 月？", "離れ隠し部屋にテレポート#通常の部屋に戻る経路は 赤い部屋で生成される"}, -- XVIII - The Moon?
    [75] = {"75", "XIX - 太陽？", "現フロアに居る間：#飛行能力を付与#涙に透過効果を付与#↑ 攻撃力 +1.5#赤ハートを骨ハートに 置き換える#闇の呪いをかける"}, -- XIX - The Sun?
    [76] = {"76", "XX - 審判？", "リロールマシーンを スポーンする"}, -- XX - Judgement?
    [77] = {"77", "XXI - 世界？", "クロールスペースに 繋がるトラップドアを 生成する"}, -- XXI - The World?
    [78] = {"78", "ひびが入ったカギ", "使い捨て{{Collectible580}}レッドキー"}, -- Cracked Key
    [79] = {"79", "ハートのクイーン", "1～20個の赤ハートを スポーンする"}, -- Queen of Hearts
    [80] = {"80", "ワイルド カード", "最後に使用したカード・ ピル・ソウルストーン・ ルーン・アクティブ アイテムの効果をコピー する"}, -- Wild Card
    [81] = {"81", "アイザックのソウル", "部屋の全てのアイテムを リロールする#元のアイテムとリロール されたアイテムが1秒 おきに切り替わって表示 される"}, -- Soul of Isaac
    [82] = {"82", "マグダレーンのソウル", "その部屋に居る間、 アイザックが赤い オーラを放つ#倒された敵が2秒で 消える半赤ハートを スポーンする"}, -- Soul of Magdalene
    [83] = {"83", "ケインのソウル", "部屋の全てのドアを開く#部屋の適用可能な全ての 壁に{{Collectible580}}レッドキー効果を 発動し、赤い部屋を生成 する"}, -- Soul of Cain
    [84] = {"84", "ユダのソウル", "敵の動きを3秒間止め、 無敵状態で敵と弾を 貫通して移動できる#3秒後、貫通した全ての 敵にダメージを与える#貫通した敵と弾の数に 応じてダメージが増加 する"}, -- Soul of Judas
    [85] = {"85", "？？？のソウル", "下痢と毒おならを8連続で放つ#うんち爆弾を7連続で放つ#下痢の上に立つと：#↑ 連射速度 +1.5#↑ 攻撃力　 +1"}, -- Soul of ???
    [86] = {"86", "イブのソウル", "14匹の{{Collectible117}}鳥の死体が現れ、 その部屋に居る間、敵を 攻撃する"}, -- Soul of Eve
    [87] = {"87", "サムソンのソウル", "10秒間バーサーカー化し、 涙を近接攻撃に置き換える#↑ 移動速度 +0.4#↑ 攻撃力　 +3#↑ 連射速度#敵を倒すと持続時間+1秒"}, -- Soul of Samson
    [88] = {"88", "アザゼルのソウル", "{{Collectible441}}メガブラストを 7.5秒間放つ"}, -- Soul of Azazel
    [89] = {"89", "ラザラスのソウル", "致命的なダメージを受け ると自動的に使用され、 半ハートの状態でその 部屋に復活する#復活時、ダメージを一定 時間無効化する"}, -- Soul of Lazarus
    [90] = {"90", "エデンのソウル", "部屋の全てのアイテムと ピックアップをリロール する#アイテムはランダムな アイテムプールを使用 してリロールされる"}, -- Soul of Eden
    [91] = {"91", "ザ ロストのソウル", "その部屋に居る間、 ザ・ロストに変身する#悪魔部屋のアイテムを 1個無料で取得できるが、 取得後、他のアイテムは 消滅する#マウソレウム／ゲヘナの ドアをノーダメージで 開放できる"}, -- Soul of the Lost
    [92] = {"92", "リリスのソウル", "ランダムな使い魔を 1体、永続付与する"}, -- Soul of Lilith
    [93] = {"93", "キーパーのソウル", "1～25枚のランダムな コインをスポーンする"}, -- Soul of the Keeper
    [94] = {"94", "アポリオンのソウル", "15匹のランダムなイナゴを スポーンする"}, -- Soul of Apollyon
    [95] = {"95", "ザ フォーガットンのソウル", "その部屋に居る間、 ザ・フォーガットンが セカンドキャラクター としてスポーンする"}, -- Soul of the Forgotten
    [96] = {"96", "ベタニアのソウル", "ランダムな特殊効果 付きのウィスプを 6つスポーンする"}, -- Soul of Bethany
    [97] = {"97", "ヤコブとエサウのソウル", "その部屋に居る間、 エサウがセカンド キャラクターとして スポーンする#アイザックと同数の ランダムなパッシブ アイテムを所持した 状態でスポーンする"}, -- Soul of Jacob and Esau
}
EID:updateDescriptionsViaTable(repCards, EID.descriptions[languageCode].cards)

-- Card Buffs caused by Tarot Cloth
-- Strings will be appended to the original description (with line breaks replaced with a Tarot Cloth icon)
-- Tables with one entry will completely replace the original description
-- Tables with two or more entries are find-replace pairs (the new text will be colored Shiny Purple)
EID.descriptions[languageCode].tarotClothBuffs = {
    [2] = "{{Collectible34}}ベリアルの本の効果が 同時に発動する", -- I - The Magician
    [3] = "追加の踏み潰し攻撃", -- II - The High Priestess
    [4] = {0.3, 0.6, 1.5, 3}, -- III - The Empress
    [5] = "ボスを倒していない場合、 青ハートを1個付与", -- IV - The Emperor
    [6] = {"2個", "3個"}, -- V - The Hierophant
    [7] = {"2個", "3個"}, -- VI - The Lovers
    [8] = {"6秒間", "12秒間"}, -- VII - The Chariot
    [9] = {"ハート・コイン・爆弾・ 鍵を各{{ColorShinyPurple}}2個{{CR}}スポーン"}, -- VIII - Justice
    [10] = "グリードを出現させない#グリード出現済みの場合、 通常のお店に戻す", -- IX - The Hermit
    [11] = {"スロットマシーンか 占いマシーンを{{ColorShinyPurple}}2つ{{CR}}スポーン"}, -- X - Wheel of Fortune
    [12] = {1, 2, 0.3, 0.6, 0.3, 0.6, 2.5, 5}, -- XI - Strength
    [14] = {"40ダメージ", "80ダメージ"}, -- XIII - Death
    [15] = {"献血機を{{ColorShinyPurple}}2つ{{CR}}スポーン#グリードモードでは 悪魔乞食を{{ColorShinyPurple}}2体{{CR}}スポーン"}, -- XIV - Temperance
    [16] = {2, 4}, -- XV - The Devil
    [17] = {"6個", "12個"}, -- XVI - The Tower
    [18] = "トレジャールーム未訪問の 状態で使うと、アイテムを 2つの候補から選択できる ようになる", -- XVII - The Stars
	[20] = {"100ダメージ", "400ダメージ"}, -- XIX - The Sun
    [21] = {"乞食か悪魔乞食を{{ColorShinyPurple}}2体{{CR}}スポーン"}, -- XX - Judgement
    [56] = "ピックアップと一緒に パッシブアイテムを 6個落とす#取得順の新しい方から 6個が落とされる", -- 0 - The Fool?
    [59] = {2, 3}, -- III - The Empress?
    [61] = {"2個", "3個"}, -- V - The Hierophant?
    [62] = "ブロークンハートを2個 追加し、アイテムを2個 スポーンする", -- VI - The Lovers?
    [64] = {"2～4個", "4～14個"}, -- VIII - Justice?
	[65] = "コインを1枚追加", -- IX - The Hermit?
	[66] = {"ランダムなダイス部屋の 効果を{{ColorShinyPurple}}2回{{CR}}発動する"}, -- X - Wheel of Fortune?

	[68] = {"30秒間", "60秒間"}, -- XII - The Hanged Man?
    [70] = {"5連続", "10連続"}, -- XIV - Temperance?
    [72] = {"7ヶ所", "14ヶ所"}, -- XVI - The Tower?
    [73] = {"最も古いパッシブアイテム （初期アイテムを除く）を {{ColorShinyPurple}}2個{{CR}}削除する#現在の部屋のアイテム プールからランダムな アイテムを{{ColorShinyPurple}}4個{{CR}}スポーン"}, -- XVII - The Stars?
    [76] = {"リロールマシーンを {{ColorShinyPurple}}2つ{{CR}}スポーンする"}, -- XX - Judgement?
}

-- There's some odd behavior with Blank Card + Tarot Cloth not doubling some cards
-- These will be appended after Blank Card recharge time and "Blank Card effect:"
EID.descriptions[languageCode].tarotClothBlankCardBuffs = {
	[11] = "1つスポーン", -- X - Wheel of Fortune
	[12] = "{{Collectible451}} の2倍バフ無効", -- XI - Strength
	[14] = "全ての敵に40ダメージ", -- XIII - Death
	[15] = "1つスポーン", -- XIV - Temperance
	[16] = "攻撃力 +2", -- XV - The Devil
	[20] = "全ての敵に200ダメージ", -- XIX - The Sun
	[21] = "1体スポーン", -- XX - Judgement
	[56] = "パッシブアイテムを 3個落とす", -- 0 - The Fool?
	[64] = "金宝箱を2～7個スポーン", -- VIII - Justice?
	[65] = "追加のコインなし", -- IX - The Hermit?
	[66] = "1回のみ発動", -- X - Wheel of Fortune?
	[68] = "効果時間30秒", -- XII - The Hanged Man?
	[72] = "7ヶ所に生成する", -- XVI - The Tower?
	[73] = "1個削除し2個スポーン", -- XVII - The Stars?
	[76] = "1つスポーン", -- XX - Judgement?
}

---------- Pills ----------

local repPills={
    [4] = {"3", "爆弾は鍵なり", "爆弾と鍵の所持数を 入れ替える#金爆弾／金鍵の場合、 金効果も入れ替わる"}, -- Bombs are Key
    [12] = {"11", "射程距離ダウン", "↓ 射程 -1"}, -- Range Down
    [13] = {"12", "射程距離アップ", "↑ 射程 +1.25"}, -- Range Up
	[38] = {"37", "レトロビジョン", "ゲーム画面が30秒間 ピクセル加工される"},
    [42] = {"41", "眠いなぁ・・・", "部屋の全ての敵と アイザックを スロー状態にする"}, -- I'm Drowsy...
    [43] = {"42", "ワクワクする！", "部屋の全ての敵と アイザックを 加速状態にする#30秒後と60秒後にも 効果が発動する"}, -- I'm Excited!!!
    [48] = {"47", "ショットスピードダウン", "↓ 弾速 -0.15"}, -- Shot Speed Down
    [49] = {"48", "ショットスピードアップ", "↑ 弾速 +0.15"}, -- Shot Speed Up
    [50] = {"49", "エクスペリメンタル ピル", "↑ ランダムなステータス#↓ ランダムなステータス#{{Collectible46}}幸せの足・{{Collectible303}}おとめ座・ {{Collectible75}}PHD所有時は減少なし#{{Collectible654}}偽PHD所有時は増加なし"}, -- Experimental Pill
    [9999] = {"", "ゴールデンピル", "ランダムなピルの効果#複数回使用できる"}, -- golden Pill
}
EID:updateDescriptionsViaTable(repPills, EID.descriptions[languageCode].pills)

EID.descriptions[languageCode].horsepills={
    {"0", "悪性ガス", "全ての敵に毒を与える"}, -- Bad Gas
    {"1", "バッドトリップ", "ハート2個のダメージを 受ける#ハートが1個以下の場合、 体力全快ピルに変化"}, -- Bad Trip
    {"2", "鉄球", "青ハート +4"}, -- Balls of Steel
    {"3", "爆弾は鍵なり", "爆弾と鍵の所持数を 入れ替える#爆弾と鍵の所持数を 50%増やす#金爆弾／金鍵の場合、 金効果も入れ替わる"}, -- Bombs are Key
    {"4", "おなか急降下", "アイザックの尻から 巨大ホーミング爆弾が 8連続スポーンする"}, -- Explosive Diarrhea
    {"5", "体力全快", "体力全回復#青ハート +3"}, -- Full Health
    {"6", "ＨＰダウン", "↓ 最大体力 -2#最大体力が2以下の 場合、HPアップに変化"}, -- Health Down
    {"7", "ＨＰアップ", "↑ 最大体力 +2"}, -- Health Up
    {"8", "ピル発見", "効果なし"}, -- I Found Pills
    {"9", "厨二病", "3回使用すると大人になる (最大体力 +1)"}, -- Puberty
    {"10", "プリティー フライ", "{{Collectible279}}ビッグファンを付与#付与の上限なし"}, -- Pretty Fly
    {"11", "射程距離ダウン", "↓ 射程 -2"}, -- Range Down
    {"12", "射程距離アップ", "↑ 射程 +2.5"}, -- Range Up
    {"13", "スピードダウン", "↓ 移動速度 -0.24"}, -- Speed Down
    {"14", "スピードアップ", "↑ 移動速度 +0.3"}, -- Speed Up
    {"15", "涙ダウン", "↓ 連射速度 -0.56"}, -- Tears Down
    {"16", "涙アップ", "↑ 連射速度 +0.70"}, -- Tears Up
    {"17", "運ダウン", "↓ 運 -2"}, -- Luck Down
    {"18", "運アップ", "↑ 運 +2"}, -- Luck Up
    {"19", "テレポピル", "ランダムな部屋に テレポートする#低確率でI AM ERRORへ"}, -- Telepills
    {"20", "４８時間戦えますか！", "アクティブアイテムを フルチャージする#3～4個の電池をドロップ"}, -- 48 Hour Energy!
    {"21", "吐血", "赤ハートを1個残しで 空にして、1～4個の 赤ハートをスポーン"}, -- Hematemesis
    {"22", "まひ", "4秒間のマヒ"}, -- Paralysis
    {"23", "あぁ刻が見える！", "現フロアの隠し部屋の 入り口を全て開放する#フルマッピング効果"}, -- I can see forever!
    {"24", "フェロモン", "部屋の全ての敵を 友好的な敵に変える"}, -- Pheromones
    {"25", "記憶喪失", "マップを？に置き換える (迷われし者の呪い)"}, -- Amnesia
    {"26", "レモンパーティー", "レモン汁が部屋全体に 広がって、触れた敵に ダメージを与える"}, -- Lemon Party
    {"27", "君、魔法使い？", "60秒間、涙が斜めに飛ぶ"}, -- R U a Wizard?
    {"28", "強力鎮痛薬！", "その部屋に居る間、 受けるダメージを 半ハートに軽減する"},  -- Percs!
    {"29", "過剰摂取！", "その部屋に居る間、 受けるダメージが ハート1個分に増加"}, -- Addicted!
    {"30", "リ・ラックス", "4秒間うんちを出し続ける"}, -- Re-Lax
    {"31", "???", "現フロアに迷路の呪いを かける"}, -- ???
    {"32", "オオキクナール", "アイザックのサイズ拡大#当たり判定は不変"}, -- One makes you larger
    {"33", "チイサクナール", "アイザックのサイズ縮小#当たり判定も縮小"}, -- One makes you small
    {"34", "感染性！", "部屋のうんち1個につき 2匹の青クモをスポーン"}, -- Infested!
    {"35", "感染症？", "部屋の敵1体につき2匹の 青クモをスポーンする#敵が居ない場合2～6匹の 青クモをスポーンする"}, -- Infested?
    {"36", "パワー ピル！", "6秒間パックマン化し、 以下の効果を得る：#無敵状態#全ての敵に恐怖を与える#秒間40の接触ダメージ#敵を2体倒すたび 半赤ハート回復#涙攻撃不可#パックマン化に加え、#その部屋に居る間：#↑ 攻撃力 +7#↑ 射程 +3#巨大化#障害物破壊能力"}, -- Power Pill!
    {"37", "レトロビジョン", "ゲーム画面が90秒間 ピクセル加工される"}, -- Retro Vision
    {"38", "最後までおともだち！", "青ハエを6匹スポーン"}, -- Friends Till The End!
    {"39", "ＫＯらっく", "茶色の液体が床に広がり、 アイザックをスリップ させる#通常のピルより長持ち"}, -- X-Lax
    {"40", "何かがおかしい・・・", "黒い液体が床に広がり、 触れた敵をスロー状態に#通常のピルより長持ち"}, -- Something's wrong...
    {"41", "眠いなぁ・・・", "部屋の全ての敵と アイザックを スロー状態にする"}, -- I'm Drowsy...
    {"42", "ワクワクする！", "部屋の全ての敵と アイザックを 加速状態にする#30秒後と60秒後にも 効果が発動する"}, --I'm Excited!!!
    {"43", "ごっくん！", "保持中のトリンケットを 吸収し、効果を永続化する#吸収したトリンケット 1個につき赤ハート1個 回復する"}, -- Gulp!
    {"44", "バクバク！", "{{Collectible149}} 吐き気薬の涙を複数放つ"}, -- Horf!
    {"45", "天国を歩いてる気分！", "6秒間パックマン化し、 以下の効果を得る：#無敵状態#全ての敵に恐怖を与える#秒間40の接触ダメージ#敵を2体倒すたび 半赤ハート回復#涙攻撃不可"}, -- Feels like I'm walking on sunshine!
    {"46", "げふっ、ゲロ！", "最後に使用したピルを ホースピル状態にして スポーンする"}, -- Vurp!
    {"47", "ショットスピードダウン", "↓ 弾速 -0.3"}, -- Shot Speed Down
    {"48", "ショットスピードアップ", "↑ 弾速 +0.3"}, -- Shot Speed Up
    {"49", "エクスペリメンタル ピル", "↑ ランダムなステータス 1つを2回増加させる#↓ ランダムなステータス 1つを2回減少させる#{{Collectible46}}幸せの足・{{Collectible303}}おとめ座・ {{Collectible75}}PHD所有時は減少なし#{{Collectible654}}偽PHD所有時は増加なし"}, -- Experimental Pill
    [9999] = {"", "ゴールデンピル", "ランダムなホースピル効果#複数回使用できる"}, -- Golden Pill
}

---------- Character Info ----------
local repCharacterInfo = {
	[4] = {"???", "赤ハートを持てない#体力が増える効果は、 代わりに青ハート+1#悪魔取引のコストは、 赤ハート1個=青1個、 赤ハート2個=青2個に、 それぞれ置き換わる#うんちを壊した時、 青ハエが1匹スポーン"},
	[8] = {"Lazarus", "1フロアに1回、死亡時に 以下の効果を発動する：#復活ラザラスとして その部屋で復活#↓ 最大体力 -1#↑ 攻撃力 +1"},
	[11] = {"Lazarus Risen", "↑ 移動速度#↑ 射程#↑ 運#↑ 攻撃力 x1.4#次のフロアに移動した時、 ラザラスに戻る"},
	[12] = {"Dark Judas", "↑ 攻撃力 x2#赤ハートを持てない#体力が増える効果は、 代わりに黒ハート+1#{{Player3}} 実績はユダとして扱う"},
	[14] = {"Keeper", "{{CoinHeart}} コインで体力を回復#最大体力は3#ハートは青ハエに 置き換わる#悪魔取引のコストは 15／30コイン"},
	[18] = {"Bethany", "青／黒ハートを体力へ 追加できない代わりに、 アクティブアイテムの チャージとして使用できる"},
	[19] = {"Jacob", "二人を同時に操作する#爆弾は二人同時に置く#{{ButtonRT}} 押下中、エサウは その場に待機する#アクティブアイテムは、 {{ButtonLT}}でヤコブが、 {{ButtonRB}}でエサウが使用#カード／ピルは、{{ButtonRT}}押下中、 {{ButtonLT}}でヤコブが、{{ButtonRB}}でエサウが使用#二択のアイテムは、同時に 触れることで両取りできる#片方でも死ぬとゲームオーバー"},
	[20] = {"Esau", "二人を同時に操作する#爆弾は二人同時に置く#{{ButtonRT}} 押下中、エサウは その場に待機する#アクティブアイテムは、 {{ButtonLT}}でヤコブが、 {{ButtonRB}}でエサウが使用#カード／ピルは、{{ButtonRT}}押下中、 {{ButtonLT}}でヤコブが、{{ButtonRB}}でエサウが使用#二択のアイテムは、同時に 触れることで両取りできる#片方でも死ぬとゲームオーバー"},
	
	[21] = {"Tainted Isaac", "アイテムが二択状態で 生成される#パッシブアイテムは 8個までしか持てず、 9個目のアイテムは {{ButtonRT}}で選んで入れ替える"},
	[22] = {"Tainted Magdalene", "赤ハートが2個以上ある時、 体力が徐々に減少する#死んだ敵は、2秒で消える 半赤ハートを確率で落とす#敵に接触時、自動的に 近接攻撃が発動し、 6倍のダメージを与える#この効果で倒された敵は、 半赤ハートを確定で落とす#アイテムやカードなどの 体力回復効果2倍#減少部分の赤ハートは、 悪魔部屋の出現確率に 影響しない"},
	[23] = {"Tainted Cain", "触れたアイテムが 各種ピックアップに 変換される"},
	[24] = {"Tainted Judas", "赤ハートを持てない#体力が増える効果は、 代わりに黒ハート+1"},
	[25] = {"Tainted ???", "爆弾とうんちが置き換わる#{{Crafting29}} 敵にダメージを与えると うんちピックアップが スポーンする#{{Collectible715}} うんちを1個ホールドし、 あとで使うことができる"},
	[26] = {"Tainted Eve", "攻撃ボタンを押し続けると 体力が消費され、血餅の 使い魔がスポーンする#サンプトリウムを使うと 血餅は体力になって戻る#消費されたハートの種類に 応じて血餅の特性が変化する#{{ButtonRT}}で血餅を固定できる#以下の条件時、近接攻撃型の キャラに変化し、移動速度と 攻撃力が増加する： ・血餅が無く、残り体力が 　半ハートになった時 ・残り体力がハート1個の 　状態で血餅を出した時"},
	[27] = {"Tainted Samson", "与えた／受けたダメージが 一定量に達すると、5秒間 バーサーカー状態になり、 以下の効果を得る：#↑ 移動速度 +0.4#↑ 連射速度#↑ 攻撃力　 +3#涙を骨による近接攻撃に 置き換える#敵を倒すと持続+1秒＆ 短時間の無敵状態"},
	[28] = {"Tainted Azazel", "攻撃チャージ開始時に 吐血し、呪いの効果と 1.5倍のダメージを与える#吐血が敵に当たると、 チャージ時間が半減する#{{BrimstoneCurse}} 呪われた敵はビームから 追加のダメージを受け、 死亡時に爆発し、周囲の 敵に呪いを拡散する"},
	[29] = {"Tainted Lazarus", "裏と表の二形態があり、 各々個別のアイテムと ステータスを持つ#部屋をクリアした時と、 フリップを使用した時、 裏表が入れ替わる"},
	[30] = {"Tainted Eden", "ダメージを受けるたびに ステータス、アイテム、 トリンケット、所持品が リロールされる#アイテムは、同じプール から選択・リロールされる#自傷ダメージはリロール無し"},
	[31] = {"Tainted Lost", "{{Card51}} スポーンするカードが 10%の確率で聖なるカードに 置き換わる#品質{{Quality2}}以下のアイテムは、 20%の確率でリロールされる#攻撃型のアイテムのみ スポーンする"},
	[32] = {"Tainted Lilith", "胎児を発射して攻撃し、 3倍のダメージを与える#攻撃ボタンを押し続けると 胎児が涙攻撃を始め、 近くの敵を自動的に狙う"},
	[33] = {"Tainted Keeper", "最大体力2#敵が2秒で消える コインを落とす#アイテム取得時、 15コイン支払う#お店の品ぞろえが 強化され、入店時 鍵を消費しない"},
	[34] = {"Tainted Apollyon", ""},
	[35] = {"Tainted Forgotten", "移動できない無敵の フォーガットンを、 攻撃できないソウルが 運び投げて戦う#爆弾はフォーガットンの 位置に置かれる#赤ハートを持てない#体力が増える効果は、 代わりに青ハート+1"},
	[36] = {"Tainted Bethany", "赤ハートを持てない 代わりにアクティブ アイテムのチャージ として使用できる#体力が増える効果は、 代わりに青ハート+1と チャージ+12を得る#ステータスアップの 効果が75%に抑制される"},
	[37] = {"Tainted Jacob", "敵対化したエサウが ヤコブを追い回す#接近すると、エサウが 突進を始め、進路上の 敵に大ダメージを与える#エサウと接触すると、 ヤコブは次のフロアまで ザ・ロスト状態になる#ロスト時、悪魔取引が 一回無料になる"},
	[38] = {"Dead Tainted Lazarus", "裏と表の二形態があり、 各々個別のアイテムと ステータスを持つ#部屋をクリアした時と、 フリップを使用した時、 裏表が入れ替わる"},
	[39] = {"Tainted Jacob's Soul", "{{Warning}} 体力なし#飛行能力#透過効果付きの涙#悪魔取引が一部屋につき 一回無料　　　#次のフロアに移動した時、 汚染ヤコブに戻る"},
	[40] = {"Tainted Forgotten Soul", "移動できない無敵の フォーガットンを、 攻撃できないソウルが 運び投げて戦う#爆弾はフォーガットンの 位置に置かれる#赤ハートを持てない#体力が増える効果は、 代わりに青ハート+1"},
}
EID:updateDescriptionsViaTable(repCharacterInfo, EID.descriptions[languageCode].CharacterInfo)

EID.descriptions[languageCode].birthright ={
    {"Isaac", "", "アイテムが二択状態で 生成されるようになる"},
    {"Magdalene", "", "↑ 最大体力 +1#体力の上限が18に増加"},
    {"Cain", "", "↑ 運 +1#全てのフロアで上位版の アーケードが出現する (各種最終フロアを除く)#{{Collectible46}}幸せの足の効果を強化"},
    {"Judas", "", "{{Collectible34}}ベリアルの本に他の アクティブアイテムを 積み重ねられるように なる　　　　#{{Collectible34}}ベリアルの本を未所持 だった場合、付与する#{{Collectible34}}の攻撃力の増加量は、 積み重ねたアイテムの チャージ量に比例する#積み重ねたアイテムに 応じて、特殊な効果が 発動する"},
    {"???", "", "最大体力を増加する効果で 付与される青ハートの量を、 2倍にする"},
    {"Eve", "", "{{Collectible122}} バビロンの女と {{Collectible117}} 鳥の死体が常時有効化"},
    {"Samson", "", "{{Collectible157}}血まみれの欲望の上限 回数が4増え、攻撃力の 最大増加値が14になる"},
    {"Azazel", "", "ブリムストーンビームの 幅が2倍に広がる#ダメージは増加しない"},
    {"Lazarus", "", "復活ラザラスになった時、 攻撃力が21.6増加する#増加した攻撃力は、毎秒 0.1ずつ減少する#効果が有効な状態で敵を 倒した時、攻撃力が0.07 増加する"},
    {"Eden", "", "ランダムなプールから アイテムを3個スポーン#1個だけ取得できる"},
    {"The Lost", "", "ロストに有益ではない アイテム（体力アップや 飛行・透過付与、被弾を 条件にするものなど）が 現れなくなる"},
    {"Lazarus Risen", "", "攻撃力が21.6増加する#増加した攻撃力は、毎秒 0.1ずつ減少する#効果が有効な状態で敵を 倒した時、攻撃力が0.07 増加する"},
    {"Black Judas", "", "{{Collectible34}}ベリアルの本に他の アクティブアイテムを 積み重ねられるように なる　　　　#{{Collectible34}}ベリアルの本を未所持 だった場合、付与する#{{Collectible34}}の攻撃力の増加量は、 積み重ねたアイテムの チャージ量に比例する#積み重ねたアイテムに 応じて、特殊な効果が 発動する"},
    {"Lilith", "", "全ての使い魔がリリスの 正面に固定される"},
    {"Keeper", "", "↑ 最大体力 +1#体力の上限が1増加"},
    {"Apollyon", "", "{{Collectible477}}ボイド使用時、それ以前 に取り込まれたアイテムが 一定確率でドロップする#ステータスは維持される#取り込まれたアイテムが 多いほどドロップ確率が 増加する"},
    {"The Forgotten", "", "魂が鎖から解かれ、自由に 移動可能になる"},
    {"The Forgotten Soul", "", "魂が鎖から解かれ、自由に 移動可能になる"},
    {"Bethany", "", "アクティブアイテムを 青ハートでチャージ する時、50%の確率で ハートが消費されない"},
    {"Jacob", "", "エサウの持つランダムな パッシブアイテムを3個 コピーする"},
    {"Esau", "", "ヤコブの持つランダムな パッシブアイテムを3個 コピーする"},
    {"Tainted Isaac", "", "パッシブアイテム用の スロットが4つ増加#バースライト自体は スロットを消費しない"},
    {"Tainted Magdalene", "", "消耗しない赤ハートが 1個追加される"},
    {"Tainted Cain", "", "アイテムからスポーンする ピックアップ量2倍"},
    {"Tainted Judas", "", "{{Collectible705}}ダークアーツの 効果範囲が広がる"},
    {"Tainted ???", "", "保持できるうんちの数を 29個まで増やす"},
    {"Tainted Eve", "", "赤ハートからスポーンした 血餅が死んだ時、2秒後に 消える半赤ハートを落とす"},
    {"Tainted Samson", "", "バーサーカー状態で敵を 倒した時の延長時間が、 1秒から3秒に増加"},
    {"Tainted Azazel", "", "{{Collectible726}}喀血のサイズが拡大する"},
    {"Tainted Lazarus", "", "裏面のラザラスが幽霊に なって現れ、セカンド キャラクターのように 機能する#幽霊状態のラザラスは ダメージを受けないが、 攻撃力は25%に低下する#このアイテムの効果は 片方のラザラスが取得 すれば両方で機能する"},
    {"Tainted Eden", "", "バースライトの前に 取得したアイテムは、 ダメージを受けても リロールされなくなる#アクティブアイテムは 交換するとリロールの 保護対象から外れる"},
    {"Tainted Lost", "", "一度だけ同じ部屋に復活 でき、復活時に近くの敵に 200ダメージを与える#復活時の攻撃は複数回 ヒットすることがある"},
    {"Tainted Lilith", "", "使い魔が{{Collectible728}}ゲローと連動 するようになり、体外に 居る時は自動攻撃をする#ゲローによる近接攻撃は、 使い魔1体につき3の追加 ダメージを得る"},
    {"Tainted Keeper", "", "敵を倒した時にスポーン するコインがキーパーに 引き寄せられる#通常のコインには影響なし"},
    {"Tainted Apollyon", "", "攻撃ボタンを押したままに すると、イナゴが戻らずに 攻撃を続けるようになる"},
    {"Tainted Forgotten", "", "魂に{{Collectible714}}リコールを付与#リコールを使用すると、 骨を魂に引き寄せられる"},
    {"Tainted Bethany", "", "高品質の{{Collectible712}}レメゲトン・ ウィスプを4つスポーン#通常のウィスプよりも 大きく、耐久値も高くなる"},
    {"Tainted Jacob", "", "ダークエサウが二人に 分離する#{{Collectible722}} アニマソラは同時に 二人を拘束する#{{Collectible722}} アニマソラのチャージ 時間を10秒に短縮し、 拘束時間を6.67秒に 延長する"},
    {"Dead Tainted Lazarus", "", "裏面のラザラスが幽霊に なって現れ、セカンド キャラクターのように 機能する#幽霊状態のラザラスは ダメージを受けないが、 攻撃力は25%に低下する#このアイテムの効果は 片方のラザラスが取得 すれば両方で機能する"},
    {"Tainted Jacob 2", "", "ダークエサウが二人に 分離する#{{Collectible722}} アニマソラは同時に 二人を拘束する#{{Collectible722}} アニマソラのチャージ 時間を10秒に短縮し、 拘束時間を6.67秒に 延長する"},
    {"Tainted Forgotten Soul", "", "魂に{{Collectible714}}リコールを付与#リコールを使用すると、 骨を魂に引き寄せられる"},
}

---------- Glitched Item Descriptions ----------

EID.descriptions[languageCode].GlitchedItemText = {
    -- Item Config info
	-- These texts are affected by the PluralizeFunction (ab+ file)
    AddBlackHearts = "{1} 黒ハート",
    AddBombs = "{1} 爆弾",
    AddCoins = "{1} コイン",
    AddHearts = "回復 {1} 赤ハート",
    AddKeys = "{1} 鍵",
    AddMaxHearts = "{1} 最大体力",
    AddSoulHearts = "{1} 青ハート",

    -- Cache Flag names
    cacheFlagStart = "影響する可能性： ",
    [0] = "攻撃力", "連射速度", "弾速", "射程", "移動速度", "特殊効果", "涙の色", "飛行", "攻撃の種類", "使い魔", "運", "サイズ", "色", "宝箱の中身", [16] = "全ステータス",

    -- Attribute triggers
    chain = "その後：{{CR}} ",
    active = "使用時：#",
    pickup_collected = "ピックアップ取得時：#",
    enemy_kill = "倒した時、一定確率で：#",
    damage_taken = "ダメージを受けた時：#",
    entity_spawned = "{T1} がスポーンした時：#",
    tear_fire = "涙を発射した時、一定確率で：#",
    enemy_hit = "敵に接触した時、一定確率で：#",
    room_clear = "部屋をクリアした時：#",

    -- Attribute effects
    area_damage = "近くの敵に {1} ダメージを与える",
    add_temporary_effect = "その部屋に居る間、 {1} を付与",
    convert_entities = "部屋の全ての {1} を {2} に変換",
    use_active_item = "{1} 使用時、",
    spawn_entity = "{1} をスポーン",
    fart = "{1} のおなら",

    -- Generic entity names not obtained from entities2.xml
    -- This could also be a place to localize entity names; this table is read from before EID.XMLEntityNames
    ["4.-1"] = "点火済み爆弾",
    ["5.0"] = "ピックアップ",
    ["5.10"] = "ハート",
    ["5.20"] = "コイン",
    ["5.30"] = "鍵",
    ["5.40"] = "爆弾",
    ["5.69"] = "サック",
    ["5.70"] = "ピル",
    ["5.90"] = "電池",
    ["5.300"] = "カード",
	["5.301"] = "ルーン", -- not a real ID
    ["9.-1"] = "敵の弾",
    ["999.-1"] = "障害物",
    ["1000.0"] = "効果",

	-- Text for the base item that is granted
	grants = "付与 ",
}

---------- Bag of Crafting Text ----------
EID.descriptions[languageCode].CraftingBagContent = "バッグ："
EID.descriptions[languageCode].CraftingRoomContent = "部屋内："
EID.descriptions[languageCode].CraftingFloorContent = "フロア："
EID.descriptions[languageCode].CraftingSearch = "検索："
EID.descriptions[languageCode].CraftingBagQuality = "バッグ品質："
EID.descriptions[languageCode].CraftingBestQuality = "最高品質："
EID.descriptions[languageCode].CraftingHideKey = "レシピの非表示："
EID.descriptions[languageCode].CraftingPreviewKey = "アイテムの確認："
-- {1} will be converted to the number of recipes
EID.descriptions[languageCode].CraftingMore = "...+{1} 以上"
-- {1} will be converted into the number of available items
EID.descriptions[languageCode].CraftingNumAvailableItems = "ピックアップ：{1} / 8 個"
EID.descriptions[languageCode].CraftingWarningAvailableItems = "クラフトレシピの表示には ピックアップが8個必要"
-- {1} will be converted into the name of the key that toggles the BoC visibility
EID.descriptions[languageCode].CraftingIsHidden = "非表示に設定中 (表示に設定：{1})"
-- {1} will be converted into the name of the key that toggles the BoC Search
EID.descriptions[languageCode].CraftingResults = "レシピ操作：マップ表示中、#{{Blank}} 　{{ButtonY}} {{ButtonA}} でスクロール#{{Blank}} 　{{ButtonX}} でレシピ固定#{{Blank}} 　{{ButtonB}} でレシピ更新#{{Blank}} 　{1}で検索"

-- Strings for Tainted Cain's pedestal salvaging; the non-base lines will have the corresponding icon automatically
EID.descriptions[languageCode].TaintedCainPedestalBase = "触れると、3～8個の ピックアップに変換"
EID.descriptions[languageCode].TaintedCainPedestalBaseBirthright = "触れると、{{BlinkBirthright}}6-16個{{CR}}の ピックアップに変換"
EID.descriptions[languageCode].TaintedCainPedestalGuaranteed = "{1}を確定でスポーン" -- Room type spawns
EID.descriptions[languageCode].TaintedCainPedestalBonus = "33%の確率で追加の{1}" -- "Safety Cap" type spawns
EID.descriptions[languageCode].TaintedCainPedestalLuckyToe = "66%の確率でピックアップ+1"
EID.descriptions[languageCode].TaintedCainPedestalLuckyToeBirthright = "66%の確率でピックアップ{{BlinkBirthright}}+2{{CR}}"
EID.descriptions[languageCode].TaintedCainPedestalDaemonsTail = "ハートの出現率 -80%"


---------- Misc. Text ----------

EID.descriptions[languageCode].ResultsWithX = "({1}:-2)"
EID.descriptions[languageCode].VariableCharge = "{1}チャージ："

EID.descriptions[languageCode].poopSpells = {
	{"Poop", "ピックアップを落とすことが ある、通常のうんち"},
	{"Corny Poop", "最大3匹の青ハエをスポーン"},
	{"Burning Poop", "敵に接触ダメージを与える#壊されると炎を残す"},
	{"Stone Poop", "投げると追加ダメージ#壊れにくい"},
	{"Stinky Poop", "毒ガスで敵にダメージを 与える#!!! 毒ガスは引火・爆発する"},
	{"Black Poop", "液体が敵をスロー状態にする#壊されると部屋の全ての敵に 10ダメージを与える"},
	{"Holy Poop", "{{Collectible543}} オーラを放つ白いうんち#うんちオーラの範囲内：#↑ 攻撃力　 +20%#↑ 連射速度 +150%#涙にホーミング効果を付与#一定確率でダメージ無効化"},
	{"Brown Creep", "床に液体を残す#液体の上では攻撃力と 連射速度がアップする#液体にうんちを置くと、 各種相乗効果が発生"},
	{"Fart", "敵と弾をノックバックし、 毒ガスを発生させる#!!! 毒ガスは引火・爆発する"},
	{"Bomb", "ノーマルなうんち爆弾"},
	{"Explosive Diarrhea", "アイザックの尻から 点火済みの爆弾が 5連続スポーンする"},

	--Undetected poop, for Poop API
	--[Poop name in code] = {Icon, Name, Description}
	["Unknown"] = {"{{PoopSpell1}}", "Unknown Poop", "The effects of the poop are Unknown"}
}

EID.descriptions[languageCode].itemPoolFor = "アイテムプール:"
EID.descriptions[languageCode].itemPoolNames = {
	[0] = "トレジャールーム", "お店", "ボス部屋", "悪魔部屋", "天使部屋", "隠し部屋", "図書館", "シェルゲーム", "金宝箱", "赤宝箱", "乞食", "悪魔乞食", "呪い部屋", "鍵乞食", "電池乞食", "ママの宝箱", "トレジャールーム（グリード）", "ボス部屋（グリード）", "お店（グリード）", "悪魔部屋（グリード）", "天使部屋（グリード）", "呪い部屋（グリード）", "隠し部屋（グリード）", "クレーンゲーム", "離れ隠し部屋", "爆弾乞食", "プラネタリウム", "古い宝箱", "お店（使い魔）", "木の宝箱", "腐った乞食",
}

EID.descriptions[languageCode].VoidShopText = "吸収した場合："
EID.descriptions[languageCode].VoidOptionText = "代わりに吸収される"
EID.descriptions[languageCode].VoidNames[2] = "{1} 連射速度アップ"

EID.descriptions[languageCode].PurityBoosts = {[0] = "↑ 攻撃力 +4", "↑ 連射速度 +2", "↑ 移動速度 +0.5", "↑ 射程 +3"}

EID.descriptions[languageCode].spindownError = "アイテム消失"

EID.descriptions[languageCode].BlankCardEffect = "白紙のカードで使用時："

EID.descriptions[languageCode].FlipItemToggleInfo = "（マップボタンで確認）"
EID.descriptions[languageCode].GlitchedCrownToggleInfo = "(マップボタンで確認：{1})"

EID.descriptions[languageCode].GlowingHourglassTransformed = "次のフロアに移動した時、 輝く砂時計に戻る"

EID.descriptions[languageCode].FalsePHDHeart = "黒ハートを1個スポーン"
EID.descriptions[languageCode].FalsePHDDamage = "攻撃力 +0.6"
EID.descriptions[languageCode].FalsePHDHorseDamage = "攻撃力 +1.2"

EID.descriptions[languageCode].ExperimentalPillPHD = "ステータスダウンなし"
EID.descriptions[languageCode].ExperimentalPillFalsePHD = "ステータスアップなし"

EID.descriptions[languageCode].PandorasBoxStrangeKeyEffect = "トリンケットを消費し、 通常の効果の代わりに、 ランダムなプールから 6個のアイテムをスポーン"

EID.descriptions[languageCode].AchievementWarningTitle = "{{ColorYellow}}!!! 注意 !!!"
EID.descriptions[languageCode].AchievementWarningText = "実績無効！#実績を有効化するには、 MOD未使用でママを倒す 必要があります#すでに倒している場合、 この警告はバグであり 無視して構いません#この警告は設定で無効に できます"
EID.descriptions[languageCode].OldGameVersionWarningText = "ゲームがアップデート されていません#最新バージョンのみが サポートされています#この警告は設定で無効に できます"
EID.descriptions[languageCode].ModdedRecipesWarningText = "MODのアイテムが原因で クラフトレシピの表示が 不正確になる可能性が あります#その場合、Item Probability モードか、非表示にして ください#この警告は設定で無効に できます"


-- Conditional descriptions - DO NOT TRANSLATE THE FIRST PART IN ["BRACKETS"]
-- Strings will be appended to the original description
-- Tables with one entry will completely replace the original description
-- Tables with two or more entries are find-replace pairs (if there's an odd number of entries, the last entry is appended)
-- For collectible/player conditionals, lines will automatically have their bulletpoint, and {1} is replaced with their name
local repConditions = {
	------ GENERAL STRINGS ------
	["Tainted Revive"] = "{1}のまま復活する",
	["Ice Tears"] = "凍結した敵は、倒した 扱いにならない", -- Uranus Anti-Synergy
	
	------ GREED MODE ------
	["5.100.344"] = {"黒ハート +1#取得時、爆弾を3個スポーン"}, -- Match Book (Greed) 
	["5.300.74"] = {"フロア開始時の部屋に テレポートする"}, -- The Moon? (Greed)
	["5.100.416"] = {"コインの最大値が999に"}, -- Deep Pockets (Greed)
	["5.100.566"] = "!!! グリードモードでは 正しいアイテムが 表示されません", -- Dream Catcher (Greed)
	["5.100.580"] = "{{GreedMode}} グリードモードでは、 開通先が特殊部屋だった 場合のみ部屋を生成可能 （極低確率）#{{GreedMode}} 隠し部屋の割り出しには 活用できる", -- Red Key (Greed)
	["5.300.83"] = "{{GreedMode}} グリードモードでは、 開通先が特殊部屋だった 場合のみ部屋を生成可能 （極低確率）#{{GreedMode}} 隠し部屋の割り出しには 活用できる", -- Soul of Cain (Greed)
	["5.100.514"] = {"敵と弾がランダムな 間隔で遅延を起こす"}, -- Broken Modem (Greed)
	["5.350.162"] = {"{{Player7}} ウェーブをクリアした時、 50%の確率でアザゼルに 変身する#効果は次のウェーブを クリアするまで有効"}, -- Azazel's Stump (Greed)
	
	
	------ ACHIEVEMENT CHECKS ------
	-- todo...
	
	
	------ SPECIFIC CHARACTER SYNERGIES/CHANGES ------
	["5.100.642"] = {"{{Warning}} 使い切りアイテム {{Warning}}#その部屋のアイテムプール から、アイテムを一つ生成"}, -- Magic Skin + Lost
	["5.100.240"] = "{1}：　　　 入れ替えても ステータスはそのまま", -- Experimental Treatment + Tainted Isaac
	["5.100.644"] = "{1}：　　　 入れ替えても ステータスを維持", -- Consolation Prize + Tainted Isaac
	["5.100.549"] = {"↑ 連射速度 +0.4"}, -- Brittle Bones (Keeper+Lost)
	["5.100.694"] = "{1}：　　　 4回まで攻撃を耐えられる", -- Heartbreak + Losts
	["5.100.694 (Keeper)"] = {"↓ 壊れたハート +1#↑ 壊れたハート1個につき 攻撃力 +0.25#キーパーに致命的な ダメージが与えられる時、 代わりに、1個の壊れた ハートを追加し、全ての 敵に40ダメージを与える#壊れたハートが3個 溜まると死ぬ"}, -- Heartbreak + Normal Keeper
	["5.100.694 (Tainted Keeper)"] = {"{1}：#{{Warning}} このアイテムを取得すると 一撃で死ぬ状態に陥る#↓ 壊れたハート +1#↑ 壊れたハート1個につき 攻撃力 +0.25#汚染キーパーに致命的な ダメージが与えられる時、 代わりに、1個の壊れた ハートを追加し、全ての 敵に40ダメージを与える#壊れたハートが2個 溜まると死ぬ"}, -- Heartbreak + Tainted Keeper
--  ["5.100.501"] = "{1} can gain additional coin containers#Health up items can grant an extra container per 25 coins", -- Greed's Gullet + Keeper
--  ["5.100.188"] = "{1}の場合7.5", -- Cain + Abel
	["5.100.360"] = "{1}の場合100%", -- Lilith + Incubus
--  ["5.100.728"] = "{1}の場合100%", -- Lilith + Gello
	["5.100.230 (Keeper)"] = "{1}：　　　 最大体力を1にする", -- Abaddon
	["5.100.230 (Bethany)"] = "{1}：　　　 最大体力を1、残り体力を 半赤ハートにする", -- Abaddon
	["5.100.230 (Tainted Bethany)"] = "{1}：　　　 ブラッドチャージは 失わない", -- Abaddon
	["5.100.245 (Keeper)"] = {"↑ 連射速度#↑ 涙の拡散度低下#↓ 攻撃力 x0.8"}, -- 20/20 + Keeper
	["5.100.205 (Tainted Magdalene)"] = "ヤムハートで無限回復", -- Sharp Plug + Tainted Magdalene
	
	["5.100.705"] = "敵／弾に触れるたび 一時的に攻撃力+1", -- Dark Arts + Dark/Tainted Judas
	["5.100.722"] = {"ダークエサウを鎖で拘束し、 行動不能にする#5秒後、もしくは拘束中に アニマソラを再使用した時、 エサウはヤコブに突進する"}, -- TJacob + Anima Sola
	["5.100.713"] = {"血餅を体力に換えて戻す#体力を超える血餅は イブの元に戻り残る#リチャージ時間は1秒"}, --Teve + Sumptorium
	["5.100.711"] = {"{{Player38}} 裏表を切り替える"}, -- Tlaz + Flip
	["5.100.710"] = {"使用し、攻撃すると、 その方向に近接攻撃を放つ#射程内のピックアップは バッグの中に取り込まれ、 8個集めるとアイテムを クラフトできる （使用ボタン長押し）#バッグが一杯の時、{{ButtonRT}}で 並び順を入れ替えられ、 新たなピックアップは 左上のモノと入れ替わる#アイテムの品質は集めた 素材の品質に比例する"}, -- Tcain Bag of Crafting
	
	["Mother's Kiss Soul"] = {"{{SoulHeart}} 保持中、青ハート +1"},
	["Mother's Kiss Bone"] = {"{{BoneHeart}} 保持中、骨ハート +1"},
	["Mother's Kiss Coin"] = {"{{CoinHeart}} 保持中、最大体力 +1#体力の上限 +1"},
	
	-- Vibrant/Dim Bulb
	["5.350.100 (Bethany)"] = "{1}：　　　 ソウルチャージが 十分にあると有効化",
	["5.350.100 (Tainted Bethany)"] = "{1}：　　　 ブラッドチャージが 十分にあると有効化",
	["5.350.101 (Bethany)"] = "{1}：　　　 ソウルチャージの量は無視",
	["5.350.101 (Tainted Bethany)"] = "{1}：　　　 ブラッドチャージの量は無視",
	["Health Up Soul Charges"] = "ソウルチャージ +{1}",
	["Health Up Blood Charges"] = "ブラッドチャージ +{1}",
	
	-- Tainted Bethany stuff
	["2 of Hearts Blood Charges"] = "{1}：　　　 ブラッドチャージ量2倍",
	["Vampire Blood Charges"] = {"↑ 攻撃力 +0.3#敵を13体倒すたび、 ブラッドチャージ +1"},
	["Fork Blood Charges"] = {"部屋クリア時、10%の確率で ブラッドチャージ +1"},
	["Stem Cell Blood Charges"] = {"新しいフロアに入った時、 ブラッドチャージ +1"},
	
	["Salvaging Bonus"] = "{1}：　　　 アイテム分解時にも 追加スポーン有効",
	["Salvaging Lucky Toe"] = "{1}：　　　 アイテム分解時、66%の 確率でピックアップが 追加でスポーンする",
	
	
	------ DUPLICATE COPIES OF ITEMS ------
	["5.100.2 (Copies)"] = "同時発射数 +1#連射速度ダウンなし", -- The Inner Eye
	["5.100.153 (Copies)"] = "同時発射数 +2#連射速度ダウンなし", -- Mutant Spider
	["5.100.245 (Copies)"] = "同時発射数 +1#連射速度ダウンなし", -- 20/20
	["5.100.358 (Copies)"] = "同時発射数 +1（正面）", -- The Wiz
--  ["5.100.64 (Copies)"] = "Owning this item multiple times reduces the price further", -- Steam Sale
	["5.100.118 (Copies)"] = "複数取得でダメージと ビームのサイズが増加", -- Brimstone
	["5.100.531 (Copies)"] = "複数取得時の効果は 攻撃力+1のみ", -- Haemolacria
	["5.100.224 (Copies)"] = "複数取得時の効果は 連射速度+0.5のみ", -- Cricket's Body
	
	
	----- MISC. ITEM CONDITIONS ------
	["Sacrificial Nugget"] = "{{ColorYellow}}ブラウンナゲット{{CR}}の ハエはコインに変換",
	["Sacrificial Item Wisps"] = "{{ColorYellow}}レメゲトン{{CR}}から生まれた 使い魔も生贄にできる#{{ColorYellow}}レメゲトン{{CR}}のウィスプは 半青ハートに変換される",
	["Sacrificial Plum"] = "召喚したベビープラムも 生贄にできる#{{ColorYellow}}プラムのふえ{{CR}}は消えない",
	["Sacrificial Quints"] = "{{ColorYellow}}クインツ{{CR}}から生まれた 使い魔が生贄にされると、 クインツ自体も失う",
	["Sacrificial Abyss"] = "{{ColorYellow}}アビス{{CR}}のイナゴは 使い魔として扱う",
	["Sacrificial Star"] = "{{ColorYellow}}ベツレヘムの星{{CR}}は 使い魔として扱う",
	["Sacrificial Clots"] = "血餅はコインに変換",
	
	["1000.76.1"] = "{{Warning}} 協力プレイ時、ダイスを 踏んだプレイヤーにのみ リロール効果が発生する", -- Dice Room 1 (Co-op)
	["1000.76.6"] = "{{Warning}} 協力プレイ時、全ての プレイヤーがリロール", -- Dice Room 6 (Co-op)
	["5.100.45"] = "協力プレイ時、 他プレイヤーを 半赤ハート回復", -- Yum Heart (Co-Op)
--  ["5.350.125"] = "プレイヤー間にも 電気ビームが発生する", -- Extension Cord (Co-Op)
	
	["5.100.245"] = "{1}の連射速度 ダウンを取り除く", -- 20/20 + Mutant Spider, The Inner Eye, Polyphemus
	["20/20"] = "{1}との 組み合わせで追加の 連射速度ダウンなし", -- 20/20 + Mutant Spider, The Inner Eye, Polyphemus
	
	["5.100.135 (Hard Mode)"] = {"1～2コイン", "1コイン", "2～3コイン", "2コイン"}, -- IV Bag Hard Mode (modify the PHD text too)
	["5.100.201"] = "取得時、{1}を フルチャージする", -- Iron Bar + Notched Axe
	["5.350.172"] = "{1}は テレポート効果を取り除く", -- Cursed Penny + Black Candle
--  ["5.100.501 (Deep Pockets)"] = "+1 container for every 100 coins past 99", -- Greed's Gullet + Deep Pockets
	["? Card Single Use"] = "使い切りアイテムもコピー可", -- Single Use Actives + ? Card
	["Both Peppers"] = "{1}と同時所有時、 炎の発生確率がアップ#運0=8%から12%に、最大値が 運10=50%から運7=100%に それぞれアップ", -- Ghost Pepper + Bird's Eye
	["Black Feather"] = "↑ 攻撃力 +0.5", -- Black Feather items
	["Hemoptysis"] = "{1}の呪い有効", -- Hemoptysis + Brimstone items
	["5.100.600"] = "{1}：連射速度 x1.2", -- Eye Drops (items and some players)
	["5.100.482"] = "汚染キャラは別の 汚染キャラに変化する", -- Clicker
	
	["4.5 Volt Timed"] = "時間式チャージの アイテムには効果なし", -- 4.5 Volt + Timed Recharges
	["4.5 Volt Multiple"] = "二番目にあるアイテムは、 一番目がフルチャージ後に チャージを始める", -- 4.5 Volt + Schoolbag/Pocket Actives
	["Bulb Zero"] = "チャージバーが無い アイテムでは無効", -- Vibrant/Dim Bulb + zero charge actives
	
	["Brimstone Proptosis"] = "ビームはゼロ距離で 6倍のダメージを与え、 距離が離れるほど ダメージが低下する",
	["Brimstone Ipecac"] = "↑ 攻撃力 +2#レーザーが衝突地点で 爆発する",
	["Brimstone Pop!"] = "ビームの射程が短くなり、 先端から目玉が飛び出す",
	["Eye of Belial Dr. Fetus"] = "爆弾は貫通する#爆弾は貫通時に2.5倍の ダメージを与えるが、 爆発は追加ダメージを 与えず、ホーミングもしない",
	["Spirit Sword C Section"] = "{1}が優先される#胎児が剣で回転攻撃する",
	["Spirit Sword Mom's Knife"] = "チャージ攻撃が変化： 回転する剣を前方に発射",
	["Spirit Sword Technology"] = "剣がライトセーバー化し、 敵の弾を跳ね返す#剣を振ると、レーザーが アイザックを取り囲む",
	["Spirit Sword Ipecac"] = "毒効果と攻撃力+2#剣ビームが爆発する",
	["Ludovico Ipecac"] = "攻撃力+2、毒・爆発なし",
	["Technology Ipecac"] = "↑ 攻撃力 +2#レーザーが衝突地点で 爆発する",
	["Eye of the Occult Beam"] = "照準が現れ自動攻撃",
	
	["Lullaby Clots"] = "血餅にも有効",
	["Lullaby Incubus"] = "インキュバスにも有効",
	
	-- Jacob's Ladder / 120 Volt battery synergies
	["Sparks Damage"] = "放電ダメージ増加",
	["Sparks Arc Length"] = "放電距離が延長",
	["Sparks Arc Count"] = "同時放電数が増加",
	["Sparks Arc Back"] = "同じ敵に複数回放電",
	
	["White Poop Jar"] = "1チャージで使用時、 白いうんちをスポーン", -- Everything Jar + Hallowed Ground
	["Golden Poop Jar"] = "黄金うんちの確率アップ",
	
	["Binge Eater Healing"] = {"体力を1回復", "体力を{{BlinkGreen}}2{{CR}}回復", "ブラッドチャージ +4", "ブラッドチャージ {{BlinkGreen}}+6{{CR}}"},
}
EID:updateDescriptionsViaTable(repConditions, EID.descriptions[languageCode].ConditionalDescs)




-- If Debug enabled, add overwrite tables to the languagepack in order for the language completion script to be able to compare them
if EID.enableDebug then
    EID.descriptions[languageCode].repCollectibles = repCollectibles
    EID.descriptions[languageCode].repTrinkets = repTrinkets
    EID.descriptions[languageCode].repCards = repCards
    EID.descriptions[languageCode].repPills = repPills
end

if REPENTOGON then
	EID.descriptions[languageCode].custom["6.8.0"] = {"0", "Donation Machine", "次の実績：{1}枚 残り：{2}枚　　　#{{Luck}} 寄付時、2%の確率で運+1#{{AngelRoom}} 10回の寄付で天使部屋の 出現率がアップ"}
	EID.descriptions[languageCode].custom["6.11.0"] = {"0", "Greed Donation Machine", "次の実績：{1}枚 残り：{2}枚　　　"}
end
