--------------------------------------
-----  Basic Polish descriptions  ----
--------------------------------------

-- FORMAT: Item ID | Name | Description

-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  ! = Warning  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "pl"

-- init pl table
EID.descriptions[languageCode] = {}
EID.descriptions[languageCode].custom = {} -- table for custom entity descriptions
EID.descriptions[languageCode].languageName = "Polish (WIP)"
EID.descriptions[languageCode].alternativeLanguageCodes = {"polish"}

-- Fonts to be used with this language pack
EID.descriptions[languageCode].fonts = EID.descriptions["en_us"].fonts

---------- Collectibles ----------
EID.descriptions[languageCode].collectibles={
	{"1", "Smutna Cebula", "↑ +0.7 Szybkostrzelności"},
	{"2", "Wewnętrzne Oko", "Potrójny strzał#↓ Mniejsza Szybkostrzelność"},
	{"3", "Wygięta Łyżka", "Naprowadzane łzy"},
	{"4", "Głowa Cricketa", "↑ +0.5 Obrażeń#↑ +50% Mnożnik Obrażeń"},
	{"5", "Moje Odbicie", "Daje łzom efekt bumerangu#↑ +1.5 Zasięgu#↑ +0.6 Prędkości Strzałów#↑ +1 Wysokości lotu łez"},
	{"6", "Numer Jeden", "↑ +1.5 Szybkostrzelności#↓ -17.62 Zasięgu#↑ +0.76 Wysokości lotu łez"},
	{"7", "Krew Męczennika", "↑ +1.0 Obrażeń#↑ +50% jeśli masz Księgę Beliala {{Collectible34}}"},
	{"8", "Braciszek Robercik", "Sojusznik ze zwykłymi łzami#Zadaje 3.5 Obrażeń na łzę"},
	{"9", "Skatol", "Wszystkie wrogie muchy są teraz przyjazne"},
	{"10", "Aureola z Much", "+2 orbitujące muchy#Blokują wrogie pociski"},
	{"11", "1up!", "↑ +1 Życie#Odrodzisz się z pełnym zdrowiem"},
	{"12", "Magiczny Grzyb", "↑ +1 Serce#↑ +0.3 Obrażeń#↑ +50% Mnożnik Obrażeń#↑ +5.25 Zasięgu#↑ +0.3 Prędkości#↑ +0.5 Wysokości lotu łez#Pełne zdrowie!"},
	{"13", "Wirus", "Zatruwasz dotykiem#↓ -0.1 Prędkości#Zatruci wrogowie mogą upuścić czarne serca"},
	{"14", "Furia na Sterydach", "↑ +0.6 Prędkości#↑ +5.25 Zasięgu#↑ +0.5 Wysokości lotu łez"},
	{"15", "<3", "↑ +1 Serce#Pełne zdrowie"},
	{"16", "Surowa Wątroba", "↑ +2 Serca#Pełne zdrowie"},
	{"17", "Klucz Uniwersalny", "+99 Kluczy"},
	{"18", "Dolar", "+99 Monet"},
	{"19", "Bum!", "+10 Bomb"},
	{"20", "Transcendencja", "Latanie!"},
	{"21", "Kompas", "Ujawnia wszystkie ikony na mapie#Nie pokazuje układu mapy"},
	{"22", "Drugie Śniadanie", "↑ +1 Serce"},
	{"23", "Obiad", "↑ +1 Serce"},
	{"24", "Deser", "↑ +1 Serce"},
	{"25", "Śniadanie", "↑ +1 Serce"},
	{"26", "Zgniłe Mięso", "↑ +1 Serce"},
	{"27", "Drewniana Łyżka", "↑ +0.3 Prędkości"},
	{"28", "Pas", "↑ +0.3 Prędkości"},
	{"29", "Bielizna Mamy", "↑ +5.25 Zasięgu#↑ +0.5 Wysokości lotu łez"},
	{"30", "Szpilki Mamy", "↑ +5.25 Zasięgu#↑ +0.5 Wysokości lotu łez"},
	{"31", "Szminka Mamy", "↑ +5.25 Zasięgu#↑ +0.5 Wysokości lotu łez"},
	{"32", "Druciany Wieszak", "↑ +0.7 Szybkostrzelności"},
	{"33", "Biblia", "Latanie w tym pokoju#Natychmiastowo zabija Mamę, Serce Matki oraz To Żyje#!!! Zabija CIEBIE jeśli użyjesz na Szatanie"},
	{"34", "Księga Beliala", "↑ +2 Obrażeń#↑ +12.5% szansy na Pokój Diabła{{DevilRoom}}#↑ +50% Mnożnik Obrażeń jeśli posiadasz Krew Męczennika {{Collectible7}}"},
	{"35", "Nekronomikon", "Zadaje 40 obrażeń przeciwnikom w pokoju"},
	{"36", "Kupa", "Tworzy jedną kupę#Stwórz ją przy przepaści i zniszcz bombą, aby zrobić most"},
	{"37", "Pan Bum", "Tworzy pod tobą dużą bombę zadającą 110 obrażeń"},
	{"38", "Głowa Tammy", "Wystrzeliwuje wokół ciebie 10 łez"},
	{"39", "Stanik Mamy", "Zamraża wszystkich przeciwników w pokoju na 4 sekundy"},
	{"40", "Kamikaze!", "Powoduje eksplozję pod twoimi nogami#Zadaje 40 obrażeń"},
	{"41", "Podpaska Mamy", "Straszy wszystkich przeciwników w pokoju na 5 sekund"},
	{"42", "Zgniły Łeb Boba", "Trująca bomba do rzucania"},
	{"43", "", "<przedmiot nie istnieje>"},
	{"44", "Teleport!", "Teleportuje cię do dowolnego, losowego pokoju poza pokojem I AM ERROR"},
	{"45", "Serduszko", "Leczy 1 czerwone serce"},
	{"46", "Szczęśliwa Stopa", "↑ +1.0 Szczęścia#Zwiększa szanse wygranej na automatach#Zwiększa szanse na nagrodę po oczyszczeniu pokoju"},
	{"47", "Pilot Doktora", "Epic Fetus na żądanie#Kontrolowane Naloty"},
	{"48", "Strzała Kupidyna", "Penetrujące łzy"},
	{"49", "Shoop da Whoop!", "Laser zadający duże obrażenia"},
	{"50", "Steven", "↑ +1 Obrażeń"},
	{"51", "Pentagram", "↑ +1.0 Obrażeń#↑ +10% szansy na Pokój Diabła{{DevilRoom}}"},
	{"52", "Dr. Fetus", "Bomby zamiast łez"},
	{"53", "Magneto", "Przyciąga do ciebie pickupy"},
	{"54", "Mapa Skarbów", "Ujawnia układ piętra"},
	{"55", "Oko Mamy", "Szansa na dodatkowy strzał z tyłu głowy#Szansa ta wynosi 100% przy 2 Szczęścia"},
	{"56", "Wypadek z Cytryną", "Tworzy kałużę lemoniady#Zadaje wrogom 66 Obrażeń kontaktowych"},
	{"57", "Podziw z Daleka", "Orbitująca mucha na średnim dystansie#Zadaje wrogom 75 Obrażeń kontaktowych"},
	{"58", "Księga Cieni", "Nieśmiertelność na 10 sekund"},
	{"59", "", "<przedmiot nie istnieje>"},
	{"60", "Drabina", "Możesz przechodzić przez pojedyńcze dziury"},
	{"61", "", "<przedmiot nie istnieje>"},
	{"62", "Urok Wampira", "Leczy pół serca co 13 zabitych wrogów"},
	{"63", "Bateria", "Przedmioty na spację mogą być naładowane dwukrotnie"},
	{"64", "Wyprzedaż Steam", "Zniżka -50% na wszystko w sklepie#Zebranie dwóch sprawi, że wszystko będzie darmowe"},
	{"65", "Książka Kucharska Anarchisty", "Tworzy 6 troll bomb w pobliżu środka pokoju"},
	{"66", "Klepsydra", "Spowalnia przeciwników na 8 sekund"},
	{"67", "Siostra Madzia", "Sojusznik ze zwykłymi łzami#Zadaje 3.5 Obrażeń na łzę"},
	{"68", "Technologia", "Laser zamiast łez"},
	{"69", "Mleko Czekoladowe", "Ładowane łzy#↑ Aż do 400% Obrażeń#↓ Mniejsza Szybkostrzelność"},
	{"70", "Hormony Wzrostu", "↑ +1.0 Obrażeń#↑ +0.4 Prędkości"},
	{"71", "Mini Grzybek", "↑ +0.3 Prędkości#↓ -4.25 Zasięgu*#↑ +1.5 Wysokości lotu łez*#(*razem wychodzi nieco większy Zasięg)#↑ Malejesz"},
	{"72", "Różaniec", "+3 Serca Duszy#Biblia pojawia się częściej"},
	{"73", "Kostka Mięsa", "LVL1: Orbituje#LVL2: Orbituje i strzela#LVL3: Meat Boy poziomu 1#LVL4: Meat Boy poziomu 2"},
	{"74", "Ćwierćdolarówka", "+25 monet"},
	{"75", "Doktorat", "Lepsze pigułki# +1 pigułka#Leczy 2 serca#Więcej pieniędzy z Automatu Krwiodawstwa"},
	{"76", "X-Ray w Oczach", "Odsłania wejścia do sekretnych pokoi"},
	{"77", "Mój Mały Jednorożec", "Nieśmiertelność#Zadajesz 40 obrażeń kontaktowych"},
	{"78", "Księga Objawień", "+1 Serce duszy#Po użyciu większa szansa na Jeźdźca jako bossa#↑ +17.5% szansy na Pokój Diabła{{DevilRoom}}"},
	{"79", "Znak", "↑ +1.0 Obrażeń#↑ +0.2 Prędkości#+1 Serce Duszy"},
	{"80", "Pakt", "↑ +0.5 Obrażeń#↑ +0.7 Szybkostrzelności#+2 Serca Duszy"},
	{"81", "Martwy Kot", "↑ +9 Żyć#Odrodzisz się z 1 Sercem#↓ Ustawia ilość twoich czerwonych serc na 1"},
	{"82", "Pan Otchłani", "Latanie#↑ +0.3 Prędkości"},
	{"83", "Gwóźdź", "+1 Serce duszy#↑ +0.7 Obrażeń#↓ -0.18 Prędkości#Zadajesz Obrażenia kontaktowe#Miażdżysz kamienie"},
	{"84", "Musimy Kopać Dalej!", "Tworzy zapadnię z przejściem na następne piętro#10% szans na wejście do szczeliny"},
	{"85", "Talia Kart", "Tworzy 1 Kartę"},
	{"86", "Ząb Monstro", "Przyzywasz Monstro na jeden atak"},
	{"87", "Rogi Loki'ego", "Szansa na wystrzał w 4 kierunkach"},
	{"88", "Mały Chubby", "Sojusznik szarżujący w przód#Zadaje 52.5 obrażeń kontaktowych na sekundę"},
	{"89", "Ugryzienie Pająka", "Szansa na wystrzelenie łez spowalniającyh"},
	{"90", "Kamyczek", "↑ +1 Obrażeń#↑ +0.2 Szybkostrzelności#↓ -0.2 Prędkości"},
	{"91", "Czapka Speleologa", "Wyjawia typy sąsiednich pokoi#Może wyjawić równiż pokoje sekretne, super sekretne i pokoje mini-bossów"},
	{"92", "Super Bandaż", "↑ +1 Serce#+2 Serca duszy"},
	{"93", "Gamekid", "Nieśmiertelność +obrażenia kontaktowe#Zjadanie przeciwników regeneruje zdrowie"},
	{"94", "Sakiewa z Monetami", "Upuszcza losową monetę co 2 pokoje"},
	{"95", "Robo-Dziecko", "Laserowe łzy#Zadaje 3.5 obrażeń na strzał"},
	{"96", "Mały C.H.A.D.", "Upuszcza pół serca co 3 pokoje"},
	{"97", "Księga Grzechu", "Tworzy losowy PickUp"},
	{"98", "Relikt", "Tworzy 1 Serce duszy co 5-6 pokoi"},
	{"99", "Mały Gish", "Spowalniające łzy#Zadaje 3.5 obrażeń na strzał"},
	{"100", "Mały Steven", "Naprowadzane łzy#Zadaje 3.5 obrażeń na strzał"},
	{"101", "Aureola", "↑ +1 Serce#↑ +0.3 Obrażeń#↑ +0.2 Szybkostrzelności#↑ +0.25 Zasięgu#↑ +0.3 Prędkości#↑ +0.5 Wysokości lotu łez"},
	{"102", "Butelka Pigułek Mamy", "Tworzy 1 Pigułkę"},
	{"103", "Przeziębienie", "Szansa na wystrzelenie Trujących łez"},
	{"104", "Pasożyt", "Łzy rozdzielają się na 2 przy kontakcie#Rozdzielone łzy zadają połowę obrażeń"},
	{"105", "D6", "Przelosowuje przedmioty na piedestałach w obecnym pokoju"},
	{"106", "Pan Mega", "↑ Obrażenia od bomb x2.25#+5 Bomb"},
	{"107", "Nożyce do Tkaniny", "Latanie#Twoje ciało atakuje wrogów, zadając im 82.5 obrażeń kontaktowych na sekundę"},
	{"108", "Opłatek", "Wszelkie otrzymane obrażenia są redukowane do połowy serca"},
	{"109", "Pieniądze = Siła", "↑ +0.04 Obrażeń za każdą posiadaną monetę"},
	{"110", "Soczewki Mamy", "Szansa na wystrzelenie Zamrażających Łez#↑ +0.25 Zasięgu#↑ +0.5 Wysokości lotu łez"},
	{"111", "Fasola", "Trujący pierd"},
	{"112", "Anioł Stróż", "Orbituje#Przyspiesza orbitujących sojuszników#Blokuje pociski#Zadaje 105 obrażeń kontaktowych na sekundę"},
	{"113", "Demoniczne Dziecko", "Samostrzelający sojusznik#Zadaje 3 obrażeń na strzał"},
	{"114", "Nóż Mamy", "Kontrolowany atak nożem#Trzymany, nóż zadaje 2x twoje obrażenia oraz 6x twoich obrażeń będąc w najdalszym, możliwym punkcie"},
	{"115", "Plansza Ouija", "Widmowe łzy"},
	{"116", "Bateria 9V", "-1 Wymagany Ładunek aktywnych przedmiotów#W pełni ładuje obecny aktywny przedmiot"},
	{"117", "Martwy Ptak", "Tworzy ptaka, gdy zostaniesz trafiony#Ptak zadaje 4 obrażeń kontaktowych na sekundę"},
	{"118", "Ogień Piekielny", "Krwawy, ładowany laser zamiast łez, zadający ciągłe obrażenia"},
	{"119", "Worek na Krew", "↑ +1 Serce#↑ +0.3 Prędkości#Leczy 5 Serc"},
	{"120", "Dziwaczny Grzyb", "↑ +1.7 Szybkostrzelności#↑ +0.3 Prędkości#↓ -10% Obrażeń#↓Dodatkowo -0.4 obrażeń"},
	{"121", "Dziwny Grzyb", "↑ +1 Pusty zasobnik na serce#↑ +0.3 Obrażeń#↑ +0.25 Zasięgu#↓ -0.1 Prędkości#↑ +0.5 Wysokości lotu łez"},
	{"122", "Nierządnica z Babilonu", "!!! Mając pół czerwonego serca lub mniej:#↑ +1.5 Obrażeń#↑ +0.3 Prędkości"},
	{"123", "Księga Potworów", "Losowy sojusznik na obecny pokój"},
	{"124", "Zwoje znad Morza Martwego", "Losowy efekt aktywnego przedmiotu"},
	{"125", "Bobby-Bomba", "Naprowadzane bomby#+5 Bomb"},
	{"126", "Żyletka", "↑ +1.2 Obrażeń w obecnym pokoju#↓ Zadaje ci 1 serce obrażeń"},
	{"127", "Zapominajka", "Przelosowuje całe piętro"},
	{"128", "Wiecznie Samotny", "Orbitująca mucha#Trzyma się daleko#Zadaje 30 obrażeń kontaktowych na sekundę"},
	{"129", "Wiadro Smalcu", "↑ +2 Puste zasobniki na serce#↓ -0.2 Prędkości#Leczy połowę serca"},
	{"130", "Kucyk", "Latanie, gdy trzymasz ten przedmiot#Ustawia twoją prędkość na 1.5 jeżeli masz mniejszą#Przy użyciu Szarża w wybranym kierunku#"},
	{"131", "Torba na Bomby", "Upuszcza 1 Bombę do podniesienia co 2-3 pokoje"},
	{"132", "Bryła Węgla", "Obrażenia wzrastają wraz z przebytym przez łzę dystansem"},
	{"133", "Łapka Guppy'ego", "!!! Zamienia:#1 Czerwone serce na 3 Serca duszy"},
	{"134", "Ogon Guppy'ego", "Pojawia się więcej skrzynek"},
	{"135", "Kroplówka", "Przenośny automat krwiodawsta#Pół serca = 1-3 Monet"},
	{"136", "Najlepszy Przyjaciel", "Wybuchowa przynęta#Wabi przeciwników"},
	{"137", "Zdalny Detonator", "Detonacja bomb na życzenie#+5 bomb"},
	{"138", "Znamię", "↑ +1 Serce#↑ +0.3 Obrażeń"},
	{"139", "Torebka Mamy", "Możesz mieć 2 trynkiety na raz"},
	{"140", "Przekleństwo Boba", "Trujące bomby#+5 bomb"},
	{"141", "Balowy Chłopak", "Tworzy 7 losowych monet"},
	{"142", "Szkaplerz", "Gdy obrażenia sprowadzą twoje zdrowie do połowy serca, dostajesz 1 Serce duszy#(Raz na pokój)"},
	{"143", "Mieszanka", "↑ +0.3 Prędkości#↑ +0.2 Prędkości Strzałów"},
	{"144", "Przybłęda", "Zamienia Monety w Pickupy"},
	{"145", "Głowa Guppy'ego", "Tworzy 2-4 niebieskich much"},
	{"146", "Modlitewnik", "+1 Wieczne serce"},
	{"147", "Karbowana Siekiera", "W tym pokoju niszczysz kamienie dotykiem"},
	{"148", "Zarażenie", "Tworzy muchy, gdy zostaniesz trafiony"},
	{"149", "Wymiotnica", "Wybuchowe, trujące łzy#↑40 Obrażeń#↓ Szybkostrzelność"},
	{"150", "Miłosne Poświęcenie", "Szansa na strzał zębem#Zęby zadają 3.2x twoich obrażeń"},
	{"151", "Mucharz", "1/6 szansy na stworzenie muchy, gdy twoje łzy trafią przeciwnika"},
	{"152", "Technologia 2", "Permanentny laser!#↓ -35% Obrażeń"},
	{"153", "Zmutowany Pająk", "Poczwórny Strzał!#↓ Szybkostrzelność Maleje"},
	{"154", "Peeling Chemiczny", "↑ +2 Obrażeń z lewego oka"},
	{"155", "Podglądacz", "Lata po pokoju#Zadaje 17.1 obrażeń kontaktowych na sekundę"},
	{"156", "Habit", "+1 Ładunek, gdy otrzymujesz obrażenia"},
	{"157", "Krwawa Żądza", "↑ Obrażenia rosną za każdym razem, gdy zostaniesz trafiony#Działa do 6 razy na piętro#Efekt utrzymuje się przez całe piętro"},
	{"158", "Kryształowa Kula", "Ujawnia całą mapę#Upuszcza losową Kartę albo Serce duszy"},
	{"159", "Duch Nocy", "Latanie#Widmowe łzy"},
	{"160", "Rozerwanie Nieba", "Tworzy 5 promieni światła przy przeciwnikach #Zadają twoje obrażenia +20"},
	{"161", "Anch", "Po śmierci odrodzisz się jako ??? (Blue Baby)"},
	{"162", "Krzyż Celtycki", "Szansa na Nieśmiertelność, gdy zostaniesz trafiony"},
	{"163", "Dziecko-Duch", "Sojusznik z Widowymi łzami#Zadaje 3.5 obrażeń na strzał"},
	{"164", "Świeca", "Tworzy niebieski ogień#Zadaje obrażenia kontaktowe#Blokuje wrogie łzy#Znika po 2 sekundach"},
	{"165", "Kańczug", "↑ +1 Obrażeń#↑ +0.23 Prędkości Strzałów"},
	{"166", "D20", "Przelosowuje Pickupy"},
	{"167", "Arlekinowe Dziecko", "Strzela dwiema łzami w kształcie V#Zadaje 4 obrażeń na strzał"},
	{"168", "Epicki Fetus", "Kontrolowany nalot zamiast łez#Zadaje twoje obrażenia x20"},
	{"169", "Polifem", "Mega Łzy!#↑ +100% Obrażeń#↑ +4 dodatkowe Obrażenia#↓ Szybkostrzelność Maleje"},
	{"170", "Tatuś Kosarzy", "Depta wrogów#Zadaje 40 obrażeń na sekundę"},
	{"171", "Tyłek Pająka", "Spowalnia wrogów na 4 sekundy#Zadaje 10 obrażeń wszystkim wrogom"},
	{"172", "Sztylet Ofiarny", "Orbitujący nóż#Blokuje wrogie strzały#Zadaje 225 obrażeń na sekundę"},
	{"173", "Mitra", "Większa szansa na znalezienie serc dusz"},
	{"174", "Tęczowe Dziecko", "Strzela losowymi łzami#Zadaje 3-5 obrażeń na strzał"},
	{"175", "Klucz Taty", "Otwiera wszystkie drzwi w obecnym pokoju, nawet do sekretnych pokoi"},
	{"176", "Komórki Macierzyste", "↑ +1 Serce#↑ +0.16 Prędkości Strzałów"},
	{"177", "Przenośny Automat", "Przenośny automat do gier"},
	{"178", "Woda Święcona", "Tworzy kałużę mazi, gdy zostaniesz trafiony#Zadaje 24 obrażeń na sekundę"},
	{"179", "Przeznaczenie", "Latanie#+1 Wieczne serce"},
	{"180", "Czarna Fasola", "Pierd przy dotyku"},
	{"181", "Biały Kucyk", "Latanie, gdy trzymasz ten przedmiot#Ustawia twoją prędkość na 1.5 jeżeli masz mniejszą#Przy użyciu Szarża w wybranym kierunku#Szarżując, tworzysz raniące wrogów słupy światła"},
	{"182", "Najświętsze Serce", "Naprowadzane łzy#↑ +1 Serce#↑ 230% +1 Obrażeń#↓ -0.4 Szybkostrzelności#↓ -0.25 Prędkości Strzałów#↑ +4.125 Zasięgu"},
	{"183", "Wykałaczki", "↑ +0.7 Szybkostrzelności.#↑ +0.16 Prędkości Strzałów"},
	{"184", "Święty Graal", "Daje latanie#↑ +1 Serce"},
	{"185", "Martwy Gołąb", "Latanie#Widmowe łzy"},
	{"186", "Prawo Krwi", "Zadaje 40 obrażeń każdemu przeciwnikowi#Zadaje ci 1 serce obrażeń"},
	{"187", "Kłaczek Guppy'ego", "Rosnąca kula włosów#Huśta się w okół ciebie#Rośnie, gdy zabija wrogów#Im jest większa, tym większe obrażenia zadaje"},
	{"188", "Abel", "Odzwierciedla twoje ruchy#Strzela w twoim kierunku#Zadaje 3.5 obrażeń na strzał"},
	{"189", "Super Fan SMB", "↑ +1 Serce#↑ +0.3 Obrażeń#↑ +0.2 Szybkostrzelności#↑ +0.5 Zasięgu#↑ +0.2 Prędkości#↑ +1.0 Wysokości lotu łez#Pełne zdrowie"},
	{"190", "Piromania", "+99 Bomb"},
	{"191", "Banknot 3 Dolarowy", "Losowy efekt łez co 2-3 sekundy"},
	{"192", "Telepatia Dla Opornych", "Naprowadzane łzy w obecnym pokoju"},
	{"193", "MIĘSO!", "↑ +1 Serce#↑ +0.3 Obrażeń"},
	{"194", "Magiczna Kula nr 8", "↑ +0.16 Prędkości pocisków#+1 karta"},
	{"195", "Portmonetka Mamy", "Upuszcza 4 Pigułki"},
	{"196", "Gniotek", "Tworzy 2 Serca duszy#↑ +0.4 Szybkostrzelności"},
	{"197", "Sok z Winogron", "↑ +0.5 Obrażeń#↑ +0.25 Zasięgu#↑ +0.5 Wysokości lotu łez"},
	{"198", "Pudełko", "Tworzy 1 pickup każdego rodzaju"},
	{"199", "Klucz Mamy", "+2 Klucze#Ze skrzynek wypada więcej rzeczy"},
	{"200", "Cień do Powiek Mamy", "Szansa na wystrzelenie czarujących przeciwników łez"},
	{"201", "Sztabka Żelaza", "↑ +0.3 Obrażeń#Szansa na wystrzelenie ogłuszających łez"},
	{"202", "Dotyk Midasa", "Przy dotyku zamienia wrogów w złoto#Zadaje obrażenia kontaktowe dostosowane do liczby twoich monet#Złoci wrogowie upuszczają monety"},
	{"203", "Pokorny Pakiet", "Podwaja wszystkie pickupy"},
	{"204", "Nerka", "50% na upuszczenie losowego pickupa, gdy zostaniesz trafiony"},
	{"205", "Ostra Wtyczka", "-2 Serca = W pełni ładuje twój przedmiot przy wciśnięciu spacji#!!! Działa tylko, gdy przedmiot nie ma ładunków!"},
	{"206", "Gilotyna", "↑ +1 Obrażeń#↑ Szybkostrzelność#Twoja głowa teraz orbituje wokół ciała#Strzelasz z głowy#Głowa zadaje 105 obrażeń kontaktowych"},
	{"207", "Kula z Bandaży", "LVL1: Orbituje#LVL2: Orbituje i strzela#LVL3: Dziewczyna z bandaży poziomu 1#LVL4: Dziewczyna z bandaży poziomu 2"},
	{"208", "Pas Mistrza", "↑ +1 Obrażeń#!!! Więcej Mistrzowskich Przeciwników"},
	{"209", "Dupne Bomby", "↑ +5 Bomb#Wybuchy ogłuszają i ranią każdego przeciwnika w pokoju"},
	{"210", "Nadgryziony Listek", "Jesteś nietykalny, jeśli stoisz nieruchomo przez conajmniej 1 sekundę"},
	{"211", "Pajęcze Dziecię", "Pojawia 1-2 pająki, gdy zostaniesz trafiony"},
	{"212", "Obroża Guppy'ego", "↑ 50% szansy na odrodzenie"},
	{"213", "Zgubiona Soczewka", "Łzy z tarczą#Blokują wrogie pociski#↓ -0.16 Prędkości Strzałów"},
	{"214", "Anemik", "↑ +5 Zasięgu#Zostawiasz pod sobą maź, gdy zostaniesz trafiony"},
	{"215", "Kozia Głowa", "↑ 100% szans na pokój Diabła{{DevilRoom}} / Anioła{{AngelRoom}}"},
	{"216", "Szaty Ceremonialne", "↑ +1 Obrażeń#+3 Czarne serca"},
	{"217", "Peruka Mamy", "Losowa szansa na stworzenie niebieskiego pająka gdy strzelasz#Leczy 1 czerwone serce przy podniesieniu"},
	{"218", "Łożysko", "↑ +1 Serce#Powoli regeneruje zdrowie"},
	{"219", "Stary Bandaż", "↑ +1 Pusty zasobnik na serce#Losowa szansa na upuszczenie serca, gdy zostaniesz trafiony"},
	{"220", "Smutne Bomby", "Wybuch łez!#+5 Bomb"},
	{"221", "Klej Kauczukowy", "Odbijające się łzy"},
	{"222", "Antygrawitacja", "↑ 2 Szybkostrzelności#Antygrawitacyjne łzy"},
	{"223", "Piroman", "Wybuchy cię leczą#+5 Bomb"},
	{"224", "Ciało Cricketa", "↑ +1 Szybkostrzelności#↓ -10 Zasięgu#Łzy rozdzielają się na 4 przy trafieniu#Powstałe łezki zadają połowiczne obrażenia"},
	{"225", "Pokraka", "Szansa na upuszczenie Serca Duszy/Czarnego Serca, gdy zostaniesz trafiony#Szansa na stworzenie połówki serca przy zabiciu wroga"},
	{"226", "Czarny Lotos", "↑ +1 Serce#+1 Serce Duszy#+1 Czarne Serce"},
	{"227", "Świnka Skarbonka", "+3 Monety#Upuszczasz 1-2 monet, gdy zostaniesz trafiony#Dozorca/Keeper upuszcza 0-1 monet"},
	{"228", "Perfumy Mamy", "Szana na straszące wrogów strzały#↑ +1 Szybkostrzelności"},
	{"229", "Płuco Monstro", "Łzy muszą być teraz naładowane i wystrzelone w stylu strzelby"},
	{"230", "Abaddon", "↑ +1.5 Obrażeń#↑ +0.2 Prędkości#Straszące wrogów łzy#↓ Usuwa wszystkie czerwone serca#+6 Czarnych Serc"},
	{"231", "Kulka Smoły", "Szansa na wystrzelenie spowalniającyh łez#Zostawiasz spowalniającą maź#"},
	{"232", "Stop-Er", "Permanentny efekt spowolnienia#(aktywowany przy zostaniu trafionym)#↑ +0.3 Prędkości"},
	{"233", "Tycia Planeta", "Łzy orbitują wokół ciebie#↑ +7.0 Wysokość lotu łez#Widmowe łzy"},
	{"234", "Zarażenie 2", "Tworzy pająki, gdy zabijasz wrogów"},
	{"235", "", "<przedmiot nie istnieje>"},
	{"236", "Pałeczka Okrężnicy", "Dotykiem zamieniasz przeciwników w kupy"},
	{"237", "Dotyk Śmierci", "Kosy zamiast łez!#↑ +1.5 Obrażeń#↓ -0.3 Szybkostrzelności#Penetrujące łzy"},
	{"238", "Fragment Klucza 1", "!!! Kawałek klucza do drzwi Mega Szatana!#Pojawia się więcej Pokoi Anioła{{AngelRoom}}"},
	{"239", "Fragment Klucza 2", "!!! Kawałek klucza do drzwi Mega Szatana!#Pojawia się więcej Pokoi Anioła{{AngelRoom}}"},
	{"240", "Terapia Eksperymentalna", "Wszystkie statystyki rosną↑ lub maleją↓ o losową ilość"},
	{"241", "Kontrakt Spod Ziemi", "Podwaja wszystkie Pickupy#Brak efektu w Trybie Chciwym/Greed Mode"},
	{"242", "Niesława", "50% Szans na zablokowanie wrogich łez"},
	{"243", "Tarcza Trójcy", "Tarcza blokująca łzy"},
	{"244", "Tech.5", "Losowo strzelasz laserowym typem łez"},
	{"245", "20/20", "Podwaja wszystkie twoje strzały"},
	{"246", "Niebieska Mapa", "Ujawnia Sekretne Pokoje"},
	{"247", "BFFS!", "Twoi Sojusznicy zadają podwójne obrażenia"},
	{"248", "Jeden Umysł", "Niebieskie Pająki/Muchy zadają podwójne obrażenia"},
	{"249", "Istnieją Możliwości", "2 Przedmioty za pokonanie Bossa zamiast 1#!!! Tylko jeden może być wzięty"},
	{"250", "Druga Bomba Gratis", "Podwaja wszystkie pojawienia się bomb"},
	{"251", "Talia Startowa", "Możesz trzymać 2 Karty#Zamienia wszystkie Pigułki w Karty"},
	{"252", "Torebeczka", "Możesz trzymać 2 Pigułki#Zamienia wszystkie Karty w Pigułki"},
	{"253", "Magiczny Strup", "↑ +1 Szczęścia#↑ +1 Serce"},
	{"254", "Zakrzep", "↑ +1 Obrażeń#↑ +5 Zasięgu#!!! Wpływa tylko na lewe oko"},
	{"255", "Śrubka", "↑ +0.5 Szybkostrzelności#↑ +0.2 Prędkości Strzałów"},
	{"256", "Gorące Bomby", "Płonące bomby#+5 Bomb"},
	{"257", "Płomienny Umysł", "Szansa na wybuchowe łzy#Łzy zapalają wrogów"},
	{"258", "Missing No.", "Przelosowuje twoje przedmioty i statystyki przy podniesieniu oraz z każdą zmianą piętra"},
	{"259", "Ciemna Materia", "↑ +1 Obrażeń#Szansa na wystrzelenie straszących strzałów"},
	{"260", "Czarna Świeca", "Odporność na klątwy#+1 Czarne Serce#Zwiększona szansa na Pokój Diabła{{DevilRoom}}/Anioła{{AngelRoom}}"},
	{"261", "Wytrzeszcz", "↑ +100% Obrażeń#↓ Obrażenia spadają wraz z przebytym dystansem łez"},
	{"262", "Brakująca Kartka 2", "+1 Czarne Serce#Kiedy twoje zdrowie spadnie do 1 Serca, ranisz wszystkich wrogów w pokoju"},
	{"263", "", "<przedmiot nie istnieje>"},
	{"264", "Mądra Muszka", "Orbituje#Atakuje wrogów, gdy zostaniesz trafiony#Zadaje 22.5 obrażeń na sekundę"},
	{"265", "Bezwodnik", "Ma 10% szans na zranienie wszystkich wrogów w pokoju, gdy zostanie trafiony łzą przeciwnika"},
	{"266", "Soczysty Wór", "Zostawia spowalniającą maź#Tworzy 1-2 przyjazne pająki po oczyszczeniu pokoju"},
	{"267", "Robo-Dziecko 2.0", "Strzela laserem#Zadaje 3.5 obrażeń na strzał#Porusza się w kierunku, w którym strzelasz"},
	{"268", "Zgniłe Dziecko", "Tworzy niebieskie muchy, gdy strzelasz"},
	{"269", "Bezgłowe Dziecko", "Zostawia na ziemi maź, zadającą 6 obrażeń na sekundę"},
	{"270", "Pijawka", "Leczy pół serca przy zabiciu wroga#Zadaje 3.2 obrażeń na sekundę"},
	{"271", "Sakiewka Tajemnic", "Co kilka pokoi upuszcza losowe Pickupy"},
	{"272", "DPM", "Przyjazna wybuchowa mucha#Wybuch zadaje 60 Obrażeń"},
	{"273", "Mózg Boba", "Rzucany sojusznik w stylu bomby#Wybuch zadaje 60 Obrażeń"},
	{"274", "Najlepszy Kumpel", "Kiedy zostaniesz trafiony, dostajesz orbitującego sojusznika#Zadaje on 75 obrażeń na sekundę"},
	{"275", "Mały Piekielnik", "Strzela laserem z Ognia Piekielnego{{Collectible118}}"},
	{"276", "Serce Izaaka", "Twoje ciało jest teraz nieśmiertelne#!!! Otrzymujesz obrażenia, gdy Serce zostanie trafione"},
	{"277", "Straszak", "Przyjazny Sojusznik-Duch#Zadaje 4 obrażenia na sekundę"},
	{"278", "Mroczny Przybłęda", "!!! Zamienia:#1,5 Czerwonego serca w 1 Serce Duszy lub Pająka"},
	{"279", "Duży Fan", "Duży, gruby orbitujący Sojusznik#Zadaje 30 obrażeń na sekundę"},
	{"280", "Siostrzyczka Kosarzy", "Losowo tworzy niebieskie pająki w pokoju z wrogami"},
	{"281", "Kumpel Do Bicia", "Sojusznik-przynęta#Wrogowie będą atakować jego"},
	{"282", "Poradnik do Skakania", "Pozwala ci skakać"},
	{"283", "D100", "Przelosowuje wszystkie Pickupy, piedestały i twoje pasywne przedmioty"},
	{"284", "D4", "Przelosowuje wszystkie twoje pasywne przedmioty"},
	{"285", "D10", "Przelosowuje wszystkich przeciwników w pokoju"},
	{"286", "Czysta Karta", "Kopiuje efekt twojej trzymanej karty, nie zużywając jej"},
	{"287", "Księga Tajemnic", "Ujawnia części mapy"},
	{"288", "Pudełko Pająków", "Pojawia 1-4 niebieskich pająków"},
	{"289", "Czerwona Świeca", "Rzuca czerwony płomień#Płomień zniknie po zadaniu obrażeń 5 razy"},
	{"290", "Słoik", "Może przechować do 4 czerwonych serc"},
	{"291", "Spłuczka!", "!!! Zabija przeciwników-kupy!#Zamienia normalnych przeciwników w kupy"},
	{"292", "Biblia Szatana", "+1 Czarne serce"},
	{"293", "Głowa Krampusa", "Strzela laserem z Ognia Piekielnego{{Collectible118}} w 4 kierunkach"},
	{"294", "Maślana Fasola", "Odrzuca pobliskich przeciwników i strzały#Przy zmianie na inny przedmiot aktywny, po czym podniesieniu tego ponownie, ma 10% szans na zmianę w silniejszy przedmiot Chwila, Co?{{Collectible484}}"},
	{"295", "Cudowne Pudełeczko", "Rani wszystkich wrogów w pokoju twoimi obrażeniami x2#Koszt: 1 moneta{{Coin}}"},
	{"296", "Przetwornik", "!!! Konwertuje:#2 Serca Duszy/Czarne w 1 Czerwone Serce"},
	{"297", "Puszka Pandory", "Upuszcza przedmioty zależnie od piętra:#B1: 2 Serca Duszy#B2: 2 klucze i bomby#C1: 1 Przedmiot z bossa#C2: 2 Serca Duszy + 1 Przedmiot z bossa#D1: 4 Serca Duszy#D2: 20 Monet#W1: 2 Przedmioty z bossów#W2: Biblia#Szeol: 1 Przedmiot Diabła{{DevilRoom}} + Czarne Serce#Katedra: 1 Przedmiot Anioła{{AngelRoom}} + Serce Duszy#Skrzynia: 1 Moneta"},
	{"298", "Odłamek Jednorożca", "+0.28 Prędkości oraz Nietykalność na 6 sekund #Nie możesz strzelać w trakcie trwania efektu"},
	{"299", "Byk", "Jesteś szybszy w pokoju z przeciwnikami!#Daje nietykalność gdy jesteś wystarczająco szybki"},
	{"300", "Baran", "↑ +0.25 Prędkości#Dotykanie przeciwników ich rani"},
	{"301", "Rak", "+3 Serca Duszy#Po otrzymaniu obrażeń, każde następne w tym samym pokoju zada połowę obrażeń"},
	{"302", "Lew", "Niszczysz kamienie wchodząc w nie"},
	{"303", "Panna", "Szansa na nietykalność, gdy zostaniesz trafiony#Zamienia negatywne pigułki w pozytywne"},
	{"304", "Waga", "+6 Monet{{Coin}}/Kluczy{{Key}}/Bomb{{Bomb}}#Balansuje twoje statystyki!#!!! Każde następne podniesienie statystyk wpłynie również na pozostałe"},
	{"305", "Skorpion", "Trujące łzy"},
	{"306", "Strzelec", "↑ +0.2 Prędkości#Penetrujące łzy"},
	{"307", "Koziorożec", "↑ +1 Serce{{Heart}}/ Klucz{{Key}}/ Bomba{{Bomb}}/ Moneta{{Coin}}#↑ +0.5 Obrażeń#↑ +0.1 Prędkości#↑ +1.5 Zasięgu#Większa Szybkostrzelność"},
	{"308", "Wodnik", "Zostawiasz za sobą maź#Zadaje ona 6 obrażeń na sekundę"},
	{"309", "Ryby", "↑ Większa Szybkostrzelność#Odrzucające łzy"},
	{"310", "Maskara Ewy", "↑ +100% Obrażeń#↓ Szybkostrzelność maleje#↓ -0.5 Prędkości Strzałów"},
	{"311", "Cień Judasza", "Po śmierci odradzasz się jako Czarny Judasz#↑ (Obrażenia x 2)"},
	{"312", "Kokardka Madzi", "↑ +1 Serce#Wszystkie czerwone serca leczą teraz podwójnie"},
	{"313", "Święte Okrycie", "Ignoruje pierwsze otrzymane obrażenia w każdym pokoju"},
	{"314", "Masywne Uda", "↑ +1 Serce#-0.4 Prędkości#Niszczysz kamienie wchodząc w nie"},
	{"315", "Nietypowy Przyciągacz", "Magnetyczne łzy#Wpływa na wrogów, pickupy i trynkiety"},
	{"316", "Przeklęte Oko", "Ładowalna fala łez#Kiedy ładujesz i zostaniesz trafiony, teleportuje cię do losowego pokoju"},
	{"317", "Tajemnicza Ciecz", "Łzy zostawiają maź#Zadaje ona 30 obrażeń na sekundę"},
	{"318", "Bliźnięta", "Sojusznik trzymający się blisko#Zadaje 6 obrażeń kontaktowych na sekundę"},
	{"319", "Drugie Oko Kaina", "Odbija się po pokoju#Strzela w twoją stronę#Jego obrażenia równe są twoim"},
	{"320", "Jedyny Przyjaciel ???", "Kontrolowana Mucha#Zadaje 5 obrażeń kontaktowych na sekundę"},
	{"321", "Łańcuch Samsona", "Niszcząca kamienie kula na łańcuchu, którą ciągniesz za sobą#Zadaje 10.7 obrażeń kontaktowych na sekundę"},
	{"322", "Mały Naśladowca", "Kopiuje efekt jednego z twoich sojuszników#Zadaje ich obrażenia x2"},
	{"323", "Łzy Izaaka", "Wystrzeliwujesz 8 łez we wszystkie kierunki#Ładuje się podczas strzelania"},
	{"324", "Niezdefiniowane", "Teleportuje cię do:#{{TreasureRoom}}Pokoju Skarbów, {{SecretRoom}}{{SuperSecretRoom}}Sekretu lub Pokoju Error"},
	{"325", "Nożyczki", "Odcina ci głowę#Twoja głowa od teraz stoi w miejscu#Kontrolujesz swoje ciało oddzielnie"},
	{"326", "Tchnienie Życia", "Trzymanie spacji do wyczerpania ładunków da ci nieśmiertelność#!!! Nie trzymaj za długo!"},
	{"327", "Polaroid", "Nieśmiertelność, gdy zostaniesz trafiony mając pół czerwonego serca lub kompletny jego brak"},
	{"328", "Negatyw", "Gdy zostaniesz trafiony mając pół czerwonego serca lub kompletny jego brak, ranisz wszystkich wrogów w pokoju"},
	{"329", "Technika Ludovica", "Kontrolowana łza"},
	{"330", "Mleko Sojowe", "↑ +Ogromna Szybkostrzelność: (opóźnienie /4) - 2#↓ -80% Obrażeń"},
	{"331", "Bóstwo", "Naprowadzane łzy#↑ +0.5 Obrażeń#↑ +1.2 Zasięgu#↓ -0.3 Szybkostrzelności#↓ -0.3 Prędkości Strzałów#↑ +0.8 Wysokości lotu łez#Łzy otrzymują aurę, zadającą obrażenia"},
	{"332", "Łachmany Łazarza", "Po śmierci odradzasz się jako Łazarz (Powstały)"},
	{"333", "Umysł", "Odkrywa całą mapę"},
	{"334", "Ciało", "↑ +3 Serca"},
	{"335", "Dusza", "+2 Serca Duszy#Dostajesz aurę odpychającą od ciebie wrogów oraz pociski"},
	{"336", "Martwa Cebula", "Penetrujące + Widmowe łzy#↓ -0.25 Zasięgu#↓ -0.4 Prędkości Strzałów#↑ +50% Wielkości łez"},
	{"337", "Zepsuty Zegarek", "Spowalnia lub przyspiesza co czwarty pokój"},
	{"338", "Bumerang", "Rzucany bumerang#Przy trafieniu wroga ogłusza go i zadaje mu twoje obrażenia x2#Może zbierać pickupy"},
	{"339", "Agrafka", "↑ +5.25 Zasięgu#↑ +0.16 Prędkości Strzałów#+1 Czarne Serce#↑ +0.5 Wysokości lotu łez"},
	{"340", "Kofeina w Kapsułce", "↑ +0.3 Szybkość#↑ Zmniejsza Isaaca#Upuszcza losową pigułkę"},
	{"341", "Rozdarte Zdjęcie", "↑ +0.7 Szybkostrzelności#↑ +0.16 Prędkości Strzałów"},
	{"342", "Niebieściak", "↑ +1 Serce#↑ +0.7 Szybkostrzelności#↓ -16% Prędkości Strzałów"},
	{"343", "Klucz od Mieszkania", "↑ +1 Szczęścia#+1 Serce Duszy#Pojawia 2 klucze"},
	{"344", "Pudełko Zapałek", "+1 Czarne Serce#+3 Bomby"},
	{"345", "Synthol", "↑ +1.0 Obrażeń#↑ +5.25 Zasięgu#↑ +0.5 Wysokości lotu łez"},
	{"346", "Przekąska", "↑ +1 Serce"},
	{"347", "Diplopia", "Duplikuje piedestały / pickupy w pokoju"},
	{"348", "Placebo", "Kopiuje efekt twojej trzymanej pigułki"},
	{"349", "Drewniany Pieniążek", "50% szansy na stworzenie losowej monety"},
	{"350", "Wstrząs Toksyczny", "Przy wejściu do pokoju zatruwa wszystkich obecnych przeciwników"},
	{"351", "Mega Fasola", "Zamraża wrogów w pokoju#Zadaje 5 obrażeń i zatruwa pobliskich przeciwników#Wysyła falę kolców#!!! Może być użyte do otwarcia {{SecretRoom}}Sekretnych Pokoi"},
	{"352", "Szklana Armata", "↓ Redukuje twoje zdrowie do pół serca#Strzela wielką widmową, penetrującą, łzą ((Obrażenia+1) X 10)"},
	{"353", "Bombowy Chłopak", "+5 Bomb#Bomby będą wybuchać w kształcie krzyżyka"},
	{"354", "Przysmak z Niespodzianką", "↑ +1 Serce#Pojawia na ziemi losowy trynkiet"},
	{"355", "Perły Mamy", "↑ +1.25 Zasięgu#↑ +1 Szczęścia#↑ +0.5 Wysokości lotu łez"},
	{"356", "Akumulator Samochodowy", "Sprawia, że twój przedmiot aktywny aktywuje się podwójnie"},
	{"357", "Pudełko z Przyjaciółmi", "Duplikuje twoich sojuszników na jeden pokój"},
	{"358", "Czaruś", "Strzelasz równocześnie dwiema łzami na skos, jak przy pigułce {{Pill}}JESTEŚ CZARODZIEJEM?#Widmowe łzy"},
	{"359", "Stalowe Gwoździe", "↑ +1.5 Obrażeń#Zwiększa odrzut"},
	{"360", "Inkub", "Strzela takimi samymi łzami jak ty, w odniesieniu do obrażeń, statystyk czy efektów"},
	{"361", "Nagroda od Losu", "Strzela łzami z takimi samymi obrażeniami, jak ty"},
	{"362", "Skrzyneczka", "Tworzy losowy pickup co kilka pokoi"},
	{"363", "Zaprzysiężony Obrońca", "Orbitujący sojusznik#Zadaje 105 obrażeń kontaktowych na sekundę#Blokuje i przyciąga pociski#Zablokowanie 10 łez w jednym pokoju da ci wieczne serce"},
	{"364", "Strefa Przyjaźni", "Orbitujący sojusznik#Zadaje 45 obrażeń kontaktowych na sekundę"},
	{"365", "Utracona Mucha", "Porusza się wzdłuż ścian/przeszkód w pokoju#Zadaje 105 obrażeń kontaktowych na sekundę"},
	{"366", "Bomby Rozpryskowe", "+5 bomb#Przy wybuchu twoje bomby rozpadają się na 2-4 mniejsze"},
	{"367", "Lepkie Bomby", "+5 bomb#Gdy bomba zabije przeciwnika, tworzy niebieskie pająki#Twoje bomby lepią się do wrogów"},
	{"368", "Łzawienie", "Strzelanie w jednym kierunku zwiększa szybkostrzelność maksymalnie o 200%"},
	{"369", "Kontinuum", "↑ +2.25 Zasięgu#↑ +1.5 Wysokości lotu łez#Łzy przechodzą przez ściany i wylatują z drugiej strony"},
	{"370", "Pan Laleczka", "↑ +0.7 Szybkostrzelności#↑ +5.25 Zasięgu#↑ +0.5 Wysokości lotu łez#Tworzy 3 losowe serca przy podniesieniu"},
	{"371", "Klątwa Wieży", "Tworzy 6 troll bomb za każdym razem, gdy zostaniesz trafiony#Przedmioty zmieniające bomby mają na to wpływ"},
	{"372", "Energiczne Dziecko", "Losowa szansa na upuszczenie baterii lub zamrożenie przeciwników w pokoju#Szansa na dodanie jednego ładunku do twojego przedmiotu aktywnego"},
	{"373", "Prosto w Cel", "↑ +12.5% obrażeń za każdą łzę, która trafi przeciwnika#(max. +100%)"},
	{"374", "Święta Światłość", "Losowa szansa na wystrzał Świętej łzy, która tworzy słup światła przy trafieniu#Promień światła zadaje 4x twoje obrażenia"},
	{"375", "Kapelusz Żywiciela", "20% szans na zablokowanie wrogiej łzy#Odporność na wybuchy/nadepnięcia Mamy i Szatana"},
	{"376", "Uzupełniacz", "Tworzy 3 losowe Pickupy#Sklepy natychmiast uzupełniają swoje zaopatrzenie, gdy tylko coś kupisz"},
	{"377", "Pękający Wór", "Wrogie pająki już cię nie atakują ani nie zadają ci obrażeń kontaktowych"},
	{"378", "Numer Dwa", "Ciągłe strzelanie przez 3 sekundy upuści Dupną Bombę"},
	{"379", "Podwójna Źrenica", "Łzy mają znacznie większy hitbox#Widmowe łzy"},
	{"380", "Płać By Grać", "+5 monet#Otwierasz drzwi monetami, zamiast kluczami"},
	{"381", "Błogosławieństwo Edena", "↑ +0.7 Szybkostrzelności#Na początku następnej rozgrywki dostajesz losowy przedmiot"},
	{"382", "Kula Przyjaźni", "Rzucona w przeciwnika nie-bossa złapie go#Następny rzut wypuści złapanego przeciwnika, który będzie walczyć dla ciebie"},
	{"383", "Detonator Łez", "Detonuje wszystkie łzy znajdujące się na ekranie, a każda z nich rozpada się na 6 kolejnych łez"},
	{"384", "Tyci Gurdy", "Wystrzeliwuje i ślizga się po pokoju#Zadaje 90 obrażeń kontaktowych na sekundę"},
	{"385", "Bumbo", "Zjada pobliskie monety#Co każde 6 monet zwiększa swój poziom, poza poziomem 4, który zajmuje mu 12 monet#Poziom 2: może upuścić losowy pickup#Poziom 3: Strzela w tym samym kierunku, co ty#Poziom 4: Zamiast strzelać goni wrogów. Losowo upuszcza bomby#Po Poziomie 4: dalej zjada monety i upuszcza losowe pickupy"},
	{"386", "D12", "Przelosowuje wszystkie obiekty-przeszkody, w inny losowy typ obiektu (np. kupę, wazony, TNT, grzyby itp.)"},
	{"387", "Kadzielnica", "Tworzy wielką aurę światła, która spowalnia przeciwników i ich pociski"},
	{"388", "Klucznik", "Zbiera klucze, w zamian dając losowe skrzynki"},
	{"389", "Wór na Runy", "Upuszcza losową runę co 5-6 pokoi"},
	{"390", "Serafin", "Strzela łzami z Najświętszego Serca{{Collectible182}}#Zadaje 10 obrażeń na strzał"},
	{"391", "Zdrada", "Przy każdym otrzymaniu przez ciebie obrażeń, wszyscy przeciwnicy w pokoju zostają oczarowani"},
	{"392", "Zodiak", "Dostajesz efekt losowego znaku zodiaku co każde piętro"},
	{"393", "Pocałunek Węża", "Losowa szansa na wystrzelenie trujących łez#Trujesz wrogów dotykiem#Zatruci wrogowie mogą upuścić czarne serca przy śmierci"},
	{"394", "Oznaczony", "Twoje strzały lecą w kierunku położonego na ziemi celownika, którym sterujesz#↑ +0.7 Szybkostrzelności#↑ +3.15 Zasięgu#↑ +0.3 Wysokości lotu łez"},
	{"395", "Tech X", "Strzelasz laserowym kręgiem, który możesz ładować#Krąg ten leci przez cały pokój"},
	{"396", "Przekrojowa Brzytwa", "Tworzy do dwóch portali, między którymi możesz się przemieszczać#Możesz je zostawić w innych pokojach"},
	{"397", "Wiązka Holownicza", "Łzy podążają za słupem światła, dopasowując się do zmiany kierunku#↑ +0.5 Szybkostrzelności#↑ +5.25 Zasięgu#↑ +0.16 Prędkości Strzałów#↑ +0.5 Wysokości lotu łez"},
	{"398", "Święty Grzyb", "Łzy mogą zmniejszyć wrogów#Zmniejszeni wrogowie mogą być zadeptani na śmierć"},
	{"399", "Paszcza z Pustki", "↑ +1.0 Obrażeń#Po ciągłym strzelaniu przez 3 sekundy, na twojej głowie pojawi się czerwony krzyż. Po zaprzestaniu strzelania, tworzy krąg z czarnego lasera#Wrogowie zabici czarnym kręgiem mają szansę na upuszczenie Czarnego Serca"},
	{"400", "Włócznia Przeznaczenia", "Pojawia przed tobą włócznię#Zadaje twoje obrażenia x2#Szansa na straszenie przeciwników przy kontakcie"},
	{"401", "Explosivo", "Szansa na wystrzelenie czegoś na wzór klejącej się bomby"},
	{"402", "Chaos", "Przedmioty na piedestałach będą teraz wybierane z losowych puli przedmiotów#Tworzy 1-6 losowych pickupów"},
	{"403", "Spider Mod", "Widzisz obrażenia twoich łez oraz paski zdrowia przeciwników#Nakłada losowy efekt przy kontakcie z wrogiem#Losowo upuszcza baterie"},
	{"404", "Pierdzący Dzieciak", "Blokuje pociski#Pierdzi, gdy zostanie trafiony. Ten pierd może przeciwników odrzucić, zatruć lub oczarować"},
	{"405", "GB Bug", "Lata po pokoju#Zadaje 120 obrażeń na sekundę i nakłada losowe efektu"},
	{"406", "D8", "Przelosowuje twoje statystyki#Wpływa jedynie na obrażenia, szybkostrzelność, zasięg i prędkość"},
	{"407", "Czystość", "↑ Zwiększa jedną z twoich statystyk zależnie od koloru aury#Dostajesz nową aurę po otrzymaniu obrażeń#{{ColorRed}}Czerwona{{CR}} =#{{Blank}} +4.0 Obrażeń#{{ColorBlue}}Niebieska{{CR}} =#{{Blank}} -4 Opóźnienia wystrzału#{{ColorYellow}}Żółta{{CR}} = +0.5 Prędkości#{{ColorOrange}}Pomarańczowa{{CR}} =#{{Blank}} +7.5 Zasięgu,#{{Blank}} +1 Wysokości lotu łez"},
	{"408", "Athame", "Po otrzymaniu obrażeń, wokół ciebie pojawi się krąg z czarnego lasera#Zabici nim wrogowie mogą upuścić czarne serce"},
	{"409", "Puste Naczynie", "+2 Czarne Serca#Gdy nie posiadasz czerwonych serc, otrzymujesz latanie i szansę na uzyskanie tarczy"},
	{"410", "Złe Oko", "Szansa na wystrzelenie oka, które leci przez cały ekran strzelając łzami w tym samym kierunku, co ty"},
	{"411", "Żądna Krew", "↑ +0.5 Obrażeń za każdego zabitego przeciwnika w tym pokoju#Maksymalnie +5 Obrażeń po 10 zabiciach"},
	{"412", "Poczęcie Kambiona", "Po otrzymaniu obrażeń 15 razy, dostajesz na stałe demonicznego sojusznika#Maksymalnie 4 sojuszników"},
	{"413", "Niepokalane Poczęcie", "Po podniesieniu 15 serc, dostajesz na stałe anielskiego sojusznika#Maksymalnie 5 sojuszników"},
	{"414", "Więcej Możliwości", "2 przedmioty zamiast 1 w Pokoju Skarbów{{TreasureRoom}}#Możesz podnieść tylko 1"},
	{"415", "Korona Światłości", "+2 Serca Duszy#↑ Obrażenia X 2, jeśli nie posiadasz żadnych rannych, czerwonych zasobników#Bez względu na zasobniki, wyłączy się na pokój przy otrzymaniu obrażeń"},
	{"416", "Głębokie Kieszenie", "Pozwala ci nosić na raz dwie karty/pigułki/runy"},
	{"417", "Sukkub", "Lata po pokoju mając na sobie raniącą aurę, która zadaje 129% twoich obrażeń na sekundę#↑ +50% obrażeń, gdy stoisz w tej aurze"},
	{"418", "Ciasto Owocowe", "Przy każdym strzale otrzymujesz inny efekt łez"},
	{"419", "Teleport 2.0", "Teleportuje cię do innego, losowego pokoju w którym jeszcze nie byłeś#Kolejność: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}>{{IsaacsRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}> Pokój-Error"},
	{"420", "Czarny Proszek", "Poruszając się na wzór koła, stworzysz na ziemi symbol pentagramu, który zadaje 10 obrażeń na jeden tick czasu"},
	{"421", "Fasola Nerkowata", "Nakłada efekt oczarowania na wszystkich pobliskich przeciwników#{{Blank}} oraz zadaje im 5 obrażeń"},
	{"422", "Świecąca Klepsydra", "Cofa czas do poprzedniego pokoju,#{{Blank}} wracając cię do tego samego stanu, w jakim wtedy byłeś"},
	{"423", "Okrąg Ochrony", "Masz wokół siebie dużą otoczkę, która zadaje twoje obrażenia przy kontakcie z wrogiem#{{Blank}} co sekundę#Szansa na odbicie wrogiego pocisku"},
	{"424", "Sakiewkowa Głowa", "Pickupy mają 33% szans na zmianę w sakiewkę#Tworzy sakiewkę"},
	{"425", "Lampka Nocna", "Tworzy przed tobą słup światła, który spowalnia wrogów i pociski znajdujące się w nim"},
	{"426", "Fan z Obsesją", "Śledzi każdy twój ruch z 3-sekundowym opóźnieniem#Zadaje 30 obrażeń kontaktowych na sekundę"},
	{"427", "Górnik", "Tworzy przesuwalną beczkę z TNT#Użyte drugi raz w pokoju z pojawioną beczką, zdalnie ją wysadzi"},
	{"428", "Piżamka", "+4 Serca Duszy#W pełni leczy twoje czerwone serca"},
	{"429", "Głowa Dozorcy", "Wrogowie mają 5% szans na upuszczenie Centa, gdy zostaną trafieni twoim pociskiem"},
	{"430", "Tata-Mucha", "Śledzi każdy twój ruch z sekundowym opóźnieniem#Strzela w najbliższych wrogów łzami, zadającymi twoje obrażenia"},
	{"431", "Wielowymiarowe Dziecko", "Śledzi każdy twój ruch z 2-sekundowym opóźnieniem#Łzy, które przez nie przelecą rozdzielą się na dwie i przyspieszą"},
	{"432", "Brokatowe Bomby", "+5 bomb#Bomby mogą upuścić losowy pickup przy wybuchu"},
	{"433", "Mój Cień", "Za każdym razem gdy otrzymasz obrażenia, nakłada strach na wszystkich wrogów#{{Blank}} i tworzy przyjazny cień, szarżujący na przeciwników#Zadaje on 5 obrażeń na sekundę"},
	{"434", "Słój na Muchy", "Za każdym razem gdy zabijesz przeciwnika, niebieska mucha zostanie dodana do Słoika#Maksymalnie 20 much#Użycie przedmiotu wypuści wszystkie muchy"},
	{"435", "Mały Loki", "Wystrzeliwuje 4 łzy na krzyż#Zadaje 3.5 obrażeń na strzał"},
	{"436", "Mleko!", "Po otrzymaniu obrażeń zwiększa się twoja Szybkostrzelność na resztę pokoju"},
	{"437", "D7", "Odradza wszystkich przeciwników w pokoju#Pozwala na kilkukrotne zdobycie nagród za oczyszczenie pokoju#!!! Użyte na walce z Chciwością, może przelosować pokój w Sklep{{Shop}}"},
	{"438", "Smoczek", "+1 Serce duszy#↑ +0.7 Szybkostrzelności#↑ Znacząco cię zmniejsza, zmniejszając również twój hitbox"},
	{"439", "Pudełko Mamy", "Tworzy losowy trynkiet{{Trinket}}#↑ +1 Szczęścia, gdy to trzymasz#Gdy to trzymasz, podwaja efekty trynkietów"},
	{"440", "Kamień Nerkowy", "Losowo w trakcie strzelania przestaniesz strzelać, po czym wypuścisz serię pocisków i kamień nerkowy#↓ -0.2 Prędkości#↓ -17 Zasięgu#↑ +2.0 Wysokości lotu łez"},
	{"441", "Mega Strzał", "Przez 15 sekund strzelasz wielkim laserem Mega Szatana#Efekt utrzymuje się przy zmianie pokoju czy piętra"},
	{"442", "Korona Księcia Mroku", "!!! Mając 1 pełne, czerwone serce:#↑ +1.5 Zasięgu#↑ +0.7 Szybkostrzelności#↑ +0.2 Prędkości Strzałów#(Nie działa na postaciach bez czerwonych serc)"},
	{"443", "Jabłko!", "Losowo strzelasz żyletkami, które zadają 400% obrażeń#↑ +0.3 Szybkostrzelności"},
	{"444", "Ołówek", "Co 15 strzałów, wystrzeliwujesz chmarę łez#Każda wystrzelona w ten sposób łza zadaje podwójne obrażenia"},
	{"445", "Psi Ząb", "↑ +0.3 Obrażeń#↑ +0.1 Prędkości#Słyszysz wycie w pomieszczeniu, obok Sekretnego Pokoju#Słyszysz szczekanie w pokoju, w którym znajduje się szczelina"},
	{"446", "Martwy Ząb", "W trakcie strzelania dostajesz zieloną aurę, która zatruwa przeciwników#Ta trucizna zadaje twoje obrażenia"},
	{"447", "Uporczywa Fasola", "Tworzy chmurkę smrodu co 7.5 sekund, gdy strelasz bez przerwy#Chmura ta zadaje 3.5 obrażeń, 5 razy#{{Blank}} na sekundę#Chmura utrzymuje się 15 sekund#Możesz nią poruszać, strzelając w nią"},
	{"448", "Kawałek Szkła", "Gdy otrzymasz obrażenia, masz szansę na dostanie ↑ +5 Zasięgu + zostawiasz za sobą krawą maź, albo tworzysz czerowne serce"},
	{"449", "Płyta Metalowa", "+1 Serce Duszy#25% szans na odbicie wrogiego pocisku, zmieniając go przy tym#{{Blank}} w ogłuszający"},
	{"450", "Chciwe Oko", "Co 20 strzałów, wystrzeliwujesz monetę zmieniającą przeciwników w złoto#Kosztuje cię to 1 monetę#Trafieni przeciwnicy upuszczają monetę"},
	{"451", "Obrus do Tarota", "Przy podniesieniu upuszcza losową#{{Blank}} kartę {{Card}} lub runę {{Rune}}#Podwaja efekt użytej karty"},
	{"452", "Żylaki", "Gdy otrzymasz obrażenia, wystrzeliwujesz 10 łez w kręgu#{{Blank}} wokół ciebie#Łzy te zadają 125% twoich obrażeń"},
	{"453", "Złamanie Otwarte", "Kościane łzy#Po trafieniu w cokolwiek, Łzy rozpadają się#{{Blank}} na 1-3 mniejsze#{{Blank}} odłamki kości#↑ +1.5 Zasięgu#↑ +1.0 Wysokości lotu łez"},
	{"454", "Polidaktylia", "Możesz trzymać dwie karty, runy czy pigułki#Przy podniesieniu tworzy losową kartę, pigułkę lub runę"},
	{"455", "Zgubiona Moneta Taty", "↑ +1.5 Zasięgu#Tworzy szczęśliwą monetę"},
	{"456", "Spleśniały Chleb", "↑ +1 Zdrowia"},
	{"457", "Stożkogłowy", "+1 Serce Duszy#20% Szans na zignorowanie obrażeń"},
	{"458", "Pępek", "Przy podniesieniu tworzy losowy trynkiet {{Trinket}}#Dodaje 1 miejsce na trynkiety"},
	{"459", "Zapalenie Zatok", "Lepkie, trujące Łzy#Zadaje twoje obrażenia co sekundę#Przykleja się do wroga, aż ten umrze#{{Blank}} lub minie 60 sekund"},
	{"460", "Jaskra", "Szansa na wystrzał ogłuszających łez"},
	{"461", "Parazytoid", "Szansa na strzał jajem#Tworzy spowalniającą maź przy trafieniu#Tworzy niebieskiego pająka lub muchę przy trafieniu"},
	{"462", "Oko Beliala", "↑ +1.5 Zasięgu#↑ +1.0 Wysokości lotu łez#Dostajesz penetrujące łzy#Po trafieniu pierwszego wroga, łza zadaje podwójne obrażenia i dostaje efekt naprowadzania"},
	{"463", "Kwas Siarkowy", "↑ +0.3 Obrażeń#Szansa na niszczenie kamieni i otwarcie drzwi twoimi łzami"},
	{"464", "Glif Równowagi", "+2 Serca Duszy#Mistrzowscy przeciwnicy częściej upuszczają pickupy"},
	{"465", "Gałka Analogowa", "↑ +0.3 Szybkostrzelności#Pozwala strzelać ci w dowolnym kierunku"},
	{"466", "Zakażenie", "Pierwszy zabity wróg w pokoju wybuchnie i zarazi pobliskich przeciwników"},
	{"467", "Paluch!", "Nieprzerwanie zadaje 10% twoich obrażeń przeciwnikom, na których wskazujesz"},
	{"468", "Cień", "Śledzi każdy twój ruch z sekundowym opóźnieniem#Zadaje 30 obrażeń kontaktowych na sekundę"},
	{"469", "Depresja", "Zostawia za sobą maź#Maź ta zadaje 6 obrażeń na sekundę#Przy dotknięciu wroga może stworzyć słup Świętej Światłośći {{Collectible374}}"},
	{"470", "Hushy", "Lata po pokoju#Zadaje obrażenia kontaktowe#Nie porusza się, gdy strzelasz#Blokuje pociski, gdy jest nieruchomy"},
	{"471", "Tyci Monstro", "Ładowany strzał na wzór strzelby#(Podobnie jak#{{Blank}} Płuco Monstro {{Collectible229}})#Każda łza zadaje 3.5 obrażeń"},
	{"472", "Dziecięcy Król", "Podążają za nim inni sojusznicy#Nie porusza się, gdy strzelasz#Gdy przestaniesz strzelać, teleportuje się do ciebie"},
	{"473", "Big Chubby", "Powoli szarżuje przed siebie#Zadaje 40.5 obrażeń kontaktowych na sekundę"},
	{"474", "Migdałek", "Blokuje wrogie pociski"},
	{"475", "Plan C", "Zadaje 9,999,999 obrażeń wszystkim przeciwnikom w pokoju i zabija cię 3 sekundy później"},
	{"476", "D1", "Duplikuje 1 losowy Pickup w obecnym pokoju"},
	{"477", "Pustka", "!!! Użyta, 'pożera' wszystkie przedmioty na piedestałach w pokoju#Przedmiot aktywny: Jego efekt zostanie dodany do efektu Pustki (Nakładając je na siebie)#↑ Przedmiot pasywny: Małe ulepszenie losowej statystyki"},
	{"478", "Pauza", "Zamraża wszystkich wrogów w pokoju, dopóki nie zaczniesz strzelać#Dotknięcie zamrożonego wroga cię zrani#Wrogowie się odmrożą po 30 sekundach"},
	{"479", "Wytapiacz", "Zjadasz swój trynkiet, zyskując na stałe jego efekt#Pojawia się więcej trynkietów {{Trinket}}"},
	{"480", "Kompost", "Zmienia pickupy w niebieskie muchy lub pająki#Podwaja twoją obecną ilość niebieskich much/pająków#Tworzy 1 niebieską muchę lub pająka, gdy nie masz żadnych"},
	{"481", "Kopacz Danych", "Przy użyciu zwiększa bądź zmniejsza losowe statystyki#Losowe łzy w obecnym pokoju#Psuje wyświetlane sprite'y i muzykę"},
	{"482", "Klikacz", "Zmienia cię w inną postać#Usuwa ostatni przedmiot, jaki zdobyłeś"},
	{"483", "Mama Mega!", "Wpływa na całe piętro#Wysadza wszystkie obiekty#Zadaje 200 obrażeń wszystkim przeciwnikom#Otwiera:#drogę na Boss Rush#drzwi do Husha#Sekretne Pokoje"},
	{"484", "Czekaj, Co?", "Przy użyciu odpycha przeciwników i tworzy falę kamieni#Może otwierać pokoje i niszczyć kamienie"},
	{"485", "Skrzywiony Pieniążek", "50% szans na podwojenie przedmiotów, pickupów i skrzynek#{{Blank}} w pokoju#50% szans usunięcie przedmiotów/pickupów w pokoju i stworzenie#{{Blank}} 1 monety"},
	{"486", "Tępa Żyletka", "Rani cię, bez zadawania ci obrażeń#Może być użyta do aktywowania efektów przedmiotów"},
	{"487", "Obieraczka do Ziemniaków", "Usuwa jeden zasobnik na czerwone serce i daje ci ↑ +0.2 Obrażeń i \"Kostkę Mięsa\"{{Collectible73}}"},
	{"488", "Metronom", "Dostajesz efekt losowego przedmiotu w każdym pokoju"},
	{"489", "D Nieskończoność", "Efekt losowej Kości przy każdym użyciu"},
	{"490", "Dusza Edena", "Tworzy 2 losowe przedmioty z puli pokoju, w którym zostanie użyte"},
	{"491", "Kwaśne Dziecko", "Upuszcza losową pigułkę {{Pill}} co 3 pokoje#Użycie pigułki zatruwa wszystkich przeciwników w pokoju"},
	{"492", "EJ, SŁUCHAJ!", "↑ +1 Szczęścia#Wskazuje położenie sekretnych pokoi, kamieni z X oraz szczelin"},
	{"493", "Adrenalina", "Za każdy pusty zasobnik na serce:#↑ +0.2 Obrażeń"},
	{"494", "Drabina Jakuba", "Przy kontakcie,#{{Blank}} łzy tworzą 1-2 iskry elektryczne#Iskry zadają połowę twoich obrażeń"},
	{"495", "wyZionięcie Ducha", "Szansa na wystrzelenie Ognia zamiast łez#Ogień utrzyma się, dopóki nie zada obrażeń 5 razy"},
	{"496", "Eutanazja", "Szansa na wystrzelenie strzykawki#Strzykawki natychmiastowo zabijają zwykłuch przeciwników#W innym przypadku zadają 3x twoje obrażenia"},
	{"497", "Portki Kamuflarzu", "Po wejściu do pokoju wszyscy wrogowie dostają dezorientację i cię nie widzą, dopóki nie zaczniesz strzelać"},
	{"498", "Dualizm", "Tworzy pokoje#{{Blank}} Diabła{{DevilRoom}} i Anioła{{AngelRoom}}#Po wejściu do jednego, drugi zniknie"},
	{"499", "Eucharystia", "100% szansy na#{{Blank}} Pokój Anioła{{AngelRoom}}"},
	{"500", "Sakiewka na Sakiewki", "Tworzy sakiewkę co 5-6 pokoi"},
	{"501", "Przełyk Chciwości", "Dostajesz 1 zasobnik na serca za każde 25 monet#Dozorca / Keeper otrzyma dodatkowe Pieniężne Serca {{CoinHeart}}"},
	{"502", "Spory Pryszcz", "Szansa na strzelenie zadającą podwójne obrażenia łzą, pozostawiającą Maź"},
	{"503", "Mały Róg", "Szansa na wystrzelenie łzy, która natychmiastowo zabija wrogów nie-bossów#Wbieganie we wrogów#{{Blank}} zada im 3.5 obrażeń"},
	{"504", "Brązowy Bobek", "Tworzy muchę-wieżyczkę, strzelającą w przeciwników#Każdy strzał zadaje 2 obrażeń"},
	{"505", "Poke Go", "Szansa na stworzenie Oczarowanego przeciwnika przy wejściu do pokoju z wrogami"},
	{"506", "Nóż w Plecy", "Łzy mogą wywołać u wrogów krwawienie, które co 5 sekund zadaje im obrażenia o wartości 10% ich pełnego zdrowia"},
	{"507", "Ostra Słomka", "Zadaje twoje obrażenia +10% wartości maksymalnego zdrowia przeciwnika#Wpływa na wszystkich wrogów w pokoju#Szansa na upuszczenie połówki serca przy zadawaniu obrażeń"},
	{"508", "Żyletka Mamy", "Orbituje wokół ciebie#Nakłada na wrogów krwawienie, które co 5 sekund zadaje im obrażenia o wartości 10% ich maksymalnego zdrowia#Przy kontakcie zadaje 300% twoich obrażeń na sekundę"},
	{"509", "Przekrwione Oko", "Orbituje wokół ciebie#Strzela łzą w losowym kierunku co 2 sekundy#Zadaje 3.5 obrażeń na łzę#Zadaje 30 obrażeń kontaktowych na sekundę"},
	{"510", "Delirious", "Tworzy przyjazną wersję Delirium na jeden pokój, który przyjmuje formę bossa"},
	{"511", "Wściekła Mucha", "Orbituje wokół losowego wroga, dopóki ten nie umrze#Zadaje 30 obrażeń kontaktowych na sekundę"},
	{"512", "Czarna Dziura", "Rzucana czarna dziura, która wszystko wciąga#Zadaje 0.4 obrażeń na każdy tick czasu#Niszczy pobliskie kamienie#Utrzymuje się 6 sekund"},
	{"513", "Bozo", "↑ +0.1 Obrażeń#+1 Serce Duszy#Losowa szansa na oczarowanie/wystraszenie wroga#Losowa szansa na stworzenie tęczowej kupy, gdy otrzymasz obrażenia"},
	{"514", "Zepsuty Modem", "Sprawia, że losowi wrogowie mają 'lagi' w losowych odstępach czasu, przez co chwilowo stają w miejscu#25% szans na podwojenie nagrody za oczyszczenie pokoju"},
	{"515", "Tajemniczy Prezent", "Tworzy losowy przedmiot z puli obecnego pokoju#Szansa na stworzenie Bryły Węgla{{Collectible132}} lub Kupy{{Collectible36}}"},
	{"516", "Zraszacz", "Tworzy Zraszacz, który obraca się w stylu koła, strzelając łzami we wszystkie kierunki"},
	{"517", "Szybkie Bomby", "+7 Bomb#Pozwala ci bardzo szybko stawiać bomby na ziemi"},
	{"518", "Kumpel z Pudełka", "Sojusznik o wyglądzie losowego Dziecka z trybu kooperacji#Losowy efekt łez#Losowy co każde piętro"},
	{"519", "Tyci Delirium", "Sojusznik, który zmienia się w innych losowych sojuszników co 10 sekund"},
	{"520", "Kable Rozruchowe", "+1 ładunek dla twojego przedmiotu aktywnego co każde 15 zabitych wrogów"},
	{"521", "Kupon", "Użyte sprawia, że losowy przedmiot w Sklepie{{Shop}} lub#{{Blank}} Pokoju Diabła{{DevilRoom}} stanie się darmowy"},
	{"522", "Telekineza", "Pobliskie pociski wrogów zatrzymują się na 3 sekundy#Następnie są one od ciebie odrzucane#Odnawia się co#{{Blank}} 3 sekundy"},
	{"523", "Pudło na Przenosiny", "Użyte, przechowuje wszystkie Pickupy z obecnego pokoju#Użyte ponownie wyrzuci swoją zawartość na ziemię#Możesz w ten sposób przenosić rzeczy między pokojami"},
	{"524", "Technologia Zero", "Łzy są połączone wiązką elektryczną#Elektryczność zadaje obrażenia równe twoim"},
	{"525", "Trąd", "Przy otrzymaniu obrażeń tworzy orbitujący wokół ciebie strzęp blokujący wrogie pociski#Maks. 3 na raz#Strzępy są niszczone. gdy otrzymają zbyt wiele obrażeń"},
	{"526", "7 Pieczęci", "Tworzy małych jeźdźców w roli sojuszników, którzy tworzą własne szarańcze#Jeźdźcy zmieniają się co 10 sekund"},
	{"527", "Pan JA!", "!!! Sojusznik wykonujący twoje polecenia:#Otwiera drzwi & skrzynki, Przynosi przedmioty, Kradnie ze Sklepu / od Diabła, walczy z wrogami, wybucha, oraz naciska przyciski"},
	{"528", "Anielski Pryzmat", "Orbitujący pryzmat#Przy kontakcie z nim, łzy rozdzielają się na 4"},
	{"529", "Pop!", "Łzy zachowują się jak kule od bilarda"},
	{"530", "Lista Śmierci", "Dostaniesz nagrodę za zabicie wrogów w kolejności, w której są oznaczeni czaszką"},
	{"531", "Hemolakria", "Łzy lecą łukiem#Przy kontakcie rozpadają się na wiele mniejszych#↓ Mniejsza Szybkostrzelność#↑ +31% Obrażeń"},
	{"532", "Wygłodniałe Łzy", "Łzy spowalniają wraz z przebytym dystansem#Po zatrzymaniu, eksplodują w 8 mniejszych łez#Strzelając łzami w łzy, możesz je powiększać"},
	{"533", "Trisagion", "Strzelasz białymi promieniami światła"},
	{"534", "Plecak Szkolny", "Pozwala ci trzymać 2 przedmioty aktywne#Przełącz się między nimi wciskając przycisk od upuszczania rzeczy (przytrzymaj jako \"The Forgotten / Zapomniany\")"},
	{"535", "Kocyk", "+1 Serce Duszy#Leczy 1 Czerwone Serce#Dostajesz tarczę po wejściu do pokoju z bossem {{BossRoom}}"},
	{"536", "Ołtarz Ofiarny", "Poświęcasz 1-2 sojuszników i tworzysz przedmiot z puli Pokoju Diabła{{DevilRoom}}#Zmienia twoje niebieskie pająki/muchy w monety"},
	{"537", "Tyci Spewer", "Tworzy losową pigułkę#Sojusznik, który wymiotuje mazią#Typ mazi zmienia się wraz z każdą spożytą pigułką"},
	{"538", "Marmurki", "Tworzy 3 losowe trynkiety {{Trinket}}#Przy otrzymaniu obrażeń istnieje szansa, że połkniesz trynkiet, zyskując jego efekt na stałe"},
	{"539", "Jajko Niespodzianka", "Tworzy zauroczonego przeciwnika, gdy zostaniesz trafiony#Stworzysz tym silniejszego kolegę, im więcej pokoi wyczyścisz bez otrzymania obrażeń"},
	{"540", "Płaski Kamień", "Łzy odbijają się od podłogi#Zadają obrażenia rozpryskowe przy każdym odbiciu"},
	{"541", "Szpik", "+1 Kościane Serce#Tworzy 3 Czerwone Serca"},
	{"542", "Przesunięte Żebro", "Orbituje#Odbija pociski"},
	{"543", "Poświęcona Ziemia", "Tworzy białą kupę, gdy zostaniesz trafiony#Biała kupa może blokować obrażenia i ma aurę zwiększającą Szybkostrzelność"},
	{"544", "Spiczaste Żebro", "Unosi się przed tobą#Zadaje obrażenia równe twoim 6 razy na sekundę"},
	{"545", "Księga Umarłych", "Tworzy orbitującą kość lub oczarowanego Bony'ego za każdego zabitego w pokoju wroga"},
	{"546", "Pierścień Taty", "Daje ci aurę, która zamraża przeciwników"},
	{"547", "Papiery Rozwodowe", "+1 Kościane Serce#↑ +0.7 Szybkostrzelności#Tworzy trynkiet#{{Blank}} {{Trinket21}} Tajemnicza Kartka"},
	{"548", "Szczęka", "Sojusznik Bumerangowy#Zadaje 7 obrażeń kontaktowych#Może zbierać dla ciebie pickupy"},
	{"549", "Łamliwe Kości", "Zamienia wszystkie twoje czerwone zasobniki na 6 Kościanych Serc#Utrata kościanego serca wystrzeli Kościane Łzy we wszystkie kierunki oraz da ci na stałe +0.5 Szybkostrzelności"},
	{"550", "Rozwalona Łopata", "Stopa mamy będzie cię ciągle atakować#Użycie wyłączy ataki stopy mamy w tym pokoju#!!! Spróbuj przejść Bossrush z jej pomocą!"},
	{"551", "Rozwalona Łopata", "Druga część rozwalonej łopaty#!!! Użyj na stercie brudu w#{{Blank}} \"Ciemni/Dark Room\""},
	{"552", "Łopata Mamy", "Tworzy zapadnię na następne piętro#!!! Użyj na stercie brudu w#{{Blank}} \"Ciemni/Dark Room\"#!!! Odblokujesz coś czadowego"},
}

---------- Trinkets ----------
EID.descriptions[languageCode].trinkets={
	{"1", "Połknięty Pieniążek", "Upuszcza 1 monetę, gdy otrzymasz obrażenia"},
	{"2", "Skamieniała Kupa", "50% więcej pickupów z kup"},
	{"3", "Bateria AAA", "-1 potrzebnego ładunku do przedmiotu aktywnego"},
	{"4", "Zepsuty Pilot", "Teleportuje cię w losowe miejsce, kiedy używasz przedmiotu"},
	{"5", "Purpurowe Serce", "Więcej mistrzowskich przeciwników#Większa szansa na pokoje wyzwań z bossami{{BossRushRoom}}"},
	{"6", "Zepsuty Magnes", "Magnes na monety"},
	{"7", "Koralik Różańcowy", "Większa szansa na pokój anioła{{AngelRoom}}#Większa szansa na znalezienie Biblii {{Collectible33}}"},
	{"8", "Kartridż", "Szansa na efekt#{{Blank}} {{Collectible93}} Gamekid, gdy otrzymasz obrażenia"},
	{"9", "Pulsujący Robak", "Pulsujące łzy#Wpływa na hitbox łez"},
	{"10", "Rozhuśtany Robak", "Falujące łzy#↑ +0.3 Szybkostrzelności"},
	{"11", "Pierścienny Robak", "Łzy poruszają się spiralnie z dużą prędkością"},
	{"12", "Płaski Robak", "50% szersze łzy"},
	{"13", "Bon Podarunkowy", "Jeden darmowy przedmiot w sklepie"},
	{"14", "Modzel", "Zapobiega obrażeniom od mazi i kolców"},
	{"15", "Szczęśliwy Kamyczek", "Rozwalanie kamieni tworzy monety"},
	{"16", "Paznokieć Mamy", "Stopa Mamy stąpa na przeciwników co 60 sekund"},
	{"17", "Czarna Szminka", "Więcej pojawiających się czarnych serc {{BlackHeart}}"},
	{"18", "Fragment Biblii", "Wiecej pojawiających się wiecznych serc {{EternalHeart}}"},
	{"19", "Spinacz", "Otwieranie skrzynek bez użycia kluczy"},
	{"20", "Małpia Łapka", "Gdy masz połowę serca, tworzy czarne serca {{BlackHeart}}#!!! Do 3 użyć"},
	{"21", "Tajemnicza Kartka", "Imituje \"Polaroid\"{{Collectible327}}, \"Negatyw\"{{Collectible328}}, \"Brakującą Kartkę\"{{Trinket48}} oraz \"Plakat Zaginionego\"{{Trinket23}}"},
	{"22", "Ogon Demona", "Obniża współczynnik tworzenia serc do 20%#Zwiększa szanse na upuszczenie kluczy#Serca do podniesienia zmieniane są na czarne serca"},
	{"23", "Plakat Zaginionego", "Odradzasz się jako \"Zaginiony/The Lost\" kiedy zginiesz w Pokoju Poświęceń {{SacrificeRoom}} #Jeśli jest już odblokowany, odrodzisz się jako on nawet poza Pokojami Poświęceń"},
	{"24", "Dupny Pieniążek", "Pierdzisz, gdy podnosisz monety#Pierdy odrzucają przeciwników"},
	{"25", "Tajemnicze Ciuciu", "Pierdzisz lub tworzysz kupy co#{{Blank}} 30 sekund"},
	{"26", "Haczykowaty Robak", "Łzy poruszają się#{{Blank}} pod kątem#↑ +10 Zasięgu"},
	{"27", "Batowy Robak", "↑ +0.5 Prędkości Strzałów"},
	{"28", "Złamany Anch", "22% szans na odrodzenie się jako \"???\""},
	{"29", "Głowa Ryby", "Tworzy niebieskie muchy, kiedy otrzymujesz obrażenia"},
	{"30", "Czerwone Oko", "Losowo strzelasz trującymi łzami"},
	{"31", "Pinezka", "Losowo strzelasz penetrującymi łzami"},
	{"32", "Czapka Wolności", "Losowy efekt grzyba#{{Blank}} co pokój#Może odkrywać specjalne pokoje na minimapie."},
	{"33", "Pępowina", "Gdy masz połowę serca, dostajesz#{{Blank}} Małego Steven'a {{Collectible100}}"},
	{"34", "Serce Dziecka", "Powstaje więcej czerwonych serc"},
	{"35", "Zakrzywiony Róg", "↑ +2 Obrażeń"},
	{"36", "Zardzewiały Klucz", "Pojawia się więcej kluczy"},
	{"37", "Kozie Kopyto", "↑ +0.15 Prędkości"},
	{"38", "Perła Mamy", "Powstaje więcej#{{Blank}} Serc Duszy {{SoulHeart}}"},
	{"39", "Rak", "↑ Szybkostrzelność"},
	{"40", "Czerwona Łatka", "↑ Szansa na +1.8 Obrażeń na pokój,#{{Blank}} gdy otrzymujesz obrażenia"},
	{"41", "Zapałka", "Więcej pojawiających się bomb#!!! Usuwa \"Kleszcza\"{{Trinket53}}"},
	{"42", "Szczęśliwy Paluch", "↑ +1 Szczęścia#Szansa na dodatkowe pickupy"},
	{"43", "Przeklęta Czaszka", "Gdy twoje zdrowie spadnie do połowy serca lub jego braku, teleportuje cię do losowego pokoju"},
	{"44", "Nakrętka Bezpieczna", "Więcej pojawiających się pigułek"},
	{"45", "As Pik", "Więcej pojawiających się kart"},
	{"46", "Widelec Izaaka", "Szansa na uleczenie połowy serca po wyczyszczeniu pokoju"},
	{"47", "", "<Przedmiot nie istnieje>"},
	{"48", "Brakująca Kartka", "Sszansa na zadanie obrażeń wszystkim w pokoju, gdy otrzymasz obrażenia"},
	{"49", "Krwawy Pieniążek", "50% szans na upuszczenie połowy serca, gdy podniesiesz monetę"},
	{"50", "Spalony Pieniążek", "50% szans na upuszczenie bomby, gdy podniesiesz monetę"},
	{"51", "Płaski Pieniążek", "50% szans na upuszczenie klucza, gdy podniesiesz monetę"},
	{"52", "Podrobiony Pieniążek", "50% szans na +1 monetę, gdy podniesiesz monetę"},
	{"53", "Kleszcz", "-15% zdrowia bossa#Leczy 1 czerwone serce, gdy wchodzisz bo pokoju bossa {{BossRoom}}#!!! Raz podniesionego nie da się pozbyć#Zdejmiesz go jedynie przy pomocy Zapałki {{Trinket41}}#{{Blank}} lub poprzez połknięcie"},
	{"54", "Głowa Izaaka", "Sojusznik z penetrującymi łzami#Zadaje 3.5 obrażeń na łzę"},
	{"55", "Wiara Madzi", "Dostajesz jedno wieczne serce {{EternalHeart}} na start kolejnego piętra"},
	{"56", "Język Judasza", "Ustawia ceny przedmiotów u Diabła na 1 serce"},
	{"57", "Dusza ???", "Sojusznik latający po pokoju#Strzela w tym samym kierunku, co ty#Zadaje 3.5 obrażeń na łzę"},
	{"58", "Włosy Samsona", "↑ 1/15 szans na +0.5 Obrażeń, gdy zabijesz przeciwnika#Efekt utrzymuje się przez aktualny pokój"},
	{"59", "Oko Kaina", "25% Szanss na odkrycie ikon na mapie na start nowego piętra"},
	{"60", "Skok Ptaka Ewy", "Szansa na stworzenie Martwego Ptaka {{Collectible117}}, gdy zabijesz wroga"},
	{"61", "Lewa Ręka", "Zamienia wszystkie skrzynki na czerwone"},
	{"62", "", "Kamienie kryjące Szczelinę i Kamienie z X'em migają co 10 sekund"},
	{"63", "", "Zamienia troll bomby w bomb pickupy"},
	{"64", "", "Losowy wężowy efekt co 3 sekundy"},
	{"65", "", "↑ Podwaja Twój Zasięg#-50% Wysokości lotu łez"},
	{"66", "", "↓ -0.4 Zmniejszona Prędkość strzałów#↑ +4 Zasięg"},
	{"67", "", "Szansa na losowy efekt kostki, gdy otrzymujesz obrażenia."},
	{"68", "", "Magnes na pickupy i przeciwników"},
	{"69", "", "Losowo kamufluje gracza#Dezorientuje przeciwników"},
	{"70", "", "Szansa na stworzenie pająka we wrogim pokoju"},
	{"71", "", "Bomby pozostawiają maź"},
	{"72", "", "Więcej pojawiających się baterii#5% szans na odładowanie jednego ładunku twoje przedmiotu aktynego"},
	{"73", "", "Wybuchające bomby mogą upuścić bomby do podniesienia"},
	{"74", "", "Większa szansa na znalezienie Szczeliny przy niszczeniu kamieni"},
	{"75", "", "Efekt losowego trynkietu co pokój"},
	{"76", "", "Skrzynie mają 50/50 szans na stworzenie większych pickupów LUB nic/przeciwników"},
	{"77", "", "Zwiększony odrzut"},
	{"78", "", "Dłużej działające efekty na przeciwnikach"},
	{"79", "", "Gdy użyjesz pigułki/karty, istnieje 25% szans na pojawienie się jej kopii."},
	{"80", "", "↑ +0.2 Obrażeń za każdy diabelski przedmiot, jaki mamy."},
	{"81", "", "Nietykalność trwa dłużej po dostaniu obrażenia."},
	{"82", "", "+15% na podwójne przedmioty w Pokoju Skarbów na kolejnym piętrze"},
	{"83", "", "Otwiera sklepy{{Shop}} za darmo"},
	{"84", "", "Greed/Super Greed nie pojawia się więcej w sklepie#Więcej pojawiających się monet"},
	{"85", "", "Użycie Automatu do Wpłat może Cię uleczyć lub stworzyć żebraka"},
	{"86", "", "Rozwalanie kup tworzy niebieskie muchy"},
	{"87", "", "Leczy połowę serca, gdy używamy klucza#Zamienia połowy serc w całe"},
	{"88", "", "Bardzo mała szansa na przedmioty aktywne w Pokojach Skarbów{{TreasureRoom}}"},
	{"89", "", "Sojusznicy są bliżej Ciebie"},
	{"90", "", "Kupy eksplodują przy rozwaleniu"},
	{"91", "", "Zwiększona szansa na pojawienie się Czarnych Kup#Szansa na stworzenie czarnego serca, gdy rozwalasz czarną kupę"},
	{"92", "", "↑ Przedmioty zwiększające Twoje statystyki są 33% bardziej efektywne#↑ +0.2 Szybkostrzelności#↑ -1 Opóźnienie Wystrzału"},
	{"93", "", "Latający przeciwnicy stają się przyjaźni"},
	{"94", "", "Podwaja wszystkie niebieskie muchy/pająki"},
	{"95", "", "Losowo strzelasz trującymi Zębowymi łzami"},
	{"96", "", "Strzały poruszają się szybkim, spiralnym wzorem#Widmowe łzy#↑ +4 Zasięg"},
	{"97", "", "Szansa na orbitującego sojusznika, który blokuje strzały, po dostaniu obrażenia 12-20 razy#Do +2 Możliwych sojuszników"},
	{"98", "", "Szansa na klejąco-trujące łzy"},
	{"99", "", "Szansa na odbijające łzy"},
	{"100", "", "!!! Gdy trzymasz naładowany aktywny przedmiot:#↑ +0.5 Obrażeń#↑ +0.25 Prędkości#↑ +0.75 Zasięgu#↑ +0.2 Szybkostrzelności#↑ +0.1 Prędkości strzałów#↑ +1 Szczęścia"},
	{"101", "", "!!! Gdy trzymasz nienaładowany aktywny przedmiot:#↑ +1.5 Obrażeń#↑ +0.5 Prędkości#↑ +1.5 Zasięgu#↑ +0.4 Szybkostrzelności#↑ +0.3 Prędkości strzałów#↑ +2 Szczęścia"},
	{"102", "", "+1 dodatkowy sekretny pokój na każde piętro, gdy to trzymasz"},
	{"103", "", "!!! Gdy liczba monet, kluczy i bomb jest równa:#Zamienia ich połowiczne wersje w podwójne wersje"},
	{"104", "", "Szansa na stworzenie przedmiotu z piedestału, gdy otrzymasz obrażenia#Zostaje po tym zniszczony"},
	{"105", "", "Szansa na stworzenie Drugiego Śniadania{{Collectible22}}, gdy otrzymasz obrażenia#Zostaje po tym zniszczony"},
	{"106", "", "Zwiększa promień każdej mazi, jaką produkujesz"},
	{"107", "", "Otrzymanie obrażeń ignoruje w pierwszej kolejności serca duszy/czarne serca/zgniłe serca, przed czerwonymi"},
	{"108", "", "Szansa na drop losowego pickupa / trynkietu, gdy otrzymasz obrażenia od eksplozji#Zostaje po tym zniszczony"},
	{"109", "", "Powoduje, że wszyscy sojusznicy przestają się poruszać"},
	{"110", "", "Sklepy{{Shop}} mogą się pojawić na piętrze W1/W2"},
	{"111", "", "Pokój Skarbów {{TreasureRoom}} pojawia się w Womb'ie"},
	{"112", "", "Automat z zapasami będzie się zawsze pojawiał w Pokoju Skarbów{{TreasureRoom}}"},
	{"113", "", "Tworzy eksplodującą, atakującą muchę, która pojawia się w pokoju z wrogami#Mucha zadaje podwójne Twoje obrażenia + obrażenia od eksplozji"},
	{"114", "", "Tworzy trującą, atakującą muchę, która pojawia się w pokoju z wrogami#Mucha zadaje podwójne Twoje obrażenia"},
	{"115", "", "Tworzy spowalniającą, atakującą muchę, która pojawia się w pokoju z wrogami#Mucha zadaje podwójne Twoje obrażenia"},
	{"116", "", "Tworzy atakującą muchę, która pojawia się w pokoju z wrogami#Mucha zadaje poczwórne Twoje obrażenia"},
	{"117", "", "Tworzy 1-4 atakujących much w pokoju z wrogami#Każda z much zadaje podwójne Twoje obrażenia"},
	{"118", "", "Szansa na otrzymanie latania po zabiciu przeciwnika#Działa w danym pokoju"},
	{"119", "", "Leczy połowę serca po podróży na kolejne piętro"},
	{"120", "", "Pełne naładowanie aktywnego przedmiotu na start walki z bossem"},
	{"121", "", "Co poziom, chroni Cię przed otrzymaniem pierwszego obrażenia"},
	{"122", "", "Użycie aktywnego przedmiotu upuszcza go z powrotem na piedestał"},
	{"123", "", "Powoduje, że Anioły w Pokoju Aniołów będą dropić zwykłe przedmioty zamiast części klucza"},
	{"124", "", "Ostatnie użyte drzwi pozostaną nadal otwarte"},
	{"125", "", "Łączy Twoich sojuszników elektrycznymi wiązkami#Zadaje 6 obrażeń co uderzenie"},
	{"126", "", "Tworzy niebieską muchę, gdy podnosisz monetę"},
	{"127", "", "Gwarantuje Twoim sojusznikom naprowadzane łzy"},
	{"128", "", "2% szans na otrzymanie Kościanego Serca, gdy otrzymasz obrażenia"},
}

---------- Cards ----------
EID.descriptions[languageCode].cards={
	{"1", "0 - Głupiec", "Teleportuje cię na start piętra"},
	{"2", "I - Mag", "Samonaprowadzające łzy w tym pokoju"},
	{"3", "II - Kapłanka", "Stopa Mamy depta przeciwnika, zadając mu 300 obrażeń"},
	{"4", "III - Cesarzowa", "↑ +2.35 Obrażeń#↑ +0.3 Prędkości#{{Blank}} W tym pokoju"},
	{"5", "IV - Cesarz", "Teleportuje cię do pokoju Bossa {{BossRoom}}"},
	{"6", "V - Hierofant", "Tworzy 2 Serca Duszy"},
	{"7", "VI - Kochankowie", "Tworzy 2 czerwone serca"},
	{"8", "VII - Rydwan", "Nieśmiertelność#Ranisz dotykiem przez 6 sekund"},
	{"9", "VIII - Sprawiedliwość", "Tworzy 1 bombę,#{{Blank}} 1 klucz, 1 monetę#{{Blank}} oraz 1 serce"},
	{"10", "IX - Eremita", "Teleportuje cię#{{Blank}} do Sklepu {{Shop}}"},
	{"11", "X - Koło Fortuny", "Tworzy Automat do Gier lub z Wróżbami"},
	{"12", "XI - Siła", "↑ +1 Zdrowia#↑ +0.3 Obrażeń#↑ +50% Obrażeń#↑ +5.25 Zasięgu#↑ +0.3 Prędkości#W tym pokoju"},
	{"13", "XII - Wisielec", "Otrzymujesz latanie#{{Blank}} w tym pokoju"},
	{"14", "XIII - Śmierć", "Zadaje 40 obrażeń przeciwnikom w tym pokoju"},
	{"15", "XIV - Umiarkowanie", "Tworzy Automat Krwiodawstwa"},
	{"16", "XV - Diabeł", "↑ +2 Obrażeń w tym pokoju"},
	{"17", "XVI - Wieża", "Tworzy 6 troll bomb"},
	{"18", "XVII - Gwiazda", "Teleportuje cię do Pokoju Skarbów {{TreasureRoom}}"},
	{"19", "XVIII - Księżyc", "Teleportuje cię do sekretnego pokoju {{SecretRoom}}"},
	{"20", "XIX - Słońce", "Zadaje 100 obrażeń przeciwnikom#{{Blank}} w tym pokoju#Pełne wyleczenie#Odsłania całą mapę"},
	{"21", "XX - Sąd Ostateczny", "Tworzy żebraka"},
	{"22", "XXI - Świat", "Odsłania całą mapę i ujawnia typy pokoi"},
	{"23", "2 Trefl", "Podwaja twoje bomby"},
	{"24", "2 Karo", "Podwaja twoje monety"},
	{"25", "2 Pik", "Podwaja twoje klucze"},
	{"26", "2 Kier", "Podwaja twoje czerwone serca#Ma jedynie efekt leczący"},
	{"27", "As Trefl", "Zmienia wszystkie pickupy w bomby"},
	{"28", "As Karo", "Zmienia wszystkie pickupy w monety"},
	{"29", "As Pik", "Zmienia wszystkie pickupy w klucze"},
	{"30", "As Kier", "Zmienia wszystkie pickupy w serca"},
	{"31", "Joker", "Teleportuje cię do Pokoju Diabła{{DevilRoom}} lub Pokoju Anioła{{AngelRoom}}"},
	{"32", "Hagalaz", "Niszczy wszystkie kamienie w tym pokoju"},
	{"33", "Jera", "Podwaja wszystkie pickupy w tym pokoju"},
	{"34", "Ehwaz", "Tworzy zapadnię na następne piętro"},
	{"35", "Dagaz", "+1 Serce Duszy#Usuwa obecne klątwy"},
	{"36", "Ansuz", "Odsłania całą mapę na tym piętrze"},
	{"37", "Perthro", "Przelosowuje przedmioty na piedestałach"},
	{"38", "Berkano", "Przyzywa po 3 niebieskie pająki i niebieskie muchy"},
	{"39", "Algiz", "Nieśmiertelność na 30 sekund"},
	{"40", "Pusta Runa", "Efekt losowej runy#25% szans, że stworzy swoją kopię"},
	{"41", "Czarna Runa", "Zadaje 40 obrażeń przeciwnikom#{{Blank}} w tym pokoju#Wzrost losowej statystyki za każdy przedmiot na piedestale#(Niszczy wszystkie piedestały w pokoju)"},
	{"42", "Karta Chaosu", "Rzucasz w kierunku ruchu kartą, która zabije prawie wszystko na swojej drodze"},
	{"43", "Karta Kredytowa", "Usuwa ceny wszystkiego w tym sklepie lub#{{Blank}} pokoju Diabła {{DevilRoom}}"},
	{"44", "Karta Zasad", "Pokazuje \"przydatne\" porady"},
	{"45", "Karta Przeciw Ludzkości", "Wypełnia cały pokój kupami"},
	{"46", "Król Samobójca", "Zabija cię i tworzy 10 pickupów/przedmiotów na podłodze"},
	{"47", "Karta Wyjścia z Więzienia", "Otwiera wszystkie drzwi w tym pokoju"},
	{"48", "Karta ?", "Używa twojego aktywnego przedmiotu, bez zużywania jego ładunku"},
	{"49", "Odłamek Kości", "Przelosowuje piedestały i pickupy w tym pokoju"},
	{"50", "W Nagłym Wypadku", "Przyzywa dwie dłonie Mamy, które łapią wrogów"},
	{"51", "Święta Karta", "Daje efekt Świętego Okrycia{{Collectible313}} w tym pokoju#(Neguje następne otrzymane obrażenia)#25% Szans na stworzenie kopii tej karty"},
	{"52", "Wielkie Bydle", "↑ +7 Obrażeń#↑ +30 Zasięgu#↑ +Rośniesz#Miażdżysz kamienie!#Efekt tylko na ten pokój"},
	{"53", "Starożytne Wezwanie", "Tworzy 3 losowe karty"},
	{"54", "Historyczna Przechadzka", "Spowalnia wrogów#↓ -0.5 Prędkości#-1 Prędkości Strzałów#Efekt tylko na ten pokój"},
}

---------- Pills ----------
EID.descriptions[languageCode].unidentifiedPill = "Nieznana Pigułka"

EID.descriptions[languageCode].pills={
	{"0", "Wzdęcia", "Tworzy chmurę Gazu"},
	{"1", "Potknięcie", "Tracisz 1 serce"},
	{"2", "Jaja ze Stali", "+2 Serca Duszy"},
	{"3", "Bomby to Klucze", "Zamienia ilość bomb z kluczami"},
	{"4", "Ostra Biegunka", "Tworzy 5 troll bomb pod twoimi nogami"},
	{"5", "Pełne Zdrowie", "Pełne wyleczenie czerwonych serc"},
	{"6", "Mniej Zdrowia", "↓ Zdrowie maleje"},
	{"7", "Więcej Zdrowia", "↑ Zdrowie wzrasta"},
	{"8", "Znalazłem Pigułki", "Brak efektu"},
	{"9", "Dorastanie", "Po zjedzeniu 3 otrzymasz transformację Adult (+1 Czerwone Serce)"},
	{"10", "Muszka", "Tworzy orbitującą wokół ciebie muchę"},
	{"11", "Zasięgu Maleje", "↓ -2 Zasięgu"},
	{"12", "Zasięgu Wzrasta", "↑ +2.5 Zasięgu"},
	{"13", "Prędkość Maleje", "↓ -0.12 Prędkości"},
	{"14", "Prędkość Wzrasta", "↑ +0.15 Prędkości"},
	{"15", "Szybkostrzelność Maleje", "↓ -0.28 Szybkostrzelności"},
	{"16", "Szybkostrzelność Wzrasta", "↑ +0.35 Szybkostrzelności"},
	{"17", "Szczęście Maleje", "↓ -1 Szczęścia"},
	{"18", "Szczęście Wzrasta", "↑ +1 Szczęścia"},
	{"19", "Telepigułka", "Teleport do losowego pokoju"},
	{"20", "Energia na 48h!", "Odładowuje twój przedmiot aktywny#Upuszcza od 1 do 2 baterii"},
	{"21", "Krwawe Wymioty", "Opróżnia wszystkie zasobniki na serca poza jednym#Tworzy od 1 do 4 czerwonych serc"},
	{"22", "Paraliż", "Brak możliwości ruchu na 2 sekundy"},
	{"23", "Mam wieczne widzenie!", "Otwiera przejścia do sekretnych pokoi na tym piętrze"},
	{"24", "Feromony", "Oczarowuje wszystkich przeciwników w tym pokoju"},
	{"25", "Amnezja", "Ukrywa mapę piętra"},
	{"26", "Cytrynowa Zabawa", "Tworzy na ziemi kałużę, która rani nielatających wrogów"},
	{"27", "JESTEŚ CZARODZIEJEM?", "Przez 30 sekund strzelasz na skos"},
	{"28", "Paracetamol", "W tym pokoju otrzymujesz maksymalnie pół serca obrażeń"},
	{"29", "Uzależniony!", "W tym pokoju wszystko zrani cię za pełne serce"},
	{"30", "Poluzowanie!", "Przez 2 sekundy tworzysz kupy pod nogami"},
	{"31", "???", "Efekt Klątwy Dezorientacji na całe piętro"},
	{"32", "Czyni cię większym", "Rośniesz#Brak wpływu na twój hitbox"},
	{"33", "Czyni cię małym", "Malejesz#Twój hitbox również się zmniejsza"},
	{"34", "Zarażony!", "Tworzy 1 niebieskiego pająka na każdą kupę w pokoju"},
	{"35", "Zarażony?", "Tworzy 1 niebieskiego pająka na każdego wroga w pokoju#Tworzy od 1 do 3 pająków w przypadku braku przeciwników"},
	{"36", "Pigułka Mocy!", "Krótkotrwała nieśmiertelność"},
	{"37", "Retro-Widok", "Rozpikselowuje ekran na 30 sekund"},
	{"38", "Przyjaciele do końca", "Tworzy 3 niebieskie muchy"},
	{"39", "Przeczyszczenie", "Tworzy kałużę śliskiej mazi"},
	{"40", "Coś jest nie tak...", "Tworzy kałużę spowalniającej mazi"},
	{"41", "Jestem śpiący...", "Spowalnia przeciwników w tym pokoju"},
	{"42", "Ekscytacja!", "Przyspiesza przeciwników w tym pokoju"},
	{"43", "Łyk!", "Połykasz swój trynkiet, zyskując permanentnie jego efekt"},
	{"44", "Paw!", "Wystrzeliwujesz jedną łzę z efektem Wymiotnicy"},
	{"45", "Jakbym stąpał po promykach słońca!", "Krótkotrwała nieśmiertelność bez zadawania obrażeń"},
	{"46", "Refluks!", "Tworzy ostatnią połkniętą pigułkę"},
}

---------- Sacrifice Room ----------
EID.descriptions[languageCode].sacrificeHeader = "[Następna wypłata Pokoju Poświęceń]"

EID.descriptions[languageCode].sacrifice={
	{"1", "", "50% szans na 1 Monetę#100% szans na 1 Bombę na piętrze Piwnica 1 po zabiciu Bossa w mniej niż minutę"},
	{"2", "", "50% szans na 1 Monetę#100% szans na 1 Bombę na piętrze Piwnica 1 po zabiciu Bossa w mniej niż minutę"},
	{"3", "", "67% szans na zwiększenie szansy na otwarcie Pokoju Anioła{{AngelRoom}}"},
	{"4", "", "50% szans na 1 losową Skrzynkę"},
	{"5", "", "33% szans na 3 Monety#67% szans na zwiększenie szansy na otwarcie Pokoju Anioła {{AngelRoom}}"},
	{"6", "", "33% szans na teleport do Pokoju Anioła{{AngelRoom}}/Diabła{{DevilRoom}}#67% szans na losową Skrzynkę"},
	{"7", "", "33% szans na 1 losowy przedmiot z Pokoju Anioła{{AngelRoom}}#67% szans na 1 serce duszy"},
	{"8", "", "100% szans na 7 troll bomb"},
	{"9", "", "100% szans na walkę z \"Urielem\""},
	{"10", "", "50% szans na 7 serc dusz#50% szans na 30 monet"},
	{"11", "", "100% szans na walkę z \"Gabrielem\""},
	{"12", "", "50% szans na teleport do \"Ciemnego Pokoju\""},
}

---------- Dice Room ----------
EID.descriptions[languageCode].diceHeader = "[Efekt kości]"

EID.descriptions[languageCode].dice={
	{"1", "", "Przelosowuje twoje przedmioty#(brak wpływu na pickupy np. klucze)"},
	{"2", "", "Przelosowuje pickupy w pokoju"},
	{"3", "", "Przelosowuje pickupy na całym piętrze"},
	{"4", "", "Przelosowuje wszystkie przedmioty na piętrze#Brak wpływu na oferty Diabła"},
	{"5", "", "Przelosowuje i restartuje całe piętro"},
	{"6", "", "Przelosowuje twoje przedmioty oraz przedmioty i pickupy na piętrze"},
}

---------- Transformations ----------
EID.descriptions[languageCode].transformations={
	"",					-- 0 = none
	"Guppy",			-- 1
	"Fun Guy",			-- 2
	"Beelzebub",		-- 3
	"Conjoined",		-- 4
	"Spun",				-- 5
	"Yes Mother?",		-- 6
	"Oh Crap",			-- 7
	"Bob",				-- 8
	"Leviathan",		-- 9
	"Seraphim",			-- 10
	"Super Bum",		-- 11
	"Bookworm",			-- 12
	"Spider Baby",		-- 13
	"Adult",			-- 14
	"Stompy"			-- 15
}

EID.descriptions[languageCode].SingleUseInfo = "{{Warning}} JEDNORAZOWE {{Warning}}"
