--------------------------------------
-----  Basic Chinese descriptions  ---
--------------------------------------

-- FORMAT: Item ID | Name | Description

-- Special character markup:
-- ↑ = Up Arrow  |  ↓ = Down Arrow  |  # = Starts a new line
-- More can be found here: https://github.com/wofsauge/External-Item-Descriptions/wiki/Markup

local languageCode = "zh_cn"

-- init zh_cn table
EID.descriptions[languageCode] = {}
EID.descriptions[languageCode].custom = {} -- table for custom entity descriptions
EID.descriptions[languageCode].languageName = "Simplified Chinese"
EID.descriptions[languageCode].alternativeLanguageCodes = {"zh-CN", "schinese", "zh"}

-- Fonts to be used with this languagepack
EID.descriptions[languageCode].fonts = {{name = "cn_alt", lineHeight = 13, textboxWidth = 145}, {name = "cn_default", lineHeight = 13, textboxWidth = 140}, {name = "cn_old", lineHeight = 14, textboxWidth = 150}}

---------- Collectibles ----------

EID.descriptions[languageCode].collectibles={
	{"1", "悲伤洋葱", "↑ {{Tears}} 射速+0.7"},
	{"2", "内眼", "↓ {{Tears}} 射速修正x0.48#↓ {{Tears}} 射击延迟+3#角色一次发射3颗泪弹"},
	{"3", "弯勺魔术", "追踪泪弹"},
	{"4", "柯吉猫的头", "↑ {{Damage}} 伤害+0.5#↑ {{Damage}} 伤害修正x1.5"},
	{"5", "我的镜像", "↑ {{Range}} 射程+1.5#↑ 泪弹高度+1#↑ {{Shotspeed}} 弹速+0.6#↑ 泪弹高度+1#泪弹具有回旋效果"},
	{"6", "小号", "↑ {{Tears}} 射速+1.5#↑ 泪弹高度+0.76#↓ {{Range}} 射程-17.62"},
	{"7", "殉道者之血", "↑ {{Damage}} 伤害+1"},
	{"8", "波比兄弟", "发射普通泪弹#泪弹造成3.5点伤害"},
	{"9", "粪臭素", "所有敌对苍蝇变得友好"},
	{"10", "苍蝇光环", "环绕苍蝇+2#阻挡弹幕"},
	{"11", "1UP!", "↑ 生命+1#角色重生后回满血"},
	{"12", "魔法蘑菇", "↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.3#↑ {{Damage}} 伤害+0.3#↑ {{Damage}} 伤害修正x1.5#↑ {{Range}} 射程+5.25#↑ 泪弹高度+0.5#体型变大#{{HealingRed}} 回满血"},
	{"13", "病毒", "↓ {{Speed}} 移速-0.1#{{Poison}} 接触敌人使其中毒#{{BlackHeart}} 中毒的敌人死亡时20%概率掉1黑心"},
	{"14", "过量类固醇", "↑ {{Speed}} 移速+0.6#↑ {{Range}} 射程+5.25#↑ 泪弹高度+0.5"},
	{"15", "<3", "↑ {{Heart}} +1心之容器#{{HealingRed}} 回满血"},
	{"16", "生肝", "↑ {{Heart}} 心之容器+2#{{HealingRed}} 回满血"},
	{"17", "骷髅钥匙", "{{Key}} +99钥匙"},
	{"18", "一美元", "{{Coin}} +99硬币"},
	{"19", "轰！", "{{Bomb}} +10炸弹"},
	{"20", "超凡升天", "飞行!"},
	{"21", "指南针", "在地图上显示图标#不会显示地图轮廓"},
	{"22", "午餐", "↑ {{Heart}} +1心之容器"},
	{"23", "正餐", "↑ {{Heart}} +1心之容器"},
	{"24", "甜点", "↑ {{Heart}} +1心之容器"},
	{"25", "早餐", "↑ {{Heart}} +1心之容器"},
	{"26", "烂肉", "↑ {{Heart}} +1心之容器"},
	{"27", "木头勺子", "↑ {{Speed}} 移速+0.3"},
	{"28", "皮带", "↑ {{Speed}} 移速+0.3"},
	{"29", "妈妈的内裤", "↑ {{Range}} 射程+5.25#↑ 泪弹高度+0.5"},
	{"30", "妈妈的高跟鞋", "↑ {{Range}} 射程+5.25#↑ 泪弹高度+0.5"},
	{"31", "妈妈的口红", "↑ {{Range}} 射程+5.25#↑ 泪弹高度+0.5"},
	{"32", "铁丝衣架", "↑ {{Tears}} 射速+0.7"},
	{"33", "圣经", "{{Timer}} 在当前房间飞行#{{MomsHeart}} 立即击杀妈腿和妈心#{{Warning}} 当对撒但使用时, 角色会死亡"},
	{"34", "彼列之书", "{{AngelDevilChance}} 持有时, 恶魔房/天使房概率+12.5%#{{Timer}} 使用后, 在当前房间中获得:#↑ {{Damage}} 伤害+2"},
	{"35", "死灵之书", "对房间中所有敌人造成40点伤害"},
	{"36", "大便", "生成1个大便并击退敌人#可以放在靠近坑的位置然后炸掉作为桥"},
	{"37", "炸弹先生", "在角色下方放置1大炸弹, 造成110点伤害"},
	{"38", "塔米猫的头", "在角色周围发射10颗泪弹#泪弹与角色的效果一致, 额外+25点伤害"},
	{"39", "妈妈的胸罩", "{{Petrify}} 使房间中所有敌人石化4秒"},
	{"40", "神风！", "在角色位置造成一次爆炸#造成40点伤害"},
	{"41", "妈妈的卫生巾", "{{Fear}} 使房间中所有敌人恐惧5秒"},
	{"42", "鲍勃的烂头", "向发射方向投掷头#{{Poison}} 头接触到敌人时爆炸并使其中毒"},
	{"43", "", "<道具不存在>"},
	{"44", "传送！", "将角色传送至除错误房外的房间"},
	{"45", "美味的心", "{{HealingRed}} 治疗1红心"},
	{"46", "幸运脚", "↑ {{Luck}} 幸运+1#提升房间清理奖励概率#赌博时赢的概率更高"},
	{"47", "胎儿博士的遥控器", "{{Collectible168}} 使用时, 瞄准十字准星#1.5秒后导弹降落在准星处#造成20x角色伤害"},
	{"48", "丘比特之箭", "穿刺泪弹"},
	{"49", "嗖-哒-呜！", "下一次发射由激光取代#在0.9秒内造成26x角色伤害"},
	{"50", "史蒂文", "↑ {{Damage}} 伤害+1"},
	{"51", "五芒星", "↑ {{Damage}} 伤害+1#{{AngelDevilChance}} 恶魔房/天使房概率+10%"},
	{"52", "胎儿博士", "↓ {{Tears}} 射速修正x0.4#{{Bomb}} 角色的泪弹由炸弹取代#{{Damage}} 该炸弹造成5x角色伤害+30的伤害"},
	{"53", "万磁王", "角色吸引掉落物"},
	{"54", "藏宝图", "揭示地图轮廓#不显示房间图标"},
	{"55", "妈妈的眼睛", "50%概率向后发射1颗泪弹#{{Luck}} 幸运2: 100%概率"},
	{"56", "烦事柠檬", "留下一摊水迹#水迹每秒造成24点伤害"},
	{"57", "仰慕之交", "中范围环绕苍蝇#每秒造成75点接触伤害"},
	{"58", "影之书", "{{Timer}} 无敌10秒"},
	{"59", "", "<道具不存在>"},
	{"60", "梯子", "角色能走过1格间隙"},
	{"61", "", "<道具不存在>"},
	{"62", "吸血鬼之魅", "{{HealingRed}} 每击杀13个敌人治疗半红心"},
	{"63", "蓄电池", "{{Battery}} 主动道具可以过载充能至使用2次"},
	{"64", "Steam大促", "{{Shop}} 商店物品价格-50%"},
	{"65", "无政府主义者食谱", "在房间中央附近生成6个即爆炸弹"},
	{"66", "沙漏", "{{Slow}} 使敌人减速8秒"},
	{"67", "玛姬姐妹", "发射普通泪弹#泪弹造成3.5点伤害"},
	{"68", "科技", "角色会发射激光而不是泪弹"},
	{"69", "巧克力牛奶", "{{Chargeable}} 可蓄力泪弹#{{Damage}} 伤害随蓄力时间提升, 最高4x#{{Tears}} 最大充能时间为2.5x射击延迟"},
	{"70", "生长激素", "↑ {{Speed}} 移速+0.4#↑ {{Damage}} 伤害+1"},
	{"71", "小蘑菇", "↑ {{Speed}} 移速+0.3#↑ 泪弹高度+1.5#↑ 体型变小#↓ {{Range}} 射程-4.25#泪弹高度和射程的总体影响为射程稍微提升"},
	{"72", "念珠", "{{SoulHeart}} +3魂心#{{Collectible33}} 圣经添加至所有道具池"},
	{"73", "肉块", "1级: 环绕物#2级: 可发射泪弹的环绕物#3级: 食肉男孩#4级: 超级食肉男孩"},
	{"74", "25美分", "{{Coin}} +25硬币"},
	{"75", "药学博士证", "{{HealingRed}} 治疗2红心#{{Pill}} 生成1胶囊#{{Pill}} 将负面胶囊变为正面的#{{BloodDonationMachine}} 献血机得到的{{Coin}}硬币更多"},
	{"76", "X光透视", "{{SecretRoom}} 打开所有隐藏房入口"},
	{"77", "彩虹独角兽", "{{Timer}} 在6秒内获得:#↑ {{Speed}} 移速+0.28#无敌#角色无法发射泪弹, 但每秒造成40点接触伤害"},
	{"78", "启示录", "{{SoulHeart}} +1魂心#{{AngelDevilChance}} 持有时, 恶魔房/天使房概率+17.5%#使用后, 本层头目由天启骑士取代的概率更高"},
	{"79", "咒印", "↑ {{Speed}} 移速+0.2#↑ {{Damage}} 伤害+1#{{SoulHeart}} +1魂心"},
	{"80", "契约", "↑ {{Tears}} 射速+0.7#↑ {{Damage}} 伤害+0.5#{{SoulHeart}} +2魂心"},
	{"81", "嗝屁猫", "↑ 生命+9#死亡时, 角色以1心之容器重生#{{Warning}} 拾起时, 将角色的心之容器设置为1个"},
	{"82", "深渊领主", "↑ {{Speed}} 移速+0.3#飞行"},
	{"83", "钉子", "使用后:#{{SoulHeart}} +1魂心#{{Timer}} 在当前房间中获得:#↑ {{Damage}} 伤害+0.7#↓ {{Speed}} 移速-0.18#角色每秒造成40点接触伤害#角色可粉碎接触的石头"},
	{"84", "我们需要深入挖掘！", "打开1个跳过本层的活板门#{{LadderRoom}} 10%概率是暗门"},
	{"85", "卡牌盒", "{{Card}} 生成1卡牌"},
	{"86", "萌死戳的牙", "召唤萌死戳进行一次践踏, 造成120点伤害#{{Warning}} 若房间没有敌人, 则萌死戳会落在角色上"},
	{"87", "洛基的角", "25%概率向4个方向发射泪弹#{{Luck}} 幸运7: 100%概率"},
	{"88", "小胖蛆", "向角色发射方向冲刺#每秒造成52.5点接触伤害"},
	{"89", "蜘蛛之咬", "{{Slow}} 25%概率发射减速泪弹#{{Luck}} 幸运15: 100%概率"},
	{"90", "小石头", "↑ {{Tears}} 射速+0.2#↑ {{Damage}} 伤害+1#↓ {{Speed}} 移速-0.2"},
	{"91", "探窟帽", "揭示相邻房间的类型#{{SecretRoom}} 可以揭示隐藏房和超级隐藏房"},
	{"92", "超级绷带", "↑ {{Heart}} +1心之容器#{{HealingRed}} 治疗1红心#{{SoulHeart}} +2魂心"},
	{"93", "游戏掌机", "{{Timer}} 在6.5秒内获得:#无敌#角色无法发射, 但每秒造成40点接触伤害#{{HalfHeart}} 每击杀2个敌人治疗半红心#{{Fear}} 使房间中的所有敌人恐惧"},
	{"94", "硬币袋", "{{Coin}} 每2个房间随机生成1硬币"},
	{"95", "机器宝宝", "发射激光#激光造成3.5点伤害"},
	{"96", "查德宝宝", "{{HalfHeart}} 每3个房间生成1半红心"},
	{"97", "七原罪之书", "生成1随机掉落物"},
	{"98", "圣遗物", "{{SoulHeart}} 每5-6个房间生成1魂心"},
	{"99", "吉什宝宝", "{{Slow}} 发射减速泪弹#泪弹造成3.5点伤害"},
	{"100", "史蒂文宝宝", "发射追踪泪弹#泪弹造成3.5点伤害"},
	{"101", "光环", "↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.3#↑ {{Tears}} 射速+0.2#↑ {{Damage}} 伤害+0.3#↑ {{Range}} 射程+0.25#↑ 泪弹高度+0.5"},
	{"102", "妈妈的药瓶", "{{Pill}} 生成1胶囊"},
	{"103", "普通感冒", "{{Poison}} 25%概率发射有毒泪弹#{{Luck}} 幸运12: 100%概率"},
	{"104", "寄生虫", "泪弹击中后会分裂为2颗#分裂的泪弹造成的伤害减半"},
	{"105", "六面骰", "重置房间中的底座道具"},
	{"106", "大爆弹先生", "↑ {{Bomb}} 炸弹伤害x1.83#{{Bomb}} +5炸弹"},
	{"107", "锯齿剪", "{{Timer}} 在当前房间中获得:#飞行#角色的身体与头分离, 每秒造成82.5点接触伤害"},
	{"108", "圣饼", "大多数伤害降低为半心"},
	{"109", "金钱=力量", "↑ {{Damage}} 角色每持有{{Coin}}1硬币, 伤害+0.04"},
	{"110", "妈妈的美瞳", "↑ {{Range}} 射程+0.25#↑ 泪弹高度+0.5#{{Petrify}} 20%概率发射石化泪弹#{{Luck}} 幸运20: 50%概率"},
	{"111", "豆子", "{{Poison}} 对附近敌人造成5点伤害并使其中毒#中毒的敌人受到6次角色伤害"},
	{"112", "守护天使", "环绕物#提高所有其他环绕物的速度#阻挡弹幕#每秒造成105点接触伤害"},
	{"113", "恶魔宝宝", "自动向靠近的敌人发射#泪弹造成3点伤害"},
	{"114", "妈妈的菜刀", "角色的泪弹由可投掷的菜刀取代#{{Damage}} 持拿时菜刀造成2x角色伤害, 最远位置时造成6x"},
	{"115", "通灵板", "灵体泪弹"},
	{"116", "9伏特", "{{Battery}} 自动对主动道具的第1格充能#{{Battery}} 拾起时, 将主动道具完全充能"},
	{"117", "死鸟", "受伤时, 生成1只攻击敌人的鸟#鸟每秒造成4.3点接触伤害"},
	{"118", "硫磺火", "↓ {{Tears}} 射速修正x0.33#{{Chargeable}} 角色的泪弹由可蓄力的鲜血激光取代#{{Damage}} 在0.9秒内造成13x角色伤害"},
	{"119", "血袋", "↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.3#{{HealingRed}} 治疗4红心"},
	{"120", "怪异蘑菇(小)", "↑ {{Speed}} 移速+0.3#↑ {{Tears}} 射速+1.7#↓ {{Damage}} 伤害修正x0.9#↓ {{Damage}} 伤害-0.4"},
	{"121", "怪异蘑菇(大)", "↑ {{EmptyHeart}} +1空心之容器#↑ {{Damage}} 伤害+0.3#↑ {{Range}} 射程+0.25#↑ 泪弹高度+0.5#↓ {{Speed}} 移速-0.1"},
	{"122", "巴比伦大淫妇", "当不多于半红心时:#↑ {{Speed}} 移速+0.3#↑ {{Damage}} 伤害+1.5"},
	{"123", "怪物手册", "{{Timer}} 在当前房间中生成1个随机跟班"},
	{"124", "死海古卷", "触发1次随机主动道具的效果"},
	{"125", "波比炸弹", "{{Bomb}} +5炸弹#追踪炸弹"},
	{"126", "剃刀片", "↑ {{Damage}} 在当前房间中伤害+1.2#{{Warning}} 对角色造成1心伤害#{{Heart}} 优先消耗红心"},
	{"127", "遗忘药", "重置整层"},
	{"128", "孤独一生", "远范围苍蝇环绕物#每秒造成30点接触伤害"},
	{"129", "桶装猪油", "↑ {{EmptyHeart}} +2空心之容器#↓ {{Speed}} 移速-0.2#{{HealingRed}} 治疗半红心"},
	{"130", "小黑马", "持有时:#{{Speed}} 设置移速至少为1.5#飞行#使用后, 向角色移动方向冲刺"},
	{"131", "炸弹袋", "{{Bomb}} 每3个房间生成1炸弹"},
	{"132", "煤块", "{{Damage}} 泪弹前进越远伤害越高"},
	{"133", "嗝屁猫的爪子", "{{SoulHeart}} 将1心之容器转换为3魂心"},
	{"134", "嗝屁猫的尾巴", "{{Chest}} 33%概率将房间清理奖励变成箱子#33%概率使奖励消失"},
	{"135", "献血袋", "{{Coin}} 对角色造成半红心伤害并生成1-2硬币#{{Heart}} 优先消耗红心"},
	{"136", "最好的朋友", "生成1个诱饵, 吸引敌人并在5秒后爆炸"},
	{"137", "起爆器", "{{Bomb}} +5炸弹#角色的炸弹不再自动爆炸#使用时, 使角色的炸弹同时引爆"},
	{"138", "圣痕", "↑ {{Heart}} +1心之容器#↑ {{Damage}} 伤害+0.3"},
	{"139", "妈妈的钱包", "{{Trinket}} 角色可以持有2个饰品"},
	{"140", "鲍勃的诅咒", "{{Bomb}} +5炸弹#{{Poison}} 角色的炸弹会使炸到的敌人中毒"},
	{"141", "盛装男孩", "{{Coin}} 生成7随机硬币"},
	{"142", "肩衣", "{{SoulHeart}} 当受伤至半心时, 角色获得1魂心#每房间只会发生一次#离开并重进房间可以再次触发"},
	{"143", "混合麻药", "↑ {{Speed}} 移速+0.3#↑ {{Shotspeed}} 弹速+0.2"},
	{"144", "乞丐朋友", "{{Coin}} 捡起附近的硬币#每3-4硬币生成1随机掉落物"},
	{"145", "嗝屁猫的头", "生成2-4只蓝苍蝇"},
	{"146", "祈祷卡", "{{EternalHeart}} +1永恒之心"},
	{"147", "残损铁镐", "{{Timer}} 在当前房间中角色可粉碎接触的石头和隐藏房的墙"},
	{"148", "害虫横行", "受伤时, 生成1-3只蓝苍蝇"},
	{"149", "吐根酊", "↑ {{Damage}} 伤害+40#↓ {{Tears}} 射速修正x0.5#↓ {{Tears}} 射击延迟+10#角色的泪弹呈抛物线射出#{{Poison}} 泪弹会爆炸并使击中的敌人中毒"},
	{"150", "严厉的爱", "{{Damage}} 10%概率发射牙齿, 造成3.2x角色伤害#{{Luck}} 幸运9: 100%概率"},
	{"151", "虫群复击", "泪弹击中敌人时有1/6概率生成1只蓝苍蝇"},
	{"152", "科技II", "↓ {{Tears}} 射速修正x0.5#↓ {{Damage}} 伤害修正x0.65#角色右眼泪弹由持续激光取代#{{Damage}} 激光每秒造成3x角色伤害"},
	{"153", "变异蜘蛛", "↓ {{Tears}} 射速修正x0.48#↓ {{Tears}} 射击延迟+3#角色同时发射4颗泪弹"},
	{"154", "化学剥皮法", "↑ {{Damage}} 左眼伤害+2"},
	{"155", "窥眼", "在房间中四处漂浮#每秒造成17.1点接触伤害"},
	{"156", "修女服", "{{Battery}} 受伤时, 为主动道具回复1格充能"},
	{"157", "嗜血", "↑ {{Damage}} 受伤时, 伤害增加#每层能叠加6次#效果在当前层持续"},
	{"158", "水晶球", "生成1{{SoulHeart}}魂心/{{Rune}}符文/{{Card}}卡牌#{{Timer}} 揭示全图({{SuperSecretRoom}}超级隐藏房除外)"},
	{"159", "夜之幽魂", "灵体泪弹#飞行"},
	{"160", "撕裂苍穹", "在敌人附近生成5道光柱#在0.8秒内每道光柱造成8x角色伤害+160的伤害"},
	{"161", "安卡十字", "{{Player4}} 死亡时, 以???(小蓝人)重生"},
	{"162", "凯尔特十字", "受伤时, 20%概率使角色暂时无敌#{{Luck}} 幸运27: 100%概率"},
	{"163", "幽灵宝宝", "发射灵体泪弹#泪弹造成3.5点伤害"},
	{"164", "蓝蜡烛", "投掷蓝火#造成接触伤害, 阻挡弹幕, 2秒后消失"},
	{"165", "九尾鞭", "↑ {{Damage}} 伤害+1#↑ {{Shotspeed}} 弹速+0.23"},
	{"166", "二十面骰", "重置房间中的所有掉落物"},
	{"167", "小丑宝宝", "以V字形发射2颗泪弹#泪弹造成4点伤害"},
	{"168", "史诗胎儿博士", "发射泪弹改为瞄准十字准星#1.5秒后火箭降落在准星处#{{Damage}} 火箭造成20x角色伤害"},
	{"169", "巨人独眼", "↑ {{Damage}} 伤害+4#↑ {{Damage}} 伤害修正x2#↓ {{Tears}} 射速修正x0.48#↓ {{Tears}} 射击延迟+3#泪弹击杀敌人伤害溢出时会穿透敌人前进"},
	{"170", "长腿蛛父", "每4秒践踏附近敌人#每秒造成40点伤害"},
	{"171", "蜘蛛屁股", "{{Slow}} 使敌人减速4秒#所有敌人受到10点伤害"},
	{"172", "献祭匕首", "环绕物#阻挡弹幕#每秒造成225点接触伤害"},
	{"173", "主教冠", "{{SoulHeart}} 红心生成时有50%概率由魂心取代"},
	{"174", "彩虹宝宝", "发射随机泪弹#泪弹造成3-5点伤害"},
	{"175", "爸爸的钥匙", "打开房间中所有的门, 包括{{SecretRoom}}{{SuperSecretRoom}}隐藏房, {{ChallengeRoom}}{{BossRushRoom}}挑战房和超级撒旦的门"},
	{"176", "干细胞", "↑ {{Heart}} +1心之容器#↑ {{Shotspeed}} 弹速+0.16"},
	{"177", "便携式老虎机", "{{Coin}} 花费1硬币, 概率生成1掉落物"},
	{"178", "圣水", "受伤时, 留下一摊水迹#水迹每秒造成24点伤害"},
	{"179", "宿命", "{{EternalHeart}} +1永恒之心#飞行"},
	{"180", "黑豆", "受伤时, 角色放屁#{{Poison}} 屁会使敌人中毒"},
	{"181", "小白马", "持有时:#{{Speed}} 设置移速至少为1.5#飞行#使用后, 向角色移动方向冲刺, 留下光柱"},
	{"182", "圣心", "↑ {{Heart}} +1心之容器#↑ {{Damage}} 伤害修正x2.3#↑ {{Damage}} 伤害+1#↑ {{Range}} 射程+0.38#↑ 泪弹高度+0.75#↓ {{Tears}} 射速-0.4#↓ {{Shotspeed}} 弹速-0.25#{{HealingRed}} 回满血#追踪泪弹"},
	{"183", "牙签", "↑ {{Tears}} 射速+0.7#↑ {{Shotspeed}} 弹速+0.16"},
	{"184", "圣杯", "↑ {{Heart}} +1心之容器#飞行"},
	{"185", "死鸽", "灵体泪弹#飞行"},
	{"186", "血之权利", "对所有敌人造成40点伤害#{{Warning}} 对角色造成1心伤害#{{Heart}} 优先消耗红心"},
	{"187", "嗝屁猫的毛球", "移动时会使毛球摇动#毛球击杀敌人时变大#球越大, 造成的伤害越高"},
	{"188", "亚伯", "与角色移动互为镜像#向角色发射泪弹#泪弹造成3.5点伤害"},
	{"189", "超级食肉男孩死忠粉", "↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.2#↑ {{Tears}} 射速+0.2#↑ {{Damage}} 伤害+0.3#↑ {{Range}} 射程+0.5#↑ 泪弹高度+1#{{HealingRed}} 回满血"},
	{"190", "烟火盛宴", "{{Bomb}} +99炸弹"},
	{"191", "3美元纸币", "角色的泪弹每2-3秒获得随机效果"},
	{"192", "心灵感应傻瓜式教程", "{{Timer}} 在当前房间中泪弹有追踪效果"},
	{"193", "生肉！", "↑ {{Heart}} +1心之容器#↑ {{Damage}} 伤害+0.3"},
	{"194", "魔力八号球", "↑ {{Shotspeed}} 弹速+0.16#{{Card}} 生成1卡牌"},
	{"195", "妈妈的零钱包", "{{Pill}} 生成4胶囊"},
	{"196", "挤压玩具", "↑ {{Tears}} 射速+0.4#{{SoulHeart}} 生成2魂心"},
	{"197", "耶稣果汁", "↑ {{Damage}} 伤害+0.5#↑ {{Range}} 射程+0.25#↑ 泪弹高度+0.5"},
	{"198", "盒子", "每种掉落物生成1个"},
	{"199", "妈妈的钥匙", "{{Key}} +2钥匙#箱子中的掉落物更多"},
	{"200", "妈妈的眼影", "{{Charm}} 10%概率发射魅惑泪弹#{{Luck}} 幸运27: 100%概率"},
	{"201", "铁块", "↑ {{Damage}} 伤害+0.3#{{Confusion}} 10%概率发射混乱泪弹#{{Luck}} 幸运27: 100%概率"},
	{"202", "弥达斯之触", "{{Petrify}} 接触敌人时使其石化并变成金块#角色根据持有硬币量造成接触伤害#{{Coin}} 击杀金敌人会生成硬币#角色生成的大便为金大便的概率更高"},
	{"203", "慈善捆绑包", "所有可能的掉落物成对出现"},
	{"204", "挎包", "受伤时, 50%概率生成1随机掉落物"},
	{"205", "锋利插头", "{{Battery}} 使用未充能的主动道具时, 花费2心使其完全充能#只有道具完全没有充能时有效"},
	{"206", "断头台", "↑ {{Tears}} 射击延迟-1#↑ {{Damage}} 伤害+1#角色的头变成环绕物, 不会承受受伤, 每秒造成105点接触伤害"},
	{"207", "绷带球", "1级: 环绕物#{{Charm}} 2级: 发射魅惑泪弹的环绕物#{{Charm}} 3级: 绷带女孩#{{Charm}} 4级: 超级绷带女孩"},
	{"208", "冠军腰带", "↑ {{Damage}} 伤害+1#精英敌人概率从5%增至20%#不增加精英头目的概率"},
	{"209", "屁股炸弹", "{{Bomb}} +5炸弹#{{Confusion}} 爆炸会使房间中所有敌人混乱并造成10点伤害"},
	{"210", "狸猫树叶", "完全不行动1秒后, 角色无敌"},
	{"211", "蜘蛛宝宝", "受伤时, 生成1-2只蓝蜘蛛"},
	{"212", "嗝屁猫的项圈", "死亡时, 50%概率以半心重生"},
	{"213", "丢失的隐形眼镜", "↓ {{Shotspeed}} 弹速-0.15#角色的泪弹能摧毁敌人的弹幕"},
	{"214", "贫血", "↑ {{Range}} 射程+5#{{Timer}} 受伤时, 在房间中留下血迹#血迹每秒造成6点伤害"},
	{"215", "山羊头", "{{AngelDevilChance}} 100%恶魔房/天使房概率"},
	{"216", "仪式法袍", "↑ {{Damage}} 伤害+1#{{BlackHeart}} +3黑心"},
	{"217", "妈妈的假发", "{{HealingRed}} 治疗1红心#发射泪弹时, 5%概率生成1只蓝蜘蛛#{{Luck}} 幸运10: 100%概率"},
	{"218", "胎盘", "↑ {{Heart}} +1心之容器#{{HealingRed}} 每分钟50%概率治疗半红心"},
	{"219", "旧绷带", "↑ {{EmptyHeart}} +1空心之容器#{{Heart}} 受伤时, 10%概率生成1红心"},
	{"220", "悲伤炸弹", "{{Bomb}} +5炸弹#角色的炸弹爆炸时环形发射10颗泪弹"},
	{"221", "橡胶胶水", "角色的泪弹会在敌人和障碍物上反弹"},
	{"222", "反重力", "↑ {{Tears}} 射击延迟-2#按住发射键会使泪弹悬空#松开后, 所有泪弹会向发射方向继续前进"},
	{"223", "纵火狂", "{{Bomb}} +5炸弹#免疫爆炸, 岩石波, 践踏的伤害#{{HealingRed}} 受爆炸击中时治疗1红心"},
	{"224", "柯吉猫的身体", "↑ {{Tears}} 射击延迟-1#↑ {{Tearsize}} 泪弹尺寸x1.2#↓ {{Range}} 射程-10#泪弹击中后会分裂为4颗#分裂的泪弹造成的伤害减半"},
	{"225", "兽性面具", "{{SoulHeart}} 受伤时, 概率生成1魂心#{{HalfHeart}} 敌人死亡时概率掉落1半红心"},
	{"226", "黑莲花", "↑ {{Heart}} +1心之容器#{{SoulHeart}} +1魂心#{{BlackHeart}} +1黑心"},
	{"227", "小猪存钱罐", "{{Coin}} +3硬币#受伤时, 生成1-2硬币"},
	{"228", "妈妈的香水", "↑ {{Tears}} 射击延迟-1#{{Fear}} 15%概率发射恐惧泪弹"},
	{"229", "萌死戳的肺", "↓ {{Tears}} 射击延迟x4.3#{{Chargeable}} 泪弹可蓄力并在松开时散射"},
	{"230", "亚巴顿", "↑ {{Speed}} 移速+0.2#↑ {{Damage}} 伤害+1.5#↓ {{EmptyHeart}} 移除所有心之容器#{{BlackHeart}} +6黑心#{{Fear}} 15%概率发射恐惧泪弹"},
	{"231", "焦油球", "{{Slow}} 10%概率发射减速泪弹#{{Luck}} 幸运18: 100%概率#{{Slow}} 角色会留下减速水迹"},
	{"232", "怀表", "↑ {{Speed}} 移速+0.3#{{Slow}} 受伤时, 使房间中的所有敌人永久减速"},
	{"233", "小小星球", "↑ 泪弹高度+7#灵体泪弹#角色的泪弹环绕在角色周围"},
	{"234", "害虫横行II", "击杀敌人时, 生成1只蓝蜘蛛"},
	{"235", "", "<道具不存在>"},
	{"236", "大肠杆菌", "接触敌人时, 使其变成大便"},
	{"237", "死神之触", "↑ {{Damage}} 伤害+1.5#↑ {{Tearsize}} 泪弹尺寸x2#↓ {{Tears}} 射速-0.3#穿刺泪弹"},
	{"238", "钥匙碎片1", "{{Warning}} 集齐两个钥匙碎片可开启金色大门#{{AngelChance}} 天使房概率+25%#{{EternalHeart}} 永恒之心概率+2%"},
	{"239", "钥匙碎片2", "{{Warning}} 集齐两个钥匙碎片可开启金色大门#{{AngelChance}} 天使房概率+25%#{{EternalHeart}} 永恒之心概率+2%"},
	{"240", "实验性疗法", "↑ 随机提升4项属性#↓ 随机降低2项属性"},
	{"241", "地狱契约", "所有房间清理奖励翻倍#33%概率房间清理奖励消失"},
	{"242", "耻辱假面", "50%概率阻挡弹幕"},
	{"243", "三位一体盾", "阻挡角色发射方向的敌人弹幕"},
	{"244", "科技0.5", "时不时发射激光"},
	{"245", "完美视力", "角色同时发射2颗泪弹"},
	{"246", "蓝地图", "{{SecretRoom}} 在地图上揭示隐藏房"},
	{"247", "好朋友一辈子！", "跟班造成的伤害翻倍"},
	{"248", "虫群之心", "蓝蜘蛛/蓝苍蝇造成的伤害翻倍"},
	{"249", "额外选择", "允许角色击败头目后从2个道具中选择"},
	{"250", "炸弹买一送一", "{{Bomb}} 所有炸弹掉落物变成一对炸弹"},
	{"251", "新手牌组", "{{Card}} 拾起时, 生成1卡牌#角色能携带2卡牌#将所有胶囊变成卡牌"},
	{"252", "小药袋", "{{Pill}} 拾起时, 生成1胶囊#角色能携带2胶囊#将所有卡牌变成胶囊"},
	{"253", "魔法血痂", "↑ {{Heart}} +1心之容器#↑ {{Luck}} 幸运+1"},
	{"254", "血块", "↑ {{Damage}} 左眼伤害+1#↑ {{Range}} 左眼射程+5#↑ 泪弹高度+0.5"},
	{"255", "螺丝", "↑ {{Tears}} 射速+0.5#↑ {{Shotspeed}} 弹速+0.2"},
	{"256", "炙热炸弹", "{{Bomb}} +5炸弹#{{Burning}} 角色的炸弹爆炸时会留下火焰"},
	{"257", "火焰意志", "{{Burning}} 角色的泪弹可点燃敌人#击中敌人时, 泪弹有10%概率爆炸#{{Luck}} 幸运13: 100%概率#{{Warning}} 爆炸也会伤到角色"},
	{"258", "编号丢失", "拾起时和每次进入新层时, 重置角色属性和持有道具"},
	{"259", "暗物质", "↑ {{Damage}} 伤害+1#{{Fear}} 33%概率发射恐惧泪弹# {{Luck}} 幸运20: 100%概率"},
	{"260", "黑蜡烛", "{{CurseBlind}} 免疫诅咒#{{BlackHeart}} +1黑心#{{AngelDevilChance}} 恶魔房/天使房概率+15%"},
	{"261", "眼球突出", "↑ {{Damage}} 伤害修正x2#↓ 泪弹前进越远伤害越低"},
	{"262", "遗失的书页2", "{{BlackHeart}} +1黑心#受伤至1心时, 对房间中所有敌人造成伤害"},
	{"263", "", "<道具不存在>"},
	{"264", "智能苍蝇", "环绕物#每秒造成22.5点接触伤害#角色受伤前, 阻挡弹幕#角色受伤后, 追击附近敌人"},
	{"265", "枯骨宝宝", "当被敌人弹幕击中时, 10%概率对房间中所有敌人造成40点伤害"},
	{"266", "粘液卵囊", "{{Slow}} 留下减速水迹#清理房间后, 生成1-2只蓝蜘蛛"},
	{"267", "机器宝宝2.0", "发射激光#激光造成3.5点伤害#向角色发射方向移动"},
	{"268", "腐烂宝宝", "角色发射时, 生成蓝苍蝇"},
	{"269", "无头宝宝", "留下每秒造成6点伤害的水迹"},
	{"270", "水蛭", "追击敌人#{{HealingRed}} 击杀敌人时为角色治疗半红心#每秒造成3.2点接触伤害"},
	{"271", "神秘的袋子", "每5-6个房间生成1随机掉落物"},
	{"272", "大美蝇", "友好的爆炸苍蝇#爆炸造成60点伤害#{{Warning}} 爆炸也会伤到角色"},
	{"273", "鲍勃的脑浆子", "向角色发射方向冲刺#接触到敌人时爆炸#{{Poison}} 爆炸造成60点伤害并使敌人中毒#{{Warning}} 爆炸也会伤到角色"},
	{"274", "生死之交", "受伤时, 在房间中生成1个中范围环绕物#环绕物每秒造成75点接触伤害"},
	{"275", "硫磺火宝宝", "{{Chargeable}} 蓄力并发射{{Collectible118}}硫磺火激光#激光在0.63秒内造成31.5点伤害"},
	{"276", "以撒的心脏", "角色无敌#生成跟随角色的心脏#{{Warning}} 心脏受伤时, 角色也会受伤"},
	{"277", "恶灵宝宝", "{{Fear}} 追击并使敌人恐惧#每秒造成4点接触伤害"},
	{"278", "黑暗乞丐", "{{Heart}} 捡起附近的红心#{{SoulHeart}} 每捡起1.5红心, 生成1魂心/黑心/蜘蛛"},
	{"279", "大粉丝", "较大的环绕物#每秒造成30点接触伤害"},
	{"280", "长腿蛛妹妹", "在有敌人的房间里随机生成蓝蜘蛛, 最多5只"},
	{"281", "受气包", "诱饵跟班#敌人有时会以他而不是角色作为目标"},
	{"282", "跳跃教程", "允许角色跳过间隙和障碍物"},
	{"283", "一百面骰", "重置房间中所有掉落物, 底座道具和角色持有的被动道具"},
	{"284", "四面骰", "重置所有角色持有的被动道具"},
	{"285", "十面骰", "重置房间中所有敌人"},
	{"286", "空白卡牌", "触发角色持有的符文/卡牌的效果"},
	{"287", "秘密之书", "{{Timer}} 在本层获得以下三种效果之一:#{{Collectible54}} 藏宝图#{{Collectible21}} 指南针 #{{Collectible246}} 蓝地图"},
	{"288", "蜘蛛盒", "生成1-4只蓝蜘蛛"},
	{"289", "红蜡烛", "投掷红火#火焰可造成接触伤害, 阻挡弹幕, 在造成或阻挡5次伤害后消失"},
	{"290", "罐子", "{{Heart}} 满血时, 最多将4红心存入罐中#使用时, 所存红心全部掉在地上"},
	{"291", "冲水！", "使非头目敌人变成大便#立即击杀便便类敌人和头目"},
	{"292", "撒但圣经", "{{BlackHeart}} +1黑心"},
	{"293", "坎卜斯的头", "{{Collectible118}} 在四个方向上发射硫磺火激光#每道激光在1.33秒内造成440点伤害"},
	{"294", "棉豆", "击退附近的敌人和弹幕#10%概率在换成其他主动道具再将其换回来后, 变成更强的{{Collectible484}}等等, 啥?"},
	{"295", "魔术手指", "对房间中所有敌人造成2x角色伤害#{{Coin}} 花费1硬币"},
	{"296", "转换器", "{{Heart}} 将2魂心/黑心转换为1心之容器"},
	-- NOTE FOR LOCALIZERS: There is code to highlight the text of your current floor
	-- For it to work, only use line breaks or semicolons to separate floor details, and use the same order as English
	{"297", "潘多拉魔盒", "{{NoLB}}根据所在层生成奖励:#1章1: 2{{SoulHeart}}; 1章2: 2{{Bomb}}+2{{Key}}#{{NoLB}}2章1: 1{{BossRoom}}道具; 2章2: 2章1+2{{SoulHeart}}#3章1: 4{{SoulHeart}}; 3章2: 20{{Coin}}#4章1: 2{{BossRoom}}道具; 4章2: {{Collectible33}}圣经#???/虚空: 无#阴间: 1{{DevilRoom}}道具+1{{BlackHeart}}; 教堂: 1{{AngelRoom}}道具+1{{EternalHeart}}#{{NoLB}}暗室: 解锁{{Collectible523}}搬家盒; 玩具箱: 1{{Coin}}"},
	{"298", "独角兽的残角", "{{Timer}} 在6秒内获得:#↑ {{Speed}} 移速+0.28#无敌#角色无法发射(也没有接触伤害)"},
	{"299", "金牛座", "↓ {{Speed}} 移速-0.3#↑ {{Speed}} 在有敌人的房间中, 移速缓慢增加#移速达到2时, 角色无敌并造成接触伤害, 持续5秒#随后, 在当前房间中失去金牛座移速加成"},
	{"300", "白羊座", "↑ {{Speed}} 移速+0.25#移速大于0.85时, 对敌人造成18点接触伤害"},
	{"301", "巨蟹座", "{{SoulHeart}} +3魂心#受伤后, 在当前房间中后续所受伤害降低为半心"},
	{"302", "狮子座", "体型变大#粉碎接触的石头"},
	{"303", "室女座", "受伤时, 概率获得10秒无敌#{{Luck}} 幸运10: 100%概率#将负面胶囊变成正面的"},
	{"304", "天秤座", "+6{{Coin}}硬币, {{Bomb}}炸弹, {{Key}}钥匙#平衡角色属性#后续的属性变化会分散到各个属性"},
	{"305", "天蝎座", "{{Poison}} 有毒泪弹"},
	{"306", "人马座", "↑ {{Speed}} 移速+0.2#穿刺泪弹"},
	{"307", "摩羯座", "↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.1#↑ {{Tears}} 射击延迟-1#↑ {{Damage}} 伤害+0.5#↑ {{Range}} 射程+1.5#+1{{Coin}}硬币, {{Bomb}}炸弹, {{Key}}钥匙"},
	{"308", "宝瓶座", "角色留下水迹#水迹每秒造成6点伤害"},
	{"309", "双鱼座", "↑ {{Tears}} 射击延迟-1#↑ {{Tearsize}} 泪弹尺寸x1.25#提高泪弹击退力"},
	{"310", "夏娃的睫毛膏", "↑ {{Damage}} 伤害修正x2#↓ {{Tears}} 射速修正x0.5#↓ {{Shotspeed}} 弹速-0.5"},
	{"311", "犹大的影子", "{{Player12}} 死亡时, 以伤害修正x2的犹大之影重生"},
	{"312", "抹大拉的蝴蝶结", "↑ {{Heart}} +1心之容器#所有红心治疗量翻倍"},
	{"313", "神圣屏障", "阻挡每个房间第一次受到的伤害"},
	{"314", "霹雳大腿", "↑ {{Heart}} +1心之容器#↓ {{Speed}} 移速-0.4#角色摧毁接触的石头"},
	{"315", "怪异磁铁", "角色的泪弹吸引敌人, 掉落物和饰品"},
	{"316", "诅咒之眼", "蓄力发射4颗泪弹#{{Warning}} 蓄力未满时受伤会将角色传送至随机房间"},
	{"317", "神秘液体", "角色的泪弹会留下水迹#水迹每秒造成30点伤害"},
	{"318", "双子座", "近战跟班#每秒造成6点接触伤害"},
	{"319", "该隐的另一只眼", "在房间中四处漂浮#与角色同方向发射, 造成1x角色伤害"},
	{"320", "???唯一的朋友", "可控制的苍蝇#每秒造成37.5点接触伤害"},
	{"321", "参孙的脚镣", "可拖动的球, 能够摧毁石头#每秒造成10.7点接触伤害"},
	{"322", "蒙戈宝宝", "复制其他跟班的泪弹效果#造成2x所复制跟班的伤害#若没有跟班, 则发射普通的3.5伤害泪弹"},
	{"323", "以撒的泪盆", "向8个方向发射泪弹#泪弹复制角色泪弹的效果#发射泪弹时充能"},
	{"324", "未定义", "传送至{{TreasureRoom}}宝箱房/{{SecretRoom}}隐藏房/{{SuperSecretRoom}}超级隐藏房/{{ErrorRoom}}错误房"},
	{"325", "剪刀", "{{Timer}} 当前房间中将角色的头变为不动的跟班#头发射泪弹造成3.5点伤害#独立控制角色身体, 仍发射角色的泪弹"},
	{"326", "生命之息", "按住使用键时消耗充能条#充能条为空时角色暂时无敌#{{Warning}} 按住过久会对角色造成伤害"},
	{"327", "全家福", "若不多于半红心时受伤, 则获得5秒无敌"},
	{"328", "底片", "若不多于半红心时受伤, 则对房间中所有敌人造成伤害"},
	{"329", "鲁多维科科技", "角色的泪弹由1颗巨大的可控泪弹取代"},
	{"330", "豆奶", "↑ {{Tears}} 射速修正x4#↑ {{Tears}} 发射延迟-2#↓ {{Damage}} 伤害修正x0.2#↓ {{Tearsize}} 泪弹尺寸x0.5"},
	{"331", "神性", "↑ {{Damage}} 伤害+0.5#↑ {{Range}} 射程+1.2#↓ {{Tears}} 射速-0.3#↓ {{Shotspeed}} 弹速-0.3#追踪泪弹#{{Damage}} 泪弹具有光环, 每秒造成4.5x角色伤害"},
	{"332", "拉撒路的绷带", "{{Player11}} 死亡时, 以'复活的拉撒路'重生"},
	{"333", "思想", "获得完整的地图效果"},
	{"334", "肉体", "↑ {{Heart}} +3心之容器"},
	{"335", "灵魂", "{{SoulHeart}} +2魂心#获得排斥敌人和弹幕的光环"},
	{"336", "烂洋葱", "↑ {{Range}} 射程+0.25#↑ {{Tearsize}} 泪弹尺寸x1.5#↓ -0.5泪弹高度#↓ {{Shotspeed}} 弹速-0.4#穿刺灵体泪弹"},
	{"337", "损坏的怀表", "{{Slow}} 每4个房间减速一次#13%概率由加速取代"},
	{"338", "回旋镖", "可投掷的回旋镖#{{Petrify}} 使敌人石化并造成2x角色伤害#可带回物品"},
	{"339", "安全别针", "↑ {{Range}} 射程+5.25#↑ 泪弹高度+0.5#↑ {{Shotspeed}} 弹速+0.16#{{BlackHeart}} +1黑心"},
	{"340", "咖啡因片", "↑ {{Speed}} 移速+0.3#↑ 体型变小#{{Pill}} 生成1随机胶囊"},
	{"341", "撕碎的照片", "↑ {{Tears}} 射速+0.7#↑ {{Shotspeed}} 弹速+0.16"},
	{"342", "蓝盖蘑菇", "↑ {{Heart}} +1心之容器#↑ {{Tears}} 射速+0.7#↓ {{Shotspeed}} 弹速-0.16"},
	{"343", "弹簧锁钥匙", "↑ {{Luck}} 幸运+1#{{SoulHeart}} +1魂心#{{Key}} 生成2钥匙"},
	{"344", "火柴盒", "{{BlackHeart}} +1黑心#{{Bomb}} 生成3炸弹"},
	{"345", "合成油脂", "↑ {{Damage}} 伤害+1#↑ {{Range}} 射程+5.25#↑ 泪弹高度+0.5"},
	{"346", "零食", "↑ {{Heart}} +1心之容器"},
	{"347", "复视", "复制房间中所有底座道具和掉落物"},
	{"348", "安慰剂", "{{Pill}} 触发角色持有胶囊的效果"},
	{"349", "木制镍币", "{{Coin}} 56%概率生成1随机硬币"},
	{"350", "毒性休克", "{{Poison}} 进入房间时, 使所有敌人中毒#被毒死的敌人留下水迹#水迹每秒造成30点伤害"},
	{"351", "超级豆子", "{{Petrify}} 使房间中所有敌人石化#{{Poison}} 造成5点伤害并使附近敌人中毒#向角色移动方向发出岩石波#岩石波可打开隐藏房和粉碎石头"},
	{"352", "玻璃大炮", "{{Warning}} 发射炮弹会将角色血量降至半心#发射一颗巨大的穿刺灵体泪弹, 造成10x角色伤害+10的伤害"},
	{"353", "炸弹人", "{{Bomb}} +5炸弹#炸弹十字爆炸"},
	{"354", "琥珀爆米花", "↑ {{Heart}} +1心之容器#{{Trinket}} 生成1饰品"},
	{"355", "妈妈的珍珠项链", "↑ {{Range}} 射程+1.25#↑ 泪弹高度+0.5#↑ {{Luck}} 幸运+1"},
	{"356", "车载电池", "{{Battery}} 使用主动道具时触发效果两次"},
	{"357", "朋友盒", "{{Timer}} 在当前房间复制所有跟班#{{Collectible113}} 若没有跟班, 则在当前房间获得1个恶魔宝宝"},
	{"358", "蠢巫帽", "同时对角发射2颗泪弹"},
	{"359", "八寸钉", "↑ {{Damage}} 伤害+1.5#提高击退力"},
	{"360", "淫魔", "发射泪弹, 效果和属性与角色一致"},
	{"361", "宿命的报答", "发射泪弹, 效果和属性与角色一致#射速是其他跟班的一半"},
	{"362", "小箱子", "清理房间后, 33%概率生成1随机掉落物"},
	{"363", "宣誓守护者", "环绕物#每秒造成105点接触伤害#吸引并阻挡弹幕#在1个房间中阻挡10颗弹幕时, 生成1{{EternalHeart}}永恒之心"},
	{"364", "浅交朋友", "中范围苍蝇环绕物#每秒造成45点接触伤害"},
	{"365", "迷路苍蝇", "沿着房间中的墙/障碍物行进#每秒造成105点接触伤害"},
	{"366", "分裂炸弹", "{{Bomb}} +5炸弹#角色的炸弹会炸成2-4个小炸弹"},
	{"367", "粘性炸弹", "{{Bomb}} +5炸弹#角色的炸弹会粘在敌人身上#用炸弹击杀敌人会生成蓝蜘蛛"},
	{"368", "溢泪症", "↑ {{Tears}} 持续向单方向发射会逐渐降低射击延迟, 最多降至50%"},
	{"369", "连续统", "↑ {{Range}} 射程+2.25#↑ 泪弹高度+1.5#灵体泪弹#泪弹会过屏幕, 从另一边回来"},
	{"370", "玩偶先生", "↑ {{Tears}} 射速+0.7#↑ {{Range}} 射程+5.25#↑ 泪弹高度+0.5#{{UnknownHeart}} 生成3随机心"},
	{"371", "塔之诅咒", "{{Warning}} 受伤时, 生成6个即爆炸弹#该炸弹继承角色的炸弹效果"},
	{"372", "充电宝宝", "在未清理的房间中, 每30秒产生以下效果之一:#{{Battery}} 生成1电池(每房间最多2次)#{{Battery}} 为主动道具充能1格(每房间最多2次)#{{Petrify}} 将房间中所有敌人石化"},
	{"373", "死亡之眼", "↑ {{Damage}} 每次成功击中敌人伤害+25%(最高+100%)#未击中时, 概率重置修正"},
	{"374", "圣光", "10%概率发射圣光泪弹, 击中时会产生光柱#{{Luck}} 幸运9: 50%概率#{{Damage}} 光柱造成4x角色伤害"},
	{"375", "寄居骷髅帽", "免疫爆炸, 岩石波, 践踏的伤害#20%概率阻挡弹幕"},
	{"376", "补货", "生成3随机掉落物#商店物品购买后会立刻补货"},
	{"377", "爆裂虫卵", "蜘蛛类敌人不再以角色为目标, 也不对角色造成接触伤害"},
	{"378", "大号", "持续发射3秒后, 生成1大便炸弹"},
	{"379", "双瞳", "↑ {{Tearsize}} 泪弹尺寸x2#灵体泪弹"},
	{"380", "充钱游戏", "{{Coin}} +5硬币#{{Coin}} 单钥匙门必须用硬币打开而不是钥匙"},
	{"381", "伊甸的祝福", "↑ {{Tears}} 射速+0.7#下一局开始时, 获得1随机道具"},
	{"382", "友好球", "可以扔向敌人将其捕捉#{{Friendly}} 下一次使用则会生成相同的友好敌人"},
	{"383", "眼泪引爆器", "引爆屏幕中的泪弹, 每颗泪弹分裂为6颗并以环状散开"},
	{"384", "肉山宝宝", "{{Chargeable}} 弹出并在房间中反弹, 速度基于蓄力时间#根据蓄力时间, 每秒造成5-90点接触伤害"},
	{"385", "乞丐宝", "{{Coin}} 捡起附近的硬币#捡起7, 13, 25硬币时升级#2级: 清理房间后, 概率生成掉落物或道具#3级: 发射泪弹, 击中时概率生成硬币#4级: 追击敌人, 每秒造成37.5点接触伤害#4级: 继续捡硬币, 能生成掉落物或道具"},
	{"386", "十二面骰", "将障碍物重置为其他随机类型的障碍物(大便/罐子/TNT/红大便/石头等)"},
	{"387", "香炉", "{{Slow}} 产生大片光环, 能够使其中的敌人和弹幕减速"},
	{"388", "钥匙乞丐", "{{Key}} 捡起附近的钥匙#{{Chest}} 生成随机宝箱作为回报"},
	{"389", "符文袋", "{{Rune}} 每5-6个房间生成1随机符文"},
	{"390", "撒拉弗", "发射圣心泪弹#泪弹造成10点伤害"},
	{"391", "背叛", "{{Charm}} 受伤时, 魅惑房间中所有敌人"},
	{"392", "黄道十二宫", "每层获得1个随机星座道具效果"},
	{"393", "蛇蝎之吻", "{{Poison}} 15%概率发射有毒泪弹#{{Poison}} 使接触的敌人中毒#{{BlackHeart}} 中毒敌人死亡时, 20%概率掉落1黑心"},
	{"394", "十字准星", "↑ {{Tears}} 射速+0.7#↑ {{Range}} 射程+3.15#↑ 泪弹高度+0.3#角色自动向地上的可控红色标记发射泪弹"},
	{"395", "科技X", "{{Chargeable}} 角色的泪弹由可蓄力的激光环取代#激光环尺寸随蓄力时间增加"},
	{"396", "心室手术刀", "创造最多2个传送门#可以在不同房间放置"},
	{"397", "牵引光束", "↑ {{Tears}} 射速+0.5#↑ {{Range}} 射程+5.25#↑ 泪弹高度+0.5#↑ {{Shotspeed}} 弹速+0.16#角色的泪弹受角色面前的光束指引"},
	{"398", "神体蘑菇", "{{Shrink}} 10%概率发射使敌人缩小的泪弹#缩小的敌人可以被踩死"},
	{"399", "虚空之喉", "↑ {{Damage}} 伤害+1#{{Chargeable}} 持续发射泪弹2.35秒后, 松开发射键会产生黑硫磺火圈#黑圈在2秒内造成30x角色伤害#{{BlackHeart}} 被黑圈击杀的敌人有5%概率掉落1黑心"},
	{"400", "命运之矛", "在角色面前生成一根矛#{{Fear}} 每秒造成约8.57x角色伤害, 概率使接触到的敌人恐惧"},
	{"401", "爆炸物", "25%概率发射粘性炸弹泪弹#泪弹击中时不造成伤害, 几秒后爆炸"},
	{"402", "混沌", "底座道具会从随机道具池产生#生成1-6随机掉落物"},
	{"403", "蜘蛛模组", "显示泪弹伤害和所有敌人的血条#接触敌人时, 施加随机状态效果#清理房间后, 概率生成蓝蜘蛛/小电池"},
	{"404", "放屁宝宝", "阻挡弹幕#受击时, 10%概率放屁, 效果为{{Charm}}魅惑/{{Poison}}中毒/击退三种其一"},
	{"405", "恶性漏洞", "在房间中漂浮#每秒造成120点接触伤害, 并施加随机状态效果#在有敌人的房间中, 接触掉落物时, 概率将其变成其他物品"},
	{"406", "八面骰", "角色的伤害, 射速, 射程, 移速属性的修正x0.5-x2#修正在每次使用后重置"},
	{"407", "纯洁", "↑ 根据光环颜色对角色属性进行增强#受伤时, 移除光环, 在下个房间获得新的光环#{{ColorYellow}}黄色{{CR}} = ↑ {{Speed}} 移速+0.5#{{ColorBlue}}蓝色{{CR}} = ↑ {{Tears}} 射击延迟-4#{{ColorRed}}红色{{CR}} = ↑ {{Damage}} 伤害+4#{{ColorOrange}}橙色{{CR}} = ↑ {{Range}} 射程+7.5, ↑ 泪弹高度+1"},
	{"408", "祭祀之刃", "受伤时, 在角色周围产生黑色硫磺火圈#{{BlackHeart}} 敌人被黑圈击杀时, 15%概率掉落1黑心"},
	{"409", "空容器", "{{BlackHeart}} +2黑心#{{EmptyHeart}} 角色没有红心时:#获得飞行#在有敌人的房间中, 每40秒产生1个持续10秒的护盾"},
	{"410", "邪恶之眼", "3.33%概率发射眼睛#{{Luck}} 幸运20: 10%概率#眼睛缓慢移动并发射与角色方向一致的泪弹"},
	{"411", "血嗜", "↑ {{Damage}} 击杀敌人时, 在当前房间中伤害+0.5#最多击杀10个敌人伤害+5"},
	{"412", "恶魔受胎", "受伤15次, 30次, 60次, 90次时, 永久获得1个恶魔跟班#最多产生4个跟班"},
	{"413", "圣灵受胎", "每拾起15次心, 永久获得1个天使跟班并生成1魂心#最多产生5个跟班"},
	{"414", "更多选择", "{{TreasureRoom}} 允许宝箱房道具二选一"},
	{"415", "光明之冠", "{{SoulHeart}} +2魂心#若角色无不满的心之容器:#↑ {{Damage}} 伤害修正x2#↑ {{Range}} 射程+5.25#↑ 泪弹高度+0.5#↓ {{Shotspeed}} 弹速-0.3#受伤后, 在当前房间中效果消失"},
	{"416", "深口袋", "允许角色携带2卡牌/胶囊/符文"},
	{"417", "魅魔", "在房间中漂浮的跟班, 产生伤害光环, 每秒造成1.29x角色伤害#↑ {{Damage}} 站在光环中伤害修正x1.5"},
	{"418", "水果蛋糕", "每颗泪弹都有不同效果"},
	{"419", "传送2.0", "传送至未探索的随机房间#顺序: {{Room}}>{{BossRoom}}>{{SuperSecretRoom}}>{{Shop}}>{{TreasureRoom}}>{{SacrificeRoom}}> {{DiceRoom}}>{{Library}}>{{CursedRoom}}>{{MiniBoss}}>{{ChallengeRoom}}>{{IsaacsRoom}}{{BarrenRoom}}> {{ArcadeRoom}}>{{ChestRoom}}>{{SecretRoom}}>{{DevilRoom}}{{AngelRoom}}>{{ErrorRoom}}"},
	{"420", "黑色粉末", "在地上走1个圈会产生五角星符号, 4秒内造成130点接触伤害"},
	{"421", "腰豆", "{{Charm}} 对近距离的所有敌人造成5点伤害并魅惑"},
	{"422", "发光沙漏", "将角色带回上个房间, 回退所有使用时房间的行动"},
	{"423", "保护之环", "角色周围产生1个大光环, 每秒造成1x角色伤害#概率反弹敌人弹幕"},
	{"424", "福袋头", "掉落物有概率由{{GrabBag}}福袋取代:#{{Coin}}: 10%, {{Bomb}}{{Key}}{{Pill}}{{Rune}}{{Battery}}: 20%#{{GrabBag}} 生成1福袋"},
	{"425", "小夜灯", "{{Slow}} 在角色面前生成锥形光, 使其中的敌人和弹幕减速#移除当前层黑暗诅咒"},
	{"426", "狂热粉丝", "模仿角色移动, 有3秒延迟#每秒造成30点接触伤害"},
	{"427", "工矿炸药包", "生成1个可推的TNT桶#在相同房间中第二次使用时, 远程引爆之前生成的桶"},
	{"428", "睡衣", "{{HealingRed}} 回满血#{{SoulHeart}} +4魂心"},
	{"429", "店主的头", "{{Coin}} 敌人被泪弹中时, 5%概率掉落1硬币"},
	{"430", "狙击蝇老爹", "模仿角色移动, 有1秒延迟#向附近敌人发射泪弹, 造成1x角色伤害"},
	{"431", "多维宝宝", "模仿角色移动, 有2秒延迟#经过它的泪弹会分成2个并有射程+弹速加成"},
	{"432", "闪光炸弹", "{{Bomb}} +5炸弹#角色的炸弹爆炸时, 25%概率生成1随机掉落物, 15%概率魅惑炸到的敌人"},
	{"433", "我的影子", "{{Fear}} 受伤时, 使所有敌人恐惧, 并生成1个友好的黑蛆#黑蛆每秒造成5点接触伤害"},
	{"434", "苍蝇罐", "击杀敌人时, 在罐子里加入1只蓝苍蝇, 最多20只#使用时, 释放所有苍蝇"},
	{"435", "洛基宝宝", "十字发射泪弹#泪弹造成3.5点伤害"},
	{"436", "牛奶！", "{{Tears}} 受伤后, 在当前房间中获得射速提升"},
	{"437", "七面骰", "重新开始房间并重生所有敌人#能够从同一房间获得多次清理房间奖励#若在与贪婪战斗中使用, 则将房间重置为普通商店/隐藏房"},
	{"438", "奶嘴", "↑ {{Tears}} 射速+0.75#{{SoulHeart}} +1魂心#↑ 体型变小"},
	{"439", "妈妈的盒子", "{{Trinket}} 生成1随机饰品#持有时:#↑ {{Luck}} 幸运+1#{{Trinket}} 饰品效果翻倍"},
	{"440", "肾结石", "↑ 泪弹高度+2#↓ {{Speed}} 移速-0.2#↓ {{Range}} 射程-17#角色约每25秒停止发射并蓄力, 释放散射泪弹和1颗肾结石"},
	{"441", "超级喷射", "{{Timer}} 发射超级撒但激光15秒#激光在房间和层之间持续存在"},
	{"442", "黑王子之冠", "红心为1时:#↑ {{Tears}} 射速+0.75#↑ {{Range}} 射程+1.5#↑ 泪弹高度+1#↑ {{Shotspeed}} 弹速+0.2"},
	{"443", "苹果！", "↑ {{Tears}} 射速+0.3#{{Damage}} 6.66%概率发射刀片, 造成4x角色伤害#{{Luck}} 幸运14: 100%概率"},
	{"444", "铅笔", "角色每发射15颗泪弹, 抛射大量泪弹#抛射的泪弹造成2x角色伤害"},
	{"445", "狗牙", "↑ {{Speed}} 移速+0.1#↑ {{Damage}} 伤害+0.3#{{SecretRoom}} 在隐藏房/超级隐藏房相邻房间时会有一声狼嚎#{{LadderRoom}} 进入石头下有暗门的房间时会有一声吠叫"},
	{"446", "烂牙", "{{Poison}} 发射泪弹时, 角色周围会有使敌人中毒的绿环"},
	{"447", "流连豆", "每连续发射7.5秒时, 生成一朵便便云#便便云每秒造成5次1x角色伤害#便便云持续15秒, 可通过射击便便云使其移动"},
	{"448", "玻璃碎片", "受伤时:#{{Heart}} 25%概率生成1红心#{{Collectible214}} 10%概率获得↑ {{Range}} 射程+5, 并在当前房间中留下血迹"},
	{"449", "金属板", "{{SoulHeart}} +1魂心#{{Confusion}} 使敌人的弹幕有25%概率反弹为混乱泪弹"},
	{"450", "贪婪的眼睛", "每发射20颗泪弹, 发射1颗造成2x角色伤害的硬币泪弹#{{Petrify}} 被硬币泪弹击中的敌人石化并变为金块#{{Coin}} 击杀金敌人掉落1-4硬币#{{Warning}} 发射硬币泪弹消耗1硬币"},
	{"451", "塔罗牌桌布", "{{Card}} 生成1卡牌#{{Card}} 使用的卡牌效果翻倍或增强"},
	{"452", "静脉曲张", "受伤时:#围着角色发射10颗高伤害泪弹#{{Damage}} 泪弹造成1x角色伤害+25的伤害#{{Collectible214}} 20%概率获得贫血效果"},
	{"453", "复杂性骨折", "↑ {{Range}} 射程+1.5#↑ 泪弹高度+1#泪弹击中时碎成1-3个小骨片"},
	{"454", "多指畸形", "生成1{{Rune}}符文/{{Card}}卡牌/{{Pill}}胶囊#允许角色携带2卡牌/符文/胶囊"},
	{"455", "爸爸丢失的硬币", "↑ {{Range}} 射程+1.5#↑ 泪弹高度+1#{{Luck}} 生成1幸运硬币"},
	{"456", "夜宵", "↑ {{Heart}} +1心之容器"},
	{"457", "蛋头", "{{SoulHeart}} +1魂心#20%概率阻挡伤害"},
	{"458", "肚脐", "{{Trinket}} 生成1随机饰品#{{Trinket}} 允许角色携带2饰品"},
	{"459", "鼻窦炎", "20%概率发射粘性鼻屎#{{Damage}} 鼻屎每秒造成1x角色伤害, 能粘住60秒"},
	{"460", "青光眼", "{{Confusion}} 5%概率发射混乱泪弹#屏幕会稍暗一些"},
	{"461", "拟寄生物", "15%概率发射虫卵#{{Luck}} 幸运5: 50%概率#{{Slow}} 虫卵击中时, 生成减速水迹和1只蓝蜘蛛/蓝苍蝇"},
	{"462", "彼列之眼", "↑ {{Range}} 射程+1.5#↑ 泪弹高度+1#穿刺泪弹#泪弹击中敌人后, 获得追踪效果并伤害翻倍"},
	{"463", "硫酸", "↑ {{Damage}} 伤害+0.3#25%概率发射能摧毁石头和打开门的泪弹"},
	{"464", "平衡符号", "{{SoulHeart}} +2魂心#精英怪掉落角色最需要的掉落物"},
	{"465", "模拟摇杆", "↑ {{Tears}} 射速+0.35#向任意方向发射泪弹"},
	{"466", "传染病", "{{Poison}} 房间中首个击杀的敌人会产生毒气并使周围敌人中毒#中毒的敌人死亡仍会产生毒气"},
	{"467", "手指！", "{{Damage}} 对手指指向的敌人持续造成0.1x角色伤害"},
	{"468", "阴影", "跟随角色移动, 有1秒延迟#每秒造成30点接触伤害#{{Friendly}} 造成600伤害后被角色吸收, 角色获得接触伤害效果, 并生成友好的黑蛆"},
	{"469", "抑郁症", "留下水迹#水迹每秒造成6点伤害#接触到云的敌人会被圣光击中"},
	{"470", "死寂宝宝", "在房间中四处漂浮#每秒造成30点接触伤害#角色发射时停止移动#停下来时可阻挡弹幕"},
	{"471", "萌死戳宝宝", "{{Chargeable}} 蓄力, 散射泪弹#每颗泪弹造成3.5点伤害"},
	{"472", "国王宝宝", "其他跟班都会跟着他#角色发射时停止移动#停止发射时传送回角色位置"},
	{"473", "大胖蛆", "非常慢地向前冲刺#阻挡弹幕#每秒造成40.5点接触伤害"},
	{"474", "扁桃体", "阻挡弹幕"},
	{"475", "计划C", "对所有敌人造成9,999,999点伤害#{{Warning}} 在3秒后击杀角色"},
	{"476", "一面骰", "复制房间中1随机掉落物"},
	{"477", "虚空", "消耗房间中所有底座道具:#主动道具: 激活其效果, 后续每次使用虚空时也会激活#↑ 被动道具: 提升2项随机属性"},
	{"478", "暂停", "暂停房间中所有敌人, 直到角色发射#角色接触暂停的敌人仍会受伤#30秒后解除暂停"},
	{"479", "熔炉", "{{Trinket}} 消耗角色持有的饰品并永久获得饰品效果#提升饰品的生成率"},
	{"480", "堆肥", "将掉落物变成蓝苍蝇/蓝蜘蛛#使现有的蓝苍蝇/蓝蜘蛛翻倍#若没有则生成1只蓝苍蝇/蓝蜘蛛"},
	{"481", "数据破解", "↑ 随机属性提升#↓ 随机属性降低#{{Timer}} 当前房间中随机泪弹效果#{{Blank}} 损坏当前房间中的所有贴图和音乐"},
	{"482", "遥控器", "将角色换为其他随机角色#移除最近收集到的1个道具"},
	{"483", "妈咪炸弹！", "影响整层#炸碎所有障碍物#对所有敌人造成200点伤害#打开隐藏房的门#无论时间, 打开头目车轮战和死寂的门"},
	{"484", "等等，啥？", "使用时, 推走敌人并生成岩石波#岩石波可以开门或摧毁石头"},
	{"485", "被掰弯的硬币", "50%概率使房间中所有道具, 掉落物和箱子翻倍#50%概率将上述内容移除并生成1硬币"},
	{"486", "钝剃刀片", "使角色受伤但不掉血#触发'受伤时触发'道具的效果"},
	{"487", "土豆削皮刀", "{{EmptyHeart}} 移除1心之容器, 获得:#↑ {{Damage}} 伤害+0.2#{{Collectible73}} 肉块#{{Timer}} 当前房间中获得:#↑ {{Range}} 射程+5#{{Collectible214}} 留下血迹"},
	{"488", "节拍器", "在当前房间中获得1个随机道具的效果"},
	{"489", "无限面骰", "每次使用时触发1次随机骰子的效果"},
	{"490", "伊甸的灵魂", "根据当前房间的道具池生成2个随机道具#起始无充能"},
	{"491", "毒瘾宝宝", "{{Pill}} 每3个房间生成1随机胶囊#{{Poison}} 使用胶囊会使房间中所有敌人中毒"},
	{"492", "嘿，听好！", "↑ {{Luck}} 幸运+1#使{{SecretRoom}}隐藏房, 标记石头和{{LadderRoom}}暗门的地点高亮"},
	{"493", "肾上腺素", "每有1空心之容器:#↑ {{Damage}} 伤害+0.2"},
	{"494", "雅各布天梯", "泪弹击中时会生成1-2个随机方向的电弧#{{Damage}} 电弧造成0.5x角色伤害"},
	{"495", "断魂椒", "概率发射红火, 能阻挡弹幕并造成接触伤害#火焰造成或阻挡5次伤害后消失"},
	{"496", "安乐死", "3.33%概率发射针#{{Luck}} 幸运15: 100%概率#针会立即击杀通常敌人, 并爆出10颗泪弹#{{Damage}} 针击中头目造成3x角色伤害"},
	{"497", "迷彩内裤", "{{Confusion}} 进入房间时, 迷惑所有敌人并使角色伪装, 直到角色开始发射"},
	{"498", "二元性", "{{AngelDevilChance}} {{DevilRoom}}恶魔房和{{AngelRoom}}天使房生成时会同时生成#进入其一, 另一个就会消失"},
	{"499", "圣餐", "{{AngelChance}} 天使房的概率为100%"},
	{"500", "袋中袋", "每5-6个房间生成1福袋"},
	{"501", "贪婪的胃袋", "{{Heart}} 拾起后, 每获得25硬币增加1心之容器"},
	{"502", "大青春痘", "{{Slow}} 发射时, 时不时额外发射一颗白色青春痘, 造成2x角色伤害并使敌人减速#受伤时, 向随机方向发射一颗青春痘"},
	{"503", "小魔角", "5%概率发射能立即击杀非头目敌人的泪弹#{{Luck}} 幸运15: 20%概率#角色造成3.5点接触伤害"},
	{"504", "棕色粪块", "生成1只向敌人发射的苍蝇炮塔#泪弹造成2点伤害"},
	{"505", "宝可GO", "{{Friendly}} 进入有敌人的房间时, 20%概率生成友好的敌人"},
	{"506", "背刺", "{{BleedingOut}} 若泪弹击中敌人后背, 则造成的伤害翻倍并造成流血, 每5秒造成最大血量10%的伤害"},
	{"507", "尖头吸管", "{{Damage}} 对所有敌人造成1x角色伤害+敌人最大血量10%的伤害#{{HalfHeart}} 造成伤害时, 15%概率生成半红心 #{{HalfSoulHeart}} 若角色没有心之容器则改为生成半魂心"},
	{"508", "妈妈的剃刀", "{{BleedingOut}} 能造成流血的环绕物, 流血每5秒造成最大血量10%的伤害#{{Damage}} 每秒造成3x角色伤害#无法阻挡弹幕"},
	{"509", "血丝眼", "每2秒在随机方向上发射泪弹的环绕物#泪弹造成3.5伤害#每秒造成30点接触伤害#不阻挡弹幕"},
	{"510", "精神错乱", "{{Friendly}} 当前房间中生成1个友好的精神错乱版的头目"},
	{"511", "愤怒苍蝇", "在随机敌人周围环绕直到该敌人死亡#每秒对其他敌人造成30点接触伤害"},
	{"512", "黑洞", "可投掷的黑洞, 会吸入所有东西#每秒造成6点接触伤害#摧毁附近的石头#持续6秒"},
	{"513", "派对帽", "↑ {{Damage}} 伤害+0.1#{{SoulHeart}} +1魂心#{{Charm}} 概率魅惑/恐惧敌人#受伤时, 5%概率生成1个彩虹大便"},
	{"514", "损坏的调制解调器", "随机间隔使一些敌人和弹幕短暂停滞#25%概率使清理房间奖励翻倍"},
	{"515", "神秘礼物", "根据当前房间的道具池生成1个随机道具#概率生成{{Collectible132}}煤块/{{Collectible36}}便便"},
	{"516", "洒水器", "生成1个洒水器, 转圈发射泪弹"},
	{"517", "快速炸弹", "{{Bomb}} +7炸弹#移除放置炸弹的冷却"},
	{"518", "伙伴盲盒", "与合作宝宝外观一样的跟班#随机泪弹效果#效果每层都会变化"},
	{"519", "精神错乱宝宝", "每10秒变成随机跟班"},
	{"520", "跨接电缆", "每击杀15个敌人主动道具充能1格"},
	{"521", "代金券", "使{{Shop}}商店/{{DevilRoom}}恶魔房的随机1个物品免费#{{Shop}} 持有时, 进入商店必有1个商店物品打折"},
	{"522", "念力", "使靠近角色的敌人弹幕停滞3秒, 结束后弹幕会被抛开"},
	{"523", "搬家盒", "使用时, 储存当前房间中所有掉落物#再次使用将储存物放回地上#允许角色在房间之间搬东西"},
	{"524", "科技零", "泪弹以电弧连接#{{Damage}} 电弧每秒造成1x角色伤害"},
	{"525", "麻风病", "受伤时, 生成1个阻挡弹幕的环绕物#同时最多有3个环绕物#环绕物受伤过多后被摧毁"},
	{"526", "七印", "生成小天启骑士跟班, 能生成对应的蝗虫#骑士及其蝗虫每10秒更换一次"},
	{"527", "自我先生！", "几秒内显示可移动光标, 随后生成幽灵, 根据光标位置:#打开门或箱子#带回物品# 50%概率在{{Shop}}商店/{{DevilRoom}}恶魔房偷东西#攻击敌人直到目标死亡#炸开墙/石头/天使雕像/店主/机器/乞丐#按下压力板"},
	{"528", "天使棱镜", "棱镜环绕物#友方泪弹击中它会分裂成4个"},
	{"529", "噗！", "角色的泪弹会彼此弹开, 停止移动时消失"},
	{"530", "死神名册", "按顺序击杀标记的敌人可获得奖励"},
	{"531", "泪血症", "↑ {{Damage}} 伤害修正x1.31#↓ {{Tears}} 射速修正x0.5#↓ {{Tears}} 射击延迟+10#角色的泪弹呈抛物线前进, 击中时分裂成更小的泪弹"},
	{"532", "食泪症", "角色的泪弹前进时减速, 停止后会爆裂成8颗小泪弹#泪弹可以合并变大"},
	{"533", "三圣颂", "角色的泪弹由光束弹取代#每秒造成15次0.33x角色伤害"},
	{"534", "书包", "允许角色持有2个主动道具#按掉落键({{ButtonRT}})切换"},
	{"535", "毛毯", "{{HealingRed}} 治疗1红心#{{SoulHeart}} +1魂心#{{HolyMantle}} 进入头目房时产生神圣屏障护盾, 阻挡1次伤害"},
	{"536", "祭坛", "献祭最多2个跟班并生成同样数量的{{DevilRoom}}恶魔房道具#{{Coin}} 将蓝蜘蛛/蓝苍蝇变成硬币"},
	{"537", "呕吐虫宝宝", "{{Pill}} 生成1随机胶囊#发射一条水迹#每次使用胶囊后, 水迹类型改变"},
	{"538", "弹珠袋", "{{Trinket}} 生成3随机饰品#{{Collectible479}} 受伤时, 10%概率消耗角色持有的饰品并永久获得其效果"},
	{"539", "神秘的卵", "{{Friendly}} 受伤时, 生成1个友好的敌人#未受伤清理的房间越多, 生成的帮手更强"},
	{"540", "扁石", "角色的泪弹会在地面弹起#{{Damage}} 每次弹起对附近敌人造成0.25x角色伤害"},
	{"541", "骨髓", "{{Heart}} 生成3红心#{{EmptyBoneHeart}} +1骨心"},
	{"542", "滑肋骨", "环绕物#反弹敌人弹幕"},
	{"543", "圣地大便", "受伤时, 生成白大便#在大便光环中时:#↑ {{Tears}} 射速修正x2#50%概率阻挡伤害"},
	{"544", "尖肋骨", "漂浮在角色前方的骨刺#每秒造成6x角色伤害"},
	{"545", "亡者之书", "{{Friendly}} 当前房间中每击杀1个敌人, 生成1个骨头环绕物/友好的骷髅仔#最多生成8个"},
	{"546", "爸爸的戒指", "{{Petrify}} 获得能使敌人石化的光环"},
	{"547", "离婚协议书", "↑ {{Tears}} 射速+0.7#{{EmptyBoneHeart}} +1骨心#{{Trinket21}} 生成神秘纸片饰品"},
	{"548", "颌骨", "回旋镖状的跟班#造成7点接触伤害#能捡起并带回掉落物"},
	{"549", "脆骨症", "{{EmptyBoneHeart}} 角色所有的心之容器由6空骨心取代#失去骨心时:#↑ {{Tears}} 射速+0.5#向四周方向发射8颗骨头泪弹"},
	{"550", "铲子碎片", "妈腿会持续攻击角色#使用后, 在当前房间中(或头目车轮战1波次)妈腿攻击停止#{{Warning}} (试着带着它通过头目车轮战!)"},
	{"551", "铲子碎片", "破铲子的第二部分#{{Warning}} 在\"暗室\"的土丘上使用铲子"},
	{"552", "妈妈的铲子", "生成通往下一层的活板门#10%概率生成{{LadderRoom}}暗门#{{Warning}} 在\"暗室\"的土丘上使用铲子"},
}

---------- Modifiers ----------

-- Effect of Car battery on Active Items
-- these all need way more consistency with the original effect text and spellchecking
EID.descriptions[languageCode].carBattery = {
	["No Effect"] = "无效果",
	[35] = {40, 80}, -- The Necronomicon
	[37] = {1, 2}, -- Mr. Boom
	[38] = {10, 20}, -- Tammy's Head
	[45] = {1, 2}, -- Yum Heart
	[58] = {10, 20}, -- Book of Shadows
	[65] = {6, 12}, -- Anarchist's Cookbook
	[66] = {8, 16}, -- The Hourglass
	[77] = {6, 12}, -- My Little Unicorn
	[78] = {1, 2}, -- Book of Revelations
	[83] = {1, 2}, -- The Nail
	[85] = {1, 2}, -- Deck of Cards
	[86] = {120, 240}, -- Monstro's Tooth
	[93] = {6.5, 13}, -- The Gamekid
	[97] = {1, 2}, -- The Book of Sin
	[102] = {1, 2}, -- Mom's Bottle of Pills
	[105] = "连续重置两次, 消耗道具池更快", -- The D6
	[107] = "生成两具身体", -- The Pinking Shears
	[111] = {5, 10}, -- The Bean
	[123] = {1, 2}, -- Monster Manual
	[124] = {1, 2}, -- Dead Sea Scrolls
	[136] = {1, 2}, -- Best Friend
	[145] = {"2-4", "4-8"}, -- Guppy's Head
	[146] = {1, 2}, -- Prayer Card (should this just say +1 health...)
	[158] = {1, 2}, -- Crystal Ball
	[160] = {5, 10}, -- Crack the Sky
	[171] = {10, 20}, -- Spider Butt
	[283] = "连续重置两次, 有助于套装进度但消耗道具池更快", -- D100
	[284] = "连续重置两次, 有助于套装进度但消耗道具池更快", -- D4
	[286] = "触发两次", -- Blank Card
	[287] = {"一", "二"}, -- Book of Secrets
	[288] = {"1-4", "2-8"}, -- Box of Spiders
	[292] = {1, 2}, -- Satanic Bible
	[293] = {440, 880}, -- Head of Krampus
	[294] = "提高击退力", -- Butter Bean
	[298] = {6, 12}, -- Unicorn Stump
	[348] = "触发两次", -- Placebo
	[349] = "尝试生成两次", -- Wooden Nickel
	[351] = {5, 10}, -- Mega Bean
	[357] = {"复制", "三重复制"}, -- Box of Friends
	[383] = {6, 36}, -- Tear Detonator
	[421] = {5, 10}, -- Kidney Bean
	[427] = {1, 2}, -- Mine Crafter
	[439] = {1, 2}, -- Mom's Box
	[476] = {1, 2}, -- D1
	[477] = "每个被吸收的主动道具触发两次", -- Void
	[480] = {"翻倍", "翻四倍"}, -- Compost
	[481] = {"一", "两"}, -- Dataminer
	[482] = "改变两次角色并移除两个道具", -- Clicker
	[485] = "25%概率翻四倍, 25%概率翻倍并移除原有物品, 50%概率全部移除并生成1硬币", -- Crooked Penny
	[486] = {"效果", "{{CR}}效果{{BlinkYellowGreen}}两次"}, -- Dull Razor
	[488] = "触发两次, 但只保留第二次的效果", -- Metronome
	[489] = {1, 2}, -- D Infinity
	[504] = {1, 2}, -- Brown Nugget
	[507] = "触发两次", -- Sharp Straw
	[510] = {1, 2}, -- Delirious
	[516] = {1, 2}, -- Sprinkler
	[521] = {1, 2}, -- Coupon
	[523] = "使盒中物品与房间物品交换", -- Moving Box
	[545] = {8, 16}, -- Book of the Dead
	[550] = "使踩踏停止持续两个房间(或头目车轮战波次)", -- Broken Shovel
}

-- Effect of BFFS! on Familiars
EID.descriptions[languageCode].BFFSSynergies = {
	["No Effect"] = "{1}无效果",
	["5.100.8"] = {3.5, 7}, -- Brother Bobby
	["5.100.57"] = {75, 150}, -- Distant Admiration
	["5.100.67"] = {3.5, 7}, -- Sister Maggy
	["5.100.73"] = "伤害翻倍", -- Cube of Meat
	["5.100.88"] = {52.5, 105}, -- Little Chubby
	["5.100.94"] = {"2", "1-2"}, -- Sack of Pennies
	["5.100.95"] = {3.5, 7}, -- Robo-Baby
	["5.100.96"] = {"3", "2-3"}, -- Little C.H.A.D.
	["5.100.98"] = {"5-6", "4-5"}, -- The Relic
	["5.100.99"] = {3.5, 7}, -- Little Gish
	["5.100.100"] = {3.5, 7}, -- Little Steven
	["5.100.107"] = {82.5, 165}, -- The Pinking Shears
	["5.100.112"] = {105, 210}, -- Guardian Angel
	["5.100.113"] = {3, 6}, -- Demon Baby
	["5.100.117"] = {4.3, 8.6}, -- Dead Bird
	["5.100.128"] = {30, 60}, -- Forever Alone
	["5.100.131"] = {"3", "2-3"}, -- Bomb Bag
	["5.100.144"] = {"3-4", "3"}, -- Bum Friend
	["5.100.155"] = {17, 34}, -- The Peeper
	["5.100.163"] = {3.5, 7}, -- Ghost Baby
	["5.100.167"] = {4, 8}, -- Harlequin Baby
	["5.100.170"] = {40, 80}, -- Daddy Longlegs
	["5.100.172"] = {225, 450}, -- Sacrificial Dagger
	["5.100.174"] = {"3-5", "6-10"}, -- Rainbow Baby
	["5.100.187"] = "伤害翻倍", -- Guppy's Hairball
	["5.100.188"] = {3.5, 7, 7.5, 15}, -- Abel (includes Cain's Rep synergy)
	["5.100.206"] = {105, 210}, -- Guillotine
	["5.100.207"] = "伤害翻倍", -- Ball of Bandages
	["5.100.264"] = {22.5, 45}, -- Smart Fly
	["5.100.266"] = "生成1只额外的蓝蜘蛛", -- Juicy Sack
	["5.100.267"] = {3.5, 7}, -- Robo-Baby 2.0
	["5.100.270"] = {3.2, 6.4}, -- Leech
	["5.100.271"] = {"5-6", "4-5"}, -- Mystery Sack
	["5.100.272"] = {60, 85}, -- BBF
	["5.100.273"] = {60, 85}, -- Bob's Brain
	["5.100.274"] = {75, 150}, -- Best Bud
	["5.100.275"] = {31.5, 63}, -- Lil Brimstone
	["5.100.277"] = {4, 8}, -- Lil Haunt
	["5.100.279"] = {30, 60}, -- Big Fan
	["5.100.318"] = {6, 12}, -- Gemini
	["5.100.319"] = {1, 2}, -- Cain's Other Eye
	["5.100.320"] = {37.5, 75}, -- ???'s Only Friend
	["5.100.321"] = {10.7, 21.4}, -- Samson's Chains
	["5.100.322"] = {3.5, 7}, -- Mongo Baby
	["5.100.325"] = {3.5, 7}, -- Scissors
	["5.100.360"] = "伤害翻倍", -- Incubus
	["5.100.361"] = "伤害翻倍", -- Fate's Reward
	["5.100.362"] = {35, 44}, -- Lil Chest
	["5.100.363"] = {105, 210}, -- Sworn Protector
	["5.100.364"] = {45, 90}, -- Friend Zone
	["5.100.365"] = {105, 210}, -- Lost Fly
	["5.100.372"] = "生成电池概率更高", -- Charged Baby
	["5.100.384"] = {"5-90", "10-180"}, -- Lil Gurdy
	["5.100.385"] = "伤害翻倍", -- Bumbo
	["5.100.388"] = "生成箱子更频繁", -- Key Bum
	["5.100.389"] = {"5-6", "4-5"}, -- Rune Bag
	["5.100.390"] = {10, 20}, -- Seraphim
	["5.100.403"] = "生成电池概率更高", -- Spider Mod
	["5.100.405"] = {120, 240}, -- GB Bug
	["5.100.417"] = "伤害光环更大, 但伤害不变", -- Succubus
	["5.100.426"] = {30, 60}, -- Obsessed Fan
	["5.100.430"] = {1, 2}, -- Papa Fly
	["5.100.435"] = {3.5, 7}, -- Lil Loki
	["5.100.468"] = {30, 60}, -- Shade
	["5.100.470"] = {30, 60}, -- Hushy
	["5.100.471"] = {3.5, 7}, -- Lil Monstro
	["5.100.473"] = {40.5, 81}, -- Big Chubby
	["5.100.491"] = {"3", "2-3"}, -- Acid Baby
	["5.100.500"] = {"5-6", "4-5"}, -- Sack of Sacks
	["5.100.508"] = {3, 6}, -- Mom's Razor
	["5.100.509"] = {3.5, 7, 30, 60}, -- Bloodshot Eye
	["5.100.511"] = {30, 60}, -- Angry Fly
	["5.100.518"] = "伤害翻倍", -- Buddy in a Box
	["5.100.519"] = "伤害翻倍", -- Lil Delirium
	["5.100.525"] = {35, 70}, -- Leprosy
	["5.100.526"] = "骑士接触伤害翻倍", -- 7 Seals
	["5.100.537"] = "水迹尺寸增大, 但伤害不变", -- Lil Spewer
	["5.100.539"] = "生成精英敌人", -- Mystery Egg
	["5.100.544"] = {6, 12}, -- Pointy Rib
	["5.100.545"] = "骨头环绕物的接触伤害翻倍", -- Book of the Dead
	["5.100.548"] = {7, 14}, -- Jaw Bone

	["5.350.54"] = {3.5, 7}, --- Isaac's Head
	["5.350.57"] = {3.5, 7}, --- ???'s Soul
	["Lilith"] = "淫魔伤害翻倍", -- Incubus (for BFFS pedestal)
}

---------- Trinkets ----------
EID.descriptions[languageCode].trinkets={
	{"1", "被吞下的硬币", "{{Coin}} 受伤时, 生成1硬币"},
	{"2", "石化大便", "大便50%概率掉落东西"},
	{"3", "7号电池", "{{Battery}} 主动道具充能条-1"},
	{"4", "损坏的遥控器", "{{Collectible44}} 使用主动道具时, 将角色传送至随机房间"},
	{"5", "紫心奖章", "出现精英怪的概率翻倍"},
	{"6", "断掉的磁铁", "{{Coin}} 角色吸引硬币"},
	{"7", "念珠段", "{{AngelChance}} 天使房转换概率+50%#{{Collectible33}} 在{{Shop}}商店和{{Library}}图书馆出现圣经的概率更高"},
	{"8", "游戏卡带", "{{Timer}} 受伤时, 5%概率在6.5秒内获得:#无敌#角色无法发射, 但每秒造成40点接触伤害#{{HalfHeart}} 每击杀2个敌人治疗半红心#{{Fear}} 使房间中的所有敌人恐惧"},
	{"9", "搏动虫", "角色的泪弹搏动#影响泪弹命中区域"},
	{"10", "扭扭虫", "↑ {{Tears}} 射速+0.3#角色的泪弹波形前进"},
	{"11", "环形虫", "角色的泪弹高速螺旋前进"},
	{"12", "扁形虫", "泪弹宽50%#提高击退力"},
	{"13", "商店积分", "{{Shop}} 允许角色免费拿1个商店道具"},
	{"14", "老茧", "不再受到水迹和地刺的伤害"},
	{"15", "幸运石", "{{Coin}} 摧毁石头会生成硬币"},
	{"16", "妈妈的脚趾甲", "每60秒妈腿会践踏房间中的敌人"},
	{"17", "黑色口红", "{{BlackHeart}} 魂心生成为黑心的概率翻倍, 由5%提升至10%"},
	{"18", "圣经小册", "{{EternalHeart}} 永恒之心概率+3%"},
	{"19", "回形针", "{{GoldenChest}} 金箱子可不消耗钥匙打开"},
	{"20", "猴爪", "{{BlackHeart}} 受伤至不多于半心时, 生成1黑心#{{Warning}} 生成3次后消失"},
	{"21", "神秘纸片", "随机获得效果:#{{Collectible327}} 全家福#{{Collectible328}} 底片#{{Trinket48}} 遗失的书页#{{Trinket23}} 寻人启事"},
	{"22", "恶魔的尾巴", "{{Heart}} 心掉落物生成率降至20%#{{BlackHeart}} 所有心掉落物变为黑心#{{Key}} 提升钥匙掉落概率"},
	{"23", "寻人启事", "{{Player10}} 死亡时, 以游魂重生"},
	{"24", "屁股硬币", "{{Coin}} 大便产生硬币的概率+20%#角色拾起硬币时放屁"},
	{"25", "神秘糖果", "角色每30秒放屁或生成大便"},
	{"26", "钩形虫", "↑ {{Range}} 射程+10#泪弹直角前进"},
	{"27", "鞭形虫", "↑ {{Shotspeed}} 弹速+0.5"},
	{"28", "碎安卡十字", "{{Player4}} 死亡时, 22%概率以???(小蓝人)重生"},
	{"29", "鱼头", "受伤时, 生成1只蓝苍蝇"},
	{"30", "角膜炎", "{{Poison}} 10%概率发射有毒泪弹#{{Luck}} 幸运18: 100%概率"},
	{"31", "图钉", "10%概率发射穿刺灵体泪弹#{{Luck}} 幸运18: 100%概率"},
	{"32", "裸盖蘑菇", "每个房间25%概率出现随机蘑菇效果#可能在地图上显示特殊房间"},
	{"33", "脐带", "{{Timer}} 受伤至半心时, 在当前房间中生成{{Collectible100}}史蒂文宝宝"},
	{"34", "小孩的心脏", "{{UnknownHeart}} 10%概率房间清理奖励为1随机心#{{Heart}} 33%概率在箱子, 标记石头, 炸毁的机器中额外出现心"},
	{"35", "弯羊角", "↑ {{Damage}} 伤害+2"},
	{"36", "生锈的钥匙", "{{Key}} 10%概率房间清理奖励为1钥匙#{{Key}} 33%概率在箱子, 标记石头, 炸毁的机器中额外出现钥匙"},
	{"37", "山羊蹄", "↑ {{Speed}} 移速+0.15"},
	{"38", "妈妈的珍珠", "随机心掉落为{{SoulHeart}}魂心, {{BlackHeart}}黑心, {{EmptyBoneHeart}}骨心的概率+10%"}, -- base chance is 10%
	{"39", "癌症", "↑ {{Tears}} 射击延迟-2"},
	{"40", "红补丁", "{{Timer}} 受伤时, 20%概率在当前房间中获得:#↑ {{Damage}} 伤害+1.8#{{Luck}} 幸运8: 100%概率"},
	{"41", "火柴棍", "{{Bomb}} 10%概率房间清理奖励为1炸弹#{{Bomb}} 33%概率在箱子, 标记石头, 炸毁的机器中额外出现炸弹#{{Warning}} 能够移除{{Trinket53}}血虱"},
	{"42", "幸运脚趾", "↑ {{Luck}} 幸运+1#房间清理奖励概率+8%#33%概率在箱子, 标记石头, 炸毁的机器中有额外掉落物"},
	{"43", "诅咒的头骨", "受伤至不多于半心时, 将角色传送至随机房间"},
	{"44", "保险瓶盖", "{{Pill}} 10%概率房间清理奖励为1胶囊#{{Pill}} 33%概率在箱子, 标记石头, 炸毁的机器中额外出现胶囊"},
	{"45", "黑桃A", "{{Card}} 10%概率房间清理奖励为1卡牌#{{Card}} 33%概率在箱子, 标记石头, 炸毁的机器中额外出现卡牌"},
	{"46", "以撒的叉子", "{{HealingRed}} 清理房间后, 10%概率治疗半红心#{{Luck}} 幸运18: 100%概率"},
	{"47", "", "<道具不存在>"},
	{"48", "遗失的书页", "受伤时, 5%概率对房间中所有敌人造成40点伤害"},
	{"49", "染血硬币", "{{HalfHeart}} 拾起硬币时, 50%概率生成1半红心"},
	{"50", "焦灼硬币", "{{Bomb}} 拾起硬币时, 50%概率生成1炸弹"},
	{"51", "扁平硬币", "{{Key}} 拾起硬币时, 50%概率生成1钥匙"},
	{"52", "假币", "{{Coin}} 拾起硬币时, 有50%概率再获得1硬币"},
	{"53", "血虱", "{{HealingRed}} 进入{{BossRoom}}头目房时, 治疗1红心#头目血量-15%#{{Warning}} 拾起后, 无法被其他饰品替换#只能被{{Trinket41}}火柴棍移除或吞下"},
	{"54", "以撒的头", "发射穿刺泪弹的跟班#泪弹造成3.5点伤害"},
	{"55", "抹大拉的信仰", "{{EternalHeart}} 每层一开始获得1永恒之心"},
	{"56", "犹大的舌头", "{{DevilRoom}} 降低恶魔房交易价格为1心之容器#不降低3魂心的价格"},
	{"57", "???的灵魂", "在房间中四处漂浮的跟班#发射方向与角色相同#泪弹造成3.5点伤害"},
	{"58", "参孙的发髻", "{{Timer}} 击杀敌人时, 1/15概率在当前房间中获得:#↑ {{Damage}} 伤害+0.5#{{Luck}} 幸运10: 100%概率"},
	{"59", "该隐的眼睛", "25%概率揭示新一层的地图图标#{{Luck}} 幸运3: 100%概率"},
	{"60", "夏娃的鸟爪", "{{Collectible117}} 击杀敌人时, 5%概率生成死鸟#{{Luck}} 幸运8: 100%概率"},
	{"61", "左断手", "{{RedChest}} 将所有箱子变成红箱子"},
	{"62", "闪亮岩石", "暗门石头和标记石头每10秒闪烁一次"},
	{"63", "安全剪刀", "{{Bomb}} 将即爆炸弹变成炸弹掉落物"},
	{"64", "彩虹虫", "每3秒获得随机蠕虫效果"},
	{"65", "长条虫", "↑ {{Range}} 射程修正x2#↓ 泪弹高度x0.5"},
	{"66", "懒散虫", "↑ {{Range}} 射程+4#↑ 泪弹高度+2#↓ {{Shotspeed}} 弹速-0.4"},
	{"67", "碎裂六面骰", "受伤时, 50%概率触发以下骰子效果之一:#{{Collectible105}} 六面骰#{{Collectible406}} 八面骰#{{Collectible386}} 十二面骰#{{Collectible166}} 二十面骰"},
	{"68", "超级磁铁", "角色吸引掉落物和敌人"},
	{"69", "褪色的全家福", "随机使角色伪装#{{Confusion}} 使敌人迷惑"},
	{"70", "虱子", "在有敌人的房间中, 时不时生成1只蓝蜘蛛"},
	{"71", "鲍勃的膀胱", "角色的炸弹会留下水迹"},
	{"72", "钮扣电池", "{{Battery}} 6.66%概率房间清理奖励为1电池#{{Battery}} 随机掉落物为电池的概率+10%#{{Battery}} 清理房间后, 5%概率为持有的主动道具充能1格"},
	{"73", "雷管", "{{Bomb}} 爆炸的炸弹有10%概率产生炸弹掉落物"},
	{"74", "饰钉定位器", "摧毁石头时, 出现{{LadderRoom}}暗门的概率+0.5%"},
	{"75", "错误", "每个房间获得随机饰品效果"},
	{"76", "筹码", "↑ 箱子有50%概率生成额外掉落物#↓ 箱子有50%概率只有1只红苍蝇"},
	{"77", "水疱", "提高击退力"},
	{"78", "秒针", "状态效果影响敌人两倍久"},
	{"79", "无名无尽", "使用{{Rune}}符文, {{Card}}卡牌, {{Pill}}胶囊时, 25%概率生成其复制"},
	{"80", "黑色羽毛", "↑ {{Damage}} 每持有1个\"邪恶上升\"道具, 伤害+0.2"},
	{"81", "盲目的怒火", "受伤后的无敌变为两倍久"},
	{"82", "黄金马蹄铁", "{{TreasureRoom}} 后续层宝箱房能道具二选一的概率+15%"},
	{"83", "商店钥匙", "{{Shop}} 免费开启商店"},
	{"84", "贪婪的肋骨", "{{Coin}} 房间清理奖励中硬币概率+5%, 心概率-5%#{{Shop}}商店和{{SecretRoom}}隐藏房不再出现贪婪和超级贪婪"},
	{"85", "业报", "{{DonationMachine}} 使用捐款机时, 33%概率:#{{HealingRed}} 治疗1红心(40%)#{{Luck}} 幸运+1(15%)#{{Beggar}} 生成1个乞丐(5%)"},
	{"86", "小幼虫", "摧毁大便时, 生成1只蓝苍蝇"},
	{"87", "妈妈的吊坠", "{{HealingRed}} 使用钥匙时, 治疗半红心#{{Heart}} 将半红心变成整心"},
	{"88", "不！", "阻止主动道具生成"},
	{"89", "儿童栓绳", "跟班离角色更近"},
	{"90", "棕色雷管", "大便摧毁时爆炸, 造成100点伤害"},
	{"91", "胎粪", "33%生成黑大便#{{BlackHeart}} 摧毁黑大便时, 5%概率生成1黑心"},
	{"92", "碎裂的王冠", "↑ {{Tears}} 射击延迟x0.8#↑ 高于{{Speed}}移速1, {{Damage}}伤害3.5, {{Range}}射程23.75, {{Shotspeed}}弹速1的部分修正x1.33"},
	{"93", "用过的尿布", "每房间15%概率使所有苍蝇敌人变得友好"},
	{"94", "鱼尾", "使蓝苍蝇/蓝蜘蛛生成翻倍"},
	{"95", "黑牙", "{{Poison}} 3%概率发射有毒牙齿#牙齿造成2x角色伤害"},
	{"96", "衔尾虫", "↑ {{Range}} 射程+4#↑ 泪弹高度+2#灵体泪弹#概率为追踪泪弹#{{Luck}} 幸运9: 100%概率#角色的泪弹螺旋快速前进"},
	{"97", "扁桃体", "受伤12-20次后, 获得阻挡弹幕的跟班#最多+2个跟班"},
	{"98", "鼻涕泡", "10%概率发射追踪粘性泪弹#{{Damage}} 每秒造成1x角色伤害#能粘住60秒"},
	{"99", "超级弹球", "10%概率发射弹性泪弹"},
	{"100", "亮灯泡", "持有完全充能的主动道具时:#↑ {{Speed}} 移速+0.25#↑ {{Tears}} 射速+0.2#↑ {{Damage}} 伤害+0.5#↑ {{Range}} 射程+0.75#↑ {{Shotspeed}} 弹速+0.1#↑ {{Luck}} 幸运+1"},
	{"101", "暗灯泡", "持有完全未充能的主动道具时:#↑ {{Speed}} 移速+0.5#↑ {{Tears}} 射速+0.4#↑ {{Damage}} 伤害+1.5#↑ {{Range}} 射程+1.5#↑ {{Shotspeed}} 弹速+0.3#↑ {{Luck}} 幸运+2"},
	{"102", "塔罗牌残片", "{{SecretRoom}} 持有时, 每层+1个额外隐藏房"},
	{"103", "等号！", "当角色的{{Coin}}硬币, {{Bomb}}炸弹和{{Key}}钥匙数量相等时:#将掉落物变成成对掉落物"},
	{"104", "许愿骨", "受伤时, 2%概率被摧毁并生成1底座道具"},
	{"105", "午餐袋", "{{Collectible22}} 受伤时, 2%概率被摧毁并生成午餐"},
	{"106", "丢失的瓶塞", "提高角色和跟班产生的水迹范围"},
	{"107", "乌鸦的心", "受伤时, 首先消耗红心, 然后消耗魂心/黑心"},
	{"108", "核桃", "受到1-9次爆炸后, 摧毁饰品并生成1{{UnknownHeart}}随机心, 1{{Coin}}硬币, 1{{Key}}钥匙和1{{Trinket}}随机饰品#不必要受伤"},
	{"109", "胶带", "跟班被粘住, 随角色同步移动"},
	{"110", "银币", "{{Shop}} 商店会出现在子宫层"},
	{"111", "染血王冠", "{{TreasureRoom}} 宝箱房会出现在子宫层"},
	{"112", "充钱游戏", "{{RestockMachine}} {{TreasureRoom}}宝箱房永远生成补货机"},
	{"113", "战争蝗虫", "进入有敌人的房间时, 生成1只爆炸攻击的蝗虫#蝗虫造成2x角色伤害+60点爆炸伤害"},
	{"114", "瘟疫蝗虫", "{{Poison}} 进入有敌人的房间时, 生成1只有毒攻击的蝗虫#蝗虫造成2x角色伤害"},
	{"115", "饥荒蝗虫", "{{Slow}} 进入有敌人的房间时, 生成1只减速攻击的蝗虫#蝗虫造成2x角色伤害"},
	{"116", "死亡蝗虫", "进入有敌人的房间时, 生成1只攻击蝗虫#蝗虫造成4x角色伤害"},
	{"117", "征服蝗虫", "进入有敌人的房间时, 生成1-4只攻击蝗虫#每只蝗虫造成2x角色伤害"},
	{"118", "蝙蝠翅膀", "{{Timer}} 击杀敌人后, 5%概率在当前房间中获得飞行"},
	{"119", "干细胞", "{{HealingRed}} 进入新一层时, 治疗半红心"},
	{"120", "发夹", "头目战开始时将主动道具充能"},
	{"121", "木十字架", "{{Collectible313}} 阻挡每层第一次受到的伤害"},
	{"122", "黄油！", "使用主动道具会使其以底座道具的形式掉在地上#受伤时, 2%概率掉落角色持有的被动道具"},
	{"123", "银丝羽毛", "天使头目掉落正常道具而不是钥匙部件"},
	{"124", "门挡", "最后经过的门保持打开"},
	{"125", "扩接电线", "使跟班以电束相连#电束造成6点伤害"},
	{"126", "腐烂硬币", "拾起硬币时, 生成1只蓝苍蝇"},
	{"127", "儿童弯勺", "跟班的泪弹有追踪效果"},
	{"128", "指骨", "{{EmptyBoneHeart}} 受伤时, 2%概率获得1骨心"},
}

---------- Cards ----------
EID.descriptions[languageCode].cards={
	{"1", "0-愚者", "将角色传送至本层初始房间"},
	{"2", "I-魔术师", "{{Timer}} 当前房间中泪弹有追踪效果"},
	{"3", "II-女祭司", "妈腿会践踏1个敌人#对敌人造成300点接触伤害#若没有敌人则会践踏角色"},
	{"4", "III-皇后", "{{Timer}} 当前房间中获得:#↑ {{Speed}} 移速+0.3#↑ {{Damage}} 伤害+1.5"},
	{"5", "IV-皇帝", "{{BossRoom}} 将角色传送至头目房"},
	{"6", "V-教皇", "{{SoulHeart}} 生成2魂心"},
	{"7", "IV-恋人", "{{Heart}} 生成2红心"},
	{"8", "VII-战车", "{{Timer}} 在6秒内获得:#↑ {{Speed}} 移速+0.28#无敌#角色无法发射泪弹, 但每秒造成40点接触伤害"},
	{"9", "VIII-正义", "生成1{{UnknownHeart}}随机心, 1{{Coin}}硬币, 1{{Bomb}}炸弹, 1{{Key}}钥匙"},
	{"10", "IX-隐者", "{{Shop}} 将角色传送至商店"},
	{"11", "X-命运之轮", "{{Slotmachine}} 生成1台赌博机#{{FortuneTeller}} 25%概率为预言机"},
	{"12", "XI-力量", "{{Timer}} 当前房间中获得:#↑ {{Heart}} +1心之容器#↑ {{Speed}} 移速+0.3#↑ {{Damage}} 伤害+0.3#↑ {{Damage}} 伤害修正x1.5#↑ {{Range}} 射程+5.25#↑ 泪弹高度+0.5"},
	{"13", "XII-倒吊人", "{{Timer}} 当前房间中获得飞行"},
	{"14", "XIII-死亡", "对房间中所有敌人造成40点伤害"},
	{"15", "XIV-节制", "{{DonationMachine}} 生成1台献血机"},
	{"16", "XV-恶魔", "{{Timer}} 当前房间中获得:#↑ {{Damage}} 伤害+2"},
	{"17", "XVI-塔", "生成6个即爆炸弹"},
	{"18", "XVII-星星", "{{TreasureRoom}} 将角色传送至宝箱房"},
	{"19", "XVIII-月亮", "{{SecretRoom}} 将角色传送至隐藏房"},
	{"20", "XIX-太阳", "{{HealingRed}} 回满血#对所有敌人造成100点伤害#{{Timer}} 揭示本层全图并显示房间类型, {{SuperSecretRoom}}超级隐藏房除外"},
	{"21", "XX-审判", "{{Beggar}} 生成1个乞丐#{{DemonBeggar}} 33%概率为恶魔乞丐#2%概率为钥匙大师或炸弹乞丐"},
	{"22", "XXI-世界", "{{Timer}} 揭示本层全图并显示房间类型#无法揭示{{SuperSecretRoom}}超级隐藏房的位置"},
	{"23", "梅花2", "{{Bomb}} 使角色持有的炸弹翻倍"},
	{"24", "方片2", "{{Coin}} 使角色持有的硬币翻倍"},
	{"25", "黑桃2", "{{Key}} 使角色持有的钥匙翻倍"},
	{"26", "红桃2", "{{HealingRed}} 使角色的红心翻倍{{ColorSilver}}(并非心之容器){{CR}}"},
	{"27", "梅花A", "{{Bomb}} 将所有掉落物变成炸弹"},
	{"28", "方片A", "{{Coin}} 将所有掉落物变成硬币"},
	{"29", "黑桃A", "{{Key}} 将所有掉落物变成钥匙"},
	{"30", "红桃A", "{{Heart}} 将所有掉落物变成随机心"},
	{"31", "鬼牌", "{{AngelDevilChance}} 将角色传送至恶魔房/天使房"},
	{"32", "冰雹符文", "摧毁房间中所有石头"},
	{"33", "收获符文", "复制房间中所有掉落物"},
	{"34", "马骑符文", "生成1个前往下一层的活板门#{{LadderRoom}} 8%概率为暗门"},
	{"35", "朝夕符文", "{{SoulHeart}} +1魂心#{{CurseCursed}} 移除本层的所有诅咒"},
	{"36", "诸神符文", "{{Timer}} 本层获得完整的地图效果"},
	{"37", "签筒符文", "重置房间中所有底座道具"},
	{"38", "桦木符文", "召唤3只蓝蜘蛛和3只蓝苍蝇"},
	{"39", "保护符文", "{{Timer}} 角色无敌30秒"},
	{"40", "空白符文", "随机符文效果#使用后, 25%概率再掉落本身"},
	{"41", "黑符文", "对所有敌人造成40点伤害#将房间中所有底座道具变为随机属性提升#将所有掉落物变成蓝苍蝇"},
	{"42", "混沌卡", "使用时, 向角色移动方向投出#立即击杀接触到的任何敌人(精神错乱除外)"},
	{"43", "信用卡", "使{{Shop}}商店/{{DevilRoom}}恶魔房的所有道具和掉落物免费"},
	{"44", "规则卡", "使用时, 显示\"有帮助的\"提示"},
	{"45", "反人类卡", "整个房间中填满大便"},
	{"46", "自杀之王", "立即击杀角色并在地上生成10个掉落物或道具#生成的道具使用当前房间的道具池"},
	{"47", "免费保释卡", "打开当前房间中所有的门"},
	{"48", "？卡", "免费激活1次角色的主动道具"},
	{"49", "骰子碎片", "重置房间中所有底座道具和掉落物"},
	{"50", "紧急联系电话", "2个妈妈的手落下并抓住2个敌人"},
	{"51", "神圣卡", "{{HolyMantle}} 当前房间中获得神圣屏障护盾(阻挡1次伤害)#25%概率生成另1张神圣卡"},
	{"52", "变巨术", "{{Timer}} 当前房间中获得:#↑ {{Damage}} 伤害+7#↑ {{Range}} 射程+30#体型变大#角色可粉碎接触的石头"},
	{"53", "先祖召唤", "{{Card}} 生成3随机卡牌"},
	{"54", "时空漫步", "{{Timer}} 当前房间中获得:#↑ {{Speed}} 移速+0.5#↓ {{Shotspeed}} 弹速-1#{{Slow}} 使敌人减速"},
}

--[[ Card Buffs caused by Tarot Cloth (separate table from Rep due to how different they are)
-- Strings will be appended to the original description (with line breaks replaced with a Tarot Cloth icon)
-- Tables with one entry will completely replace the original description
-- Tables with two or more entries are find-replace pairs (the new text will be colored Shiny Purple) ]]
EID.descriptions[languageCode].tarotClothBuffsAB = {
	[4] = {0.3, 0.6, 1.5, 3}, -- III - The Empress
	[6] = {2, 4}, -- V - The Hierophant
	[7] = {2, 4}, -- VI - The Lovers
	[8] = {6, 12}, -- VII - The Chariot
	[9] = {1, 2, 1, 2, 1, 2, 1, 2}, -- VIII - Justice
	[11] = {1, 2}, -- X - Wheel of Fortune
	[12] = {1, 2, 0.3, 0.6, 0.3, 0.6, 5.25, 10.5}, -- XI - Strength
	[14] = {40, 80}, -- XIII - Death
	[15] = {1, 2}, -- XIV - Temperance (+ Greed version)
	[17] = {6, 12}, -- XVI - The Tower
	[20] = {100, 200}, -- XIX - The Sun
	[21] = {1, 2}, -- XX - Judgement
	[23] = {"翻倍", "翻四倍"}, -- 2 of Clubs
	[24] = {"翻倍", "翻四倍"}, -- 2 of Diamonds
	[25] = {"翻倍", "翻四倍"}, -- 2 of Spades
	[26] = {"翻倍", "翻四倍"}, -- 2 of Hearts
	[33] = {"翻倍", "翻四倍"}, -- Jera
	[35] = {1, 2}, -- Dagaz
	[37] = "重置2次", -- Perthro
	[38] = {3, 6, 3, 6}, -- Berkano
	[39] = {30, 60}, -- Algiz
	[40] = "触发2次符文效果, 并尝试复制本身2次", -- Blank Rune
	[41] = {40, 80}, -- Black Rune
	[46] = {10, 20}, -- Suicide King
	[48] = "使用2次", -- ? Card
	[53] = {3, 6}, -- Ancient Recall
}

---------- Pills ----------

EID.descriptions[languageCode].unidentifiedPill = "未识别的胶囊"

EID.descriptions[languageCode].pills={
	{"0", "剧毒臭屁", "{{Poison}} 角色放屁并使附近敌人中毒"},
	{"1", "过激幻觉", "{{Warning}} 对角色造成1心伤害#不多于1心时, 变为体力回满胶囊"},
	{"2", "钢铁双蛋", "{{SoulHeart}} +2魂心"},
	{"3", "炸弹变钥匙", "交换角色持有的{{Bomb}}炸弹和{{Key}}钥匙的数量"},
	{"4", "爆炸性腹泻", "在角色位置快速生成5个激活的炸弹"},
	{"5", "体力回满", "{{HealingRed}} 回满血"},
	{"6", "体力下降", "↓ {{EmptyHeart}} -1心之容器#不多于1心之容器时, 变为体力上升胶囊"},
	{"7", "体力上升", "↑ {{EmptyHeart}} +1空心之容器"},
	{"8", "我找到枚怪药", "无效果"},
	{"9", "青春期", "无效果#吃3个会获得成人套装:#↑ {{Heart}} +1心之容器"},
	{"10", "漂亮苍蝇", "+1苍蝇环绕物"},
	{"11", "射程下降", "↓ {{Range}} 射程-2"},
	{"12", "射程上升", "↑ {{Range}} 射程+2.5"},
	{"13", "移速下降", "↓ {{Speed}} 移速-0.12"},
	{"14", "移速上升", "↑ {{Speed}} 移速+0.15"},
	{"15", "射速下降", "↓ {{Tears}} 射速-0.28"},
	{"16", "射速上升", "↑ {{Tears}} 射速+0.35"},
	{"17", "运气下降", "↓ {{Luck}} 幸运-1"},
	{"18", "运气上升", "↑ {{Luck}} 幸运+1"},
	{"19", "传送胶囊", "将角色传送至随机房间#{{ErrorRoom}} 小概率传送至{{ErrorRoom}}错误房"},
	{"20", "48小时能量！", "{{Battery}} 将主动道具完全充能#{{Battery}} 生成1-2电池"},
	{"21", "呕血", "{{Warning}} 清空红心但保留1红心#{{Heart}} 生成1-4红心"},
	{"22", "麻痹", "角色不能移动和发射2秒"},
	{"23", "我能永远看清！", "{{SecretRoom}} 打开本层所有隐藏房的入口"},
	{"24", "信息素", "{{Charm}} 魅惑房间中所有敌人"},
	{"25", "失忆症", "{{CurseLost}} 隐藏本层地图"},
	{"26", "柠檬派对", "生成一大滩水迹, 对敌人造成伤害"},
	{"27", "你是巫师吗？", "{{Timer}} 角色进行斜角发射30秒"},
	{"28", "止痛药！", "{{Timer}} 当前房间中受到的伤害均为半心"},
	{"29", "上瘾！", "{{Timer}} 当前房间中受到的伤害均为整心"},
	{"30", "放-松", "2秒内, 角色在身后生成大便"},
	{"31", "？？？", "{{CurseMaze}} 本层施加混乱诅咒的效果"},
	{"32", "变大胶囊", "角色体型变大#不影响命中区域"},
	{"33", "变小胶囊", "角色体型变小#影响命中区域"},
	{"34", "大量滋生！", "房间中每1个大便生成1只蓝蜘蛛"},
	{"35", "大量滋生？", "房间中每有1个敌人生成1只蓝蜘蛛#若房间中没有敌人则生成1-3只蓝蜘蛛"},
	{"36", "大力丸！", "{{Timer}} 在6.5秒内获得:#无敌#角色无法发射, 但每秒造成40点接触伤害#{{HalfHeart}} 每击杀2个敌人治疗半红心#{{Fear}} 使房间中的所有敌人恐惧"},
	{"37", "复古视野", "{{Timer}} 30秒内, 屏幕像素化3次"},
	{"38", "好朋友一辈子！", "生成3只蓝苍蝇"},
	{"39", "泻药", "生成一摊打滑水迹"},
	{"40", "哪里不对…", "{{Slow}} 生成一摊减速水迹"},
	{"41", "好困…", "{{Slow}} 使房间中所有敌人减速"},
	{"42", "好兴奋！！！", "使房间中所有敌人加速"},
	{"43", "咕噜！", "{{Trinket}} 消耗角色的饰品并永久获得其效果"},
	{"44", "呕！", "{{Collectible149}} 发射1颗吐根泪弹"},
	{"45", "感觉像漫步在阳光下！", "{{Timer}} 在6秒内获得:#↑ {{Speed}} 移速+0.28#无敌#角色无法发射(也没有接触伤害)"},
	{"46", "嗝！", "生成上次使用的胶囊"},
}

EID.descriptions[languageCode].CharacterInfo = {
	[0] = {"以撒", ""},
	[1] = {"抹大拉", ""},
	[2] = {"该隐", ""},
	[3] = {"犹大", ""},
	[4] = {"???", "不能拥有红心#{{SoulHeart}} 体力上升改为获得魂心"},
	[5] = {"夏娃", ""},
	[6] = {"参孙", ""},
	[7] = {"阿萨泻勒", "飞行#{{Collectible118}} 泪弹由短程硫磺火取代"},
	[8] = {"拉撒路", "死亡时, 以\"复活的拉撒路\"重生, 具有1心之容器"},
	[9] = {"伊甸", "每局游戏开始时, 具有随机属性和道具"},
	[10] = {"游魂", "飞行#灵体泪弹#没有生命值#{{Warning}} 没有血量#{{DevilRoom}} 每个房间可以免费进行1次恶魔交易"},
	[11] = {"复活的拉撒路", "提升属性, 伤害修正x1.2"},
	[12] = {"黑暗犹大", "{{Damage}} 伤害修正x2#{{Player3}} 通关标记为犹大"},
	[13] = {"莉莉丝", "不能发射泪弹#{{Collectible360}} 通过淫魔射出泪弹"},
	[14] = {"店主", "{{CoinHeart}} 通过拾起硬币来治疗#最多2硬币心容器#心类掉落物变成蓝苍蝇"},
	[15] = {"亚伯伦", ""},
	[16] = {"遗骸", "有一根可以蓄力并投掷的近战骨头#{{BoneHeart}} 可以拥有最多6骨心#{{Player17}} 按{{ButtonRT}}切换到遗骸之魂#{{SoulHeart}} 遗骸之魂可以最多拥有6魂心/黑心, 具有飞行, 灵体泪弹#遗骸之魂以小范围锁链相连"},
	[17] = {"遗骸之魂", "有一根可以蓄力并投掷的近战骨头#{{BoneHeart}} 可以拥有最多6骨心#{{Player17}} 按{{ButtonRT}}切换到遗骸之魂#{{SoulHeart}} 遗骸之魂可以最多拥有6魂心/黑心, 具有飞行, 灵体泪弹#遗骸之魂以小范围锁链相连"},
    }

---------- Sacrifice Room ----------
EID.descriptions[languageCode].sacrificeHeader = "[下一次献祭的结果]"

EID.descriptions[languageCode].sacrifice={
	{"1", "", "{{Coin}} 50%概率是1硬币#{{Bomb}} 当在第1层且在1分钟内击杀头目且未持有炸弹时, 100%概率是1炸弹"},
	{"2", "", "{{Coin}} 50%概率是1硬币#{{Bomb}} 当在第1层且在1分钟内击杀头目且未持有炸弹时, 100%概率是1炸弹"},
	{"3", "", "{{AngelChance}} 67%概率提升天使房概率"},
	{"4", "", "{{Chest}} 50%概率是1随机箱子"},
	{"5", "", "{{Coin}} 33%概率是3硬币#{{AngelChance}} 67%概率提升天使房概率"},
	{"6", "", "{{AngelChance}} 33%概率传送至天使房#{{DevilChance}} 若本层已生成恶魔房则传送至恶魔房#{{Chest}} 67%概率是1随机箱子"},
	{"7", "", "{{AngelRoom}} 33%概率是1个随机天使房道具#{{SoulHeart}} 67%概率是1魂心"},
	{"8", "", "100%概率是7即爆炸弹"},
	{"9", "", "100%概率生成\"乌列\""},
	{"10", "", "{{SoulHeart}} 50%概率是7魂心#{{Coin}} 50%概率是30硬币"},
	{"11", "", "100%概率生成\"加百列\""},
	{"12", "", "50%概率传送至\"暗室\"层"},
}

---------- Dice Room ----------
EID.descriptions[languageCode].diceHeader = "[骰子房效果]"

EID.descriptions[languageCode].dice={
	{"1", "", "重置角色的所有道具为获得时的房间道具池的随机道具"},
	{"2", "", "重置当前房间所有掉落物"},
	{"3", "", "重置整层所有掉落物和饰品#不影响{{AngelDevilChance}}恶魔房/{{AngelRoom}}天使房/{{LadderRoom}}夹层"},
	{"4", "", "重置整层所有底座道具#不影响{{DevilRoom}}恶魔房/{{AngelRoom}}天使房/{{LadderRoom}}夹层"},
	{"5", "", "重置当前层并重新开始"},
	{"6", "", "重置角色的所有道具#重置地上所有掉落物, 饰品和底座道具"},
}

---------- Transformations ----------

-- Using customary name for better understanding
EID.descriptions[languageCode].transformations={
	"",				-- 0 = none
	"嗝屁猫套装",			-- 1
	"蘑菇套装",			-- 2
	"苍蝇套装",			-- 3
	"连体套装",			-- 4
	"嗑药套装",			-- 5
	"妈妈套装",			-- 6
	"便便套装",			-- 7
	"鲍勃套装",			-- 8
	"恶魔套装",			-- 9
	"天使套装",			-- 10
	"乞丐套装",			-- 11
	"书虫套装",			-- 12
	"蜘蛛套装",			-- 13
	"成人套装",			-- 14
	"践踏套装"			-- 15
}


---------- MISC ----------
-- a function that will get applied onto specific descriptions (glitched items, Abyss locusts,...) to pluralize them
-- Each language can do their own algorithm to modify the given text to their needs
EID.descriptions[languageCode].PluralizeFunction = function(text, amount)
	-- TODO: Not Implemented right now...
	return text
end

EID.descriptions[languageCode].VoidText = "若吸收, 则获得:"
-- {1} will become the number text (like "{1} Tears up" -> "+0.5 Tears up")
EID.descriptions[languageCode].VoidNames = {"移速{1}", "射速{1}", "伤害{1}", "射程{1}", "弹速{1}", "幸运{1}"}

EID.descriptions[languageCode].PurityBoosts = {[0] = "↑ {{Damage}} 伤害+4", "↑ {{Tears}} 射击延迟-4", "↑ {{Speed}} 移速+0.5", "↑ {{Range}} 射程+7.5#↑ 泪弹高度+1"}

EID.descriptions[languageCode].CrookedPennyHeads = "正面"
EID.descriptions[languageCode].CrookedPennyTails = "反面"

EID.descriptions[languageCode].LuckModifier = "幸运{2}: {1}%概率"

EID.descriptions[languageCode].CollectionPageInfo = "此道具尚未收录于收集页面!"

EID.descriptions[languageCode].BlackFeatherInformation = "当前持有{{ColorLime}}{1}{{CR}}个道具(伤害+{2})"

EID.descriptions[languageCode].SingleUseInfo = "{{Warning}} 一次性 {{Warning}}"

-- Find/replace pairs for changing "+1 Health" to "+1 Soul Heart" for soul health characters, or nothing at all for The Lost
-- {1} = number of hearts, {2} = plural character
-- These texts are affected by the PluralizeFunction (ab+ file)
-- If having a simple plural character doesn't work for your language, you could just include an extra string pair to catch plural lines
EID.descriptions[languageCode].RedToX = {
	-- These change "+1 Health" to just "+1 Soul Heart" and etc.
	["Red to Soul"] = {"↑ {{Heart}} +{1}心之容器", "{{SoulHeart}} +{1}魂心",
	"↑ {{EmptyHeart}} +{1}空心之容器", "{{SoulHeart}} +{1}魂心",
	"↓ {{EmptyHeart}} {1}心之容器", "↓ {{SoulHeart}} {1}魂心"},

	["Red to Black"] = {"↑ {{Heart}} +{1}心之容器", "{{BlackHeart}} +{1}黑心",
	"↑ {{EmptyHeart}} +{1}空心之容器", "{{BlackHeart}} +{1}黑心",
	"↓ {{EmptyHeart}} {1}心之容器", "↓ {{BlackHeart}} {1}黑心"},

	["Red to Bone"] = {"↑ {{Heart}} +{1}心之容器", "{{BoneHeart}} +{1}骨心",
	"↑ {{EmptyHeart}} +{1}空心之容器", "{{EmptyBoneHeart}} +{1}骨心", "{{HealingRed}}", "{{HealingBone}}",
	"↓ {{EmptyHeart}} {1}心之容器", "↓ {{EmptyBoneHeart}} {1}骨心"}, -- Red HP to Bone Hearts

	["Red to Coin"] = {"↑ {{Heart}} +{1}心之容器", "{{CoinHeart}} +{1}硬币心容器",
	"↑ {{EmptyHeart}} +{1}空心之容器", "{{EmptyCoinHeart}} +{1}空硬币心容器",
	"{{HealingRed}} 治疗{1}红心", "{{HealingCoin}} 治疗{1}硬币", "{{HealingRed}} 治疗半红心", "{{HealingCoin}} 治疗1硬币", "{{HealingRed}}", "{{HealingCoin}}", "↓ {{EmptyHeart}} {1}心之容器", "↓ {{EmptyCoinHeart}} {1}硬币心容器"}, -- Red HP to Coin Hearts

	["Red to None"] = {"↑ {{Heart}} +{1}心之容器", "", "↑ {{EmptyHeart}} +{1}空心之容器", "", "↓ {{EmptyHeart}} {1}心之容器", ""}, -- Red HP to None (The Lost)
}

EID.descriptions[languageCode].MCM = {
	DemoObjectName = "测试道具名",
	DemoObjectTransformation = "测试套装",
	DemoObjectText = "这份文本是中文的#一条又酷又长的描述, 用来模拟EID文本框自动分行功能!#{{Collectible4}} 这也是很酷的一行#{{Heart}} 爱来自这行#{{AngelDevilChance}} 天使还是恶魔, 这是一个问题#\1 {{Damage}} 属性+1, 原地起飞",
}

-- the ItemReminder description will predict the abilities of items with a header like "Item Name Result"
EID.descriptions[languageCode].ItemReminder = {
	ResultHeader = "{1}的结果",
	InventoryEmpty = "(角色没有道具)",
	CategoryNames = {
		Overview = "库存概况",
		Wisps = "所罗门魔典魂火",
		Special = "特殊",
		Actives = "持有的主动道具",
		Pockets = "持有的口袋道具",
		Trinkets = "持有的饰品",
		Passives = "持有的被动道具",
		Character = "角色信息",
	}
}

-- https://wofsauge.github.io/IsaacDocs/rep/enums/RoomType.html
-- Includes Repentance room types for localization convenience
EID.descriptions[languageCode].RoomTypeNames = { "普通房", "商店", "错误房", "宝箱房", "头目房", "小头目房", "隐藏房", "超级隐藏房", "游戏厅", "诅咒房", "挑战房", "图书馆", "献祭房", "恶魔房", "天使房", "夹层", "头目车轮战房", "以撒的卧室", "肮脏的卧室", "宝库", "骰子房", "黑市", "出口房", "星象房", "传送入口房", "传送出口房", "替代章节入口房", "蓝色房间", "究极隐藏房",
-- Not technically room types but still potentially useful to have localized
[666] = "恶魔房/天使房", [1024] = "红色房间", [1025] = "特殊红色房间" }

-- currently used for D1 and Glyph of Balance; contains Rep pickups for ease of localization
EID.descriptions[languageCode].PickupNames = {
	["5.0"] = "无",

	["5.10"] = "{{Heart}} 心",
	["5.10.1"] = "{{Heart}} 红心", ["5.10.2"] = "{{HalfHeart}} 半红心", ["5.10.3"] = "{{SoulHeart}} 魂心", ["5.10.4"] = "{{EternalHeart}} 永恒之心", ["5.10.5"] = "{{Heart}} 双红心", ["5.10.6"] = "{{BlackHeart}} 黑心", ["5.10.7"] = "{{GoldHeart}} 金心", ["5.10.8"] = "{{HalfSoulHeart}} 半魂心", ["5.10.9"] = "{{Heart}} 胆小的红心", ["5.10.10"] = "{{BlendedHeart}} 混合心", ["5.10.11"] = "{{EmptyBoneHeart}} 骨心", ["5.10.12"] = "{{RottenHeart}} 腐心",

	["5.20"] = "{{Coin}} 硬币",
	["5.20.1"] = "{{Crafting8}} 硬币", ["5.20.2"] = "{{Crafting9}} 镍币", ["5.20.3"] = "{{Crafting10}} 铸币", ["5.20.4"] = "{{Crafting8}} 双硬币", ["5.20.5"] = "{{Crafting11}} 幸运硬币", ["5.20.6"] = "{{Crafting9}} 粘性镍币", ["5.20.7"] = "{{Crafting26}} 金硬币",

	["5.30"] = "{{Key}} 钥匙",
	["5.30.1"] = "{{Crafting12}} 钥匙", ["5.30.2"] = "{{Crafting13}} 金钥匙", ["5.30.3"] = "{{Crafting12}} 双钥匙", ["5.30.4"] = "{{Crafting14}} 充能钥匙",

	["5.40"] = "{{Bomb}} 炸弹",
	["5.40.1"] = "{{Crafting15}} 炸弹", ["5.40.2"] = "{{Crafting15}} 双炸弹", ["5.40.3"] = "{{Crafting15}} 即爆炸弹", ["5.40.4"] = "{{Crafting16}} 金炸弹", ["5.40.5"] = "{{Crafting15}} 超级即爆炸弹", ["5.40.7"] = "{{Crafting17}} 巨型炸弹",

	["5.42"] = "{{Crafting29}} 屎块", ["5.42.1"] = "{{Crafting29}} 大屎块",

	["5.90"] = "{{Battery}} 电池",
	["5.90.0"] = "{{Crafting19}} 小电池", --AB+ didn't have subtypes for batteries
	["5.90.1"] = "{{Crafting19}} 小电池", ["5.90.2"] = "{{Crafting18}} 微型电池", ["5.90.3"] = "{{Crafting20}} 超级电池", ["5.90.4"] = "{{Crafting28}} 金电池",

	["5.50"] = "{{Chest}} 箱子", ["5.51"] = "{{BombChest}} 石头箱子", ["5.52"] = "{{SpikedChest}} 刺箱子", ["5.53"] = "{{EternalChest}} 永恒箱子", ["5.54"] = "{{MimicChest}} 拟态箱子", ["5.55"] = "{{OldChest}} 旧箱子", ["5.56"] = "{{WoodenChest}} 木箱子", ["5.57"] = "{{MegaChest}} 大箱子", ["5.58"] = "{{HauntedChest}} 闹鬼箱子", ["5.60"] = "{{GoldenChest}} 金箱子", ["5.360"] = "{{RedChest}} 红箱子",

	["5.69"] = "{{GrabBag}} 福袋", ["5.69.1"] = "{{GrabBag}} 福袋", ["5.69.2"] = "{{BlackSack}} 黑福袋",

	["5.70"] = "{{Pill}} 胶囊",
	["5.300"] = "{{Card}} 卡牌",
	["5.301"] = "{{Rune}} 符文", -- not a real id
	["5.350"] = "{{Trinket}} 饰品",

}

-- Conditional descriptions - DO NOT TRANSLATE THE FIRST PART IN ["BRACKETS"]
-- Strings will be appended to the original description
-- Tables with one entry will completely replace the original description
-- Tables with two or more entries are find-replace pairs (if there's an odd number of entries, the last entry is appended)
-- For collectible/player conditionals, lines will automatically have their bulletpoint, and {1} is replaced with their name
EID.descriptions[languageCode].ConditionalDescs = {
	------ GENERAL STRINGS ------
	["Overridden"] = "被{1}覆盖",
	["Overrides"] = "覆盖{1}",
	["Almost No Effect"] = "对{1}几乎没有影响",
	["No Effect"] = "对{1}没有影响",
	["No Effect Replace"] = {"对{1}没有影响"},
	["No Effect From"] = "{1}对此没有影响",
	["Can't Charge"] = "无法改变{1}",
	["Can't Be Charged"] = "无法被{1}改变",
	["Can't Be Duplicated"] = "无法复制",
	["No Effect (Greed)"] = "{{GreedMode}} 贪婪模式中无效果",
	["No Effect (Copies)"] = "多个重复品无额外效果", -- Having the item already, or having Diplopia while looking at a pedestal
	["No Effect (Familiars)"] = "对跟班没有额外效果", -- probably just for Hive Mind + BFFS!
	["Different Effect"] = "{{ColorSilver}}对{1}有不同效果{{CR}}",
	["Dies on Use"] = "{{Warning}} 使用时{1}死亡", -- for Razor Blade and such as The Lost


	------ GREED MODE ------
	["Room to Wave"] = {"房间", "波次", "房间", "波次"}, -- convert room clear effects to wave clear effects
	["No Champion Drops"] = "!!! 贪婪模式中精英怪没有掉落物!", -- Champion Belt / Purple Heart
	["5.300.15"] = {"{{DemonBeggar}} 生成1个恶魔乞丐"}, -- Temperance (Greed)
	["5.300.19"] = {"将角色传送至本层初始房间"}, -- The Moon (Greed)
	["5.300.20"] = {"{{HealingRed}} 回满血#对所有敌人造成100点伤害"}, -- XIX - The Sun (Greed)
	["5.100.483 (Greed)"] = "{{GreedMode}} 不会每波次触发, 只每房间触发", -- Mama Mega (Greed)
	["5.100.535"] = "{{GreedMode}} 头目波次没有护盾, 只有究极贪婪战斗时有", -- Blanket (Greed)
	["5.350.120"] = "{{GreedMode}} 头目波次没有充能, 只有究极贪婪战斗时有", -- Hairpin (Greed)
	["5.100.246"] = {"{{SuperSecretRoom}} 在地图上揭示超级隐藏房"}, -- Blue Map (Greed)
	["5.100.333"] = {"{{SuperSecretRoom}} 在地图上揭示超级隐藏房"}, -- The Mind (Greed)
	["5.100.514"] = {"随机间隔使一些敌人和弹幕短暂停滞"}, -- Broken Modem (Greed)
	["5.350.34"] = {"{{Heart}} 33%概率在箱子, 标记石头, 炸毁的机器中额外出现心"}, -- Child's Heart
	["5.350.36"] = {"{{Key}} 33%概率在箱子, 标记石头, 炸毁的机器中额外出现钥匙"}, -- Rusted Key
	["5.350.41"] = {"{{Bomb}} 33%概率在箱子, 标记石头, 炸毁的机器中额外出现炸弹#{{Warning}} 能够移除{{Trinket53}}血虱"}, -- Match Stick
	["5.350.44"] = {"{{Pill}} 33%概率在箱子, 标记石头, 炸毁的机器中额外出现胶囊"}, -- Safety Cap
	["5.350.45"] = {"{{Card}} 33%概率在箱子, 标记石头, 炸毁的机器中额外出现卡牌"}, -- Ace of Spades
	["5.350.72"] = {"{{Battery}} 随机掉落物为电池的概率+10%#{{Battery}} 清理波次后, 5%概率为持有的主动道具充能1格"}, -- Watch Battery
	["5.100.297 (Greed)"] = {"根据所在层生成奖励:#地下室: 2{{Bomb}}+2{{Key}}#洞穴: 1{{BossRoom}}道具+2{{SoulHeart}}#深牢: 20{{Coin}}#子宫: 2{{BossRoom}}道具#阴间: 1{{DevilRoom}}道具+1{{BlackHeart}}#商店/究极贪婪: 1{{Coin}}"}, -- Pandora's Box


	------ ACHIEVEMENT CHECKS ------
	["5.350.23"] = "{{Warning}} 持有此饰品在{{SacrificeRoom}}献祭房中死亡时, 解锁游魂", -- Missing Poster (Unlock The Lost)
	["5.100.297"] = {"解锁{{Collectible523}}搬家盒", "无"}, -- Pandora's Box unlocking Moving Box


	------ SPECIFIC CHARACTER SYNERGIES/CHANGES ------
	-- NO RED HEALTH CHARS
	["Super Bandage Soul"] = {"{{SoulHeart}} +3魂心"}, -- for Soul Heart chars
	["Super Bandage Black"] = {"{{SoulHeart}} +2魂心#{{BlackHeart}} +1黑心"}, -- for Black Heart chars
	["Black Lotus Soul"] = {"{{SoulHeart}} +2魂心#{{BlackHeart}} +1黑心"}, -- for Soul Heart chars
	["Black Lotus Black"] = {"{{SoulHeart}} +1魂心#{{BlackHeart}} +2黑心"}, -- for Black Heart chars


	["5.100.135 (PHD)"] = "若持有{1}则生成2-3硬币", -- IV Bag PHD
	["Keeper 0-1"] = "{1}: 生成0-1硬币", -- IV Bag/Piggy Bank Keeper
	["5.100.549"] = "{1}: 只在拾起时↑ {{Tears}} 射速+0.4", -- Brittle Bones (Keeper+Lost)
	["5.100.501"] = "{1}: 获得额外硬币心容器", -- Greed's Gullet
	["5.100.230 (Keeper)"] = "{{Warning}} {1}: 直接死亡", -- Abaddon


	------ DUPLICATE COPIES OF ITEMS ------
	["5.100.2 (Copies)"] = "角色再多发射3颗泪弹#没有额外属性降低", -- The Inner Eye
	["5.100.153 (Copies)"] = "角色再多发射4颗泪弹#没有额外属性降低", -- Mutant Spider
	["5.100.245 (Copies)"] = "角色再多发射2颗泪弹", -- 20/20
	["5.100.358 (Copies)"] = "角色再多发射2颗更靠近中心的泪弹", -- The Wiz
	["5.100.64 (Copies)"] = "再次持有此道具后, 使所有商店道具免费", -- Steam Sale
	["5.100.118 (Copies)"] = "角色额外发射一束激光", -- Brimstone
	["5.100.224 (Copies)"] = "额外重复品仅有移速-0.2的效果", -- Kidney Stone


	----- MISC. ITEM CONDITIONS ------
	["Sacrificial Nugget"] = "棕色粪块苍蝇炮塔算作跟班",
	["Sacrificial Conception"] = "由{1}获得的跟班可被献祭, 随后可继续生成",
	["Sacrificial Angels"] = "献祭{1}生成2黑心",
	["Sacrificial Void"] = "被虚空吸收后能使用多次",

	["5.100.116 (1 Room)"] = "1格充能的主动道具, 需在有敌人的房间中15秒充能", -- 9 Volt
	["5.100.116 (Timed)"] = "时间充能的主动道具使用后半满", -- 9 Volt
	["9 Volt 1 Room"] = "在有敌人的房间中15秒充能", -- Actives + 9 Volt
	["9 Volt Timed"] = "充能在使用后半满", -- Actives + 9 Volt
	["5.100.205 (Wafer)"] = "花费降至半心", -- Sharp Plug + Wafer

	["Suicide 1"] = "{1}无法阻止死亡", -- Plan C, Damocles, Suicide King
	["Suicide 2"] = "死亡无法被{1}阻止", -- Plan C, Damocles, Suicide King

	["5.100.7"] = "{1}效果激活时, 伤害修正x1.5", -- Blood of the Martyr
	["5.100.34"] = "伤害修正x1.5", -- Book of Belial
	["5.300.16"] = "伤害修正x1.5", -- XV - The Devil

	["5.100.81"] = "不能拥有红心的角色设置为1魂心/黑心", -- Dead Cat
	["5.100.316"] = "{1}可移除传送效果", -- Cursed Eye
	["5.100.260"] = "移除{1}的传送效果", -- Black Candle
	["Void Single Use"] = "一次性道具只能激活一次", -- Single Use Actives + Void
	["? Card Single Use"] = "使用?卡后, 一次性道具会消失", -- Single Use Actives + ? Card
	["5.300.48"] = "传送至错误房#空白卡牌和?卡会被摧毁", -- Blank Card + ? Card
	["? + Blank Pedestal"] = "对空白卡牌使用?卡会传送至错误房并摧毁两者", -- Looking at Blank Card with ? Card
	["5.100.208"] = {20, 35, 5, 20}, -- Champion Belt + Hard Mode
	["5.100.521"] = "{{Collectible376}} 免费物品不会补货", -- Coupon + Restock/Greed
	["Black Feather"] = "↑ {{Damage}} 伤害+0.2", -- Black Feather items

	["Bulb Multiple"] = "只检查主要主动道具", -- Vibrant/Dim Bulb + Schoolbag/Pocket Actives
	["Bulb Zero"] = "零充能的主动道具能触发灯泡", -- Vibrant/Dim Bulb + zero charge actives
	["5.350.101 (Timed)"] = "对时间充能的主动道具来说基本没用", -- Dim Bulb + Timed Recharges
	["5.100.122"] = "{1}: 处于1红心时触发", -- Whore of Babylon + Eve

	["5.70.28"] = "改为角色向前方和侧方发射", -- R U A Wizard + The Wiz
	["5.100.523"] = "{1}算作被动道具", -- Moving Box + Void
	["Mongo Babies"] = "可以被{1}复制", -- Mongo Baby + Baby Familiars
	["Technology 2 One Eye"] = "持有{1}时, 角色的泪弹完全由激光取代",
	["Brimstone Proptosis"] = "激光在最近时造成2x额外伤害, 伤害随距离降低",
	["Brimstone Ipecac"] = "吐根泪弹在蓄力时发射#激光伤害+40",
	["Proptosis Anti-Gravity"] = "泪弹移动前不造成伤害",
	["Epic Fetus Soy Milk"] = "瞄准时间不缩短, 但导弹伤害大幅下降",
	["Eye of Belial Dr. Fetus"] = "炸弹穿透, 但不追踪也没有额外伤害",
	["Epic Fetus Brimstone"] = "{1}优先#火箭射出10束激光",
	["Epic Fetus Mom's Knife"] = "{1}优先#火箭射出10把菜刀",
	["Haemolacria Brimstone"] = "{1}优先#泪弹分裂成4-7束激光",
	["Brimstone Mom's Knife"] = "{1}优先#根据蓄力时间发射飞刀",
	["Ludovico Ipecac"] = "泪弹伤害+4, 但不爆炸和中毒",
	["Technology Ipecac"] = "激光伤害+4并使目标中毒",
	["Chocolate Milk Overrides"] = "↑ {{Tears}} 射速修正x1.25",
	["Chocolate Milk Marked"] = "角色自动根据准星距离自动蓄力发射",
	["Ghost Pepper Fart"] = "角色放屁会在身后发射火焰",
	["Damage Multiplier Stack"] = "伤害修正不叠加",
	["White Poop"] = "改为生成白大便",
	["White Poop Chance"] = "概率生成白大便",
	["Golden Poop Chance"] = "概率生成金大便",
	["5.100.483"] = "{{GoldenBomb}} 持有金炸弹时, 可消耗金炸弹使用一次",

	["5.300.5"] = {"{{BossRoom}} 将角色传送至随机头目房"}, -- IV - The Emperor (in The Void)
	["5.300.18"] = "若没有宝箱房, 则将角色传送至随机房间", -- XVII - The Stars (Womb and below)
	["5.300.18 (Greed)"] = {"{{TreasureRoom}} 将角色传送至随机宝箱房"}, -- XVII - The Stars (Greed)
	["5.300.18 (Late Greed)"] = {"将角色传送至本层初始房间"}, -- XVII - The Stars (Greed Last Floors)
	["5.300.10"] = "若没有商店, 则将角色传送至随机房间", -- IX - The Hermit (Womb and below)

}
