"""Node editor built using ImGui
Python bindings for https://github.com/thedmd/imgui-node-editor
"""

# ruff: noqa: B008
from typing import Any, Optional, List, overload
import enum
from imgui_bundle.imgui import ImVec2, ImVec4, ImDrawList, ImVec2Like, ImVec4Like
from imgui_bundle import imgui

ImGuiMouseButton = imgui.MouseButton

EditorContext = Any
NodeEditorContext = Any

class NodeId:
    def __init__(self, id: int = 0):
        pass

    def id(self) -> int:
        pass

    @staticmethod
    def create() -> NodeId:
        """Creates a new NodeId with a unique id

        Create your node once per session, not at each frame!
        """
        pass

class LinkId:
    def __init__(self, id: int = 0):
        pass

    def id(self) -> int:
        pass

    @staticmethod
    def create() -> LinkId:
        """Creates a new LinkId with a unique id

        Create your node once per session, not at each frame!
        """
        pass

class PinId:
    def __init__(self, id: int = 0):
        pass

    def id(self) -> int:
        pass

    @staticmethod
    def create() -> PinId:
        """Creates a new NodeId with a unique id

        Create your node once per session, not at each frame!
        """
        pass

# Suspends canvas by returning to normal ImGui transformation space.
# While suspended UI will not be drawn on canvas plane.
#
# Calls to Suspend()/Resume() are symmetrical. Each call to Suspend()
# must be matched with call to Resume().
def suspend_editor_canvas() -> None:
    pass

def resume_editor_canvas() -> None:
    pass

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:imgui_node_editor.h>    ####################
# ------------------------------------------------------------------------------
# VERSION 0.9.1
#
# LICENSE
#   This software is dual-licensed to the public domain and under the following
#   license: you are granted a perpetual, irrevocable license to copy, modify,
#   publish, and distribute this file as you see fit.
#
# CREDITS
#   Written by Michal Cichon
# ------------------------------------------------------------------------------
# # ifndef __IMGUI_NODE_EDITOR_H__
#

#
# Adaptations for ImGui Bundle are noted with [ADAPT_IMGUI_BUNDLE]
#
# [ADAPT_IMGUI_BUNDLE]
# #ifdef IMGUI_BUNDLE_PYTHON_API
#
# #endif
#

# ------------------------------------------------------------------------------

# ------------------------------------------------------------------------------

# ------------------------------------------------------------------------------

# ------------------------------------------------------------------------------

class PinKind(enum.Enum):
    """------------------------------------------------------------------------------"""

    # Input,    /* original C++ signature */
    input = enum.auto()  # (= 0)
    # Output    /* original C++ signature */
    # }
    output = enum.auto()  # (= 1)

class FlowDirection(enum.Enum):
    # Forward,    /* original C++ signature */
    forward = enum.auto()  # (= 0)
    # Backward    /* original C++ signature */
    # }
    backward = enum.auto()  # (= 1)

class CanvasSizeMode(enum.Enum):
    # FitVerticalView,            /* original C++ signature */
    fit_vertical_view = (
        enum.auto()
    )  # (= 0)  # Previous view will be scaled to fit new view on Y axis
    # FitHorizontalView,          /* original C++ signature */
    fit_horizontal_view = (
        enum.auto()
    )  # (= 1)  # Previous view will be scaled to fit new view on X axis
    # CenterOnly,                 /* original C++ signature */
    center_only = enum.auto()  # (= 2)  # Previous view will be centered on new view

class SaveReasonFlags(enum.Enum):
    """------------------------------------------------------------------------------"""

    # None       = 0x00000000,    /* original C++ signature */
    none = enum.auto()  # (= 0x00000000)
    # Navigation = 0x00000001,    /* original C++ signature */
    navigation = enum.auto()  # (= 0x00000001)
    # Position   = 0x00000002,    /* original C++ signature */
    position = enum.auto()  # (= 0x00000002)
    # Size       = 0x00000004,    /* original C++ signature */
    size = enum.auto()  # (= 0x00000004)
    # Selection  = 0x00000008,    /* original C++ signature */
    selection = enum.auto()  # (= 0x00000008)
    # AddNode    = 0x00000010,    /* original C++ signature */
    add_node = enum.auto()  # (= 0x00000010)
    # RemoveNode = 0x00000020,    /* original C++ signature */
    remove_node = enum.auto()  # (= 0x00000020)
    # User       = 0x00000040    /* original C++ signature */
    # }
    user = enum.auto()  # (= 0x00000040)

class Config:

    # std::string             SettingsFile;    /* original C++ signature */
    settings_file: str
    # void*                   UserPointer;    /* original C++ signature */
    user_pointer: Any
    # CanvasSizeModeAlias     CanvasSizeMode;    /* original C++ signature */
    canvas_size_mode: CanvasSizeMode
    # int                     DragButtonIndex;    /* original C++ signature */
    drag_button_index: (
        int  # Mouse button index drag action will react to (0-left, 1-right, 2-middle)
    )
    # int                     SelectButtonIndex;    /* original C++ signature */
    select_button_index: int  # Mouse button index select action will react to (0-left, 1-right, 2-middle)
    # int                     NavigateButtonIndex;    /* original C++ signature */
    navigate_button_index: int  # Mouse button index navigate action will react to (0-left, 1-right, 2-middle)
    # int                     ContextMenuButtonIndex;    /* original C++ signature */
    context_menu_button_index: int  # Mouse button index context menu action will react to (0-left, 1-right, 2-middle)
    # bool                    EnableSmoothZoom;    /* original C++ signature */
    enable_smooth_zoom: bool
    # float                   SmoothZoomPower;    /* original C++ signature */
    smooth_zoom_power: float

    # bool                    ForceWindowContentWidthToNodeWidth;    /* original C++ signature */
    # [ADAPT_IMGUI_BUNDLE]
    #
    # By default, ImGui::TextWrapped() and ImGui::Separator(), and ImGui::SliderXXX
    # will not work in a Node because they will not respect the node's bounds.
    # Instead, they will use the width of the whole window.
    # Set ForceWindowContentWidthToNodeWidth to True to fix this (this is disabled by default).
    force_window_content_width_to_node_width: bool

    # Config()    /* original C++ signature */
    #         : SettingsFile("NodeEditor.json")
    #         , BeginSaveSession(nullptr)
    #         , EndSaveSession(nullptr)
    #         , SaveSettings(nullptr)
    #         , LoadSettings(nullptr)
    #         , SaveNodeSettings(nullptr)
    #         , LoadNodeSettings(nullptr)
    #         , UserPointer(nullptr)
    #         , CustomZoomLevels()
    #         , CanvasSizeMode(CanvasSizeModeAlias::FitVerticalView)
    #         , DragButtonIndex(0)
    #         , SelectButtonIndex(0)
    #         , NavigateButtonIndex(1)
    #         , ContextMenuButtonIndex(1)
    #         , EnableSmoothZoom(true)
    #                               # ifdef __APPLE__
    #         , SmoothZoomPower(1.1f)
    #                               # else
    #         , SmoothZoomPower(1.3f)
    #                               # endif
    #         , ForceWindowContentWidthToNodeWidth(false)
    #     {
    #     }
    def __init__(self) -> None:
        pass

class StyleColor(enum.Enum):
    """------------------------------------------------------------------------------"""

    # StyleColor_Bg,    /* original C++ signature */
    bg = enum.auto()  # (= 0)
    # StyleColor_Grid,    /* original C++ signature */
    grid = enum.auto()  # (= 1)
    # StyleColor_NodeBg,    /* original C++ signature */
    node_bg = enum.auto()  # (= 2)
    # StyleColor_NodeBorder,    /* original C++ signature */
    node_border = enum.auto()  # (= 3)
    # StyleColor_HovNodeBorder,    /* original C++ signature */
    hov_node_border = enum.auto()  # (= 4)
    # StyleColor_SelNodeBorder,    /* original C++ signature */
    sel_node_border = enum.auto()  # (= 5)
    # StyleColor_NodeSelRect,    /* original C++ signature */
    node_sel_rect = enum.auto()  # (= 6)
    # StyleColor_NodeSelRectBorder,    /* original C++ signature */
    node_sel_rect_border = enum.auto()  # (= 7)
    # StyleColor_HovLinkBorder,    /* original C++ signature */
    hov_link_border = enum.auto()  # (= 8)
    # StyleColor_SelLinkBorder,    /* original C++ signature */
    sel_link_border = enum.auto()  # (= 9)
    # StyleColor_HighlightLinkBorder,    /* original C++ signature */
    highlight_link_border = enum.auto()  # (= 10)
    # StyleColor_LinkSelRect,    /* original C++ signature */
    link_sel_rect = enum.auto()  # (= 11)
    # StyleColor_LinkSelRectBorder,    /* original C++ signature */
    link_sel_rect_border = enum.auto()  # (= 12)
    # StyleColor_PinRect,    /* original C++ signature */
    pin_rect = enum.auto()  # (= 13)
    # StyleColor_PinRectBorder,    /* original C++ signature */
    pin_rect_border = enum.auto()  # (= 14)
    # StyleColor_Flow,    /* original C++ signature */
    flow = enum.auto()  # (= 15)
    # StyleColor_FlowMarker,    /* original C++ signature */
    flow_marker = enum.auto()  # (= 16)
    # StyleColor_GroupBg,    /* original C++ signature */
    group_bg = enum.auto()  # (= 17)
    # StyleColor_GroupBorder,    /* original C++ signature */
    group_border = enum.auto()  # (= 18)

    # StyleColor_Count    /* original C++ signature */
    # }
    count = enum.auto()  # (= 19)

class StyleVar(enum.Enum):
    # StyleVar_NodePadding,    /* original C++ signature */
    node_padding = enum.auto()  # (= 0)
    # StyleVar_NodeRounding,    /* original C++ signature */
    node_rounding = enum.auto()  # (= 1)
    # StyleVar_NodeBorderWidth,    /* original C++ signature */
    node_border_width = enum.auto()  # (= 2)
    # StyleVar_HoveredNodeBorderWidth,    /* original C++ signature */
    hovered_node_border_width = enum.auto()  # (= 3)
    # StyleVar_SelectedNodeBorderWidth,    /* original C++ signature */
    selected_node_border_width = enum.auto()  # (= 4)
    # StyleVar_PinRounding,    /* original C++ signature */
    pin_rounding = enum.auto()  # (= 5)
    # StyleVar_PinBorderWidth,    /* original C++ signature */
    pin_border_width = enum.auto()  # (= 6)
    # StyleVar_LinkStrength,    /* original C++ signature */
    link_strength = enum.auto()  # (= 7)
    # StyleVar_SourceDirection,    /* original C++ signature */
    source_direction = enum.auto()  # (= 8)
    # StyleVar_TargetDirection,    /* original C++ signature */
    target_direction = enum.auto()  # (= 9)
    # StyleVar_ScrollDuration,    /* original C++ signature */
    scroll_duration = enum.auto()  # (= 10)
    # StyleVar_FlowMarkerDistance,    /* original C++ signature */
    flow_marker_distance = enum.auto()  # (= 11)
    # StyleVar_FlowSpeed,    /* original C++ signature */
    flow_speed = enum.auto()  # (= 12)
    # StyleVar_FlowDuration,    /* original C++ signature */
    flow_duration = enum.auto()  # (= 13)
    # StyleVar_PivotAlignment,    /* original C++ signature */
    pivot_alignment = enum.auto()  # (= 14)
    # StyleVar_PivotSize,    /* original C++ signature */
    pivot_size = enum.auto()  # (= 15)
    # StyleVar_PivotScale,    /* original C++ signature */
    pivot_scale = enum.auto()  # (= 16)
    # StyleVar_PinCorners,    /* original C++ signature */
    pin_corners = enum.auto()  # (= 17)
    # StyleVar_PinRadius,    /* original C++ signature */
    pin_radius = enum.auto()  # (= 18)
    # StyleVar_PinArrowSize,    /* original C++ signature */
    pin_arrow_size = enum.auto()  # (= 19)
    # StyleVar_PinArrowWidth,    /* original C++ signature */
    pin_arrow_width = enum.auto()  # (= 20)
    # StyleVar_GroupRounding,    /* original C++ signature */
    group_rounding = enum.auto()  # (= 21)
    # StyleVar_GroupBorderWidth,    /* original C++ signature */
    group_border_width = enum.auto()  # (= 22)
    # StyleVar_HighlightConnectedLinks,    /* original C++ signature */
    highlight_connected_links = enum.auto()  # (= 23)
    # StyleVar_SnapLinkToPinDir,    /* original C++ signature */
    snap_link_to_pin_dir = enum.auto()  # (= 24)
    # StyleVar_HoveredNodeBorderOffset,    /* original C++ signature */
    hovered_node_border_offset = enum.auto()  # (= 25)
    # StyleVar_SelectedNodeBorderOffset,    /* original C++ signature */
    selected_node_border_offset = enum.auto()  # (= 26)

    # StyleVar_Count    /* original C++ signature */
    # }
    count = enum.auto()  # (= 27)

class Style:
    # ImVec4  NodePadding;    /* original C++ signature */
    node_padding: ImVec4
    # float   NodeRounding;    /* original C++ signature */
    node_rounding: float
    # float   NodeBorderWidth;    /* original C++ signature */
    node_border_width: float
    # float   HoveredNodeBorderWidth;    /* original C++ signature */
    hovered_node_border_width: float
    # float   HoverNodeBorderOffset;    /* original C++ signature */
    hover_node_border_offset: float
    # float   SelectedNodeBorderWidth;    /* original C++ signature */
    selected_node_border_width: float
    # float   SelectedNodeBorderOffset;    /* original C++ signature */
    selected_node_border_offset: float
    # float   PinRounding;    /* original C++ signature */
    pin_rounding: float
    # float   PinBorderWidth;    /* original C++ signature */
    pin_border_width: float
    # float   LinkStrength;    /* original C++ signature */
    link_strength: float
    # ImVec2  SourceDirection;    /* original C++ signature */
    source_direction: ImVec2
    # ImVec2  TargetDirection;    /* original C++ signature */
    target_direction: ImVec2
    # float   ScrollDuration;    /* original C++ signature */
    scroll_duration: float
    # float   FlowMarkerDistance;    /* original C++ signature */
    flow_marker_distance: float
    # float   FlowSpeed;    /* original C++ signature */
    flow_speed: float
    # float   FlowDuration;    /* original C++ signature */
    flow_duration: float
    # ImVec2  PivotAlignment;    /* original C++ signature */
    pivot_alignment: ImVec2
    # ImVec2  PivotSize;    /* original C++ signature */
    pivot_size: ImVec2
    # ImVec2  PivotScale;    /* original C++ signature */
    pivot_scale: ImVec2
    # float   PinCorners;    /* original C++ signature */
    pin_corners: float
    # float   PinRadius;    /* original C++ signature */
    pin_radius: float
    # float   PinArrowSize;    /* original C++ signature */
    pin_arrow_size: float
    # float   PinArrowWidth;    /* original C++ signature */
    pin_arrow_width: float
    # float   GroupRounding;    /* original C++ signature */
    group_rounding: float
    # float   GroupBorderWidth;    /* original C++ signature */
    group_border_width: float
    # float   HighlightConnectedLinks;    /* original C++ signature */
    highlight_connected_links: float
    # float   SnapLinkToPinDir;    /* original C++ signature */
    snap_link_to_pin_dir: (
        float  # when True link will start on the line defined by pin direction
    )

    # [ADAPT_IMGUI_BUNDLE]
    #                            #ifdef IMGUI_BUNDLE_PYTHON_API
    #
    # python adapter for Style::Colors[StyleColor_Count]
    # You can query and modify those values (0 <= idxColor < StyleColor.count)
    # inline IMGUI_NODE_EDITOR_API ImVec4& Color_(StyleColor idxColor) { IM_ASSERT( (idxColor >=0) && (idxColor < StyleColor_Count)); return Colors[idxColor]; }    /* original C++ signature */
    def color_(self, idx_color: StyleColor) -> ImVec4:
        pass
    # inline IMGUI_NODE_EDITOR_API void SetColor_(StyleColor idxColor, ImVec4 color) { IM_ASSERT( (idxColor >=0) && (idxColor < StyleColor_Count)); Colors[idxColor] = color; }    /* original C++ signature */
    def set_color_(self, idx_color: StyleColor, color: ImVec4Like) -> None:
        pass
    #                            #endif
    #

    # Style()    /* original C++ signature */
    #     {
    #         NodePadding              = ImVec4(8, 8, 8, 8);
    #         NodeRounding             = 12.0f;
    #         NodeBorderWidth          = 1.5f;
    #         HoveredNodeBorderWidth   = 3.5f;
    #         HoverNodeBorderOffset    = 0.0f;
    #         SelectedNodeBorderWidth  = 3.5f;
    #         SelectedNodeBorderOffset = 0.0f;
    #         PinRounding              = 4.0f;
    #         PinBorderWidth           = 0.0f;
    #         LinkStrength             = 100.0f;
    #         SourceDirection          = ImVec2(1.0f, 0.0f);
    #         TargetDirection          = ImVec2(-1.0f, 0.0f);
    #         ScrollDuration           = 0.35f;
    #         FlowMarkerDistance       = 30.0f;
    #         FlowSpeed                = 150.0f;
    #         FlowDuration             = 2.0f;
    #         PivotAlignment           = ImVec2(0.5f, 0.5f);
    #         PivotSize                = ImVec2(0.0f, 0.0f);
    #         PivotScale               = ImVec2(1, 1);
    #         PinCorners               = ImDrawFlags_RoundCornersAll;
    #         PinRadius                = 0.0f;
    #         PinArrowSize             = 0.0f;
    #         PinArrowWidth            = 0.0f;
    #         GroupRounding            = 6.0f;
    #         GroupBorderWidth         = 1.0f;
    #         HighlightConnectedLinks  = 0.0f;
    #         SnapLinkToPinDir         = 0.0f;
    #
    #         Colors[StyleColor_Bg]                 = ImColor( 60,  60,  70, 200);
    #         Colors[StyleColor_Grid]               = ImColor(120, 120, 120,  40);
    #         Colors[StyleColor_NodeBg]             = ImColor( 32,  32,  32, 200);
    #         Colors[StyleColor_NodeBorder]         = ImColor(255, 255, 255,  96);
    #         Colors[StyleColor_HovNodeBorder]      = ImColor( 50, 176, 255, 255);
    #         Colors[StyleColor_SelNodeBorder]      = ImColor(255, 176,  50, 255);
    #         Colors[StyleColor_NodeSelRect]        = ImColor(  5, 130, 255,  64);
    #         Colors[StyleColor_NodeSelRectBorder]  = ImColor(  5, 130, 255, 128);
    #         Colors[StyleColor_HovLinkBorder]      = ImColor( 50, 176, 255, 255);
    #         Colors[StyleColor_SelLinkBorder]      = ImColor(255, 176,  50, 255);
    #         Colors[StyleColor_HighlightLinkBorder]= ImColor(204, 105,   0, 255);
    #         Colors[StyleColor_LinkSelRect]        = ImColor(  5, 130, 255,  64);
    #         Colors[StyleColor_LinkSelRectBorder]  = ImColor(  5, 130, 255, 128);
    #         Colors[StyleColor_PinRect]            = ImColor( 60, 180, 255, 100);
    #         Colors[StyleColor_PinRectBorder]      = ImColor( 60, 180, 255, 128);
    #         Colors[StyleColor_Flow]               = ImColor(255, 128,  64, 255);
    #         Colors[StyleColor_FlowMarker]         = ImColor(255, 128,  64, 255);
    #         Colors[StyleColor_GroupBg]            = ImColor(  0,   0,   0, 160);
    #         Colors[StyleColor_GroupBorder]        = ImColor(255, 255, 255,  32);
    #     }
    def __init__(self) -> None:
        pass

# ------------------------------------------------------------------------------
# IMGUI_NODE_EDITOR_API void SetCurrentEditor(EditorContext* ctx);    /* original C++ signature */
def set_current_editor(ctx: EditorContext) -> None:
    pass

# IMGUI_NODE_EDITOR_API EditorContext* GetCurrentEditor();    /* original C++ signature */
def get_current_editor() -> EditorContext:
    pass

# IMGUI_NODE_EDITOR_API EditorContext* CreateEditor(const Config* config = nullptr);    /* original C++ signature */
def create_editor(config: Optional[Config] = None) -> EditorContext:
    pass

# IMGUI_NODE_EDITOR_API void DestroyEditor(EditorContext* ctx);    /* original C++ signature */
def destroy_editor(ctx: EditorContext) -> None:
    pass

# IMGUI_NODE_EDITOR_API const Config& GetConfig(EditorContext* ctx = nullptr);    /* original C++ signature */
def get_config(ctx: Optional[EditorContext] = None) -> Config:
    pass

# IMGUI_NODE_EDITOR_API Style& GetStyle();    /* original C++ signature */
def get_style() -> Style:
    pass

# IMGUI_NODE_EDITOR_API const char* GetStyleColorName(StyleColor colorIndex);    /* original C++ signature */
def get_style_color_name(color_index: StyleColor) -> str:
    pass

# IMGUI_NODE_EDITOR_API void PushStyleColor(StyleColor colorIndex, const ImVec4& color);    /* original C++ signature */
def push_style_color(color_index: StyleColor, color: ImVec4Like) -> None:
    pass

# IMGUI_NODE_EDITOR_API void PopStyleColor(int count = 1);    /* original C++ signature */
def pop_style_color(count: int = 1) -> None:
    pass

# IMGUI_NODE_EDITOR_API void PushStyleVar(StyleVar varIndex, float value);    /* original C++ signature */
@overload
def push_style_var(var_index: StyleVar, value: float) -> None:
    pass

# IMGUI_NODE_EDITOR_API void PushStyleVar(StyleVar varIndex, const ImVec2& value);    /* original C++ signature */
@overload
def push_style_var(var_index: StyleVar, value: ImVec2Like) -> None:
    pass

# IMGUI_NODE_EDITOR_API void PushStyleVar(StyleVar varIndex, const ImVec4& value);    /* original C++ signature */
@overload
def push_style_var(var_index: StyleVar, value: ImVec4Like) -> None:
    pass

# IMGUI_NODE_EDITOR_API void PopStyleVar(int count = 1);    /* original C++ signature */
def pop_style_var(count: int = 1) -> None:
    pass

# IMGUI_NODE_EDITOR_API void Begin(const char* id, const ImVec2& size = ImVec2(0, 0));    /* original C++ signature */
def begin(id: str, size: Optional[ImVec2Like] = None) -> None:
    """Python bindings defaults:
    If size is None, then its default value will be: ImVec2(0, 0)
    """
    pass

# IMGUI_NODE_EDITOR_API void End();    /* original C++ signature */
def end() -> None:
    pass

# IMGUI_NODE_EDITOR_API void BeginNode(NodeId id);    /* original C++ signature */
def begin_node(id: NodeId) -> None:
    pass

# IMGUI_NODE_EDITOR_API void BeginPin(PinId id, PinKind kind);    /* original C++ signature */
def begin_pin(id: PinId, kind: PinKind) -> None:
    pass

# IMGUI_NODE_EDITOR_API void PinRect(const ImVec2& a, const ImVec2& b);    /* original C++ signature */
def pin_rect(a: ImVec2Like, b: ImVec2Like) -> None:
    pass

# IMGUI_NODE_EDITOR_API void PinPivotRect(const ImVec2& a, const ImVec2& b);    /* original C++ signature */
def pin_pivot_rect(a: ImVec2Like, b: ImVec2Like) -> None:
    pass

# IMGUI_NODE_EDITOR_API void PinPivotSize(const ImVec2& size);    /* original C++ signature */
def pin_pivot_size(size: ImVec2Like) -> None:
    pass

# IMGUI_NODE_EDITOR_API void PinPivotScale(const ImVec2& scale);    /* original C++ signature */
def pin_pivot_scale(scale: ImVec2Like) -> None:
    pass

# IMGUI_NODE_EDITOR_API void PinPivotAlignment(const ImVec2& alignment);    /* original C++ signature */
def pin_pivot_alignment(alignment: ImVec2Like) -> None:
    pass

# IMGUI_NODE_EDITOR_API void EndPin();    /* original C++ signature */
def end_pin() -> None:
    pass

# IMGUI_NODE_EDITOR_API void Group(const ImVec2& size);    /* original C++ signature */
def group(size: ImVec2Like) -> None:
    pass

# IMGUI_NODE_EDITOR_API void EndNode();    /* original C++ signature */
def end_node() -> None:
    pass

# IMGUI_NODE_EDITOR_API bool BeginGroupHint(NodeId nodeId);    /* original C++ signature */
def begin_group_hint(node_id: NodeId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API ImVec2 GetGroupMin();    /* original C++ signature */
def get_group_min() -> ImVec2:
    pass

# IMGUI_NODE_EDITOR_API ImVec2 GetGroupMax();    /* original C++ signature */
def get_group_max() -> ImVec2:
    pass

# IMGUI_NODE_EDITOR_API ImDrawList* GetHintForegroundDrawList();    /* original C++ signature */
def get_hint_foreground_draw_list() -> ImDrawList:
    pass

# IMGUI_NODE_EDITOR_API ImDrawList* GetHintBackgroundDrawList();    /* original C++ signature */
def get_hint_background_draw_list() -> ImDrawList:
    pass

# IMGUI_NODE_EDITOR_API void EndGroupHint();    /* original C++ signature */
def end_group_hint() -> None:
    pass

# IMGUI_NODE_EDITOR_API ImDrawList* GetNodeBackgroundDrawList(NodeId nodeId);    /* original C++ signature */
def get_node_background_draw_list(node_id: NodeId) -> ImDrawList:
    """TODO: Add a way to manage node background channels"""
    pass

# IMGUI_NODE_EDITOR_API bool Link(LinkId id, PinId startPinId, PinId endPinId, const ImVec4& color = ImVec4(1, 1, 1, 1), float thickness = 1.0f);    /* original C++ signature */
def link(
    id: LinkId,
    start_pin_id: PinId,
    end_pin_id: PinId,
    color: Optional[ImVec4Like] = None,
    thickness: float = 1.0,
) -> bool:
    """Python bindings defaults:
    If color is None, then its default value will be: ImVec4(1, 1, 1, 1)
    """
    pass

# IMGUI_NODE_EDITOR_API void Flow(LinkId linkId, FlowDirection direction = FlowDirection::Forward);    /* original C++ signature */
def flow(link_id: LinkId, direction: FlowDirection = FlowDirection.forward) -> None:
    pass

# IMGUI_NODE_EDITOR_API bool BeginCreate(const ImVec4& color = ImVec4(1, 1, 1, 1), float thickness = 1.0f);    /* original C++ signature */
def begin_create(color: Optional[ImVec4Like] = None, thickness: float = 1.0) -> bool:
    """Python bindings defaults:
    If color is None, then its default value will be: ImVec4(1, 1, 1, 1)
    """
    pass

# IMGUI_NODE_EDITOR_API bool QueryNewLink(PinId* startId, PinId* endId);    /* original C++ signature */
@overload
def query_new_link(start_id: PinId, end_id: PinId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool QueryNewLink(PinId* startId, PinId* endId, const ImVec4& color, float thickness = 1.0f);    /* original C++ signature */
@overload
def query_new_link(
    start_id: PinId, end_id: PinId, color: ImVec4Like, thickness: float = 1.0
) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool QueryNewNode(PinId* pinId);    /* original C++ signature */
@overload
def query_new_node(pin_id: PinId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool QueryNewNode(PinId* pinId, const ImVec4& color, float thickness = 1.0f);    /* original C++ signature */
@overload
def query_new_node(pin_id: PinId, color: ImVec4Like, thickness: float = 1.0) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool AcceptNewItem();    /* original C++ signature */
@overload
def accept_new_item() -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool AcceptNewItem(const ImVec4& color, float thickness = 1.0f);    /* original C++ signature */
@overload
def accept_new_item(color: ImVec4Like, thickness: float = 1.0) -> bool:
    pass

# IMGUI_NODE_EDITOR_API void RejectNewItem();    /* original C++ signature */
@overload
def reject_new_item() -> None:
    pass

# IMGUI_NODE_EDITOR_API void RejectNewItem(const ImVec4& color, float thickness = 1.0f);    /* original C++ signature */
@overload
def reject_new_item(color: ImVec4Like, thickness: float = 1.0) -> None:
    pass

# IMGUI_NODE_EDITOR_API void EndCreate();    /* original C++ signature */
def end_create() -> None:
    pass

# IMGUI_NODE_EDITOR_API bool BeginDelete();    /* original C++ signature */
def begin_delete() -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool QueryDeletedLink(LinkId* linkId, PinId* startId = nullptr, PinId* endId = nullptr);    /* original C++ signature */
def query_deleted_link(
    link_id: LinkId, start_id: Optional[PinId] = None, end_id: Optional[PinId] = None
) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool QueryDeletedNode(NodeId* nodeId);    /* original C++ signature */
def query_deleted_node(node_id: NodeId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool AcceptDeletedItem(bool deleteDependencies = true);    /* original C++ signature */
def accept_deleted_item(delete_dependencies: bool = True) -> bool:
    pass

# IMGUI_NODE_EDITOR_API void RejectDeletedItem();    /* original C++ signature */
def reject_deleted_item() -> None:
    pass

# IMGUI_NODE_EDITOR_API void EndDelete();    /* original C++ signature */
def end_delete() -> None:
    pass

# IMGUI_NODE_EDITOR_API void SetNodePosition(NodeId nodeId, const ImVec2& editorPosition);    /* original C++ signature */
def set_node_position(node_id: NodeId, editor_position: ImVec2Like) -> None:
    pass

# IMGUI_NODE_EDITOR_API void SetGroupSize(NodeId nodeId, const ImVec2& size);    /* original C++ signature */
def set_group_size(node_id: NodeId, size: ImVec2Like) -> None:
    pass

# IMGUI_NODE_EDITOR_API ImVec2 GetNodePosition(NodeId nodeId);    /* original C++ signature */
def get_node_position(node_id: NodeId) -> ImVec2:
    pass

# IMGUI_NODE_EDITOR_API ImVec2 GetNodeSize(NodeId nodeId);    /* original C++ signature */
def get_node_size(node_id: NodeId) -> ImVec2:
    pass

# IMGUI_NODE_EDITOR_API void CenterNodeOnScreen(NodeId nodeId);    /* original C++ signature */
def center_node_on_screen(node_id: NodeId) -> None:
    pass

# IMGUI_NODE_EDITOR_API void SetNodeZPosition(NodeId nodeId, float z);     /* original C++ signature */
def set_node_z_position(node_id: NodeId, z: float) -> None:
    """Sets node z position, nodes with higher value are drawn over nodes with lower value"""
    pass

# IMGUI_NODE_EDITOR_API float GetNodeZPosition(NodeId nodeId);     /* original C++ signature */
def get_node_z_position(node_id: NodeId) -> float:
    """Returns node z position, defaults is 0.0"""
    pass

# IMGUI_NODE_EDITOR_API void RestoreNodeState(NodeId nodeId);    /* original C++ signature */
def restore_node_state(node_id: NodeId) -> None:
    pass

# IMGUI_NODE_EDITOR_API void Suspend();    /* original C++ signature */
def suspend() -> None:
    pass

# IMGUI_NODE_EDITOR_API void Resume();    /* original C++ signature */
def resume() -> None:
    pass

# IMGUI_NODE_EDITOR_API bool IsSuspended();    /* original C++ signature */
def is_suspended() -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool IsActive();    /* original C++ signature */
def is_active() -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool HasSelectionChanged();    /* original C++ signature */
def has_selection_changed() -> bool:
    pass

# IMGUI_NODE_EDITOR_API int  GetSelectedObjectCount();    /* original C++ signature */
def get_selected_object_count() -> int:
    pass

# #ifdef IMGUI_BUNDLE_PYTHON_API
#
# IMGUI_NODE_EDITOR_API std::vector<NodeId> GetSelectedNodes();    /* original C++ signature */
def get_selected_nodes() -> List[NodeId]:
    pass

# IMGUI_NODE_EDITOR_API std::vector<LinkId> GetSelectedLinks();    /* original C++ signature */
def get_selected_links() -> List[LinkId]:
    pass

# #endif
#
# IMGUI_NODE_EDITOR_API bool IsNodeSelected(NodeId nodeId);    /* original C++ signature */
def is_node_selected(node_id: NodeId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool IsLinkSelected(LinkId linkId);    /* original C++ signature */
def is_link_selected(link_id: LinkId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API void ClearSelection();    /* original C++ signature */
def clear_selection() -> None:
    pass

# IMGUI_NODE_EDITOR_API void SelectNode(NodeId nodeId, bool append = false);    /* original C++ signature */
def select_node(node_id: NodeId, append: bool = False) -> None:
    pass

# IMGUI_NODE_EDITOR_API void SelectLink(LinkId linkId, bool append = false);    /* original C++ signature */
def select_link(link_id: LinkId, append: bool = False) -> None:
    pass

# IMGUI_NODE_EDITOR_API void DeselectNode(NodeId nodeId);    /* original C++ signature */
def deselect_node(node_id: NodeId) -> None:
    pass

# IMGUI_NODE_EDITOR_API void DeselectLink(LinkId linkId);    /* original C++ signature */
def deselect_link(link_id: LinkId) -> None:
    pass

# IMGUI_NODE_EDITOR_API bool DeleteNode(NodeId nodeId);    /* original C++ signature */
def delete_node(node_id: NodeId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool DeleteLink(LinkId linkId);    /* original C++ signature */
def delete_link(link_id: LinkId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool HasAnyLinks(NodeId nodeId);     /* original C++ signature */
@overload
def has_any_links(node_id: NodeId) -> bool:
    """Returns True if node has any link connected"""
    pass

# IMGUI_NODE_EDITOR_API bool HasAnyLinks(PinId pinId);     /* original C++ signature */
@overload
def has_any_links(pin_id: PinId) -> bool:
    """Return True if pin has any link connected"""
    pass

# IMGUI_NODE_EDITOR_API int BreakLinks(NodeId nodeId);     /* original C++ signature */
@overload
def break_links(node_id: NodeId) -> int:
    """Break all links connected to this node"""
    pass

# IMGUI_NODE_EDITOR_API int BreakLinks(PinId pinId);     /* original C++ signature */
@overload
def break_links(pin_id: PinId) -> int:
    """Break all links connected to this pin"""
    pass

# IMGUI_NODE_EDITOR_API void NavigateToContent(float duration = -1);    /* original C++ signature */
def navigate_to_content(duration: float = -1) -> None:
    pass

# IMGUI_NODE_EDITOR_API void NavigateToSelection(bool zoomIn = false, float duration = -1);    /* original C++ signature */
def navigate_to_selection(zoom_in: bool = False, duration: float = -1) -> None:
    pass

# Shows context menu for node, link or background
# Typical usage (this should happen inside ed::Begin/ed::End block):
#        ed::Begin();
#        ... (Show nodes)
#        ed::Suspend();
#        if (ed::ShowNodeContextMenu(&contextNodeId))
#            ImGui::OpenPopup("Node Context Menu");
#        ed::Resume();
#        ...
#        ed::Suspend();
#        if (ImGui::BeginPopup("Node Context Menu"))
#        {
#            ImGui::Text("Node Context Menu, node ID: %d", contextNodeId);
#            ImGui::EndPopup();
#        }
#        ed::Resume();
#        ...
#        ed::End();
# IMGUI_NODE_EDITOR_API bool ShowNodeContextMenu(NodeId* nodeId);    /* original C++ signature */
def show_node_context_menu(node_id: NodeId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool ShowPinContextMenu(PinId* pinId);    /* original C++ signature */
def show_pin_context_menu(pin_id: PinId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool ShowLinkContextMenu(LinkId* linkId);    /* original C++ signature */
def show_link_context_menu(link_id: LinkId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool ShowBackgroundContextMenu();    /* original C++ signature */
def show_background_context_menu() -> bool:
    pass

# IMGUI_NODE_EDITOR_API void EnableShortcuts(bool enable);    /* original C++ signature */
def enable_shortcuts(enable: bool) -> None:
    pass

# IMGUI_NODE_EDITOR_API bool AreShortcutsEnabled();    /* original C++ signature */
def are_shortcuts_enabled() -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool BeginShortcut();    /* original C++ signature */
def begin_shortcut() -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool AcceptCut();    /* original C++ signature */
def accept_cut() -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool AcceptCopy();    /* original C++ signature */
def accept_copy() -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool AcceptPaste();    /* original C++ signature */
def accept_paste() -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool AcceptDuplicate();    /* original C++ signature */
def accept_duplicate() -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool AcceptCreateNode();    /* original C++ signature */
def accept_create_node() -> bool:
    pass

# IMGUI_NODE_EDITOR_API int  GetActionContextSize();    /* original C++ signature */
def get_action_context_size() -> int:
    pass

# #ifdef IMGUI_BUNDLE_PYTHON_API
#
# IMGUI_NODE_EDITOR_API std::vector<NodeId> GetActionContextNodes();    /* original C++ signature */
def get_action_context_nodes() -> List[NodeId]:
    pass

# IMGUI_NODE_EDITOR_API std::vector<LinkId> GetActionContextLinks();    /* original C++ signature */
def get_action_context_links() -> List[LinkId]:
    pass

# #endif
#
# IMGUI_NODE_EDITOR_API void EndShortcut();    /* original C++ signature */
def end_shortcut() -> None:
    pass

# IMGUI_NODE_EDITOR_API float GetCurrentZoom();    /* original C++ signature */
def get_current_zoom() -> float:
    pass

# IMGUI_NODE_EDITOR_API NodeId GetHoveredNode();    /* original C++ signature */
def get_hovered_node() -> NodeId:
    pass

# IMGUI_NODE_EDITOR_API PinId GetHoveredPin();    /* original C++ signature */
def get_hovered_pin() -> PinId:
    pass

# IMGUI_NODE_EDITOR_API LinkId GetHoveredLink();    /* original C++ signature */
def get_hovered_link() -> LinkId:
    pass

# IMGUI_NODE_EDITOR_API NodeId GetDoubleClickedNode();    /* original C++ signature */
def get_double_clicked_node() -> NodeId:
    pass

# IMGUI_NODE_EDITOR_API PinId GetDoubleClickedPin();    /* original C++ signature */
def get_double_clicked_pin() -> PinId:
    pass

# IMGUI_NODE_EDITOR_API LinkId GetDoubleClickedLink();    /* original C++ signature */
def get_double_clicked_link() -> LinkId:
    pass

# IMGUI_NODE_EDITOR_API bool IsBackgroundClicked();    /* original C++ signature */
def is_background_clicked() -> bool:
    pass

# IMGUI_NODE_EDITOR_API bool IsBackgroundDoubleClicked();    /* original C++ signature */
def is_background_double_clicked() -> bool:
    pass

# IMGUI_NODE_EDITOR_API ImGuiMouseButton GetBackgroundClickButtonIndex();     /* original C++ signature */
def get_background_click_button_index() -> ImGuiMouseButton:
    """-1 if none"""
    pass

# IMGUI_NODE_EDITOR_API ImGuiMouseButton GetBackgroundDoubleClickButtonIndex();     /* original C++ signature */
def get_background_double_click_button_index() -> ImGuiMouseButton:
    """-1 if none"""
    pass

# IMGUI_NODE_EDITOR_API bool GetLinkPins(LinkId linkId, PinId* startPinId, PinId* endPinId);     /* original C++ signature */
def get_link_pins(link_id: LinkId, start_pin_id: PinId, end_pin_id: PinId) -> bool:
    """pass None if particular pin do not interest you"""
    pass

# IMGUI_NODE_EDITOR_API bool PinHadAnyLinks(PinId pinId);    /* original C++ signature */
def pin_had_any_links(pin_id: PinId) -> bool:
    pass

# IMGUI_NODE_EDITOR_API ImVec2 GetScreenSize();    /* original C++ signature */
def get_screen_size() -> ImVec2:
    pass

# IMGUI_NODE_EDITOR_API ImVec2 ScreenToCanvas(const ImVec2& pos);    /* original C++ signature */
def screen_to_canvas(pos: ImVec2Like) -> ImVec2:
    pass

# IMGUI_NODE_EDITOR_API ImVec2 CanvasToScreen(const ImVec2& pos);    /* original C++ signature */
def canvas_to_screen(pos: ImVec2Like) -> ImVec2:
    pass

# IMGUI_NODE_EDITOR_API int GetNodeCount();                                    /* original C++ signature */
def get_node_count() -> int:
    pass

# Returns number of submitted nodes since Begin() call
# #ifdef IMGUI_BUNDLE_PYTHON_API
#
# IMGUI_NODE_EDITOR_API std::vector<NodeId> GetOrderedNodeIds();    /* original C++ signature */
def get_ordered_node_ids() -> List[NodeId]:
    """Fills an array with node id's in order they're drawn"""
    pass

# #endif
#

# ------------------------------------------------------------------------------

# ------------------------------------------------------------------------------

# namespace ax

# ------------------------------------------------------------------------------
# # endif
####################    </generated_from:imgui_node_editor.h>    ####################

####################    <generated_from:node_editor_default_context.h>    ####################

# IMGUI_NODE_EDITOR_API NodeEditorContext* DefaultNodeEditorContext_Immapp();    /* original C++ signature */
def default_node_editor_context_immapp() -> NodeEditorContext:
    pass

# IMGUI_NODE_EDITOR_API void SuspendNodeEditorCanvas_Immapp();    /* original C++ signature */
def suspend_node_editor_canvas_immapp() -> None:
    pass

# IMGUI_NODE_EDITOR_API void ResumeNodeEditorCanvas_Immapp();    /* original C++ signature */
def resume_node_editor_canvas_immapp() -> None:
    pass

# IMGUI_NODE_EDITOR_API void DisableUserInputThisFrame();    /* original C++ signature */
def disable_user_input_this_frame() -> None:
    pass

# IMGUI_NODE_EDITOR_API void UpdateNodeEditorColorsFromImguiColors();    /* original C++ signature */
def update_node_editor_colors_from_imgui_colors() -> None:
    pass

####################    </generated_from:node_editor_default_context.h>    ####################

# </litgen_stub> // Autogenerated code end!
