"""ImGui Test Engine python bindings

Note: Integrating ImGui TestEngine directly from python, and without using HelloImGui and ImmApp is very difficult:
         ImGui Test Engine uses two different threads (one for the main gui, and one for the scenario runner).
         Your python code will be called from two separate threads, and this breaks the GIL!
         HelloImGui and ImmApp handle this well by transferring the GIL between threads (from C++)
     For gory details, see https://github.com/pthom/imgui_test_engine/blob/imgui_bundle/imgui_test_engine/imgui_te_python_gil.jpg
"""

# ruff: noqa: B008, F821
import sys
from typing import Any, Optional, Tuple, Callable, overload, Union
import numpy as np
import enum
from imgui_bundle.imgui import internal as internal
from imgui_bundle import imgui as imgui
from imgui_bundle.imgui import (
    WindowFlags,
    TableFlags,
    PopupFlags,
    ImVec2,
    ImVec4,
    KeyChord,
    Viewport,
    ImU64,
    ImWchar,
    TableSortSpecs,
    MouseButton,
    Key,
    Dir,
    SortDirection,
    DataType,
)
from imgui_bundle.imgui.internal import (
    ItemStatusFlags,
    DockNode,
    Axis,
    Window,
    ImRect,
    Context,
    ItemFlags,
    LastItemData,
    TextBuffer,
    TabBar,
    InputSource,
)

ID = int
Str = str
Key_None = Key.none
TestInputType_None = TestInputType.none  # noqa
TestRunFlags = int
TestCheckFlags = int
TestFlags = int
TestOpFlags = int
TestLogFlags = int

TestVerboseLevel_Warning = TestVerboseLevel.warning  # noqa
TestVerboseLevel_Info = TestVerboseLevel.info  # noqa
TestOpFlags_None = TestOpFlags_.none  # noqa
TestRunFlags_None = TestRunFlags_.none  # noqa
TestRunSpeed_Fast = TestRunSpeed.fast  # noqa
TestFlags_None = TestFlags_.none  # noqa
Dir_None = Dir_.none  # noqa
TestActiveFunc_None = TestActiveFunc.none  # noqa
TestGroup_Unknown = TestGroup.unknown  # noqa
TestStatus_Unknown = TestStatus.unknown  # noqa
TestStatus_Success = TestStatus.success  # noqa
InputSource_Mouse = InputSource.mouse  # noqa

Function_TestRunner = Callable[[TestContext], None]
Function_TestGui = Callable[[imgui.test_engine.TestContext], None]

Str30 = str
Str256 = str
ImVector_char = list[int]
ImVector_Window_ptr = list[Window]

##################################################
#    AUTO GENERATED CODE BELOW
##################################################
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:imgui_te_exporters.h>    ####################
# dear imgui test engine
# (result exporters)
# Read https://github.com/ocornut/imgui_test_engine/wiki/Exporting-Results

# -------------------------------------------------------------------------
# Description
# -------------------------------------------------------------------------
#
# Test results may be exported in one of supported formats.
# To enable result exporting please configure test engine as follows:
#
#     ImGuiTestEngineIO& test_io = ImGuiTestEngine_GetIO(engine);
#     test_io.ExportResultsFile = "output_file.xml";
#     test_io.ExportResultsFormat = ImGuiTestEngineExportFormat_<...>;
#
# JUnit XML format
# ------------------
# JUnit XML format described at https://llg.cubic.org/docs/junit/. Many
# third party applications support consumption of this format. Some of
# of them are listed here:
# - Jenkins
#    - Installation guide: https://www.jenkins.io/doc/book/installing/docker/
#    - JUnit plugin: https://plugins.jenkins.io/junit/
# - xunit-viewer
#    - Project: https://github.com/lukejpreston/xunit-viewer
#    - Install npm: https://docs.npmjs.com/downloading-and-installing-node-js-and-npm
#    - Install viewer and view test results:
#          npm install xunit-viewer
#          imgui_test_suite -nopause -v2 -ve4 -nogui -export-file junit.xml tests
#          node_modules/xunit-viewer/bin/xunit-viewer -r junit.xml -o junit.html
#    - Open junit.html
#

# -------------------------------------------------------------------------
# Forward Declarations
# -------------------------------------------------------------------------

# -------------------------------------------------------------------------
# Types
# -------------------------------------------------------------------------

class TestEngineExportFormat(enum.Enum):
    # ImGuiTestEngineExportFormat_None = 0,    /* original C++ signature */
    none = enum.auto()  # (= 0)
    # ImGuiTestEngineExportFormat_JUnitXml,    /* original C++ signature */
    # }
    j_unit_xml = enum.auto()  # (= 1)

# -------------------------------------------------------------------------
# Functions
# -------------------------------------------------------------------------

# void ImGuiTestEngine_PrintResultSummary(ImGuiTestEngine* engine);    /* original C++ signature */
def print_result_summary(engine: TestEngine) -> None:
    """(private API)"""
    pass

# void ImGuiTestEngine_Export(ImGuiTestEngine* engine);    /* original C++ signature */
def export(engine: TestEngine) -> None:
    """(private API)"""
    pass

# void ImGuiTestEngine_ExportEx(ImGuiTestEngine* engine, ImGuiTestEngineExportFormat format, const char* filename);    /* original C++ signature */
def export_ex(engine: TestEngine, format: TestEngineExportFormat, filename: str) -> None:
    """(private API)"""
    pass

####################    </generated_from:imgui_te_exporters.h>    ####################

####################    <generated_from:imgui_te_engine.h>    ####################
# dear imgui test engine
# (core)
# This is the interface that your initial setup (app init, main loop) will mostly be using.
# Actual tests will mostly use the interface of imgui_te_context.h

# #ifdef IMGUI_BUNDLE_PYTHON_API
#
# #endif
#

# IMGUI_BUNDLE_PYTHON_UNSUPPORTED_API is always defined (even when building python bindings),
# but is used as a marker to exclude certain functions from the python binding code.

# -----------------------------------------------------------------------------
# Function Pointers
# -----------------------------------------------------------------------------

# -------------------------------------------------------------------------
# Forward Declarations
# -------------------------------------------------------------------------

# -------------------------------------------------------------------------
# Types
# -------------------------------------------------------------------------

class TestActiveFunc(enum.Enum):
    """Stored in ImGuiTestContext: where we are currently running GuiFunc or TestFunc"""

    # ImGuiTestActiveFunc_None,    /* original C++ signature */
    none = enum.auto()  # (= 0)
    # ImGuiTestActiveFunc_GuiFunc,    /* original C++ signature */
    gui_func = enum.auto()  # (= 1)
    # ImGuiTestActiveFunc_TestFunc    /* original C++ signature */
    # }
    test_func = enum.auto()  # (= 2)

class TestRunSpeed(enum.Enum):
    # ImGuiTestRunSpeed_Fast          = 0,        /* original C++ signature */
    fast = enum.auto()  # (= 0)  # Run tests as fast as possible (teleport mouse, skip delays, etc.)
    # ImGuiTestRunSpeed_Normal        = 1,        /* original C++ signature */
    normal = enum.auto()  # (= 1)  # Run tests at human watchable speed (for debugging)
    # ImGuiTestRunSpeed_Cinematic     = 2,        /* original C++ signature */
    cinematic = enum.auto()  # (= 2)  # Run tests with pauses between actions (for e.g. tutorials)
    # ImGuiTestRunSpeed_COUNT    /* original C++ signature */
    # }
    count = enum.auto()  # (= 3)

class TestVerboseLevel(enum.Enum):
    # ImGuiTestVerboseLevel_Silent    = 0,        /* original C++ signature */
    silent = enum.auto()  # (= 0)  # -v0
    # ImGuiTestVerboseLevel_Error     = 1,        /* original C++ signature */
    error = enum.auto()  # (= 1)  # -v1
    # ImGuiTestVerboseLevel_Warning   = 2,        /* original C++ signature */
    warning = enum.auto()  # (= 2)  # -v2
    # ImGuiTestVerboseLevel_Info      = 3,        /* original C++ signature */
    info = enum.auto()  # (= 3)  # -v3
    # ImGuiTestVerboseLevel_Debug     = 4,        /* original C++ signature */
    debug = enum.auto()  # (= 4)  # -v4
    # ImGuiTestVerboseLevel_Trace     = 5,    /* original C++ signature */
    trace = enum.auto()  # (= 5)
    # ImGuiTestVerboseLevel_COUNT    /* original C++ signature */
    # }
    count = enum.auto()  # (= 6)

class TestStatus(enum.Enum):
    """Test status (stored in ImGuiTest)"""

    # ImGuiTestStatus_Unknown     = 0,    /* original C++ signature */
    unknown = enum.auto()  # (= 0)
    # ImGuiTestStatus_Success     = 1,    /* original C++ signature */
    success = enum.auto()  # (= 1)
    # ImGuiTestStatus_Queued      = 2,    /* original C++ signature */
    queued = enum.auto()  # (= 2)
    # ImGuiTestStatus_Running     = 3,    /* original C++ signature */
    running = enum.auto()  # (= 3)
    # ImGuiTestStatus_Error       = 4,    /* original C++ signature */
    error = enum.auto()  # (= 4)
    # ImGuiTestStatus_Suspended   = 5,    /* original C++ signature */
    suspended = enum.auto()  # (= 5)
    # ImGuiTestStatus_COUNT    /* original C++ signature */
    # }
    count = enum.auto()  # (= 6)

class TestGroup(enum.Enum):
    """Test group: this is mostly used to categorize tests in our testing UI. (Stored in ImGuiTest)"""

    # ImGuiTestGroup_Unknown      = -1,    /* original C++ signature */
    unknown = enum.auto()  # (= -1)
    # ImGuiTestGroup_Tests        = 0,    /* original C++ signature */
    tests = enum.auto()  # (= 0)
    # ImGuiTestGroup_Perfs        = 1,    /* original C++ signature */
    perfs = enum.auto()  # (= 1)
    # ImGuiTestGroup_COUNT    /* original C++ signature */
    # }
    count = enum.auto()  # (= 2)

class TestFlags_(enum.Enum):
    """Flags (stored in ImGuiTest)"""

    # ImGuiTestFlags_None                 = 0,    /* original C++ signature */
    none = enum.auto()  # (= 0)
    # ImGuiTestFlags_NoGuiWarmUp          = 1 << 0,       /* original C++ signature */
    no_gui_warm_up = (
        enum.auto()
    )  # (= 1 << 0)  # Disable running the GUI func for 2 frames before starting test code. For tests which absolutely need to start before GuiFunc.
    # ImGuiTestFlags_NoAutoFinish         = 1 << 1,       /* original C++ signature */
    no_auto_finish = (
        enum.auto()
    )  # (= 1 << 1)  # By default, tests with no TestFunc (only a GuiFunc) will end after warmup. Setting this require test to call ctx->Finish().
    # ImGuiTestFlags_NoRecoveryWarnings   = 1 << 2        /* original C++ signature */
    no_recovery_warnings = (
        enum.auto()
    )  # (= 1 << 2)  # Error/recovery warnings (missing End/Pop calls etc.) will be displayed as normal debug entries, for tests which may rely on those.
    # ImGuiTestFlags_RequireViewports   = 1 << 10

class TestCheckFlags_(enum.Enum):
    """Flags for IM_CHECK* macros."""

    # ImGuiTestCheckFlags_None            = 0,    /* original C++ signature */
    none = enum.auto()  # (= 0)
    # ImGuiTestCheckFlags_SilentSuccess   = 1 << 0    /* original C++ signature */
    # }
    silent_success = enum.auto()  # (= 1 << 0)

class TestLogFlags_(enum.Enum):
    """Flags for ImGuiTestContext::Log* functions."""

    # ImGuiTestLogFlags_None              = 0,    /* original C++ signature */
    none = enum.auto()  # (= 0)
    # ImGuiTestLogFlags_NoHeader          = 1 << 0        /* original C++ signature */
    no_header = enum.auto()  # (= 1 << 0)  # Do not display frame count and depth padding

class TestRunFlags_(enum.Enum):
    # ImGuiTestRunFlags_None              = 0,    /* original C++ signature */
    none = enum.auto()  # (= 0)
    # ImGuiTestRunFlags_GuiFuncDisable    = 1 << 0,       /* original C++ signature */
    gui_func_disable = (
        enum.auto()
    )  # (= 1 << 0)  # Used internally to temporarily disable the GUI func (at the end of a test, etc)
    # ImGuiTestRunFlags_GuiFuncOnly       = 1 << 1,       /* original C++ signature */
    gui_func_only = enum.auto()  # (= 1 << 1)  # Set when user selects "Run GUI func"
    # ImGuiTestRunFlags_NoSuccessMsg      = 1 << 2,    /* original C++ signature */
    no_success_msg = enum.auto()  # (= 1 << 2)
    # ImGuiTestRunFlags_EnableRawInputs   = 1 << 3,       /* original C++ signature */
    enable_raw_inputs = (
        enum.auto()
    )  # (= 1 << 3)  # Disable input submission to let test submission raw input event (in order to test e.g. IO queue)
    # ImGuiTestRunFlags_RunFromGui        = 1 << 4,       /* original C++ signature */
    run_from_gui = enum.auto()  # (= 1 << 4)  # Test ran manually from GUI, will disable watchdog.
    # ImGuiTestRunFlags_RunFromCommandLine= 1 << 5,       /* original C++ signature */
    run_from_command_line = enum.auto()  # (= 1 << 5)  # Test queued from command-line.

    # Flags for ImGuiTestContext::RunChildTest()
    # ImGuiTestRunFlags_NoError           = 1 << 10,    /* original C++ signature */
    no_error = enum.auto()  # (= 1 << 10)
    # ImGuiTestRunFlags_ShareVars         = 1 << 11,      /* original C++ signature */
    share_vars = (
        enum.auto()
    )  # (= 1 << 11)  # Share generic vars and custom vars between child and parent tests (custom vars need to be same type)
    # ImGuiTestRunFlags_ShareTestContext  = 1 << 12,      /* original C++ signature */
    share_test_context = (
        enum.auto()
    )  # (= 1 << 12)  # Share ImGuiTestContext instead of creating a new one (unsure what purpose this may be useful for yet)
    # TODO: Add GuiFunc options

# -------------------------------------------------------------------------
# Functions
# -------------------------------------------------------------------------

# extern void         ImGuiTestEngineHook_ItemAdd(ImGuiContext* ui_ctx, ImGuiID id, const ImRect& bb, const ImGuiLastItemData* item_data);    /* original C++ signature */
def hook_item_add(ui_ctx: Context, id_: ID, bb: ImRect, item_data: LastItemData) -> None:
    """Hooks for core imgui/ library (generally called via macros)
    (private API)
    """
    pass

# extern void         ImGuiTestEngineHook_Log(ImGuiContext* ui_ctx, const char* fmt, ...);    /* original C++ signature */
def hook_log(ui_ctx: Context, fmt: str) -> None:
    """(private API)"""
    pass

# extern const char*  ImGuiTestEngine_FindItemDebugLabel(ImGuiContext* ui_ctx, ImGuiID id);    /* original C++ signature */
def find_item_debug_label(ui_ctx: Context, id_: ID) -> str:
    """(private API)"""
    pass

# Functions (generally called via IM_CHECK() macros)
# IMGUI_API bool      ImGuiTestEngine_Check(const char* file, const char* func, int line, ImGuiTestCheckFlags flags, bool result, const char* expr);    /* original C++ signature */
def check(file: str, func: str, line: int, flags: TestCheckFlags, result: bool, expr: str) -> bool:
    pass

# IMGUI_API bool      ImGuiTestEngine_CheckStrOp(const char* file, const char* func, int line, ImGuiTestCheckFlags flags, const char* op, const char* lhs_var, const char* lhs_value, const char* rhs_var, const char* rhs_value, bool* out_result);    /* original C++ signature */
def check_str_op(
    file: str,
    func: str,
    line: int,
    flags: TestCheckFlags,
    op: str,
    lhs_var: str,
    lhs_value: str,
    rhs_var: str,
    rhs_value: str,
    out_result: bool,
) -> Tuple[bool, bool]:
    pass

# IMGUI_API bool      ImGuiTestEngine_Error(const char* file, const char* func, int line, ImGuiTestCheckFlags flags, const char* fmt, ...);    /* original C++ signature */
def error(file: str, func: str, line: int, flags: TestCheckFlags, fmt: str) -> bool:
    pass

# IMGUI_API void      ImGuiTestEngine_AssertLog(const char* expr, const char* file, const char* function, int line);    /* original C++ signature */
def assert_log(expr: str, file: str, function: str, line: int) -> None:
    pass

# IMGUI_API ImGuiTextBuffer* ImGuiTestEngine_GetTempStringBuilder();    /* original C++ signature */
def get_temp_string_builder() -> TextBuffer:
    pass

# -------------------------------------------------------------------------
# ImGuiTestEngine API
# -------------------------------------------------------------------------

# Functions: Initialization

# IMGUI_API ImGuiTestEngine*    ImGuiTestEngine_CreateContext();    /* original C++ signature */
def create_context() -> TestEngine:
    """ImGuiTestEngine_CreateContext: Create test engine
    Note for python bindings users:
        Integrating ImGui TestEngine directly from python, and without using HelloImGui and ImmApp is very difficult:
            ImGui Test Engine uses two different threads (one for the main gui, and one for the scenario runner).
            Your python code will be called from two separate threads, and this breaks the GIL!
            HelloImGui and ImmApp handle this well by transferring the GIL between threads (from C++)
        For gory details, see https://github.com/pthom/imgui_test_engine/blob/imgui_bundle/imgui_test_engine/imgui_te_python_gil.jpg
    """
    pass

# IMGUI_API void                ImGuiTestEngine_DestroyContext(ImGuiTestEngine* engine);                  /* original C++ signature */
def destroy_context(engine: TestEngine) -> None:
    """Destroy test engine. Call after ImGui::DestroyContext() so test engine specific ini data gets saved."""
    pass

# IMGUI_API void                ImGuiTestEngine_Start(ImGuiTestEngine* engine, ImGuiContext* ui_ctx);     /* original C++ signature */
def start(engine: TestEngine, ui_ctx: Context) -> None:
    """Bind to a dear imgui context. Start coroutine."""
    pass

# IMGUI_API void                ImGuiTestEngine_Stop(ImGuiTestEngine* engine);                            /* original C++ signature */
def stop(engine: TestEngine) -> None:
    """Stop coroutine and export if any. (Unbind will lazily happen on context shutdown)"""
    pass

# IMGUI_API void                ImGuiTestEngine_PostSwap(ImGuiTestEngine* engine);                        /* original C++ signature */
def post_swap(engine: TestEngine) -> None:
    """Call every frame after framebuffer swap, will process screen capture and call test_io.ScreenCaptureFunc()"""
    pass

# IMGUI_API ImGuiTestEngineIO&  ImGuiTestEngine_GetIO(ImGuiTestEngine* engine);    /* original C++ signature */
def get_io(engine: TestEngine) -> TestEngineIO:
    pass

# IMGUI_API ImGuiTest*          ImGuiTestEngine_RegisterTest(ImGuiTestEngine* engine, const char* category, const char* name, const char* src_file = NULL, int src_line = 0);     /* original C++ signature */
def register_test(
    engine: TestEngine, category: str, name: str, src_file: Optional[str] = None, src_line: int = 0
) -> Test:
    """Prefer calling IM_REGISTER_TEST()"""
    pass

# IMGUI_API void                ImGuiTestEngine_UnregisterTest(ImGuiTestEngine* engine, ImGuiTest* test);    /* original C++ signature */
def unregister_test(engine: TestEngine, test: Test) -> None:
    pass

# Functions: Main
# IMGUI_API void                ImGuiTestEngine_QueueTest(ImGuiTestEngine* engine, ImGuiTest* test, ImGuiTestRunFlags run_flags = 0);    /* original C++ signature */
def queue_test(engine: TestEngine, test: Test, run_flags: TestRunFlags = 0) -> None:
    pass

# IMGUI_API void                ImGuiTestEngine_QueueTests(ImGuiTestEngine* engine, ImGuiTestGroup group, const char* filter = NULL, ImGuiTestRunFlags run_flags = 0);    /* original C++ signature */
def queue_tests(
    engine: TestEngine, group: TestGroup, filter: Optional[str] = None, run_flags: TestRunFlags = 0
) -> None:
    pass

# IMGUI_API bool                ImGuiTestEngine_TryAbortEngine(ImGuiTestEngine* engine);    /* original C++ signature */
def try_abort_engine(engine: TestEngine) -> bool:
    pass

# IMGUI_API void                ImGuiTestEngine_AbortCurrentTest(ImGuiTestEngine* engine);    /* original C++ signature */
def abort_current_test(engine: TestEngine) -> None:
    pass

# IMGUI_API ImGuiTest*          ImGuiTestEngine_FindTestByName(ImGuiTestEngine* engine, const char* category, const char* name);    /* original C++ signature */
def find_test_by_name(engine: TestEngine, category: str, name: str) -> Test:
    pass

# Functions: Status Queries
# FIXME: Clarify API to avoid function calls vs raw bools in ImGuiTestEngineIO
# IMGUI_API bool                ImGuiTestEngine_IsTestQueueEmpty(ImGuiTestEngine* engine);    /* original C++ signature */
def is_test_queue_empty(engine: TestEngine) -> bool:
    pass

# IMGUI_API bool                ImGuiTestEngine_IsUsingSimulatedInputs(ImGuiTestEngine* engine);    /* original C++ signature */
def is_using_simulated_inputs(engine: TestEngine) -> bool:
    pass

# IMGUI_API void                ImGuiTestEngine_GetResult(ImGuiTestEngine* engine, int& count_tested, int& success_count);    /* original C++ signature */
def get_result(engine: TestEngine, count_tested: int, success_count: int) -> Tuple[int, int]:
    pass

# Functions: Crash Handling
# Ensure past test results are properly exported even if application crash during a test.
# IMGUI_API void                ImGuiTestEngine_InstallDefaultCrashHandler();         /* original C++ signature */
def install_default_crash_handler() -> None:
    """Install default crash handler (if you don't have one)"""
    pass

# IMGUI_API void                ImGuiTestEngine_CrashHandler();                       /* original C++ signature */
def crash_handler() -> None:
    """Default crash handler, should be called from a custom crash handler if such exists"""
    pass

# -----------------------------------------------------------------------------
# IO structure to configure the test engine
# -----------------------------------------------------------------------------

class TestEngineIO:
    # -------------------------------------------------------------------------
    # Functions
    # -------------------------------------------------------------------------

    # Options: Functions
    # void*                                       SrcFileOpenUserData = NULL;    /* original C++ signature */
    src_file_open_user_data: Any = None  # (Optional) User data for SrcFileOpenFunc
    # void*                                       ScreenCaptureUserData = NULL;    /* original C++ signature */
    screen_capture_user_data: Any = None  # (Optional) User data for ScreenCaptureFunc

    # Options: Main
    # bool                        ConfigSavedSettings = true;    /* original C++ signature */
    config_saved_settings: bool = True  # Load/Save settings in main context .ini file.
    # ImGuiTestRunSpeed           ConfigRunSpeed = ImGuiTestRunSpeed_Fast;    /* original C++ signature */
    config_run_speed: TestRunSpeed = TestRunSpeed_Fast  # Run tests in fast/normal/cinematic mode
    # bool                        ConfigStopOnError = false;    /* original C++ signature */
    config_stop_on_error: bool = False  # Stop queued tests on test error
    # bool                        ConfigBreakOnError = false;    /* original C++ signature */
    config_break_on_error: bool = False  # Break debugger on test error by calling IM_DEBUG_BREAK()
    # bool                        ConfigKeepGuiFunc = false;    /* original C++ signature */
    config_keep_gui_func: bool = False  # Keep test GUI running at the end of the test
    # ImGuiTestVerboseLevel       ConfigVerboseLevel = ImGuiTestVerboseLevel_Warning;    /* original C++ signature */
    config_verbose_level: TestVerboseLevel = TestVerboseLevel_Warning
    # ImGuiTestVerboseLevel       ConfigVerboseLevelOnError = ImGuiTestVerboseLevel_Info;    /* original C++ signature */
    config_verbose_level_on_error: TestVerboseLevel = TestVerboseLevel_Info
    # bool                        ConfigLogToTTY = false;    /* original C++ signature */
    config_log_to_tty: bool = False
    # bool                        ConfigLogToDebugger = false;    /* original C++ signature */
    config_log_to_debugger: bool = False
    # bool                        ConfigRestoreFocusAfterTests = true;    /* original C++ signature */
    config_restore_focus_after_tests: bool = True  # Restore focus back after running tests
    # bool                        ConfigCaptureEnabled = true;    /* original C++ signature */
    config_capture_enabled: bool = (
        True  # Master enable flags for capturing and saving captures. Disable to avoid e.g. lengthy saving of large PNG files.
    )
    # bool                        ConfigCaptureOnError = false;    /* original C++ signature */
    config_capture_on_error: bool = False
    # bool                        ConfigNoThrottle = false;    /* original C++ signature */
    config_no_throttle: bool = False  # Disable vsync for performance measurement or fast test running
    # bool                        ConfigMouseDrawCursor = true;    /* original C++ signature */
    config_mouse_draw_cursor: bool = True  # Enable drawing of Dear ImGui software mouse cursor when running tests
    # float                       ConfigFixedDeltaTime = 0.0f;    /* original C++ signature */
    config_fixed_delta_time: float = 0.0  # Use fixed delta time instead of calculating it from wall clock
    # int                         PerfStressAmount = 1;    /* original C++ signature */
    perf_stress_amount: int = 1  # Integer to scale the amount of items submitted in test

    # Options: Speed of user simulation
    # float                       MouseSpeed = 600.0f;    /* original C++ signature */
    mouse_speed: float = 600.0  # Mouse speed (pixel/second) when not running in fast mode
    # float                       MouseWobble = 0.25f;    /* original C++ signature */
    mouse_wobble: float = (
        0.25  # (0.0..1.0) How much wobble to apply to the mouse (pixels per pixel of move distance) when not running in fast mode
    )
    # float                       ScrollSpeed = 1400.0f;    /* original C++ signature */
    scroll_speed: float = 1400.0  # Scroll speed (pixel/second) when not running in fast mode
    # float                       TypingSpeed = 20.0f;    /* original C++ signature */
    typing_speed: float = 20.0  # Char input speed (characters/second) when not running in fast mode
    # float                       ActionDelayShort = 0.15f;    /* original C++ signature */
    action_delay_short: float = 0.15  # Time between short actions
    # float                       ActionDelayStandard = 0.40f;    /* original C++ signature */
    action_delay_standard: float = 0.40  # Time between most actions

    # Options: Screen/video capture

    # Options: Watchdog. Set values to FLT_MAX to disable.
    # Interactive GUI applications that may be slower tend to use higher values.
    # float                       ConfigWatchdogWarning = 30.0f;    /* original C++ signature */
    config_watchdog_warning: float = 30.0  # Warn when a test exceed this time (in second)
    # float                       ConfigWatchdogKillTest = 60.0f;    /* original C++ signature */
    config_watchdog_kill_test: float = 60.0  # Attempt to stop running a test when exceeding this time (in second)
    # float                       ConfigWatchdogKillApp = FLT_MAX;    /* original C++ signature */
    config_watchdog_kill_app: float = sys.float_info.max
    # Stop application when exceeding this time (in second)

    # Options: Export
    # While you can manually call ImGuiTestEngine_Export(), registering filename/format here ensure the crash handler will always export if application crash.
    # Note: in Python, use export_result_filename_set() to set this value.
    # ImGuiTestEngineExportFormat ExportResultsFormat = (ImGuiTestEngineExportFormat)0;    /* original C++ signature */
    export_results_format: TestEngineExportFormat = TestEngineExportFormat.j_unit_xml

    #                                                   #ifdef IMGUI_BUNDLE_PYTHON_API
    #
    # void ExportResultsFilename_Set(const char* filename);    /* original C++ signature */
    def export_results_filename_set(self, filename: str) -> None:
        """Set ExportResultsFilename from Python
        (private API)
        """
        pass
    #                                                   #endif
    #

    # Options: Sanity Checks
    # bool                        CheckDrawDataIntegrity = false;    /* original C++ signature */
    check_draw_data_integrity: bool = (
        False  # Check ImDrawData integrity (buffer count, etc.). Currently cheap but may become a slow operation.
    )

    # -------------------------------------------------------------------------
    # Output
    # -------------------------------------------------------------------------

    # Output: State of test engine
    # bool                        IsRunningTests = false;    /* original C++ signature */
    is_running_tests: bool = False
    # bool                        IsRequestingMaxAppSpeed = false;    /* original C++ signature */
    is_requesting_max_app_speed: bool = (
        False  # When running in fast mode: request app to skip vsync or even skip rendering if it wants
    )
    # bool                        IsCapturing = false;    /* original C++ signature */
    is_capturing: bool = False  # Capture is in progress
    # ImGuiTestEngineIO(bool ConfigSavedSettings = true, ImGuiTestRunSpeed ConfigRunSpeed = ImGuiTestRunSpeed_Fast, bool ConfigStopOnError = false, bool ConfigBreakOnError = false, bool ConfigKeepGuiFunc = false, ImGuiTestVerboseLevel ConfigVerboseLevel = ImGuiTestVerboseLevel_Warning, ImGuiTestVerboseLevel ConfigVerboseLevelOnError = ImGuiTestVerboseLevel_Info, bool ConfigLogToTTY = false, bool ConfigLogToDebugger = false, bool ConfigRestoreFocusAfterTests = true, bool ConfigCaptureEnabled = true, bool ConfigCaptureOnError = false, bool ConfigNoThrottle = false, bool ConfigMouseDrawCursor = true, float ConfigFixedDeltaTime = 0.0f, int PerfStressAmount = 1, float MouseSpeed = 600.0f, float MouseWobble = 0.25f, float ScrollSpeed = 1400.0f, float TypingSpeed = 20.0f, float ActionDelayShort = 0.15f, float ActionDelayStandard = 0.40f, float ConfigWatchdogWarning = 30.0f, float ConfigWatchdogKillTest = 60.0f, float ConfigWatchdogKillApp = FLT_MAX, ImGuiTestEngineExportFormat ExportResultsFormat = (ImGuiTestEngineExportFormat)0, bool CheckDrawDataIntegrity = false, bool IsRunningTests = false, bool IsRequestingMaxAppSpeed = false, bool IsCapturing = false);    /* original C++ signature */
    def __init__(
        self,
        config_saved_settings: bool = True,
        config_run_speed: TestRunSpeed = TestRunSpeed_Fast,
        config_stop_on_error: bool = False,
        config_break_on_error: bool = False,
        config_keep_gui_func: bool = False,
        config_verbose_level: TestVerboseLevel = TestVerboseLevel_Warning,
        config_verbose_level_on_error: TestVerboseLevel = TestVerboseLevel_Info,
        config_log_to_tty: bool = False,
        config_log_to_debugger: bool = False,
        config_restore_focus_after_tests: bool = True,
        config_capture_enabled: bool = True,
        config_capture_on_error: bool = False,
        config_no_throttle: bool = False,
        config_mouse_draw_cursor: bool = True,
        config_fixed_delta_time: float = 0.0,
        perf_stress_amount: int = 1,
        mouse_speed: float = 600.0,
        mouse_wobble: float = 0.25,
        scroll_speed: float = 1400.0,
        typing_speed: float = 20.0,
        action_delay_short: float = 0.15,
        action_delay_standard: float = 0.40,
        config_watchdog_warning: float = 30.0,
        config_watchdog_kill_test: float = 60.0,
        config_watchdog_kill_app: float = sys.float_info.max,
        export_results_format: TestEngineExportFormat = TestEngineExportFormat.j_unit_xml,
        check_draw_data_integrity: bool = False,
        is_running_tests: bool = False,
        is_requesting_max_app_speed: bool = False,
        is_capturing: bool = False,
    ) -> None:
        """Auto-generated default constructor with named params"""
        pass

# -------------------------------------------------------------------------
# ImGuiTestItemInfo
# -------------------------------------------------------------------------

class TestItemInfo:
    """Information about a given item or window, result of an ItemInfo() or WindowInfo() query"""

    # ImGuiID                     ID = 0;    /* original C++ signature */
    id_: ID = 0  # Item ID
    # ImGuiWindow*                Window = NULL;    /* original C++ signature */
    window: Window = None  # Item Window
    # int                         TimestampMain;    /* original C++ signature */
    timestamp_main: int  # Timestamp of main result (all fields)
    # int                         TimestampStatus;    /* original C++ signature */
    timestamp_status: int  # Timestamp of StatusFlags
    # ImGuiID                     ParentID = 0;    /* original C++ signature */
    parent_id: ID = 0  # Item Parent ID (value at top of the ID stack)
    # ImRect                      RectFull = ImRect();    /* original C++ signature */
    rect_full: ImRect = ImRect()  # Item Rectangle
    # ImRect                      RectClipped = ImRect();    /* original C++ signature */
    rect_clipped: ImRect = ImRect()  # Item Rectangle (clipped with window->ClipRect at time of item submission)
    # ImGuiItemFlags              ItemFlags = 0;    /* original C++ signature */
    item_flags: ItemFlags = 0  # Item flags
    # ImGuiItemFlags            InFlags = 0;                // Item flags (OBSOLETE: before 2024/10/17 ItemFlags was called InFlags)
    # ImGuiItemStatusFlags        StatusFlags = 0;    /* original C++ signature */
    status_flags: ItemStatusFlags = (
        0  # Item Status flags (fully updated for some items only, compare TimestampStatus to FrameCount)
    )

    # ImGuiTestItemInfo()         { memset(this, 0, sizeof(*this)); }    /* original C++ signature */
    def __init__(self) -> None:
        pass

class TestItemList:
    """Result of an GatherItems() query"""

    # void                        Clear()                 { Pool.Clear(); }    /* original C++ signature */
    def clear(self) -> None:
        """(private API)"""
        pass
    # void                        Reserve(int capacity)   { Pool.Reserve(capacity); }    /* original C++ signature */
    def reserve(self, capacity: int) -> None:
        """(private API)"""
        pass
    # int                         GetSize() const         { return Pool.GetMapSize(); }    /* original C++ signature */
    def get_size(self) -> int:
        """(private API)"""
        pass
    # const ImGuiTestItemInfo*    GetByIndex(int n)       { return Pool.GetByIndex(n); }    /* original C++ signature */
    def get_by_index(self, n: int) -> TestItemInfo:
        """(private API)"""
        pass
    # const ImGuiTestItemInfo*    GetByID(ImGuiID id)     { return Pool.GetByKey(id); }    /* original C++ signature */
    def get_by_id(self, id_: ID) -> TestItemInfo:
        """(private API)"""
        pass
    # For range-for
    # size_t                      size() const            { return (size_t)Pool.GetMapSize(); }    /* original C++ signature */
    def size(self) -> int:
        """(private API)"""
        pass
    # const ImGuiTestItemInfo*    begin() const           { return Pool.Buf.begin(); }    /* original C++ signature */
    def begin(self) -> TestItemInfo:
        """(private API)"""
        pass
    # const ImGuiTestItemInfo*    end() const             { return Pool.Buf.end(); }    /* original C++ signature */
    def end(self) -> TestItemInfo:
        """(private API)"""
        pass
    # const ImGuiTestItemInfo*    operator[] (size_t n)   { return &Pool.Buf[(int)n]; }    /* original C++ signature */
    def __getitem__(self, n: int) -> TestItemInfo:
        """(private API)"""
        pass
    # ImGuiTestItemList();    /* original C++ signature */
    def __init__(self) -> None:
        """Auto-generated default constructor"""
        pass

# -------------------------------------------------------------------------
# ImGuiTestLog: store textual output of one given Test.
# -------------------------------------------------------------------------

class TestLogLineInfo:
    # ImGuiTestVerboseLevel           Level;    /* original C++ signature */
    level: TestVerboseLevel
    # int                             LineOffset;    /* original C++ signature */
    line_offset: int
    # ImGuiTestLogLineInfo(ImGuiTestVerboseLevel Level = ImGuiTestVerboseLevel(), int LineOffset = int());    /* original C++ signature */
    def __init__(self, level: TestVerboseLevel = TestVerboseLevel(), line_offset: int = int()) -> None:
        """Auto-generated default constructor with named params"""
        pass

class TestLog:
    # ImGuiTextBuffer                 Buffer;    /* original C++ signature */
    buffer: TextBuffer

    # ImGuiTestLog() {}    /* original C++ signature */
    def __init__(self) -> None:
        """Functions"""
        pass
    # bool    IsEmpty() const         { return Buffer.empty(); }    /* original C++ signature */
    def is_empty(self) -> bool:
        """(private API)"""
        pass
    # void    Clear();    /* original C++ signature */
    def clear(self) -> None:
        """(private API)"""
        pass
    # int     ExtractLinesForVerboseLevels(ImGuiTestVerboseLevel level_min, ImGuiTestVerboseLevel level_max, ImGuiTextBuffer* out_buffer);    /* original C++ signature */
    def extract_lines_for_verbose_levels(
        self, level_min: TestVerboseLevel, level_max: TestVerboseLevel, out_buffer: TextBuffer
    ) -> int:
        """Extract log contents filtered per log-level.
         Output:
         - If 'buffer != None': all extracted lines are appended to 'buffer'. Use 'buffer->c_str()' on your side to obtain the text.
         - Return value: number of lines extracted (should be equivalent to number of '\n' inside buffer->c_str()).
         - You may call the function with buffer == None to only obtain a count without getting the data.
         Verbose levels are inclusive:
         - To get ONLY Error:                     Use level_min == ImGuiTestVerboseLevel_Error, level_max = ImGuiTestVerboseLevel_Error
         - To get ONLY Error and Warnings:        Use level_min == ImGuiTestVerboseLevel_Error, level_max = ImGuiTestVerboseLevel_Warning
         - To get All Errors, Warnings, Debug...  Use level_min == ImGuiTestVerboseLevel_Error, level_max = ImGuiTestVerboseLevel_Trace
        (private API)
        """
        pass
    # void    UpdateLineOffsets(ImGuiTestEngineIO* engine_io, ImGuiTestVerboseLevel level, const char* start);    /* original C++ signature */
    def update_line_offsets(self, engine_io: TestEngineIO, level: TestVerboseLevel, start: str) -> None:
        """[Internal]
        (private API)
        """
        pass

# -------------------------------------------------------------------------
# ImGuiTest
# -------------------------------------------------------------------------

# Wraps a placement new of a given type (where 'buffer' is the allocated memory)

class TestOutput:
    """Storage for the output of a test run"""

    # ImGuiTestStatus                 Status = ImGuiTestStatus_Unknown;    /* original C++ signature */
    status: TestStatus = TestStatus_Unknown
    # ImGuiTestLog                    Log;    /* original C++ signature */
    log: TestLog
    # ImU64                           StartTime = 0;    /* original C++ signature */
    start_time: ImU64 = 0
    # ImU64                           EndTime = 0;    /* original C++ signature */
    end_time: ImU64 = 0
    # ImGuiTestOutput(ImGuiTestStatus Status = ImGuiTestStatus_Unknown, ImGuiTestLog Log = ImGuiTestLog(), ImU64 StartTime = 0, ImU64 EndTime = 0);    /* original C++ signature */
    def __init__(
        self,
        status: TestStatus = TestStatus_Unknown,
        log: Optional[TestLog] = None,
        start_time: ImU64 = 0,
        end_time: ImU64 = 0,
    ) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If Log is None, then its default value will be: TestLog()
        """
        pass

class Test:
    """Storage for one test"""

    # Test Definition
    # Str30                           Category;    /* original C++ signature */
    category: Str30  # Stored on the stack if len<30
    # Str30                           Name;    /* original C++ signature */
    name: Str30  # Stored on the stack if len<30
    # ImGuiTestGroup                  Group = ImGuiTestGroup_Unknown;    /* original C++ signature */
    group: TestGroup = TestGroup_Unknown  # Coarse groups: 'Tests' or 'Perf'
    # Str256                          SourceFile;    /* original C++ signature */
    source_file: Str256  # __FILE__, stored on the stack if len<256
    # int                             SourceLine = 0;    /* original C++ signature */
    source_line: int = 0  # __LINE__
    # int                             SourceLineEnd = 0;    /* original C++ signature */
    source_line_end: int = 0  # Calculated by ImGuiTestEngine_StartCalcSourceLineEnds()
    # int                             ArgVariant = 0;    /* original C++ signature */
    arg_variant: int = (
        0  # User parameter. Generally we use it to run variations of a same test by sharing GuiFunc/TestFunc
    )
    # ImGuiTestFlags                  Flags = ImGuiTestFlags_None;    /* original C++ signature */
    flags: TestFlags = TestFlags_None  # See ImGuiTestFlags_
    # Function_TestGui     GuiFunc = NULL;    /* original C++ signature */
    gui_func: Function_TestGui = (
        None  # GUI function (optional if your test are running over an existing GUI application)
    )
    # Function_TestRunner    TestFunc = NULL;    /* original C++ signature */
    test_func: Function_TestRunner = None  # Test function
    # void*                           UserData = NULL;    /* original C++ signature */
    user_data: Any = (
        None  # General purpose user data (if assigning capturing lambdas on GuiFunc/TestFunc you may not need to use this)
    )
    # ImVector<ImGuiTestRunTask>    Dependencies;                   // Registered via AddDependencyTest(), ran automatically before our test. This is a simpler wrapper to calling ctx->RunChildTest()

    # ImGuiTestOutput                 Output;    /* original C++ signature */
    # Last Test Output/Status
    # (this is the only part that may change after registration)
    output: TestOutput

    # User variables (which are instantiated when running the test)
    # Setup after test registration with SetVarsDataType<>(), access instance during test with GetVars<>().
    # This is mostly useful to communicate between GuiFunc and TestFunc. If you don't use both you may not want to use it!
    # size_t                          VarsSize = 0;    /* original C++ signature */
    vars_size: int = 0
    # void*                           VarsPostConstructorUserFn = NULL;    /* original C++ signature */
    vars_post_constructor_user_fn: Any = None

    # ImGuiTest() {}    /* original C++ signature */
    def __init__(self) -> None:
        """Functions"""
        pass

class TestRunTask:
    """Stored in test queue"""

    # ImGuiTest*          Test = NULL;    /* original C++ signature */
    test: Test = None
    # ImGuiTestRunFlags   RunFlags = ImGuiTestRunFlags_None;    /* original C++ signature */
    run_flags: TestRunFlags = TestRunFlags_None
    # ImGuiTestRunTask(ImGuiTestRunFlags RunFlags = ImGuiTestRunFlags_None);    /* original C++ signature */
    def __init__(self, run_flags: TestRunFlags = TestRunFlags_None) -> None:
        """Auto-generated default constructor with named params"""
        pass

# -------------------------------------------------------------------------

####################    </generated_from:imgui_te_engine.h>    ####################

####################    <generated_from:imgui_te_context.h>    ####################
# dear imgui test engine
# (context when a running test + end user automation API)
# This is the main (if not only) interface that your Tests will be using.

#
#
# Index of this file:
# // [SECTION] Header mess, warnings
# // [SECTION] Forward declarations
# // [SECTION] ImGuiTestRef
# // [SECTION] Helper keys
# // [SECTION] ImGuiTestContext related Flags/Enumerations
# // [SECTION] ImGuiTestGenericVars, ImGuiTestGenericItemStatus
# // [SECTION] ImGuiTestContext
# // [SECTION] Debugging macros: IM_SUSPEND_TESTFUNC()
# // [SECTION] Testing/Checking macros: IM_CHECK(), IM_ERRORF() etc.
#
#

# -------------------------------------------------------------------------
# [SECTION] Header mess, warnings
# -------------------------------------------------------------------------

# Undo some of the damage done by <windows.h>

# -------------------------------------------------------------------------
# [SECTION] Forward declarations
# -------------------------------------------------------------------------

# This file

# External: imgui

# External: test engine

# -------------------------------------------------------------------------
# [SECTION] ImGuiTestRef
# -------------------------------------------------------------------------

class TestRef:
    """Weak reference to an Item/Window given an hashed ID _or_ a string path ID.
    This is most often passed as argument to function and generally has a very short lifetime.
    Documentation: https://github.com/ocornut/imgui_test_engine/wiki/Named-References
    (SUGGESTION: add those constructors to "VA Step Filter" (Visual Assist) or a .natstepfilter file (Visual Studio) so they are skipped by F11 (StepInto)
    """

    # ImGuiID         ID;    /* original C++ signature */
    id_: ID  # Pre-hashed ID

    # ImGuiTestRef()                  { ID = 0; Path = Str(""); }    /* original C++ signature */
    @overload
    def __init__(self) -> None:
        pass
    # ImGuiTestRef(ImGuiID id)        { ID = id; Path = Str(""); }    /* original C++ signature */
    @overload
    def __init__(self, id_: ID) -> None:
        pass
    # ImGuiTestRef(const char* path)  { ID = 0; Path = Str(path); }    /* original C++ signature */
    @overload
    def __init__(self, path: str) -> None:
        pass
    # bool IsEmpty() const            { return ID == 0 && Path.length() == 0; }    /* original C++ signature */
    def is_empty(self) -> bool:
        """(private API)"""
        pass

class TestRefDesc:
    """Debug helper to output a string showing the Path, ID or Debug Label based on what is available (some items only have ID as we couldn't find/store a Path)
    (The size is arbitrary, this is only used for logging info the user/debugger)
    """

    # const char* c_str()             { return Buf; }    /* original C++ signature */
    def c_str(self) -> str:
        """(private API)"""
        pass
    # ImGuiTestRefDesc(const ImGuiTestRef& ref);    /* original C++ signature */
    @overload
    def __init__(self, ref: Union[TestRef, str]) -> None:
        pass
    # ImGuiTestRefDesc(const ImGuiTestRef& ref, const ImGuiTestItemInfo& item);    /* original C++ signature */
    @overload
    def __init__(self, ref: Union[TestRef, str], item: TestItemInfo) -> None:
        pass

# -------------------------------------------------------------------------
# [SECTION] ImGuiTestContext related Flags/Enumerations
# -------------------------------------------------------------------------

class TestAction(enum.Enum):
    """Named actions. Generally you will call the named helpers e.g. ItemClick(). This is used by shared/low-level functions such as ItemAction()."""

    # ImGuiTestAction_Unknown = 0,    /* original C++ signature */
    unknown = enum.auto()  # (= 0)
    # ImGuiTestAction_Hover,              /* original C++ signature */
    hover = enum.auto()  # (= 1)  # Move mouse
    # ImGuiTestAction_Click,              /* original C++ signature */
    click = enum.auto()  # (= 2)  # Move mouse and click
    # ImGuiTestAction_DoubleClick,        /* original C++ signature */
    double_click = enum.auto()  # (= 3)  # Move mouse and double-click
    # ImGuiTestAction_Check,              /* original C++ signature */
    check = (
        enum.auto()
    )  # (= 4)  # Check item if unchecked (Checkbox, MenuItem or any widget reporting ImGuiItemStatusFlags_Checkable)
    # ImGuiTestAction_Uncheck,            /* original C++ signature */
    uncheck = enum.auto()  # (= 5)  # Uncheck item if checked
    # ImGuiTestAction_Open,               /* original C++ signature */
    open = (
        enum.auto()
    )  # (= 6)  # Open item if closed (TreeNode, BeginMenu or any widget reporting ImGuiItemStatusFlags_Openable)
    # ImGuiTestAction_Close,              /* original C++ signature */
    close = enum.auto()  # (= 7)  # Close item if opened
    # ImGuiTestAction_Input,              /* original C++ signature */
    input = (
        enum.auto()
    )  # (= 8)  # Start text inputing into a field (e.g. CTRL+Click on Drags/Slider, click on InputText etc.)
    # ImGuiTestAction_NavActivate,        /* original C++ signature */
    nav_activate = enum.auto()  # (= 9)  # Activate item with navigation
    # ImGuiTestAction_COUNT    /* original C++ signature */
    # }
    count = enum.auto()  # (= 10)

class TestOpFlags_(enum.Enum):
    """Generic flags for many ImGuiTestContext functions
    Some flags are only supported by a handful of functions. Check function headers for list of supported flags.
    """

    # ImGuiTestOpFlags_None               = 0,    /* original C++ signature */
    none = enum.auto()  # (= 0)
    # ImGuiTestOpFlags_NoCheckHoveredId   = 1 << 1,       /* original C++ signature */
    no_check_hovered_id = (
        enum.auto()
    )  # (= 1 << 1)  # Don't check for HoveredId after aiming for a widget. A few situations may want this: while e.g. dragging or another items prevents hovering, or for items that don't use ItemHoverable()
    # ImGuiTestOpFlags_NoError            = 1 << 2,       /* original C++ signature */
    no_error = (
        enum.auto()
    )  # (= 1 << 2)  # Don't abort/error e.g. if the item cannot be found or the operation doesn't succeed.
    # ImGuiTestOpFlags_NoFocusWindow      = 1 << 3,       /* original C++ signature */
    no_focus_window = enum.auto()  # (= 1 << 3)  # Don't focus window when aiming at an item
    # ImGuiTestOpFlags_NoAutoUncollapse   = 1 << 4,       /* original C++ signature */
    no_auto_uncollapse = (
        enum.auto()
    )  # (= 1 << 4)  # Disable automatically uncollapsing windows (useful when specifically testing Collapsing behaviors)
    # ImGuiTestOpFlags_NoAutoOpenFullPath = 1 << 5,       /* original C++ signature */
    no_auto_open_full_path = (
        enum.auto()
    )  # (= 1 << 5)  # Disable automatically opening intermediaries (e.g. ItemClick("Hello/OK") will automatically first open "Hello" if "OK" isn't found. Only works if ref is a string path.
    # ImGuiTestOpFlags_NoYield            = 1 << 6,       /* original C++ signature */
    no_yield = (
        enum.auto()
    )  # (= 1 << 6)  # Don't yield (only supported by a few functions), in case you need to manage rigorous per-frame timing.
    # ImGuiTestOpFlags_IsSecondAttempt    = 1 << 7,       /* original C++ signature */
    is_second_attempt = enum.auto()  # (= 1 << 7)  # Used by recursing functions to indicate a second attempt
    # ImGuiTestOpFlags_MoveToEdgeL        = 1 << 8,       /* original C++ signature */
    move_to_edge_l = (
        enum.auto()
    )  # (= 1 << 8)  # Simple Dumb aiming helpers to test widget that care about clicking position. May need to replace will better functionalities.
    # ImGuiTestOpFlags_MoveToEdgeR        = 1 << 9,    /* original C++ signature */
    move_to_edge_r = enum.auto()  # (= 1 << 9)
    # ImGuiTestOpFlags_MoveToEdgeU        = 1 << 10,    /* original C++ signature */
    move_to_edge_u = enum.auto()  # (= 1 << 10)
    # ImGuiTestOpFlags_MoveToEdgeD        = 1 << 11,    /* original C++ signature */
    # }
    move_to_edge_d = enum.auto()  # (= 1 << 11)

class TestActionFilter:
    """Advanced filtering for ItemActionAll()"""

    # int                     MaxDepth;    /* original C++ signature */
    max_depth: int
    # int                     MaxPasses;    /* original C++ signature */
    max_passes: int
    # const int*              MaxItemCountPerDepth;    /* original C++ signature */
    max_item_count_per_depth: int  # (const)
    # ImGuiItemStatusFlags    RequireAllStatusFlags;    /* original C++ signature */
    require_all_status_flags: ItemStatusFlags
    # ImGuiItemStatusFlags    RequireAnyStatusFlags;    /* original C++ signature */
    require_any_status_flags: ItemStatusFlags

    # ImGuiTestActionFilter() { MaxDepth = -1; MaxPasses = -1; MaxItemCountPerDepth = NULL; RequireAllStatusFlags = RequireAnyStatusFlags = 0; }    /* original C++ signature */
    def __init__(self) -> None:
        pass

# -------------------------------------------------------------------------
# [SECTION] ImGuiTestGenericVars, ImGuiTestGenericItemStatus
# -------------------------------------------------------------------------

class TestGenericItemStatus:
    """Helper struct to store various query-able state of an item.
    This facilitate interactions between GuiFunc and TestFunc, since those state are frequently used.
    """

    # int     RetValue;    /* original C++ signature */
    ret_value: int  # return value
    # int     Hovered;    /* original C++ signature */
    hovered: int  # result of IsItemHovered()
    # int     Active;    /* original C++ signature */
    active: int  # result of IsItemActive()
    # int     Focused;    /* original C++ signature */
    focused: int  # result of IsItemFocused()
    # int     Clicked;    /* original C++ signature */
    clicked: int  # result of IsItemClicked()
    # int     Visible;    /* original C++ signature */
    visible: int  # result of IsItemVisible()
    # int     Edited;    /* original C++ signature */
    edited: int  # result of IsItemEdited()
    # int     Activated;    /* original C++ signature */
    activated: int  # result of IsItemActivated()
    # int     Deactivated;    /* original C++ signature */
    deactivated: int  # result of IsItemDeactivated()
    # int     DeactivatedAfterEdit;    /* original C++ signature */
    deactivated_after_edit: int  # result of IsItemDeactivatedAfterEdit()

    # ImGuiTestGenericItemStatus()        { Clear(); }    /* original C++ signature */
    def __init__(self) -> None:
        pass
    # void Clear()                        { memset(this, 0, sizeof(*this)); }    /* original C++ signature */
    def clear(self) -> None:
        """(private API)"""
        pass
    # void QuerySet(bool ret_val = false) { Clear(); QueryInc(ret_val); }    /* original C++ signature */
    def query_set(self, ret_val: bool = False) -> None:
        """(private API)"""
        pass
    # void QueryInc(bool ret_val = false) { RetValue += ret_val; Hovered += ImGui::IsItemHovered(); Active += ImGui::IsItemActive(); Focused += ImGui::IsItemFocused(); Clicked += ImGui::IsItemClicked(); Visible += ImGui::IsItemVisible(); Edited += ImGui::IsItemEdited(); Activated += ImGui::IsItemActivated(); Deactivated += ImGui::IsItemDeactivated(); DeactivatedAfterEdit += ImGui::IsItemDeactivatedAfterEdit(); }    /* original C++ signature */
    def query_inc(self, ret_val: bool = False) -> None:
        """(private API)"""
        pass

class TestGenericVars:
    """Generic structure with various storage fields.
    This is useful for tests to quickly share data between GuiFunc and TestFunc without creating custom data structure.
    If those fields are not enough: using test->SetVarsDataType<>() + ctx->GetVars<>() it is possible to store custom data.
    """

    # Generic storage with a bit of semantic to make user/test code look neater
    # int                     Step;    /* original C++ signature */
    step: int
    # int                     Count;    /* original C++ signature */
    count: int
    # ImGuiID                 DockId;    /* original C++ signature */
    dock_id: ID
    # ImGuiID                 OwnerId;    /* original C++ signature */
    owner_id: ID
    # ImVec2                  WindowSize;    /* original C++ signature */
    window_size: ImVec2
    # ImGuiWindowFlags        WindowFlags;    /* original C++ signature */
    window_flags: WindowFlags
    # ImGuiTableFlags         TableFlags;    /* original C++ signature */
    table_flags: TableFlags
    # ImGuiPopupFlags         PopupFlags;    /* original C++ signature */
    popup_flags: PopupFlags
    # ImGuiTestGenericItemStatus  Status;    /* original C++ signature */
    status: TestGenericItemStatus
    # bool                    ShowWindow1,     /* original C++ signature */
    show_window1: bool
    # ShowWindow2;    /* original C++ signature */
    show_window2: bool
    # bool                    UseClipper;    /* original C++ signature */
    use_clipper: bool
    # bool                    UseViewports;    /* original C++ signature */
    use_viewports: bool
    # float                   Width;    /* original C++ signature */
    width: float
    # ImVec2                  Pos;    /* original C++ signature */
    pos: ImVec2
    # ImVec2                  Pivot;    /* original C++ signature */
    pivot: ImVec2
    # ImVec2                  ItemSize;    /* original C++ signature */
    item_size: ImVec2
    # ImVec4                  Color1,     /* original C++ signature */
    color1: ImVec4
    # Color2;    /* original C++ signature */
    color2: ImVec4

    # Generic unnamed storage
    # int                     Int1,     /* original C++ signature */
    int1: int
    # Int2,     /* original C++ signature */
    int2: int
    # IntArray[10];    /* original C++ signature */
    int_array: np.ndarray  # ndarray[type=int, size=10]
    # float                   Float1,     /* original C++ signature */
    float1: float
    # Float2,     /* original C++ signature */
    float2: float
    # FloatArray[10];    /* original C++ signature */
    float_array: np.ndarray  # ndarray[type=float, size=10]
    # bool                    Bool1,     /* original C++ signature */
    bool1: bool
    # Bool2,     /* original C++ signature */
    bool2: bool
    # BoolArray[10];    /* original C++ signature */
    bool_array: np.ndarray  # ndarray[type=bool, size=10]
    # ImGuiID                 Id,     /* original C++ signature */
    id_: ID
    # IdArray[10];    /* original C++ signature */
    id_array: np.ndarray  # ndarray[type=ImGuiID, size=10]

    # ImGuiTestGenericVars()  { Clear(); }    /* original C++ signature */
    def __init__(self) -> None:
        pass
    # void Clear()            { memset(this, 0, sizeof(*this)); }    /* original C++ signature */
    def clear(self) -> None:
        """(private API)"""
        pass

# -------------------------------------------------------------------------
# [SECTION] ImGuiTestContext
# Context for a running ImGuiTest
# This is the interface that most tests will interact with.
# -------------------------------------------------------------------------

class TestContext:
    # User variables
    # ImGuiTestGenericVars    GenericVars;    /* original C++ signature */
    generic_vars: TestGenericVars  # Generic variables holder for convenience.
    # void*                   UserVars = NULL;    /* original C++ signature */
    user_vars: Any = None  # Access using ctx->GetVars<Type>(). Setup with test->SetVarsDataType<>().

    # Public fields
    # ImGuiContext*           UiContext = NULL;    /* original C++ signature */
    ui_context: Context = None  # UI context
    # ImGuiTestEngineIO*      EngineIO = NULL;    /* original C++ signature */
    engine_io: TestEngineIO = None  # Test Engine IO/settings
    # ImGuiTest*              Test = NULL;    /* original C++ signature */
    test: Test = None  # Test currently running
    # ImGuiTestOutput*        TestOutput = NULL;    /* original C++ signature */
    test_output: TestOutput = None  # Test output (generally == &Test->Output)
    # ImGuiTestOpFlags        OpFlags = ImGuiTestOpFlags_None;    /* original C++ signature */
    op_flags: TestOpFlags = (
        TestOpFlags_None  # Flags affecting all operation (supported: ImGuiTestOpFlags_NoAutoUncollapse)
    )
    # int                     PerfStressAmount = 0;    /* original C++ signature */
    perf_stress_amount: int = 0  # Convenience copy of engine->IO.PerfStressAmount
    # int                     FrameCount = 0;    /* original C++ signature */
    frame_count: int = 0  # Test frame count (restarts from zero every time)
    # int                     FirstTestFrameCount = 0;    /* original C++ signature */
    first_test_frame_count: int = (
        0  # First frame where TestFunc is running (after warm-up frame). This is generally -1 or 0 depending on whether we have warm up enabled
    )
    # bool                    FirstGuiFrame = false;    /* original C++ signature */
    first_gui_frame: bool = False
    # bool                    HasDock = false;    /* original C++ signature */
    has_dock: bool = False  # #ifdef IMGUI_HAS_DOCK expressed in an easier to test value

    # -------------------------------------------------------------------------
    # [Internal Fields]
    # -------------------------------------------------------------------------

    # ImGuiTestEngine*        Engine = NULL;    /* original C++ signature */
    engine: TestEngine = None
    # ImGuiTestInputs*        Inputs = NULL;    /* original C++ signature */
    inputs: TestInputs = None
    # ImGuiTestRunFlags       RunFlags = ImGuiTestRunFlags_None;    /* original C++ signature */
    run_flags: TestRunFlags = TestRunFlags_None
    # ImGuiTestActiveFunc     ActiveFunc = ImGuiTestActiveFunc_None;    /* original C++ signature */
    active_func: TestActiveFunc = TestActiveFunc_None  # None/GuiFunc/TestFunc
    # double                  RunningTime = 0.0;    /* original C++ signature */
    running_time: float = 0.0  # Amount of wall clock time the Test has been running. Used by safety watchdog.
    # int                     ActionDepth = 0;    /* original C++ signature */
    action_depth: int = 0  # Nested depth of ctx-> function calls (used to decorate log)
    # int                     CaptureCounter = 0;    /* original C++ signature */
    capture_counter: int = 0  # Number of captures
    # int                     ErrorCounter = 0;    /* original C++ signature */
    error_counter: int = 0  # Number of errors (generally this maxxes at 1 as most functions will early out)
    # bool                    Abort = false;    /* original C++ signature */
    abort: bool = False
    # double                  PerfRefDt = -1.0;    /* original C++ signature */
    perf_ref_dt: float = -1.0
    # int                     PerfIterations = 400;    /* original C++ signature */
    perf_iterations: int = 400  # Number of frames for PerfCapture() measurements
    # ImGuiID                 RefID = 0;    /* original C++ signature */
    ref_id: ID = 0  # Reference ID over which all named references are based
    # ImGuiID                 RefWindowID = 0;    /* original C++ signature */
    ref_window_id: ID = 0  # ID of a window that contains RefID item
    # ImGuiInputSource        InputMode = ImGuiInputSource_Mouse;    /* original C++ signature */
    input_mode: InputSource = InputSource_Mouse  # Prefer interacting with mouse/keyboard/gamepad
    # ImVector<char>          Clipboard;    /* original C++ signature */
    clipboard: ImVector_char  # Private clipboard for the test instance
    # ImVector<ImGuiWindow*>  ForeignWindowsToHide;    /* original C++ signature */
    foreign_windows_to_hide: ImVector_Window_ptr
    # ImGuiTestItemInfo       DummyItemInfoNull;    /* original C++ signature */
    dummy_item_info_null: TestItemInfo  # Storage for ItemInfoNull()
    # bool                    CachedLinesPrintedToTTY = false;    /* original C++ signature */
    cached_lines_printed_to_tty: bool = False

    # -------------------------------------------------------------------------
    # Public API
    # -------------------------------------------------------------------------

    # Main control
    # void            Finish(ImGuiTestStatus status = ImGuiTestStatus_Success);                           /* original C++ signature */
    def finish(self, status: TestStatus = TestStatus_Success) -> None:
        """(private API)

        Set test status and stop running. Usually called when running test logic from GuiFunc() only.
        """
        pass
    # ImGuiTestStatus RunChildTest(const char* test_name, ImGuiTestRunFlags flags = 0);                   /* original C++ signature */
    def run_child_test(self, test_name: str, flags: TestRunFlags = 0) -> TestStatus:
        """(private API)

        [Experimental] Run another test from the current test.
        """
        pass
    # Main status queries
    # bool        IsError() const             { return TestOutput->Status == ImGuiTestStatus_Error || Abort; }    /* original C++ signature */
    def is_error(self) -> bool:
        """(private API)"""
        pass
    # bool        IsWarmUpGuiFrame() const    { return FrameCount < FirstTestFrameCount; }        /* original C++ signature */
    def is_warm_up_gui_frame(self) -> bool:
        """(private API)

        Unless test->Flags has ImGuiTestFlags_NoGuiWarmUp, we run GuiFunc() twice before running TestFunc(). Those frames are called "WarmUp" frames.
        """
        pass
    # bool        IsFirstGuiFrame() const     { return FirstGuiFrame; }    /* original C++ signature */
    def is_first_gui_frame(self) -> bool:
        """(private API)"""
        pass
    # bool        IsFirstTestFrame() const    { return FrameCount == FirstTestFrameCount; }       /* original C++ signature */
    def is_first_test_frame(self) -> bool:
        """(private API)

        First frame where TestFunc is running (after warm-up frame).
        """
        pass
    # bool        IsGuiFuncOnly() const       { return (RunFlags & ImGuiTestRunFlags_GuiFuncOnly) != 0; }    /* original C++ signature */
    def is_gui_func_only(self) -> bool:
        """(private API)"""
        pass
    # Debugging
    # bool        SuspendTestFunc(const char* file = NULL, int line = 0);                 /* original C++ signature */
    def suspend_test_func(self, file: Optional[str] = None, line: int = 0) -> bool:
        """(private API)

        [DEBUG] Generally called via IM_SUSPEND_TESTFUNC
        """
        pass
    # Logging
    # void        LogEx(ImGuiTestVerboseLevel level, ImGuiTestLogFlags flags, const char* fmt, ...) ;    /* original C++ signature */
    def log_ex(self, level: TestVerboseLevel, flags: TestLogFlags, fmt: str) -> None:
        """(private API)"""
        pass
    # void        LogToTTY(ImGuiTestVerboseLevel level, const char* message, const char* message_end = NULL);    /* original C++ signature */
    def log_to_tty(self, level: TestVerboseLevel, message: str, message_end: Optional[str] = None) -> None:
        """(private API)"""
        pass
    # void        LogToDebugger(ImGuiTestVerboseLevel level, const char* message);    /* original C++ signature */
    def log_to_debugger(self, level: TestVerboseLevel, message: str) -> None:
        """(private API)"""
        pass
    # void        LogDebug(const char* fmt, ...)      ;      /* original C++ signature */
    def log_debug(self, fmt: str) -> None:
        """(private API)

        ImGuiTestVerboseLevel_Debug or ImGuiTestVerboseLevel_Trace depending on context depth
        """
        pass
    # void        LogInfo(const char* fmt, ...)       ;      /* original C++ signature */
    def log_info(self, fmt: str) -> None:
        """(private API)

        ImGuiTestVerboseLevel_Info
        """
        pass
    # void        LogWarning(const char* fmt, ...)    ;      /* original C++ signature */
    def log_warning(self, fmt: str) -> None:
        """(private API)

        ImGuiTestVerboseLevel_Warning
        """
        pass
    # void        LogError(const char* fmt, ...)      ;      /* original C++ signature */
    def log_error(self, fmt: str) -> None:
        """(private API)

        ImGuiTestVerboseLevel_Error
        """
        pass
    # void        LogBasicUiState();    /* original C++ signature */
    def log_basic_ui_state(self) -> None:
        """(private API)"""
        pass
    # void        LogItemList(ImGuiTestItemList* list);    /* original C++ signature */
    def log_item_list(self, list: TestItemList) -> None:
        """(private API)"""
        pass
    # Yield, Timing
    # void        Yield(int count = 1);    /* original C++ signature */
    def yield_(self, count: int = 1) -> None:
        """(private API)"""
        pass
    # void        Sleep(float time_in_second);                /* original C++ signature */
    def sleep(self, time_in_second: float) -> None:
        """(private API)

        Sleep for a given simulation time, unless in Fast mode
        """
        pass
    # void        SleepShort();                               /* original C++ signature */
    def sleep_short(self) -> None:
        """(private API)

        Standard short delay of io.ActionDelayShort (~0.15), unless in Fast mode.
        """
        pass
    # void        SleepStandard();                            /* original C++ signature */
    def sleep_standard(self) -> None:
        """(private API)

        Standard regular delay of io.ActionDelayStandard (~0.40), unless in Fast mode.
        """
        pass
    # void        SleepNoSkip(float time_in_second, float framestep_in_second);    /* original C++ signature */
    def sleep_no_skip(self, time_in_second: float, framestep_in_second: float) -> None:
        """(private API)"""
        pass
    # Base Reference
    # - ItemClick("Window/Button")                --> click "Window/Button"
    # - SetRef("Window"), ItemClick("Button")     --> click "Window/Button"
    # - SetRef("Window"), ItemClick("/Button")    --> click "Window/Button"
    # - SetRef("Window"), ItemClick("//Button")   --> click "/Button"
    # - SetRef("//$FOCUSED"), ItemClick("Button") --> click "Button" in focused window.
    # See https://github.com/ocornut/imgui_test_engine/wiki/Named-References about using ImGuiTestRef in all ImGuiTestContext functions.
    # Note: SetRef() may take multiple frames to complete if specified ref is an item id.
    # Note: SetRef() ignores current reference, so they are always absolute path.
    # void        SetRef(ImGuiTestRef ref);    /* original C++ signature */
    @overload
    def set_ref(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        SetRef(ImGuiWindow* window);     /* original C++ signature */
    @overload
    def set_ref(self, window: Window) -> None:
        """(private API)

        Shortcut to SetRef(window->Name) which works for ChildWindow (see code)
        """
        pass
    # ImGuiTestRef GetRef();    /* original C++ signature */
    def get_ref(self) -> TestRef:
        """(private API)"""
        pass
    # Windows
    # - Use WindowInfo() to access path to child windows, since the paths are internally mangled.
    # - SetRef(WindowInfo("Parent/Child")->Window) --> set ref to child window.
    # ImGuiTestItemInfo WindowInfo(ImGuiTestRef window_ref, ImGuiTestOpFlags flags = ImGuiTestOpFlags_None);    /* original C++ signature */
    def window_info(self, window_ref: Union[TestRef, str], flags: TestOpFlags = TestOpFlags_None) -> TestItemInfo:
        """(private API)"""
        pass
    # void        WindowClose(ImGuiTestRef window_ref);    /* original C++ signature */
    def window_close(self, window_ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        WindowCollapse(ImGuiTestRef window_ref, bool collapsed);    /* original C++ signature */
    def window_collapse(self, window_ref: Union[TestRef, str], collapsed: bool) -> None:
        """(private API)"""
        pass
    # void        WindowFocus(ImGuiTestRef window_ref, ImGuiTestOpFlags flags = ImGuiTestOpFlags_None);    /* original C++ signature */
    def window_focus(self, window_ref: Union[TestRef, str], flags: TestOpFlags = TestOpFlags_None) -> None:
        """(private API)"""
        pass
    # void        WindowBringToFront(ImGuiTestRef window_ref, ImGuiTestOpFlags flags = ImGuiTestOpFlags_None);    /* original C++ signature */
    def window_bring_to_front(self, window_ref: Union[TestRef, str], flags: TestOpFlags = TestOpFlags_None) -> None:
        """(private API)"""
        pass
    # void        WindowMove(ImGuiTestRef window_ref, ImVec2 pos, ImVec2 pivot = ImVec2(0.0f, 0.0f), ImGuiTestOpFlags flags = ImGuiTestOpFlags_None);    /* original C++ signature */
    def window_move(
        self,
        window_ref: Union[TestRef, str],
        pos: ImVec2Like,
        pivot: Optional[ImVec2Like] = None,
        flags: TestOpFlags = TestOpFlags_None,
    ) -> None:
        """---
        Python bindings defaults:
            If pivot is None, then its default value will be: ImVec2(0.0, 0.0)
        (private API)
        """
        pass
    # void        WindowResize(ImGuiTestRef window_ref, ImVec2 sz);    /* original C++ signature */
    def window_resize(self, window_ref: Union[TestRef, str], sz: ImVec2Like) -> None:
        """(private API)"""
        pass
    # bool        WindowTeleportToMakePosVisible(ImGuiTestRef window_ref, ImVec2 pos_in_window);    /* original C++ signature */
    def window_teleport_to_make_pos_visible(self, window_ref: Union[TestRef, str], pos_in_window: ImVec2Like) -> bool:
        """(private API)"""
        pass
    # ImGuiWindow*GetWindowByRef(ImGuiTestRef window_ref);    /* original C++ signature */
    def get_window_by_ref(self, window_ref: Union[TestRef, str]) -> Window:
        """(private API)"""
        pass
    # Popups
    # void        PopupCloseOne();    /* original C++ signature */
    def popup_close_one(self) -> None:
        """(private API)"""
        pass
    # void        PopupCloseAll();    /* original C++ signature */
    def popup_close_all(self) -> None:
        """(private API)"""
        pass
    # ImGuiID     PopupGetWindowID(ImGuiTestRef ref);    /* original C++ signature */
    def popup_get_window_id(self, ref: Union[TestRef, str]) -> ID:
        """(private API)"""
        pass
    # Get hash for a decorated ID Path.
    # Note: for windows you may use WindowInfo()
    # ImGuiID     GetID(ImGuiTestRef ref);    /* original C++ signature */
    @overload
    def get_id(self, ref: Union[TestRef, str]) -> ID:
        """(private API)"""
        pass
    # ImGuiID     GetID(ImGuiTestRef ref, ImGuiTestRef seed_ref);    /* original C++ signature */
    @overload
    def get_id(self, ref: Union[TestRef, str], seed_ref: Union[TestRef, str]) -> ID:
        """(private API)"""
        pass
    # Miscellaneous helpers
    # ImVec2      GetPosOnVoid(ImGuiViewport* viewport);                                  /* original C++ signature */
    def get_pos_on_void(self, viewport: Viewport) -> ImVec2:
        """(private API)

        Find a point that has no windows // FIXME: This needs error return and flag to enable/disable forcefully finding None.
        """
        pass
    # ImVec2      GetWindowTitlebarPoint(ImGuiTestRef window_ref);                        /* original C++ signature */
    def get_window_titlebar_point(self, window_ref: Union[TestRef, str]) -> ImVec2:
        """(private API)

        Return a clickable point on window title-bar (window tab for docked windows).
        """
        pass
    # ImVec2      GetMainMonitorWorkPos();                                                /* original C++ signature */
    def get_main_monitor_work_pos(self) -> ImVec2:
        """(private API)

        Work pos and size of main viewport when viewports are disabled, or work pos and size of monitor containing main viewport when viewports are enabled.
        """
        pass
    # ImVec2      GetMainMonitorWorkSize();    /* original C++ signature */
    def get_main_monitor_work_size(self) -> ImVec2:
        """(private API)"""
        pass
    # Screenshot/Video Captures
    # void        CaptureReset();                                                         /* original C++ signature */
    def capture_reset(self) -> None:
        """(private API)

        Reset state (use when doing multiple captures)
        """
        pass
    # void        CaptureSetExtension(const char* ext);                                   /* original C++ signature */
    def capture_set_extension(self, ext: str) -> None:
        """(private API)

        Set capture file format (otherwise for video this default to EngineIO->VideoCaptureExtension)
        """
        pass
    # bool        CaptureAddWindow(ImGuiTestRef ref);                                     /* original C++ signature */
    def capture_add_window(self, ref: Union[TestRef, str]) -> bool:
        """(private API)

        Add window to be captured (default to capture everything)
        """
        pass
    # void        CaptureScreenshotWindow(ImGuiTestRef ref, int capture_flags = 0);       /* original C++ signature */
    def capture_screenshot_window(self, ref: Union[TestRef, str], capture_flags: int = 0) -> None:
        """(private API)

        Trigger a screen capture of a single window (== CaptureAddWindow() + CaptureScreenshot())
        """
        pass
    # bool        CaptureScreenshot(int capture_flags = 0);                               /* original C++ signature */
    def capture_screenshot(self, capture_flags: int = 0) -> bool:
        """(private API)

        Trigger a screen capture
        """
        pass
    # bool        CaptureBeginVideo();                                                    /* original C++ signature */
    def capture_begin_video(self) -> bool:
        """(private API)

        Start a video capture
        """
        pass
    # bool        CaptureEndVideo();    /* original C++ signature */
    def capture_end_video(self) -> bool:
        """(private API)"""
        pass
    # Mouse inputs
    # void        MouseMove(ImGuiTestRef ref, ImGuiTestOpFlags flags = ImGuiTestOpFlags_None);    /* original C++ signature */
    def mouse_move(self, ref: Union[TestRef, str], flags: TestOpFlags = TestOpFlags_None) -> None:
        """(private API)"""
        pass
    # void        MouseMoveToPos(ImVec2 pos);    /* original C++ signature */
    def mouse_move_to_pos(self, pos: ImVec2Like) -> None:
        """(private API)"""
        pass
    # void        MouseTeleportToPos(ImVec2 pos, ImGuiTestOpFlags flags = ImGuiTestOpFlags_None);    /* original C++ signature */
    def mouse_teleport_to_pos(self, pos: ImVec2Like, flags: TestOpFlags = TestOpFlags_None) -> None:
        """(private API)"""
        pass
    # void        MouseClick(ImGuiMouseButton button = 0);    /* original C++ signature */
    def mouse_click(self, button: MouseButton = 0) -> None:
        """(private API)"""
        pass
    # void        MouseClickMulti(ImGuiMouseButton button, int count);    /* original C++ signature */
    def mouse_click_multi(self, button: MouseButton, count: int) -> None:
        """(private API)"""
        pass
    # void        MouseDoubleClick(ImGuiMouseButton button = 0);    /* original C++ signature */
    def mouse_double_click(self, button: MouseButton = 0) -> None:
        """(private API)"""
        pass
    # void        MouseDown(ImGuiMouseButton button = 0);    /* original C++ signature */
    def mouse_down(self, button: MouseButton = 0) -> None:
        """(private API)"""
        pass
    # void        MouseUp(ImGuiMouseButton button = 0);    /* original C++ signature */
    def mouse_up(self, button: MouseButton = 0) -> None:
        """(private API)"""
        pass
    # void        MouseLiftDragThreshold(ImGuiMouseButton button = 0);    /* original C++ signature */
    def mouse_lift_drag_threshold(self, button: MouseButton = 0) -> None:
        """(private API)"""
        pass
    # void        MouseDragWithDelta(ImVec2 delta, ImGuiMouseButton button = 0);    /* original C++ signature */
    def mouse_drag_with_delta(self, delta: ImVec2Like, button: MouseButton = 0) -> None:
        """(private API)"""
        pass
    # void        MouseWheel(ImVec2 delta);    /* original C++ signature */
    def mouse_wheel(self, delta: ImVec2Like) -> None:
        """(private API)"""
        pass
    # void        MouseWheelX(float dx) { MouseWheel(ImVec2(dx, 0.0f)); }    /* original C++ signature */
    def mouse_wheel_x(self, dx: float) -> None:
        """(private API)"""
        pass
    # void        MouseWheelY(float dy) { MouseWheel(ImVec2(0.0f, dy)); }    /* original C++ signature */
    def mouse_wheel_y(self, dy: float) -> None:
        """(private API)"""
        pass
    # void        MouseMoveToVoid(ImGuiViewport* viewport = NULL);    /* original C++ signature */
    def mouse_move_to_void(self, viewport: Optional[Viewport] = None) -> None:
        """(private API)"""
        pass
    # void        MouseClickOnVoid(ImGuiMouseButton button = 0, ImGuiViewport* viewport = NULL);    /* original C++ signature */
    def mouse_click_on_void(self, button: MouseButton = 0, viewport: Optional[Viewport] = None) -> None:
        """(private API)"""
        pass
    # ImGuiWindow*FindHoveredWindowAtPos(const ImVec2& pos);    /* original C++ signature */
    def find_hovered_window_at_pos(self, pos: ImVec2Like) -> Window:
        """(private API)"""
        pass
    # bool        FindExistingVoidPosOnViewport(ImGuiViewport* viewport, ImVec2* out);    /* original C++ signature */
    def find_existing_void_pos_on_viewport(self, viewport: Viewport, out: ImVec2Like) -> bool:
        """(private API)"""
        pass
    # Mouse inputs: Viewports
    # - This is automatically called by SetRef() and any mouse action taking an item reference (e.g. ItemClick("button"), MouseClick("button"))
    # - But when using raw position directy e.g. MouseMoveToPos() / MouseTeleportToPos() without referring to the parent window before, this needs to be set.
    # void        MouseSetViewport(ImGuiWindow* window);    /* original C++ signature */
    def mouse_set_viewport(self, window: Window) -> None:
        """(private API)"""
        pass
    # void        MouseSetViewportID(ImGuiID viewport_id);    /* original C++ signature */
    def mouse_set_viewport_id(self, viewport_id: ID) -> None:
        """(private API)"""
        pass
    # Keyboard inputs
    # void        KeyDown(ImGuiKeyChord key_chord);    /* original C++ signature */
    def key_down(self, key_chord: KeyChord) -> None:
        """(private API)"""
        pass
    # void        KeyUp(ImGuiKeyChord key_chord);    /* original C++ signature */
    def key_up(self, key_chord: KeyChord) -> None:
        """(private API)"""
        pass
    # void        KeyPress(ImGuiKeyChord key_chord, int count = 1);    /* original C++ signature */
    def key_press(self, key_chord: KeyChord, count: int = 1) -> None:
        """(private API)"""
        pass
    # void        KeyHold(ImGuiKeyChord key_chord, float time);    /* original C++ signature */
    def key_hold(self, key_chord: KeyChord, time: float) -> None:
        """(private API)"""
        pass
    # void        KeySetEx(ImGuiKeyChord key_chord, bool is_down, float time);    /* original C++ signature */
    def key_set_ex(self, key_chord: KeyChord, is_down: bool, time: float) -> None:
        """(private API)"""
        pass
    # void        KeyChars(const char* chars);                    /* original C++ signature */
    def key_chars(self, chars: str) -> None:
        """(private API)

        Input characters
        """
        pass
    # void        KeyCharsAppend(const char* chars);              /* original C++ signature */
    def key_chars_append(self, chars: str) -> None:
        """(private API)

        Input characters at end of field
        """
        pass
    # void        KeyCharsAppendEnter(const char* chars);         /* original C++ signature */
    def key_chars_append_enter(self, chars: str) -> None:
        """(private API)

        Input characters at end of field, press Enter
        """
        pass
    # void        KeyCharsReplace(const char* chars);             /* original C++ signature */
    def key_chars_replace(self, chars: str) -> None:
        """(private API)

        Delete existing field then input characters
        """
        pass
    # void        KeyCharsReplaceEnter(const char* chars);        /* original C++ signature */
    def key_chars_replace_enter(self, chars: str) -> None:
        """(private API)

        Delete existing field then input characters, press Enter
        """
        pass
    # Navigation inputs
    # FIXME: Need some redesign/refactoring:
    # - This was initially intended to: replace mouse action with keyboard/gamepad
    # - Abstract keyboard vs gamepad actions
    # However this is widely inconsistent and unfinished at this point.
    # void        SetInputMode(ImGuiInputSource input_mode);      /* original C++ signature */
    def set_input_mode(self, input_mode: InputSource) -> None:
        """(private API)

        Mouse or Keyboard or Gamepad. In Keyboard or Gamepad mode, actions such as ItemClick or ItemInput are using nav facilities instead of Mouse.
        """
        pass
    # void        NavMoveTo(ImGuiTestRef ref);    /* original C++ signature */
    def nav_move_to(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        NavActivate();                                  /* original C++ signature */
    def nav_activate(self) -> None:
        """(private API)

        Activate current selected item: activate button, tweak sliders/drags. Equivalent of pressing Space on keyboard, ImGuiKey_GamepadFaceUp on a gamepad.
        """
        pass
    # void        NavInput();                                     /* original C++ signature */
    def nav_input(self) -> None:
        """(private API)

        Input into select item: input sliders/drags. Equivalent of pressing Enter on keyboard, ImGuiKey_GamepadFaceDown on a gamepad.
        """
        pass
    # void        ScrollTo(ImGuiTestRef ref, ImGuiAxis axis, float scroll_v, ImGuiTestOpFlags flags = ImGuiTestOpFlags_None);    /* original C++ signature */
    def scroll_to(
        self, ref: Union[TestRef, str], axis: Axis, scroll_v: float, flags: TestOpFlags = TestOpFlags_None
    ) -> None:
        """Scrolling
        (private API)
        """
        pass
    # void        ScrollToX(ImGuiTestRef ref, float scroll_x) { ScrollTo(ref, ImGuiAxis_X, scroll_x); }    /* original C++ signature */
    def scroll_to_x(self, ref: Union[TestRef, str], scroll_x: float) -> None:
        """(private API)"""
        pass
    # void        ScrollToY(ImGuiTestRef ref, float scroll_y) { ScrollTo(ref, ImGuiAxis_Y, scroll_y); }    /* original C++ signature */
    def scroll_to_y(self, ref: Union[TestRef, str], scroll_y: float) -> None:
        """(private API)"""
        pass
    # void        ScrollToTop(ImGuiTestRef ref);    /* original C++ signature */
    def scroll_to_top(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        ScrollToBottom(ImGuiTestRef ref);    /* original C++ signature */
    def scroll_to_bottom(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        ScrollToItem(ImGuiTestRef ref, ImGuiAxis axis, ImGuiTestOpFlags flags = ImGuiTestOpFlags_None);    /* original C++ signature */
    def scroll_to_item(self, ref: Union[TestRef, str], axis: Axis, flags: TestOpFlags = TestOpFlags_None) -> None:
        """(private API)"""
        pass
    # void        ScrollToItemX(ImGuiTestRef ref);    /* original C++ signature */
    def scroll_to_item_x(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        ScrollToItemY(ImGuiTestRef ref);    /* original C++ signature */
    def scroll_to_item_y(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        ScrollToTabItem(ImGuiTabBar* tab_bar, ImGuiID tab_id);    /* original C++ signature */
    def scroll_to_tab_item(self, tab_bar: TabBar, tab_id: ID) -> None:
        """(private API)"""
        pass
    # bool        ScrollErrorCheck(ImGuiAxis axis, float expected, float actual, int* remaining_attempts);    /* original C++ signature */
    def scroll_error_check(
        self, axis: Axis, expected: float, actual: float, remaining_attempts: int
    ) -> Tuple[bool, int]:
        """(private API)"""
        pass
    # void        ScrollVerifyScrollMax(ImGuiTestRef ref);    /* original C++ signature */
    def scroll_verify_scroll_max(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # Low-level queries
    # - ItemInfo queries never returns a None pointer, instead they return an empty instance (info->IsEmpty(), info->ID == 0) and set contexted as errored.
    # - You can use ImGuiTestOpFlags_NoError to do a query without marking context as errored. This is what ItemExists() does.
    # ImGuiTestItemInfo   ItemInfo(ImGuiTestRef ref, ImGuiTestOpFlags flags = ImGuiTestOpFlags_None);    /* original C++ signature */
    def item_info(self, ref: Union[TestRef, str], flags: TestOpFlags = TestOpFlags_None) -> TestItemInfo:
        """(private API)"""
        pass
    # ImGuiTestItemInfo   ItemInfoOpenFullPath(ImGuiTestRef ref, ImGuiTestOpFlags flags = ImGuiTestOpFlags_None);    /* original C++ signature */
    def item_info_open_full_path(self, ref: Union[TestRef, str], flags: TestOpFlags = TestOpFlags_None) -> TestItemInfo:
        """(private API)"""
        pass
    # ImGuiID             ItemInfoHandleWildcardSearch(const char* wildcard_prefix_start, const char* wildcard_prefix_end, const char* wildcard_suffix_start);    /* original C++ signature */
    def item_info_handle_wildcard_search(
        self, wildcard_prefix_start: str, wildcard_prefix_end: str, wildcard_suffix_start: str
    ) -> ID:
        """(private API)"""
        pass
    # ImGuiTestItemInfo   ItemInfoNull() { return ImGuiTestItemInfo(); }    /* original C++ signature */
    def item_info_null(self) -> TestItemInfo:
        """(private API)"""
        pass
    # void                GatherItems(ImGuiTestItemList* out_list, ImGuiTestRef parent, int depth = -1);    /* original C++ signature */
    def gather_items(self, out_list: TestItemList, parent: Union[TestRef, str], depth: int = -1) -> None:
        """(private API)"""
        pass
    # void        ItemAction(ImGuiTestAction action, ImGuiTestRef ref, ImGuiTestOpFlags flags = 0, void* action_arg = NULL);    /* original C++ signature */
    def item_action(
        self, action: TestAction, ref: Union[TestRef, str], flags: TestOpFlags = 0, action_arg: Optional[Any] = None
    ) -> None:
        """Item/Widgets manipulation
        (private API)
        """
        pass
    # void        ItemClick(ImGuiTestRef ref, ImGuiMouseButton button = 0, ImGuiTestOpFlags flags = 0) { ItemAction(ImGuiTestAction_Click, ref, flags, (void*)(size_t)button); }    /* original C++ signature */
    def item_click(self, ref: Union[TestRef, str], button: MouseButton = 0, flags: TestOpFlags = 0) -> None:
        """(private API)"""
        pass
    # void        ItemDoubleClick(ImGuiTestRef ref, ImGuiTestOpFlags flags = 0)           { ItemAction(ImGuiTestAction_DoubleClick, ref, flags); }    /* original C++ signature */
    def item_double_click(self, ref: Union[TestRef, str], flags: TestOpFlags = 0) -> None:
        """(private API)"""
        pass
    # void        ItemCheck(ImGuiTestRef ref, ImGuiTestOpFlags flags = 0)                 { ItemAction(ImGuiTestAction_Check, ref, flags); }    /* original C++ signature */
    def item_check(self, ref: Union[TestRef, str], flags: TestOpFlags = 0) -> None:
        """(private API)"""
        pass
    # void        ItemUncheck(ImGuiTestRef ref, ImGuiTestOpFlags flags = 0)               { ItemAction(ImGuiTestAction_Uncheck, ref, flags); }    /* original C++ signature */
    def item_uncheck(self, ref: Union[TestRef, str], flags: TestOpFlags = 0) -> None:
        """(private API)"""
        pass
    # void        ItemOpen(ImGuiTestRef ref, ImGuiTestOpFlags flags = 0)                  { ItemAction(ImGuiTestAction_Open, ref, flags); }    /* original C++ signature */
    def item_open(self, ref: Union[TestRef, str], flags: TestOpFlags = 0) -> None:
        """(private API)"""
        pass
    # void        ItemClose(ImGuiTestRef ref, ImGuiTestOpFlags flags = 0)                 { ItemAction(ImGuiTestAction_Close, ref, flags); }    /* original C++ signature */
    def item_close(self, ref: Union[TestRef, str], flags: TestOpFlags = 0) -> None:
        """(private API)"""
        pass
    # void        ItemInput(ImGuiTestRef ref, ImGuiTestOpFlags flags = 0)                 { ItemAction(ImGuiTestAction_Input, ref, flags); }    /* original C++ signature */
    def item_input(self, ref: Union[TestRef, str], flags: TestOpFlags = 0) -> None:
        """(private API)"""
        pass
    # void        ItemNavActivate(ImGuiTestRef ref, ImGuiTestOpFlags flags = 0)           { ItemAction(ImGuiTestAction_NavActivate, ref, flags); }    /* original C++ signature */
    def item_nav_activate(self, ref: Union[TestRef, str], flags: TestOpFlags = 0) -> None:
        """(private API)"""
        pass
    # Item/Widgets: Batch actions over an entire scope
    # void        ItemActionAll(ImGuiTestAction action, ImGuiTestRef ref_parent, const ImGuiTestActionFilter* filter = NULL);    /* original C++ signature */
    def item_action_all(
        self, action: TestAction, ref_parent: Union[TestRef, str], filter: Optional[TestActionFilter] = None
    ) -> None:
        """(private API)"""
        pass
    # void        ItemOpenAll(ImGuiTestRef ref_parent, int depth = -1, int passes = -1);    /* original C++ signature */
    def item_open_all(self, ref_parent: Union[TestRef, str], depth: int = -1, passes: int = -1) -> None:
        """(private API)"""
        pass
    # void        ItemCloseAll(ImGuiTestRef ref_parent, int depth = -1, int passes = -1);    /* original C++ signature */
    def item_close_all(self, ref_parent: Union[TestRef, str], depth: int = -1, passes: int = -1) -> None:
        """(private API)"""
        pass
    # Item/Widgets: Helpers to easily set a value
    # void        ItemInputValue(ImGuiTestRef ref, int v);    /* original C++ signature */
    @overload
    def item_input_value(self, ref: Union[TestRef, str], v: int) -> None:
        """(private API)"""
        pass
    # void        ItemInputValue(ImGuiTestRef ref, float f);    /* original C++ signature */
    @overload
    def item_input_value(self, ref: Union[TestRef, str], f: float) -> None:
        """(private API)"""
        pass
    # void        ItemInputValue(ImGuiTestRef ref, const char* str);    /* original C++ signature */
    @overload
    def item_input_value(self, ref: Union[TestRef, str], str: str) -> None:
        """(private API)"""
        pass
    # Item/Widgets: Helpers to easily read a value by selecting Slider/Drag/Input text, copying into clipboard and parsing it.
    # - This requires the item to be selectable (we will later provide helpers that works in more general manner)
    # - Original clipboard value is restored afterward.
    # bool        ItemSelectAndReadValue(ImGuiTestRef ref, ImGuiDataType data_type, void* out_data, ImGuiTestOpFlags flags = ImGuiTestOpFlags_None);    /* original C++ signature */
    @overload
    def item_select_and_read_value(
        self, ref: Union[TestRef, str], data_type: DataType, out_data: Any, flags: TestOpFlags = TestOpFlags_None
    ) -> bool:
        """(private API)"""
        pass
    # void        ItemSelectAndReadValue(ImGuiTestRef ref, int* out_v);    /* original C++ signature */
    @overload
    def item_select_and_read_value(self, ref: Union[TestRef, str], out_v: int) -> int:
        """(private API)"""
        pass
    # void        ItemSelectAndReadValue(ImGuiTestRef ref, float* out_v);    /* original C++ signature */
    @overload
    def item_select_and_read_value(self, ref: Union[TestRef, str], out_v: float) -> float:
        """(private API)"""
        pass
    # Item/Widgets: Status query
    # bool        ItemExists(ImGuiTestRef ref);    /* original C++ signature */
    def item_exists(self, ref: Union[TestRef, str]) -> bool:
        """(private API)"""
        pass
    # bool        ItemIsChecked(ImGuiTestRef ref);    /* original C++ signature */
    def item_is_checked(self, ref: Union[TestRef, str]) -> bool:
        """(private API)"""
        pass
    # bool        ItemIsOpened(ImGuiTestRef ref);    /* original C++ signature */
    def item_is_opened(self, ref: Union[TestRef, str]) -> bool:
        """(private API)"""
        pass
    # void        ItemVerifyCheckedIfAlive(ImGuiTestRef ref, bool checked);    /* original C++ signature */
    def item_verify_checked_if_alive(self, ref: Union[TestRef, str], checked: bool) -> None:
        """(private API)"""
        pass
    # Item/Widgets: Drag and Mouse operations
    # void        ItemHold(ImGuiTestRef ref, float time);    /* original C++ signature */
    def item_hold(self, ref: Union[TestRef, str], time: float) -> None:
        """(private API)"""
        pass
    # void        ItemHoldForFrames(ImGuiTestRef ref, int frames);    /* original C++ signature */
    def item_hold_for_frames(self, ref: Union[TestRef, str], frames: int) -> None:
        """(private API)"""
        pass
    # void        ItemDragOverAndHold(ImGuiTestRef ref_src, ImGuiTestRef ref_dst);    /* original C++ signature */
    def item_drag_over_and_hold(self, ref_src: Union[TestRef, str], ref_dst: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        ItemDragAndDrop(ImGuiTestRef ref_src, ImGuiTestRef ref_dst, ImGuiMouseButton button = 0);    /* original C++ signature */
    def item_drag_and_drop(
        self, ref_src: Union[TestRef, str], ref_dst: Union[TestRef, str], button: MouseButton = 0
    ) -> None:
        """(private API)"""
        pass
    # void        ItemDragWithDelta(ImGuiTestRef ref_src, ImVec2 pos_delta);    /* original C++ signature */
    def item_drag_with_delta(self, ref_src: Union[TestRef, str], pos_delta: ImVec2Like) -> None:
        """(private API)"""
        pass
    # Helpers for Tab Bars widgets
    # void        TabClose(ImGuiTestRef ref);    /* original C++ signature */
    def tab_close(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # Helpers for MenuBar and Menus widgets
    # - e.g. MenuCheck("File/Options/Enable grid");
    # void        MenuAction(ImGuiTestAction action, ImGuiTestRef ref);    /* original C++ signature */
    def menu_action(self, action: TestAction, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        MenuActionAll(ImGuiTestAction action, ImGuiTestRef ref_parent);    /* original C++ signature */
    def menu_action_all(self, action: TestAction, ref_parent: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        MenuClick(ImGuiTestRef ref)                 { MenuAction(ImGuiTestAction_Click, ref); }    /* original C++ signature */
    def menu_click(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        MenuCheck(ImGuiTestRef ref)                 { MenuAction(ImGuiTestAction_Check, ref); }    /* original C++ signature */
    def menu_check(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        MenuUncheck(ImGuiTestRef ref)               { MenuAction(ImGuiTestAction_Uncheck, ref); }    /* original C++ signature */
    def menu_uncheck(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        MenuCheckAll(ImGuiTestRef ref_parent)       { MenuActionAll(ImGuiTestAction_Check, ref_parent); }    /* original C++ signature */
    def menu_check_all(self, ref_parent: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        MenuUncheckAll(ImGuiTestRef ref_parent)     { MenuActionAll(ImGuiTestAction_Uncheck, ref_parent); }    /* original C++ signature */
    def menu_uncheck_all(self, ref_parent: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # Helpers for Combo Boxes
    # void        ComboClick(ImGuiTestRef ref);    /* original C++ signature */
    def combo_click(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # void        ComboClickAll(ImGuiTestRef ref);    /* original C++ signature */
    def combo_click_all(self, ref: Union[TestRef, str]) -> None:
        """(private API)"""
        pass
    # Helpers for Tables
    # void                        TableOpenContextMenu(ImGuiTestRef ref, int column_n = -1);    /* original C++ signature */
    def table_open_context_menu(self, ref: Union[TestRef, str], column_n: int = -1) -> None:
        """(private API)"""
        pass
    # ImGuiSortDirection          TableClickHeader(ImGuiTestRef ref, const char* label, ImGuiKeyChord key_mods = 0);    /* original C++ signature */
    def table_click_header(self, ref: Union[TestRef, str], label: str, key_mods: KeyChord = 0) -> SortDirection:
        """(private API)"""
        pass
    # void                        TableSetColumnEnabled(ImGuiTestRef ref, const char* label, bool enabled);    /* original C++ signature */
    def table_set_column_enabled(self, ref: Union[TestRef, str], label: str, enabled: bool) -> None:
        """(private API)"""
        pass
    # void                        TableResizeColumn(ImGuiTestRef ref, int column_n, float width);    /* original C++ signature */
    def table_resize_column(self, ref: Union[TestRef, str], column_n: int, width: float) -> None:
        """(private API)"""
        pass
    # const ImGuiTableSortSpecs*  TableGetSortSpecs(ImGuiTestRef ref);    /* original C++ signature */
    def table_get_sort_specs(self, ref: Union[TestRef, str]) -> TableSortSpecs:
        """(private API)"""
        pass
    # Viewports
    # IMPORTANT: Those function may alter Platform state (unless using the "Mock Viewport" backend). Use carefully.
    # Those are mostly useful to simulate OS actions and testing of viewport-specific features, may not be useful to most users.

    # Docking
    #                                                  #ifdef IMGUI_HAS_DOCK
    #
    # void        DockClear(const char* window_name, ...);    /* original C++ signature */
    def dock_clear(self, window_name: str) -> None:
        """(private API)"""
        pass
    # void        DockInto(ImGuiTestRef src_id, ImGuiTestRef dst_id, ImGuiDir split_dir = ImGuiDir_None, bool is_outer_docking = false, ImGuiTestOpFlags flags = 0);    /* original C++ signature */
    def dock_into(
        self,
        src_id: Union[TestRef, str],
        dst_id: Union[TestRef, str],
        split_dir: Optional[Dir] = None,
        is_outer_docking: bool = False,
        flags: TestOpFlags = 0,
    ) -> None:
        """---
        Python bindings defaults:
            If split_dir is None, then its default value will be: Dir_None
        (private API)
        """
        pass
    # void        UndockNode(ImGuiID dock_id);    /* original C++ signature */
    def undock_node(self, dock_id: ID) -> None:
        """(private API)"""
        pass
    # void        UndockWindow(const char* window_name);    /* original C++ signature */
    def undock_window(self, window_name: str) -> None:
        """(private API)"""
        pass
    # bool        WindowIsUndockedOrStandalone(ImGuiWindow* window);    /* original C++ signature */
    def window_is_undocked_or_standalone(self, window: Window) -> bool:
        """(private API)"""
        pass
    # bool        DockIdIsUndockedOrStandalone(ImGuiID dock_id);    /* original C++ signature */
    def dock_id_is_undocked_or_standalone(self, dock_id: ID) -> bool:
        """(private API)"""
        pass
    # void        DockNodeHideTabBar(ImGuiDockNode* node, bool hidden);    /* original C++ signature */
    def dock_node_hide_tab_bar(self, node: DockNode, hidden: bool) -> None:
        """(private API)"""
        pass
    #                                                  #endif
    #

    # Performances Measurement (use along with Dear ImGui Perf Tool)
    # void        PerfCalcRef();    /* original C++ signature */
    def perf_calc_ref(self) -> None:
        """(private API)"""
        pass
    # void        PerfCapture(const char* category = NULL, const char* test_name = NULL, const char* csv_file = NULL);    /* original C++ signature */
    def perf_capture(
        self, category: Optional[str] = None, test_name: Optional[str] = None, csv_file: Optional[str] = None
    ) -> None:
        """(private API)"""
        pass
    # Obsolete functions

    # [Internal]
    # void        _MakeAimingSpaceOverPos(ImGuiViewport* viewport, ImGuiWindow* over_window, const ImVec2& over_pos);     /* original C++ signature */
    def _make_aiming_space_over_pos(self, viewport: Viewport, over_window: Window, over_pos: ImVec2Like) -> None:
        """(private API)

        Move windows covering 'window' at pos.
        """
        pass
    # void        _ForeignWindowsUnhideAll();                                                    /* original C++ signature */
    def _foreign_windows_unhide_all(self) -> None:
        """(private API)

        FIXME: Aim to remove this system...
        """
        pass
    # ImGuiTestContext(ImGuiTestGenericVars GenericVars = ImGuiTestGenericVars(), ImGuiTestOpFlags OpFlags = ImGuiTestOpFlags_None, int PerfStressAmount = 0, int FrameCount = 0, int FirstTestFrameCount = 0, bool FirstGuiFrame = false, bool HasDock = false, ImGuiTestRunFlags RunFlags = ImGuiTestRunFlags_None, ImGuiTestActiveFunc ActiveFunc = ImGuiTestActiveFunc_None, double RunningTime = 0.0, int ActionDepth = 0, int CaptureCounter = 0, int ErrorCounter = 0, bool Abort = false, double PerfRefDt = -1.0, int PerfIterations = 400, ImGuiID RefID = 0, ImGuiID RefWindowID = 0, ImGuiInputSource InputMode = ImGuiInputSource_Mouse, ImVector<char> Clipboard = ImVector<char>(), ImVector<ImGuiWindow*> ForeignWindowsToHide = ImVector<ImGuiWindow*>(), ImGuiTestItemInfo DummyItemInfoNull = ImGuiTestItemInfo(), bool CachedLinesPrintedToTTY = false);    /* original C++ signature */
    def __init__(
        self,
        generic_vars: Optional[TestGenericVars] = None,
        op_flags: TestOpFlags = TestOpFlags_None,
        perf_stress_amount: int = 0,
        frame_count: int = 0,
        first_test_frame_count: int = 0,
        first_gui_frame: bool = False,
        has_dock: bool = False,
        run_flags: TestRunFlags = TestRunFlags_None,
        active_func: TestActiveFunc = TestActiveFunc_None,
        running_time: float = 0.0,
        action_depth: int = 0,
        capture_counter: int = 0,
        error_counter: int = 0,
        abort: bool = False,
        perf_ref_dt: float = -1.0,
        perf_iterations: int = 400,
        ref_id: ID = 0,
        ref_window_id: ID = 0,
        input_mode: Optional[InputSource] = None,
        clipboard: Optional[ImVector_int] = None,
        foreign_windows_to_hide: Optional[ImVector_Window] = None,
        dummy_item_info_null: Optional[TestItemInfo] = None,
        cached_lines_printed_to_tty: bool = False,
    ) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                GenericVars: TestGenericVars()
                InputMode: InputSource_Mouse
                Clipboard: ImVector_char()
                ForeignWindowsToHide: ImVector_Window_ptr()
                DummyItemInfoNull: TestItemInfo()
        """
        pass

# -------------------------------------------------------------------------
# [SECTION] Debugging macros (IM_SUSPEND_TESTFUNC)
# -------------------------------------------------------------------------

# -------------------------------------------------------------------------
# [SECTION] Testing/Checking macros: IM_CHECK(), IM_ERRORF() etc.
# -------------------------------------------------------------------------

# Helpers used by IM_CHECK_OP() macros.
# ImGuiTestEngine_GetTempStringBuilder() returns a shared instance of ImGuiTextBuffer to recycle memory allocations

# We embed every macro in a do {} while(0) statement as a trick to allow using them as regular single statement, e.g. if (XXX) IM_CHECK(A); else IM_CHECK(B)
# We leave the IM_DEBUG_BREAK() outside of the check function to step out faster when using a debugger. It also has the benefit of being lighter than an IM_ASSERT().

# Scalar compares

# Scalar compares, without return on failure

# String compares

# Floating point compares

# -------------------------------------------------------------------------

####################    </generated_from:imgui_te_context.h>    ####################

####################    <generated_from:imgui_te_internal.h>    ####################
# dear imgui test engine
# (internal api)

# -------------------------------------------------------------------------
# FORWARD DECLARATIONS
# -------------------------------------------------------------------------

# -------------------------------------------------------------------------
# DATA STRUCTURES
# -------------------------------------------------------------------------

class TestInfoTask:
    """Query item position/window/state given ID."""

    # Input
    # ImGuiID                 ID = 0;    /* original C++ signature */
    id_: ID = 0
    # int                     FrameCount = -1;    /* original C++ signature */
    frame_count: int = -1  # Timestamp of request

    # ImGuiTestItemInfo       Result;    /* original C++ signature */
    # Output
    result: TestItemInfo
    # ImGuiTestInfoTask(ImGuiID ID = 0, int FrameCount = -1, ImGuiTestItemInfo Result = ImGuiTestItemInfo());    /* original C++ signature */
    def __init__(self, id_: ID = 0, frame_count: int = -1, result: Optional[TestItemInfo] = None) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If Result is None, then its default value will be: TestItemInfo()
        """
        pass

class TestGatherTask:
    """Gather item list in given parent ID."""

    # Input
    # ImGuiID                 InParentID = 0;    /* original C++ signature */
    in_parent_id: ID = 0
    # int                     InMaxDepth = 0;    /* original C++ signature */
    in_max_depth: int = 0
    # short                   InLayerMask = 0;    /* original C++ signature */
    in_layer_mask: int = 0

    # Output/Temp
    # ImGuiTestItemList*      OutList = NULL;    /* original C++ signature */
    out_list: TestItemList = None
    # ImGuiTestItemInfo*      LastItemInfo = NULL;    /* original C++ signature */
    last_item_info: TestItemInfo = None

    # void Clear() { memset(this, 0, sizeof(*this)); }    /* original C++ signature */
    def clear(self) -> None:
        """(private API)"""
        pass
    # ImGuiTestGatherTask(ImGuiID InParentID = 0, int InMaxDepth = 0, short InLayerMask = 0);    /* original C++ signature */
    def __init__(self, in_parent_id: ID = 0, in_max_depth: int = 0, in_layer_mask: int = 0) -> None:
        """Auto-generated default constructor with named params"""
        pass

class TestFindByLabelTask:
    """Find item ID given a label and a parent id
    Usually used by queries with wildcards such as ItemInfo("hello/**/foo/bar")
    """

    # Input
    # ImGuiID                 InPrefixId = 0;    /* original C++ signature */
    in_prefix_id: ID = (
        0  # A known base ID which appears BEFORE the wildcard ID (for "hello/**/foo/bar" it would be hash of "hello")
    )
    # int                     InSuffixDepth = 0;    /* original C++ signature */
    in_suffix_depth: int = 0  # Number of labels in a path, after unknown base ID (for "hello/**/foo/bar" it would be 2)
    # const char*             InSuffix = NULL;    /* original C++ signature */
    in_suffix: str = (
        None  # A label string which appears on ID stack after unknown base ID (for "hello/**/foo/bar" it would be "foo/bar") # (const)
    )
    # const char*             InSuffixLastItem = NULL;    /* original C++ signature */
    in_suffix_last_item: str = None  # A last label string (for "hello/**/foo/bar" it would be "bar") # (const)
    # ImGuiID                 InSuffixLastItemHash = 0;    /* original C++ signature */
    in_suffix_last_item_hash: ID = 0
    # ImGuiItemStatusFlags    InFilterItemStatusFlags = 0;    /* original C++ signature */
    in_filter_item_status_flags: ItemStatusFlags = 0  # Flags required for item to be returned

    # Output
    # ImGuiID                 OutItemId = 0;    /* original C++ signature */
    out_item_id: ID = 0  # Result item ID
    # ImGuiTestFindByLabelTask(ImGuiID InPrefixId = 0, int InSuffixDepth = 0, ImGuiID InSuffixLastItemHash = 0, ImGuiItemStatusFlags InFilterItemStatusFlags = 0, ImGuiID OutItemId = 0);    /* original C++ signature */
    def __init__(
        self,
        in_prefix_id: ID = 0,
        in_suffix_depth: int = 0,
        in_suffix_last_item_hash: ID = 0,
        in_filter_item_status_flags: ItemStatusFlags = 0,
        out_item_id: ID = 0,
    ) -> None:
        """Auto-generated default constructor with named params"""
        pass

class TestInputType(enum.Enum):
    # ImGuiTestInputType_None,    /* original C++ signature */
    none = enum.auto()  # (= 0)
    # ImGuiTestInputType_Key,    /* original C++ signature */
    key = enum.auto()  # (= 1)
    # ImGuiTestInputType_Char,    /* original C++ signature */
    char = enum.auto()  # (= 2)
    # ImGuiTestInputType_ViewportFocus,    /* original C++ signature */
    viewport_focus = enum.auto()  # (= 3)
    # ImGuiTestInputType_ViewportSetPos,    /* original C++ signature */
    viewport_set_pos = enum.auto()  # (= 4)
    # ImGuiTestInputType_ViewportSetSize,    /* original C++ signature */
    viewport_set_size = enum.auto()  # (= 5)
    # ImGuiTestInputType_ViewportClose    /* original C++ signature */
    # }
    viewport_close = enum.auto()  # (= 6)

class TestInput:
    """FIXME: May want to strip further now that core imgui is using its own input queue"""

    # ImGuiTestInputType      Type = ImGuiTestInputType_None;    /* original C++ signature */
    type: TestInputType = TestInputType_None
    # ImGuiKeyChord           KeyChord = ImGuiKey_None;    /* original C++ signature */
    key_chord: KeyChord = Key_None
    # ImWchar                 Char = 0;    /* original C++ signature */
    char: ImWchar = 0
    # bool                    Down = false;    /* original C++ signature */
    down: bool = False
    # ImGuiID                 ViewportId = 0;    /* original C++ signature */
    viewport_id: ID = 0
    # ImVec2                  ViewportPosSize;    /* original C++ signature */
    viewport_pos_size: ImVec2

    # static ImGuiTestInput   ForKeyChord(ImGuiKeyChord key_chord, bool down)    /* original C++ signature */
    #     {
    #         ImGuiTestInput inp;
    #         inp.Type = ImGuiTestInputType_Key;
    #         inp.KeyChord = key_chord;
    #         inp.Down = down;
    #         return inp;
    #     }
    @staticmethod
    def for_key_chord(key_chord: KeyChord, down: bool) -> TestInput:
        """(private API)"""
        pass
    # static ImGuiTestInput   ForChar(ImWchar v)    /* original C++ signature */
    #     {
    #         ImGuiTestInput inp;
    #         inp.Type = ImGuiTestInputType_Char;
    #         inp.Char = v;
    #         return inp;
    #     }
    @staticmethod
    def for_char(v: ImWchar) -> TestInput:
        """(private API)"""
        pass
    # static ImGuiTestInput   ForViewportFocus(ImGuiID viewport_id)    /* original C++ signature */
    #     {
    #         ImGuiTestInput inp;
    #         inp.Type = ImGuiTestInputType_ViewportFocus;
    #         inp.ViewportId = viewport_id;
    #         return inp;
    #     }
    @staticmethod
    def for_viewport_focus(viewport_id: ID) -> TestInput:
        """(private API)"""
        pass
    # static ImGuiTestInput   ForViewportSetPos(ImGuiID viewport_id, const ImVec2& pos)    /* original C++ signature */
    #     {
    #         ImGuiTestInput inp;
    #         inp.Type = ImGuiTestInputType_ViewportSetPos;
    #         inp.ViewportId = viewport_id;
    #         inp.ViewportPosSize = pos;
    #         return inp;
    #     }
    @staticmethod
    def for_viewport_set_pos(viewport_id: ID, pos: ImVec2Like) -> TestInput:
        """(private API)"""
        pass
    # static ImGuiTestInput   ForViewportSetSize(ImGuiID viewport_id, const ImVec2& size)    /* original C++ signature */
    #     {
    #         ImGuiTestInput inp;
    #         inp.Type = ImGuiTestInputType_ViewportSetSize;
    #         inp.ViewportId = viewport_id;
    #         inp.ViewportPosSize = size;
    #         return inp;
    #     }
    @staticmethod
    def for_viewport_set_size(viewport_id: ID, size: ImVec2Like) -> TestInput:
        """(private API)"""
        pass
    # static ImGuiTestInput   ForViewportClose(ImGuiID viewport_id)    /* original C++ signature */
    #     {
    #         ImGuiTestInput inp;
    #         inp.Type = ImGuiTestInputType_ViewportClose;
    #         inp.ViewportId = viewport_id;
    #         return inp;
    #     }
    @staticmethod
    def for_viewport_close(viewport_id: ID) -> TestInput:
        """(private API)"""
        pass
    # ImGuiTestInput(ImGuiTestInputType Type = ImGuiTestInputType_None, ImGuiKeyChord KeyChord = ImGuiKey_None, ImWchar Char = 0, bool Down = false, ImGuiID ViewportId = 0, ImVec2 ViewportPosSize = ImVec2());    /* original C++ signature */
    def __init__(
        self,
        type: TestInputType = TestInputType_None,
        key_chord: Optional[KeyChord] = None,
        char: ImWchar = 0,
        down: bool = False,
        viewport_id: ID = 0,
        viewport_pos_size: Optional[ImVec2Like] = None,
    ) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                KeyChord: Key_None
                ViewportPosSize: ImVec2()
        """
        pass

class TestInputs:
    # ImVec2                      MousePosValue;    /* original C++ signature */
    mouse_pos_value: ImVec2  # Own non-rounded copy of MousePos in order facilitate simulating mouse movement very slow speed and high-framerate
    # ImVec2                      MouseWheel;    /* original C++ signature */
    mouse_wheel: ImVec2
    # ImGuiID                     MouseHoveredViewport = 0;    /* original C++ signature */
    mouse_hovered_viewport: ID = 0
    # int                         MouseButtonsValue = 0x00;    /* original C++ signature */
    mouse_buttons_value: int = 0x00  # FIXME-TESTS: Use simulated_io.MouseDown[] ?
    # bool                        HostEscDown = false;    /* original C++ signature */
    host_esc_down: bool = False
    # float                       HostEscDownDuration = -1.0f;    /* original C++ signature */
    host_esc_down_duration: float = -1.0  # Maintain our own DownDuration for host/backend ESC key so we can abort.
    # ImGuiTestInputs(ImVec2 MousePosValue = ImVec2(), ImVec2 MouseWheel = ImVec2(), ImGuiID MouseHoveredViewport = 0, int MouseButtonsValue = 0x00, bool HostEscDown = false, float HostEscDownDuration = -1.0f);    /* original C++ signature */
    def __init__(
        self,
        mouse_pos_value: Optional[ImVec2Like] = None,
        mouse_wheel: Optional[ImVec2Like] = None,
        mouse_hovered_viewport: ID = 0,
        mouse_buttons_value: int = 0x00,
        host_esc_down: bool = False,
        host_esc_down_duration: float = -1.0,
    ) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                MousePosValue: ImVec2()
                MouseWheel: ImVec2()
        """
        pass

class TestEngine:
    """[Internal] Test Engine Context"""

    # ImGuiTestEngineIO           IO;    /* original C++ signature */
    io: TestEngineIO
    # ImGuiContext*               UiContextTarget = NULL;    /* original C++ signature */
    ui_context_target: Context = None  # imgui context for testing
    # ImGuiContext*               UiContextActive = NULL;    /* original C++ signature */
    ui_context_active: Context = None  # imgui context for testing == UiContextTarget or None

    # bool                        Started = false;    /* original C++ signature */
    started: bool = False
    # ImU64                       BatchStartTime = 0;    /* original C++ signature */
    batch_start_time: ImU64 = 0
    # ImU64                       BatchEndTime = 0;    /* original C++ signature */
    batch_end_time: ImU64 = 0
    # int                         FrameCount = 0;    /* original C++ signature */
    frame_count: int = 0
    # float                       OverrideDeltaTime = -1.0f;    /* original C++ signature */
    override_delta_time: float = (
        -1.0
    )  # Inject custom delta time into imgui context to simulate clock passing faster than wall clock time.
    # ImGuiTestContext*           TestContext = NULL;    /* original C++ signature */
    test_context: TestContext = None  # Running test context
    # ImGuiTestGatherTask         GatherTask;    /* original C++ signature */
    gather_task: TestGatherTask
    # ImGuiTestFindByLabelTask    FindByLabelTask;    /* original C++ signature */
    find_by_label_task: TestFindByLabelTask

    # ImGuiTestInputs             Inputs;    /* original C++ signature */
    # Inputs
    inputs: TestInputs

    # UI support
    # bool                        Abort = false;    /* original C++ signature */
    abort: bool = False
    # ImGuiTest*                  UiSelectAndScrollToTest = NULL;    /* original C++ signature */
    ui_select_and_scroll_to_test: Test = None
    # ImGuiTest*                  UiSelectedTest = NULL;    /* original C++ signature */
    ui_selected_test: Test = None
    # bool                        UiMetricsOpen = false;    /* original C++ signature */
    ui_metrics_open: bool = False
    # bool                        UiDebugLogOpen = false;    /* original C++ signature */
    ui_debug_log_open: bool = False
    # bool                        UiCaptureToolOpen = false;    /* original C++ signature */
    ui_capture_tool_open: bool = False
    # bool                        UiStackToolOpen = false;    /* original C++ signature */
    ui_stack_tool_open: bool = False
    # bool                        UiPerfToolOpen = false;    /* original C++ signature */
    ui_perf_tool_open: bool = False
    # float                       UiLogHeight = 150.0f;    /* original C++ signature */
    ui_log_height: float = 150.0

    # Performance Monitor
    # double                      PerfRefDeltaTime;    /* original C++ signature */
    perf_ref_delta_time: float

    # Screen/Video Capturing

    # Tools
    # bool                        PostSwapCalled = false;    /* original C++ signature */
    post_swap_called: bool = False
    # bool                        ToolDebugRebootUiContext = false;    /* original C++ signature */
    tool_debug_reboot_ui_context: bool = False  # Completely shutdown and recreate the dear imgui context in place
    # bool                        ToolSlowDown = false;    /* original C++ signature */
    tool_slow_down: bool = False
    # int                         ToolSlowDownMs = 100;    /* original C++ signature */
    tool_slow_down_ms: int = 100
    # ImGuiTestRunSpeed           BackupConfigRunSpeed = ImGuiTestRunSpeed_Fast;    /* original C++ signature */
    backup_config_run_speed: TestRunSpeed = TestRunSpeed_Fast
    # bool                        BackupConfigNoThrottle = false;    /* original C++ signature */
    backup_config_no_throttle: bool = False

    # ImGuiTestEngine();    /* original C++ signature */
    def __init__(self) -> None:
        """Functions"""
        pass

# -------------------------------------------------------------------------
# INTERNAL FUNCTIONS
# -------------------------------------------------------------------------

# ImGuiTestItemInfo*  ImGuiTestEngine_FindItemInfo(ImGuiTestEngine* engine, ImGuiID id, const char* debug_id);    /* original C++ signature */
def find_item_info(engine: TestEngine, id_: ID, debug_id: str) -> TestItemInfo:
    """(private API)"""
    pass

# void                ImGuiTestEngine_Yield(ImGuiTestEngine* engine);    /* original C++ signature */
def yield_(engine: TestEngine) -> None:
    """(private API)"""
    pass

# void                ImGuiTestEngine_SetDeltaTime(ImGuiTestEngine* engine, float delta_time);    /* original C++ signature */
def set_delta_time(engine: TestEngine, delta_time: float) -> None:
    """(private API)"""
    pass

# int                 ImGuiTestEngine_GetFrameCount(ImGuiTestEngine* engine);    /* original C++ signature */
def get_frame_count(engine: TestEngine) -> int:
    """(private API)"""
    pass

# bool                ImGuiTestEngine_PassFilter(ImGuiTest* test, const char* filter);    /* original C++ signature */
def pass_filter(test: Test, filter: str) -> bool:
    """(private API)"""
    pass

# void                ImGuiTestEngine_RunTest(ImGuiTestEngine* engine, ImGuiTestContext* ctx, ImGuiTest* test, ImGuiTestRunFlags run_flags);    /* original C++ signature */
def run_test(engine: TestEngine, ctx: TestContext, test: Test, run_flags: TestRunFlags) -> None:
    """(private API)"""
    pass

# void                ImGuiTestEngine_RebootUiContext(ImGuiTestEngine* engine);    /* original C++ signature */
def reboot_ui_context(engine: TestEngine) -> None:
    """(private API)"""
    pass

# Screen/Video Capturing

# Helper functions
# const char*         ImGuiTestEngine_GetStatusName(ImGuiTestStatus v);    /* original C++ signature */
def get_status_name(v: TestStatus) -> str:
    """(private API)"""
    pass

# const char*         ImGuiTestEngine_GetRunSpeedName(ImGuiTestRunSpeed v);    /* original C++ signature */
def get_run_speed_name(v: TestRunSpeed) -> str:
    """(private API)"""
    pass

# const char*         ImGuiTestEngine_GetVerboseLevelName(ImGuiTestVerboseLevel v);    /* original C++ signature */
def get_verbose_level_name(v: TestVerboseLevel) -> str:
    """(private API)"""
    pass

# -------------------------------------------------------------------------
####################    </generated_from:imgui_te_internal.h>    ####################

####################    <generated_from:imgui_te_ui.h>    ####################
# dear imgui test engine
# (ui)
# If you run tests in an interactive or visible application, you may want to call ImGuiTestEngine_ShowTestEngineWindows()

# Provide access to:
# - "Dear ImGui Test Engine" main interface
# - "Dear ImGui Capture Tool"
# - "Dear ImGui Perf Tool"
# - other core debug functions: Metrics, Debug Log

# Functions
# IMGUI_API void  ImGuiTestEngine_ShowTestEngineWindows(ImGuiTestEngine* engine, bool* p_open);    /* original C++ signature */
def show_test_engine_windows(engine: TestEngine, p_open: bool) -> bool:
    pass

# IMGUI_API void  ImGuiTestEngine_OpenSourceFile(ImGuiTestEngine* engine, const char* source_filename, int source_line_no);    /* original C++ signature */
def open_source_file(engine: TestEngine, source_filename: str, source_line_no: int) -> None:
    pass

####################    </generated_from:imgui_te_ui.h>    ####################

# </litgen_stub> // Autogenerated code end!

class TestContext:  # noqa: F811
    @overload
    def set_ref(self, id: str) -> None:
        pass
