"""Spinners for ImGui
https://github.com/dalerank/imspinner
"""
# ruff: noqa: B008
import enum
import math
from typing import Tuple, Optional

from imgui_bundle.imgui import ImColor

IM_PI = math.pi
PI_DIV_4 = IM_PI / 4.
PI_DIV_2 = IM_PI / 2.
PI_2 = IM_PI * 2.

LeafColor = ImColor


# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:imspinner.h>    ####################
# #ifndef _IMSPINNER_H_
#

#
# * The MIT License (MIT)
# *
# * Copyright (c) 2021-2022 Dalerank
# *
# * Permission is hereby granted, free of charge, to any person obtaining a copy
# * of this software and associated documentation files (the "Software"), to deal
# * in the Software without restriction, including without limitation the rights
# * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# * copies of the Software, and to permit persons to whom the Software is
# * furnished to do so, subject to the following conditions:
# *
# * The above copyright notice and this permission notice shall be included in all
# * copies or substantial portions of the Software.
# *
# * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# * SOFTWARE.
# *
#



# imgui headers

white: ImColor  # = ImColor(1., 1., 1., 1.)
half_white: ImColor  # = ImColor(1., 1., 1., 0.5)
red: ImColor  # = ImColor(1., 0., 0., 1.)


class SpinnerTypeT(enum.Enum):
    e_st_rainbow = enum.auto()      # (= 0)
    e_st_angle = enum.auto()        # (= 1)
    e_st_dots = enum.auto()         # (= 2)
    e_st_ang = enum.auto()          # (= 3)
    e_st_vdots = enum.auto()        # (= 4)
    e_st_bounce_ball = enum.auto()  # (= 5)
    e_st_eclipse = enum.auto()      # (= 6)
    e_st_ingyang = enum.auto()      # (= 7)
    e_st_barchartsine = enum.auto() # (= 8)

    e_st_count = enum.auto()        # (= 9)

PI_DIV_4: float  # = IM_PI / 4.
PI_DIV_2: float  # = IM_PI / 2.
PI_2: float  # = IM_PI  2.




def color_alpha(c: ImColor, alpha: float) -> ImColor:
    pass

def damped_spring(
    mass: float,
    stiffness: float,
    damping: float,
    time: float,
    a: float = PI_DIV_2,
    b: float = PI_DIV_2
    ) -> float:
    pass

def damped_gravity(limtime: float) -> float:
    pass

def damped_trifolium(limtime: float, a: float = 0., b: float = 1.) -> float:
    pass

def damped_infinity(a: float, t: float) -> Tuple[float, float]:
    pass

def spinner_rainbow(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    ang_min: float = 0.,
    ang_max: float = PI_2,
    arcs: int = 1,
    mode: int = 0
    ) -> None:
    """
            const char *label: A string label for the spinner, used to identify it in ImGui.
            float radius: The radius of the spinner.
            float thickness: The thickness of the spinner's border.
            const ImColor &color: The color of the spinner.
            float speed: The speed of the spinning animation.
            float ang_min: Minimum angle of spinning.
            float ang_max: Maximum angle of spinning.
            int arcs: Number of arcs of the spinner.

    """
    pass


def spinner_rainbow_mix(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    ang_min: float = 0.,
    ang_max: float = PI_2,
    arcs: int = 1,
    mode: int = 0
    ) -> None:
    pass

def spinner_rotating_heart(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    ang_min: float = 0.
    ) -> None:
    """ This function draws a rotating heart spinner."""
    pass

def spinner_ang(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = IM_PI,
    mode: int = 0
    ) -> None:
    """ SpinnerAng is a function that draws a spinner widget with a given angle.
    ---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: white
    """
    pass



def spinner_ang_mix(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = IM_PI,
    arcs: int = 4,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_loading_ring(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    segments: int = 5
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: half_white
    """
    pass

def spinner_clock(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: half_white
    """
    pass

def spinner_pulsar(
    label: str,
    radius: float,
    thickness: float,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    sequence: bool = True,
    angle: float = 0.,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If bg is None, then its default value will be: half_white
    """
    pass

def spinner_double_fade_pulsar(
    label: str,
    radius: float,
    param_2: float,
    bg: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If bg is None, then its default value will be: half_white
    """
    pass

def spinner_twin_pulsar(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    rings: int = 2
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_fade_pulsar(
    label: str,
    radius: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    rings: int = 2
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_circular_lines(
    label: str,
    radius: float,
    color: Optional[ImColor] = None,
    speed: float = 1.8,
    lines: int = 8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_dots(
    label: str,
    nextdot: float,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 12,
    minth: float = -1.,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_v_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bgcolor: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 12,
    mdots: int = 6
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bgcolor: white
    """
    pass

def spinner_bounce_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 3,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_zip_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 5
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_dots_to_points(
    label: str,
    radius: float,
    thickness: float,
    offset_k: float,
    color: Optional[ImColor] = None,
    speed: float = 1.8,
    dots: int = 5
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass
#const float sina = ImSin( ImFmod((start + (IM_PI - i * offset)), PI_DIV_2));

def spinner_dots_to_bar(
    label: str,
    radius: float,
    thickness: float,
    offset_k: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 5
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_wave_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    lt: int = 8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_fade_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    lt: int = 8,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_three_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    lt: int = 8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_five_dots(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor = 0xffffffff,
    speed: float = 2.8,
    lt: int = 8
    ) -> None:
    pass

def spinner4_caleidospcope(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor = 0xffffffff,
    speed: float = 2.8,
    lt: int = 8
    ) -> None:
    pass

def spinner_multi_fade_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    lt: int = 8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_scale_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    lt: int = 8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_square_spins(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_moving_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 3
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_rotate_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 2,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_orion_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_galaxy_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_twin_ang(
    label: str,
    radius1: float,
    radius2: float,
    thickness: float,
    color1: Optional[ImColor] = None,
    color2: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = IM_PI,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color1: white
            color2: red
    """
    pass

def spinner_filling(
    label: str,
    radius: float,
    thickness: float,
    color1: Optional[ImColor] = None,
    color2: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color1: white
            color2: red
    """
    pass

def spinner_filling_mem(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    colorbg: ImColor,
    speed: float
    ) -> None:
    pass

def spinner_topup(
    label: str,
    radius1: float,
    radius2: float,
    color: Optional[ImColor] = None,
    fg: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: red
            fg: white
            bg: white
    """
    pass

def spinner_twin_ang180(
    label: str,
    radius1: float,
    radius2: float,
    thickness: float,
    color1: Optional[ImColor] = None,
    color2: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = PI_DIV_4,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color1: white
            color2: red
    """
    pass

def spinner_twin_ang360(
    label: str,
    radius1: float,
    radius2: float,
    thickness: float,
    color1: Optional[ImColor] = None,
    color2: Optional[ImColor] = None,
    speed1: float = 2.8,
    speed2: float = 2.5,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color1: white
            color2: red
    """
    pass

def spinner_inc_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 6
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_inc_full_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_fade_bars(
    label: str,
    w: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    bars: int = 3,
    scale: bool = False
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_fade_tris(
    label: str,
    radius: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dim: int = 2,
    scale: bool = False
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_bars_rotate_fade(
    label: str,
    rmin: float,
    rmax: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    bars: int = 6
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_bars_scale_middle(
    label: str,
    w: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    bars: int = 3
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_ang_twin(
    label: str,
    radius1: float,
    radius2: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = IM_PI,
    arcs: int = 1,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: half_white
    """
    pass

def spinner_arc_rotation(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_arc_fade(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_simple_arc_fade(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_square_stroke_fade(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_ascii_symbol_points(
    label: str,
    text: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_text_fading(
    label: str,
    text: str,
    radius: float,
    fsize: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_seven_segments(
    label: str,
    text: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_square_stroke_fill(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_square_stroke_loading(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_square_loading(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_filled_arc_fade(
    label: str,
    radius: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_points_arc_bounce(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    points: int = 4,
    circles: int = 2,
    rspeed: float = 0.
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_filled_arc_color(
    label: str,
    radius: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: red
            bg: white
    """
    pass

def spinner_filled_arc_ring(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: red
            bg: white
    """
    pass

def spinner_arc_wedges(
    label: str,
    radius: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: red
    """
    pass

def spinner_twin_ball(
    label: str,
    radius1: float,
    radius2: float,
    thickness: float,
    b_thickness: float,
    ball: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    balls: int = 2
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            ball: white
            bg: half_white
    """
    pass

def spinner_solar_balls(
    label: str,
    radius: float,
    thickness: float,
    ball: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    balls: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            ball: white
            bg: half_white
    """
    pass

def spinner_solar_scale_balls(
    label: str,
    radius: float,
    thickness: float,
    ball: Optional[ImColor] = None,
    speed: float = 2.8,
    balls: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If ball is None, then its default value will be: white
    """
    pass

def spinner_solar_arcs(
    label: str,
    radius: float,
    thickness: float,
    ball: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    balls: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            ball: white
            bg: half_white
    """
    pass

def spinner_moving_arcs(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_rainbow_circle(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4,
    mode: float = 1
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_bounce_ball(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 1,
    shadow: bool = False
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_pulsar_ball(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    shadow: bool = False,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_inc_scale_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 6,
    angle: float = 0.,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_some_scale_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    dots: int = 6,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_ang_triple(
    label: str,
    radius1: float,
    radius2: float,
    radius3: float,
    thickness: float,
    c1: Optional[ImColor] = None,
    c2: Optional[ImColor] = None,
    c3: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = IM_PI
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            c1: white
            c2: half_white
            c3: white
    """
    pass

def spinner_ang_eclipse(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = IM_PI
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_ing_yang(
    label: str,
    radius: float,
    thickness: float,
    reverse: bool,
    yang_detlta_r: float,
    color_i: Optional[ImColor] = None,
    color_y: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = math.pi * 0.7
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            colorI: white
            colorY: white
    """
    pass


def spinner_gooey_balls(
    label: str,
    radius: float,
    color: ImColor,
    speed: float,
    mode: int = 0
    ) -> None:
    pass

def spinner_dots_loading(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    bg: ImColor,
    speed: float
    ) -> None:
    pass

def spinner_rotate_gooey_balls(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    balls: int
    ) -> None:
    pass

def spinner_herbert_balls(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    balls: int
    ) -> None:
    pass

def spinner_herbert_balls3_d(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float
    ) -> None:
    pass

def spinner_rotate_triangles(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    tris: int
    ) -> None:
    pass

def spinner_rotate_shapes(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    shapes: int,
    pnt: int
    ) -> None:
    pass

def spinner_sin_squares(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float
    ) -> None:
    pass

def spinner_moon_line(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = IM_PI
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: red
    """
    pass

def spinner_circle_drop(
    label: str,
    radius: float,
    thickness: float,
    thickness_drop: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = IM_PI
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: half_white
    """
    pass

def spinner_surrounded_indicator(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: half_white
    """
    pass

def spinner_wifi_indicator(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    cangle: float = 0.,
    dots: int = 3
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: red
            bg: half_white
    """
    pass

def spinner_triangles_selector(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    bars: int = 8
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: half_white
    """
    pass


def spinner_flowing_gradient(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = IM_PI
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: red
    """
    pass

def spinner_rotate_segments(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4,
    layers: int = 1
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_lemniscate(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = IM_PI / 2.0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_rotate_gear(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    pins: int = 12
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_rotate_wheel(
    label: str,
    radius: float,
    thickness: float,
    bg_color: Optional[ImColor] = None,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    pins: int = 12
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            bg_color: white
            color: white
    """
    pass

def spinner_atom(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    elipses: int = 3
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_pattern_rings(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    elipses: int = 3
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_pattern_eclipse(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    elipses: int = 3,
    delta_a: float = 2.,
    delta_y: float = 0.
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_pattern_sphere(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    elipses: int = 3
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_ring_synchronous(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    elipses: int = 3
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_ring_watermarks(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    elipses: int = 3
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_rotated_atom(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    elipses: int = 3
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_rainbow_balls(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    balls: int = 5
    ) -> None:
    pass

def spinner_rainbow_shot(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    balls: int = 5
    ) -> None:
    pass

def spinner_spiral(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_spiral_eye(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_bar_chart_sine(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    bars: int = 5,
    mode: int = 0
    ) -> None:
    pass

def spinner_bar_chart_adv_sine(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    mode: int = 0
    ) -> None:
    pass

def spinner_bar_chart_adv_sine_fade(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    mode: int = 0
    ) -> None:
    pass

def spinner_bar_chart_rainbow(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    bars: int = 5
    ) -> None:
    pass

def spinner_blocks(
    label: str,
    radius: float,
    thickness: float,
    bg: ImColor,
    color: ImColor,
    speed: float
    ) -> None:
    pass

def spinner_twin_blocks(
    label: str,
    radius: float,
    thickness: float,
    bg: ImColor,
    color: ImColor,
    speed: float
    ) -> None:
    pass

def spinner_square_random_dots(
    label: str,
    radius: float,
    thickness: float,
    bg: ImColor,
    color: ImColor,
    speed: float
    ) -> None:
    pass

def spinner_scale_blocks(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    mode: int = 0
    ) -> None:
    pass

def spinner_scale_squares(
    label: str,
    radius: float,
    thikness: float,
    color: ImColor,
    speed: float
    ) -> None:
    pass

def spinner_squish_square(
    label: str,
    radius: float,
    color: ImColor,
    speed: float
    ) -> None:
    pass

def spinner_fluid(
    label: str,
    radius: float,
    color: ImColor,
    speed: float,
    bars: int = 3
    ) -> None:
    pass

def spinner_fluid_points(
    label: str,
    radius: float,
    thickness: float,
    color: ImColor,
    speed: float,
    dots: int = 6,
    delta: float = 0.35
    ) -> None:
    pass

def spinner_arc_polar_fade(
    label: str,
    radius: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_arc_polar_radius(
    label: str,
    radius: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_caleidoscope(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 6,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_hbo_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    minfade: float = 0.0,
    ryk: float = 0.,
    speed: float = 1.1,
    dots: int = 6
    ) -> None:
    """ spinner idea by nitz 'Chris Dailey'
    ---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_moon_dots(
    label: str,
    radius: float,
    thickness: float,
    first: ImColor,
    second: ImColor,
    speed: float = 1.1
    ) -> None:
    pass

def spinner_twin_hbo_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    minfade: float = 0.0,
    ryk: float = 0.,
    speed: float = 1.1,
    dots: int = 6,
    delta: float = 0.
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_three_dots_star(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    minfade: float = 0.0,
    ryk: float = 0.,
    speed: float = 1.1,
    delta: float = 0.
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_sine_arcs(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_triangles_shift(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    bars: int = 8
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: half_white
    """
    pass

def spinner_points_shift(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    bars: int = 8
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: half_white
    """
    pass

def spinner_swing_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_circular_points(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 1.8,
    lines: int = 8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_curved_circle(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    circles: int = 1
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_mod_circle(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    ang_min: float = 1.,
    ang_max: float = 1.,
    speed: float = 2.8
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_dna_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    lt: int = 8,
    delta: float = 0.5,
    mode: bool = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner3_smuggle_dots(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 4.8,
    lt: int = 8,
    delta: float = 0.5,
    mode: bool = 0
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_rotate_segments_pulsar(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    speed: float = 2.8,
    arcs: int = 4,
    layers: int = 1
    ) -> None:
    """---
    Python bindings defaults:
        If color is None, then its default value will be: white
    """
    pass

def spinner_spline_ang(
    label: str,
    radius: float,
    thickness: float,
    color: Optional[ImColor] = None,
    bg: Optional[ImColor] = None,
    speed: float = 2.8,
    angle: float = IM_PI,
    mode: int = 0
    ) -> None:
    """---
    Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            color: white
            bg: white
    """
    pass


# ---------------------------------------------------------------------


# #endif

# #endif
####################    </generated_from:imspinner.h>    ####################

# </litgen_stub> // Autogenerated code end!
