"""immvision: immediate image debugger and insights
Python bindings for https://github.com/pthom/immvision.git
"""

# ruff: noqa: B008
from typing import List, Tuple, TypeAlias, Optional, overload
import enum
import numpy as np
from numpy.typing import NDArray
from imgui_bundle import ImVec2, ImVec2Like

import cv2 as cv

Point2d: TypeAlias = Tuple[float, float]
Point: TypeAlias = Tuple[int, int]
Size: TypeAlias = Tuple[int, int]
Size2d: TypeAlias = Tuple[float, float]
Mat: TypeAlias = NDArray[np.number]
Matx33d: TypeAlias = NDArray[np.number]
Image_RGBA: TypeAlias = NDArray[np.uint8]
Image_RGB: TypeAlias = NDArray[np.uint8]
Scalar: TypeAlias = Tuple[float, float, float, float]
ImTextureID: TypeAlias = int

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:immvision.h>    ####################
# THIS FILE WAS GENERATED AUTOMATICALLY. DO NOT EDIT.

# ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#                       src/immvision/immvision.h                                                              //
# //////////////////////////////////////////////////////////////////////////////////////////////////////////////

# ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#                       src/immvision/image.h included by src/immvision/immvision.h                            //
# //////////////////////////////////////////////////////////////////////////////////////////////////////////////

# IMMVISION_API is a marker for public API functions. IMMVISION_STRUCT_API is a marker for public API structs (in comment lines)
# Usage of ImmVision as a shared library is not recommended. No guaranty of ABI stability is provided

# Set the color order for displayed images.
# You **must** call once at the start of your program:
#     ImmVision::UseRgbColorOrder() or ImmVision::UseBgrColorOrder() (C++)
#     immvision.use_rgb_color_order() or immvision.use_bgr_color_order() (Python)
# (Breaking change - October 2024)
# void UseRgbColorOrder();    /* original C++ signature */
def use_rgb_color_order() -> None:
    """(private API)"""
    pass

# void UseBgrColorOrder();    /* original C++ signature */
def use_bgr_color_order() -> None:
    """(private API)"""
    pass

# bool IsUsingRgbColorOrder();    /* original C++ signature */
def is_using_rgb_color_order() -> bool:
    """Returns True if we are using RGB color order
    (private API)
    """
    pass

# bool IsUsingBgrColorOrder();    /* original C++ signature */
def is_using_bgr_color_order() -> bool:
    """Returns True if we are using BGR color order
    (private API)
    """
    pass

# bool IsColorOrderUndefined();    /* original C++ signature */
def is_color_order_undefined() -> bool:
    """Returns True if the color order is undefined (i.e. UseRgbColorOrder or UseBgrColorOrder was not called)
    (private API)
    """
    pass

# Temporary change of color order (useful for displaying a single image with a different color order)
# void PushColorOrderRgb();    /* original C++ signature */
def push_color_order_rgb() -> None:
    """(private API)"""
    pass

# void PushColorOrderBgr();    /* original C++ signature */
def push_color_order_bgr() -> None:
    """(private API)"""
    pass

# void PopColorOrder();    /* original C++ signature */
def pop_color_order() -> None:
    """(private API)"""
    pass

class ColorMapStatsTypeId(enum.Enum):
    """Are we using the stats on the full image, on the Visible ROI, or are we using Min/Max values"""

    # FromFullImage,    /* original C++ signature */
    from_full_image = enum.auto()  # (= 0)
    # FromVisibleROI    /* original C++ signature */
    #     }
    from_visible_roi = enum.auto()  # (= 1)

class ColormapScaleFromStatsData:
    """Scale the Colormap according to the Image  stats

    IMMVISION_API_STRUCT
    """

    # ColorMapStatsTypeId ColorMapStatsType = ColorMapStatsTypeId::FromFullImage;    /* original C++ signature */
    # Are we using the stats on the full image, the visible ROI, or are we using Min/Max values
    color_map_stats_type: ColorMapStatsTypeId = ColorMapStatsTypeId.from_full_image

    # double NbSigmas = 1.5;    /* original C++ signature */
    # If stats active (either on ROI or on Image), how many sigmas around the mean should the Colormap be applied
    nb_sigmas: float = 1.5

    # bool UseStatsMin = false;    /* original C++ signature */
    # If ColorMapScaleType==ColorMapStatsType::FromMinMax, then ColormapScaleMin will be calculated from the matrix min value instead of a sigma based value
    use_stats_min: bool = False
    # bool UseStatsMax = false;    /* original C++ signature */
    # If ColorMapScaleType==ColorMapStatsType::FromMinMax, then ColormapScaleMax will be calculated from the matrix min value instead of a sigma based value
    use_stats_max: bool = False
    # ColormapScaleFromStatsData(ColorMapStatsTypeId ColorMapStatsType = ColorMapStatsTypeId::FromFullImage, double NbSigmas = 1.5, bool UseStatsMin = false, bool UseStatsMax = false);    /* original C++ signature */
    def __init__(
        self,
        color_map_stats_type: ColorMapStatsTypeId = ColorMapStatsTypeId.from_full_image,
        nb_sigmas: float = 1.5,
        use_stats_min: bool = False,
        use_stats_max: bool = False,
    ) -> None:
        """Auto-generated default constructor with named params"""
        pass

class ColormapSettingsData:
    """Colormap Settings (useful for matrices with one channel, in order to see colors mapping float values)

    IMMVISION_API_STRUCT
    """

    # std::string Colormap = "None";    /* original C++ signature */
    # Colormap, see available Colormaps with AvailableColormaps()
    # Work only with 1 channel matrices, i.e len(shape)==2
    colormap: str = "None"

    # ColormapScaleMin and ColormapScaleMax indicate how the Colormap is applied:
    #     - Values in [ColormapScaleMin, ColomapScaleMax] will use the full colormap.
    #     - Values outside this interval will be clamped before coloring
    # by default, the initial values are ignored, and they will be updated automatically
    # via the options in ColormapScaleFromStats
    # double ColormapScaleMin = 0.;    /* original C++ signature */
    colormap_scale_min: float = 0.0
    # double ColormapScaleMax = 1.;    /* original C++ signature */
    colormap_scale_max: float = 1.0

    # ColormapScaleFromStatsData ColormapScaleFromStats = ColormapScaleFromStatsData();    /* original C++ signature */
    # If ColormapScaleFromStats.ActiveOnFullImage or ColormapScaleFromStats.ActiveOnROI,
    # then ColormapScaleMin/Max are ignored, and the scaling is done according to the image stats.
    # ColormapScaleFromStats.ActiveOnFullImage is True by default
    colormap_scale_from_stats: ColormapScaleFromStatsData = ColormapScaleFromStatsData()

    # std::string internal_ColormapHovered = "";    /* original C++ signature */
    # Internal value: stores the name of the Colormap that is hovered by the mouse
    internal_colormap_hovered: str = ""
    # ColormapSettingsData(std::string Colormap = "None", double ColormapScaleMin = 0., double ColormapScaleMax = 1., ColormapScaleFromStatsData ColormapScaleFromStats = ColormapScaleFromStatsData(), std::string internal_ColormapHovered = "");    /* original C++ signature */
    def __init__(
        self,
        colormap: str = "None",
        colormap_scale_min: float = 0.0,
        colormap_scale_max: float = 1.0,
        colormap_scale_from_stats: Optional[ColormapScaleFromStatsData] = None,
        internal_colormap_hovered: str = "",
    ) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If ColormapScaleFromStats is None, then its default value will be: ColormapScaleFromStatsData()
        """
        pass

class MouseInformation:
    """Contains information about the mouse inside an image

    IMMVISION_API_STRUCT
    """

    # bool IsMouseHovering = false;    /* original C++ signature */
    # Is the mouse hovering the image
    is_mouse_hovering: bool = False

    # cv::Point2d MousePosition = cv::Point2d(-1., -1.);    /* original C++ signature */
    # Mouse position in the original image/matrix
    # This position is given with float coordinates, and will be (-1., -1.) if the mouse is not hovering the image
    mouse_position: Point2d = (-1.0, -1.0)
    # cv::Point MousePosition_Displayed = cv::Point(-1, -1);    /* original C++ signature */
    # Mouse position in the displayed portion of the image (the original image can be zoomed,
    # and only show a subset if it may be shown).
    # This position is given with integer coordinates, and will be (-1, -1) if the mouse is not hovering the image
    mouse_position_displayed: Point = (-1, -1)

    #
    # Note: you can query ImGui::IsMouseDown(mouse_button) (c++) or imgui.is_mouse_down(mouse_button) (Python)
    #
    # MouseInformation(bool IsMouseHovering = false, cv::Point2d MousePosition = cv::Point2d(-1., -1.), cv::Point MousePosition_Displayed = cv::Point(-1, -1));    /* original C++ signature */
    def __init__(
        self,
        is_mouse_hovering: bool = False,
        mouse_position: Optional[Point2d] = None,
        mouse_position_displayed: Optional[cv.Point] = None,
    ) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                MousePosition: Point2(-1., -1.)
                MousePosition_Displayed: Point(-1, -1)
        """
        pass

class ImageParams:
    """Set of display parameters and options for an Image

    IMMVISION_API_STRUCT
    """

    #
    # ImageParams store the parameters for a displayed image
    # (as well as user selected watched pixels, selected channel, etc.)
    # Its default constructor will give them reasonable choices, which you can adapt to your needs.
    # Its values will be updated when the user pans or zooms the image, adds watched pixels, etc.
    #

    #
    # Refresh Images Textures
    #

    # bool RefreshImage = false;    /* original C++ signature */
    # Refresh Image: images textures are cached. Set to True if your image matrix/buffer has changed
    # (for example, for live video images)
    refresh_image: bool = False

    #
    # Display size and title
    #

    # cv::Size ImageDisplaySize = cv::Size();    /* original C++ signature */
    # Size of the displayed image (can be different from the matrix size)
    # If you specify only the width or height (e.g (300, 0), then the other dimension
    # will be calculated automatically, respecting the original image w/h ratio.
    image_display_size: Size = (0, 0)

    #
    # Zoom and Pan (represented by an affine transform matrix, of size 3x3)
    #

    # cv::Matx33d ZoomPanMatrix = cv::Matx33d::eye();    /* original C++ signature */
    # ZoomPanMatrix can be created using MakeZoomPanMatrix to create a view centered around a given point
    zoom_pan_matrix: Matx33d = np.eye(3)
    # std::string ZoomKey = "";    /* original C++ signature */
    # If displaying several images, those with the same ZoomKey will zoom and pan together
    zoom_key: str = ""

    # ColormapSettingsData ColormapSettings = ColormapSettingsData();    /* original C++ signature */
    #
    # Colormap Settings (useful for matrices with one channel, in order to see colors mapping float values)
    #
    # ColormapSettings stores all the parameter concerning the Colormap
    colormap_settings: ColormapSettingsData = ColormapSettingsData()
    # std::string ColormapKey = "";    /* original C++ signature */
    # If displaying several images, those with the same ColormapKey will adjust together
    colormap_key: str = ""

    #
    # Zoom and pan with the mouse
    #
    # bool PanWithMouse = true;    /* original C++ signature */
    pan_with_mouse: bool = True
    # bool ZoomWithMouseWheel = true;    /* original C++ signature */
    zoom_with_mouse_wheel: bool = True

    # bool CanResize = true;    /* original C++ signature */
    # Can the image widget be resized by the user
    can_resize: bool = True
    # bool ResizeKeepAspectRatio = true;    /* original C++ signature */
    # Does the widget keep an aspect ratio equal to the image when resized
    resize_keep_aspect_ratio: bool = True

    # int  SelectedChannel = -1;    /* original C++ signature */
    #
    # Image display options
    #
    # if SelectedChannel >= 0 then only this channel is displayed
    selected_channel: int = -1
    # bool ShowSchoolPaperBackground = true;    /* original C++ signature */
    # Show a "school paper" background grid
    show_school_paper_background: bool = True
    # bool ShowAlphaChannelCheckerboard = true;    /* original C++ signature */
    # show a checkerboard behind transparent portions of 4 channels RGBA images
    show_alpha_channel_checkerboard: bool = True
    # bool ShowGrid = true;    /* original C++ signature */
    # Grid displayed when the zoom is high
    show_grid: bool = True
    # bool DrawValuesOnZoomedPixels = true;    /* original C++ signature */
    # Pixel values show when the zoom is high
    draw_values_on_zoomed_pixels: bool = True

    # bool ShowImageInfo = true;    /* original C++ signature */
    #
    # Image display options
    #
    # Show matrix type and size
    show_image_info: bool = True
    # bool ShowPixelInfo = true;    /* original C++ signature */
    # Show pixel values
    show_pixel_info: bool = True
    # bool ShowZoomButtons = true;    /* original C++ signature */
    # Show buttons that enable to zoom in/out (the mouse wheel also zoom)
    show_zoom_buttons: bool = True
    # bool ShowOptionsPanel = false;    /* original C++ signature */
    # Open the options panel
    show_options_panel: bool = False
    # bool ShowOptionsInTooltip = false;    /* original C++ signature */
    # If set to True, then the option panel will be displayed in a transient tooltip window
    show_options_in_tooltip: bool = False
    # bool ShowOptionsButton = true;    /* original C++ signature */
    # If set to False, then the Options button will not be displayed
    show_options_button: bool = True

    # std::vector<cv::Point> WatchedPixels = std::vector<cv::Point>();    /* original C++ signature */
    #
    # Watched Pixels
    #
    # List of Watched Pixel coordinates
    watched_pixels: List[Point] = List[Point]()
    # bool AddWatchedPixelOnDoubleClick = true;    /* original C++ signature */
    # Shall we add a watched pixel on double click
    add_watched_pixel_on_double_click: bool = True
    # bool HighlightWatchedPixels = true;    /* original C++ signature */
    # Shall the watched pixels be drawn on the image
    highlight_watched_pixels: bool = True

    # MouseInformation MouseInfo = MouseInformation();    /* original C++ signature */
    # Mouse position information. These values are filled after displaying an image
    mouse_info: MouseInformation = MouseInformation()

    # ImageParams(bool RefreshImage = false, cv::Size ImageDisplaySize = cv::Size(), cv::Matx33d ZoomPanMatrix = cv::Matx33d::eye(), std::string ZoomKey = "", ColormapSettingsData ColormapSettings = ColormapSettingsData(), std::string ColormapKey = "", bool PanWithMouse = true, bool ZoomWithMouseWheel = true, bool CanResize = true, bool ResizeKeepAspectRatio = true, int SelectedChannel = -1, bool ShowSchoolPaperBackground = true, bool ShowAlphaChannelCheckerboard = true, bool ShowGrid = true, bool DrawValuesOnZoomedPixels = true, bool ShowImageInfo = true, bool ShowPixelInfo = true, bool ShowZoomButtons = true, bool ShowOptionsPanel = false, bool ShowOptionsInTooltip = false, bool ShowOptionsButton = true, std::vector<cv::Point> WatchedPixels = std::vector<cv::Point>(), bool AddWatchedPixelOnDoubleClick = true, bool HighlightWatchedPixels = true, MouseInformation MouseInfo = MouseInformation());    /* original C++ signature */
    def __init__(
        self,
        refresh_image: bool = False,
        image_display_size: Optional[Size] = None,
        zoom_pan_matrix: Optional[Matx33d] = None,
        zoom_key: str = "",
        colormap_settings: Optional[ColormapSettingsData] = None,
        colormap_key: str = "",
        pan_with_mouse: bool = True,
        zoom_with_mouse_wheel: bool = True,
        can_resize: bool = True,
        resize_keep_aspect_ratio: bool = True,
        selected_channel: int = -1,
        show_school_paper_background: bool = True,
        show_alpha_channel_checkerboard: bool = True,
        show_grid: bool = True,
        draw_values_on_zoomed_pixels: bool = True,
        show_image_info: bool = True,
        show_pixel_info: bool = True,
        show_zoom_buttons: bool = True,
        show_options_panel: bool = False,
        show_options_in_tooltip: bool = False,
        show_options_button: bool = True,
        watched_pixels: Optional[List[Point]] = None,
        add_watched_pixel_on_double_click: bool = True,
        highlight_watched_pixels: bool = True,
        mouse_info: Optional[MouseInformation] = None,
    ) -> None:
        """Auto-generated default constructor with named params
        ---
        Python bindings defaults:
            If any of the params below is None, then its default value below will be used:
                ImageDisplaySize: Size()
                ZoomPanMatrix: Matx33.eye()
                ColormapSettings: ColormapSettingsData()
                WatchedPixels: List[Point]()
                MouseInfo: MouseInformation()
        """
        pass

# #ifdef IMMVISION_SERIALIZE_JSON
#
# IMMVISION_API std::string ImageParamsToJson(const ImageParams& params);    /* original C++ signature */
def image_params_to_json(params: ImageParams) -> str:
    pass

# IMMVISION_API void FillImageParamsFromJson(const std::string& json, ImageParams* params);    /* original C++ signature */
def fill_image_params_from_json(json: str, params: ImageParams) -> None:
    pass

# IMMVISION_API ImageParams ImageParamsFromJson(const std::string& json);    /* original C++ signature */
def image_params_from_json(json: str) -> ImageParams:
    pass

# #endif
#

# IMMVISION_API ImageParams FactorImageParamsDisplayOnly();    /* original C++ signature */
def factor_image_params_display_only() -> ImageParams:
    """Create ImageParams that display the image only, with no decoration, and no user interaction"""
    pass

# IMMVISION_API cv::Matx33d MakeZoomPanMatrix(    /* original C++ signature */
#                         const cv::Point2d & zoomCenter,
#                         double zoomRatio,
#                         const cv::Size displayedImageSize
#     );
def make_zoom_pan_matrix(
    zoom_center: Point2d, zoom_ratio: float, displayed_image_size: Size
) -> Matx33d:
    """Create a zoom/pan matrix centered around a given point of interest"""
    pass

# IMMVISION_API cv::Matx33d MakeZoomPanMatrix_ScaleOne(    /* original C++ signature */
#         cv::Size imageSize,
#         const cv::Size displayedImageSize
#     );
def make_zoom_pan_matrix_scale_one(
    image_size: Size, displayed_image_size: Size
) -> Matx33d:
    pass

# IMMVISION_API cv::Matx33d MakeZoomPanMatrix_FullView(    /* original C++ signature */
#         cv::Size imageSize,
#         const cv::Size displayedImageSize
#     );
def make_zoom_pan_matrix_full_view(
    image_size: Size, displayed_image_size: Size
) -> Matx33d:
    pass

# IMMVISION_API void Image(const std::string& label, const cv::Mat& mat, ImageParams* params);    /* original C++ signature */
def image(label: str, mat: Mat, params: ImageParams) -> None:
    """Display an image, with full user control: zoom, pan, watch pixels, etc.

    :param label
        A legend that will be displayed.
        Important notes:
            - With ImGui and ImmVision, widgets *must* have a unique Ids.
              For this widget, the id is given by this label.
              Two widgets (for example) two images *cannot* have the same label or the same id!
              (you can use ImGui::PushID / ImGui::PopID to circumvent this, or add suffixes with ##)

              If they do, they might not refresh correctly!
              To circumvent this, you can:
                 - Call `ImGui::PushID("some_unique_string")` at the start of your function,
                   and `ImGui::PopID()` at the end.
                 - Or modify your label like this:
                     "MyLabel##some_unique_id"
                     (the part after "##" will not be displayed but will be part of the id)
           - To display an empty legend, use "##_some_unique_id"

    :param mat
        An image you want to display, under the form of an OpenCV matrix. All types of dense matrices are supported.

    :param params
        Complete options (as modifiable inputs), and outputs (mouse position, watched pixels, etc)
        @see ImageParams structure.
        The ImageParams may be modified by this function: you can extract from them
        the mouse position, watched pixels, etc.
        Important note:
            ImageParams is an input-output parameter, passed as a pointer.
            Its scope should be wide enough so that it is preserved from frame to frame.
            !! If you cannot zoom/pan in a displayed image, extend the scope of the ImageParams !!

    - This function requires that both imgui and OpenGL were initialized.
      (for example, use `imgui_runner.run`for Python,  or `HelloImGui::Run` for C++)
    """
    pass

# IMMVISION_API cv::Point2d ImageDisplay(    /* original C++ signature */
#         const std::string& label_id,
#         const cv::Mat& mat,
#         const cv::Size& imageDisplaySize = cv::Size(),
#         bool refreshImage = false,
#         bool showOptionsButton = false
#         );
def image_display(
    label_id: str,
    mat: Mat,
    image_display_size: Optional[Size] = None,
    refresh_image: bool = False,
    show_options_button: bool = False,
) -> Point2d:
    """ImageDisplay: Only, display the image, with no user interaction (by default)

     Parameters:
     :param label_id
         A legend that will be displayed.
         Important notes:
             - With ImGui and ImmVision, widgets must have a unique Ids. For this widget, the id is given by this label.
               Two widgets (for example) two images *cannot* have the same label or the same id!
               If they do, they might not refresh correctly!
               To circumvent this, you can modify your label like this:
                  "MyLabel##some_unique_id"    (the part after "##" will not be displayed but will be part of the id)
            - To display an empty legend, use "##_some_unique_id"
            - if your legend is displayed (i.e. it does not start with "##"),
              then the total size of the widget will be larger than the imageDisplaySize.

     :param mat:
         An image you want to display, under the form of an OpenCV matrix. All types of dense matrices are supported.

     :param imageDisplaySize:
         Size of the displayed image (can be different from the mat size)
         If you specify only the width or height (e.g (300, 0), then the other dimension
         will be calculated automatically, respecting the original image w/h ratio.

     :param refreshImage:
         images textures are cached. Set to True if your image matrix/buffer has changed
         (for example, for live video images)

     :param showOptionsButton:
         If True, show an option button that opens the option panel.
         In that case, it also becomes possible to zoom & pan, add watched pixel by double-clicking, etc.

     :param isBgrOrBgra:
         set to True if the color order of the image is BGR or BGRA (as in OpenCV)
    .    Breaking change, oct 2024: the default is BGR for C++, RGB for Python!

     :return:
          The mouse position in `mat` original image coordinates, as double values.
          (i.e. it does not matter if imageDisplaySize is different from mat.size())
          It will return (-1., -1.) if the mouse is not hovering the image.

          Note: use ImGui::IsMouseDown(mouse_button) (C++) or imgui.is_mouse_down(mouse_button) (Python)
                to query more information about the mouse.

     Note: this function requires that both imgui and OpenGL were initialized.
           (for example, use `imgui_runner.run`for Python,  or `HelloImGui::Run` for C++)

    ---
    Python bindings defaults:
        If imageDisplaySize is None, then its default value will be: Size()
    """
    pass

# IMMVISION_API cv::Point2d ImageDisplayResizable(    /* original C++ signature */
#         const std::string& label_id,
#         const cv::Mat& mat,
#         ImVec2* size = nullptr,
#         bool refreshImage = false,
#         bool resizable = true,
#         bool showOptionsButton = false
#     );
def image_display_resizable(
    label_id: str,
    mat: Mat,
    size: Optional[ImVec2Like] = None,
    refresh_image: bool = False,
    resizable: bool = True,
    show_options_button: bool = False,
) -> Point2d:
    """ImageDisplayResizable: display the image, with no user interaction (by default)
    The image can be resized by the user (and the new size will be stored in the size parameter, if provided)
    The label will not be displayed (but it will be used as an id, and must be unique)
    """
    pass

# IMMVISION_API std::vector<std::string> AvailableColormaps();    /* original C++ signature */
def available_colormaps() -> List[str]:
    """Return the list of the available color maps
    Taken from https://github.com/yuki-koyama/tinycolormap, thanks to Yuki Koyama
    """
    pass

# IMMVISION_API void ClearTextureCache();    /* original C++ signature */
def clear_texture_cache() -> None:
    """Clears the internal texture cache of immvision (this is done automatically at exit time)

    Note: this function requires that both imgui and OpenGL were initialized.
          (for example, use `imgui_runner.run`for Python,  or `HelloImGui::Run` for C++)
    """
    pass

# IMMVISION_API cv::Mat GetCachedRgbaImage(const std::string& label);    /* original C++ signature */
def get_cached_rgba_image(label: str) -> cv.Mat:
    """Returns the RGBA image currently displayed by ImmVision::Image or ImmVision::ImageDisplay
    Note: this image must be currently displayed. This function will return the transformed image
    (i.e with ColorMap, Zoom, etc.)
    """
    pass

# IMMVISION_API std::string VersionInfo();    /* original C++ signature */
def version_info() -> str:
    """Return immvision version info"""
    pass

# namespace ImmVision

# ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#                       src/immvision/immvision.h continued                                                    //
# //////////////////////////////////////////////////////////////////////////////////////////////////////////////

# ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#                       src/immvision/inspector.h included by src/immvision/immvision.h                        //
# //////////////////////////////////////////////////////////////////////////////////////////////////////////////

# IMMVISION_API is a marker for public API functions. IMMVISION_STRUCT_API is a marker for public API structs (in comment lines)
# Usage of ImmVision as a shared library is not recommended. No guaranty of ABI stability is provided

# IMMVISION_API void Inspector_AddImage(    /* original C++ signature */
#         const cv::Mat& image,
#         const std::string& legend,
#         const std::string& zoomKey = "",
#         const std::string& colormapKey = "",
#         const cv::Point2d & zoomCenter = cv::Point2d(),
#         double zoomRatio = -1.
#     );
def inspector_add_image(
    image: Mat,
    legend: str,
    zoom_key: str = "",
    colormap_key: str = "",
    zoom_center: Optional[Point2d] = None,
    zoom_ratio: float = -1.0,
) -> None:
    """---
    Python bindings defaults:
        If zoomCenter is None, then its default value will be: Point2()
    """
    pass

# IMMVISION_API void Inspector_Show();    /* original C++ signature */
def inspector_show() -> None:
    pass

# IMMVISION_API void Inspector_ClearImages();    /* original C++ signature */
def inspector_clear_images() -> None:
    pass

# ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#                       src/immvision/immvision.h continued                                                    //
# //////////////////////////////////////////////////////////////////////////////////////////////////////////////

# ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#                       src/immvision/gl_texture.h included by src/immvision/immvision.h                       //
# //////////////////////////////////////////////////////////////////////////////////////////////////////////////

class GlTexture:
    """GlTexture contains an OpenGL texture which can be created or updated from a cv::Mat (C++), or numpy array (Python)"""

    #
    # Constructors
    #

    # GlTexture();    /* original C++ signature */
    @overload
    def __init__(self) -> None:
        """Create an empty texture"""
        pass
    # GlTexture(const cv::Mat& image, bool isColorOrderBGR = false);    /* original C++ signature */
    @overload
    def __init__(self, image: Mat, is_color_order_bgr: bool = False) -> None:
        """Create a texture from an image (cv::Mat in C++, numpy array in Python)
        isColorOrderBGR: if True, the image is assumed to be in BGR order (OpenCV default)
        """
        pass
    # GlTexture(GlTexture&& other) noexcept = default;    /* original C++ signature */
    @overload
    def __init__(self, other: GlTexture) -> None:
        pass
    #
    # Methods
    #

    # void UpdateFromImage(const cv::Mat& image, bool isColorOrderBGR = false);    /* original C++ signature */
    def update_from_image(self, image: Mat, is_color_order_bgr: bool = False) -> None:
        """Update the texture from a new image (cv::Mat in C++, numpy array in Python).
        (private API)
        """
        pass
    # ImVec2 SizeImVec2() const;    /* original C++ signature */
    def size_im_vec2(self) -> ImVec2:
        """Returns the size as ImVec2
        (private API)
        """
        pass
    #
    # Members
    #

    # ImTextureID TextureId;    /* original C++ signature */
    # OpenGL texture ID on the GPU
    texture_id: ImTextureID
    # cv::Size Size;    /* original C++ signature */
    # Image size in pixels
    size: Size

####################    </generated_from:immvision.h>    ####################

####################    <generated_from:cv_drawing_utils.h>    ####################

# <submodule cv_drawing_utils>
class cv_drawing_utils:  # Proxy class that introduces typings for the *submodule* cv_drawing_utils
    pass  # (This corresponds to a C++ namespace. All method are static!)
    """ namespace CvDrawingUtils"""

    class Colors(enum.Enum):
        # Black,    /* original C++ signature */
        black = enum.auto()  # (= 0)
        # Red,    /* original C++ signature */
        red = enum.auto()  # (= 1)
        # Green,    /* original C++ signature */
        green = enum.auto()  # (= 2)
        # Blue,    /* original C++ signature */
        blue = enum.auto()  # (= 3)
        # White,    /* original C++ signature */
        white = enum.auto()  # (= 4)
        # Yellow,    /* original C++ signature */
        yellow = enum.auto()  # (= 5)
        # Cyan,    /* original C++ signature */
        cyan = enum.auto()  # (= 6)
        # Violet,    /* original C++ signature */
        violet = enum.auto()  # (= 7)
        # Orange    /* original C++ signature */
        #         }
        orange = enum.auto()  # (= 8)

    # cv::Scalar ColorsToScalar(Colors value);    /* original C++ signature */
    @staticmethod
    def colors_to_scalar(value: Colors) -> Scalar:
        """(private API)"""
        pass
    # inline cv::Scalar Black()    /* original C++ signature */
    #         { return {0, 0, 0, 255}; }
    @staticmethod
    def black() -> Scalar:
        """(private API)"""
        pass
    # inline cv::Scalar Red()    /* original C++ signature */
    #         { return {0, 0, 255, 255}; }
    @staticmethod
    def red() -> Scalar:
        """(private API)"""
        pass
    # inline cv::Scalar Green()    /* original C++ signature */
    #         { return {0, 255, 0, 255}; }
    @staticmethod
    def green() -> Scalar:
        """(private API)"""
        pass
    # inline cv::Scalar Blue()    /* original C++ signature */
    #         { return {255, 0, 0, 255}; }
    @staticmethod
    def blue() -> Scalar:
        """(private API)"""
        pass
    # inline cv::Scalar White()    /* original C++ signature */
    #         { return {255, 255, 255, 255}; }
    @staticmethod
    def white() -> Scalar:
        """(private API)"""
        pass
    # inline cv::Scalar Yellow()    /* original C++ signature */
    #         { return {0, 255, 255, 255}; }
    @staticmethod
    def yellow() -> Scalar:
        """(private API)"""
        pass
    # inline cv::Scalar Cyan()    /* original C++ signature */
    #         { return {255, 255, 0, 255}; }
    @staticmethod
    def cyan() -> Scalar:
        """(private API)"""
        pass
    # inline cv::Scalar Violet()    /* original C++ signature */
    #         { return {200, 50, 200, 255}; }
    @staticmethod
    def violet() -> Scalar:
        """(private API)"""
        pass
    # inline cv::Scalar Orange()    /* original C++ signature */
    #         { return {255, 128, 0, 255}; }
    @staticmethod
    def orange() -> Scalar:
        """(private API)"""
        pass
    # void line(cv::Mat &image,    /* original C++ signature */
    #                   const cv::Point2d &a,
    #                   const cv::Point2d &b,
    #                   cv::Scalar color,
    #                   int thickness = 1);
    @staticmethod
    def line(
        image: Mat, a: Point2d, b: Point2d, color: Scalar, thickness: int = 1
    ) -> None:
        """(private API)"""
        pass
    # void ellipse(cv::Mat &image,    /* original C++ signature */
    #                      const cv::Point2d &center,
    #                      const cv::Size2d &size,
    #                      const cv::Scalar &color,
    #                      double angle = 0.,
    #                      double start_angle = 0.,
    #                      double end_angle = 360.,
    #                      int thickness = 1);
    @staticmethod
    def ellipse(
        image: Mat,
        center: Point2d,
        size: Size2d,
        color: Scalar,
        angle: float = 0.0,
        start_angle: float = 0.0,
        end_angle: float = 360.0,
        thickness: int = 1,
    ) -> None:
        """(private API)"""
        pass
    # void circle(cv::Mat &image,    /* original C++ signature */
    #                     const cv::Point2d &center,
    #                     double radius,
    #                     cv::Scalar color,
    #                     int thickness = 1);
    @staticmethod
    def circle(
        image: Mat, center: Point2d, radius: float, color: Scalar, thickness: int = 1
    ) -> None:
        """(private API)"""
        pass
    # void rectangle(cv::Mat &image,    /* original C++ signature */
    #                        const cv::Point2d &pt1,
    #                        const cv::Point2d &pt2,
    #                        const cv::Scalar &color,
    #                        bool fill = false,
    #                        int thickness = 1);
    @staticmethod
    def rectangle(
        image: Mat,
        pt1: Point2d,
        pt2: Point2d,
        color: Scalar,
        fill: bool = False,
        thickness: int = 1,
    ) -> None:
        """(private API)"""
        pass
    # void rectangle_size(cv::Mat &img,    /* original C++ signature */
    #                             const cv::Point2d &pt,
    #                             const cv::Size2d &size,
    #                             const cv::Scalar &color,
    #                             bool fill = false,
    #                             int thickness = 1);
    @staticmethod
    def rectangle_size(
        img: Mat,
        pt: Point2d,
        size: Size2d,
        color: Scalar,
        fill: bool = False,
        thickness: int = 1,
    ) -> None:
        """(private API)"""
        pass
    # void text(cv::Mat &img,    /* original C++ signature */
    #                   const cv::Point2d &position,
    #                   const std::string &msg,
    #                   const cv::Scalar &color,
    #                   bool center_around_point = false,
    #                   bool add_cartouche = false,
    #                   double fontScale = 0.4,
    #                   int thickness = 1);
    @staticmethod
    def text(
        img: Mat,
        position: Point2d,
        msg: str,
        color: Scalar,
        center_around_point: bool = False,
        add_cartouche: bool = False,
        font_scale: float = 0.4,
        thickness: int = 1,
    ) -> None:
        """(private API)"""
        pass
    # void cross_hole(cv::Mat &img,    /* original C++ signature */
    #                         const cv::Point2d &position,
    #                         const cv::Scalar &color,
    #                         double size = 2.,
    #                         double size_hole = 2.,
    #                         int thickness = 1);
    @staticmethod
    def cross_hole(
        img: Mat,
        position: Point2d,
        color: Scalar,
        size: float = 2.0,
        size_hole: float = 2.0,
        thickness: int = 1,
    ) -> None:
        """(private API)"""
        pass
    # void draw_named_feature(cv::Mat &img,    /* original C++ signature */
    #                                 const cv::Point2d &position,
    #                                 const std::string &name,
    #                                 const cv::Scalar &color,
    #                                 bool add_cartouche = false,
    #                                 double size = 3.,
    #                                 double size_hole = 2.,
    #                                 int thickness = 1,
    #                                 double font_scale = 0.4);
    @staticmethod
    def draw_named_feature(
        img: Mat,
        position: Point2d,
        name: str,
        color: Scalar,
        add_cartouche: bool = False,
        size: float = 3.0,
        size_hole: float = 2.0,
        thickness: int = 1,
        font_scale: float = 0.4,
    ) -> None:
        """(private API)"""
        pass
    # void draw_transparent_pixel(    /* original C++ signature */
    #             cv::Mat &img_rgba,
    #             const cv::Point2d &position,
    #             const cv::Scalar &color,
    #             double alpha
    #         );
    @staticmethod
    def draw_transparent_pixel(
        img_rgba: Mat, position: Point2d, color: Scalar, alpha: float
    ) -> None:
        """(private API)"""
        pass
    # void draw_grid(    /* original C++ signature */
    #             cv::Mat& img_rgba,
    #             cv::Scalar lineColor,
    #             double alpha,
    #             double x_spacing, double y_spacing,
    #             double x_start, double y_start,
    #             double x_end, double y_end
    #         );
    @staticmethod
    def draw_grid(
        img_rgba: Mat,
        line_color: Scalar,
        alpha: float,
        x_spacing: float,
        y_spacing: float,
        x_start: float,
        y_start: float,
        x_end: float,
        y_end: float,
    ) -> None:
        """(private API)"""
        pass
    # cv::Mat stack_images_vertically(const cv::Mat &img1, const cv::Mat &img2);    /* original C++ signature */
    @staticmethod
    def stack_images_vertically(img1: Mat, img2: Mat) -> cv.Mat:
        """(private API)"""
        pass
    # cv::Mat stack_images_horizontally(const cv::Mat &img1, const cv::Mat &img2);    /* original C++ signature */
    @staticmethod
    def stack_images_horizontally(img1: Mat, img2: Mat) -> cv.Mat:
        """(private API)"""
        pass
    # cv::Mat make_alpha_channel_checkerboard_image(const cv::Size& size, int squareSize = 30);    /* original C++ signature */
    @staticmethod
    def make_alpha_channel_checkerboard_image(
        size: Size, square_size: int = 30
    ) -> cv.Mat:
        """(private API)"""
        pass
    # Image_RGB overlay_alpha_image_precise(const cv::Mat &background_rgb_or_rgba,    /* original C++ signature */
    #                                               const Image_RGBA &overlay_rgba,
    #                                               double alpha);
    @staticmethod
    def overlay_alpha_image_precise(
        background_rgb_or_rgba: Mat, overlay_rgba: Image_RGBA, alpha: float
    ) -> Image_RGB:
        """(private API)"""
        pass
    # Image_RGBA converted_to_rgba_image(const cv::Mat &inputMat, bool isBgrOrder);    /* original C++ signature */
    @staticmethod
    def converted_to_rgba_image(input_mat: Mat, is_bgr_order: bool) -> Image_RGBA:
        """(private API)"""
        pass

# </submodule cv_drawing_utils>
####################    </generated_from:cv_drawing_utils.h>    ####################

# </litgen_stub> // Autogenerated code end!
