from imgui_bundle import implot3d

def make_cube_mesh() -> implot3d.Mesh:
    """Creates and returns a Mesh object representing a cube."""
    points = [
        implot3d.Point(-1.0, -1.0, -1.0),  # 0: Bottom-back-left
        implot3d.Point(1.0, -1.0, -1.0),   # 1: Bottom-back-right
        implot3d.Point(1.0, 1.0, -1.0),    # 2: Top-back-right
        implot3d.Point(-1.0, 1.0, -1.0),   # 3: Top-back-left
        implot3d.Point(-1.0, -1.0, 1.0),   # 4: Bottom-front-left
        implot3d.Point(1.0, -1.0, 1.0),    # 5: Bottom-front-right
        implot3d.Point(1.0, 1.0, 1.0),     # 6: Top-front-right
        implot3d.Point(-1.0, 1.0, 1.0),    # 7: Top-front-left
    ]

    indices = [
        # Back face
        0, 1, 2, 0, 2, 3,
        # Front face
        4, 5, 6, 4, 6, 7,
        # Left face
        0, 3, 7, 0, 7, 4,
        # Right face
        1, 5, 6, 1, 6, 2,
        # Top face
        3, 2, 6, 3, 6, 7,
        # Bottom face
        0, 1, 5, 0, 5, 4,
    ]

    return implot3d.Mesh(points=points, idx=indices)


def make_sphere_mesh() -> implot3d.Mesh:
    """Creates and returns a Mesh object representing a sphere."""

    # Define sphere vertices
    points = [
        [-0.525731, 0.850651, 0.000000],
        [0.525731, 0.850651, 0.000000],
        [-0.525731, -0.850651, 0.000000],
        [0.525731, -0.850651, 0.000000],
        [0.000000, -0.525731, 0.850651],
        [0.000000, 0.525731, 0.850651],
        [0.000000, -0.525731, -0.850651],
        [0.000000, 0.525731, -0.850651],
        [0.850651, 0.000000, -0.525731],
        [0.850651, 0.000000, 0.525731],
        [-0.850651, 0.000000, -0.525731],
        [-0.850651, 0.000000, 0.525731],
        [-0.809017, 0.500000, 0.309017],
        [-0.500000, 0.309017, 0.809017],
        [-0.309017, 0.809017, 0.500000],
        [0.309017, 0.809017, 0.500000],
        [0.000000, 1.000000, 0.000000],
        [0.309017, 0.809017, -0.500000],
        [-0.309017, 0.809017, -0.500000],
        [-0.500000, 0.309017, -0.809017],
        [-0.809017, 0.500000, -0.309017],
        [-1.000000, 0.000000, 0.000000],
        [0.500000, 0.309017, 0.809017],
        [0.809017, 0.500000, 0.309017],
        [-0.500000, -0.309017, 0.809017],
        [0.000000, 0.000000, 1.000000],
        [-0.809017, -0.500000, -0.309017],
        [-0.809017, -0.500000, 0.309017],
        [0.000000, 0.000000, -1.000000],
        [-0.500000, -0.309017, -0.809017],
        [0.809017, 0.500000, -0.309017],
        [0.500000, 0.309017, -0.809017],
        [0.809017, -0.500000, 0.309017],
        [0.500000, -0.309017, 0.809017],
        [0.309017, -0.809017, 0.500000],
        [-0.309017, -0.809017, 0.500000],
        [0.000000, -1.000000, 0.000000],
        [-0.309017, -0.809017, -0.500000],
        [0.309017, -0.809017, -0.500000],
        [0.500000, -0.309017, -0.809017],
        [0.809017, -0.500000, -0.309017],
        [1.000000, 0.000000, 0.000000],
        [-0.693780, 0.702046, 0.160622],
        [-0.587785, 0.688191, 0.425325],
        [-0.433889, 0.862668, 0.259892],
        [-0.862668, 0.259892, 0.433889],
        [-0.702046, 0.160622, 0.693780],
        [-0.688191, 0.425325, 0.587785],
        [-0.425325, 0.587785, 0.688191],
        [-0.259892, 0.433889, 0.862668],
        [-0.160622, 0.693780, 0.702046],
        [-0.162460, 0.951057, 0.262866],
        [-0.273267, 0.961938, 0.000000],
        [0.160622, 0.693780, 0.702046],
        [0.000000, 0.850651, 0.525731],
        [0.162460, 0.951057, 0.262866],
        [0.433889, 0.862668, 0.259892],
        [0.273267, 0.961938, 0.000000],
        [-0.162460, 0.951057, -0.262866],
        [-0.433889, 0.862668, -0.259892],
        [0.433889, 0.862668, -0.259892],
        [0.162460, 0.951057, -0.262866],
        [0.000000, 0.850651, -0.525731],
        [0.160622, 0.693780, -0.702046],
        [-0.160622, 0.693780, -0.702046],
        [-0.587785, 0.688191, -0.425325],
        [-0.693780, 0.702046, -0.160622],
        [-0.259892, 0.433889, -0.862668],
        [-0.425325, 0.587785, -0.688191],
        [-0.688191, 0.425325, -0.587785],
        [-0.702046, 0.160622, -0.693780],
        [-0.862668, 0.259892, -0.433889],
        [-0.850651, 0.525731, 0.000000],
        [-0.961938, 0.000000, -0.273267],
        [-0.951057, 0.262866, -0.162460],
        [-0.951057, 0.262866, 0.162460],
        [-0.961938, 0.000000, 0.273267],
        [0.587785, 0.688191, 0.425325],
        [0.693780, 0.702046, 0.160622],
        [0.259892, 0.433889, 0.862668],
        [0.425325, 0.587785, 0.688191],
        [0.688191, 0.425325, 0.587785],
        [0.702046, 0.160622, 0.693780],
        [0.862668, 0.259892, 0.433889],
        [-0.262866, 0.162460, 0.951057],
        [0.000000, 0.273267, 0.961938],
        [-0.702046, -0.160622, 0.693780],
        [-0.525731, 0.000000, 0.850651],
        [-0.262866, -0.162460, 0.951057],
        [-0.259892, -0.433889, 0.862668],
        [0.000000, -0.273267, 0.961938],
        [-0.951057, -0.262866, 0.162460],
        [-0.862668, -0.259892, 0.433889],
        [-0.862668, -0.259892, -0.433889],
        [-0.951057, -0.262866, -0.162460],
        [-0.850651, -0.525731, 0.000000],
        [-0.693780, -0.702046, -0.160622],
        [-0.693780, -0.702046, 0.160622],
        [-0.525731, 0.000000, -0.850651],
        [-0.702046, -0.160622, -0.693780],
        [0.000000, 0.273267, -0.961938],
        [-0.262866, 0.162460, -0.951057],
        [-0.262866, -0.162460, -0.951057],
        [0.000000, -0.273267, -0.961938],
        [-0.259892, -0.433889, -0.862668],
        [0.425325, 0.587785, -0.688191],
        [0.259892, 0.433889, -0.862668],
        [0.693780, 0.702046, -0.160622],
        [0.587785, 0.688191, -0.425325],
        [0.688191, 0.425325, -0.587785],
        [0.862668, 0.259892, -0.433889],
        [0.702046, 0.160622, -0.693780],
        [0.693780, -0.702046, 0.160622],
        [0.587785, -0.688191, 0.425325],
        [0.433889, -0.862668, 0.259892],
        [0.862668, -0.259892, 0.433889],
        [0.702046, -0.160622, 0.693780],
        [0.688191, -0.425325, 0.587785],
        [0.425325, -0.587785, 0.688191],
        [0.259892, -0.433889, 0.862668],
        [0.160622, -0.693780, 0.702046],
        [0.162460, -0.951057, 0.262866],
        [0.273267, -0.961938, 0.000000],
        [-0.160622, -0.693780, 0.702046],
        [0.000000, -0.850651, 0.525731],
        [-0.162460, -0.951057, 0.262866],
        [-0.433889, -0.862668, 0.259892],
        [-0.273267, -0.961938, 0.000000],
        [0.162460, -0.951057, -0.262866],
        [0.433889, -0.862668, -0.259892],
        [-0.433889, -0.862668, -0.259892],
        [-0.162460, -0.951057, -0.262866],
        [0.000000, -0.850651, -0.525731],
        [-0.160622, -0.693780, -0.702046],
        [0.160622, -0.693780, -0.702046],
        [0.587785, -0.688191, -0.425325],
        [0.693780, -0.702046, -0.160622],
        [0.259892, -0.433889, -0.862668],
        [0.425325, -0.587785, -0.688191],
        [0.688191, -0.425325, -0.587785],
        [0.702046, -0.160622, -0.693780],
        [0.862668, -0.259892, -0.433889],
        [0.850651, -0.525731, 0.000000],
        [0.961938, 0.000000, -0.273267],
        [0.951057, -0.262866, -0.162460],
        [0.951057, -0.262866, 0.162460],
        [0.961938, 0.000000, 0.273267],
        [0.262866, -0.162460, 0.951057],
        [0.525731, 0.000000, 0.850651],
        [0.262866, 0.162460, 0.951057],
        [-0.587785, -0.688191, 0.425325],
        [-0.425325, -0.587785, 0.688191],
        [-0.688191, -0.425325, 0.587785],
        [-0.425325, -0.587785, -0.688191],
        [-0.587785, -0.688191, -0.425325],
        [-0.688191, -0.425325, -0.587785],
        [0.525731, 0.000000, -0.850651],
        [0.262866, -0.162460, -0.951057],
        [0.262866, 0.162460, -0.951057],
        [0.951057, 0.262866, 0.162460],
        [0.951057, 0.262866, -0.162460],
        [0.850651, 0.525731, 0.000000],
    ]

    for i in range(len(points)):
        points[i] = implot3d.Point(points[i][0], points[i][1], points[i][2])

    # Define sphere indices (faces)
    indices = [
        0, 42, 44,
        42, 12, 43,
        44, 43, 14,
        42, 43, 44,
        12, 45, 47,
        45, 11, 46,
        47, 46, 13,
        45, 46, 47,
        14, 48, 50,
        48, 13, 49,
        50, 49, 5,
        48, 49, 50,
        12, 47, 43,
        47, 13, 48,
        43, 48, 14,
        47, 48, 43,
        0, 44, 52,
        44, 14, 51,
        52, 51, 16,
        44, 51, 52,
        14, 50, 54,
        50, 5, 53,
        54, 53, 15,
        50, 53, 54,
        16, 55, 57,
        55, 15, 56,
        57, 56, 1,
        55, 56, 57,
        14, 54, 51,
        54, 15, 55,
        51, 55, 16,
        54, 55, 51,
        0, 52, 59,
        52, 16, 58,
        59, 58, 18,
        52, 58, 59,
        16, 57, 61,
        57, 1, 60,
        61, 60, 17,
        57, 60, 61,
        18, 62, 64,
        62, 17, 63,
        64, 63, 7,
        62, 63, 64,
        16, 61, 58,
        61, 17, 62,
        58, 62, 18,
        61, 62, 58,
        0, 59, 66,
        59, 18, 65,
        66, 65, 20,
        59, 65, 66,
        18, 64, 68,
        64, 7, 67,
        68, 67, 19,
        64, 67, 68,
        20, 69, 71,
        69, 19, 70,
        71, 70, 10,
        69, 70, 71,
        18, 68, 65,
        68, 19, 69,
        65, 69, 20,
        68, 69, 65,
        0, 66, 42,
        66, 20, 72,
        42, 72, 12,
        66, 72, 42,
        20, 71, 74,
        71, 10, 73,
        74, 73, 21,
        71, 73, 74,
        12, 75, 45,
        75, 21, 76,
        45, 76, 11,
        75, 76, 45,
        20, 74, 72,
        74, 21, 75,
        72, 75, 12,
        74, 75, 72,
        1, 56, 78,
        56, 15, 77,
        78, 77, 23,
        56, 77, 78,
        15, 53, 80,
        53, 5, 79,
        80, 79, 22,
        53, 79, 80,
        23, 81, 83,
        81, 22, 82,
        83, 82, 9,
        81, 82, 83,
        15, 80, 77,
        80, 22, 81,
        77, 81, 23,
        80, 81, 77,
        5, 49, 85,
        49, 13, 84,
        85, 84, 25,
        49, 84, 85,
        13, 46, 87,
        46, 11, 86,
        87, 86, 24,
        46, 86, 87,
        25, 88, 90,
        88, 24, 89,
        90, 89, 4,
        88, 89, 90,
        13, 87, 84,
        87, 24, 88,
        84, 88, 25,
        87, 88, 84,
        11, 76, 92,
        76, 21, 91,
        92, 91, 27,
        76, 91, 92,
        21, 73, 94,
        73, 10, 93,
        94, 93, 26,
        73, 93, 94,
        27, 95, 97,
        95, 26, 96,
        97, 96, 2,
        95, 96, 97,
        21, 94, 91,
        94, 26, 95,
        91, 95, 27,
        94, 95, 91,
        10, 70, 99,
        70, 19, 98,
        99, 98, 29,
        70, 98, 99,
        19, 67, 101,
        67, 7, 100,
        101, 100, 28,
        67, 100, 101,
        29, 102, 104,
        102, 28, 103,
        104, 103, 6,
        102, 103, 104,
        19, 101, 98,
        101, 28, 102,
        98, 102, 29,
        101, 102, 98,
        7, 63, 106,
        63, 17, 105,
        106, 105, 31,
        63, 105, 106,
        17, 60, 108,
        60, 1, 107,
        108, 107, 30,
        60, 107, 108,
        31, 109, 111,
        109, 30, 110,
        111, 110, 8,
        109, 110, 111,
        17, 108, 105,
        108, 30, 109,
        105, 109, 31,
        108, 109, 105,
        3, 112, 114,
        112, 32, 113,
        114, 113, 34,
        112, 113, 114,
        32, 115, 117,
        115, 9, 116,
        117, 116, 33,
        115, 116, 117,
        34, 118, 120,
        118, 33, 119,
        120, 119, 4,
        118, 119, 120,
        32, 117, 113,
        117, 33, 118,
        113, 118, 34,
        117, 118, 113,
        3, 114, 122,
        114, 34, 121,
        122, 121, 36,
        114, 121, 122,
        34, 120, 124,
        120, 4, 123,
        124, 123, 35,
        120, 123, 124,
        36, 125, 127,
        125, 35, 126,
        127, 126, 2,
        125, 126, 127,
        34, 124, 121,
        124, 35, 125,
        121, 125, 36,
        124, 125, 121,
        3, 122, 129,
        122, 36, 128,
        129, 128, 38,
        122, 128, 129,
        36, 127, 131,
        127, 2, 130,
        131, 130, 37,
        127, 130, 131,
        38, 132, 134,
        132, 37, 133,
        134, 133, 6,
        132, 133, 134,
        36, 131, 128,
        131, 37, 132,
        128, 132, 38,
        131, 132, 128,
        3, 129, 136,
        129, 38, 135,
        136, 135, 40,
        129, 135, 136,
        38, 134, 138,
        134, 6, 137,
        138, 137, 39,
        134, 137, 138,
        40, 139, 141,
        139, 39, 140,
        141, 140, 8,
        139, 140, 141,
        38, 138, 135,
        138, 39, 139,
        135, 139, 40,
        138, 139, 135,
        3, 136, 112,
        136, 40, 142,
        112, 142, 32,
        136, 142, 112,
        40, 141, 144,
        141, 8, 143,
        144, 143, 41,
        141, 143, 144,
        32, 145, 115,
        145, 41, 146,
        115, 146, 9,
        145, 146, 115,
        40, 144, 142,
        144, 41, 145,
        142, 145, 32,
        144, 145, 142,
        4, 119, 90,
        119, 33, 147,
        90, 147, 25,
        119, 147, 90,
        33, 116, 148,
        116, 9, 82,
        148, 82, 22,
        116, 82, 148,
        25, 149, 85,
        149, 22, 79,
        85, 79, 5,
        149, 79, 85,
        33, 148, 147,
        148, 22, 149,
        147, 149, 25,
        148, 149, 147,
        2, 126, 97,
        126, 35, 150,
        97, 150, 27,
        126, 150, 97,
        35, 123, 151,
        123, 4, 89,
        151, 89, 24,
        123, 89, 151,
        27, 152, 92,
        152, 24, 86,
        92, 86, 11,
        152, 86, 92,
        35, 151, 150,
        151, 24, 152,
        150, 152, 27,
        151, 152, 150,
        6, 133, 104,
        133, 37, 153,
        104, 153, 29,
        133, 153, 104,
        37, 130, 154,
        130, 2, 96,
        154, 96, 26,
        130, 96, 154,
        29, 155, 99,
        155, 26, 93,
        99, 93, 10,
        155, 93, 99,
        37, 154, 153,
        154, 26, 155,
        153, 155, 29,
        154, 155, 153,
        8, 140, 111,
        140, 39, 156,
        111, 156, 31,
        140, 156, 111,
        39, 137, 157,
        137, 6, 103,
        157, 103, 28,
        137, 103, 157,
        31, 158, 106,
        158, 28, 100,
        106, 100, 7,
        158, 100, 106,
        39, 157, 156,
        157, 28, 158,
        156, 158, 31,
        157, 158, 156,
        9, 146, 83,
        146, 41, 159,
        83, 159, 23,
        146, 159, 83,
        41, 143, 160,
        143, 8, 110,
        160, 110, 30,
        143, 110, 160,
        23, 161, 78,
        161, 30, 107,
        78, 107, 1,
        161, 107, 78,
        41, 160, 159,
        160, 30, 161,
        159, 161, 23,
        160, 161, 159
    ]

    return implot3d.Mesh(points=points, idx=indices)


def make_duck_mesh() -> implot3d.Mesh:
    points = [
    [0.263370, 0.782383, -0.488235],
    [0.358677, -0.624396, -0.546179],
    [0.292714, 0.782558, -0.125229],
    [0.349165, -0.579430, -0.151545],
    [0.000000, 0.985995, 0.055503],
    [0.000000, -0.771795, -0.060755],
    [0.000000, 0.884807, -0.562217],
    [0.000000, -0.793724, -0.609042],
    [0.000000, -0.299071, -0.806689],
    [0.416629, -0.234865, -0.718575],
    [0.386268, -0.264259, -0.087117],
    [0.000000, -0.154521, 0.030419],
    [0.170659, -0.255441, 0.007066],
    [0.180454, -0.704124, -0.061920],
    [0.155948, 0.918253, -0.001556],
    [0.155050, -0.228032, 0.751753],
    [0.151757, -0.513087, 0.744284],
    [0.000000, -0.182899, 0.779477],
    [0.000000, -0.578330, 0.764610],
    [0.000000, 0.685169, -0.739686],
    [0.371476, 0.629238, -0.627667],
    [0.331315, 0.641641, -0.175468],
    [0.206943, 0.597766, -0.089039],
    [0.000000, 0.614709, -0.054922],
    [0.000000, -0.737692, 0.299441],
    [0.283809, -0.102660, 0.299441],
    [0.000000, 0.014558, 0.299441],
    [0.000000, -0.736425, 0.474106],
    [0.278490, -0.087547, 0.474106],
    [0.000000, 0.025780, 0.474106],
    [0.164839, 0.864781, -0.528560],
    [0.230536, 0.696343, -0.704629],
    [0.220279, -0.294500, -0.788924],
    [0.216836, -0.741049, -0.579700],
    [0.238591, -0.660227, 0.299441],
    [0.244763, -0.660211, 0.474106],
    [0.000000, -0.363444, 0.812572],
    [0.163341, -0.354552, 0.773703],
    [0.374463, -0.372350, 0.474106],
    [0.379897, -0.380938, 0.299441],
    [0.289253, -0.469584, -0.048850],
    [0.399568, -0.463659, -0.141744],
    [0.416824, -0.506064, -0.619739],
    [0.226948, -0.580280, -0.719311],
    [0.000000, -0.596101, -0.755098],
    [0.199617, 0.050031, -0.023613],
    [0.000000, 0.056331, -0.812572],
    [0.221169, 0.056088, -0.800430],
    [0.414907, 0.057214, -0.741319],
    [0.383278, 0.079881, -0.106452],
    [0.000000, 0.066068, 0.011448],
    [0.485071, -0.225034, -0.615697],
    [0.474322, -0.235931, -0.130497],
    [0.451926, -0.378909, -0.182230],
    [0.464485, -0.423127, -0.533935],
    [0.376105, 0.621725, -0.201967],
    [0.458732, 0.078611, -0.144688],
    [0.414064, 0.587520, -0.543056],
    [0.482586, 0.065612, -0.653211],
    [0.000000, -0.672915, 0.096026],
    [0.146952, -0.607627, 0.096026],
    [0.261607, -0.401487, 0.096026],
    [0.193018, -0.190607, 0.096026],
    [0.000000, -0.095407, 0.096026],
    [0.000000, -0.044418, 0.665235],
    [0.241792, -0.132120, 0.640095],
    [0.312765, -0.375473, 0.640095],
    [0.214627, -0.620202, 0.640095],
    [0.000000, -0.694664, 0.658020],
    [0.000000, -0.682358, 0.030419],
    [0.138512, -0.610831, 0.030419],
    [0.234026, -0.438399, 0.030419],
    [0.000000, 0.914951, 0.077360],
    [0.160964, 0.841809, 0.024144],
    [0.193354, 0.741696, -0.037907],
    [0.000000, 0.800313, 0.001882],
    [0.000000, 0.405613, -0.811128],
    [0.229117, 0.399656, -0.791482],
    [0.409787, 0.383452, -0.704163],
    [0.458770, 0.376363, -0.605461],
    [0.385168, 0.580561, -0.185704],
    [0.344420, 0.600331, -0.166386],
    [0.437609, 0.339612, -0.230592],
    [0.386172, 0.365055, -0.180691],
    [0.203357, 0.342793, -0.082669],
    [0.000000, 0.367574, -0.043515],
    [0.368402, 0.509624, -0.189577],
    [0.408311, 0.494489, -0.224777],
    [0.317982, -0.276765, -0.036125],
    [0.000000, -0.705078, 0.171934],
    [0.194647, -0.634647, 0.171934],
    [0.332827, -0.390756, 0.171934],
    [0.252044, -0.153800, 0.171934],
    [0.000000, -0.052325, 0.171934],
    [0.000000, -0.845971, -0.319676],
    [0.204859, -0.774310, -0.326206],
    [0.382866, -0.635409, -0.351147],
    [0.437191, -0.532057, -0.362802],
    [0.277419, 0.820517, -0.362410],
    [0.165994, 0.946464, -0.306175],
    [0.366520, 0.694046, -0.383403],
    [0.000000, 1.000000, -0.305615],
    [0.554754, 0.081200, -0.400087],
    [0.548457, -0.240710, -0.371820],
    [0.496187, -0.443697, -0.357878],
    [0.410754, 0.655281, -0.382353],
    [0.501407, 0.340701, -0.406753],
    [-0.263370, 0.782383, -0.488235],
    [-0.358677, -0.624396, -0.546179],
    [-0.292714, 0.782558, -0.125229],
    [-0.349165, -0.579430, -0.151545],
    [-0.416629, -0.234865, -0.718575],
    [-0.386268, -0.264259, -0.087117],
    [-0.170659, -0.255441, 0.007066],
    [-0.180454, -0.704124, -0.061920],
    [-0.155948, 0.918253, -0.001556],
    [-0.155050, -0.228032, 0.751753],
    [-0.151757, -0.513087, 0.744284],
    [-0.371476, 0.629238, -0.627667],
    [-0.331315, 0.641641, -0.175468],
    [-0.206943, 0.597766, -0.089039],
    [-0.283809, -0.102660, 0.299441],
    [-0.278490, -0.087547, 0.474106],
    [-0.164839, 0.864781, -0.528560],
    [-0.230536, 0.696343, -0.704629],
    [-0.220279, -0.294500, -0.788924],
    [-0.216836, -0.741049, -0.579700],
    [-0.238591, -0.660227, 0.299441],
    [-0.244763, -0.660211, 0.474106],
    [-0.163341, -0.354552, 0.773703],
    [-0.374463, -0.372350, 0.474106],
    [-0.379897, -0.380938, 0.299441],
    [-0.289253, -0.469584, -0.048850],
    [-0.399568, -0.463659, -0.141744],
    [-0.416824, -0.506064, -0.619739],
    [-0.226948, -0.580280, -0.719311],
    [-0.199617, 0.050031, -0.023613],
    [-0.221169, 0.056088, -0.800430],
    [-0.414907, 0.057214, -0.741319],
    [-0.383278, 0.079881, -0.106452],
    [-0.485071, -0.225034, -0.615697],
    [-0.474322, -0.235931, -0.130497],
    [-0.451926, -0.378909, -0.182230],
    [-0.464485, -0.423127, -0.533935],
    [-0.376105, 0.621725, -0.201967],
    [-0.458732, 0.078611, -0.144688],
    [-0.414064, 0.587520, -0.543056],
    [-0.482586, 0.065612, -0.653211],
    [-0.146952, -0.607627, 0.096026],
    [-0.261606, -0.401487, 0.096026],
    [-0.193018, -0.190607, 0.096026],
    [-0.241792, -0.132120, 0.640095],
    [-0.312765, -0.375473, 0.640095],
    [-0.214627, -0.620202, 0.640095],
    [-0.138512, -0.610831, 0.030419],
    [-0.234026, -0.438399, 0.030419],
    [-0.160964, 0.841809, 0.024144],
    [-0.193354, 0.741696, -0.037907],
    [-0.229117, 0.399656, -0.791482],
    [-0.409787, 0.383452, -0.704163],
    [-0.458770, 0.376363, -0.605461],
    [-0.385168, 0.580561, -0.185704],
    [-0.344420, 0.600331, -0.166386],
    [-0.437609, 0.339612, -0.230592],
    [-0.386172, 0.365055, -0.180691],
    [-0.203357, 0.342793, -0.082669],
    [-0.368402, 0.509624, -0.189577],
    [-0.408311, 0.494489, -0.224777],
    [-0.317982, -0.276765, -0.036125],
    [-0.194647, -0.634647, 0.171934],
    [-0.332827, -0.390756, 0.171934],
    [-0.252044, -0.153800, 0.171934],
    [-0.204859, -0.774310, -0.326206],
    [-0.382866, -0.635409, -0.351147],
    [-0.437191, -0.532057, -0.362802],
    [-0.277419, 0.820517, -0.362410],
    [-0.165994, 0.946464, -0.306175],
    [-0.366520, 0.694046, -0.383403],
    [-0.554754, 0.081200, -0.400087],
    [-0.548457, -0.240710, -0.371820],
    [-0.496187, -0.443697, -0.357878],
    [-0.410754, 0.655281, -0.382353],
    [-0.501407, 0.340701, -0.406753],
    [-0.147251, -0.668523, 0.330326],
    [-0.047291, -0.930817, 0.472716],
    [-0.224222, -0.665336, 0.415767],
    [-0.075450, -0.918607, 0.533818],
    [-0.075797, -0.674119, 0.541030],
    [-0.096675, -0.818748, 0.395991],
    [-0.159031, -0.798414, 0.462927],
    [-0.223648, -0.656683, 0.331961],
    [-0.072544, -0.935279, 0.500884],
    [0.000000, -0.961081, 0.579077],
    [0.000000, -0.726138, 0.328549],
    [0.000000, -0.969221, 0.509585],
    [-0.176269, -0.669386, 0.471817],
    [-0.051675, -0.862571, 0.538304],
    [0.000000, -0.680106, 0.554423],
    [0.000000, -0.974061, 0.546160],
    [-0.152228, -0.819158, 0.418117],
    [0.000000, -0.867770, 0.561794],
    [0.000000, -0.827887, 0.404080],
    [-0.123466, -0.788030, 0.489190],
    [0.147251, -0.668523, 0.330326],
    [0.047291, -0.930817, 0.472716],
    [0.224222, -0.665336, 0.415767],
    [0.075450, -0.918607, 0.533818],
    [0.075797, -0.674119, 0.541030],
    [0.096675, -0.818748, 0.395991],
    [0.159031, -0.798414, 0.462927],
    [0.223648, -0.656683, 0.331961],
    [0.072544, -0.935279, 0.500884],
    [0.176269, -0.669386, 0.471817],
    [0.051675, -0.862571, 0.538304],
    [0.152228, -0.819158, 0.418117],
    [0.123466, -0.788030, 0.489190],
    [0.000000, -0.994773, 0.345730],
    [0.000000, -0.647443, 0.199203],
    [0.000000, -0.986165, 0.291566],
    [0.000000, -0.703971, 0.341994],
    [0.000000, -1.000000, 0.315210],
    [0.000000, -0.787658, 0.226787],
    [0.000000, -0.961085, 0.352303],
    [-0.133409, -0.653443, 0.222877],
    [-0.060090, -0.929363, 0.267589],
    [-0.224222, -0.658853, 0.342353],
    [-0.094843, -0.932646, 0.343060],
    [-0.151330, -0.675024, 0.346911],
    [0.000000, -0.932532, 0.323403],
    [-0.120579, -0.791706, 0.239478],
    [-0.187682, -0.791724, 0.341367],
    [-0.213355, -0.651997, 0.277443],
    [-0.092940, -0.939719, 0.301090],
    [-0.176269, -0.666860, 0.352303],
    [-0.130777, -0.793601, 0.328226],
    [-0.075297, -0.913539, 0.352303],
    [-0.182747, -0.797038, 0.284545],
    [-0.150873, -0.786911, 0.352303],
    [-0.055104, -0.898766, 0.325273],
    [0.133409, -0.653443, 0.222877],
    [0.060090, -0.929363, 0.267589],
    [0.224222, -0.658853, 0.342353],
    [0.094843, -0.932646, 0.343060],
    [0.151330, -0.675024, 0.346911],
    [0.120579, -0.791706, 0.239478],
    [0.187682, -0.791724, 0.341367],
    [0.213355, -0.651997, 0.277443],
    [0.092940, -0.939719, 0.301090],
    [0.176269, -0.666860, 0.352303],
    [0.130777, -0.793601, 0.328226],
    [0.075297, -0.913539, 0.352303],
    [0.182747, -0.797038, 0.284545],
    [0.150873, -0.786911, 0.352303],
    [0.055104, -0.898766, 0.325273]
    ]
    for i in range(len(points)):
        points[i] = implot3d.Point(points[i][0], points[i][1], points[i][2])

    idx = [2, 73, 74, 2, 74, 21, 30, 0, 20, 30, 20, 31, 43, 42, 1, 43, 1, 33, 41, 40, 13, 41, 13, 3, 40, 71, 70, 40, 70, 13, 48, 9, 32, 48, 32, 47, 45, 88, 10, 45, 10, 49, 39, 38, 35, 39, 35, 34, 66, 37, 16, 66, 16, 67, 6, 30, 31, 6, 31, 19, 46, 47, 32, 46, 32, 8, 44, 43, 33, 44, 33, 7, 70, 69, 5, 70, 5, 13, 35, 27, 24, 35, 24, 34, 16, 18, 68, 16, 68, 67, 36, 18, 16, 36, 16, 37, 64, 17, 15, 64, 15, 65, 26, 29, 28, 26, 28, 25, 50, 11, 12, 50, 12, 45, 72, 75, 74, 72, 74, 73, 17, 36, 37, 17, 37, 15, 65, 15, 37, 65, 37, 66, 25, 28, 38, 25, 38, 39, 40, 88, 12, 40, 12, 71, 10, 88, 40, 10, 40, 41, 32, 9, 42, 32, 42, 43, 8, 32, 43, 8, 43, 44, 85, 84, 22, 85, 22, 23, 20, 78, 77, 20, 77, 31, 19, 31, 77, 19, 77, 76, 48, 58, 51, 48, 51, 9, 10, 52, 56, 10, 56, 49, 41, 53, 52, 41, 52, 10, 9, 51, 54, 9, 54, 42, 81, 80, 55, 81, 55, 21, 20, 57, 79, 20, 79, 78, 90, 89, 59, 90, 59, 60, 61, 91, 90, 61, 90, 60, 62, 92, 91, 62, 91, 61, 63, 93, 92, 63, 92, 62, 29, 64, 65, 29, 65, 28, 28, 65, 66, 28, 66, 38, 38, 66, 67, 38, 67, 35, 68, 27, 35, 68, 35, 67, 60, 59, 69, 60, 69, 70, 71, 61, 60, 71, 60, 70, 12, 62, 61, 12, 61, 71, 11, 63, 62, 11, 62, 12, 14, 4, 72, 14, 72, 73, 2, 14, 73, 22, 81, 21, 22, 21, 74, 75, 23, 22, 75, 22, 74, 83, 82, 87, 83, 87, 86, 76, 77, 47, 76, 47, 46, 78, 48, 47, 78, 47, 77, 79, 58, 48, 79, 48, 78, 49, 56, 82, 49, 82, 83, 84, 45, 49, 84, 49, 83, 85, 50, 45, 85, 45, 84, 87, 80, 81, 87, 81, 86, 22, 84, 83, 22, 83, 86, 45, 12, 88, 34, 24, 89, 34, 89, 90, 91, 39, 34, 91, 34, 90, 92, 25, 39, 92, 39, 91, 93, 26, 25, 93, 25, 92, 0, 98, 100, 0, 100, 20, 1, 96, 95, 1, 95, 33, 30, 99, 98, 30, 98, 0, 97, 96, 1, 97, 1, 42, 96, 3, 13, 96, 13, 95, 41, 3, 96, 41, 96, 97, 98, 2, 21, 98, 21, 100, 99, 14, 2, 99, 2, 98, 102, 103, 51, 102, 51, 58, 56, 52, 103, 56, 103, 102, 101, 4, 14, 101, 14, 99, 6, 101, 99, 6, 99, 30, 95, 94, 7, 95, 7, 33, 13, 5, 94, 13, 94, 95, 52, 53, 104, 52, 104, 103, 103, 104, 54, 103, 54, 51, 105, 106, 79, 105, 79, 57, 97, 104, 53, 97, 53, 41, 42, 54, 104, 42, 104, 97, 21, 55, 105, 21, 105, 100, 100, 105, 57, 100, 57, 20, 106, 105, 87, 106, 87, 82, 106, 102, 58, 106, 58, 79, 82, 56, 102, 82, 102, 106, 22, 86, 81, 80, 87, 105, 80, 105, 55, 109, 119, 157, 109, 157, 156, 123, 124, 118, 123, 118, 107, 135, 126, 108, 135, 108, 134, 133, 110, 114, 133, 114, 132, 132, 114, 154, 132, 154, 155, 138, 137, 125, 138, 125, 111, 136, 139, 112, 136, 112, 168, 131, 127, 128, 131, 128, 130, 152, 153, 117, 152, 117, 129, 6, 19, 124, 6, 124, 123, 46, 8, 125, 46, 125, 137, 44, 7, 126, 44, 126, 135, 154, 114, 5, 154, 5, 69, 128, 127, 24, 128, 24, 27, 117, 153, 68, 117, 68, 18, 36, 129, 117, 36, 117, 18, 64, 151, 116, 64, 116, 17, 26, 121, 122, 26, 122, 29, 50, 136, 113, 50, 113, 11, 72, 156, 157, 72, 157, 75, 17, 116, 129, 17, 129, 36, 151, 152, 129, 151, 129, 116, 121, 131, 130, 121, 130, 122, 132, 155, 113, 132, 113, 168, 112, 133, 132, 112, 132, 168, 125, 135, 134, 125, 134, 111, 8, 44, 135, 8, 135, 125, 85, 23, 120, 85, 120, 165, 118, 124, 158, 118, 158, 159, 19, 76, 158, 19, 158, 124, 138, 111, 140, 138, 140, 147, 112, 139, 145, 112, 145, 141, 133, 112, 141, 133, 141, 142, 111, 134, 143, 111, 143, 140, 162, 119, 144, 162, 144, 161, 118, 159, 160, 118, 160, 146, 169, 148, 59, 169, 59, 89, 149, 148, 169, 149, 169, 170, 150, 149, 170, 150, 170, 171, 63, 150, 171, 63, 171, 93, 29, 122, 151, 29, 151, 64, 122, 130, 152, 122, 152, 151, 130, 128, 153, 130, 153, 152, 68, 153, 128, 68, 128, 27, 148, 154, 69, 148, 69, 59, 155, 154, 148, 155, 148, 149, 113, 155, 149, 113, 149, 150, 11, 113, 150, 11, 150, 63, 115, 156, 72, 115, 72, 4, 109, 156, 115, 120, 157, 119, 120, 119, 162, 75, 157, 120, 75, 120, 23, 164, 166, 167, 164, 167, 163, 76, 46, 137, 76, 137, 158, 159, 158, 137, 159, 137, 138, 160, 159, 138, 160, 138, 147, 139, 164, 163, 139, 163, 145, 165, 164, 139, 165, 139, 136, 85, 165, 136, 85, 136, 50, 167, 166, 162, 167, 162, 161, 120, 166, 164, 120, 164, 165, 136, 168, 113, 127, 169, 89, 127, 89, 24, 170, 169, 127, 170, 127, 131, 171, 170, 131, 171, 131, 121, 93, 171, 121, 93, 121, 26, 107, 118, 177, 107, 177, 175, 108, 126, 172, 108, 172, 173, 123, 107, 175, 123, 175, 176, 174, 134, 108, 174, 108, 173, 173, 172, 114, 173, 114, 110, 133, 174, 173, 133, 173, 110, 175, 177, 119, 175, 119, 109, 176, 175, 109, 176, 109, 115, 178, 147, 140, 178, 140, 179, 145, 178, 179, 145, 179, 141, 101, 176, 115, 101, 115, 4, 6, 123, 176, 6, 176, 101, 172, 126, 7, 172, 7, 94, 114, 172, 94, 114, 94, 5, 141, 179, 180, 141, 180, 142, 179, 140, 143, 179, 143, 180, 181, 146, 160, 181, 160, 182, 174, 133, 142, 174, 142, 180, 134, 174, 180, 134, 180, 143, 119, 177, 181, 119, 181, 144, 177, 118, 146, 177, 146, 181, 182, 163, 167, 182, 167, 181, 182, 160, 147, 182, 147, 178, 163, 182, 178, 163, 178, 145, 120, 162, 166, 161, 144, 181, 161, 181, 167, 189, 185, 190, 189, 190, 199, 190, 183, 188, 190, 188, 199, 197, 187, 196, 197, 196, 200, 188, 183, 193, 188, 193, 201, 192, 186, 191, 192, 191, 198, 191, 184, 194, 191, 194, 198, 188, 184, 191, 188, 191, 199, 191, 186, 189, 191, 189, 199, 194, 184, 188, 194, 188, 201, 196, 187, 195, 196, 195, 202, 195, 185, 189, 195, 189, 202, 189, 186, 196, 189, 196, 202, 196, 186, 192, 196, 192, 200, 209, 214, 210, 209, 210, 205, 210, 214, 208, 210, 208, 203, 197, 200, 213, 197, 213, 207, 208, 201, 193, 208, 193, 203, 192, 198, 211, 192, 211, 206, 211, 198, 194, 211, 194, 204, 208, 214, 211, 208, 211, 204, 211, 214, 209, 211, 209, 206, 194, 201, 208, 194, 208, 204, 213, 215, 212, 213, 212, 207, 212, 215, 209, 212, 209, 205, 209, 215, 213, 209, 213, 206, 213, 200, 192, 213, 192, 206, 230, 225, 231, 230, 231, 236, 231, 223, 229, 231, 229, 236, 219, 227, 234, 229, 223, 217, 229, 217, 221, 216, 226, 232, 216, 232, 220, 232, 224, 218, 232, 218, 220, 229, 224, 232, 229, 232, 236, 232, 226, 230, 232, 230, 236, 234, 238, 228, 234, 228, 219, 218, 224, 229, 218, 229, 221, 234, 227, 233, 234, 233, 237, 233, 225, 230, 233, 230, 237, 230, 226, 235, 230, 235, 237, 235, 238, 234, 235, 234, 237, 228, 238, 235, 228, 235, 222, 235, 226, 216, 235, 216, 222, 245, 251, 246, 245, 246, 241, 246, 251, 244, 246, 244, 239, 219, 249, 243, 244, 221, 217, 244, 217, 239, 216, 220, 247, 216, 247, 242, 247, 220, 218, 247, 218, 240, 244, 251, 247, 244, 247, 240, 247, 251, 245, 247, 245, 242, 249, 219, 228, 249, 228, 253, 218, 221, 244, 218, 244, 240, 249, 252, 248, 249, 248, 243, 248, 252, 245, 248, 245, 241, 245, 252, 250, 245, 250, 242, 250, 252, 249, 250, 249, 253, 228, 222, 250, 228, 250, 253, 250, 222, 216, 250, 216, 242]

    mesh = implot3d.Mesh(points, idx)

    return mesh
