local stacks = tonumber(GlobalsGetValue( "regenerating_shield_stacks", 0 ))

if stacks == 0 and ModSettingGet("regenerating_shield.make_perk") then return end

if not ModSettingGet("regenerating_shield.make_perk") then
	stacks = 1
end

local entity_id = GetUpdatedEntityID()
local comp = EntityGetFirstComponent( entity_id, "VariableStorageComponent", "hp_shield_value" )
local frames = ComponentGetValue2(comp, "value_int")
local shield_value = ComponentGetValue2(comp, "value_float")

local visual_shield_value = math.floor(shield_value*25)

local damage_comp = EntityGetFirstComponentIncludingDisabled(entity_id,"DamageModelComponent")
local maxhp = ComponentGetValue2(damage_comp,"max_hp")

local max_shield_value

if ModSettingGet("regenerating_shield.percent") then
	max_shield_value = maxhp*(tonumber(ModSettingGet("regenerating_shield.max_shield"))+(stacks-1)*tonumber(ModSettingGet("regenerating_shield.max_shield_stack")))*0.01
else
	max_shield_value = (tonumber(ModSettingGet("regenerating_shield.max_shield")) + (stacks-1)*tonumber(ModSettingGet("regenerating_shield.max_shield_stack")))/25
end

local framecomp = EntityGetFirstComponent(entity_id, "VariableStorageComponent", "frames_last_hit")
ComponentSetValue2(framecomp, "value_int", ComponentGetValue2(framecomp, "value_int") + 1)

--GamePrint(tostring(frames).. "," .. tostring(shield_value))

--yoinked from xs#7284
function get_hp_bar_length()
  if EntityGetIsAlive(entity_id) then
    if damage_comp ~= nil then
      if maxhp<=10/25 then
        return 80
      else
        local length = 80 + math.log(maxhp/4,4/3)*10
        return math.min(160,length) 
      end
    end
  end
end

--gui
local gui = GuiCreate()
GuiStartFrame(gui)
local w,h = GuiGetScreenDimensions(gui)

local hp_bar_length = get_hp_bar_length()

local number = tostring(visual_shield_value)
for i=1,#number,1 do
	GuiImage(gui, 26581+i, math.floor(600-1-hp_bar_length/2 )-16-#number*4+i*4, 20,"mods/regenerating_shield/files/gfx/numbers/number_" .. string.sub(number,i,i) .. ".png",1,1 )
end
--GuiText(gui, math.floor(600-1-hp_bar_length/2 )-20, 18, tostring(visual_shield_value))

GuiImage(gui, 2378569, math.floor(600-1-hp_bar_length/2 )-11, 19, "mods/regenerating_shield/files/gfx/shield_icon.png", 1, 1)

--yoinked from xs#7284
if shield_value ~= 0 then

	GuiZSetForNextWidget( gui, -10 )
	
	if shield_value > maxhp then
		local width_you_want_cover = math.floor((hp_bar_length/2))
		--GuiImage(gui,image_id,math.floor(600-1-hp_bar_length/2 ),21,"mods/pirates_curios/files/gfx/hud/shield.png",1,width_you_want_cover,4)
		GuiImageNinePiece( gui, 2377456, math.floor(599-hp_bar_length/2 ),21,width_you_want_cover, 4.25, 1, "mods/regenerating_shield/files/gfx/shield_border_overcharged.png", "mods/regenerating_shield/files/gfx/shield_border_overcharged.png" )
	else
		local width_you_want_cover = math.floor((hp_bar_length/2)*(shield_value/maxhp))
		--GuiImage(gui,image_id,math.floor(600-1-hp_bar_length/2 ),21,"mods/pirates_curios/files/gfx/hud/shield.png",1,width_you_want_cover,4)
		GuiImageNinePiece( gui, 2377456, math.floor(599-hp_bar_length/2 ),21,width_you_want_cover, 4.25, 1, "mods/regenerating_shield/files/gfx/shield_border.png", "mods/regenerating_shield/files/gfx/shield_border.png" )
	end
	
end

local required_frames = tonumber(ModSettingGet("regenerating_shield.rebuild_cooldown")*60)
if frames < required_frames then
	ComponentSetValue2(comp, "value_int", frames+1)
	return
end


if shield_value <= max_shield_value then
	local regen_rate
	if ModSettingGet("regenerating_shield.rebuild_percent") then
		regen_rate = max_shield_value*(tonumber(ModSettingGet("regenerating_shield.rebuild_rate"))*0.01)/60
	else
		regen_rate = tonumber(ModSettingGet("regenerating_shield.rebuild_rate"))/25/60
	end
	
	if shield_value+regen_rate > max_shield_value then
		ComponentSetValue2(comp, "value_float", max_shield_value)
	else
		ComponentSetValue2(comp, "value_float", shield_value+regen_rate)
	end
end
